% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{SumLargest-class}
\alias{SumLargest-class}
\alias{.SumLargest}
\alias{SumLargest}
\alias{to_numeric,SumLargest-method}
\alias{validate_args,SumLargest-method}
\alias{dim_from_args,SumLargest-method}
\alias{sign_from_args,SumLargest-method}
\alias{is_atom_convex,SumLargest-method}
\alias{is_atom_concave,SumLargest-method}
\alias{is_incr,SumLargest-method}
\alias{is_decr,SumLargest-method}
\alias{get_data,SumLargest-method}
\alias{.grad,SumLargest-method}
\title{The SumLargest class.}
\usage{
SumLargest(x, k)

\S4method{to_numeric}{SumLargest}(object, values)

\S4method{validate_args}{SumLargest}(object)

\S4method{dim_from_args}{SumLargest}(object)

\S4method{sign_from_args}{SumLargest}(object)

\S4method{is_atom_convex}{SumLargest}(object)

\S4method{is_atom_concave}{SumLargest}(object)

\S4method{is_incr}{SumLargest}(object, idx)

\S4method{is_decr}{SumLargest}(object, idx)

\S4method{get_data}{SumLargest}(object)

\S4method{.grad}{SumLargest}(object, values)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric matrix.}

\item{k}{The number of largest values to sum over.}

\item{object}{A \linkS4class{SumLargest} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
The sum of the largest k values of a matrix.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The sum of the \code{k} largest entries of the vector or matrix.

\item \code{validate_args}: Check that \code{k} is a positive integer.

\item \code{dim_from_args}: The atom is a scalar.

\item \code{sign_from_args}: The sign of the atom.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is weakly increasing in every argument.

\item \code{is_decr}: The atom is not weakly decreasing in any argument.

\item \code{get_data}: A list containing \code{k}.

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric matrix.}

\item{\code{k}}{The number of largest values to sum over.}
}}

