% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{scalene}
\alias{scalene}
\title{Scalene Function}
\usage{
scalene(x, alpha, beta)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{alpha}{The weight on the positive portion of \code{x}.}

\item{beta}{The weight on othe negative portion of \code{x}.}
}
\value{
An \linkS4class{Expression} representing the scalene function evaluated at the input.
}
\description{
The elementwise weighted sum of the positive and negative portions of an expression, \eqn{\alpha\max(x_i,0) - \beta\min(x_i,0)}.
This is equivalent to \code{alpha*pos(x) + beta*neg(x)}.
}
\examples{
\dontrun{
A <- Variable(2,2)
val <- cbind(c(-5,2), c(-3,1))
prob <- Problem(Minimize(scalene(A,2,3)[1,1]), list(A == val))
result <- solve(prob)
result$value
result$getValue(scalene(A, 0.7, 0.3))
}
}
