% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{compute_info}
\alias{compute_info}
\title{Computing Information Matrices}
\usage{
compute_info(P0_mat, mat_del = NULL, mat_sigma2 = NULL, mat_tau = NULL)
}
\arguments{
\item{P0_mat}{(matrix, n*n) Scale projection matrix under REML.}

\item{mat_del}{(matrix, n*n) Derivative of the scale covariance matrix of Y
with respect to delta.}

\item{mat_sigma2}{(matrix, n*n) Derivative of the scale covariance matrix of
Y with respect to sigma2.}

\item{mat_tau}{(matrix, n*n) Derivative of the scale covariance matrix of Y
with respect to tau.}
}
\value{
\item{I0}{(matrix, n*n) The computed information value.}
}
\description{
Compute information matrices based on block matrices.
}
\details{
This function gives the information value of the interaction strength.
}
\references{
Arnab Maity and Xihong Lin. Powerful tests for detecting a gene
effect in the presence of possible gene-gene interactions using garrote
kernel machines. December 2011.
}
\author{
Wenying Deng
}
\keyword{internal}
