% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikcubpq.R
\name{loglikcubpq}
\alias{loglikcubpq}
\title{Log-likelihood function of a CUB model with covariates for both feeling and uncertainty}
\usage{
loglikcubpq(m, ordinal, Y, W, bet, gama)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{bet}{Vector of parameters for the uncertainty component, with length equal to 
NCOL(Y)+1 to account for an intercept term (first entry of bbet)}

\item{gama}{Vector of parameters for the feeling component, whose length equals
NCOL(W) + 1 to account for an intercept term (first entry of gama)}
}
\description{
Compute the log-likelihood function of a CUB model fitting ordinal data
 with covariates for explaining both the feeling and the uncertainty components.
}
\keyword{internal}
