% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEI_Weights.R
\name{BEI_Weights}
\alias{BEI_Weights}
\title{Computing the weights for SFSs using the Best Index PDFs.}
\usage{
BEI_Weights(index_weight, pdf_weight, time_dim_name = "time")
}
\arguments{
\item{index_weight}{Index (e.g. NAO index) array, from a dataset of SFSs
for a period of years, with at least dimensions 'member'. 
Additional dimensions, for instance, a temporal dimension as 'time', 
must have the same lenght in both parameters, 'index_weight' and 
'pdf_weight'.}

\item{pdf_weight}{Statistics array to define a Gaussian PDF with at least 
dimensions 'statistic'. The firt statistic is the parameter 'mean' of the PDF 
and the second statistic is the parameter 'standard deviation' of the PDF.}

\item{time_dim_name}{A character string indicating the name of the temporal 
dimension, by default 'time'.}
}
\value{
BEI_Weights() returns a normalized weights array with the same 
dimensions that index_weight.
}
\description{
This function implements the computation to obtain the
normalized weights for each member of each Seasonal Forecast Systems (SFS) 
or dataset using the Probability Density Functions (PDFs) indicated by the 
parameter 'pdf_weight' (for instance the Best Index estimation obtained 
using the 'PDFBest' function). The weight of each member is proportional to
the probability of its index calculated with the PDF "pdf_weight".
}
\examples{
# Example for the BEI_Weights function
index_weight <- 1 : (10 * 3 * 5 * 1)
dim(index_weight) <- c(sdate = 10, dataset = 3, member = 5, season = 1)
pdf_weight <- 1 : (10 * 3 * 2 * 1)
dim(pdf_weight) <- c(sdate = 10, dataset = 3, statistic = 2, season = 1)
res <- BEI_Weights(index_weight, pdf_weight)
dim(res)
# sdate   dataset    member season
#    10         3         5      1

}
\references{
Regionally improved seasonal forecast of precipitation through 
Best estimation of winter NAO, Sanchez-Garcia, E. et al.,
Adv. Sci. Res., 16, 165174, 2019, \doi{10.5194/asr-16-165-2019}
}
\author{
Eroteida Sanchez-Garcia - AEMET, \email{esanchezg@aemet.es}
}
