% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SaveExp.R
\name{SaveExp}
\alias{SaveExp}
\title{Save a multidimensional array with metadata to data in NetCDF format}
\usage{
SaveExp(
  data,
  destination = "./",
  Dates = NULL,
  coords = NULL,
  varname = NULL,
  metadata = NULL,
  Datasets = NULL,
  startdates = NULL,
  dat_dim = "dataset",
  sdate_dim = "sdate",
  ftime_dim = "time",
  var_dim = "var",
  memb_dim = "member",
  single_file = FALSE,
  extra_string = NULL
)
}
\arguments{
\item{data}{A multi-dimensional array with named dimensions.}

\item{destination}{A character string indicating the path where to store the 
NetCDF files.}

\item{Dates}{A named array of dates with the corresponding sdate and forecast 
time dimension.}

\item{coords}{A named list with elements of the coordinates corresponding to 
the dimensions of the data parameter. The names and length of each element 
must correspond to the names of the dimensions. If any coordinate is not 
provided, it is set as an index vector with the values from 1 to the length 
of the corresponding dimension.}

\item{varname}{A character string indicating the name of the variable to be 
saved.}

\item{metadata}{A named list where each element is a variable containing the
corresponding information. The information must be contained in a list of 
lists for each variable.}

\item{Datasets}{A vector of character string indicating the names of the 
datasets.}

\item{startdates}{A vector of dates that will be used for the filenames 
when saving the data in multiple files. It must be a vector of the same 
length as the start date dimension of data. It must be a vector of class 
\code{Dates}, \code{'POSIXct'} or character with lenghts between 1 and 10. 
If it is NULL, the first Date of each time step will be used as the name of 
the files. It is NULL by default.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
By default, it is set to 'dataset'. It can be NULL if there is no dataset  
dimension.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. By default, it is set to 'sdate'. It can be NULL if there is no
start date dimension.}

\item{ftime_dim}{A character string indicating the name of the forecast time
dimension. By default, it is set to 'time'. It can be NULL if there is no 
forecast time dimension.}

\item{var_dim}{A character string indicating the name of variable dimension. 
By default, it is set to 'var'. It can be NULL if there is no variable  
dimension.}

\item{memb_dim}{A character string indicating the name of the member dimension.
By default, it is set to 'member'. It can be NULL if there is no member 
dimension.}

\item{single_file}{A logical value indicating if all object is saved in a 
unique file (TRUE) or in separated directories (FALSE). When it is FALSE, 
the array is separated for Datasets, variable and start date. It is FALSE  
by default.}

\item{extra_string}{A character string to be include as part of the file name, 
for instance, to identify member or realization. It would be added to the 
file name between underscore characters.}
}
\value{
Multiple or single NetCDF files containing the data array.\cr
\item{\code{single_file = TRUE}}{
 All data is saved in a single file located in the specified destination  
 path with the following name: 
 <variable_name>_<extra_string>_<first_sdate>_<last_sdate>.nc. Multiple 
 variables are saved separately in the same file. The forecast time units 
 is extracted from the frequency of the time steps (hours, days, months). 
 The first value of forecast time is 1. If no frequency is found, the units 
 will be 'hours since' each start date and the time steps are assumed to be 
 equally spaced.
}
\item{\code{single_file = FALSE}}{
 The data array is subset and stored into multiple files. Each file 
 contains the data subset for each start date, variable and dataset. Files 
 with different variables and Datasets are stored in separated directories 
 within the following directory tree: destination/Dataset/variable/. 
 The name of each file will be: 
 <variable_name>_<extra_string>_<sdate>.nc.
}
}
\description{
This function allows to save a data array with metadata into a 
NetCDF file, allowing to reload the saved data using \code{Start} function 
from StartR package. If the original 's2dv_cube' object has been created from 
\code{CST_Load()}, then it can be reloaded with \code{Load()}.
}
\examples{
\dontrun{
data <- lonlat_temp$exp$data
lon <- lonlat_temp$exp$coords$lon
lat <- lonlat_temp$exp$coords$lat
coords <- list(lon = lon, lat = lat)
Datasets <- lonlat_temp$exp$attrs$Datasets
varname <- 'tas'
Dates <- lonlat_temp$exp$attrs$Dates
destination = './'
metadata <- lonlat_temp$exp$attrs$Variable$metadata
SaveExp(data = data, destination = destination, coords = coords, 
       Datasets = Datasets, varname = varname, Dates = Dates, 
       metadata = metadata, single_file = TRUE, ftime_dim = 'ftime', 
       var_dim = NULL)
}

}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}
}
