% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BEI_Weighting.R
\name{CST_BEI_Weighting}
\alias{CST_BEI_Weighting}
\title{Weighting SFSs of a CSTools object.}
\usage{
CST_BEI_Weighting(
  var_exp,
  aweights,
  terciles = NULL,
  type = "ensembleMean",
  time_dim_name = "time"
)
}
\arguments{
\item{var_exp}{An object of the class 's2dv_cube' containing the variable
(e.g. precipitation, temperature, NAO index) array.
The var_exp object is expected to have an element named \code{$data} with
at least a temporal dimension and a dimension named 'member'.}

\item{aweights}{Normalized weights array with at least dimensions 
(time, member), when 'time' is the temporal dimension as default. 
When 'aweights' parameter has any other dimensions (as e.g. 'lat') and 
'var_exp' parameter has also the same dimension, they must be equals.}

\item{terciles}{A numeric array with at least one dimension 'tercil' equal to 
2, the first element is the lower tercil for a hindcast period, and the second  
element is the upper tercile. By default is NULL, the terciles are computed  
from var_exp data.}

\item{type}{A character string indicating the type of output. 
If 'type' =  'probs', the function returns, in the element data from 
'var_exp' parameter, an array with at least two 
or four dimensions depending if the variable is spatially aggregated variable 
(as e.g. NAO index), dimension (time, tercil) or it is spatial variable 
(as e.g. precipitation or temperature), dimension (time, tercile, lat, lon), 
containing the terciles probabilities computing with weighted members.
The first tercil is the lower tercile, the second is the normal tercile and
the third is the upper tercile.
If 'type' =  'ensembleMean', the function returns, in the element data from 
'var_exp' parameter, an array with at least one or three dimensions
depending if the variable is a spatially aggregated variable 
(as e.g. NAO index)(time) or it is spatial variable (as e.g. precipitation 
or temperature) (time, lat, lon), containing the ensemble means computing
with weighted members.}

\item{time_dim_name}{A character string indicating the name of the 
temporal dimension, by default 'time'.}
}
\value{
CST_BEI_Weighting() returns a CSTools object (i.e., of the
class 's2dv_cube').
This object has at least an element named \code{$data}
with at least a temporal dimension (and dimension 'tercil' when the output 
are tercile probabilities), containing the ensemble means computing with 
weighted members or probabilities of terciles.
}
\description{
Function to apply weights to a 's2dv_cube' object.  
It could return a weighted ensemble mean (deterministic output) or
the terciles probabilities (probabilistic output) for Seasonal Forecast 
Systems (SFSs).
}
\examples{
var_exp <- 1 : (2 * 4 * 3 * 2)
dim(var_exp) <- c(time = 2, member = 4, lat = 3, lon = 2)
aweights <- c(0.2, 0.1, 0.3, 0.4, 0.1, 0.2, 0.4, 0.3, 0.1, 0.2, 0.4, 0.4, 0.1, 0.2, 0.4, 0.2)
dim(aweights) <- c(time = 2, member = 4, dataset = 2)
var_exp <- list(data = var_exp)
class(var_exp) <- 's2dv_cube'
res_CST <- CST_BEI_Weighting(var_exp, aweights)
dim(res_CST$data)
# time     lat     lon   dataset
#    2       3       2         2
}
\references{
Regionally improved seasonal forecast of precipitation through
Best estimation of winter NAO, Sanchez-Garcia, E. et al.,
Adv. Sci. Res., 16, 165174, 2019, https://doi.org/10.5194/asr-16-165-2019
}
\author{
Eroteida Sanchez-Garcia - AEMET, \email{esanchezg@aemet.es}
}
