% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Analogs.R
\name{CST_Analogs}
\alias{CST_Analogs}
\title{Downscaling using Analogs based on large scale fields.}
\usage{
CST_Analogs(expL, obsL, time_obsL, expVar = NULL, obsVar = NULL,
  region = NULL, criteria = "Large_dist")
}
\arguments{
\item{expL}{an 's2dv_cube' object containing the experimental field on the 
large scale for which the analog is aimed. This field is used to in all the
criterias. If parameter 'expVar' is not provided, the function will return 
the expL analog. The element 'data' in the 's2dv_cube' object must have, at
least, latitudinal and longitudinal dimensions. The object is expect to be 
already subset for the desired large scale region.}

\item{obsL}{an 's2dv_cube' object containing the observational field on the
large scale. The element 'data' in the 's2dv_cube' object must have the same 
latitudinal and longitudinal dimensions as parameter 'expL' and a temporal 
dimension with the maximum number of available observations.}

\item{time_obsL}{a character string indicating the date of the observations 
in the format "dd/mm/yyyy"}

\item{expVar}{an 's2dv_cube' object containing the experimental field on the
local scale, usually a different variable to the parameter 'expL'. If it is 
not NULL (by default, NULL), the returned field by this function will be the 
analog of parameter 'expVar'.}

\item{obsVar}{an 's2dv_cube' containing the field of the same variable as the 
passed in parameter 'expVar' for the same region.}

\item{region}{a vector of length four indicating the minimum longitude, the 
maximum longitude, the minimum latitude and the maximum latitude.}

\item{criteria}{a character string indicating the criteria to be used for the 
selection of analogs:
\itemize{
\item{Large_dist} minimal distance in the large scale pattern;
\item{Local_dist} minimal distance in the large scale pattern and minimal 
distance in the local scale pattern; and
\item{Local_cor} minimal distance in the large scale pattern, minimal 
distance in the local scale pattern and maxima correlation in the 
local variable to downscale.}}
}
\value{
An 's2dv_cube' object containing the dowscaled values of the best 
analogs in the criteria selected.
}
\description{
This function perform a downscaling using Analogs. To compute 
the analogs, the function search for days with similar large scale conditions
to downscaled fields in the local scale. The large scale and the local scale 
regions are defined by the user. The large scale is usually given by 
atmospheric circulation as sea level pressure or geopotential height 
(Yiou et al, 2013) but the function gives the possibility to use another 
field. The local scale will be usually given by precipitation or temperature 
fields, but might be another variable.The analogs function will find the best
analogs based in three criterias:
(1) Minimal distance in the large scale pattern (i.e. SLP)
(2) Minimal distance in the large scale pattern (i.e. SLP) and minimal 
distance in the local scale pattern (i.e. SLP). 
(3) Minimal distance in the large scale pattern (i.e. SLP), minimal 
distance in the local scale pattern (i.e. SLP) and maxima correlation in the 
local variable to downscale (i.e Precipitation).
The search of analogs must be done in the longest dataset posible. This is 
important since it is necessary to have a good representation of the 
possible states of the field in the past, and therefore, to get better 
analogs. Once the search of the analogs is complete, and in order to used 
the three criterias the user can select a number of analogs, using parameter
'nAnalogs' to restrict the selection of the best analogs in a short number 
of posibilities, the best ones.
This function has not constrains of specific regions, variables to downscale,
or data to be used (seasonal forecast data, climate projections data, 
reanalyses data). The regrid into a finner scale is done interpolating with 
CST_Load. Then, this interpolation is corrected selecting the analogs in the 
large and local scale in based of the observations. The function is an 
adapted version of the method of Yiou et al 2013.
}
\examples{
res <- CST_Analogs(expL = lonlat_data$exp, obsL = lonlat_data$obs)

}
\author{
M. Carmen Alvarez-Castro, \email{carmen.alvarez-castro@cmcc.it}

Nuria Perez-Zanon \email{nuria.perez@bsc.es}
}
\references{
Yiou, P., T. Salameh, P. Drobinski, L. Menut, R. Vautard,
and M. Vrac, 2013 : Ensemble reconstruction of the atmospheric column 
from surface pressure using analogues.  Clim. Dyn., 41, 1419-1437. 
\email{pascal.yiou@lsce.ipsl.fr}
}
\seealso{
code{\link{CST_Load}}, \code{\link[s2dverification]{Load}} and 
\code{\link[s2dverification]{CDORemap}}
}

