% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_get_peaks.R
\name{ch_get_peaks}
\alias{ch_get_peaks}
\title{Extracts peak flows over a threshold}
\usage{
ch_get_peaks(dataframe, threshold)
}
\arguments{
\item{dataframe}{a data frame of streamflow data containing columns named \option{Date} and \option{Flow}}

\item{threshold}{a value for the threshold. Values above the threshold are tested for peaks.}
}
\value{
Returns a list containing:
	\item{POTevents}{a dataframe contining details of the events}
	\item{events}{a vector with the value 0 when the flow is below the threshold and 1 when above.}
	\item{event_num}{a vector with the value 0 when the flow is below a threshold or the index of the events when the threshold was exceeded. i.e. 1,2,3, etc}
	\item{st_date}{start date of events}
	\item{case}{a list of the daily flows in each individual event (see details for more information)}
	
	The \code{POTevents} data frame contains five columns: 
	\item{st_date}{starting date of event}
	\item{max_date}{date of maximum in the event}
	\item{max}{maximum discharge during event}
	\item{volume}{flow volume during the event}
	\item{duration}{length of the event in days}
	The \code{case} list contains the flows during an event and also for four preceding and subsequent days. Each event will have
	 a length between nine to n days in length. Note: in rare cases where the event is in progress when data becomes available the 
	 event might be shorter than nine days long.
}
\description{
This function is development code being shared as is. It is expected that the user will be interested in the
data frame returned for POT analysis and for plotting (i.e. ch_booth_plot).

This function retrieves peaks greater than or equal to the prescribed threshold.  It returns a data frame of peak characteristics
suitable for subsequent analysis.

The portion under development is returns a list of the flows during an event with the values of the four
preceding days and three subsequent days. If the peak is a single point the fragment is nine points long; if the events is longer 
the fragment contains all days above the threshold and eight additional days.
}
\examples{
CAN05AA008 <- CAN05AA008
threshold <- 0.5*max(CAN05AA008$Flow)  # arbitrary threshold
my_peaks <- ch_get_peaks(CAN05AA008, threshold)
str(my_peaks)
}
\references{
Burn, D.H., Whitfield, P.H., Sharif, M., 2016. Identification of changes in floods and flood regimes
in Canada using a peaks over threshold approach. Hydrological Processes, 39: 3303-3314. DOI:10.1002/hyp.10861

Whitfield, P.H., and J.W. Pomeroy. 2016. Changes to flood peaks of a mountain river: implications
for analysis of the 2013 flood in the Upper Bow River, Canada. Hydrological Processes 30:4657-73. doi:
10.1002/hyp.10957.
}
\seealso{
\code{\link{ch_booth_plot}}
}
\author{
Paul Whitfield
}
