% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_get_ECDE_metadata.R
\name{ch_get_ECDE_metadata}
\alias{ch_get_ECDE_metadata}
\title{Reads Environment Canada Date Explorer (ECDE) meta data file}
\usage{
ch_get_ECDE_metadata(filename, writefile = NULL)
}
\arguments{
\item{filename}{The name of the ECDE file, \option{FavHydatStations.tb0}.}

\item{writefile}{Default is \code{NULL}, but if it is a filename e.g. \option{filename.csv} 
then the dataframe is saved to a csv file.}
}
\value{
Returns a dataframe consisting of:
\item{Station}{StationID}
\item{StationName}{Station Name}
\item{HYDStatus}{Active or Discontinued}
\item{Prov}{Province}
\item{Latitude}{}
\item{Longitude}{}
\item{DrainageArea}{km\eqn{^2}{^2}}
\item{Years}{Number of years with data}
\item{From}{Start Year}
\item{To}{End Year}
\item{Reg.}{Regulated?} 
\item{Flow}{If TRUE/Yes flow data exists}
\item{Level}{If TRUE/Yes level data exists}
\item{Sed}{If TRUE/Yes sediment data exists}
\item{OperSched}{Operations current - Continuous or Seasonal}
\item{RealTime}{If TRUE/Yes real time data is available}
\item{RHBN}{If TRUE/Yes the stations is in the reference hydrologic basin network}
\item{Region}{Name of regional office operating station}
\item{Datum}{Elevation datum}
\item{Operator}{Operator or provider of the data}
}
\description{
Reads the file that is generated from ECDE 'save favourite stations' to capture the ECDE metadata. 
The dataframe returned contains 20 fields from ECDE.
}
\examples{
\dontrun{
# Don't run this example as it requires an ECDE file
filename <- "FavHydatStations.tb0"        # dummy file name (not supplied)
meta0 <- ch_get_ECDE_metadata(filename)
meta1 <- ch_get_ECDE_metadata(filename, writefile="study52_metadata.csv")
}
}
\author{
Paul Whitfield <paul.h.whitfield@gmail.com>
}
