% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_m_binaryY.R
\name{w_m_binaryY}
\alias{w_m_binaryY}
\title{Compute E-step for Binary Mediator Misclassification Model Estimated With the EM Algorithm}
\usage{
w_m_binaryY(
  mstar_matrix,
  outcome_matrix,
  pistar_matrix,
  pi_matrix,
  p_yi_m0,
  p_yi_m1,
  sample_size,
  n_cat
)
}
\arguments{
\item{mstar_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
mediator \code{M*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed mediator category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{outcome_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{pistar_matrix}{A numeric matrix of conditional probabilities obtained from
the internal function \code{pistar_compute}. Rows of the matrix correspond to
each subject and to each observed mediator category. Columns of the matrix
correspond to each true, latent mediator category.}

\item{pi_matrix}{A numeric matrix of probabilities obtained from the internal
function \code{pi_compute}. Rows of the matrix correspond to each subject.
Columns of the matrix correspond to each true, latent mediator category.}

\item{p_yi_m0}{A numeric vector of outcome probabilities computed assuming a
true mediator value of 0.}

\item{p_yi_m1}{A numeric vector of outcome probabilities computed assuming a
true mediator value of 1.}

\item{sample_size}{An integer value specifying the number of observations in
the sample. This value should be equal to the number of rows of the observed
mediator matrix, \code{mstar_matrix}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{M},
and the observed outcome, \code{M*}, can take.}
}
\value{
\code{w_m_binaryY} returns a matrix of E-step weights for the EM-algorithm.
Rows of the matrix correspond to each subject. Columns of the matrix correspond
to the true mediator categories \eqn{j = 1, \dots,} \code{n_cat}.
}
\description{
Note that this function should only be used for Binary outcome models.
}
