% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_function_bernoulliY.R
\name{EM_function_bernoulliY}
\alias{EM_function_bernoulliY}
\title{EM Algorithm Function for Estimation of the Misclassification Model}
\usage{
EM_function_bernoulliY(
  param_current,
  obs_mediator,
  obs_outcome,
  X,
  Z,
  c_matrix,
  sample_size,
  n_cat
)
}
\arguments{
\item{param_current}{A numeric vector of regression parameters, in the order
\eqn{\beta, \gamma, \theta}. The \eqn{\gamma} vector is obtained from the matrix form.
In matrix form, the gamma parameter matrix rows
correspond to parameters for the \code{M* = 1}
observed mediator, with the dimensions of \code{Z}.
In matrix form, the gamma parameter matrix columns correspond to the true mediator categories
\eqn{j = 1, \dots,} \code{n_cat}. The numeric vector \code{gamma_v} is
obtained by concatenating the gamma matrix, i.e. \code{gamma_v <- c(gamma_matrix)}.}

\item{obs_mediator}{A numeric vector of indicator variables (1, 2) for the observed
mediator \code{M*}. There should be no \code{NA} terms. The reference category is 2.}

\item{obs_outcome}{A vector containing the outcome variables of interest. There
should be no \code{NA} terms.}

\item{X}{A numeric design matrix for the true mediator mechanism.}

\item{Z}{A numeric design matrix for the observation mechanism.}

\item{c_matrix}{A numeric matrix of covariates in the true mediator and outcome mechanisms.
\code{c_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{sample_size}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X} or \code{Z}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{M},
and the observed outcome, \code{M*} can take.}
}
\value{
\code{EM_function_bernoulliY} returns a numeric vector of updated parameter
estimates from one iteration of the EM-algorithm.
}
\description{
Function is for cases with \eqn{Y \sim Bernoulli} and with no interaction term
in the outcome mechanism.
}
