% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{applyBliss}
\alias{applyBliss}
\title{This function performs synergy analysis based on Bliss model and calculates associated BIs and global BI.}
\usage{
applyBliss(noOfRows, noOfCols, rawDataPreProcessed, nBoot)
}
\arguments{
\item{noOfRows}{Number of data rows in an experiment.}

\item{noOfCols}{Number of data columns in an experiment.}

\item{rawDataPreProcessed}{Data matrix to be analyzed.}

\item{nBoot}{Number of bootstraps to calculates BIs.}
}
\value{
Three lists are returned, first list contains Bliss synergy/antagonism values, lower and upper bounds of
corresponding BI. Second list consists of global BI of maximum synergistic combination and third list
consists of global BI of maximum antagonistic combination.
}
\description{
This function performs synergy analysis based on Bliss model and calculates associated BIs and global BI.
}
\examples{
dataFile <- system.file("/raw/rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
nR <- 8
nC <- 10
rslt <- applyBliss(nR, nC,  as.matrix(dataSample ), 500)
}
\author{
Muhammad kashif
}

