% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_assemble.R
\name{extractYear}
\alias{extractYear}
\title{Impute panel data}
\usage{
extractYear(use_year, IndData, impute_latest = FALSE)
}
\arguments{
\item{use_year}{The year of data to extract and impute.}

\item{IndData}{A data frame of indicator data, containing a \code{Year} column and with multiple observations for each unit code.}

\item{impute_latest}{Logical: if \code{TRUE}, imputes missing data points using most recent value from previous years. If \code{FALSE}
(default) simply extracts the data frame as is.}
}
\value{
A list containing:
\itemize{
\item \code{.$IndDataImp}: An \code{IndData} format data frame from the specified year (\code{use_year}), with missing data imputed using previous years
(where possible).
\item \code{.$DataYears}: A data frame in the same format as \code{IndData}, where each entry shows which year each data point came from.
Points where there was no missing data will have \code{use_year}, imputed points will have the corresponding year used to impute,
and any points in \code{.$IndDataImp} which are still \code{NA} will be be \code{NA}.
\item \code{.$ImpTable}: A data frame where each row is a point that was successfully imputed. This is a filtered and arranged version
of \code{.$DataYears} that focuses only on the imputed points.
\item \code{.$NImputed}: The number of imputed points.
}
}
\description{
Given a data frame of the \code{IndData} format, with a \code{Year} column, imputes any missing data using the latest available year.
This function is used inside \code{\link[=assemble]{assemble()}}.
}
\details{
This expects a data frame in the \code{IndData} format, i.e. it should at least have a \code{UnitCode} column, and a \code{Year} column,
as well as other columns that are to be imputed. It also presumes that there are multiple observations for each unit code,
i.e. one per year. It then searches for any missing values in the target year, and replaces them with the equivalent points
from previous years. It will replace using the most recently available point.
}
\examples{
# artificial example using ASEM data
# We only have one year of data so we copy it and "pretend" that they are from different years
# First, introduce 3 NAs
dat2018 <- ASEMIndData
dat2018[2, 12] <- NA
dat2018[3, 13] <- NA
dat2018[4, 14] <- NA
# Now make copy, pretending it is the previous year
dat2017 <- ASEMIndData
dat2017$Year <- 2017
# This df still has one missing point
dat2017[4, 14] <- NA
# Finally we have a 2016 data frame where none of the previous points are missing
dat2016 <- ASEMIndData
dat2016$Year <- 2016
# We can now put them together
IndData <- rbind(dat2018, dat2017, dat2016)
# And extract the 2018 data, with missing data taken from previous years
Imp <- extractYear(2018, IndData, impute_latest = TRUE)
# View which points have been imputed and the years of data used
Imp$ImpTable

}
\seealso{
\itemize{
\item \code{\link[=assemble]{assemble()}} Assemble a COIN - this function optionally calls \code{\link[=extractYear]{extractYear()}}.
\item \code{\link[=impute]{impute()}} Impute data using other imputation options (not using panel data).
}
}
