% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_iplot.R
\name{iplotIndDist}
\alias{iplotIndDist}
\title{Interactive indicator distribution plots}
\usage{
iplotIndDist(
  COIN,
  dset = "Raw",
  icodes = NULL,
  ptype = "Violin",
  aglev = 1,
  axlims = NULL
)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data}

\item{dset}{The source data set to use for indicator data (if input is COIN object)}

\item{icodes}{A character vector of a single indicator name or aggregate name to plot.}

\item{ptype}{The type of plot to produce. Currently supports \code{"Violin"} and \code{"Histogram"}.}

\item{aglev}{The aggregation level to extract the indicator data from. Defaults to indicator level (1)}

\item{axlims}{Optional parameter specifying axis limits. Useful mainly for matching with another plot.}
}
\value{
Plots generated with \strong{plotly}. These can be edited further with \strong{plotly} commands.
}
\description{
Generates a JavaScript distribution plot of a single indicator, using \strong{plotly}. Plot can be embedded e.g. in
HTML documents, websites, etc, or used for more interactive data exploration. This only plots one
indicator at a time - for multiple plots you can use \code{\link[=plotIndDist]{plotIndDist()}}.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# plot renewable energy indicator
iplotIndDist(ASEM, "Raw", "Renew", ptype = "Violin")

}
