% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultstable.R
\name{compareDF}
\alias{compareDF}
\title{Compare two data frames}
\usage{
compareDF(df1, df2, matchcol, sigfigs = 5)
}
\arguments{
\item{df1}{A data frame}

\item{df2}{Another data frame}

\item{matchcol}{A common column name that is used to match row order. E.g. this might be \code{UnitCode}.}

\item{sigfigs}{The number of significant figures to use for matching numerical columns}
}
\value{
A list with comparison results. List contains:
\itemize{
\item \code{.$Same}: overall summary: if \code{TRUE} the data frames are the same according to the rules specified, otherwise \code{FALSE}.
\item \code{.$Details}: details of each column as a data frame. Each row summarises a column of the data frame, saying whether
the column is the same as its equivalent, and the number of differences, if any. In case the two data frames have differing
numbers of columns and rows, or have differing column names or entries in \code{matchcol}, \code{.$Details} will simply contain a
message to this effect.
\item \code{.$Differences}: a list with one entry for every column which contains different entries. Differences are summarised as
a data frame with one row for each difference, reporting the value from \code{df1} and its equivalent from \code{df2}.
}
}
\description{
A custom function for comparing two data frames of indicator data, to see whether they match up, at a specified number of
significant figures.
}
\details{
This function compares numerical and non-numerical columns to see if they match. Rows and columns can be in any order. The function
performs the following checks:
\itemize{
\item Checks that the two data frames are the same size
\item Checks that column names are the same, and that the matching column has the same entries
\item Checks column by column that the elements are the same, after sorting according to the matching column
}

It then summarises for each column whether there are any differences, and also what the differences are, if any.

This is intended to cross-check results. For example, if you run something in COINr and want to check indicator results against
external calculations.
}
\examples{
# take a sample of indicator data (including the UnitCode column)
data1 <- ASEMIndData[c(2,12:15)]
# copy the data
data2 <- data1
# make a change: replace one value in data2 by NA
data2[1,2] <- NA
# compare data frames
compareDF(data1, data2, matchcol = "UnitCode")

}
