% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformer_30_60kv.R
\name{safety_cof_transformer_30_60kv}
\alias{safety_cof_transformer_30_60kv}
\title{Safety cost of Failure for 30/10kv and 60/10kv Transformer}
\usage{
safety_cof_transformer_30_60kv(tf_asset_category, location_risk, type_risk)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer
Options: \code{tf_asset_category = c("30kV Transformer (GM)",
"60kV Transformer (GM)")}.}

\item{location_risk}{String Type Financial factor criteria for Transformer
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{location_risk = c("Low", "Medium", "High")}.
The default setting is
\code{location_risk = "Medium"}.}

\item{type_risk}{String. Asses Financial factor criteria for Transformer
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{type_risk = c("Low", "Medium", "High")}.
The default setting is
\code{type_risk = "Medium"}.}
}
\value{
Numeric. Safety consequences of failure for Transformers
}
\description{
This function calculates safety consequences of failure
Outputted in DKK.
}
\examples{
safety_cof_transformer_30_60kv(tf_asset_category = "30kV Transformer (GM)",
location_risk = "Default",
type_risk = "Default")
}
