% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_cables_04_10kv.R
\name{environmental_cof_cables_04_10kv}
\alias{environmental_cof_cables_04_10kv}
\title{Environmental cost of Failure for 0.4kV and 10kV UG Cables}
\usage{
environmental_cof_cables_04_10kv(hv_asset_category, prox_water, bunded)
}
\arguments{
\item{hv_asset_category}{String The type of HV asset category
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\description{
This function calculates environmental consequences of failure
Outputted in DKK
\code{hv_asset_category = c("10kV UG Cable (Oil)",
"10kV UG Cable (Non Pressurised)", "0.4kV UG Cable (Non Pressurised)"}.
}
\examples{
environmental_cof_cables_04_10kv(hv_asset_category = "10kV UG Cable (Oil)",
prox_water = 95, bunded = "Yes")
}
