% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_health.R
\name{initial_health}
\alias{initial_health}
\title{Initial Health}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Healh & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
initial_health(b1, age)
}
\arguments{
\item{b1}{Numeric. The output returned by the function
\code{\link{beta_1}()}.}

\item{age}{Numeric. The crurrent age of the asset.}
}
\value{
Numeric. Initial health for an electric network asset.
}
\description{
Calculating the initial health score for a given asset.
See section 6.1.6 on page 36 in CNAIM (2021).
}
\examples{
# 6.6/ 11 kv transformer age 10 years and an initial age rate of 0.05
initial_health(b1 = 0.05,
               age = 10)
}
