% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnbd_expectation}
\alias{pnbd_expectation}
\alias{pnbd_nocov_expectation}
\alias{pnbd_staticcov_expectation}
\title{Pareto/NBD: Unconditional Expectation}
\usage{
pnbd_nocov_expectation(r, s, alpha_0, beta_0, vT_i)

pnbd_staticcov_expectation(r, s, vAlpha_i, vBeta_i, vT_i)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process. The smaller r, the stronger the heterogeneity of the purchase process}

\item{s}{shape parameter of the Gamma distribution for the lifetime process. The smaller s, the stronger the heterogeneity of customer lifetimes}

\item{alpha_0}{rate parameter of the Gamma distribution of the purchase process}

\item{beta_0}{rate parameter for the Gamma distribution for the lifetime process.}

\item{vT_i}{Number of periods since the customer came alive}

\item{vAlpha_i}{Vector of individual parameters alpha}

\item{vBeta_i}{Vector of individual parameters beta}
}
\value{
Returns the expected transaction values according to the chosen model.
}
\description{
Computes the expected number of repeat transactions in the interval (0, vT_i]
for a randomly selected customer, where 0 is defined as the point when the customer came alive.
}
\references{
Schmittlein DC, Morrison DG, Colombo R (1987). \dQuote{Counting Your Customers:
Who-Are They and What Will They Do Next?} Management Science, 33(1), 1–24.

Fader PS, Hardie BGS (2005). \dQuote{A Note on Deriving the Pareto/NBD Model and
Related Expressions.}
URL \url{http://www.brucehardie.com/notes/009/pareto_nbd_derivations_2005-11-05.pdf}.

Fader PS, Hardie BG (2007). \dQuote{Incorporating time-invariant covariates into the
Pareto/NBD and BG/NBD models.}
URL \url{http://www.brucehardie.com/notes/019/time_invariant_covariates.pdf}.
}
