% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.r
\name{logLik.clme}
\alias{logLik.clme}
\alias{logLik.summary.clme}
\title{Log-likelihood}
\usage{
\method{logLik}{clme}(object, ...)

\method{logLik}{summary.clme}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{...}{space for additional arguments}
}
\value{
Numeric.
}
\description{
Computes the log-likelihood of the fitted model for objects of class \code{clme}.

Log-likelihood
}
\details{
The log-likelihood is computed using the Normal distribution. The model uses residual bootstrap
methodology, and Normality is neither required nor assumed. Therefore the log-likelihood may
not be a useful measure in the context of \pkg{CLME}.
}
\examples{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood ,
                 constraints = cons, seed = 42, nsim = 0)

logLik( clme.out )
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}

\code{\link{logLik.clme}}
}

