% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{print.varcorr_clme}
\alias{print.varcorr_clme}
\title{Printout for variance components}
\usage{
\method{print}{varcorr_clme}(object, rdig = 5, ...)
}
\arguments{
\item{object}{object of class \code{\link{clme}}.}

\item{rdig}{number of digits to round to.}

\item{...}{space for additional arguments.}
}
\value{
Text printed to console.
}
\description{
Prints variance components of an objects of \code{clme}.
}
\examples{
\dontrun{
data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)
                 
print.varcorr_clme( clme.out )
}
}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
