% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate_fun.R
\name{ate_fun}
\alias{ate_fun}
\title{OR/RR/RD estimation for ATE}
\usage{
ate_fun(wt1, wt2, wt3, y, trt_ind)
}
\arguments{
\item{wt1}{weight for treatment group 1 in ATE}

\item{wt2}{weight for treatment group 2 in ATE}

\item{wt3}{weight for treatment group 3 in ATE}

\item{y}{numeric vector for the binary outcome}

\item{trt_ind}{numeric vector for the treatment indicator}
}
\value{
list with 3 elements for ATE effect. It contains
\item{ATE12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE23:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
The function estimates OR/RR/RD for ATE. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
ate_fun(wt1 = 1:100, wt2 = 1:100, wt3 = 1:100, y  =1:100, trt_ind =  rep(1:3, c(32,32,36)))
}
