% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aCFO.next.R
\name{aCFO.next}
\alias{aCFO.next}
\title{Determination of the dose level for next cohort in the accumulative calibration-free odds (aCFO) design}
\usage{
aCFO.next(target, ays, ans, currdose, 
       prior.para = list(alp.prior = target, bet.prior = 1 - target),
       cutoff.eli = 0.95, early.stop = 0.95)
}
\arguments{
\item{target}{the target DLT rate.}

\item{ays}{the cumulative numbers of DLTs observed in patients for all dose levels.}

\item{ans}{the cumulative numbers of patients for all dose levels.}

\item{currdose}{the current dose level.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}
}
\value{
The \code{aCFO.next()} function returns a list object comprising the following elements:
\itemize{
\item target: the target DLT rate.
\item ays: the cumulative counts of DLTs observed at all dose levels.
\item ans: the cumulative counts of patients treated at all dose levels.
\item decision: the decision in the aCFO design, where \code{left}, \code{stay}, and \code{right} represent the
movement directions, and \code{stop} indicates stopping the experiment.
\item currdose: the current dose level.
\item nextdose: the recommended dose level for the next cohort. \code{nextdose = 99} indicates that the trial is
terminated due to early stopping.
\item overtox: the situation regarding which position experiences over-toxicity. The dose level indicated by
\code{overtox} and all the dose levels above experience over-toxicity. \code{overtox = NA} signifies that the
occurrence of over-toxicity did not happen.
\item toxprob: the expected toxicity probability, \eqn{Pr(p_k > \phi | x_k, m_k)}, at all dose
levels, where \eqn{p_k}, \eqn{x_k}, and \eqn{m_k} is the dose-limiting toxicity (DLT) rate, the
numbers of observed DLTs, and the numbers of patients at dose level \eqn{k}.
}
}
\description{
In the aCFO design, the function is used to determine the dose movement based on the toxicity outcomes of the enrolled cohorts.
}
\details{
The aCFO design is an extension of the CFO design. It integrates dose information from all positions (ranging
from the lowest to the highest dose levels) into the decision-making process of the trial. Before assigning the dose level
for a new cohort, aCFO compares the evidence from the current dose level with all doses to its left and right. In contrast,
the original CFO design makes dose allocation by examining one dose level above and one below the current dose level.
Consequently, the aCFO design enhances the utilization of information while maintaining the characteristics of the CFO
design (model-free and calibration-free). Additionally, the aCFO design preserves the same early stopping and dose
elimination criteria as the CFO design.
}
\note{
The dose level indicated by \code{overtox} and all the dose levels above experience over-toxicity, and these dose levels will be eliminated.
}
\examples{
## determine the dose level for the next cohort of new patients
ays <- c(0, 0, 1, 0, 0, 0, 0); ans <- c(3, 3, 6, 0, 0, 0, 0)
decision <- aCFO.next(target = 0.2, ays = ays, ans = ans, currdose = 3, 
            prior.para = list(alp.prior = 0.2, bet.prior = 0.8))
summary(decision)

ays <- c(3, 0, 0, 0, 0, 0, 0); ans <- c(3, 0, 0, 0, 0, 0, 0)
decision <- aCFO.next(target = 0.2, ays = ays, ans = ans, currdose = 1,
            prior.para = list(alp.prior = 0.2, bet.prior = 0.8))
summary(decision)

ays <- c(0, 0, 0, 0, 0, 0, 3); ans <- c(3, 3, 3, 3, 3, 3, 3)
decision <- aCFO.next(target = 0.2, ays = ays, ans = ans, currdose = 7,
            prior.para = list(alp.prior = 0.2, bet.prior = 0.8))
summary(decision)

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Fang J, Yin G (2024). Fractional accumulative calibration‐free odds (f‐aCFO) design for delayed toxicity
in phase I clinical trials. \emph{Statistics in Medicine}.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
