## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
library(CEOdata)

## ----message = FALSE, echo = TRUE, eval = FALSE-------------------------------
#  library(CEOdata)
#  d <- CEOdata()

## ----message = FALSE, echo = FALSE, eval = TRUE-------------------------------
library(knitr)
library(CEOdata)
d <- CEOdata()
# If there is an internet problem, do not run the remaining of the chunks.
if (is.null(d)) {
  print("here")
  knitr::opts_chunk$set(eval = FALSE)
} else {
  knitr::opts_chunk$set(eval = TRUE)
}

## -----------------------------------------------------------------------------
dim(d)

## -----------------------------------------------------------------------------
d

## -----------------------------------------------------------------------------
names(d)[1:50]

## ---- eval = FALSE------------------------------------------------------------
#  d.raw <- CEOdata(raw = FALSE)

## -----------------------------------------------------------------------------
d746 <- CEOdata(reo = "746")
d746

## -----------------------------------------------------------------------------
b2019 <- CEOdata(date_start = "2019-01-01", date_end = "2019-12-31")
b2019

## -----------------------------------------------------------------------------
tail(names(d))

## -----------------------------------------------------------------------------
d.lowercase <- d
names(d.lowercase) <- tolower(names(d.lowercase))

## -----------------------------------------------------------------------------
CEOmeta()

## -----------------------------------------------------------------------------
CEOmeta(reo = "746")

## -----------------------------------------------------------------------------
CEOmeta(search = "Medi ambient")

## -----------------------------------------------------------------------------
CEOmeta(search = c("Medi ambient", "Municipi"))

## -----------------------------------------------------------------------------
CEOmeta() |> 
  filter(`Metode de recollida de dades` == "internet")

## -----------------------------------------------------------------------------
CEOmeta() |>
  filter(`Mostra estudis quantitatius` < 500)

## -----------------------------------------------------------------------------
CEOmeta(date_start = "2019-01-01", date_end = "2019-12-31")

## ---- eval = FALSE------------------------------------------------------------
#  CEOmeta(search = "Medi ambient a", browse = TRUE)

## ---- eval = FALSE------------------------------------------------------------
#  CEOmeta(reo = "746", browse = TRUE)

## ---- eval = FALSE------------------------------------------------------------
#  CEOmeta(search = "Medi ambient a", browse = TRUE, browse_translate = "de")

## -----------------------------------------------------------------------------
CEOsearch(d)  # equivalent to CEOsearch(d, where = "variables")

## -----------------------------------------------------------------------------
CEOsearch(d, where = "values")

## -----------------------------------------------------------------------------
CEOsearch(d, keyword = "edat")

## -----------------------------------------------------------------------------
CEOsearch(d, keyword = "edat", translate = TRUE)

## -----------------------------------------------------------------------------
CEOsearch(d) |>
  left_join(CEOsearch(d, where = "values"))

