% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_map.R
\name{sensitivity_map}
\alias{sensitivity_map}
\title{Create a sensitivity map}
\usage{
sensitivity_map(cnfa, parallel = FALSE, n = 1, filename = "", ...)
}
\arguments{
\item{cnfa}{Object of class \code{cnfa}}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of cores to use for calculation}

\item{filename}{character. Output filename (optional)}

\item{...}{Additional arguments for file writing as for \code{\link[raster]{writeRaster}}}
}
\value{
A RasterLayer of sensitivity values
}
\description{
Creates a sensitivity map of species habitat from a \code{cnfa} object.
}
\details{
The values of the sensitivity raster are calculated by centering the
habitat's climate data around the marginality factor \strong{m}
and projecting onto the sensitivity factor \strong{s}, given by the formula

 \eqn{\sigma} = |\bold{S} - \bold{m}|\bold{s}.
}
\examples{
mod1 <- cnfa(x = climdat.hist, s.dat = ABPR, field = "CODE")
sens.map <- sensitivity_map(mod1)

}
\seealso{
\code{\link{cnfa}}, \code{\link{exposure_map}}, \code{\link{vulnerability_map}}
}
