% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimMaxMinDist.R
\name{optimMaxMinDist}
\alias{optimMaxMinDist}
\title{Max-Min-Distance Optimizer}
\usage{
optimMaxMinDist(x = NULL, fun, control = list())
}
\arguments{
\item{x}{Optional set of solution(s) as a list, which are added to the randomly generated solutions and are also evaluated with the target function.}

\item{fun}{target function to be minimized}

\item{control}{(list), with the options\cr
\code{budget} The limit on number of target function evaluations (stopping criterion) (default: 100).\cr
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE.\cr
\code{creationFunction} Function to create individuals/solutions in search space. Default is a function that creates random permutations of length 6.\cr
\code{designBudget} budget of the design function \code{\link{designMaxMinDist}}, which is the number of randomly created candidates in each iteration.}
}
\value{
a list:\cr 	
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{x} history of all evaluated solutions\cr
\code{y} corresponding target function values f(x)\cr
\code{count} number of performed target function evaluations
}
\description{
One-shot optimizer: Create a design with maximum sum of distances, and evaluate.
Best candidate is returned.
}
\examples{
seed=0
#distance
dF <- distancePermutationHamming
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(1:5,dF)
#start optimization
set.seed(seed)
res <- optimMaxMinDist(,lF,list(creationFunction=cF,budget=20,
	vectorized=TRUE)) ##target function is "vectorized", expects list as input
res$xbest 

}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimEA}}, \code{\link{optimRS}}, \code{\link{optim2Opt}}
}

