% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationLee}
\alias{distancePermutationLee}
\title{Lee Distance for Permutations}
\usage{
distancePermutationLee(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Usually a string distance, with slightly different definition.
Adapted to permutations as: 
\deqn{d(x,y) = \sum_{i=1}^n min(|x_i - y_i|), n- |x_i - y_i|)}{ d(x,y) = \sum_{i=1}^n  min(|x_i - y_i|), n- |x_i - y_i|)}
where n is the length of the permutations x and y.
}
\examples{
x <- 1:5
y <- c(5,1,2,3,4)
distancePermutationLee(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationLee)

}
\references{
Lee, C., "Some properties of nonbinary error-correcting codes," Information Theory, IRE Transactions on, vol.4, no.2, pp.77,82, June 1958
}

