% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{unlock_user}
\alias{unlock_user}
\title{Unlock User-Specific Records
Removes any pending lock(s) for a specific user. Normally there should not be more than one record locked per user at any given time, but if there were more than one, i.e. DB corruption, all locks would be lifted at once.}
\usage{
unlock_user(uri_fun, user, password, host, port, database, end_user)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user.}
}
\value{
{
No return value, unlocks alls records for a specific user in the database.
}
}
\description{
Unlock User-Specific Records
Removes any pending lock(s) for a specific user. Normally there should not be more than one record locked per user at any given time, but if there were more than one, i.e. DB corruption, all locks would be lifted at once.
}
\examples{
\dontrun{
unlock_user(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port= NA, database = 'TEST_PROJECT', end_user = 'Mike')
}
}
