% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_processing.R
\name{patient_processor_par}
\alias{patient_processor_par}
\title{Process All Documents for One Patient}
\usage{
patient_processor_par(
  cl,
  sub_corpus,
  text_format,
  nlp_engine,
  negex_simp,
  umls_selected,
  max_n_grams_length,
  negex_depth,
  single_core_model
)
}
\arguments{
\item{cl}{Computing cluster.}

\item{sub_corpus}{Data frame of text to annotate.}

\item{text_format}{Text format.}

\item{nlp_engine}{NLP engine, UDPipe only for now.}

\item{negex_simp}{Simplifed negex.}

\item{umls_selected}{Processed UMLS table.}

\item{max_n_grams_length}{Maximum length of tokens for matching with UMLS concept unique identifiers (CUI's). Shorter values will result in faster processing. If ) is chosen, UMLS CUI tags will not be provided.}

\item{negex_depth}{Maximum distance between negation item and token to negate. Shorter distances will result in decreased sensitivity but increased specificity for negation.}

\item{single_core_model}{NLP model in case parallel processing is not used.}
}
\value{
NLP annotations dataframe.
}
\description{
Performs NLP annotations on all documents using previously established cluster, including NegEx and UMLS CUI tags.
}
\keyword{internal}
