% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{end_users}
\alias{end_users}
\title{Download End User List}
\usage{
end_users(uri_fun, user, password, host, port, database)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
An object of class data.frame, listing all project users along with their associated password.
This information is not available if using Active Directory feature because in this case
the value pairs would be stored outside of the CEDARS project database.
}
}
\description{
Downloads list of CEDARS end users along with their passwords.
}
\examples{
\dontrun{
end_users(uri_fun = mongo_uri_standard, user = 'John', password = 'db_password_1234',
host = 'server1234', port = NA, database = 'TEST_PROJECT')
}
}
