% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxfunc.R
\name{norm.network}
\alias{norm.network}
\alias{vec.to.mat}
\alias{mat.to.vec}
\title{Creating Objects for Network Models}
\usage{
norm.network(W)

vec.to.mat(u, N, normalise = FALSE, byrow = FALSE)

mat.to.vec(W, ceiled = FALSE, byrow = FALSE)
}
\arguments{
\item{W}{A matrix or list of matrices to convert.}

\item{u}{A numeric vector to convert.}

\item{N}{A vector of sub-network sizes such that \code{length(u) == sum(N * (N - 1))}.}

\item{normalise}{A boolean indicating whether the returned matrices should be row-normalized (\code{TRUE}) or not (\code{FALSE}).}

\item{byrow}{A boolean indicating whether entries in the matrices should be taken by row (\code{TRUE}) or by column (\code{FALSE}).}

\item{ceiled}{A boolean indicating whether the given matrices should be ceiled before conversion (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A vector of size \code{sum(N * (N - 1))} or a list of \code{length(N)} square matrices, with matrix sizes determined by \verb{N[1], N[2], ...}.
}
\description{
The \code{vec.to.mat} function creates a list of square matrices from a given vector.
Elements of the generated matrices are taken from the vector and placed column-wise or row-wise, progressing from the first matrix in the list to the last.
The diagonals of the generated matrices are set to zeros.\cr
The \code{mat.to.vec} function creates a vector from a given list of square matrices.
Elements of the generated vector are taken column-wise or row-wise, starting from the first matrix in the list to the last, excluding diagonal entries.\cr
The \code{norm.network} function row-normalizes matrices in a given list.
}
\examples{
# Generate a list of adjacency matrices
## Sub-network sizes
N <- c(250, 370, 120)  
## Rate of friendship
p <- c(0.2, 0.15, 0.18)   
## Network data
u <- unlist(lapply(1:3, function(x) rbinom(N[x] * (N[x] - 1), 1, p[x])))
W <- vec.to.mat(u, N)

# Convert W into a list of row-normalized matrices
G <- norm.network(W)

# Recover u
v <- mat.to.vec(G, ceiled = TRUE)
all.equal(u, v)
}
\seealso{
\code{\link{simnetwork}}, \code{\link{peer.avg}}.
}
