% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_skll_assignments_csv.R
\name{read_skill_assignment_csv}
\alias{read_skill_assignment_csv}
\title{Read an assignment of taught and required skills for a set of learning objects from CSV-files.}
\usage{
read_skill_assignment_csv(
  taught,
  required,
  header = TRUE,
  sep = ",",
  dec = ".",
  warnonly = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{taught}{CSV-file with assignments of taught competencies to learning objects}

\item{required}{CSV-file with assignments of required competencies to learning objects}

\item{header}{Boolean specifying whether the CSV-files contain a header line (default = TRUE)}

\item{sep}{Column separator (default ",")}

\item{dec}{Decimal point character (default ".")}

\item{warnonly}{Are non-compliant SAs allowed? (default = FALSE)}

\item{verbose}{Verbosity of compliance test (default = TRUE)}
}
\value{
List of two binary matrices, "taught" and "required".
}
\description{
\code{read_skill_assignment} expects two CSV-files with two columns each. The first
column contains the IDs of learning objects and the second row the IDs of single skills
required or taught, respectively, by this learning object.
It returns a list of two binary matrices, "taught" and "required". Each matrix has one
row per learning object and one column per skill. The cells contain a "1" if the skill
is taught or required, respectively, by the learning object and a "0" otherwise,
}
\seealso{
Other functions reading skill assignments: 
\code{\link{read_skill_assignment_ods}()},
\code{\link{read_skill_assignment_xlsx}()}
}
\concept{functions reading skill assignments}
