## File Name: print.slca.R
## File Version: 0.04
## File Last Change: 2017-01-31 14:07:29
################################################################################
# print method class gdm
################################################################################
print.slca <-
function(x, ... ){
	cat("Estimation of structured latent class analysis\n\n")

    d1 <- utils::packageDescription("CDM")
	cat( paste( d1$Package , " " , d1$Version , " (" , d1$Date , ")" , sep="") , "\n" )		
	
	cat("\nCall:\n", paste(deparse(x$call), sep = "\n", collapse = "\n"), 
				"\n\n", sep = "")
	#*** parameters
	cat(paste0("Number of cases = " , x$N , "\n") )
	cat(paste0("Number of groups = " , x$G , "\n") )
	cat(paste0("Number of items = " , ncol(x$data) , "\n") )
#	cat(paste0("Number of skill dimensions = " , dim(x$Qmatrix)[3] , "\n") )	
	cat(paste0("Number of skill classes = " , nrow(x$pi.k) , "\n") )		
	cat(paste0("Number of parameters = " , x$Npars , "\n") )
	cat(paste0("  # item parameters = " , x$ic$itempars , "\n") )
	cat(paste0("  # skill distribution parameters = " , 
				x$ic$traitpars , "\n") )
	#*** likelihood
	cat( paste0( "\nLog-Likelihood = " , round( x$loglike ,2 ) , "\n") )
	#*** information criteria
	cat( paste0( "AIC = " , round( x$AIC ,0 ) , "\n") )
	cat( paste0( "BIC = " , round( x$BIC ,0 ) , "\n") )
	invisible(x)	
}

