% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.test.R
\name{perm.test}
\alias{perm.test}
\title{Permutation Test for Conditional Independence}
\usage{
perm.test(
  formula,
  data,
  p = 0.7,
  nperm = 600,
  subsample = 1,
  metric = "RMSE",
  method = "rf",
  nrounds = 120,
  parametric = FALSE,
  poly = TRUE,
  interaction = TRUE,
  degree = 3,
  tail = NA,
  metricfunc = NULL,
  mlfunc = NULL,
  nthread = 1,
  dag = NA,
  dag_n = NA,
  num_class = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula or DAGitty object specifying the relationship between dependent and independent variables.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{p}{Proportion of data to use for training the model. Default is 0.825.}

\item{nperm}{Number of permutations to perform. Default is 500.}

\item{subsample}{The proportion of the data to be used. Default is 1 (no subsampling).}

\item{metric}{Type of metric: "RMSE", "Kappa" or "Custom". Default is 'RMSE'.}

\item{method}{The machine learning method to use. Supported methods include "rf", "xgboost", etc. Default is "rf".}

\item{nrounds}{Number of rounds (trees) for methods such as xgboost and random forest. Default is 120.}

\item{parametric}{Logical. If TRUE, a parametric p-value is calculated in addition to the empirical p-value. Default is FALSE.}

\item{poly}{Logical. If TRUE, polynomial terms of the conditional variables are included in the model. Default is TRUE.}

\item{interaction}{Logical. If TRUE, interaction terms of the conditional variables are included in the model. Default is TRUE.}

\item{degree}{The degree of polynomial terms to include if poly is TRUE. Default is 3.}

\item{tail}{Specifies whether the test is one-tailed ("left" or "right") or two-tailed. Default is NA.}

\item{metricfunc}{An optional custom function to calculate the performance metric based on the model's predictions. Default is NULL.}

\item{mlfunc}{An optional custom machine learning function to use instead of the predefined methods. Default is NULL.}

\item{nthread}{Integer. The number of threads to use for parallel processing. Default is 1.}

\item{dag}{A DAGitty object specifying the directed acyclic graph for the variables. Default is NA.}

\item{dag_n}{A character string specifying the name of the node in the DAGitty object to be used for conditional independence testing. Default is NA.}

\item{num_class}{Integer. The number of classes for categorical data (used in xgboost). Default is NULL.}

\item{progress}{Logical. If TRUE, a progress bar is displayed during the permutation process. Default is TRUE.}

\item{...}{Additional arguments to pass to the machine learning model fitting function.}
}
\value{
An object of class 'CCI' containing the null distribution, observed test statistic, p-values, the machine learning model used, and the data.
}
\description{
Permutation Test for Conditional Independence
}
\examples{
set.seed(123)
dat <- data.frame(x1 = rnorm(100),
x2 = rnorm(100),
x3 = rnorm(100),
x4 = rnorm(100),
y = rnorm(100))
perm.test(y ~ x1 | x2 + x3 + x4, data = dat, nperm = 25)
}
\seealso{
\code{\link{print.CCI}}, \code{\link{summary.CCI}},
\code{\link{plot.CCI}}, \code{\link{QQplot}}
}
