% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_power_curve.R
\name{calc_power_curve}
\alias{calc_power_curve}
\title{Calculate the power curve for an experiment}
\usage{
calc_power_curve(ninstances, sig.level = 0.05, alternative = "two.sided",
  test.type = "t.test", npoints = 100)
}
\arguments{
\item{ninstances}{the number of instances to be used in the experiment.}

\item{sig.level}{significance level (alpha) for the experiment}

\item{alternative}{type of alternative hypothesis ("two.sided" or
"one.sided")}

\item{test.type}{type of test ("t.test", "wilcoxon", "binomial")}

\item{npoints}{number of points for the power curve.}
}
\value{
an object of class \code{caiser.powercurve} containing fields
\code{d}, the (standardized) effect size; and \code{power}, the (expected) power
to detect each effect size in \code{d}.
}
\description{
Calculates the power curve (d x power) for an experiment with a fixed
number of instances. See \code{\link[=calc_instances]{calc_instances()}} for details.
}
\examples{
my.cpc <- calc_power_curve(ninstances = 10)
summary(my.cpc)
plot(my.cpc)


}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
