% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_image.R
\name{CAESAR.coembedding.image}
\alias{CAESAR.coembedding.image}
\title{Compute Co-embedding with Image Information Using CAESAR}
\usage{
CAESAR.coembedding.image(
  seu,
  feature_img,
  pos,
  reduction.name = "caesar",
  q = 50,
  lower.med = 3.5,
  upper.med = 5.5,
  radius.upper = 400,
  q.image = 10,
  weighted = FALSE,
  approx_Phi = TRUE,
  seed = 1,
  ...
)
}
\arguments{
\item{seu}{A Seurat object containing spatial transcriptomics data.}

\item{feature_img}{A matrix representing features extracted from a histology image using a Visual Transformer. Rows correspond to spots and columns represent image features. The row names of `feature_img` should match the column names of `seu`.}

\item{pos}{A matrix of spatial coordinates for the spots (e.g., spatial positions of cells or pixels in the image). The row names of `pos` should match the column names of `seu`.}

\item{reduction.name}{A character string specifying the name of the dimensional reduction method to store in the Seurat object. Default is "caesar".}

\item{q}{An integer specifying the number of dimensions for the reduced co-embeddings. Default is 50.}

\item{lower.med}{A numeric value specifying the lower bound for the desired median number of neighbors in the spatial adjacency matrix. Default is 3.5.}

\item{upper.med}{A numeric value specifying the upper bound for the desired median number of neighbors in the spatial adjacency matrix. Default is 5.5.}

\item{radius.upper}{A numeric value specifying the upper limit of the search radius for the spatial adjacency matrix. Default is 400.}

\item{q.image}{An integer specifying the number of dimensions for the reduced image embeddings. Default is 10.}

\item{weighted}{Logical, indicating whether to apply weighted PCA on the image features. Default is FALSE.}

\item{approx_Phi}{Logical, indicating whether to use an approximate method for Phi matrix estimation. Default is TRUE.}

\item{seed}{An integer used to set the random seed for reproducibility. Default is 1.}

\item{...}{Additional arguments passed to `cellembedding_image_seurat`.}
}
\value{
The modified Seurat object with the computed cell and gene embeddings stored in the specified reduction slot.
}
\description{
This function performs co-embedding of both cells and genes using the CAESAR method. It integrates spatial transcriptomics data from a Seurat object (`seu`) with image features (`feature_img`) and a spatial adjacency matrix to compute the low-dimensional co-embedding.
}
\examples{
data(toydata)

seu <- toydata$seu
pos <- toydata$pos
imgf <- toydata$imgf

seu <- CAESAR.coembedding.image(seu, imgf, pos)
print(seu)
}
\seealso{
\code{\link{cellembedding_image_seurat}} for computing cell embeddings.
\code{\link{add.gene.embedding}} for adding gene embeddings to a Seurat object.
}
