/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class CorrelationAnalysis
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JList colList2;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevel;
    private JRadioButton kendallRadioButton;
    private ButtonGroup methodGroup;
    private JPanel methodPane;
    private JRadioButton pearsonRadioButton;
    private JPanel plotPane;
    private JCheckBox scatterPlot;
    private JRadioButton spearmanRadioButton;
    private JPanel varPane;
    private JScrollPane varScrollPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CorrelationAnalysis.this.datasetChangedAction();
            }
        });
        this.datasetChangedAction();
        this.confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        this.updateValidity();
        if (System.getProperty("os.name").contains("Windows")) {
            this.setSize(480, 400);
        }
    }

    private void refreshVariableLists() {
        String dataset = this.getDatasetPane().getSelectedDataset();
        if (dataset != null) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.nonFactors(dataset);
                if (nonFactors != null) {
                    this.colList2.setListData(nonFactors);
                } else {
                    this.colList2.removeAll();
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(CorrelationAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(CorrelationAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Object[] getSelectedItems(JList list) {
        if (list != null) {
            return list.getSelectedValues();
        }
        return null;
    }

    public Object[] getVariables() {
        return CorrelationAnalysis.getSelectedItems(this.colList2);
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPane = new JPanel();
        this.varScrollPane = new JScrollPane();
        this.colList2 = new JList();
        this.analysisOptionsPane = new JPanel();
        this.scatterPlot = new JCheckBox();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevel = new JSpinner();
        this.methodPane = new JPanel();
        this.pearsonRadioButton = new JRadioButton();
        this.kendallRadioButton = new JRadioButton();
        this.spearmanRadioButton = new JRadioButton();
        this.methodGroup = new ButtonGroup();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.varScrollPane.setPreferredSize(new Dimension(100, 140));
        this.varScrollPane.setViewportView(this.colList2);
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varScrollPane, -1, 154, Short.MAX_VALUE).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varScrollPane, -1, 243, Short.MAX_VALUE).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.scatterPlot.setText("Create Scatterplot Matrix");
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationAnalysis.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        GroupLayout analysisOptionsPaneLayout = new GroupLayout(this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.confIntervals).addContainerGap(-1, Short.MAX_VALUE)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.scatterPlot).addContainerGap(55, Short.MAX_VALUE)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGap(58, 58, 58).addComponent(this.confLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confLevel, -1, 76, Short.MAX_VALUE).addContainerGap()));
        analysisOptionsPaneLayout.setVerticalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.scatterPlot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confIntervals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confLabel).addComponent(this.confLevel, -2, -1, -2)).addContainerGap()));
        this.methodPane.setBorder(BorderFactory.createTitledBorder("Method"));
        this.methodGroup.add(this.pearsonRadioButton);
        this.pearsonRadioButton.setSelected(true);
        this.pearsonRadioButton.setText("Pearson");
        this.pearsonRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationAnalysis.this.pearsonRadioButtonStateChanged(evt);
            }
        });
        this.methodGroup.add(this.kendallRadioButton);
        this.kendallRadioButton.setText("Kendall");
        this.kendallRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationAnalysis.this.kendallRadioButtonStateChanged(evt);
            }
        });
        this.methodGroup.add(this.spearmanRadioButton);
        this.spearmanRadioButton.setText("Spearman");
        this.spearmanRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CorrelationAnalysis.this.spearmanRadioButtonStateChanged(evt);
            }
        });
        GroupLayout methodPaneLayout = new GroupLayout(this.methodPane);
        this.methodPane.setLayout(methodPaneLayout);
        methodPaneLayout.setHorizontalGroup(methodPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(methodPaneLayout.createSequentialGroup().addGroup(methodPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(methodPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.pearsonRadioButton)).addGroup(methodPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.kendallRadioButton)).addGroup(methodPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.spearmanRadioButton))).addContainerGap(192, Short.MAX_VALUE)));
        methodPaneLayout.setVerticalGroup(methodPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(methodPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.pearsonRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kendallRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spearmanRadioButton).addContainerGap()));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisOptionsPane, -1, -1, Short.MAX_VALUE).addComponent(this.methodPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addGroup(plotPaneLayout.createSequentialGroup().addComponent(this.methodPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisOptionsPane, -2, -1, -2))).addContainerGap()));
        this.setTitle("Correlation Analysis");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 584) / 2, (screenSize.height - 522) / 2, 584, 522);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.updateValidity();
    }

    private void pearsonRadioButtonStateChanged(ChangeEvent evt) {
        this.processMethodChange();
    }

    private void kendallRadioButtonStateChanged(ChangeEvent evt) {
        this.processMethodChange();
    }

    private void spearmanRadioButtonStateChanged(ChangeEvent evt) {
        this.processMethodChange();
    }

    private void processMethodChange() {
        boolean enableConfControls = this.pearsonRadioButton.isSelected();
        this.confIntervals.setEnabled(enableConfControls);
        this.confLabel.setEnabled(enableConfControls);
        this.confLevel.setEnabled(enableConfControls);
    }

    private void updateValidity() {
        boolean enableConfLevel = this.confIntervals.isSelected();
        this.confLabel.setEnabled(enableConfLevel);
        this.confLevel.setEnabled(enableConfLevel);
    }

    private List getColumn(JTable table, int column) {
        if (table != null && column <= table.getColumnCount()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                list.add(table.getValueAt(i, column));
            }
            return list;
        }
        return null;
    }

    @Override
    protected void submitButtonAction() {
        String method = null;
        if (this.pearsonRadioButton.isSelected()) {
            method = "pearson";
        } else if (this.kendallRadioButton.isSelected()) {
            method = "kendall";
        } else if (this.spearmanRadioButton.isSelected()) {
            method = "spearman";
        }
        String cmd = "cor.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", my.vars=" + (this.getVariables() != null && this.getVariables().length > 0 ? "c(" + RUtils.toString(this.getVariables(), ",", "'") + ")" : "NULL") + ", iMethod=" + RUtils.getStringValue(method) + ", iCI=" + GUIUtils.getBooleanValueR(this.confIntervals) + ", conf.level=" + (this.confIntervals.isSelected() ? Double.valueOf((Double)this.confLevel.getValue()) : "NULL") + ", iScatterplot=" + GUIUtils.getBooleanValueR(this.scatterPlot) + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('cor.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void datasetChangedAction() {
        this.refreshVariableLists();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        int[] varIndices = this.colList2.getSelectedIndices();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
        this.colList2.setSelectedIndices(varIndices);
    }
}

