/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class FactorAnalysis
extends DataPlotDialog {
    private JCheckBox centerZeroCheckBox;
    private JLabel dofLabel;
    private JTextField dofTextField;
    private JPanel faPane;
    private JPanel faRotationPane;
    private JPanel faScoresPane;
    private JPanel leftPane;
    private JCheckBox loadingScorePlotCheckBox;
    private JLabel numFactorsLabel;
    private JPanel numFactorsPane;
    private JSpinner numFactorsSpinner;
    private JPanel pcaOptionsPane;
    private JPanel pcaOutputPane;
    private JPanel pcaPane;
    private JPanel plotPane;
    private JRadioButton promaxRadioButton;
    private JLabel reqsMsg;
    private JPanel reqsPane;
    private JTabbedPane rightPane;
    private JCheckBox rotateVarsCheckBox;
    private ButtonGroup rotationButtonGroup;
    private JCheckBox scaleUnitVarCheckBox;
    private JRadioButton scoresBartlettRadioButton;
    private ButtonGroup scoresButtonGroup;
    private JRadioButton scoresNoneRadioButton;
    private JRadioButton scoresThompsonRadioButton;
    private JCheckBox screePlotCheckBox;
    private JList varList;
    private JPanel varPane;
    private JScrollPane varScrollPane;
    private JRadioButton varimaxRadioButton;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactorAnalysis.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshNumFactorsSpinner();
        this.refreshValidity();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshNumFactorsSpinner();
        this.refreshValidity();
    }

    public void refreshVariableListValidity() {
        boolean datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;
        this.varList.setEnabled(datasetValid && this.varList.getModel().getSize() > 0);
    }

    public void refreshVariableList() {
        block6: {
            if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
                Vector numerics = null;
                try {
                    numerics = RUtils.colnamesNumericVector(this.getDatasetPane().getSelectedDataset());
                    if (numerics != null) {
                        this.varList.setListData(numerics);
                        break block6;
                    }
                    this.varList.removeAll();
                }
                catch (REngineException ex) {
                    Logger.getLogger(FactorAnalysis.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (REXPMismatchException ex) {
                    Logger.getLogger(FactorAnalysis.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.varList.removeAll();
            }
        }
        this.refreshValidity();
    }

    public void refreshNumFactorsSpinner() {
        int numFactors = (Integer)this.numFactorsSpinner.getValue();
        this.numFactorsSpinner.setModel(new SpinnerNumberModel(numFactors, 0, new Double(Math.floor((double)this.varList.getModel().getSize() / 2.0)).intValue(), 1));
        this.numFactorsSpinner.setValue(numFactors);
    }

    public void refreshDataLists() {
        int[] varIndices = this.varList.getSelectedIndices();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshNumFactorsSpinner();
        this.varList.setSelectedIndices(varIndices);
        this.refreshFactorSelectionPanes();
        this.refreshValidity();
    }

    public void refreshAnalysisTabValidity() {
        if ((Integer)this.numFactorsSpinner.getValue() == 0) {
            this.rightPane.setEnabledAt(0, true);
            this.rightPane.setEnabledAt(1, false);
            this.rightPane.setSelectedIndex(0);
        } else {
            this.rightPane.setEnabledAt(0, false);
            this.rightPane.setEnabledAt(1, true);
            this.rightPane.setSelectedIndex(1);
        }
    }

    public void refreshSubmitButtonValidity() {
        boolean status;
        int numVars = this.varList.isSelectionEmpty() ? 0 : this.varList.getSelectedIndices().length;
        int numFactors = (Integer)this.numFactorsSpinner.getValue();
        if (numFactors == 0) {
            status = numVars > 0;
        } else {
            double degreesFreedom = 0.5 * (Math.pow(numVars - numFactors, 2.0) - (double)numVars - (double)numFactors);
            this.dofTextField.setText(String.valueOf(degreesFreedom));
            status = numVars >= 3 && degreesFreedom >= 0.0;
        }
        this.getSubmitButton().setEnabled(status);
    }

    public void refreshValidity() {
        this.refreshAnalysisTabValidity();
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.leftPane = new JPanel();
        this.numFactorsPane = new JPanel();
        this.numFactorsLabel = new JLabel();
        this.numFactorsSpinner = new JSpinner();
        this.varPane = new JPanel();
        this.varScrollPane = new JScrollPane();
        this.varList = new JList();
        this.rightPane = new JTabbedPane();
        this.pcaPane = new JPanel();
        this.pcaOutputPane = new JPanel();
        this.screePlotCheckBox = new JCheckBox();
        this.loadingScorePlotCheckBox = new JCheckBox();
        this.rotateVarsCheckBox = new JCheckBox();
        this.pcaOptionsPane = new JPanel();
        this.centerZeroCheckBox = new JCheckBox();
        this.scaleUnitVarCheckBox = new JCheckBox();
        this.faPane = new JPanel();
        this.faRotationPane = new JPanel();
        this.varimaxRadioButton = new JRadioButton();
        this.promaxRadioButton = new JRadioButton();
        this.faScoresPane = new JPanel();
        this.scoresNoneRadioButton = new JRadioButton();
        this.scoresThompsonRadioButton = new JRadioButton();
        this.scoresBartlettRadioButton = new JRadioButton();
        this.reqsPane = new JPanel();
        this.reqsMsg = new JLabel();
        this.dofLabel = new JLabel();
        this.dofTextField = new JTextField();
        this.rotationButtonGroup = new ButtonGroup();
        this.scoresButtonGroup = new ButtonGroup();
        this.plotPane.setLayout(new GridLayout(1, 2));
        this.leftPane.setPreferredSize(new Dimension(320, 480));
        this.numFactorsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.numFactorsLabel.setText("No. of Factors:");
        this.numFactorsSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.numFactorsSpinner.setRequestFocusEnabled(false);
        this.numFactorsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FactorAnalysis.this.numFactorsSpinnerStateChanged(evt);
            }
        });
        GroupLayout numFactorsPaneLayout = new GroupLayout(this.numFactorsPane);
        this.numFactorsPane.setLayout(numFactorsPaneLayout);
        numFactorsPaneLayout.setHorizontalGroup(numFactorsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(numFactorsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.numFactorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numFactorsSpinner, -2, 60, -2).addContainerGap(115, Short.MAX_VALUE)));
        numFactorsPaneLayout.setVerticalGroup(numFactorsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(numFactorsPaneLayout.createSequentialGroup().addContainerGap().addGroup(numFactorsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numFactorsLabel).addComponent(this.numFactorsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.varList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FactorAnalysis.this.varListValueChanged(evt);
            }
        });
        this.varScrollPane.setViewportView(this.varList);
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varScrollPane, -1, 304, Short.MAX_VALUE).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varScrollPane, -1, 413, Short.MAX_VALUE).addContainerGap()));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addComponent(this.numFactorsPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPaneLayout.createSequentialGroup().addComponent(this.numFactorsPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.varPane, -1, -1, Short.MAX_VALUE)));
        this.plotPane.add(this.leftPane);
        this.rightPane.setPreferredSize(new Dimension(320, 480));
        this.pcaOutputPane.setBorder(BorderFactory.createTitledBorder("Output"));
        this.screePlotCheckBox.setText("Scree Plot");
        this.loadingScorePlotCheckBox.setText("Loading / Score Plot");
        this.rotateVarsCheckBox.setText("Rotated Variables");
        GroupLayout pcaOutputPaneLayout = new GroupLayout(this.pcaOutputPane);
        this.pcaOutputPane.setLayout(pcaOutputPaneLayout);
        pcaOutputPaneLayout.setHorizontalGroup(pcaOutputPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pcaOutputPaneLayout.createSequentialGroup().addContainerGap().addGroup(pcaOutputPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.screePlotCheckBox).addComponent(this.loadingScorePlotCheckBox).addComponent(this.rotateVarsCheckBox)).addContainerGap(79, Short.MAX_VALUE)));
        pcaOutputPaneLayout.setVerticalGroup(pcaOutputPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pcaOutputPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.screePlotCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadingScorePlotCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rotateVarsCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.pcaOptionsPane.setBorder(BorderFactory.createTitledBorder("Options"));
        this.centerZeroCheckBox.setSelected(true);
        this.centerZeroCheckBox.setText("Center to 0");
        this.scaleUnitVarCheckBox.setSelected(true);
        this.scaleUnitVarCheckBox.setText("Scale to Unit Var");
        GroupLayout pcaOptionsPaneLayout = new GroupLayout(this.pcaOptionsPane);
        this.pcaOptionsPane.setLayout(pcaOptionsPaneLayout);
        pcaOptionsPaneLayout.setHorizontalGroup(pcaOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pcaOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(pcaOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.centerZeroCheckBox).addComponent(this.scaleUnitVarCheckBox)).addContainerGap(107, Short.MAX_VALUE)));
        pcaOptionsPaneLayout.setVerticalGroup(pcaOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pcaOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.centerZeroCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleUnitVarCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pcaPaneLayout = new GroupLayout(this.pcaPane);
        this.pcaPane.setLayout(pcaPaneLayout);
        pcaPaneLayout.setHorizontalGroup(pcaPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pcaPaneLayout.createSequentialGroup().addContainerGap().addGroup(pcaPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pcaOptionsPane, -1, -1, Short.MAX_VALUE).addComponent(this.pcaOutputPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pcaPaneLayout.setVerticalGroup(pcaPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pcaPaneLayout.createSequentialGroup().addComponent(this.pcaOutputPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcaOptionsPane, -2, -1, -2).addContainerGap(249, Short.MAX_VALUE)));
        this.rightPane.addTab("Principal Components", this.pcaPane);
        this.faRotationPane.setBorder(BorderFactory.createTitledBorder("Rotation"));
        this.rotationButtonGroup.add(this.varimaxRadioButton);
        this.varimaxRadioButton.setSelected(true);
        this.varimaxRadioButton.setText("Varimax");
        this.rotationButtonGroup.add(this.promaxRadioButton);
        this.promaxRadioButton.setText("Promax");
        GroupLayout faRotationPaneLayout = new GroupLayout(this.faRotationPane);
        this.faRotationPane.setLayout(faRotationPaneLayout);
        faRotationPaneLayout.setHorizontalGroup(faRotationPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(faRotationPaneLayout.createSequentialGroup().addContainerGap().addGroup(faRotationPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varimaxRadioButton).addComponent(this.promaxRadioButton)).addContainerGap(183, Short.MAX_VALUE)));
        faRotationPaneLayout.setVerticalGroup(faRotationPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(faRotationPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.varimaxRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.promaxRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.faScoresPane.setBorder(BorderFactory.createTitledBorder("Scores"));
        this.scoresButtonGroup.add(this.scoresNoneRadioButton);
        this.scoresNoneRadioButton.setSelected(true);
        this.scoresNoneRadioButton.setText("None");
        this.scoresButtonGroup.add(this.scoresThompsonRadioButton);
        this.scoresThompsonRadioButton.setText("Thompson");
        this.scoresButtonGroup.add(this.scoresBartlettRadioButton);
        this.scoresBartlettRadioButton.setText("Bartlett");
        GroupLayout faScoresPaneLayout = new GroupLayout(this.faScoresPane);
        this.faScoresPane.setLayout(faScoresPaneLayout);
        faScoresPaneLayout.setHorizontalGroup(faScoresPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(faScoresPaneLayout.createSequentialGroup().addContainerGap().addGroup(faScoresPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scoresNoneRadioButton).addComponent(this.scoresThompsonRadioButton).addComponent(this.scoresBartlettRadioButton)).addContainerGap(164, Short.MAX_VALUE)));
        faScoresPaneLayout.setVerticalGroup(faScoresPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(faScoresPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.scoresNoneRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scoresThompsonRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scoresBartlettRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.reqsPane.setBorder(BorderFactory.createTitledBorder("Requirements"));
        this.reqsMsg.setText("<html>   <ul style=\"margin-left: 10px;\">     <li>At least 3 variables must be selected.</li>     <li>The degrees of freedom must be at least 0.</li>   </ul> </html>");
        this.reqsMsg.setVerticalAlignment(1);
        this.dofLabel.setText("Degrees of Freedom:");
        this.dofTextField.setEditable(false);
        GroupLayout reqsPaneLayout = new GroupLayout(this.reqsPane);
        this.reqsPane.setLayout(reqsPaneLayout);
        reqsPaneLayout.setHorizontalGroup(reqsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, reqsPaneLayout.createSequentialGroup().addContainerGap().addGroup(reqsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reqsMsg, GroupLayout.Alignment.LEADING, -1, 268, Short.MAX_VALUE).addGroup(reqsPaneLayout.createSequentialGroup().addComponent(this.dofLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dofTextField, -1, 68, Short.MAX_VALUE))).addContainerGap()));
        reqsPaneLayout.setVerticalGroup(reqsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reqsPaneLayout.createSequentialGroup().addContainerGap().addGroup(reqsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dofLabel).addComponent(this.dofTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reqsMsg, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout faPaneLayout = new GroupLayout(this.faPane);
        this.faPane.setLayout(faPaneLayout);
        faPaneLayout.setHorizontalGroup(faPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, faPaneLayout.createSequentialGroup().addContainerGap().addGroup(faPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reqsPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.faRotationPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.faScoresPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        faPaneLayout.setVerticalGroup(faPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(faPaneLayout.createSequentialGroup().addComponent(this.faRotationPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.faScoresPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reqsPane, -2, -1, -2).addContainerGap(46, Short.MAX_VALUE)));
        this.rightPane.addTab("Factor", this.faPane);
        this.plotPane.add(this.rightPane);
        this.setTitle("Factor Analysis");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 686) / 2, (screenSize.height - 731) / 2, 686, 731);
    }

    private void varListValueChanged(ListSelectionEvent evt) {
        this.refreshSubmitButtonValidity();
    }

    private void numFactorsSpinnerStateChanged(ChangeEvent evt) {
        this.refreshAnalysisTabValidity();
        this.refreshSubmitButtonValidity();
    }

    @Override
    protected void submitButtonAction() {
        String rotation = "NULL";
        String scores = "NULL";
        if (this.varimaxRadioButton.isSelected()) {
            rotation = "'varimax'";
        } else if (this.promaxRadioButton.isSelected()) {
            rotation = "'promax'";
        }
        if (this.scoresNoneRadioButton.isSelected()) {
            scores = "'none'";
        } else if (this.scoresThompsonRadioButton.isSelected()) {
            scores = "'regression'";
        } else if (this.scoresBartlettRadioButton.isSelected()) {
            scores = "'Bartlett'";
        }
        String cmd = "pca.fa.JGR(my.data=" + (this.getDatasetPane().getDatasetComboBox() != null && this.getDatasetPane().getDatasetComboBox().getSelectedIndex() != -1 ? this.getDatasetPane().getSelectedDataset() : "NULL") + ", numFactors=" + this.numFactorsSpinner.getValue() + ", variables=" + (this.varList.isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.varList.getSelectedValues(), ",", "'") + ")") + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", iScreePlot=" + GUIUtils.getBooleanValueR(this.screePlotCheckBox) + ", iLoadingPlot=" + GUIUtils.getBooleanValueR(this.loadingScorePlotCheckBox) + ", retx=" + GUIUtils.getBooleanValueR(this.rotateVarsCheckBox) + ", center=" + GUIUtils.getBooleanValueR(this.centerZeroCheckBox) + ", scale=" + GUIUtils.getBooleanValueR(this.scaleUnitVarCheckBox) + ", rotation=" + rotation + ", scores=" + scores + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('pca.fa.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.refreshDataLists();
    }
}

