% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{Plot_MarkersHeatmap}
\alias{Plot_MarkersHeatmap}
\title{Plot Markers in each cell type}
\usage{
Plot_MarkersHeatmap(
  ConservedMarker,
  start_col = 2,
  module_colors = NA,
  heatmap_colors = NA,
  cluster_rows = FALSE,
  cluster_cols = FALSE,
  show_rownames = FALSE,
  show_colnames = FALSE,
  cellwidth = NA,
  cellheight = NA,
  legend = FALSE,
  annotation_legend = FALSE,
  annotation_names_row = FALSE,
  ...
)
}
\arguments{
\item{ConservedMarker}{Markers table}

\item{start_col}{numeric, indicating the start column of marker power in each
cell type}

\item{module_colors}{vector, indicating colors of modules (annotation_colors)}

\item{heatmap_colors}{vector, indicating colors used in heatmap}

\item{cluster_rows}{boolean values determining if rows should be clustered or
hclust object}

\item{cluster_cols}{boolean values determining if columns should be clustered
or hclust object}

\item{show_rownames}{boolean specifying if column names are be shown}

\item{show_colnames}{boolean specifying if column names are be shown}

\item{cellwidth}{individual cell width in points. If left as NA, then the
values depend on the size of plotting window}

\item{cellheight}{individual cell height in points. If left as NA, then the
values depend on the size of plotting window}

\item{legend}{logical to determine if legend should be drawn or not}

\item{annotation_legend}{boolean value showing if the legend for annotation
tracks should be drawn}

\item{annotation_names_row}{boolean value showing if the names for row
annotation tracks should be drawn}

\item{...}{parameter in pheatmap}
}
\value{
pheatmap object
}
\description{
This function integrate R package pheatmap to plot markers in each
cell type
}
\examples{
data("pbmc_small")
all.markers <- Identify_Markers(pbmc_small)
all.markers <- Format_Markers_Frac(all.markers)
Plot_MarkersHeatmap(all.markers[,c(2,6,7,8)])
}
