% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceResample.R
\name{performanceResample}
\alias{performanceResample}
\title{Uncertainty About Performance of a Classifier (EXPERIMENTAL)}
\usage{
performanceResample(
  object,
  data = NULL,
  name.response = NULL,
  type.resampling = "permutation",
  n.resampling = 1000,
  fold.repetition = 0,
  conf.level = 0.95,
  cpus = 1,
  seed = NULL,
  trace = TRUE,
  filename = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{glm} or \code{range} object, or a list of such object.}

\item{data}{[data.frame] the training data.}

\item{name.response}{[character] The name of the response variable (i.e. the one containing the categories).}

\item{type.resampling}{[character] Should non-parametric bootstrap (\code{"bootstrap"}) or permutation of the outcome (\code{"permutation"}) be used.}

\item{n.resampling}{[integer,>0] Nnumber of bootstrap samples or permutations.}

\item{fold.repetition}{[integer,>0] Nnumber of folds used in the cross-validation. Should be strictly positive.}

\item{conf.level}{[numeric, 0-1] confidence level for the confidence intervals.}

\item{cpus}{[integer, >0] the number of CPU to use. If strictly greater than 1, resampling is perform in parallel.}

\item{seed}{[integer, >0] seed used to ensure reproducibility.}

\item{trace}{[logical] Should the execution of the function be traced.}

\item{filename}{[character] Prefix for the files containing each result.}

\item{...}{arguments passed to \code{\link{performance}}.}
}
\description{
Use resampling to quantify uncertainties about the performance of one or several binary classifiers evaluated via cross-validation.
}
\details{
WARNING: using bootstrap after cross-validation may not provide valid variance/CI/p-value estimates.
}
