% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseTTEM.R
\name{BuyseTTEM}
\alias{BuyseTTEM}
\alias{BuyseTTEM.formula}
\alias{BuyseTTEM.prodlim}
\alias{BuyseTTEM.BuyseTTEM}
\title{Time to Event Model}
\usage{
BuyseTTEM(object, ...)

\method{BuyseTTEM}{formula}(
  object,
  treatment,
  level.treatment = NULL,
  iid,
  iid.surv = "exp",
  ...
)

\method{BuyseTTEM}{prodlim}(
  object,
  treatment,
  level.treatment = NULL,
  iid,
  iid.surv = "exp",
  ...
)

\method{BuyseTTEM}{BuyseTTEM}(object, ...)
}
\arguments{
\item{object}{time to event model.}

\item{...}{additional arguments passed to lower lever methods.}

\item{treatment}{[character] Name of the treatment variable.}

\item{level.treatment}{[character/numeric vector] Unique values of the treatment variable.}

\item{iid}{[logical] Should the iid decomposition of the predictions be output.}

\item{iid.surv}{[character] Estimator of the survival used when computing the influence function.
Can be the product limit estimator (\code{"prodlim"}) or an exponential approximation (\code{"exp"}, same as in \code{riskRegression::predictCoxPL}).}
}
\description{
Pre-compute quantities of a time to event model useful for predictions.
Only does something for prodlim objects.
}
\examples{
library(prodlim)
library(data.table)

#### survival case ####
set.seed(10)
df.data <- simBuyseTest(1e2, n.strata = 2)

e.prodlim <- prodlim(Hist(eventtime,status)~treatment+strata, data = df.data)
## plot(e.prodlim)

e.prodlim2 <- BuyseTTEM(e.prodlim,
          treatment = "treatment",
          level.treatment = unique(df.data$treatment),
          iid = TRUE)
predict(e.prodlim2, time = 1:10, treatment = "T", strata = "a")
predict(e.prodlim, times = 1:10, newdata = data.frame(treatment = "T", strata = "a"))

predict(e.prodlim2, time = 1:10, treatment = "C", strata = "a")
predict(e.prodlim, times = 1:10, newdata = data.frame(treatment = "C", strata = "a"))

#### competing risk case ####
df.dataCR <- copy(df.data)
df.dataCR$status <- rbinom(NROW(df.dataCR), prob = 0.5, size = 2)

e.prodlimCR <- prodlim(Hist(eventtime,status)~treatment+strata, data = df.dataCR)
## plot(e.prodlimCR)

e.prodlimCR <- BuyseTTEM(e.prodlimCR,
          treatment = "treatment",
          level.treatment = unique(df.dataCR$treatment),
          iid = TRUE)
}
