% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCT_simul.R
\name{Simulation function}
\alias{Simulation function}
\alias{simulBT}
\alias{simulBT_TTE}
\alias{simulBT_bin}
\alias{simulBT_cont}
\title{Simulation of data for the BuyseTest}
\usage{
simulBT(n.T, n.C = NULL, n.strata = NULL, format = "data.table",
  argsBin = list(), argsCont = list(), argsTTE = list())

simulBT_bin(n.T, n.C = NULL, p.T = 0.5, p.C = NULL, n.strata = NULL,
  format = "data.table")

simulBT_cont(n.T, n.C = NULL, mu.T = 0, sigma.T = 1, mu.C = NULL,
  sigma.C = NULL, n.strata = NULL, format = "data.table")

simulBT_TTE(n.T, n.C = NULL, rates.T = 2, rates.C = NULL,
  rates.Censor = 1, n.strata = NULL, sigma.C = NULL,
  format = "data.table")
}
\arguments{
\item{n.T}{number of patients in the treatment arm}

\item{n.C}{number of patients in the control arm}

\item{n.strata}{number of strata. \code{NULL} indicates no strata}

\item{format}{the format of the output. Can be "data.table", "data.frame" or "matrix"}

\item{argsBin}{a list of arguments to be passed to simulBT_bin. They specify the distribution parameters of the binary endpoints}

\item{argsCont}{a list of arguments to be passed to simulBT_continous. They specify the distribution parameters of the continuous endpoints}

\item{argsTTE}{a list of arguments to be passed to simulBT_TTE. They specify the distribution parameters of the time to event endpoints}

\item{p.T}{probability of event of each endpoint (binary endpoint, treatment group)}

\item{p.C}{same as \code{p.T} but for the control group}

\item{mu.T}{expected value of each endpoint (continuous endpoint, treatment group)}

\item{sigma.T}{standard deviation of the values of each endpoint (continuous endpoint, treatment group)}

\item{mu.C}{same as \code{mu.C} but for the control group}

\item{sigma.C}{same as \code{sigma.T} but for the control group}

\item{rates.T}{hazard corresponding to each endpoint (time to event endpoint, treatment group)}

\item{rates.C}{same as \code{rates.T} but for the control group}

\item{rates.Censor}{same as \code{rates.T} but for the censoring.}
}
\description{
Simulate binary, continuous or time to event data, possibly with strata.
}
\details{
Built on the lvm and sim functions from the lava package.
}
\examples{
simulBT(1e3)
simulBT(1e3, argsBin = list(p.T = c(3:5/10)), argsCont = NULL, argsTTE = NULL)
simulBT(1e3, argsBin = NULL, argsCont = list(mu.T = c(3:5/10), sigma.T = rep(1,3)), argsTTE = NULL)
simulBT(1e3, argsBin = NULL, argsCont = NULL, 
        argsTTE = list(rates.T = c(3:5/10), rates.Censor = rep(1,3)))

}
\keyword{function}
\keyword{simulations}

