#' @title Afrixalus delicatus genetic groups
#' @description Raster data representing interpolated genetic group assignments for Afrixalus delicatus
#' based on analyses in Barratt et al. 2018.
#' @docType data
#' @usage data(A.delicatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4210 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.delicatus_matrix'

#' @title Afrixalus delicatus genetic groups extent
#' @description Extent for A.delicatus_matrix
#' @docType data
#' @usage data(A.delicatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.delicatus_ext'

#' @title Afrixalus delicatus genetic groups projection
#' @description Projection for A.delicatus_matrix
#' @docType data
#' @usage data(A.delicatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.delicatus_crs'

#' @title Afrixalus sylvaticus genetic groups
#' @description Raster data representing interpolated genetic group assignments for Afrixalus sylvaticus
#' based on analyses in Barratt et al. 2018.
#' @docType data
#' @usage data(A.sylvaticus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4210 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.sylvaticus_matrix'

#' @title Afrixalus sylvaticus genetic groups extent
#' @description Extent for A.sylvaticus_matrix
#' @docType data
#' @usage data(A.sylvaticus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.sylvaticus_ext'

#' @title Afrixalus sylvaticus genetic groups projection
#' @description Projection for A.sylvaticus_matrix
#' @docType data
#' @usage data(A.sylvaticus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'A.sylvaticus_crs'

#' @title Leptopelis concolor genetic groups
#' @description Raster data representing interpolated genetic group assignments for Leptopelis concolor
#' based on analyses in Barratt et al. 2018.
#' @docType data
#' @usage data(L.concolor)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4210 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.concolor_matrix'

#' @title Leptopelis concolor genetic groups extent
#' @description Extent for L.concolor_matrix
#' @docType data
#' @usage data(L.concolor)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.concolor_ext'

#' @title Leptopelis concolor genetic groups projection
#' @description Projection 
#' @docType data
#' @usage data(L.concolor)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.concolor_crs'

#' @title Leptopelis flavomaculatus genetic groups
#' @description Raster data representing interpolated genetic group assignments for Leptopelis flavomaculatus
#' based on analyses in Barratt et al. 2018.
#' @docType data
#' @usage data(L.flavomaculatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4210 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.flavomaculatus_matrix'

#' @title Leptopelis flavomaculatus genetic groups extent
#' @description Extent for L.flavomaculatus_ext
#' @docType data
#' @usage data(L.flavomaculatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.flavomaculatus_ext'

#' @title Leptopelis flavomaculatus genetic groups projection
#' @description Projection for L.flavomaculatus_matrix
#' @docType data
#' @usage data(L.flavomaculatus)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'L.flavomaculatus_crs'

#' @title Ecoregion data for East Africa
#' @description Raster data of ecoregions in East Africa
#' @docType data
#' @usage data(ecoregions)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4210 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'ecoregions_matrix'

#' @title Ecoregion data for East Africa extent
#' @description Extent for ecoregions_matrix
#' @docType data
#' @usage data(ecoregions)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'ecoregions_ext'

#' @title Ecoregion data for East Africa projection
#' @description Projection for ecoregions_matrix
#' @docType data
#' @usage data(ecoregions)
#' @references Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.315km76}
'ecoregions_crs'

#' @title Grassland land cover 
#' @description Raster land cover data from the LifeWatch Wallonia-Brussels ecotope database and used in Cox et al. 2023. Downsampled to match T. cristatus raster
#' @docType data
#' @usage data(grassland)
#' @references
#' Cox et al. (2023) Conservation Genetics
#' Radoux et al. (2019) Remote Sens 11:354.
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4326 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'grassland_matrix'

#' @title Grassland land cover extent
#' @description Extent for grassland_matrix
#' @docType data
#' @usage data(grassland)
#' @references
#' Cox et al. (2023) Conservation Genetics
#' Radoux et al. (2019) Remote Sens 11:354.
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'grassland_ext'

#' @title Grassland land cover projection
#' @description Projection for grassland_matrix
#' @docType data
#' @usage data(grassland)
#' @references
#' Cox et al. (2023) Conservation Genetics
#' Radoux et al. (2019) Remote Sens 11:354.
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'grassland_crs'

#' @title Triturus cristatus genetic groups
#' @description Raster data representing interpolated genetic group assignments for Triturus cristatus
#' based on analyses in Cox et al. 2023
#' @docType data
#' @usage data(T.cristatus)
#' @references Cox et al. (2023) Conservation Genetics
#' @format A matrix to be converted into a SpatRaster object with a EPSG:4326 projection.
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'T.cristatus_matrix'

#' @title Triturus cristatus genetic groups extent
#' @description Extent for T.cristatus_matrix
#' @docType data
#' @usage data(T.cristatus)
#' @references Cox et al. (2023) Conservation Genetics
#' @format Numeric vector of length length 4
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'T.cristatus_ext'

#' @title Triturus cristatus genetic groups projection
#' @description Projection for T.cristatus_matrix
#' @docType data
#' @usage data(T.cristatus)
#' @references Cox et al. (2023) Conservation Genetics
#' @format ces Barratt et al. (2013) Molecular Ecology 27:4289–4308
#' @format Projection crs object
#' @keywords datasets
#' @source \doi{10.5061/dryad.bk3j9kdhz}
'T.cristatus_crs'