% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoltzMM.R
\name{fvbmtests}
\alias{fvbmtests}
\title{Hypothesis testing for a fully-visible Boltzmann machine.}
\usage{
fvbmtests(data, model, nullmodel)
}
\arguments{
\item{data}{An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).}

\item{model}{List generated from \code{fitfvbm}.}

\item{nullmodel}{A list containing two elements: a vector of length n \code{bvec}, and an n by n matrix \code{Mmat}. A list generated by \code{fitfvbm} is also sufficient.}
}
\value{
A list containing 4 objects: a vector containing the z-scores corresponding to the bias parameters \code{bvec_z},a vector containing the p-values corresponding to the bias parameters \code{bvec_p},a matrix containing the z-scores corresponding to the interaction parameters \code{Mmat_z},  and a matrix containing the standard errors corresponding to the interaction parameters \code{Mmat_p}.
}
\description{
Tests the hypothesis that the true bias and interaction parameter values are those in \code{nullmodel}, given \code{data} and \code{model}.
}
\examples{
# Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
num <- 1000; bvec <- c(0,0.5,0.25); Mmat <- matrix(0.1,3,3) - diag(0.1,3,3);
data <- rfvbm(num,bvec,Mmat)
# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
model <- fitfvbm(data,bvec,Mmat)

#Propose a null hypothesis model
nullmodel <- list(bvec = c(0,0,0), Mmat = matrix(0,3,3))

# Compute z-scores
fvbmtests(data,model,nullmodel)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
