% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatSim.R
\name{spatSim}
\alias{spatSim}
\title{Computes spatial dissimilarity of two point processes.}
\usage{
spatSim(MOD0, MOD2, WINDOW, R)
}
\arguments{
\item{MOD0}{data frame containing 'y' and 'x' coordinates (projected coordinate system) to compare with MOD2.}

\item{MOD2}{data frame containing 'y' and 'x' coordinates (projected coordinate system) to compare with MOD0.}

\item{WINDOW}{window of observation of the point patterns (MOD0 and MOD2)(see ?spatstat.geom::owin).Must be an object of class 'owin'.}

\item{R}{numeric vector of searc distances for the K-function.}
}
\value{
squared sum of distances between K-functions. This is a measure of spatial dissimilarity.
}
\description{
This function uses Ripley's K-function (see Details) to compute spatial dissimilarity of two point processes.
}
\examples{
ran<- data.frame('y'=sample(1000),'x'=sample(1000))
nor<- data.frame('y'=rnorm(1000,sd=150,mean=500),'x'=rnorm(1000,sd=150,mean=500))
window<-  spatstat.geom::owin(xrange=c(0,1000),yrange=c(0,1000))
spatSim(ran, nor, WINDOW= window, R=0:200)
}
\author{
Luca Butikofer
}
