% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectBarnes.R
\name{detectBarnes}
\alias{detectBarnes}
\title{Detect Circles in a Maze Image}
\usage{
detectBarnes(im, boardRadius, holeRadius, sigma = 25, plot = TRUE)
}
\arguments{
\item{im}{A matrix representing the image where the circles will be detected.}

\item{boardRadius}{The expected radius of the board circles.}

\item{holeRadius}{The expected radius of the hole circles.}

\item{sigma}{An optional parameter that controls the standard deviation for the
Gaussian filter used in edge detection (default value is 25).}

\item{plot}{Opcion of plot}
}
\value{
A list containing:
\item{c1}{Coordinates of the detected board circle.}
\item{boardRadius}{Radius of the board circle.}
\item{c2}{A list of coordinates representing the detected hole circles.}
\item{holeRadius}{Radius of the hole circles.}
}
\description{
The function first applies the Canny edge detection algorithm to the input image.
It then detects circles corresponding to the board and holes using the
\code{detectCircles} function. The function filters the detected hole circles
based on their distance from the board circle, ensuring they fall within acceptable
ranges relative to the specified radii. Finally, it calculates the median radius
and angle differences of the remaining circles and constructs a circular representation
for the holes based on these parameters.
}
\details{
Detects circles representing boards and holes in a given image of a maze.
It utilizes edge detection to identify potential circle patterns based on specified
radius parameters. The function returns the detected circles' coordinates, along
with additional information about the board and hole radii.
}
\examples{
path <- system.file('extdata/data.tiff', package='BioTrajectory')
im <- tiff::readTIFF(path)
im <- imager::as.cimg(t(im[,,1]))
Barnes <- detectBarnes(im, boardRadius=207, holeRadius=13, sigma=25)
}
