# Whole workflow works consistently

    Code
      set.seed(42)
      gridding(meta, btf) %>% resampling(measure = "ABUNDANCE", resamps = 1L) %>%
        getAlphaMetrics(measure = "ABUNDANCE") %>% getLinearRegressions(divType = "alpha")
    Message
      OK: all SL studies have 1 grid cell
    Output
            assemblageID YEAR     metric    diversity         slope       pvalue
      1        10_358678 1984          S 2.100000e+01 -1.785714e-01 2.122956e-01
      2        10_358678 1984          N 2.487000e+03 -7.189286e+01 2.197963e-01
      3        10_358678 1984       maxN 1.307000e+03 -3.475000e+01 2.879824e-01
      4        10_358678 1984    Shannon 1.641701e+00 -4.368307e-03 2.479066e-01
      5        10_358678 1984    Simpson 6.793687e-01 -1.431730e-03 4.797958e-01
      6        10_358678 1984 invSimpson 3.118847e+00 -1.308772e-02 4.814418e-01
      7        10_358678 1984        PIE 6.796419e-01 -1.420891e-03 4.834093e-01
      8        10_358678 1984      DomMc 6.726980e-01  6.400405e-04 1.880501e-01
      9        10_358678 1984 expShannon 5.163944e+00 -2.196319e-02 2.435039e-01
      10       10_358678 1992          S 1.900000e+01 -1.785714e-01 2.122956e-01
      11       10_358678 1992          N 1.673000e+03 -7.189286e+01 2.197963e-01
      12       10_358678 1992       maxN 8.730000e+02 -3.475000e+01 2.879824e-01
      13       10_358678 1992    Shannon 1.623314e+00 -4.368307e-03 2.479066e-01
      14       10_358678 1992    Simpson 6.803267e-01 -1.431730e-03 4.797958e-01
      15       10_358678 1992 invSimpson 3.128193e+00 -1.308772e-02 4.814418e-01
      16       10_358678 1992        PIE 6.807335e-01 -1.420891e-03 4.834093e-01
      17       10_358678 1992      DomMc 6.796175e-01  6.400405e-04 1.880501e-01
      18       10_358678 1992 expShannon 5.069862e+00 -2.196319e-02 2.435039e-01
      19       10_358678 1996          S 1.900000e+01 -1.785714e-01 2.122956e-01
      20       10_358678 1996          N 1.684000e+03 -7.189286e+01 2.197963e-01
      21       10_358678 1996       maxN 9.290000e+02 -3.475000e+01 2.879824e-01
      22       10_358678 1996    Shannon 1.585141e+00 -4.368307e-03 2.479066e-01
      23       10_358678 1996    Simpson 6.590849e-01 -1.431730e-03 4.797958e-01
      24       10_358678 1996 invSimpson 2.933282e+00 -1.308772e-02 4.814418e-01
      25       10_358678 1996        PIE 6.594766e-01 -1.420891e-03 4.834093e-01
      26       10_358678 1996      DomMc 6.799287e-01  6.400405e-04 1.880501e-01
      27       10_358678 1996 expShannon 4.879980e+00 -2.196319e-02 2.435039e-01
      28       18_335239 1945          S 3.700000e+01  6.735075e-02 4.421083e-01
      29       18_335239 1945          N 1.206000e+03  3.304506e+00 5.516348e-01
      30       18_335239 1945       maxN 2.570000e+02 -4.144869e-01 7.257293e-01
      31       18_335239 1945    Shannon 2.483182e+00  7.982316e-03 3.299430e-02
      32       18_335239 1945    Simpson 8.770341e-01  2.568415e-03 1.698999e-02
      33       18_335239 1945 invSimpson 8.132337e+00  7.466726e-02 1.073217e-02
      34       18_335239 1945        PIE 8.777620e-01  2.560995e-03 1.685206e-02
      35       18_335239 1945      DomMc 4.112769e-01 -3.810339e-03 4.658881e-03
      36       18_335239 1945 expShannon 1.197932e+01  6.996207e-02 3.978648e-02
      37       18_335239 1933          S 2.400000e+01  6.735075e-02 4.421083e-01
      38       18_335239 1933          N 4.900000e+02  3.304506e+00 5.516348e-01
      39       18_335239 1933       maxN 1.480000e+02 -4.144869e-01 7.257293e-01
      40       18_335239 1933    Shannon 2.399647e+00  7.982316e-03 3.299430e-02
      41       18_335239 1933    Simpson 8.582757e-01  2.568415e-03 1.698999e-02
      42       18_335239 1933 invSimpson 7.055954e+00  7.466726e-02 1.073217e-02
      43       18_335239 1933        PIE 8.600309e-01  2.560995e-03 1.685206e-02
      44       18_335239 1933      DomMc 4.346939e-01 -3.810339e-03 4.658881e-03
      45       18_335239 1933 expShannon 1.101929e+01  6.996207e-02 3.978648e-02
      46       18_335239 1935          S 3.200000e+01  6.735075e-02 4.421083e-01
      47       18_335239 1935          N 5.540000e+02  3.304506e+00 5.516348e-01
      48       18_335239 1935       maxN 1.520000e+02 -4.144869e-01 7.257293e-01
      49       18_335239 1935    Shannon 2.454193e+00  7.982316e-03 3.299430e-02
      50       18_335239 1935    Simpson 8.520898e-01  2.568415e-03 1.698999e-02
      51       18_335239 1935 invSimpson 6.760860e+00  7.466726e-02 1.073217e-02
      52       18_335239 1935        PIE 8.536307e-01  2.560995e-03 1.685206e-02
      53       18_335239 1935      DomMc 5.000000e-01 -3.810339e-03 4.658881e-03
      54       18_335239 1935 expShannon 1.163704e+01  6.996207e-02 3.978648e-02
      55       18_335239 1936          S 3.500000e+01  6.735075e-02 4.421083e-01
      56       18_335239 1936          N 1.404000e+03  3.304506e+00 5.516348e-01
      57       18_335239 1936       maxN 3.350000e+02 -4.144869e-01 7.257293e-01
      58       18_335239 1936    Shannon 2.561273e+00  7.982316e-03 3.299430e-02
      59       18_335239 1936    Simpson 8.806868e-01  2.568415e-03 1.698999e-02
      60       18_335239 1936 invSimpson 8.381305e+00  7.466726e-02 1.073217e-02
      61       18_335239 1936        PIE 8.813146e-01  2.560995e-03 1.685206e-02
      62       18_335239 1936      DomMc 4.237892e-01 -3.810339e-03 4.658881e-03
      63       18_335239 1936 expShannon 1.295230e+01  6.996207e-02 3.978648e-02
      64       18_335239 1937          S 2.400000e+01  6.735075e-02 4.421083e-01
      65       18_335239 1937          N 5.250000e+02  3.304506e+00 5.516348e-01
      66       18_335239 1937       maxN 1.080000e+02 -4.144869e-01 7.257293e-01
      67       18_335239 1937    Shannon 2.438410e+00  7.982316e-03 3.299430e-02
      68       18_335239 1937    Simpson 8.786866e-01  2.568415e-03 1.698999e-02
      69       18_335239 1937 invSimpson 8.243114e+00  7.466726e-02 1.073217e-02
      70       18_335239 1937        PIE 8.803635e-01  2.560995e-03 1.685206e-02
      71       18_335239 1937      DomMc 4.095238e-01 -3.810339e-03 4.658881e-03
      72       18_335239 1937 expShannon 1.145481e+01  6.996207e-02 3.978648e-02
      73       18_335239 1940          S 3.300000e+01  6.735075e-02 4.421083e-01
      74       18_335239 1940          N 9.230000e+02  3.304506e+00 5.516348e-01
      75       18_335239 1940       maxN 2.350000e+02 -4.144869e-01 7.257293e-01
      76       18_335239 1940    Shannon 2.385848e+00  7.982316e-03 3.299430e-02
      77       18_335239 1940    Simpson 8.610882e-01  2.568415e-03 1.698999e-02
      78       18_335239 1940 invSimpson 7.198812e+00  7.466726e-02 1.073217e-02
      79       18_335239 1940        PIE 8.620221e-01  2.560995e-03 1.685206e-02
      80       18_335239 1940      DomMc 4.333694e-01 -3.810339e-03 4.658881e-03
      81       18_335239 1940 expShannon 1.086828e+01  6.996207e-02 3.978648e-02
      82       18_335239 1954          S 1.900000e+01  6.735075e-02 4.421083e-01
      83       18_335239 1954          N 3.480000e+02  3.304506e+00 5.516348e-01
      84       18_335239 1954       maxN 8.100000e+01 -4.144869e-01 7.257293e-01
      85       18_335239 1954    Shannon 2.423726e+00  7.982316e-03 3.299430e-02
      86       18_335239 1954    Simpson 8.845951e-01  2.568415e-03 1.698999e-02
      87       18_335239 1954 invSimpson 8.665140e+00  7.466726e-02 1.073217e-02
      88       18_335239 1954        PIE 8.871443e-01  2.560995e-03 1.685206e-02
      89       18_335239 1954      DomMc 3.534483e-01 -3.810339e-03 4.658881e-03
      90       18_335239 1954 expShannon 1.128784e+01  6.996207e-02 3.978648e-02
      91       18_335239 1950          S 2.400000e+01  6.735075e-02 4.421083e-01
      92       18_335239 1950          N 7.160000e+02  3.304506e+00 5.516348e-01
      93       18_335239 1950       maxN 2.140000e+02 -4.144869e-01 7.257293e-01
      94       18_335239 1950    Shannon 2.322021e+00  7.982316e-03 3.299430e-02
      95       18_335239 1950    Simpson 8.519865e-01  2.568415e-03 1.698999e-02
      96       18_335239 1950 invSimpson 6.756141e+00  7.466726e-02 1.073217e-02
      97       18_335239 1950        PIE 8.531781e-01  2.560995e-03 1.685206e-02
      98       18_335239 1950      DomMc 4.483240e-01 -3.810339e-03 4.658881e-03
      99       18_335239 1950 expShannon 1.019626e+01  6.996207e-02 3.978648e-02
      100      18_335239 1955          S 3.000000e+01  6.735075e-02 4.421083e-01
      101      18_335239 1955          N 7.320000e+02  3.304506e+00 5.516348e-01
      102      18_335239 1955       maxN 2.450000e+02 -4.144869e-01 7.257293e-01
      103      18_335239 1955    Shannon 2.345554e+00  7.982316e-03 3.299430e-02
      104      18_335239 1955    Simpson 8.402572e-01  2.568415e-03 1.698999e-02
      105      18_335239 1955 invSimpson 6.260065e+00  7.466726e-02 1.073217e-02
      106      18_335239 1955        PIE 8.414067e-01  2.560995e-03 1.685206e-02
      107      18_335239 1955      DomMc 4.617486e-01 -3.810339e-03 4.658881e-03
      108      18_335239 1955 expShannon 1.043906e+01  6.996207e-02 3.978648e-02
      109      18_335239 1973          S 2.500000e+01  6.735075e-02 4.421083e-01
      110      18_335239 1973          N 3.480000e+02  3.304506e+00 5.516348e-01
      111      18_335239 1973       maxN 7.500000e+01 -4.144869e-01 7.257293e-01
      112      18_335239 1973    Shannon 2.514600e+00  7.982316e-03 3.299430e-02
      113      18_335239 1973    Simpson 8.806646e-01  2.568415e-03 1.698999e-02
      114      18_335239 1973 invSimpson 8.379740e+00  7.466726e-02 1.073217e-02
      115      18_335239 1973        PIE 8.832025e-01  2.560995e-03 1.685206e-02
      116      18_335239 1973      DomMc 4.051724e-01 -3.810339e-03 4.658881e-03
      117      18_335239 1973 expShannon 1.236166e+01  6.996207e-02 3.978648e-02
      118      18_335239 1923          S 2.300000e+01  6.735075e-02 4.421083e-01
      119      18_335239 1923          N 3.450000e+02  3.304506e+00 5.516348e-01
      120      18_335239 1923       maxN 1.000000e+02 -4.144869e-01 7.257293e-01
      121      18_335239 1923    Shannon 2.534819e+00  7.982316e-03 3.299430e-02
      122      18_335239 1923    Simpson 8.749422e-01  2.568415e-03 1.698999e-02
      123      18_335239 1923 invSimpson 7.996305e+00  7.466726e-02 1.073217e-02
      124      18_335239 1923        PIE 8.774857e-01  2.560995e-03 1.685206e-02
      125      18_335239 1923      DomMc 4.173913e-01 -3.810339e-03 4.658881e-03
      126      18_335239 1923 expShannon 1.261415e+01  6.996207e-02 3.978648e-02
      127      18_335239 1926          S 2.300000e+01  6.735075e-02 4.421083e-01
      128      18_335239 1926          N 2.990000e+02  3.304506e+00 5.516348e-01
      129      18_335239 1926       maxN 1.130000e+02 -4.144869e-01 7.257293e-01
      130      18_335239 1926    Shannon 2.262727e+00  7.982316e-03 3.299430e-02
      131      18_335239 1926    Simpson 8.160983e-01  2.568415e-03 1.698999e-02
      132      18_335239 1926 invSimpson 5.437686e+00  7.466726e-02 1.073217e-02
      133      18_335239 1926        PIE 8.188368e-01  2.560995e-03 1.685206e-02
      134      18_335239 1926      DomMc 5.050167e-01 -3.810339e-03 4.658881e-03
      135      18_335239 1926 expShannon 9.609255e+00  6.996207e-02 3.978648e-02
      136      18_335239 1927          S 1.900000e+01  6.735075e-02 4.421083e-01
      137      18_335239 1927          N 2.210000e+02  3.304506e+00 5.516348e-01
      138      18_335239 1927       maxN 1.100000e+02 -4.144869e-01 7.257293e-01
      139      18_335239 1927    Shannon 1.940792e+00  7.982316e-03 3.299430e-02
      140      18_335239 1927    Simpson 7.234496e-01  2.568415e-03 1.698999e-02
      141      18_335239 1927 invSimpson 3.615977e+00  7.466726e-02 1.073217e-02
      142      18_335239 1927        PIE 7.267380e-01  2.560995e-03 1.685206e-02
      143      18_335239 1927      DomMc 6.108597e-01 -3.810339e-03 4.658881e-03
      144      18_335239 1927 expShannon 6.964262e+00  6.996207e-02 3.978648e-02
      145      18_335239 1929          S 2.200000e+01  6.735075e-02 4.421083e-01
      146      18_335239 1929          N 3.620000e+02  3.304506e+00 5.516348e-01
      147      18_335239 1929       maxN 1.950000e+02 -4.144869e-01 7.257293e-01
      148      18_335239 1929    Shannon 1.813147e+00  7.982316e-03 3.299430e-02
      149      18_335239 1929    Simpson 6.832514e-01  2.568415e-03 1.698999e-02
      150      18_335239 1929 invSimpson 3.157078e+00  7.466726e-02 1.073217e-02
      151      18_335239 1929        PIE 6.851441e-01  2.560995e-03 1.685206e-02
      152      18_335239 1929      DomMc 6.436464e-01 -3.810339e-03 4.658881e-03
      153      18_335239 1929 expShannon 6.129705e+00  6.996207e-02 3.978648e-02
      154      18_335239 1930          S 2.300000e+01  6.735075e-02 4.421083e-01
      155      18_335239 1930          N 4.580000e+02  3.304506e+00 5.516348e-01
      156      18_335239 1930       maxN 1.530000e+02 -4.144869e-01 7.257293e-01
      157      18_335239 1930    Shannon 2.101858e+00  7.982316e-03 3.299430e-02
      158      18_335239 1930    Simpson 8.155737e-01  2.568415e-03 1.698999e-02
      159      18_335239 1930 invSimpson 5.422220e+00  7.466726e-02 1.073217e-02
      160      18_335239 1930        PIE 8.173583e-01  2.560995e-03 1.685206e-02
      161      18_335239 1930      DomMc 5.262009e-01 -3.810339e-03 4.658881e-03
      162      18_335239 1930 expShannon 8.181357e+00  6.996207e-02 3.978648e-02
      163      18_335239 1932          S 1.900000e+01  6.735075e-02 4.421083e-01
      164      18_335239 1932          N 2.870000e+02  3.304506e+00 5.516348e-01
      165      18_335239 1932       maxN 8.400000e+01 -4.144869e-01 7.257293e-01
      166      18_335239 1932    Shannon 2.334677e+00  7.982316e-03 3.299430e-02
      167      18_335239 1932    Simpson 8.581141e-01  2.568415e-03 1.698999e-02
      168      18_335239 1932 invSimpson 7.047916e+00  7.466726e-02 1.073217e-02
      169      18_335239 1932        PIE 8.611145e-01  2.560995e-03 1.685206e-02
      170      18_335239 1932      DomMc 4.494774e-01 -3.810339e-03 4.658881e-03
      171      18_335239 1932 expShannon 1.032612e+01  6.996207e-02 3.978648e-02
      172      18_335239 1934          S 2.000000e+01  6.735075e-02 4.421083e-01
      173      18_335239 1934          N 2.410000e+02  3.304506e+00 5.516348e-01
      174      18_335239 1934       maxN 1.420000e+02 -4.144869e-01 7.257293e-01
      175      18_335239 1934    Shannon 1.808111e+00  7.982316e-03 3.299430e-02
      176      18_335239 1934    Simpson 6.404504e-01  2.568415e-03 1.698999e-02
      177      18_335239 1934 invSimpson 2.781257e+00  7.466726e-02 1.073217e-02
      178      18_335239 1934        PIE 6.431189e-01  2.560995e-03 1.685206e-02
      179      18_335239 1934      DomMc 6.514523e-01 -3.810339e-03 4.658881e-03
      180      18_335239 1934 expShannon 6.098919e+00  6.996207e-02 3.978648e-02
      181      18_335239 1938          S 2.100000e+01  6.735075e-02 4.421083e-01
      182      18_335239 1938          N 4.860000e+02  3.304506e+00 5.516348e-01
      183      18_335239 1938       maxN 1.060000e+02 -4.144869e-01 7.257293e-01
      184      18_335239 1938    Shannon 2.363522e+00  7.982316e-03 3.299430e-02
      185      18_335239 1938    Simpson 8.772460e-01  2.568415e-03 1.698999e-02
      186      18_335239 1938 invSimpson 8.146375e+00  7.466726e-02 1.073217e-02
      187      18_335239 1938        PIE 8.790548e-01  2.560995e-03 1.685206e-02
      188      18_335239 1938      DomMc 3.744856e-01 -3.810339e-03 4.658881e-03
      189      18_335239 1938 expShannon 1.062832e+01  6.996207e-02 3.978648e-02
      190      18_335239 1939          S 2.600000e+01  6.735075e-02 4.421083e-01
      191      18_335239 1939          N 6.500000e+02  3.304506e+00 5.516348e-01
      192      18_335239 1939       maxN 1.610000e+02 -4.144869e-01 7.257293e-01
      193      18_335239 1939    Shannon 2.443083e+00  7.982316e-03 3.299430e-02
      194      18_335239 1939    Simpson 8.738130e-01  2.568415e-03 1.698999e-02
      195      18_335239 1939 invSimpson 7.924748e+00  7.466726e-02 1.073217e-02
      196      18_335239 1939        PIE 8.751594e-01  2.560995e-03 1.685206e-02
      197      18_335239 1939      DomMc 4.246154e-01 -3.810339e-03 4.658881e-03
      198      18_335239 1939 expShannon 1.150847e+01  6.996207e-02 3.978648e-02
      199      18_335239 1941          S 2.800000e+01  6.735075e-02 4.421083e-01
      200      18_335239 1941          N 8.950000e+02  3.304506e+00 5.516348e-01
      201      18_335239 1941       maxN 2.730000e+02 -4.144869e-01 7.257293e-01
      202      18_335239 1941    Shannon 2.355142e+00  7.982316e-03 3.299430e-02
      203      18_335239 1941    Simpson 8.524778e-01  2.568415e-03 1.698999e-02
      204      18_335239 1941 invSimpson 6.778639e+00  7.466726e-02 1.073217e-02
      205      18_335239 1941        PIE 8.534313e-01  2.560995e-03 1.685206e-02
      206      18_335239 1941      DomMc 4.402235e-01 -3.810339e-03 4.658881e-03
      207      18_335239 1941 expShannon 1.053963e+01  6.996207e-02 3.978648e-02
      208      18_335239 1942          S 2.900000e+01  6.735075e-02 4.421083e-01
      209      18_335239 1942          N 1.177000e+03  3.304506e+00 5.516348e-01
      210      18_335239 1942       maxN 2.550000e+02 -4.144869e-01 7.257293e-01
      211      18_335239 1942    Shannon 2.461544e+00  7.982316e-03 3.299430e-02
      212      18_335239 1942    Simpson 8.814657e-01  2.568415e-03 1.698999e-02
      213      18_335239 1942 invSimpson 8.436377e+00  7.466726e-02 1.073217e-02
      214      18_335239 1942        PIE 8.822152e-01  2.560995e-03 1.685206e-02
      215      18_335239 1942      DomMc 4.069669e-01 -3.810339e-03 4.658881e-03
      216      18_335239 1942 expShannon 1.172289e+01  6.996207e-02 3.978648e-02
      217      18_335239 1946          S 3.200000e+01  6.735075e-02 4.421083e-01
      218      18_335239 1946          N 1.256000e+03  3.304506e+00 5.516348e-01
      219      18_335239 1946       maxN 2.590000e+02 -4.144869e-01 7.257293e-01
      220      18_335239 1946    Shannon 2.610930e+00  7.982316e-03 3.299430e-02
      221      18_335239 1946    Simpson 8.956854e-01  2.568415e-03 1.698999e-02
      222      18_335239 1946 invSimpson 9.586388e+00  7.466726e-02 1.073217e-02
      223      18_335239 1946        PIE 8.963991e-01  2.560995e-03 1.685206e-02
      224      18_335239 1946      DomMc 3.654459e-01 -3.810339e-03 4.658881e-03
      225      18_335239 1946 expShannon 1.361171e+01  6.996207e-02 3.978648e-02
      226      18_335239 1949          S 2.300000e+01  6.735075e-02 4.421083e-01
      227      18_335239 1949          N 6.380000e+02  3.304506e+00 5.516348e-01
      228      18_335239 1949       maxN 1.280000e+02 -4.144869e-01 7.257293e-01
      229      18_335239 1949    Shannon 2.366246e+00  7.982316e-03 3.299430e-02
      230      18_335239 1949    Simpson 8.755515e-01  2.568415e-03 1.698999e-02
      231      18_335239 1949 invSimpson 8.035455e+00  7.466726e-02 1.073217e-02
      232      18_335239 1949        PIE 8.769260e-01  2.560995e-03 1.685206e-02
      233      18_335239 1949      DomMc 3.949843e-01 -3.810339e-03 4.658881e-03
      234      18_335239 1949 expShannon 1.065731e+01  6.996207e-02 3.978648e-02
      235      18_335239 1951          S 2.600000e+01  6.735075e-02 4.421083e-01
      236      18_335239 1951          N 6.490000e+02  3.304506e+00 5.516348e-01
      237      18_335239 1951       maxN 1.680000e+02 -4.144869e-01 7.257293e-01
      238      18_335239 1951    Shannon 2.458757e+00  7.982316e-03 3.299430e-02
      239      18_335239 1951    Simpson 8.769780e-01  2.568415e-03 1.698999e-02
      240      18_335239 1951 invSimpson 8.128626e+00  7.466726e-02 1.073217e-02
      241      18_335239 1951        PIE 8.783313e-01  2.560995e-03 1.685206e-02
      242      18_335239 1951      DomMc 3.882897e-01 -3.810339e-03 4.658881e-03
      243      18_335239 1951 expShannon 1.169027e+01  6.996207e-02 3.978648e-02
      244      18_335239 1952          S 2.300000e+01  6.735075e-02 4.421083e-01
      245      18_335239 1952          N 3.990000e+02  3.304506e+00 5.516348e-01
      246      18_335239 1952       maxN 1.480000e+02 -4.144869e-01 7.257293e-01
      247      18_335239 1952    Shannon 2.227176e+00  7.982316e-03 3.299430e-02
      248      18_335239 1952    Simpson 8.203340e-01  2.568415e-03 1.698999e-02
      249      18_335239 1952 invSimpson 5.565885e+00  7.466726e-02 1.073217e-02
      250      18_335239 1952        PIE 8.223952e-01  2.560995e-03 1.685206e-02
      251      18_335239 1952      DomMc 4.812030e-01 -3.810339e-03 4.658881e-03
      252      18_335239 1952 expShannon 9.273643e+00  6.996207e-02 3.978648e-02
      253      18_335239 1956          S 2.500000e+01  6.735075e-02 4.421083e-01
      254      18_335239 1956          N 3.470000e+02  3.304506e+00 5.516348e-01
      255      18_335239 1956       maxN 8.400000e+01 -4.144869e-01 7.257293e-01
      256      18_335239 1956    Shannon 2.529108e+00  7.982316e-03 3.299430e-02
      257      18_335239 1956    Simpson 8.862627e-01  2.568415e-03 1.698999e-02
      258      18_335239 1956 invSimpson 8.792187e+00  7.466726e-02 1.073217e-02
      259      18_335239 1956        PIE 8.888241e-01  2.560995e-03 1.685206e-02
      260      18_335239 1956      DomMc 3.746398e-01 -3.810339e-03 4.658881e-03
      261      18_335239 1956 expShannon 1.254231e+01  6.996207e-02 3.978648e-02
      262      18_335239 1931          S 1.600000e+01  6.735075e-02 4.421083e-01
      263      18_335239 1931          N 3.420000e+02  3.304506e+00 5.516348e-01
      264      18_335239 1931       maxN 1.810000e+02 -4.144869e-01 7.257293e-01
      265      18_335239 1931    Shannon 1.758177e+00  7.982316e-03 3.299430e-02
      266      18_335239 1931    Simpson 6.902124e-01  2.568415e-03 1.698999e-02
      267      18_335239 1931 invSimpson 3.228018e+00  7.466726e-02 1.073217e-02
      268      18_335239 1931        PIE 6.922365e-01  2.560995e-03 1.685206e-02
      269      18_335239 1931      DomMc 6.403509e-01 -3.810339e-03 4.658881e-03
      270      18_335239 1931 expShannon 5.801852e+00  6.996207e-02 3.978648e-02
      271      18_335239 1947          S 2.100000e+01  6.735075e-02 4.421083e-01
      272      18_335239 1947          N 6.630000e+02  3.304506e+00 5.516348e-01
      273      18_335239 1947       maxN 1.850000e+02 -4.144869e-01 7.257293e-01
      274      18_335239 1947    Shannon 2.106072e+00  7.982316e-03 3.299430e-02
      275      18_335239 1947    Simpson 8.242983e-01  2.568415e-03 1.698999e-02
      276      18_335239 1947 invSimpson 5.691466e+00  7.466726e-02 1.073217e-02
      277      18_335239 1947        PIE 8.255435e-01  2.560995e-03 1.685206e-02
      278      18_335239 1947      DomMc 5.384615e-01 -3.810339e-03 4.658881e-03
      279      18_335239 1947 expShannon 8.215909e+00  6.996207e-02 3.978648e-02
      280      18_335239 1957          S 2.000000e+01  6.735075e-02 4.421083e-01
      281      18_335239 1957          N 2.890000e+02  3.304506e+00 5.516348e-01
      282      18_335239 1957       maxN 7.500000e+01 -4.144869e-01 7.257293e-01
      283      18_335239 1957    Shannon 2.341343e+00  7.982316e-03 3.299430e-02
      284      18_335239 1957    Simpson 8.708229e-01  2.568415e-03 1.698999e-02
      285      18_335239 1957 invSimpson 7.741311e+00  7.466726e-02 1.073217e-02
      286      18_335239 1957        PIE 8.738466e-01  2.560995e-03 1.685206e-02
      287      18_335239 1957      DomMc 3.944637e-01 -3.810339e-03 4.658881e-03
      288      18_335239 1957 expShannon 1.039518e+01  6.996207e-02 3.978648e-02
      289      41_452736 1923          S 4.600000e+01 -2.563657e-01 1.379129e-01
      290      41_452736 1923          N 1.420000e+02 -1.936343e+00 5.137263e-02
      291      41_452736 1923       maxN 1.200000e+01  4.328704e-01 1.559284e-02
      292      41_452736 1923    Shannon 3.542291e+00 -1.468300e-02 6.603122e-03
      293      41_452736 1923    Simpson 9.638961e-01 -1.257937e-03 1.818562e-03
      294      41_452736 1923 invSimpson 2.769780e+01 -6.612574e-01 4.743937e-04
      295      41_452736 1923        PIE 9.707322e-01 -1.139895e-03 3.169750e-03
      296      41_452736 1923      DomMc 1.408451e-01  7.400296e-03 1.927566e-04
      297      41_452736 1923 expShannon 3.454596e+01 -4.490074e-01 5.283188e-03
      298      41_452736 1924          S 4.600000e+01 -2.563657e-01 1.379129e-01
      299      41_452736 1924          N 1.450000e+02 -1.936343e+00 5.137263e-02
      300      41_452736 1924       maxN 1.000000e+01  4.328704e-01 1.559284e-02
      301      41_452736 1924    Shannon 3.603316e+00 -1.468300e-02 6.603122e-03
      302      41_452736 1924    Simpson 9.677051e-01 -1.257937e-03 1.818562e-03
      303      41_452736 1924 invSimpson 3.096465e+01 -6.612574e-01 4.743937e-04
      304      41_452736 1924        PIE 9.744253e-01 -1.139895e-03 3.169750e-03
      305      41_452736 1924      DomMc 1.241379e-01  7.400296e-03 1.927566e-04
      306      41_452736 1924 expShannon 3.671978e+01 -4.490074e-01 5.283188e-03
      307      41_452736 1926          S 4.100000e+01 -2.563657e-01 1.379129e-01
      308      41_452736 1926          N 1.330000e+02 -1.936343e+00 5.137263e-02
      309      41_452736 1926       maxN 9.000000e+00  4.328704e-01 1.559284e-02
      310      41_452736 1926    Shannon 3.478579e+00 -1.468300e-02 6.603122e-03
      311      41_452736 1926    Simpson 9.629713e-01 -1.257937e-03 1.818562e-03
      312      41_452736 1926 invSimpson 2.700611e+01 -6.612574e-01 4.743937e-04
      313      41_452736 1926        PIE 9.702666e-01 -1.139895e-03 3.169750e-03
      314      41_452736 1926      DomMc 1.353383e-01  7.400296e-03 1.927566e-04
      315      41_452736 1926 expShannon 3.241364e+01 -4.490074e-01 5.283188e-03
      316      41_452736 1927          S 4.100000e+01 -2.563657e-01 1.379129e-01
      317      41_452736 1927          N 1.070000e+02 -1.936343e+00 5.137263e-02
      318      41_452736 1927       maxN 7.000000e+00  4.328704e-01 1.559284e-02
      319      41_452736 1927    Shannon 3.486915e+00 -1.468300e-02 6.603122e-03
      320      41_452736 1927    Simpson 9.630535e-01 -1.257937e-03 1.818562e-03
      321      41_452736 1927 invSimpson 2.706619e+01 -6.612574e-01 4.743937e-04
      322      41_452736 1927        PIE 9.721390e-01 -1.139895e-03 3.169750e-03
      323      41_452736 1927      DomMc 1.308411e-01  7.400296e-03 1.927566e-04
      324      41_452736 1927 expShannon 3.268496e+01 -4.490074e-01 5.283188e-03
      325      41_452736 1930          S 4.000000e+01 -2.563657e-01 1.379129e-01
      326      41_452736 1930          N 9.600000e+01 -1.936343e+00 5.137263e-02
      327      41_452736 1930       maxN 7.000000e+00  4.328704e-01 1.559284e-02
      328      41_452736 1930    Shannon 3.467541e+00 -1.468300e-02 6.603122e-03
      329      41_452736 1930    Simpson 9.622396e-01 -1.257937e-03 1.818562e-03
      330      41_452736 1930 invSimpson 2.648276e+01 -6.612574e-01 4.743937e-04
      331      41_452736 1930        PIE 9.723684e-01 -1.139895e-03 3.169750e-03
      332      41_452736 1930      DomMc 1.458333e-01  7.400296e-03 1.927566e-04
      333      41_452736 1930 expShannon 3.205783e+01 -4.490074e-01 5.283188e-03
      334      41_452736 1931          S 4.100000e+01 -2.563657e-01 1.379129e-01
      335      41_452736 1931          N 1.040000e+02 -1.936343e+00 5.137263e-02
      336      41_452736 1931       maxN 1.100000e+01  4.328704e-01 1.559284e-02
      337      41_452736 1931    Shannon 3.431774e+00 -1.468300e-02 6.603122e-03
      338      41_452736 1931    Simpson 9.576553e-01 -1.257937e-03 1.818562e-03
      339      41_452736 1931 invSimpson 2.361572e+01 -6.612574e-01 4.743937e-04
      340      41_452736 1931        PIE 9.669529e-01 -1.139895e-03 3.169750e-03
      341      41_452736 1931      DomMc 1.923077e-01  7.400296e-03 1.927566e-04
      342      41_452736 1931 expShannon 3.093148e+01 -4.490074e-01 5.283188e-03
      343      41_452736 1936          S 4.300000e+01 -2.563657e-01 1.379129e-01
      344      41_452736 1936          N 9.700000e+01 -1.936343e+00 5.137263e-02
      345      41_452736 1936       maxN 1.400000e+01  4.328704e-01 1.559284e-02
      346      41_452736 1936    Shannon 3.439930e+00 -1.468300e-02 6.603122e-03
      347      41_452736 1936    Simpson 9.531300e-01 -1.257937e-03 1.818562e-03
      348      41_452736 1936 invSimpson 2.133560e+01 -6.612574e-01 4.743937e-04
      349      41_452736 1936        PIE 9.630584e-01 -1.139895e-03 3.169750e-03
      350      41_452736 1936      DomMc 2.164948e-01  7.400296e-03 1.927566e-04
      351      41_452736 1936 expShannon 3.118476e+01 -4.490074e-01 5.283188e-03
      352      41_452736 1937          S 3.700000e+01 -2.563657e-01 1.379129e-01
      353      41_452736 1937          N 9.500000e+01 -1.936343e+00 5.137263e-02
      354      41_452736 1937       maxN 1.600000e+01  4.328704e-01 1.559284e-02
      355      41_452736 1937    Shannon 3.221245e+00 -1.468300e-02 6.603122e-03
      356      41_452736 1937    Simpson 9.398338e-01 -1.257937e-03 1.818562e-03
      357      41_452736 1937 invSimpson 1.662063e+01 -6.612574e-01 4.743937e-04
      358      41_452736 1937        PIE 9.498320e-01 -1.139895e-03 3.169750e-03
      359      41_452736 1937      DomMc 2.526316e-01  7.400296e-03 1.927566e-04
      360      41_452736 1937 expShannon 2.505931e+01 -4.490074e-01 5.283188e-03
      361      41_452736 1938          S 4.500000e+01 -2.563657e-01 1.379129e-01
      362      41_452736 1938          N 1.210000e+02 -1.936343e+00 5.137263e-02
      363      41_452736 1938       maxN 1.300000e+01  4.328704e-01 1.559284e-02
      364      41_452736 1938    Shannon 3.462172e+00 -1.468300e-02 6.603122e-03
      365      41_452736 1938    Simpson 9.569019e-01 -1.257937e-03 1.818562e-03
      366      41_452736 1938 invSimpson 2.320285e+01 -6.612574e-01 4.743937e-04
      367      41_452736 1938        PIE 9.648760e-01 -1.139895e-03 3.169750e-03
      368      41_452736 1938      DomMc 1.983471e-01  7.400296e-03 1.927566e-04
      369      41_452736 1938 expShannon 3.188614e+01 -4.490074e-01 5.283188e-03
      370      41_452736 1940          S 3.800000e+01 -2.563657e-01 1.379129e-01
      371      41_452736 1940          N 1.110000e+02 -1.936343e+00 5.137263e-02
      372      41_452736 1940       maxN 1.800000e+01  4.328704e-01 1.559284e-02
      373      41_452736 1940    Shannon 3.268138e+00 -1.468300e-02 6.603122e-03
      374      41_452736 1940    Simpson 9.434299e-01 -1.257937e-03 1.818562e-03
      375      41_452736 1940 invSimpson 1.767719e+01 -6.612574e-01 4.743937e-04
      376      41_452736 1940        PIE 9.520066e-01 -1.139895e-03 3.169750e-03
      377      41_452736 1940      DomMc 2.522523e-01  7.400296e-03 1.927566e-04
      378      41_452736 1940 expShannon 2.626240e+01 -4.490074e-01 5.283188e-03
      379      53_393795 1966          S 5.000000e+00 -4.224059e-02 6.302075e-01
      380      53_393795 1966          N 9.100000e+00 -6.050735e-01 1.326488e-01
      381      53_393795 1966       maxN 4.100000e+00 -3.575987e-01 2.948843e-01
      382      53_393795 1966    Shannon 1.136556e+00  4.247240e-03 8.821820e-01
      383      53_393795 1966    Simpson 6.274605e-01  2.379700e-04 9.876894e-01
      384      53_393795 1966 invSimpson 2.684279e+00  3.524614e-02 6.222640e-01
      385      53_393795 1966        PIE 7.049247e-01  1.165605e-02 5.448768e-01
      386      53_393795 1966      DomMc 8.461538e-01 -6.298767e-03 5.061098e-01
      387      53_393795 1966 expShannon 3.116020e+00  2.999347e-02 6.880607e-01
      388      53_393795 1967          S 4.000000e+00 -4.224059e-02 6.302075e-01
      389      53_393795 1967          N 8.375000e+00 -6.050735e-01 1.326488e-01
      390      53_393795 1967       maxN 4.600000e+00 -3.575987e-01 2.948843e-01
      391      53_393795 1967    Shannon 1.054072e+00  4.247240e-03 8.821820e-01
      392      53_393795 1967    Simpson 5.968011e-01  2.379700e-04 9.876894e-01
      393      53_393795 1967 invSimpson 2.480165e+00  3.524614e-02 6.222640e-01
      394      53_393795 1967        PIE 6.777232e-01  1.165605e-02 5.448768e-01
      395      53_393795 1967      DomMc 8.328358e-01 -6.298767e-03 5.061098e-01
      396      53_393795 1967 expShannon 2.869311e+00  2.999347e-02 6.880607e-01
      397      53_393795 1968          S 5.000000e+00 -4.224059e-02 6.302075e-01
      398      53_393795 1968          N 1.700000e+01 -6.050735e-01 1.326488e-01
      399      53_393795 1968       maxN 1.180000e+01 -3.575987e-01 2.948843e-01
      400      53_393795 1968    Shannon 1.007184e+00  4.247240e-03 8.821820e-01
      401      53_393795 1968    Simpson 4.893599e-01  2.379700e-04 9.876894e-01
      402      53_393795 1968 invSimpson 1.958326e+00  3.524614e-02 6.222640e-01
      403      53_393795 1968        PIE 5.199449e-01  1.165605e-02 5.448768e-01
      404      53_393795 1968      DomMc 8.323529e-01 -6.298767e-03 5.061098e-01
      405      53_393795 1968 expShannon 2.737879e+00  2.999347e-02 6.880607e-01
      406      53_393795 1970          S 5.000000e+00 -4.224059e-02 6.302075e-01
      407      53_393795 1970          N 6.100000e+00 -6.050735e-01 1.326488e-01
      408      53_393795 1970       maxN 4.900000e+00 -3.575987e-01 2.948843e-01
      409      53_393795 1970    Shannon 7.532540e-01  4.247240e-03 8.821820e-01
      410      53_393795 1970    Simpson 3.434561e-01  2.379700e-04 9.876894e-01
      411      53_393795 1970 invSimpson 1.523127e+00  3.524614e-02 6.222640e-01
      412      53_393795 1970        PIE 4.108004e-01  1.165605e-02 5.448768e-01
      413      53_393795 1970      DomMc 8.852459e-01 -6.298767e-03 5.061098e-01
      414      53_393795 1970 expShannon 2.123900e+00  2.999347e-02 6.880607e-01
      415      53_393795 1971          S 5.000000e+00 -4.224059e-02 6.302075e-01
      416      53_393795 1971          N 6.900000e+00 -6.050735e-01 1.326488e-01
      417      53_393795 1971       maxN 5.025000e+00 -3.575987e-01 2.948843e-01
      418      53_393795 1971    Shannon 8.889374e-01  4.247240e-03 8.821820e-01
      419      53_393795 1971    Simpson 4.422128e-01  2.379700e-04 9.876894e-01
      420      53_393795 1971 invSimpson 1.792798e+00  3.524614e-02 6.222640e-01
      421      53_393795 1971        PIE 5.171641e-01  1.165605e-02 5.448768e-01
      422      53_393795 1971      DomMc 8.550725e-01 -6.298767e-03 5.061098e-01
      423      53_393795 1971 expShannon 2.432544e+00  2.999347e-02 6.880607e-01
      424      53_393795 1974          S 3.000000e+00 -4.224059e-02 6.302075e-01
      425      53_393795 1974          N 3.000000e+00 -6.050735e-01 1.326488e-01
      426      53_393795 1974       maxN 2.300000e+00 -3.575987e-01 2.948843e-01
      427      53_393795 1974    Shannon 6.389666e-01  4.247240e-03 8.821820e-01
      428      53_393795 1974    Simpson 3.711111e-01  2.379700e-04 9.876894e-01
      429      53_393795 1974 invSimpson 1.590106e+00  3.524614e-02 6.222640e-01
      430      53_393795 1974        PIE 5.566667e-01  1.165605e-02 5.448768e-01
      431      53_393795 1974      DomMc 9.666667e-01 -6.298767e-03 5.061098e-01
      432      53_393795 1974 expShannon 1.894522e+00  2.999347e-02 6.880607e-01
      433      53_393795 1975          S 5.000000e+00 -4.224059e-02 6.302075e-01
      434      53_393795 1975          N 7.600000e+00 -6.050735e-01 1.326488e-01
      435      53_393795 1975       maxN 4.000000e+00 -3.575987e-01 2.948843e-01
      436      53_393795 1975    Shannon 1.221693e+00  4.247240e-03 8.821820e-01
      437      53_393795 1975    Simpson 6.326177e-01  2.379700e-04 9.876894e-01
      438      53_393795 1975 invSimpson 2.721960e+00  3.524614e-02 6.222640e-01
      439      53_393795 1975        PIE 7.284689e-01  1.165605e-02 5.448768e-01
      440      53_393795 1975      DomMc 8.026316e-01 -6.298767e-03 5.061098e-01
      441      53_393795 1975 expShannon 3.392926e+00  2.999347e-02 6.880607e-01
      442      53_393795 1976          S 5.000000e+00 -4.224059e-02 6.302075e-01
      443      53_393795 1976          N 4.200000e+00 -6.050735e-01 1.326488e-01
      444      53_393795 1976       maxN 1.400000e+00 -3.575987e-01 2.948843e-01
      445      53_393795 1976    Shannon 1.364050e+00  4.247240e-03 8.821820e-01
      446      53_393795 1976    Simpson 7.165533e-01  2.379700e-04 9.876894e-01
      447      53_393795 1976 invSimpson 3.528000e+00  3.524614e-02 6.222640e-01
      448      53_393795 1976        PIE 9.404762e-01  1.165605e-02 5.448768e-01
      449      53_393795 1976      DomMc 6.666667e-01 -6.298767e-03 5.061098e-01
      450      53_393795 1976 expShannon 3.912003e+00  2.999347e-02 6.880607e-01
      451      53_393795 1969          S 4.000000e+00 -4.224059e-02 6.302075e-01
      452      53_393795 1969          N 1.160000e+01 -6.050735e-01 1.326488e-01
      453      53_393795 1969       maxN 8.050000e+00 -3.575987e-01 2.948843e-01
      454      53_393795 1969    Shannon 7.209928e-01  4.247240e-03 8.821820e-01
      455      53_393795 1969    Simpson 4.395437e-01  2.379700e-04 9.876894e-01
      456      53_393795 1969 invSimpson 1.784260e+00  3.524614e-02 6.222640e-01
      457      53_393795 1969        PIE 4.810101e-01  1.165605e-02 5.448768e-01
      458      53_393795 1969      DomMc 9.741379e-01 -6.298767e-03 5.061098e-01
      459      53_393795 1969 expShannon 2.056474e+00  2.999347e-02 6.880607e-01
      460      53_393795 1973          S 3.000000e+00 -4.224059e-02 6.302075e-01
      461      53_393795 1973          N 1.220000e+01 -6.050735e-01 1.326488e-01
      462      53_393795 1973       maxN 1.040000e+01 -3.575987e-01 2.948843e-01
      463      53_393795 1973    Shannon 5.123318e-01  4.247240e-03 8.821820e-01
      464      53_393795 1973    Simpson 2.612201e-01  2.379700e-04 9.876894e-01
      465      53_393795 1973 invSimpson 1.353583e+00  3.524614e-02 6.222640e-01
      466      53_393795 1973        PIE 2.845433e-01  1.165605e-02 5.448768e-01
      467      53_393795 1973      DomMc 9.508197e-01 -6.298767e-03 5.061098e-01
      468      53_393795 1973 expShannon 1.669179e+00  2.999347e-02 6.880607e-01
      469      59_470015 1985          S 1.300000e+01 -8.512821e-02 3.666022e-01
      470      59_470015 1985          N 1.560000e+02  4.988034e-01 7.315844e-01
      471      59_470015 1985       maxN 7.900000e+01  7.993162e-01 3.035373e-01
      472      59_470015 1985    Shannon 1.683013e+00 -1.904993e-02 7.001435e-02
      473      59_470015 1985    Simpson 7.007725e-01 -7.604887e-03 8.271231e-02
      474      59_470015 1985 invSimpson 3.341939e+00 -3.840984e-02 9.133203e-02
      475      59_470015 1985        PIE 7.052936e-01 -7.742188e-03 7.927577e-02
      476      59_470015 1985      DomMc 6.538462e-01  2.421511e-03 4.124991e-01
      477      59_470015 1985 expShannon 5.381747e+00 -6.753769e-02 5.565492e-02
      478      59_470015 1989          S 1.200000e+01 -8.512821e-02 3.666022e-01
      479      59_470015 1989          N 7.200000e+01  4.988034e-01 7.315844e-01
      480      59_470015 1989       maxN 4.200000e+01  7.993162e-01 3.035373e-01
      481      59_470015 1989    Shannon 1.608949e+00 -1.904993e-02 7.001435e-02
      482      59_470015 1989    Simpson 6.385031e-01 -7.604887e-03 8.271231e-02
      483      59_470015 1989 invSimpson 2.766275e+00 -3.840984e-02 9.133203e-02
      484      59_470015 1989        PIE 6.474961e-01 -7.742188e-03 7.927577e-02
      485      59_470015 1989      DomMc 6.666667e-01  2.421511e-03 4.124991e-01
      486      59_470015 1989 expShannon 4.997558e+00 -6.753769e-02 5.565492e-02
      487      59_470015 1990          S 9.000000e+00 -8.512821e-02 3.666022e-01
      488      59_470015 1990          N 1.760000e+02  4.988034e-01 7.315844e-01
      489      59_470015 1990       maxN 1.170000e+02  7.993162e-01 3.035373e-01
      490      59_470015 1990    Shannon 1.065267e+00 -1.904993e-02 7.001435e-02
      491      59_470015 1990    Simpson 5.086519e-01 -7.604887e-03 8.271231e-02
      492      59_470015 1990 invSimpson 2.035217e+00 -3.840984e-02 9.133203e-02
      493      59_470015 1990        PIE 5.115584e-01 -7.742188e-03 7.927577e-02
      494      59_470015 1990      DomMc 8.806818e-01  2.421511e-03 4.124991e-01
      495      59_470015 1990 expShannon 2.901615e+00 -6.753769e-02 5.565492e-02
      496      59_470015 1991          S 7.000000e+00 -8.512821e-02 3.666022e-01
      497      59_470015 1991          N 6.700000e+01  4.988034e-01 7.315844e-01
      498      59_470015 1991       maxN 5.300000e+01  7.993162e-01 3.035373e-01
      499      59_470015 1991    Shannon 8.404518e-01 -1.904993e-02 7.001435e-02
      500      59_470015 1991    Simpson 3.635554e-01 -7.604887e-03 8.271231e-02
      501      59_470015 1991 invSimpson 1.571229e+00 -3.840984e-02 9.133203e-02
      502      59_470015 1991        PIE 3.690638e-01 -7.742188e-03 7.927577e-02
      503      59_470015 1991      DomMc 8.656716e-01  2.421511e-03 4.124991e-01
      504      59_470015 1991 expShannon 2.317414e+00 -6.753769e-02 5.565492e-02
      505      59_470015 1992          S 1.000000e+01 -8.512821e-02 3.666022e-01
      506      59_470015 1992          N 7.000000e+01  4.988034e-01 7.315844e-01
      507      59_470015 1992       maxN 5.200000e+01  7.993162e-01 3.035373e-01
      508      59_470015 1992    Shannon 1.080489e+00 -1.904993e-02 7.001435e-02
      509      59_470015 1992    Simpson 4.367347e-01 -7.604887e-03 8.271231e-02
      510      59_470015 1992 invSimpson 1.775362e+00 -3.840984e-02 9.133203e-02
      511      59_470015 1992        PIE 4.430642e-01 -7.742188e-03 7.927577e-02
      512      59_470015 1992      DomMc 8.285714e-01  2.421511e-03 4.124991e-01
      513      59_470015 1992 expShannon 2.946121e+00 -6.753769e-02 5.565492e-02
      514      59_470015 1993          S 1.100000e+01 -8.512821e-02 3.666022e-01
      515      59_470015 1993          N 9.800000e+01  4.988034e-01 7.315844e-01
      516      59_470015 1993       maxN 7.500000e+01  7.993162e-01 3.035373e-01
      517      59_470015 1993    Shannon 1.023268e+00 -1.904993e-02 7.001435e-02
      518      59_470015 1993    Simpson 4.052478e-01 -7.604887e-03 8.271231e-02
      519      59_470015 1993 invSimpson 1.681373e+00 -3.840984e-02 9.133203e-02
      520      59_470015 1993        PIE 4.094256e-01 -7.742188e-03 7.927577e-02
      521      59_470015 1993      DomMc 8.367347e-01  2.421511e-03 4.124991e-01
      522      59_470015 1993 expShannon 2.782271e+00 -6.753769e-02 5.565492e-02
      523      59_470015 1995          S 5.000000e+00 -8.512821e-02 3.666022e-01
      524      59_470015 1995          N 8.300000e+01  4.988034e-01 7.315844e-01
      525      59_470015 1995       maxN 6.800000e+01  7.993162e-01 3.035373e-01
      526      59_470015 1995    Shannon 6.672300e-01 -1.904993e-02 7.001435e-02
      527      59_470015 1995    Simpson 3.149949e-01 -7.604887e-03 8.271231e-02
      528      59_470015 1995 invSimpson 1.459843e+00 -3.840984e-02 9.133203e-02
      529      59_470015 1995        PIE 3.188363e-01 -7.742188e-03 7.927577e-02
      530      59_470015 1995      DomMc 9.277108e-01  2.421511e-03 4.124991e-01
      531      59_470015 1995 expShannon 1.948832e+00 -6.753769e-02 5.565492e-02
      532      59_470015 1997          S 1.100000e+01 -8.512821e-02 3.666022e-01
      533      59_470015 1997          N 1.470000e+02  4.988034e-01 7.315844e-01
      534      59_470015 1997       maxN 1.020000e+02  7.993162e-01 3.035373e-01
      535      59_470015 1997    Shannon 1.185729e+00 -1.904993e-02 7.001435e-02
      536      59_470015 1997    Simpson 4.988662e-01 -7.604887e-03 8.271231e-02
      537      59_470015 1997 invSimpson 1.995475e+00 -3.840984e-02 9.133203e-02
      538      59_470015 1997        PIE 5.022831e-01 -7.742188e-03 7.927577e-02
      539      59_470015 1997      DomMc 8.095238e-01  2.421511e-03 4.124991e-01
      540      59_470015 1997 expShannon 3.273072e+00 -6.753769e-02 5.565492e-02
      541      59_470015 1998          S 1.200000e+01 -8.512821e-02 3.666022e-01
      542      59_470015 1998          N 1.600000e+02  4.988034e-01 7.315844e-01
      543      59_470015 1998       maxN 1.060000e+02  7.993162e-01 3.035373e-01
      544      59_470015 1998    Shannon 1.254657e+00 -1.904993e-02 7.001435e-02
      545      59_470015 1998    Simpson 5.375000e-01 -7.604887e-03 8.271231e-02
      546      59_470015 1998 invSimpson 2.162162e+00 -3.840984e-02 9.133203e-02
      547      59_470015 1998        PIE 5.408805e-01 -7.742188e-03 7.927577e-02
      548      59_470015 1998      DomMc 7.625000e-01  2.421511e-03 4.124991e-01
      549      59_470015 1998 expShannon 3.506636e+00 -6.753769e-02 5.565492e-02
      550      59_470015 1999          S 4.000000e+00 -8.512821e-02 3.666022e-01
      551      59_470015 1999          N 3.500000e+01  4.988034e-01 7.315844e-01
      552      59_470015 1999       maxN 2.400000e+01  7.993162e-01 3.035373e-01
      553      59_470015 1999    Shannon 9.351772e-01 -1.904993e-02 7.001435e-02
      554      59_470015 1999    Simpson 4.897959e-01 -7.604887e-03 8.271231e-02
      555      59_470015 1999 invSimpson 1.960000e+00 -3.840984e-02 9.133203e-02
      556      59_470015 1999        PIE 5.042017e-01 -7.742188e-03 7.927577e-02
      557      59_470015 1999      DomMc 8.571429e-01  2.421511e-03 4.124991e-01
      558      59_470015 1999 expShannon 2.547665e+00 -6.753769e-02 5.565492e-02
      559      59_470015 2001          S 1.200000e+01 -8.512821e-02 3.666022e-01
      560      59_470015 2001          N 1.790000e+02  4.988034e-01 7.315844e-01
      561      59_470015 2001       maxN 9.300000e+01  7.993162e-01 3.035373e-01
      562      59_470015 2001    Shannon 1.556511e+00 -1.904993e-02 7.001435e-02
      563      59_470015 2001    Simpson 6.822509e-01 -7.604887e-03 8.271231e-02
      564      59_470015 2001 invSimpson 3.147137e+00 -3.840984e-02 9.133203e-02
      565      59_470015 2001        PIE 6.860837e-01 -7.742188e-03 7.927577e-02
      566      59_470015 2001      DomMc 6.536313e-01  2.421511e-03 4.124991e-01
      567      59_470015 2001 expShannon 4.742245e+00 -6.753769e-02 5.565492e-02
      568      59_470015 2002          S 1.300000e+01 -8.512821e-02 3.666022e-01
      569      59_470015 2002          N 2.020000e+02  4.988034e-01 7.315844e-01
      570      59_470015 2002       maxN 9.200000e+01  7.993162e-01 3.035373e-01
      571      59_470015 2002    Shannon 1.654262e+00 -1.904993e-02 7.001435e-02
      572      59_470015 2002    Simpson 7.222821e-01 -7.604887e-03 8.271231e-02
      573      59_470015 2002 invSimpson 3.600777e+00 -3.840984e-02 9.133203e-02
      574      59_470015 2002        PIE 7.258756e-01 -7.742188e-03 7.927577e-02
      575      59_470015 2002      DomMc 6.435644e-01  2.421511e-03 4.124991e-01
      576      59_470015 2002 expShannon 5.229219e+00 -6.753769e-02 5.565492e-02
      577      59_470015 1986          S 1.300000e+01 -8.512821e-02 3.666022e-01
      578      59_470015 1986          N 1.310000e+02  4.988034e-01 7.315844e-01
      579      59_470015 1986       maxN 7.900000e+01  7.993162e-01 3.035373e-01
      580      59_470015 1986    Shannon 1.515670e+00 -1.904993e-02 7.001435e-02
      581      59_470015 1986    Simpson 6.124352e-01 -7.604887e-03 8.271231e-02
      582      59_470015 1986 invSimpson 2.580214e+00 -3.840984e-02 9.133203e-02
      583      59_470015 1986        PIE 6.171462e-01 -7.742188e-03 7.927577e-02
      584      59_470015 1986      DomMc 7.099237e-01  2.421511e-03 4.124991e-01
      585      59_470015 1986 expShannon 4.552471e+00 -6.753769e-02 5.565492e-02
      586      59_470015 1988          S 1.700000e+01 -8.512821e-02 3.666022e-01
      587      59_470015 1988          N 1.500000e+02  4.988034e-01 7.315844e-01
      588      59_470015 1988       maxN 8.700000e+01  7.993162e-01 3.035373e-01
      589      59_470015 1988    Shannon 1.706945e+00 -1.904993e-02 7.001435e-02
      590      59_470015 1988    Simpson 6.455111e-01 -7.604887e-03 8.271231e-02
      591      59_470015 1988 invSimpson 2.820963e+00 -3.840984e-02 9.133203e-02
      592      59_470015 1988        PIE 6.498434e-01 -7.742188e-03 7.927577e-02
      593      59_470015 1988      DomMc 6.466667e-01  2.421511e-03 4.124991e-01
      594      59_470015 1988 expShannon 5.512096e+00 -6.753769e-02 5.565492e-02
      595      59_470015 1987          S 1.200000e+01 -8.512821e-02 3.666022e-01
      596      59_470015 1987          N 6.900000e+01  4.988034e-01 7.315844e-01
      597      59_470015 1987       maxN 3.400000e+01  7.993162e-01 3.035373e-01
      598      59_470015 1987    Shannon 1.731617e+00 -1.904993e-02 7.001435e-02
      599      59_470015 1987    Simpson 7.120353e-01 -7.604887e-03 8.271231e-02
      600      59_470015 1987 invSimpson 3.472648e+00 -3.840984e-02 9.133203e-02
      601      59_470015 1987        PIE 7.225064e-01 -7.742188e-03 7.927577e-02
      602      59_470015 1987      DomMc 6.666667e-01  2.421511e-03 4.124991e-01
      603      59_470015 1987 expShannon 5.649783e+00 -6.753769e-02 5.565492e-02
      604      59_470015 2000          S 6.000000e+00 -8.512821e-02 3.666022e-01
      605      59_470015 2000          N 7.300000e+01  4.988034e-01 7.315844e-01
      606      59_470015 2000       maxN 2.100000e+01  7.993162e-01 3.035373e-01
      607      59_470015 2000    Shannon 1.493116e+00 -1.904993e-02 7.001435e-02
      608      59_470015 2000    Simpson 7.547382e-01 -7.604887e-03 8.271231e-02
      609      59_470015 2000 invSimpson 4.077276e+00 -3.840984e-02 9.133203e-02
      610      59_470015 2000        PIE 7.652207e-01 -7.742188e-03 7.927577e-02
      611      59_470015 2000      DomMc 5.616438e-01  2.421511e-03 4.124991e-01
      612      59_470015 2000 expShannon 4.450941e+00 -6.753769e-02 5.565492e-02
      613      59_470015 1984          S 1.300000e+01 -8.512821e-02 3.666022e-01
      614      59_470015 1984          N 1.050000e+02  4.988034e-01 7.315844e-01
      615      59_470015 1984       maxN 4.700000e+01  7.993162e-01 3.035373e-01
      616      59_470015 1984    Shannon 1.753723e+00 -1.904993e-02 7.001435e-02
      617      59_470015 1984    Simpson 7.392290e-01 -7.604887e-03 8.271231e-02
      618      59_470015 1984 invSimpson 3.834783e+00 -3.840984e-02 9.133203e-02
      619      59_470015 1984        PIE 7.463370e-01 -7.742188e-03 7.927577e-02
      620      59_470015 1984      DomMc 6.380952e-01  2.421511e-03 4.124991e-01
      621      59_470015 1984 expShannon 5.776069e+00 -6.753769e-02 5.565492e-02
      622      59_470015 1977          S 6.000000e+00 -8.512821e-02 3.666022e-01
      623      59_470015 1977          N 3.400000e+01  4.988034e-01 7.315844e-01
      624      59_470015 1977       maxN 1.500000e+01  7.993162e-01 3.035373e-01
      625      59_470015 1977    Shannon 1.351976e+00 -1.904993e-02 7.001435e-02
      626      59_470015 1977    Simpson 6.816609e-01 -7.604887e-03 8.271231e-02
      627      59_470015 1977 invSimpson 3.141304e+00 -3.840984e-02 9.133203e-02
      628      59_470015 1977        PIE 7.023173e-01 -7.742188e-03 7.927577e-02
      629      59_470015 1977      DomMc 7.647059e-01  2.421511e-03 4.124991e-01
      630      59_470015 1977 expShannon 3.865055e+00 -6.753769e-02 5.565492e-02
      631      59_470015 1978          S 1.000000e+01 -8.512821e-02 3.666022e-01
      632      59_470015 1978          N 1.210000e+02  4.988034e-01 7.315844e-01
      633      59_470015 1978       maxN 6.100000e+01  7.993162e-01 3.035373e-01
      634      59_470015 1978    Shannon 1.444418e+00 -1.904993e-02 7.001435e-02
      635      59_470015 1978    Simpson 6.651185e-01 -7.604887e-03 8.271231e-02
      636      59_470015 1978 invSimpson 2.986131e+00 -3.840984e-02 9.133203e-02
      637      59_470015 1978        PIE 6.706612e-01 -7.742188e-03 7.927577e-02
      638      59_470015 1978      DomMc 7.685950e-01  2.421511e-03 4.124991e-01
      639      59_470015 1978 expShannon 4.239382e+00 -6.753769e-02 5.565492e-02
      640      59_470015 1979          S 8.000000e+00 -8.512821e-02 3.666022e-01
      641      59_470015 1979          N 9.000000e+01  4.988034e-01 7.315844e-01
      642      59_470015 1979       maxN 4.300000e+01  7.993162e-01 3.035373e-01
      643      59_470015 1979    Shannon 1.480464e+00 -1.904993e-02 7.001435e-02
      644      59_470015 1979    Simpson 6.869136e-01 -7.604887e-03 8.271231e-02
      645      59_470015 1979 invSimpson 3.194006e+00 -3.840984e-02 9.133203e-02
      646      59_470015 1979        PIE 6.946317e-01 -7.742188e-03 7.927577e-02
      647      59_470015 1979      DomMc 7.444444e-01  2.421511e-03 4.124991e-01
      648      59_470015 1979 expShannon 4.394986e+00 -6.753769e-02 5.565492e-02
      649      59_470015 1980          S 9.000000e+00 -8.512821e-02 3.666022e-01
      650      59_470015 1980          N 1.330000e+02  4.988034e-01 7.315844e-01
      651      59_470015 1980       maxN 6.800000e+01  7.993162e-01 3.035373e-01
      652      59_470015 1980    Shannon 1.528275e+00 -1.904993e-02 7.001435e-02
      653      59_470015 1980    Simpson 6.787269e-01 -7.604887e-03 8.271231e-02
      654      59_470015 1980 invSimpson 3.112617e+00 -3.840984e-02 9.133203e-02
      655      59_470015 1980        PIE 6.838688e-01 -7.742188e-03 7.927577e-02
      656      59_470015 1980      DomMc 7.293233e-01  2.421511e-03 4.124991e-01
      657      59_470015 1980 expShannon 4.610216e+00 -6.753769e-02 5.565492e-02
      658      59_470015 1981          S 1.000000e+01 -8.512821e-02 3.666022e-01
      659      59_470015 1981          N 8.600000e+01  4.988034e-01 7.315844e-01
      660      59_470015 1981       maxN 4.500000e+01  7.993162e-01 3.035373e-01
      661      59_470015 1981    Shannon 1.598352e+00 -1.904993e-02 7.001435e-02
      662      59_470015 1981    Simpson 6.865873e-01 -7.604887e-03 8.271231e-02
      663      59_470015 1981 invSimpson 3.190682e+00 -3.840984e-02 9.133203e-02
      664      59_470015 1981        PIE 6.946648e-01 -7.742188e-03 7.927577e-02
      665      59_470015 1981      DomMc 6.511628e-01  2.421511e-03 4.124991e-01
      666      59_470015 1981 expShannon 4.944877e+00 -6.753769e-02 5.565492e-02
      667      59_470015 1982          S 1.400000e+01 -8.512821e-02 3.666022e-01
      668      59_470015 1982          N 2.190000e+02  4.988034e-01 7.315844e-01
      669      59_470015 1982       maxN 1.120000e+02  7.993162e-01 3.035373e-01
      670      59_470015 1982    Shannon 1.675483e+00 -1.904993e-02 7.001435e-02
      671      59_470015 1982    Simpson 6.932299e-01 -7.604887e-03 8.271231e-02
      672      59_470015 1982 invSimpson 3.259770e+00 -3.840984e-02 9.133203e-02
      673      59_470015 1982        PIE 6.964099e-01 -7.742188e-03 7.927577e-02
      674      59_470015 1982      DomMc 6.757991e-01  2.421511e-03 4.124991e-01
      675      59_470015 1982 expShannon 5.341374e+00 -6.753769e-02 5.565492e-02
      676      59_470015 1996          S 8.000000e+00 -8.512821e-02 3.666022e-01
      677      59_470015 1996          N 1.650000e+02  4.988034e-01 7.315844e-01
      678      59_470015 1996       maxN 9.300000e+01  7.993162e-01 3.035373e-01
      679      59_470015 1996    Shannon 1.473747e+00 -1.904993e-02 7.001435e-02
      680      59_470015 1996    Simpson 6.472727e-01 -7.604887e-03 8.271231e-02
      681      59_470015 1996 invSimpson 2.835052e+00 -3.840984e-02 9.133203e-02
      682      59_470015 1996        PIE 6.512195e-01 -7.742188e-03 7.927577e-02
      683      59_470015 1996      DomMc 6.848485e-01  2.421511e-03 4.124991e-01
      684      59_470015 1996 expShannon 4.365561e+00 -6.753769e-02 5.565492e-02
      685      59_470015 1983          S 1.400000e+01 -8.512821e-02 3.666022e-01
      686      59_470015 1983          N 1.940000e+02  4.988034e-01 7.315844e-01
      687      59_470015 1983       maxN 7.900000e+01  7.993162e-01 3.035373e-01
      688      59_470015 1983    Shannon 1.917748e+00 -1.904993e-02 7.001435e-02
      689      59_470015 1983    Simpson 7.781380e-01 -7.604887e-03 8.271231e-02
      690      59_470015 1983 invSimpson 4.507305e+00 -3.840984e-02 9.133203e-02
      691      59_470015 1983        PIE 7.821698e-01 -7.742188e-03 7.927577e-02
      692      59_470015 1983      DomMc 5.773196e-01  2.421511e-03 4.124991e-01
      693      59_470015 1983 expShannon 6.805616e+00 -6.753769e-02 5.565492e-02
      694      59_470015 1994          S 2.000000e+00 -8.512821e-02 3.666022e-01
      695      59_470015 1994          N 4.000000e+01  4.988034e-01 7.315844e-01
      696      59_470015 1994       maxN 3.900000e+01  7.993162e-01 3.035373e-01
      697      59_470015 1994    Shannon 1.169068e-01 -1.904993e-02 7.001435e-02
      698      59_470015 1994    Simpson 4.875000e-02 -7.604887e-03 8.271231e-02
      699      59_470015 1994 invSimpson 1.051248e+00 -3.840984e-02 9.133203e-02
      700      59_470015 1994        PIE 5.000000e-02 -7.742188e-03 7.927577e-02
      701      59_470015 1994      DomMc 1.000000e+00  2.421511e-03 4.124991e-01
      702      59_470015 1994 expShannon 1.124015e+00 -6.753769e-02 5.565492e-02
      703     333_426399 1996          S 3.700000e+01 -2.507389e-01 1.202473e-01
      704     333_426399 1996          N 3.160000e+02 -3.566995e+00 2.161904e-01
      705     333_426399 1996       maxN 5.600000e+01 -7.788177e-01 2.995591e-01
      706     333_426399 1996    Shannon 2.879494e+00 -9.308501e-03 1.054635e-01
      707     333_426399 1996    Simpson 9.153381e-01 -8.220532e-04 2.791912e-01
      708     333_426399 1996 invSimpson 1.181169e+01 -9.656682e-02 2.766856e-01
      709     333_426399 1996        PIE 9.182439e-01 -8.070474e-04 2.871327e-01
      710     333_426399 1996      DomMc 3.101266e-01  2.618359e-03 1.654141e-01
      711     333_426399 1996 expShannon 1.780526e+01 -1.455441e-01 1.495618e-01
      712     333_426399 1997          S 4.500000e+01 -2.507389e-01 1.202473e-01
      713     333_426399 1997          N 4.730000e+02 -3.566995e+00 2.161904e-01
      714     333_426399 1997       maxN 8.600000e+01 -7.788177e-01 2.995591e-01
      715     333_426399 1997    Shannon 3.143293e+00 -9.308501e-03 1.054635e-01
      716     333_426399 1997    Simpson 9.283195e-01 -8.220532e-04 2.791912e-01
      717     333_426399 1997 invSimpson 1.395080e+01 -9.656682e-02 2.766856e-01
      718     333_426399 1997        PIE 9.302863e-01 -8.070474e-04 2.871327e-01
      719     333_426399 1997      DomMc 3.023256e-01  2.618359e-03 1.654141e-01
      720     333_426399 1997 expShannon 2.318007e+01 -1.455441e-01 1.495618e-01
      721     333_426399 2000          S 4.500000e+01 -2.507389e-01 1.202473e-01
      722     333_426399 2000          N 3.840000e+02 -3.566995e+00 2.161904e-01
      723     333_426399 2000       maxN 5.800000e+01 -7.788177e-01 2.995591e-01
      724     333_426399 2000    Shannon 3.165390e+00 -9.308501e-03 1.054635e-01
      725     333_426399 2000    Simpson 9.333360e-01 -8.220532e-04 2.791912e-01
      726     333_426399 2000 invSimpson 1.500061e+01 -9.656682e-02 2.766856e-01
      727     333_426399 2000        PIE 9.357730e-01 -8.070474e-04 2.871327e-01
      728     333_426399 2000      DomMc 2.890625e-01  2.618359e-03 1.654141e-01
      729     333_426399 2000 expShannon 2.369799e+01 -1.455441e-01 1.495618e-01
      730     333_426399 1989          S 4.800000e+01 -2.507389e-01 1.202473e-01
      731     333_426399 1989          N 6.040000e+02 -3.566995e+00 2.161904e-01
      732     333_426399 1989       maxN 6.300000e+01 -7.788177e-01 2.995591e-01
      733     333_426399 1989    Shannon 3.291012e+00 -9.308501e-03 1.054635e-01
      734     333_426399 1989    Simpson 9.492621e-01 -8.220532e-04 2.791912e-01
      735     333_426399 1989 invSimpson 1.970913e+01 -9.656682e-02 2.766856e-01
      736     333_426399 1989        PIE 9.508363e-01 -8.070474e-04 2.871327e-01
      737     333_426399 1989      DomMc 2.069536e-01  2.618359e-03 1.654141e-01
      738     333_426399 1989 expShannon 2.687004e+01 -1.455441e-01 1.495618e-01
      739     333_426399 1981          S 5.700000e+01 -2.507389e-01 1.202473e-01
      740     333_426399 1981          N 6.460000e+02 -3.566995e+00 2.161904e-01
      741     333_426399 1981       maxN 1.480000e+02 -7.788177e-01 2.995591e-01
      742     333_426399 1981    Shannon 3.230305e+00 -9.308501e-03 1.054635e-01
      743     333_426399 1981    Simpson 9.227204e-01 -8.220532e-04 2.791912e-01
      744     333_426399 1981 invSimpson 1.294003e+01 -9.656682e-02 2.766856e-01
      745     333_426399 1981        PIE 9.241510e-01 -8.070474e-04 2.871327e-01
      746     333_426399 1981      DomMc 3.080495e-01  2.618359e-03 1.654141e-01
      747     333_426399 1981 expShannon 2.528736e+01 -1.455441e-01 1.495618e-01
      748     333_426399 1982          S 3.500000e+01 -2.507389e-01 1.202473e-01
      749     333_426399 1982          N 2.480000e+02 -3.566995e+00 2.161904e-01
      750     333_426399 1982       maxN 4.200000e+01 -7.788177e-01 2.995591e-01
      751     333_426399 1982    Shannon 2.996955e+00 -9.308501e-03 1.054635e-01
      752     333_426399 1982    Simpson 9.218913e-01 -8.220532e-04 2.791912e-01
      753     333_426399 1982 invSimpson 1.280266e+01 -9.656682e-02 2.766856e-01
      754     333_426399 1982        PIE 9.256236e-01 -8.070474e-04 2.871327e-01
      755     333_426399 1982      DomMc 3.306452e-01  2.618359e-03 1.654141e-01
      756     333_426399 1982 expShannon 2.002448e+01 -1.455441e-01 1.495618e-01
      757     333_426399 1984          S 3.400000e+01 -2.507389e-01 1.202473e-01
      758     333_426399 1984          N 1.530000e+02 -3.566995e+00 2.161904e-01
      759     333_426399 1984       maxN 2.100000e+01 -7.788177e-01 2.995591e-01
      760     333_426399 1984    Shannon 3.100553e+00 -9.308501e-03 1.054635e-01
      761     333_426399 1984    Simpson 9.381007e-01 -8.220532e-04 2.791912e-01
      762     333_426399 1984 invSimpson 1.615528e+01 -9.656682e-02 2.766856e-01
      763     333_426399 1984        PIE 9.442724e-01 -8.070474e-04 2.871327e-01
      764     333_426399 1984      DomMc 2.418301e-01  2.618359e-03 1.654141e-01
      765     333_426399 1984 expShannon 2.221023e+01 -1.455441e-01 1.495618e-01
      766     333_426399 1985          S 4.600000e+01 -2.507389e-01 1.202473e-01
      767     333_426399 1985          N 3.900000e+02 -3.566995e+00 2.161904e-01
      768     333_426399 1985       maxN 5.700000e+01 -7.788177e-01 2.995591e-01
      769     333_426399 1985    Shannon 3.180620e+00 -9.308501e-03 1.054635e-01
      770     333_426399 1985    Simpson 9.359763e-01 -8.220532e-04 2.791912e-01
      771     333_426399 1985 invSimpson 1.561922e+01 -9.656682e-02 2.766856e-01
      772     333_426399 1985        PIE 9.383824e-01 -8.070474e-04 2.871327e-01
      773     333_426399 1985      DomMc 2.487179e-01  2.618359e-03 1.654141e-01
      774     333_426399 1985 expShannon 2.406167e+01 -1.455441e-01 1.495618e-01
      775     333_426399 1987          S 5.000000e+01 -2.507389e-01 1.202473e-01
      776     333_426399 1987          N 5.440000e+02 -3.566995e+00 2.161904e-01
      777     333_426399 1987       maxN 6.800000e+01 -7.788177e-01 2.995591e-01
      778     333_426399 1987    Shannon 3.317302e+00 -9.308501e-03 1.054635e-01
      779     333_426399 1987    Simpson 9.474413e-01 -8.220532e-04 2.791912e-01
      780     333_426399 1987 invSimpson 1.902636e+01 -9.656682e-02 2.766856e-01
      781     333_426399 1987        PIE 9.491862e-01 -8.070474e-04 2.871327e-01
      782     333_426399 1987      DomMc 2.242647e-01  2.618359e-03 1.654141e-01
      783     333_426399 1987 expShannon 2.758581e+01 -1.455441e-01 1.495618e-01
      784     333_426399 1988          S 4.700000e+01 -2.507389e-01 1.202473e-01
      785     333_426399 1988          N 4.310000e+02 -3.566995e+00 2.161904e-01
      786     333_426399 1988       maxN 6.800000e+01 -7.788177e-01 2.995591e-01
      787     333_426399 1988    Shannon 3.187952e+00 -9.308501e-03 1.054635e-01
      788     333_426399 1988    Simpson 9.370320e-01 -8.220532e-04 2.791912e-01
      789     333_426399 1988 invSimpson 1.588108e+01 -9.656682e-02 2.766856e-01
      790     333_426399 1988        PIE 9.392111e-01 -8.070474e-04 2.871327e-01
      791     333_426399 1988      DomMc 2.691415e-01  2.618359e-03 1.654141e-01
      792     333_426399 1988 expShannon 2.423873e+01 -1.455441e-01 1.495618e-01
      793     333_426399 1991          S 4.700000e+01 -2.507389e-01 1.202473e-01
      794     333_426399 1991          N 4.380000e+02 -3.566995e+00 2.161904e-01
      795     333_426399 1991       maxN 8.700000e+01 -7.788177e-01 2.995591e-01
      796     333_426399 1991    Shannon 3.093380e+00 -9.308501e-03 1.054635e-01
      797     333_426399 1991    Simpson 9.217593e-01 -8.220532e-04 2.791912e-01
      798     333_426399 1991 invSimpson 1.278108e+01 -9.656682e-02 2.766856e-01
      799     333_426399 1991        PIE 9.238686e-01 -8.070474e-04 2.871327e-01
      800     333_426399 1991      DomMc 3.333333e-01  2.618359e-03 1.654141e-01
      801     333_426399 1991 expShannon 2.205148e+01 -1.455441e-01 1.495618e-01
      802     333_426399 1992          S 3.800000e+01 -2.507389e-01 1.202473e-01
      803     333_426399 1992          N 2.230000e+02 -3.566995e+00 2.161904e-01
      804     333_426399 1992       maxN 4.300000e+01 -7.788177e-01 2.995591e-01
      805     333_426399 1992    Shannon 2.927026e+00 -9.308501e-03 1.054635e-01
      806     333_426399 1992    Simpson 9.100123e-01 -8.220532e-04 2.791912e-01
      807     333_426399 1992 invSimpson 1.111263e+01 -9.656682e-02 2.766856e-01
      808     333_426399 1992        PIE 9.141114e-01 -8.070474e-04 2.871327e-01
      809     333_426399 1992      DomMc 3.587444e-01  2.618359e-03 1.654141e-01
      810     333_426399 1992 expShannon 1.867202e+01 -1.455441e-01 1.495618e-01
      811     333_426399 1993          S 4.300000e+01 -2.507389e-01 1.202473e-01
      812     333_426399 1993          N 4.040000e+02 -3.566995e+00 2.161904e-01
      813     333_426399 1993       maxN 7.000000e+01 -7.788177e-01 2.995591e-01
      814     333_426399 1993    Shannon 3.043541e+00 -9.308501e-03 1.054635e-01
      815     333_426399 1993    Simpson 9.234144e-01 -8.220532e-04 2.791912e-01
      816     333_426399 1993 invSimpson 1.305728e+01 -9.656682e-02 2.766856e-01
      817     333_426399 1993        PIE 9.257057e-01 -8.070474e-04 2.871327e-01
      818     333_426399 1993      DomMc 3.143564e-01  2.618359e-03 1.654141e-01
      819     333_426399 1993 expShannon 2.097941e+01 -1.455441e-01 1.495618e-01
      820     333_426399 1994          S 4.000000e+01 -2.507389e-01 1.202473e-01
      821     333_426399 1994          N 3.510000e+02 -3.566995e+00 2.161904e-01
      822     333_426399 1994       maxN 6.500000e+01 -7.788177e-01 2.995591e-01
      823     333_426399 1994    Shannon 2.898730e+00 -9.308501e-03 1.054635e-01
      824     333_426399 1994    Simpson 9.071355e-01 -8.220532e-04 2.791912e-01
      825     333_426399 1994 invSimpson 1.076838e+01 -9.656682e-02 2.766856e-01
      826     333_426399 1994        PIE 9.097273e-01 -8.070474e-04 2.871327e-01
      827     333_426399 1994      DomMc 3.703704e-01  2.618359e-03 1.654141e-01
      828     333_426399 1994 expShannon 1.815108e+01 -1.455441e-01 1.495618e-01
      829     333_426399 1995          S 4.000000e+01 -2.507389e-01 1.202473e-01
      830     333_426399 1995          N 2.170000e+02 -3.566995e+00 2.161904e-01
      831     333_426399 1995       maxN 3.800000e+01 -7.788177e-01 2.995591e-01
      832     333_426399 1995    Shannon 3.213190e+00 -9.308501e-03 1.054635e-01
      833     333_426399 1995    Simpson 9.384357e-01 -8.220532e-04 2.791912e-01
      834     333_426399 1995 invSimpson 1.624319e+01 -9.656682e-02 2.766856e-01
      835     333_426399 1995        PIE 9.427803e-01 -8.070474e-04 2.871327e-01
      836     333_426399 1995      DomMc 2.580645e-01  2.618359e-03 1.654141e-01
      837     333_426399 1995 expShannon 2.485826e+01 -1.455441e-01 1.495618e-01
      838     333_426399 1998          S 4.200000e+01 -2.507389e-01 1.202473e-01
      839     333_426399 1998          N 1.830000e+02 -3.566995e+00 2.161904e-01
      840     333_426399 1998       maxN 3.000000e+01 -7.788177e-01 2.995591e-01
      841     333_426399 1998    Shannon 3.228932e+00 -9.308501e-03 1.054635e-01
      842     333_426399 1998    Simpson 9.386963e-01 -8.220532e-04 2.791912e-01
      843     333_426399 1998 invSimpson 1.631223e+01 -9.656682e-02 2.766856e-01
      844     333_426399 1998        PIE 9.438540e-01 -8.070474e-04 2.871327e-01
      845     333_426399 1998      DomMc 2.568306e-01  2.618359e-03 1.654141e-01
      846     333_426399 1998 expShannon 2.525267e+01 -1.455441e-01 1.495618e-01
      847     333_426399 1999          S 3.800000e+01 -2.507389e-01 1.202473e-01
      848     333_426399 1999          N 2.270000e+02 -3.566995e+00 2.161904e-01
      849     333_426399 1999       maxN 2.800000e+01 -7.788177e-01 2.995591e-01
      850     333_426399 1999    Shannon 3.169377e+00 -9.308501e-03 1.054635e-01
      851     333_426399 1999    Simpson 9.428089e-01 -8.220532e-04 2.791912e-01
      852     333_426399 1999 invSimpson 1.748524e+01 -9.656682e-02 2.766856e-01
      853     333_426399 1999        PIE 9.469806e-01 -8.070474e-04 2.871327e-01
      854     333_426399 1999      DomMc 2.202643e-01  2.618359e-03 1.654141e-01
      855     333_426399 1999 expShannon 2.379266e+01 -1.455441e-01 1.495618e-01
      856     333_426399 2001          S 3.700000e+01 -2.507389e-01 1.202473e-01
      857     333_426399 2001          N 2.320000e+02 -3.566995e+00 2.161904e-01
      858     333_426399 2001       maxN 4.300000e+01 -7.788177e-01 2.995591e-01
      859     333_426399 2001    Shannon 3.100125e+00 -9.308501e-03 1.054635e-01
      860     333_426399 2001    Simpson 9.280247e-01 -8.220532e-04 2.791912e-01
      861     333_426399 2001 invSimpson 1.389365e+01 -9.656682e-02 2.766856e-01
      862     333_426399 2001        PIE 9.320421e-01 -8.070474e-04 2.871327e-01
      863     333_426399 2001      DomMc 3.189655e-01  2.618359e-03 1.654141e-01
      864     333_426399 2001 expShannon 2.220074e+01 -1.455441e-01 1.495618e-01
      865     333_426399 2002          S 3.800000e+01 -2.507389e-01 1.202473e-01
      866     333_426399 2002          N 3.620000e+02 -3.566995e+00 2.161904e-01
      867     333_426399 2002       maxN 6.900000e+01 -7.788177e-01 2.995591e-01
      868     333_426399 2002    Shannon 2.936602e+00 -9.308501e-03 1.054635e-01
      869     333_426399 2002    Simpson 9.126706e-01 -8.220532e-04 2.791912e-01
      870     333_426399 2002 invSimpson 1.145089e+01 -9.656682e-02 2.766856e-01
      871     333_426399 2002        PIE 9.151987e-01 -8.070474e-04 2.871327e-01
      872     333_426399 2002      DomMc 3.535912e-01  2.618359e-03 1.654141e-01
      873     333_426399 2002 expShannon 1.885168e+01 -1.455441e-01 1.495618e-01
      874     333_426399 2003          S 4.800000e+01 -2.507389e-01 1.202473e-01
      875     333_426399 2003          N 4.150000e+02 -3.566995e+00 2.161904e-01
      876     333_426399 2003       maxN 8.600000e+01 -7.788177e-01 2.995591e-01
      877     333_426399 2003    Shannon 3.033984e+00 -9.308501e-03 1.054635e-01
      878     333_426399 2003    Simpson 9.092292e-01 -8.220532e-04 2.791912e-01
      879     333_426399 2003 invSimpson 1.101676e+01 -9.656682e-02 2.766856e-01
      880     333_426399 2003        PIE 9.114254e-01 -8.070474e-04 2.871327e-01
      881     333_426399 2003      DomMc 3.734940e-01  2.618359e-03 1.654141e-01
      882     333_426399 2003 expShannon 2.077985e+01 -1.455441e-01 1.495618e-01
      883     333_426399 2004          S 3.500000e+01 -2.507389e-01 1.202473e-01
      884     333_426399 2004          N 5.130000e+02 -3.566995e+00 2.161904e-01
      885     333_426399 2004       maxN 1.150000e+02 -7.788177e-01 2.995591e-01
      886     333_426399 2004    Shannon 2.685701e+00 -9.308501e-03 1.054635e-01
      887     333_426399 2004    Simpson 8.823988e-01 -8.220532e-04 2.791912e-01
      888     333_426399 2004 invSimpson 8.503312e+00 -9.656682e-02 2.766856e-01
      889     333_426399 2004        PIE 8.841222e-01 -8.070474e-04 2.871327e-01
      890     333_426399 2004      DomMc 4.424951e-01  2.618359e-03 1.654141e-01
      891     333_426399 2004 expShannon 1.466848e+01 -1.455441e-01 1.495618e-01
      892     333_426399 2005          S 4.400000e+01 -2.507389e-01 1.202473e-01
      893     333_426399 2005          N 4.380000e+02 -3.566995e+00 2.161904e-01
      894     333_426399 2005       maxN 6.400000e+01 -7.788177e-01 2.995591e-01
      895     333_426399 2005    Shannon 3.210097e+00 -9.308501e-03 1.054635e-01
      896     333_426399 2005    Simpson 9.383145e-01 -8.220532e-04 2.791912e-01
      897     333_426399 2005 invSimpson 1.621126e+01 -9.656682e-02 2.766856e-01
      898     333_426399 2005        PIE 9.404616e-01 -8.070474e-04 2.871327e-01
      899     333_426399 2005      DomMc 2.762557e-01  2.618359e-03 1.654141e-01
      900     333_426399 2005 expShannon 2.478148e+01 -1.455441e-01 1.495618e-01
      901     333_426399 2006          S 4.900000e+01 -2.507389e-01 1.202473e-01
      902     333_426399 2006          N 3.070000e+02 -3.566995e+00 2.161904e-01
      903     333_426399 2006       maxN 5.300000e+01 -7.788177e-01 2.995591e-01
      904     333_426399 2006    Shannon 3.152383e+00 -9.308501e-03 1.054635e-01
      905     333_426399 2006    Simpson 9.234050e-01 -8.220532e-04 2.791912e-01
      906     333_426399 2006 invSimpson 1.305569e+01 -9.656682e-02 2.766856e-01
      907     333_426399 2006        PIE 9.264227e-01 -8.070474e-04 2.871327e-01
      908     333_426399 2006      DomMc 3.420195e-01  2.618359e-03 1.654141e-01
      909     333_426399 2006 expShannon 2.339174e+01 -1.455441e-01 1.495618e-01
      910     333_426399 2007          S 4.500000e+01 -2.507389e-01 1.202473e-01
      911     333_426399 2007          N 3.990000e+02 -3.566995e+00 2.161904e-01
      912     333_426399 2007       maxN 7.000000e+01 -7.788177e-01 2.995591e-01
      913     333_426399 2007    Shannon 2.856919e+00 -9.308501e-03 1.054635e-01
      914     333_426399 2007    Simpson 9.036878e-01 -8.220532e-04 2.791912e-01
      915     333_426399 2007 invSimpson 1.038290e+01 -9.656682e-02 2.766856e-01
      916     333_426399 2007        PIE 9.059584e-01 -8.070474e-04 2.871327e-01
      917     333_426399 2007      DomMc 3.233083e-01  2.618359e-03 1.654141e-01
      918     333_426399 2007 expShannon 1.740780e+01 -1.455441e-01 1.495618e-01
      919     333_426399 2008          S 4.600000e+01 -2.507389e-01 1.202473e-01
      920     333_426399 2008          N 3.120000e+02 -3.566995e+00 2.161904e-01
      921     333_426399 2008       maxN 3.600000e+01 -7.788177e-01 2.995591e-01
      922     333_426399 2008    Shannon 3.336416e+00 -9.308501e-03 1.054635e-01
      923     333_426399 2008    Simpson 9.510807e-01 -8.220532e-04 2.791912e-01
      924     333_426399 2008 invSimpson 2.044183e+01 -9.656682e-02 2.766856e-01
      925     333_426399 2008        PIE 9.541388e-01 -8.070474e-04 2.871327e-01
      926     333_426399 2008      DomMc 1.891026e-01  2.618359e-03 1.654141e-01
      927     333_426399 2008 expShannon 2.811816e+01 -1.455441e-01 1.495618e-01
      928     333_426399 1983          S 4.800000e+01 -2.507389e-01 1.202473e-01
      929     333_426399 1983          N 4.360000e+02 -3.566995e+00 2.161904e-01
      930     333_426399 1983       maxN 1.700000e+02 -7.788177e-01 2.995591e-01
      931     333_426399 1983    Shannon 2.716910e+00 -9.308501e-03 1.054635e-01
      932     333_426399 1983    Simpson 8.295808e-01 -8.220532e-04 2.791912e-01
      933     333_426399 1983 invSimpson 5.867885e+00 -9.656682e-02 2.766856e-01
      934     333_426399 1983        PIE 8.314879e-01 -8.070474e-04 2.871327e-01
      935     333_426399 1983      DomMc 4.701835e-01  2.618359e-03 1.654141e-01
      936     333_426399 1983 expShannon 1.513348e+01 -1.455441e-01 1.495618e-01
      937     333_426399 1986          S 3.800000e+01 -2.507389e-01 1.202473e-01
      938     333_426399 1986          N 2.980000e+02 -3.566995e+00 2.161904e-01
      939     333_426399 1986       maxN 3.600000e+01 -7.788177e-01 2.995591e-01
      940     333_426399 1986    Shannon 3.231694e+00 -9.308501e-03 1.054635e-01
      941     333_426399 1986    Simpson 9.464889e-01 -8.220532e-04 2.791912e-01
      942     333_426399 1986 invSimpson 1.868771e+01 -9.656682e-02 2.766856e-01
      943     333_426399 1986        PIE 9.496757e-01 -8.070474e-04 2.871327e-01
      944     333_426399 1986      DomMc 2.315436e-01  2.618359e-03 1.654141e-01
      945     333_426399 1986 expShannon 2.532251e+01 -1.455441e-01 1.495618e-01
      946     333_426399 1990          S 4.900000e+01 -2.507389e-01 1.202473e-01
      947     333_426399 1990          N 4.380000e+02 -3.566995e+00 2.161904e-01
      948     333_426399 1990       maxN 4.900000e+01 -7.788177e-01 2.995591e-01
      949     333_426399 1990    Shannon 3.308385e+00 -9.308501e-03 1.054635e-01
      950     333_426399 1990    Simpson 9.503451e-01 -8.220532e-04 2.791912e-01
      951     333_426399 1990 invSimpson 2.013899e+01 -9.656682e-02 2.766856e-01
      952     333_426399 1990        PIE 9.525198e-01 -8.070474e-04 2.871327e-01
      953     333_426399 1990      DomMc 1.826484e-01  2.618359e-03 1.654141e-01
      954     333_426399 1990 expShannon 2.734095e+01 -1.455441e-01 1.495618e-01
      955     333_426399 2009          S 1.800000e+01 -2.507389e-01 1.202473e-01
      956     333_426399 2009          N 1.560000e+02 -3.566995e+00 2.161904e-01
      957     333_426399 2009       maxN 5.800000e+01 -7.788177e-01 2.995591e-01
      958     333_426399 2009    Shannon 2.055734e+00 -9.308501e-03 1.054635e-01
      959     333_426399 2009    Simpson 7.997206e-01 -8.220532e-04 2.791912e-01
      960     333_426399 2009 invSimpson 4.993024e+00 -9.656682e-02 2.766856e-01
      961     333_426399 2009        PIE 8.048801e-01 -8.070474e-04 2.871327e-01
      962     333_426399 2009      DomMc 5.576923e-01  2.618359e-03 1.654141e-01
      963     333_426399 2009 expShannon 7.812567e+00 -1.455441e-01 1.495618e-01
      964    372_2374177 2009          S 2.600000e+01 -1.000000e+00 6.983926e-01
      965    372_2374177 2009          N 3.490000e+02  8.400000e+00 9.735759e-01
      966    372_2374177 2009       maxN 7.300000e+01  7.000000e+00 9.705844e-01
      967    372_2374177 2009    Shannon 2.560142e+00 -5.027098e-03 9.830170e-01
      968    372_2374177 2009    Simpson 8.944097e-01 -1.295316e-03 9.839092e-01
      969    372_2374177 2009 invSimpson 9.470570e+00 -2.473076e-01 8.950933e-01
      970    372_2374177 2009        PIE 8.969799e-01 -1.152933e-03 9.858000e-01
      971    372_2374177 2009      DomMc 3.581662e-01 -2.795814e-03 9.731059e-01
      972    372_2374177 2009 expShannon 1.293766e+01 -2.134265e-01 9.307716e-01
      973    372_2374177 2010          S 3.900000e+01 -1.000000e+00 6.983926e-01
      974    372_2374177 2010          N 1.733000e+03  8.400000e+00 9.735759e-01
      975    372_2374177 2010       maxN 1.140000e+03  7.000000e+00 9.705844e-01
      976    372_2374177 2010    Shannon 1.548697e+00 -5.027098e-03 9.830170e-01
      977    372_2374177 2010    Simpson 5.503933e-01 -1.295316e-03 9.839092e-01
      978    372_2374177 2010 invSimpson 2.224166e+00 -2.473076e-01 8.950933e-01
      979    372_2374177 2010        PIE 5.507110e-01 -1.152933e-03 9.858000e-01
      980    372_2374177 2010      DomMc 7.732256e-01 -2.795814e-03 9.731059e-01
      981    372_2374177 2010 expShannon 4.705336e+00 -2.134265e-01 9.307716e-01
      982    372_2374177 2008          S 3.700000e+01 -1.000000e+00 6.983926e-01
      983    372_2374177 2008          N 2.510000e+02  8.400000e+00 9.735759e-01
      984    372_2374177 2008       maxN 3.800000e+01  7.000000e+00 9.705844e-01
      985    372_2374177 2008    Shannon 3.031585e+00 -5.027098e-03 9.830170e-01
      986    372_2374177 2008    Simpson 9.305249e-01 -1.295316e-03 9.839092e-01
      987    372_2374177 2008 invSimpson 1.439365e+01 -2.473076e-01 8.950933e-01
      988    372_2374177 2008        PIE 9.342470e-01 -1.152933e-03 9.858000e-01
      989    372_2374177 2008      DomMc 2.788845e-01 -2.795814e-03 9.731059e-01
      990    372_2374177 2008 expShannon 2.073006e+01 -2.134265e-01 9.307716e-01
      991    372_2374177 2011          S 3.800000e+01 -1.000000e+00 6.983926e-01
      992    372_2374177 2011          N 5.570000e+02  8.400000e+00 9.735759e-01
      993    372_2374177 2011       maxN 1.530000e+02  7.000000e+00 9.705844e-01
      994    372_2374177 2011    Shannon 2.852837e+00 -5.027098e-03 9.830170e-01
      995    372_2374177 2011    Simpson 8.946298e-01 -1.295316e-03 9.839092e-01
      996    372_2374177 2011 invSimpson 9.490349e+00 -2.473076e-01 8.950933e-01
      997    372_2374177 2011        PIE 8.962388e-01 -1.152933e-03 9.858000e-01
      998    372_2374177 2011      DomMc 3.482944e-01 -2.795814e-03 9.731059e-01
      999    372_2374177 2011 expShannon 1.733689e+01 -2.134265e-01 9.307716e-01
      1000   372_2374177 2012          S 2.600000e+01 -1.000000e+00 6.983926e-01
      1001   372_2374177 2012          N 1.890000e+02  8.400000e+00 9.735759e-01
      1002   372_2374177 2012       maxN 3.300000e+01  7.000000e+00 9.705844e-01
      1003   372_2374177 2012    Shannon 2.860102e+00 -5.027098e-03 9.830170e-01
      1004   372_2374177 2012    Simpson 9.239383e-01 -1.295316e-03 9.839092e-01
      1005   372_2374177 2012 invSimpson 1.314722e+01 -2.473076e-01 8.950933e-01
      1006   372_2374177 2012        PIE 9.288529e-01 -1.152933e-03 9.858000e-01
      1007   372_2374177 2012      DomMc 2.698413e-01 -2.795814e-03 9.731059e-01
      1008   372_2374177 2012 expShannon 1.746331e+01 -2.134265e-01 9.307716e-01
      1009   372_2378534 2011          S 3.300000e+01 -2.600000e+00 5.374808e-01
      1010   372_2378534 2011          N 1.990000e+02 -2.280000e+01 3.230576e-01
      1011   372_2378534 2011       maxN 3.900000e+01 -4.200000e+00 1.976312e-01
      1012   372_2378534 2011    Shannon 2.782694e+00 -4.553543e-02 6.831885e-01
      1013   372_2378534 2011    Simpson 9.028560e-01 -2.632235e-03 7.824531e-01
      1014   372_2378534 2011 invSimpson 1.029400e+01 -1.114454e-01 8.814844e-01
      1015   372_2378534 2011        PIE 9.074159e-01 -1.685606e-03 8.496586e-01
      1016   372_2378534 2011      DomMc 3.668342e-01 -1.056774e-02 4.823376e-01
      1017   372_2378534 2011 expShannon 1.616250e+01 -4.583607e-01 7.549844e-01
      1018   372_2378534 2009          S 2.600000e+01 -2.600000e+00 5.374808e-01
      1019   372_2378534 2009          N 1.850000e+02 -2.280000e+01 3.230576e-01
      1020   372_2378534 2009       maxN 4.300000e+01 -4.200000e+00 1.976312e-01
      1021   372_2378534 2009    Shannon 2.551223e+00 -4.553543e-02 6.831885e-01
      1022   372_2378534 2009    Simpson 8.817531e-01 -2.632235e-03 7.824531e-01
      1023   372_2378534 2009 invSimpson 8.456882e+00 -1.114454e-01 8.814844e-01
      1024   372_2378534 2009        PIE 8.865452e-01 -1.685606e-03 8.496586e-01
      1025   372_2378534 2009      DomMc 4.108108e-01 -1.056774e-02 4.823376e-01
      1026   372_2378534 2009 expShannon 1.282278e+01 -4.583607e-01 7.549844e-01
      1027   372_2378534 2010          S 2.900000e+01 -2.600000e+00 5.374808e-01
      1028   372_2378534 2010          N 2.050000e+02 -2.280000e+01 3.230576e-01
      1029   372_2378534 2010       maxN 4.800000e+01 -4.200000e+00 1.976312e-01
      1030   372_2378534 2010    Shannon 2.570287e+00 -4.553543e-02 6.831885e-01
      1031   372_2378534 2010    Simpson 8.790006e-01 -2.632235e-03 7.824531e-01
      1032   372_2378534 2010 invSimpson 8.264503e+00 -1.114454e-01 8.814844e-01
      1033   372_2378534 2010        PIE 8.833094e-01 -1.685606e-03 8.496586e-01
      1034   372_2378534 2010      DomMc 4.292683e-01 -1.056774e-02 4.823376e-01
      1035   372_2378534 2010 expShannon 1.306957e+01 -4.583607e-01 7.549844e-01
      1036   372_2378534 2012          S 1.600000e+01 -2.600000e+00 5.374808e-01
      1037   372_2378534 2012          N 1.110000e+02 -2.280000e+01 3.230576e-01
      1038   372_2378534 2012       maxN 3.200000e+01 -4.200000e+00 1.976312e-01
      1039   372_2378534 2012    Shannon 2.328636e+00 -4.553543e-02 6.831885e-01
      1040   372_2378534 2012    Simpson 8.650272e-01 -2.632235e-03 7.824531e-01
      1041   372_2378534 2012 invSimpson 7.408900e+00 -1.114454e-01 8.814844e-01
      1042   372_2378534 2012        PIE 8.728911e-01 -1.685606e-03 8.496586e-01
      1043   372_2378534 2012      DomMc 3.963964e-01 -1.056774e-02 4.823376e-01
      1044   372_2378534 2012 expShannon 1.026393e+01 -4.583607e-01 7.549844e-01
      1045   372_2425908 2008          S 3.100000e+01 -1.100000e+00 4.206266e-01
      1046   372_2425908 2008          N 2.700000e+02  1.860000e+01 1.652717e-01
      1047   372_2425908 2008       maxN 5.500000e+01 -6.000000e-01 8.440630e-01
      1048   372_2425908 2008    Shannon 2.883840e+00 -1.419692e-02 8.305191e-01
      1049   372_2425908 2008    Simpson 9.156379e-01  2.809002e-03 6.676339e-01
      1050   372_2425908 2008 invSimpson 1.185366e+01  2.484388e-01 7.172562e-01
      1051   372_2425908 2008        PIE 9.190417e-01  2.621206e-03 6.859745e-01
      1052   372_2425908 2008      DomMc 3.222222e-01 -1.698602e-02 2.866697e-01
      1053   372_2425908 2008 expShannon 1.788281e+01 -3.055393e-01 7.504371e-01
      1054   372_2425908 2010          S 2.800000e+01 -1.100000e+00 4.206266e-01
      1055   372_2425908 2010          N 2.670000e+02  1.860000e+01 1.652717e-01
      1056   372_2425908 2010       maxN 4.100000e+01 -6.000000e-01 8.440630e-01
      1057   372_2425908 2010    Shannon 2.841133e+00 -1.419692e-02 8.305191e-01
      1058   372_2425908 2010    Simpson 9.234244e-01  2.809002e-03 6.676339e-01
      1059   372_2425908 2010 invSimpson 1.305899e+01  2.484388e-01 7.172562e-01
      1060   372_2425908 2010        PIE 9.268959e-01  2.621206e-03 6.859745e-01
      1061   372_2425908 2010      DomMc 2.659176e-01 -1.698602e-02 2.866697e-01
      1062   372_2425908 2010 expShannon 1.713517e+01 -3.055393e-01 7.504371e-01
      1063   372_2425908 2011          S 2.200000e+01 -1.100000e+00 4.206266e-01
      1064   372_2425908 2011          N 2.710000e+02  1.860000e+01 1.652717e-01
      1065   372_2425908 2011       maxN 4.400000e+01 -6.000000e-01 8.440630e-01
      1066   372_2425908 2011    Shannon 2.680879e+00 -1.419692e-02 8.305191e-01
      1067   372_2425908 2011    Simpson 9.125148e-01  2.809002e-03 6.676339e-01
      1068   372_2425908 2011 invSimpson 1.143051e+01  2.484388e-01 7.172562e-01
      1069   372_2425908 2011        PIE 9.158945e-01  2.621206e-03 6.859745e-01
      1070   372_2425908 2011      DomMc 3.025830e-01 -1.698602e-02 2.866697e-01
      1071   372_2425908 2011 expShannon 1.459792e+01 -3.055393e-01 7.504371e-01
      1072   372_2425908 2012          S 2.600000e+01 -1.100000e+00 4.206266e-01
      1073   372_2425908 2012          N 3.450000e+02  1.860000e+01 1.652717e-01
      1074   372_2425908 2012       maxN 5.800000e+01 -6.000000e-01 8.440630e-01
      1075   372_2425908 2012    Shannon 2.700191e+00 -1.419692e-02 8.305191e-01
      1076   372_2425908 2012    Simpson 9.133711e-01  2.809002e-03 6.676339e-01
      1077   372_2425908 2012 invSimpson 1.154350e+01  2.484388e-01 7.172562e-01
      1078   372_2425908 2012        PIE 9.160263e-01  2.621206e-03 6.859745e-01
      1079   372_2425908 2012      DomMc 2.753623e-01 -1.698602e-02 2.866697e-01
      1080   372_2425908 2012 expShannon 1.488258e+01 -3.055393e-01 7.504371e-01
      1081   372_2425908 2009          S 2.300000e+01 -1.100000e+00 4.206266e-01
      1082   372_2425908 2009          N 2.350000e+02  1.860000e+01 1.652717e-01
      1083   372_2425908 2009       maxN 5.600000e+01 -6.000000e-01 8.440630e-01
      1084   372_2425908 2009    Shannon 2.455552e+00 -1.419692e-02 8.305191e-01
      1085   372_2425908 2009    Simpson 8.798914e-01  2.809002e-03 6.676339e-01
      1086   372_2425908 2009 invSimpson 8.325795e+00  2.484388e-01 7.172562e-01
      1087   372_2425908 2009        PIE 8.836516e-01  2.621206e-03 6.859745e-01
      1088   372_2425908 2009      DomMc 3.787234e-01 -1.698602e-02 2.866697e-01
      1089   372_2425908 2009 expShannon 1.165286e+01 -3.055393e-01 7.504371e-01
      1090   372_2427363 2010          S 3.500000e+01 -1.900000e+00 4.036234e-01
      1091   372_2427363 2010          N 6.680000e+02 -1.016000e+02 4.426543e-01
      1092   372_2427363 2010       maxN 1.910000e+02  3.100000e+00 6.528666e-01
      1093   372_2427363 2010    Shannon 2.525286e+00 -4.879916e-02 5.097245e-01
      1094   372_2427363 2010    Simpson 8.526883e-01 -6.275651e-03 6.541698e-01
      1095   372_2427363 2010 invSimpson 6.788329e+00 -4.492538e-01 6.316265e-01
      1096   372_2427363 2010        PIE 8.539667e-01 -6.190346e-03 6.555616e-01
      1097   372_2427363 2010      DomMc 5.104790e-01  1.668092e-02 7.277495e-01
      1098   372_2427363 2010 expShannon 1.249447e+01 -6.291730e-01 5.302541e-01
      1099   372_2427363 2011          S 4.000000e+01 -1.900000e+00 4.036234e-01
      1100   372_2427363 2011          N 9.810000e+02 -1.016000e+02 4.426543e-01
      1101   372_2427363 2011       maxN 2.190000e+02  3.100000e+00 6.528666e-01
      1102   372_2427363 2011    Shannon 2.727757e+00 -4.879916e-02 5.097245e-01
      1103   372_2427363 2011    Simpson 8.972683e-01 -6.275651e-03 6.541698e-01
      1104   372_2427363 2011 invSimpson 9.734092e+00 -4.492538e-01 6.316265e-01
      1105   372_2427363 2011        PIE 8.981839e-01 -6.190346e-03 6.555616e-01
      1106   372_2427363 2011      DomMc 3.598369e-01  1.668092e-02 7.277495e-01
      1107   372_2427363 2011 expShannon 1.529854e+01 -6.291730e-01 5.302541e-01
      1108   372_2427363 2009          S 3.900000e+01 -1.900000e+00 4.036234e-01
      1109   372_2427363 2009          N 1.184000e+03 -1.016000e+02 4.426543e-01
      1110   372_2427363 2009       maxN 2.020000e+02  3.100000e+00 6.528666e-01
      1111   372_2427363 2009    Shannon 2.691077e+00 -4.879916e-02 5.097245e-01
      1112   372_2427363 2009    Simpson 8.964387e-01 -6.275651e-03 6.541698e-01
      1113   372_2427363 2009 invSimpson 9.656119e+00 -4.492538e-01 6.316265e-01
      1114   372_2427363 2009        PIE 8.971965e-01 -6.190346e-03 6.555616e-01
      1115   372_2427363 2009      DomMc 3.395270e-01  1.668092e-02 7.277495e-01
      1116   372_2427363 2009 expShannon 1.474755e+01 -6.291730e-01 5.302541e-01
      1117   372_2427363 2012          S 3.100000e+01 -1.900000e+00 4.036234e-01
      1118   372_2427363 2012          N 7.410000e+02 -1.016000e+02 4.426543e-01
      1119   372_2427363 2012       maxN 2.030000e+02  3.100000e+00 6.528666e-01
      1120   372_2427363 2012    Shannon 2.460923e+00 -4.879916e-02 5.097245e-01
      1121   372_2427363 2012    Simpson 8.606599e-01 -6.275651e-03 6.541698e-01
      1122   372_2427363 2012 invSimpson 7.176685e+00 -4.492538e-01 6.316265e-01
      1123   372_2427363 2012        PIE 8.618230e-01 -6.190346e-03 6.555616e-01
      1124   372_2427363 2012      DomMc 4.453441e-01  1.668092e-02 7.277495e-01
      1125   372_2427363 2012 expShannon 1.171562e+01 -6.291730e-01 5.302541e-01
      1126   372_2428091 2011          S 4.500000e+01  8.000000e-01 7.861910e-01
      1127   372_2428091 2011          N 1.020000e+03  9.440000e+01 5.081038e-01
      1128   372_2428091 2011       maxN 1.680000e+02  4.950000e+01 1.209562e-01
      1129   372_2428091 2011    Shannon 2.871390e+00 -1.001699e-01 1.599115e-01
      1130   372_2428091 2011    Simpson 9.177893e-01 -1.442121e-02 1.151129e-01
      1131   372_2428091 2011 invSimpson 1.216387e+01 -1.694096e+00 7.800242e-02
      1132   372_2428091 2011        PIE 9.186900e-01 -1.461660e-02 1.102946e-01
      1133   372_2428091 2011      DomMc 2.892157e-01  3.808997e-02 9.857430e-02
      1134   372_2428091 2011 expShannon 1.766154e+01 -1.572065e+00 1.530025e-01
      1135   372_2428091 2012          S 3.600000e+01  8.000000e-01 7.861910e-01
      1136   372_2428091 2012          N 8.400000e+02  9.440000e+01 5.081038e-01
      1137   372_2428091 2012       maxN 2.240000e+02  4.950000e+01 1.209562e-01
      1138   372_2428091 2012    Shannon 2.578228e+00 -1.001699e-01 1.599115e-01
      1139   372_2428091 2012    Simpson 8.806122e-01 -1.442121e-02 1.151129e-01
      1140   372_2428091 2012 invSimpson 8.376068e+00 -1.694096e+00 7.800242e-02
      1141   372_2428091 2012        PIE 8.816618e-01 -1.461660e-02 1.102946e-01
      1142   372_2428091 2012      DomMc 3.821429e-01  3.808997e-02 9.857430e-02
      1143   372_2428091 2012 expShannon 1.317378e+01 -1.572065e+00 1.530025e-01
      1144   372_2428091 2009          S 3.700000e+01  8.000000e-01 7.861910e-01
      1145   372_2428091 2009          N 7.220000e+02  9.440000e+01 5.081038e-01
      1146   372_2428091 2009       maxN 9.400000e+01  4.950000e+01 1.209562e-01
      1147   372_2428091 2009    Shannon 2.926632e+00 -1.001699e-01 1.599115e-01
      1148   372_2428091 2009    Simpson 9.287068e-01 -1.442121e-02 1.151129e-01
      1149   372_2428091 2009 invSimpson 1.402658e+01 -1.694096e+00 7.800242e-02
      1150   372_2428091 2009        PIE 9.299949e-01 -1.461660e-02 1.102946e-01
      1151   372_2428091 2009      DomMc 2.562327e-01  3.808997e-02 9.857430e-02
      1152   372_2428091 2009 expShannon 1.866467e+01 -1.572065e+00 1.530025e-01
      1153   372_2428091 2010          S 3.400000e+01  8.000000e-01 7.861910e-01
      1154   372_2428091 2010          N 4.300000e+02  9.440000e+01 5.081038e-01
      1155   372_2428091 2010       maxN 6.300000e+01  4.950000e+01 1.209562e-01
      1156   372_2428091 2010    Shannon 2.827877e+00 -1.001699e-01 1.599115e-01
      1157   372_2428091 2010    Simpson 9.177177e-01 -1.442121e-02 1.151129e-01
      1158   372_2428091 2010 invSimpson 1.215328e+01 -1.694096e+00 7.800242e-02
      1159   372_2428091 2010        PIE 9.198569e-01 -1.461660e-02 1.102946e-01
      1160   372_2428091 2010      DomMc 2.860465e-01  3.808997e-02 9.857430e-02
      1161   372_2428091 2010 expShannon 1.690953e+01 -1.572065e+00 1.530025e-01
      1162   372_2425904 2009          S 2.300000e+01 -6.000000e-01 3.585730e-01
      1163   372_2425904 2009          N 1.530000e+02  8.100000e+00 6.792425e-01
      1164   372_2425904 2009       maxN 5.400000e+01 -8.300000e+00 3.029884e-01
      1165   372_2425904 2009    Shannon 2.388161e+00  4.728845e-02 1.996768e-01
      1166   372_2425904 2009    Simpson 8.367722e-01  1.696522e-02 1.164587e-01
      1167   372_2425904 2009 invSimpson 6.126407e+00  9.204613e-01 1.800229e-01
      1168   372_2425904 2009        PIE 8.422773e-01  1.684731e-02 1.170349e-01
      1169   372_2425904 2009      DomMc 4.705882e-01 -3.588724e-02 1.764026e-01
      1170   372_2425904 2009 expShannon 1.089344e+01  5.195560e-01 2.129687e-01
      1171   372_2425904 2011          S 1.900000e+01 -6.000000e-01 3.585730e-01
      1172   372_2425904 2011          N 2.240000e+02  8.100000e+00 6.792425e-01
      1173   372_2425904 2011       maxN 3.700000e+01 -8.300000e+00 3.029884e-01
      1174   372_2425904 2011    Shannon 2.540007e+00  4.728845e-02 1.996768e-01
      1175   372_2425904 2011    Simpson 9.018256e-01  1.696522e-02 1.164587e-01
      1176   372_2425904 2011 invSimpson 1.018595e+01  9.204613e-01 1.800229e-01
      1177   372_2425904 2011        PIE 9.058696e-01  1.684731e-02 1.170349e-01
      1178   372_2425904 2011      DomMc 3.125000e-01 -3.588724e-02 1.764026e-01
      1179   372_2425904 2011 expShannon 1.267975e+01  5.195560e-01 2.129687e-01
      1180   372_2425904 2008          S 2.100000e+01 -6.000000e-01 3.585730e-01
      1181   372_2425904 2008          N 2.480000e+02  8.100000e+00 6.792425e-01
      1182   372_2425904 2008       maxN 8.900000e+01 -8.300000e+00 3.029884e-01
      1183   372_2425904 2008    Shannon 2.281352e+00  4.728845e-02 1.996768e-01
      1184   372_2425904 2008    Simpson 8.288892e-01  1.696522e-02 1.164587e-01
      1185   372_2425904 2008 invSimpson 5.844166e+00  9.204613e-01 1.800229e-01
      1186   372_2425904 2008        PIE 8.322450e-01  1.684731e-02 1.170349e-01
      1187   372_2425904 2008      DomMc 4.798387e-01 -3.588724e-02 1.764026e-01
      1188   372_2425904 2008 expShannon 9.789904e+00  5.195560e-01 2.129687e-01
      1189   372_2425904 2012          S 2.000000e+01 -6.000000e-01 3.585730e-01
      1190   372_2425904 2012          N 2.530000e+02  8.100000e+00 6.792425e-01
      1191   372_2425904 2012       maxN 5.600000e+01 -8.300000e+00 3.029884e-01
      1192   372_2425904 2012    Shannon 2.441871e+00  4.728845e-02 1.996768e-01
      1193   372_2425904 2012    Simpson 8.811886e-01  1.696522e-02 1.164587e-01
      1194   372_2425904 2012 invSimpson 8.416700e+00  9.204613e-01 1.800229e-01
      1195   372_2425904 2012        PIE 8.846854e-01  1.684731e-02 1.170349e-01
      1196   372_2425904 2012      DomMc 3.794466e-01 -3.588724e-02 1.764026e-01
      1197   372_2425904 2012 expShannon 1.149453e+01  5.195560e-01 2.129687e-01
      1198   372_2407700 2008          S 9.000000e+00  2.700000e+00 5.146741e-01
      1199   372_2407700 2008          N 3.600000e+01  9.600000e+00 7.082053e-01
      1200   372_2407700 2008       maxN 8.000000e+00  1.800000e+00 6.913025e-01
      1201   372_2407700 2008    Shannon 2.076604e+00  1.497458e-01 5.007163e-01
      1202   372_2407700 2008    Simpson 8.626543e-01  1.162206e-02 5.467439e-01
      1203   372_2407700 2008 invSimpson 7.280899e+00  9.500937e-01 6.335605e-01
      1204   372_2407700 2008        PIE 8.873016e-01  8.301115e-03 6.403021e-01
      1205   372_2407700 2008      DomMc 3.888889e-01 -1.808904e-02 6.886790e-01
      1206   372_2407700 2008 expShannon 7.977334e+00  1.586284e+00 5.770425e-01
      1207   372_2407700 2010          S 1.700000e+01  2.700000e+00 5.146741e-01
      1208   372_2407700 2010          N 1.220000e+02  9.600000e+00 7.082053e-01
      1209   372_2407700 2010       maxN 2.500000e+01  1.800000e+00 6.913025e-01
      1210   372_2407700 2010    Shannon 2.323155e+00  1.497458e-01 5.007163e-01
      1211   372_2407700 2010    Simpson 8.728836e-01  1.162206e-02 5.467439e-01
      1212   372_2407700 2010 invSimpson 7.866808e+00  9.500937e-01 6.335605e-01
      1213   372_2407700 2010        PIE 8.800975e-01  8.301115e-03 6.403021e-01
      1214   372_2407700 2010      DomMc 4.098361e-01 -1.808904e-02 6.886790e-01
      1215   372_2407700 2010 expShannon 1.020783e+01  1.586284e+00 5.770425e-01
      1216   372_2407700 2009          S 2.600000e+01  2.700000e+00 5.146741e-01
      1217   372_2407700 2009          N 1.220000e+02  9.600000e+00 7.082053e-01
      1218   372_2407700 2009       maxN 1.900000e+01  1.800000e+00 6.913025e-01
      1219   372_2407700 2009    Shannon 2.909079e+00  1.497458e-01 5.007163e-01
      1220   372_2407700 2009    Simpson 9.286482e-01  1.162206e-02 5.467439e-01
      1221   372_2407700 2009 invSimpson 1.401507e+01  9.500937e-01 6.335605e-01
      1222   372_2407700 2009        PIE 9.363230e-01  8.301115e-03 6.403021e-01
      1223   372_2407700 2009      DomMc 2.622951e-01 -1.808904e-02 6.886790e-01
      1224   372_2407700 2009 expShannon 1.833990e+01  1.586284e+00 5.770425e-01
      1225   372_2407700 2011          S 2.100000e+01  2.700000e+00 5.146741e-01
      1226   372_2407700 2011          N 6.800000e+01  9.600000e+00 7.082053e-01
      1227   372_2407700 2011       maxN 1.200000e+01  1.800000e+00 6.913025e-01
      1228   372_2407700 2011    Shannon 2.771065e+00  1.497458e-01 5.007163e-01
      1229   372_2407700 2011    Simpson 9.199827e-01  1.162206e-02 5.467439e-01
      1230   372_2407700 2011 invSimpson 1.249730e+01  9.500937e-01 6.335605e-01
      1231   372_2407700 2011        PIE 9.337138e-01  8.301115e-03 6.403021e-01
      1232   372_2407700 2011      DomMc 2.794118e-01 -1.808904e-02 6.886790e-01
      1233   372_2407700 2011 expShannon 1.597564e+01  1.586284e+00 5.770425e-01
      1234   372_2398943 2009          S 3.500000e+01 -2.700000e+00 4.505791e-01
      1235   372_2398943 2009          N 4.990000e+02 -5.630000e+01 6.822127e-01
      1236   372_2398943 2009       maxN 1.270000e+02 -1.130000e+01 6.507668e-01
      1237   372_2398943 2009    Shannon 2.761833e+00 -6.324282e-02 4.247613e-01
      1238   372_2398943 2009    Simpson 8.922534e-01 -5.060962e-03 6.132083e-01
      1239   372_2398943 2009 invSimpson 9.281039e+00 -4.163194e-01 6.097500e-01
      1240   372_2398943 2009        PIE 8.940451e-01 -4.691939e-03 6.049686e-01
      1241   372_2398943 2009      DomMc 3.967936e-01  3.534800e-03 6.789227e-01
      1242   372_2398943 2009 expShannon 1.582883e+01 -9.640355e-01 4.326917e-01
      1243   372_2398943 2010          S 4.100000e+01 -2.700000e+00 4.505791e-01
      1244   372_2398943 2010          N 7.340000e+02 -5.630000e+01 6.822127e-01
      1245   372_2398943 2010       maxN 1.530000e+02 -1.130000e+01 6.507668e-01
      1246   372_2398943 2010    Shannon 2.896235e+00 -6.324282e-02 4.247613e-01
      1247   372_2398943 2010    Simpson 9.081514e-01 -5.060962e-03 6.132083e-01
      1248   372_2398943 2010 invSimpson 1.088748e+01 -4.163194e-01 6.097500e-01
      1249   372_2398943 2010        PIE 9.093903e-01 -4.691939e-03 6.049686e-01
      1250   372_2398943 2010      DomMc 3.705722e-01  3.534800e-03 6.789227e-01
      1251   372_2398943 2010 expShannon 1.810586e+01 -9.640355e-01 4.326917e-01
      1252   372_2398943 2011          S 2.600000e+01 -2.700000e+00 4.505791e-01
      1253   372_2398943 2011          N 1.770000e+02 -5.630000e+01 6.822127e-01
      1254   372_2398943 2011       maxN 5.500000e+01 -1.130000e+01 6.507668e-01
      1255   372_2398943 2011    Shannon 2.564350e+00 -6.324282e-02 4.247613e-01
      1256   372_2398943 2011    Simpson 8.671199e-01 -5.060962e-03 6.132083e-01
      1257   372_2398943 2011 invSimpson 7.525583e+00 -4.163194e-01 6.097500e-01
      1258   372_2398943 2011        PIE 8.720467e-01 -4.691939e-03 6.049686e-01
      1259   372_2398943 2011      DomMc 4.011299e-01  3.534800e-03 6.789227e-01
      1260   372_2398943 2011 expShannon 1.299222e+01 -9.640355e-01 4.326917e-01
      1261   372_2398943 2012          S 3.100000e+01 -2.700000e+00 4.505791e-01
      1262   372_2398943 2012          N 4.970000e+02 -5.630000e+01 6.822127e-01
      1263   372_2398943 2012       maxN 1.220000e+02 -1.130000e+01 6.507668e-01
      1264   372_2398943 2012    Shannon 2.661652e+00 -6.324282e-02 4.247613e-01
      1265   372_2398943 2012    Simpson 8.890607e-01 -5.060962e-03 6.132083e-01
      1266   372_2398943 2012 invSimpson 9.013940e+00 -4.163194e-01 6.097500e-01
      1267   372_2398943 2012        PIE 8.908532e-01 -4.691939e-03 6.049686e-01
      1268   372_2398943 2012      DomMc 3.983903e-01  3.534800e-03 6.789227e-01
      1269   372_2398943 2012 expShannon 1.431992e+01 -9.640355e-01 4.326917e-01
      1270   372_2347198 2010          S 2.300000e+01 -3.000000e-01 8.651600e-01
      1271   372_2347198 2010          N 2.260000e+02 -3.410000e+01 1.252815e-01
      1272   372_2347198 2010       maxN 4.100000e+01 -1.210000e+01 2.755270e-01
      1273   372_2347198 2010    Shannon 2.484071e+00  4.622283e-02 4.850101e-01
      1274   372_2347198 2010    Simpson 8.911818e-01  8.284668e-03 3.587683e-01
      1275   372_2347198 2010 invSimpson 9.189637e+00  5.361927e-01 3.789554e-01
      1276   372_2347198 2010        PIE 8.951426e-01  8.789198e-03 3.437663e-01
      1277   372_2347198 2010      DomMc 3.274336e-01 -2.327635e-02 3.934743e-01
      1278   372_2347198 2010 expShannon 1.198998e+01  4.852883e-01 4.975387e-01
      1279   372_2347198 2009          S 1.700000e+01 -3.000000e-01 8.651600e-01
      1280   372_2347198 2009          N 3.150000e+02 -3.410000e+01 1.252815e-01
      1281   372_2347198 2009       maxN 8.600000e+01 -1.210000e+01 2.755270e-01
      1282   372_2347198 2009    Shannon 2.254740e+00  4.622283e-02 4.850101e-01
      1283   372_2347198 2009    Simpson 8.584329e-01  8.284668e-03 3.587683e-01
      1284   372_2347198 2009 invSimpson 7.063786e+00  5.361927e-01 3.789554e-01
      1285   372_2347198 2009        PIE 8.611667e-01  8.789198e-03 3.437663e-01
      1286   372_2347198 2009      DomMc 4.317460e-01 -2.327635e-02 3.934743e-01
      1287   372_2347198 2009 expShannon 9.532819e+00  4.852883e-01 4.975387e-01
      1288   372_2347198 2011          S 1.700000e+01 -3.000000e-01 8.651600e-01
      1289   372_2347198 2011          N 2.180000e+02 -3.410000e+01 1.252815e-01
      1290   372_2347198 2011       maxN 4.300000e+01 -1.210000e+01 2.755270e-01
      1291   372_2347198 2011    Shannon 2.303485e+00  4.622283e-02 4.850101e-01
      1292   372_2347198 2011    Simpson 8.705496e-01  8.284668e-03 3.587683e-01
      1293   372_2347198 2011 invSimpson 7.724967e+00  5.361927e-01 3.789554e-01
      1294   372_2347198 2011        PIE 8.745614e-01  8.789198e-03 3.437663e-01
      1295   372_2347198 2011      DomMc 3.899083e-01 -2.327635e-02 3.934743e-01
      1296   372_2347198 2011 expShannon 1.000900e+01  4.852883e-01 4.975387e-01
      1297   372_2347198 2012          S 1.800000e+01 -3.000000e-01 8.651600e-01
      1298   372_2347198 2012          N 2.040000e+02 -3.410000e+01 1.252815e-01
      1299   372_2347198 2012       maxN 4.500000e+01 -1.210000e+01 2.755270e-01
      1300   372_2347198 2012    Shannon 2.469012e+00  4.622283e-02 4.850101e-01
      1301   372_2347198 2012    Simpson 8.929258e-01  8.284668e-03 3.587683e-01
      1302   372_2347198 2012 invSimpson 9.339318e+00  5.361927e-01 3.789554e-01
      1303   372_2347198 2012        PIE 8.973244e-01  8.789198e-03 3.437663e-01
      1304   372_2347198 2012      DomMc 3.333333e-01 -2.327635e-02 3.934743e-01
      1305   372_2347198 2012 expShannon 1.181077e+01  4.852883e-01 4.975387e-01
      1306   372_2430280 2010          S 4.200000e+01  1.800000e+00 4.142929e-01
      1307   372_2430280 2010          N 5.060000e+02 -6.060000e+01 7.114047e-02
      1308   372_2430280 2010       maxN 7.700000e+01 -1.110000e+01 3.250562e-01
      1309   372_2430280 2010    Shannon 3.250355e+00  3.492057e-02 5.258353e-01
      1310   372_2430280 2010    Simpson 9.452499e-01  1.770659e-03 6.008077e-01
      1311   372_2430280 2010 invSimpson 1.826480e+01  4.012710e-01 6.229866e-01
      1312   372_2430280 2010        PIE 9.471217e-01  2.070385e-03 5.436000e-01
      1313   372_2430280 2010      DomMc 2.193676e-01  3.041705e-04 9.816094e-01
      1314   372_2430280 2010 expShannon 2.579950e+01  7.037657e-01 5.608122e-01
      1315   372_2430280 2011          S 4.100000e+01  1.800000e+00 4.142929e-01
      1316   372_2430280 2011          N 4.230000e+02 -6.060000e+01 7.114047e-02
      1317   372_2430280 2011       maxN 4.500000e+01 -1.110000e+01 3.250562e-01
      1318   372_2430280 2011    Shannon 3.137884e+00  3.492057e-02 5.258353e-01
      1319   372_2430280 2011    Simpson 9.424856e-01  1.770659e-03 6.008077e-01
      1320   372_2430280 2011 invSimpson 1.738694e+01  4.012710e-01 6.229866e-01
      1321   372_2430280 2011        PIE 9.447189e-01  2.070385e-03 5.436000e-01
      1322   372_2430280 2011      DomMc 2.033097e-01  3.041705e-04 9.816094e-01
      1323   372_2430280 2011 expShannon 2.305504e+01  7.037657e-01 5.608122e-01
      1324   372_2430280 2009          S 3.300000e+01  1.800000e+00 4.142929e-01
      1325   372_2430280 2009          N 6.230000e+02 -6.060000e+01 7.114047e-02
      1326   372_2430280 2009       maxN 1.200000e+02 -1.110000e+01 3.250562e-01
      1327   372_2430280 2009    Shannon 2.927235e+00  3.492057e-02 5.258353e-01
      1328   372_2430280 2009    Simpson 9.231776e-01  1.770659e-03 6.008077e-01
      1329   372_2430280 2009 invSimpson 1.301704e+01  4.012710e-01 6.229866e-01
      1330   372_2430280 2009        PIE 9.246618e-01  2.070385e-03 5.436000e-01
      1331   372_2430280 2009      DomMc 2.825040e-01  3.041705e-04 9.816094e-01
      1332   372_2430280 2009 expShannon 1.867592e+01  7.037657e-01 5.608122e-01
      1333   372_2430280 2008          S 2.800000e+01  1.800000e+00 4.142929e-01
      1334   372_2430280 2008          N 5.250000e+02 -6.060000e+01 7.114047e-02
      1335   372_2430280 2008       maxN 6.200000e+01 -1.110000e+01 3.250562e-01
      1336   372_2430280 2008    Shannon 2.919415e+00  3.492057e-02 5.258353e-01
      1337   372_2430280 2008    Simpson 9.334422e-01  1.770659e-03 6.008077e-01
      1338   372_2430280 2008 invSimpson 1.502453e+01  4.012710e-01 6.229866e-01
      1339   372_2430280 2008        PIE 9.352236e-01  2.070385e-03 5.436000e-01
      1340   372_2430280 2008      DomMc 2.228571e-01  3.041705e-04 9.816094e-01
      1341   372_2430280 2008 expShannon 1.853045e+01  7.037657e-01 5.608122e-01
      1342   372_2430280 2012          S 3.300000e+01  1.800000e+00 4.142929e-01
      1343   372_2430280 2012          N 3.220000e+02 -6.060000e+01 7.114047e-02
      1344   372_2430280 2012       maxN 4.400000e+01 -1.110000e+01 3.250562e-01
      1345   372_2430280 2012    Shannon 2.988694e+00  3.492057e-02 5.258353e-01
      1346   372_2430280 2012    Simpson 9.326415e-01  1.770659e-03 6.008077e-01
      1347   372_2430280 2012 invSimpson 1.484593e+01  4.012710e-01 6.229866e-01
      1348   372_2430280 2012        PIE 9.355469e-01  2.070385e-03 5.436000e-01
      1349   372_2430280 2012      DomMc 2.639752e-01  3.041705e-04 9.816094e-01
      1350   372_2430280 2012 expShannon 1.985972e+01  7.037657e-01 5.608122e-01
      1351   372_2428088 2010          S 2.900000e+01 -1.300000e+00 4.449898e-01
      1352   372_2428088 2010          N 1.690000e+02 -2.400000e+00 7.500555e-01
      1353   372_2428088 2010       maxN 3.100000e+01  7.600000e+00 6.005500e-02
      1354   372_2428088 2010    Shannon 2.884122e+00 -1.086183e-01 2.786011e-01
      1355   372_2428088 2010    Simpson 9.201358e-01 -2.122150e-02 1.110077e-01
      1356   372_2428088 2010 invSimpson 1.252126e+01 -1.692354e+00 1.161776e-01
      1357   372_2428088 2010        PIE 9.256128e-01 -2.130654e-02 1.083767e-01
      1358   372_2428088 2010      DomMc 3.136095e-01  5.356846e-02 2.351925e-02
      1359   372_2428088 2010 expShannon 1.788785e+01 -1.540458e+00 2.727261e-01
      1360   372_2428088 2008          S 2.800000e+01 -1.300000e+00 4.449898e-01
      1361   372_2428088 2008          N 1.830000e+02 -2.400000e+00 7.500555e-01
      1362   372_2428088 2008       maxN 2.900000e+01  7.600000e+00 6.005500e-02
      1363   372_2428088 2008    Shannon 2.948194e+00 -1.086183e-01 2.786011e-01
      1364   372_2428088 2008    Simpson 9.296784e-01 -2.122150e-02 1.110077e-01
      1365   372_2428088 2008 invSimpson 1.422038e+01 -1.692354e+00 1.161776e-01
      1366   372_2428088 2008        PIE 9.347865e-01 -2.130654e-02 1.083767e-01
      1367   372_2428088 2008      DomMc 2.732240e-01  5.356846e-02 2.351925e-02
      1368   372_2428088 2008 expShannon 1.907148e+01 -1.540458e+00 2.727261e-01
      1369   372_2428088 2011          S 2.500000e+01 -1.300000e+00 4.449898e-01
      1370   372_2428088 2011          N 1.550000e+02 -2.400000e+00 7.500555e-01
      1371   372_2428088 2011       maxN 3.900000e+01  7.600000e+00 6.005500e-02
      1372   372_2428088 2011    Shannon 2.673278e+00 -1.086183e-01 2.786011e-01
      1373   372_2428088 2011    Simpson 8.879917e-01 -2.122150e-02 1.110077e-01
      1374   372_2428088 2011 invSimpson 8.927908e+00 -1.692354e+00 1.161776e-01
      1375   372_2428088 2011        PIE 8.937579e-01 -2.130654e-02 1.083767e-01
      1376   372_2428088 2011      DomMc 4.193548e-01  5.356846e-02 2.351925e-02
      1377   372_2428088 2011 expShannon 1.448738e+01 -1.540458e+00 2.727261e-01
      1378   372_2428088 2012          S 1.900000e+01 -1.300000e+00 4.449898e-01
      1379   372_2428088 2012          N 1.590000e+02 -2.400000e+00 7.500555e-01
      1380   372_2428088 2012       maxN 6.000000e+01  7.600000e+00 6.005500e-02
      1381   372_2428088 2012    Shannon 2.287064e+00 -1.086183e-01 2.786011e-01
      1382   372_2428088 2012    Simpson 8.215656e-01 -2.122150e-02 1.110077e-01
      1383   372_2428088 2012 invSimpson 5.604301e+00 -1.692354e+00 1.161776e-01
      1384   372_2428088 2012        PIE 8.267654e-01 -2.130654e-02 1.083767e-01
      1385   372_2428088 2012      DomMc 5.031447e-01  5.356846e-02 2.351925e-02
      1386   372_2428088 2012 expShannon 9.845990e+00 -1.540458e+00 2.727261e-01
      1387   372_2428088 2009          S 2.000000e+01 -1.300000e+00 4.449898e-01
      1388   372_2428088 2009          N 1.310000e+02 -2.400000e+00 7.500555e-01
      1389   372_2428088 2009       maxN 2.500000e+01  7.600000e+00 6.005500e-02
      1390   372_2428088 2009    Shannon 2.437202e+00 -1.086183e-01 2.786011e-01
      1391   372_2428088 2009    Simpson 8.839811e-01 -2.122150e-02 1.110077e-01
      1392   372_2428088 2009 invSimpson 8.619287e+00 -1.692354e+00 1.161776e-01
      1393   372_2428088 2009        PIE 8.907810e-01 -2.130654e-02 1.083767e-01
      1394   372_2428088 2009      DomMc 3.435115e-01  5.356846e-02 2.351925e-02
      1395   372_2428088 2009 expShannon 1.144098e+01 -1.540458e+00 2.727261e-01
      1396   372_2407691 2008          S 2.000000e+01 -9.000000e-01 3.943777e-01
      1397   372_2407691 2008          N 1.280000e+02 -1.400000e+01 8.774774e-02
      1398   372_2407691 2008       maxN 4.000000e+01 -5.300000e+00 7.575668e-02
      1399   372_2407691 2008    Shannon 2.332818e+00 -2.994756e-03 9.506148e-01
      1400   372_2407691 2008    Simpson 8.450928e-01  5.370264e-03 4.791533e-01
      1401   372_2407691 2008 invSimpson 6.455477e+00  2.343960e-01 6.382251e-01
      1402   372_2407691 2008        PIE 8.517470e-01  7.236035e-03 3.608893e-01
      1403   372_2407691 2008      DomMc 5.000000e-01 -1.645969e-02 3.850684e-01
      1404   372_2407691 2008 expShannon 1.030695e+01 -7.168752e-02 9.029236e-01
      1405   372_2407691 2009          S 2.100000e+01 -9.000000e-01 3.943777e-01
      1406   372_2407691 2009          N 1.020000e+02 -1.400000e+01 8.774774e-02
      1407   372_2407691 2009       maxN 2.300000e+01 -5.300000e+00 7.575668e-02
      1408   372_2407691 2009    Shannon 2.653208e+00 -2.994756e-03 9.506148e-01
      1409   372_2407691 2009    Simpson 9.006151e-01  5.370264e-03 4.791533e-01
      1410   372_2407691 2009 invSimpson 1.006190e+01  2.343960e-01 6.382251e-01
      1411   372_2407691 2009        PIE 9.095321e-01  7.236035e-03 3.608893e-01
      1412   372_2407691 2009      DomMc 3.627451e-01 -1.645969e-02 3.850684e-01
      1413   372_2407691 2009 expShannon 1.419951e+01 -7.168752e-02 9.029236e-01
      1414   372_2407691 2010          S 2.400000e+01 -9.000000e-01 3.943777e-01
      1415   372_2407691 2010          N 1.050000e+02 -1.400000e+01 8.774774e-02
      1416   372_2407691 2010       maxN 2.600000e+01 -5.300000e+00 7.575668e-02
      1417   372_2407691 2010    Shannon 2.515280e+00 -2.994756e-03 9.506148e-01
      1418   372_2407691 2010    Simpson 8.756463e-01  5.370264e-03 4.791533e-01
      1419   372_2407691 2010 invSimpson 8.041575e+00  2.343960e-01 6.382251e-01
      1420   372_2407691 2010        PIE 8.840659e-01  7.236035e-03 3.608893e-01
      1421   372_2407691 2010      DomMc 4.285714e-01 -1.645969e-02 3.850684e-01
      1422   372_2407691 2010 expShannon 1.237008e+01 -7.168752e-02 9.029236e-01
      1423   372_2407691 2011          S 2.000000e+01 -9.000000e-01 3.943777e-01
      1424   372_2407691 2011          N 1.080000e+02 -1.400000e+01 8.774774e-02
      1425   372_2407691 2011       maxN 2.600000e+01 -5.300000e+00 7.575668e-02
      1426   372_2407691 2011    Shannon 2.491011e+00 -2.994756e-03 9.506148e-01
      1427   372_2407691 2011    Simpson 8.818587e-01  5.370264e-03 4.791533e-01
      1428   372_2407691 2011 invSimpson 8.464441e+00  2.343960e-01 6.382251e-01
      1429   372_2407691 2011        PIE 8.901004e-01  7.236035e-03 3.608893e-01
      1430   372_2407691 2011      DomMc 3.981481e-01 -1.645969e-02 3.850684e-01
      1431   372_2407691 2011 expShannon 1.207348e+01 -7.168752e-02 9.029236e-01
      1432   372_2407691 2012          S 1.600000e+01 -9.000000e-01 3.943777e-01
      1433   372_2407691 2012          N 5.500000e+01 -1.400000e+01 8.774774e-02
      1434   372_2407691 2012       maxN 1.200000e+01 -5.300000e+00 7.575668e-02
      1435   372_2407691 2012    Shannon 2.398943e+00 -2.994756e-03 9.506148e-01
      1436   372_2407691 2012    Simpson 8.813223e-01  5.370264e-03 4.791533e-01
      1437   372_2407691 2012 invSimpson 8.426184e+00  2.343960e-01 6.382251e-01
      1438   372_2407691 2012        PIE 8.976431e-01  7.236035e-03 3.608893e-01
      1439   372_2407691 2012      DomMc 4.000000e-01 -1.645969e-02 3.850684e-01
      1440   372_2407691 2012 expShannon 1.101153e+01 -7.168752e-02 9.029236e-01
      1441   372_2397485 2008          S 2.200000e+01 -3.000000e-01 7.608204e-01
      1442   372_2397485 2008          N 6.640000e+02 -1.632000e+02 1.384893e-01
      1443   372_2397485 2008       maxN 1.960000e+02 -3.760000e+01 1.214798e-01
      1444   372_2397485 2008    Shannon 2.346432e+00 -1.004912e-02 7.875744e-01
      1445   372_2397485 2008    Simpson 8.547503e-01 -1.075411e-02 1.990300e-01
      1446   372_2397485 2008 invSimpson 6.884697e+00 -5.095420e-01 2.639999e-01
      1447   372_2397485 2008        PIE 8.560395e-01 -9.738526e-03 2.192002e-01
      1448   372_2397485 2008      DomMc 4.759036e-01  9.343835e-03 5.811008e-01
      1449   372_2397485 2008 expShannon 1.044823e+01 -1.247464e-01 7.739099e-01
      1450   372_2397485 2009          S 2.800000e+01 -3.000000e-01 7.608204e-01
      1451   372_2397485 2009          N 8.930000e+02 -1.632000e+02 1.384893e-01
      1452   372_2397485 2009       maxN 1.990000e+02 -3.760000e+01 1.214798e-01
      1453   372_2397485 2009    Shannon 2.567849e+00 -1.004912e-02 7.875744e-01
      1454   372_2397485 2009    Simpson 8.907454e-01 -1.075411e-02 1.990300e-01
      1455   372_2397485 2009 invSimpson 9.152930e+00 -5.095420e-01 2.639999e-01
      1456   372_2397485 2009        PIE 8.917440e-01 -9.738526e-03 2.192002e-01
      1457   372_2397485 2009      DomMc 3.762598e-01  9.343835e-03 5.811008e-01
      1458   372_2397485 2009 expShannon 1.303775e+01 -1.247464e-01 7.739099e-01
      1459   372_2397485 2010          S 2.500000e+01 -3.000000e-01 7.608204e-01
      1460   372_2397485 2010          N 8.780000e+02 -1.632000e+02 1.384893e-01
      1461   372_2397485 2010       maxN 2.400000e+02 -3.760000e+01 1.214798e-01
      1462   372_2397485 2010    Shannon 2.385793e+00 -1.004912e-02 7.875744e-01
      1463   372_2397485 2010    Simpson 8.632842e-01 -1.075411e-02 1.990300e-01
      1464   372_2397485 2010 invSimpson 7.314445e+00 -5.095420e-01 2.639999e-01
      1465   372_2397485 2010        PIE 8.642686e-01 -9.738526e-03 2.192002e-01
      1466   372_2397485 2010      DomMc 4.419134e-01  9.343835e-03 5.811008e-01
      1467   372_2397485 2010 expShannon 1.086767e+01 -1.247464e-01 7.739099e-01
      1468   372_2397485 2011          S 2.500000e+01 -3.000000e-01 7.608204e-01
      1469   372_2397485 2011          N 2.790000e+02 -1.632000e+02 1.384893e-01
      1470   372_2397485 2011       maxN 9.700000e+01 -3.760000e+01 1.214798e-01
      1471   372_2397485 2011    Shannon 2.466635e+00 -1.004912e-02 7.875744e-01
      1472   372_2397485 2011    Simpson 8.470857e-01 -1.075411e-02 1.990300e-01
      1473   372_2397485 2011 invSimpson 6.539612e+00 -5.095420e-01 2.639999e-01
      1474   372_2397485 2011        PIE 8.501328e-01 -9.738526e-03 2.192002e-01
      1475   372_2397485 2011      DomMc 4.408602e-01  9.343835e-03 5.811008e-01
      1476   372_2397485 2011 expShannon 1.178274e+01 -1.247464e-01 7.739099e-01
      1477   372_2397485 2012          S 2.200000e+01 -3.000000e-01 7.608204e-01
      1478   372_2397485 2012          N 1.550000e+02 -1.632000e+02 1.384893e-01
      1479   372_2397485 2012       maxN 5.900000e+01 -3.760000e+01 1.214798e-01
      1480   372_2397485 2012    Shannon 2.346794e+00 -1.004912e-02 7.875744e-01
      1481   372_2397485 2012    Simpson 8.228096e-01 -1.075411e-02 1.990300e-01
      1482   372_2397485 2012 invSimpson 5.643646e+00 -5.095420e-01 2.639999e-01
      1483   372_2397485 2012        PIE 8.281525e-01 -9.738526e-03 2.192002e-01
      1484   372_2397485 2012      DomMc 4.903226e-01  9.343835e-03 5.811008e-01
      1485   372_2397485 2012 expShannon 1.045200e+01 -1.247464e-01 7.739099e-01
      1486   372_2400408 2005          S 3.200000e+01  1.171429e+00 2.703983e-01
      1487   372_2400408 2005          N 1.430000e+02  4.080000e+01 6.576289e-02
      1488   372_2400408 2005       maxN 2.700000e+01  4.771429e+00 1.949242e-01
      1489   372_2400408 2005    Shannon 2.940565e+00  2.849322e-02 2.429081e-01
      1490   372_2400408 2005    Simpson 9.196538e-01  2.756143e-03 3.991605e-01
      1491   372_2400408 2005 invSimpson 1.244614e+01  5.736287e-01 3.372659e-01
      1492   372_2400408 2005        PIE 9.261302e-01  1.729210e-03 5.938870e-01
      1493   372_2400408 2005      DomMc 3.286713e-01 -1.569644e-02 2.467160e-01
      1494   372_2400408 2005 expShannon 1.892653e+01  5.463865e-01 2.414862e-01
      1495   372_2400408 2006          S 2.400000e+01  1.171429e+00 2.703983e-01
      1496   372_2400408 2006          N 1.030000e+02  4.080000e+01 6.576289e-02
      1497   372_2400408 2006       maxN 1.600000e+01  4.771429e+00 1.949242e-01
      1498   372_2400408 2006    Shannon 2.816638e+00  2.849322e-02 2.429081e-01
      1499   372_2400408 2006    Simpson 9.224244e-01  2.756143e-03 3.991605e-01
      1500   372_2400408 2006 invSimpson 1.289064e+01  5.736287e-01 3.372659e-01
      1501   372_2400408 2006        PIE 9.314677e-01  1.729210e-03 5.938870e-01
      1502   372_2400408 2006      DomMc 2.912621e-01 -1.569644e-02 2.467160e-01
      1503   372_2400408 2006 expShannon 1.672054e+01  5.463865e-01 2.414862e-01
      1504   372_2400408 2007          S 2.600000e+01  1.171429e+00 2.703983e-01
      1505   372_2400408 2007          N 9.600000e+01  4.080000e+01 6.576289e-02
      1506   372_2400408 2007       maxN 2.100000e+01  4.771429e+00 1.949242e-01
      1507   372_2400408 2007    Shannon 2.877410e+00  2.849322e-02 2.429081e-01
      1508   372_2400408 2007    Simpson 9.162326e-01  2.756143e-03 3.991605e-01
      1509   372_2400408 2007 invSimpson 1.193782e+01  5.736287e-01 3.372659e-01
      1510   372_2400408 2007        PIE 9.258772e-01  1.729210e-03 5.938870e-01
      1511   372_2400408 2007      DomMc 3.020833e-01 -1.569644e-02 2.467160e-01
      1512   372_2400408 2007 expShannon 1.776820e+01  5.463865e-01 2.414862e-01
      1513   372_2400408 2008          S 3.100000e+01  1.171429e+00 2.703983e-01
      1514   372_2400408 2008          N 1.890000e+02  4.080000e+01 6.576289e-02
      1515   372_2400408 2008       maxN 4.500000e+01  4.771429e+00 1.949242e-01
      1516   372_2400408 2008    Shannon 2.865937e+00  2.849322e-02 2.429081e-01
      1517   372_2400408 2008    Simpson 9.060777e-01  2.756143e-03 3.991605e-01
      1518   372_2400408 2008 invSimpson 1.064709e+01  5.736287e-01 3.372659e-01
      1519   372_2400408 2008        PIE 9.108972e-01  1.729210e-03 5.938870e-01
      1520   372_2400408 2008      DomMc 3.597884e-01 -1.569644e-02 2.467160e-01
      1521   372_2400408 2008 expShannon 1.756550e+01  5.463865e-01 2.414862e-01
      1522   372_2400408 2009          S 3.100000e+01  1.171429e+00 2.703983e-01
      1523   372_2400408 2009          N 1.830000e+02  4.080000e+01 6.576289e-02
      1524   372_2400408 2009       maxN 2.200000e+01  4.771429e+00 1.949242e-01
      1525   372_2400408 2009    Shannon 3.076992e+00  2.849322e-02 2.429081e-01
      1526   372_2400408 2009    Simpson 9.416226e-01  2.756143e-03 3.991605e-01
      1527   372_2400408 2009 invSimpson 1.712992e+01  5.736287e-01 3.372659e-01
      1528   372_2400408 2009        PIE 9.467964e-01  1.729210e-03 5.938870e-01
      1529   372_2400408 2009      DomMc 2.131148e-01 -1.569644e-02 2.467160e-01
      1530   372_2400408 2009 expShannon 2.169306e+01  5.463865e-01 2.414862e-01
      1531   372_2400408 2010          S 3.500000e+01  1.171429e+00 2.703983e-01
      1532   372_2400408 2010          N 3.620000e+02  4.080000e+01 6.576289e-02
      1533   372_2400408 2010       maxN 5.200000e+01  4.771429e+00 1.949242e-01
      1534   372_2400408 2010    Shannon 2.986099e+00  2.849322e-02 2.429081e-01
      1535   372_2400408 2010    Simpson 9.294588e-01  2.756143e-03 3.991605e-01
      1536   372_2400408 2010 invSimpson 1.417611e+01  5.736287e-01 3.372659e-01
      1537   372_2400408 2010        PIE 9.320335e-01  1.729210e-03 5.938870e-01
      1538   372_2400408 2010      DomMc 2.541436e-01 -1.569644e-02 2.467160e-01
      1539   372_2400408 2010 expShannon 1.980827e+01  5.463865e-01 2.414862e-01
      1540   372_2436844 2010          S 1.800000e+01  1.900000e+00 5.962926e-01
      1541   372_2436844 2010          N 2.220000e+02  4.520000e+01 3.271693e-01
      1542   372_2436844 2010       maxN 6.700000e+01  9.300000e+00 5.225115e-01
      1543   372_2436844 2010    Shannon 2.358586e+00  5.186165e-02 7.096978e-01
      1544   372_2436844 2010    Simpson 8.575197e-01  3.768135e-03 8.313193e-01
      1545   372_2436844 2010 invSimpson 7.018513e+00  4.369605e-01 7.131305e-01
      1546   372_2436844 2010        PIE 8.613999e-01  3.356120e-03 8.501587e-01
      1547   372_2436844 2010      DomMc 4.459459e-01 -5.510694e-03 8.784627e-01
      1548   372_2436844 2010 expShannon 1.057598e+01  8.021874e-01 6.515458e-01
      1549   372_2436844 2011          S 2.800000e+01  1.900000e+00 5.962926e-01
      1550   372_2436844 2011          N 4.160000e+02  4.520000e+01 3.271693e-01
      1551   372_2436844 2011       maxN 1.120000e+02  9.300000e+00 5.225115e-01
      1552   372_2436844 2011    Shannon 2.299339e+00  5.186165e-02 7.096978e-01
      1553   372_2436844 2011    Simpson 8.435420e-01  3.768135e-03 8.313193e-01
      1554   372_2436844 2011 invSimpson 6.391491e+00  4.369605e-01 7.131305e-01
      1555   372_2436844 2011        PIE 8.455746e-01  3.356120e-03 8.501587e-01
      1556   372_2436844 2011      DomMc 4.639423e-01 -5.510694e-03 8.784627e-01
      1557   372_2436844 2011 expShannon 9.967596e+00  8.021874e-01 6.515458e-01
      1558   372_2436844 2009          S 2.900000e+01  1.900000e+00 5.962926e-01
      1559   372_2436844 2009          N 2.690000e+02  4.520000e+01 3.271693e-01
      1560   372_2436844 2009       maxN 5.400000e+01  9.300000e+00 5.225115e-01
      1561   372_2436844 2009    Shannon 2.605838e+00  5.186165e-02 7.096978e-01
      1562   372_2436844 2009    Simpson 8.893465e-01  3.768135e-03 8.313193e-01
      1563   372_2436844 2009 invSimpson 9.037217e+00  4.369605e-01 7.131305e-01
      1564   372_2436844 2009        PIE 8.926649e-01  3.356120e-03 8.501587e-01
      1565   372_2436844 2009      DomMc 3.680297e-01 -5.510694e-03 8.784627e-01
      1566   372_2436844 2009 expShannon 1.354257e+01  8.021874e-01 6.515458e-01
      1567   372_2436844 2012          S 3.200000e+01  1.900000e+00 5.962926e-01
      1568   372_2436844 2012          N 3.550000e+02  4.520000e+01 3.271693e-01
      1569   372_2436844 2012       maxN 7.000000e+01  9.300000e+00 5.225115e-01
      1570   372_2436844 2012    Shannon 2.798459e+00  5.186165e-02 7.096978e-01
      1571   372_2436844 2012    Simpson 9.065662e-01  3.768135e-03 8.313193e-01
      1572   372_2436844 2012 invSimpson 1.070276e+01  4.369605e-01 7.131305e-01
      1573   372_2436844 2012        PIE 9.091271e-01  3.356120e-03 8.501587e-01
      1574   372_2436844 2012      DomMc 3.436620e-01 -5.510694e-03 8.784627e-01
      1575   372_2436844 2012 expShannon 1.641932e+01  8.021874e-01 6.515458e-01
      1576   372_2424448 2009          S 1.400000e+01  9.000000e-01 7.374430e-01
      1577   372_2424448 2009          N 5.500000e+01  2.680000e+01 1.963214e-01
      1578   372_2424448 2009       maxN 1.500000e+01  8.700000e+00 1.182382e-01
      1579   372_2424448 2009    Shannon 2.202545e+00 -3.681503e-02 8.545688e-01
      1580   372_2424448 2009    Simpson 8.528926e-01 -9.573230e-03 7.089018e-01
      1581   372_2424448 2009 invSimpson 6.797753e+00 -4.389256e-01 7.078355e-01
      1582   372_2424448 2009        PIE 8.686869e-01 -1.255010e-02 6.176074e-01
      1583   372_2424448 2009      DomMc 4.545455e-01  1.598531e-02 7.484926e-01
      1584   372_2424448 2009 expShannon 9.048014e+00 -4.030095e-01 8.474010e-01
      1585   372_2424448 2010          S 2.200000e+01  9.000000e-01 7.374430e-01
      1586   372_2424448 2010          N 6.900000e+01  2.680000e+01 1.963214e-01
      1587   372_2424448 2010       maxN 1.800000e+01  8.700000e+00 1.182382e-01
      1588   372_2424448 2010    Shannon 2.698805e+00 -3.681503e-02 8.545688e-01
      1589   372_2424448 2010    Simpson 8.951901e-01 -9.573230e-03 7.089018e-01
      1590   372_2424448 2010 invSimpson 9.541082e+00 -4.389256e-01 7.078355e-01
      1591   372_2424448 2010        PIE 9.083546e-01 -1.255010e-02 6.176074e-01
      1592   372_2424448 2010      DomMc 3.768116e-01  1.598531e-02 7.484926e-01
      1593   372_2424448 2010 expShannon 1.486196e+01 -4.030095e-01 8.474010e-01
      1594   372_2424448 2011          S 1.300000e+01  9.000000e-01 7.374430e-01
      1595   372_2424448 2011          N 6.100000e+01  2.680000e+01 1.963214e-01
      1596   372_2424448 2011       maxN 2.100000e+01  8.700000e+00 1.182382e-01
      1597   372_2424448 2011    Shannon 1.911941e+00 -3.681503e-02 8.545688e-01
      1598   372_2424448 2011    Simpson 7.922601e-01 -9.573230e-03 7.089018e-01
      1599   372_2424448 2011 invSimpson 4.813713e+00 -4.389256e-01 7.078355e-01
      1600   372_2424448 2011        PIE 8.054645e-01 -1.255010e-02 6.176074e-01
      1601   372_2424448 2011      DomMc 5.737705e-01  1.598531e-02 7.484926e-01
      1602   372_2424448 2011 expShannon 6.766206e+00 -4.030095e-01 8.474010e-01
      1603   372_2424448 2012          S 2.000000e+01  9.000000e-01 7.374430e-01
      1604   372_2424448 2012          N 1.470000e+02  2.680000e+01 1.963214e-01
      1605   372_2424448 2012       maxN 4.300000e+01  8.700000e+00 1.182382e-01
      1606   372_2424448 2012    Shannon 2.342117e+00 -3.681503e-02 8.545688e-01
      1607   372_2424448 2012    Simpson 8.552918e-01 -9.573230e-03 7.089018e-01
      1608   372_2424448 2012 invSimpson 6.910457e+00 -4.389256e-01 7.078355e-01
      1609   372_2424448 2012        PIE 8.611499e-01 -1.255010e-02 6.176074e-01
      1610   372_2424448 2012      DomMc 4.421769e-01  1.598531e-02 7.484926e-01
      1611   372_2424448 2012 expShannon 1.040323e+01 -4.030095e-01 8.474010e-01
      1612   372_2410600 2010          S 1.100000e+01  7.000000e-01 3.965526e-01
      1613   372_2410600 2010          N 4.700000e+01  6.000000e-01 9.260500e-01
      1614   372_2410600 2010       maxN 1.300000e+01  1.200000e+00 3.890790e-01
      1615   372_2410600 2010    Shannon 1.900318e+00  3.834116e-02 6.070164e-01
      1616   372_2410600 2010    Simpson 8.048891e-01  2.076776e-03 8.629284e-01
      1617   372_2410600 2010 invSimpson 5.125290e+00  1.550558e-01 7.660759e-01
      1618   372_2410600 2010        PIE 8.223867e-01  2.026681e-03 8.526240e-01
      1619   372_2410600 2010      DomMc 5.531915e-01 -8.034704e-03 7.788065e-01
      1620   372_2410600 2010 expShannon 6.688022e+00  3.995053e-01 5.358768e-01
      1621   372_2410600 2008          S 1.300000e+01  7.000000e-01 3.965526e-01
      1622   372_2410600 2008          N 7.900000e+01  6.000000e-01 9.260500e-01
      1623   372_2410600 2008       maxN 1.600000e+01  1.200000e+00 3.890790e-01
      1624   372_2410600 2008    Shannon 2.247099e+00  3.834116e-02 6.070164e-01
      1625   372_2410600 2008    Simpson 8.710143e-01  2.076776e-03 8.629284e-01
      1626   372_2410600 2008 invSimpson 7.752795e+00  1.550558e-01 7.660759e-01
      1627   372_2410600 2008        PIE 8.821811e-01  2.026681e-03 8.526240e-01
      1628   372_2410600 2008      DomMc 4.050633e-01 -8.034704e-03 7.788065e-01
      1629   372_2410600 2008 expShannon 9.460248e+00  3.995053e-01 5.358768e-01
      1630   372_2410600 2009          S 1.500000e+01  7.000000e-01 3.965526e-01
      1631   372_2410600 2009          N 8.600000e+01  6.000000e-01 9.260500e-01
      1632   372_2410600 2009       maxN 2.000000e+01  1.200000e+00 3.890790e-01
      1633   372_2410600 2009    Shannon 2.215903e+00  3.834116e-02 6.070164e-01
      1634   372_2410600 2009    Simpson 8.593835e-01  2.076776e-03 8.629284e-01
      1635   372_2410600 2009 invSimpson 7.111538e+00  1.550558e-01 7.660759e-01
      1636   372_2410600 2009        PIE 8.694938e-01  2.026681e-03 8.526240e-01
      1637   372_2410600 2009      DomMc 4.302326e-01 -8.034704e-03 7.788065e-01
      1638   372_2410600 2009 expShannon 9.169683e+00  3.995053e-01 5.358768e-01
      1639   372_2410600 2012          S 1.700000e+01  7.000000e-01 3.965526e-01
      1640   372_2410600 2012          N 8.700000e+01  6.000000e-01 9.260500e-01
      1641   372_2410600 2012       maxN 2.100000e+01  1.200000e+00 3.890790e-01
      1642   372_2410600 2012    Shannon 2.438121e+00  3.834116e-02 6.070164e-01
      1643   372_2410600 2012    Simpson 8.851896e-01  2.076776e-03 8.629284e-01
      1644   372_2410600 2012 invSimpson 8.710012e+00  1.550558e-01 7.660759e-01
      1645   372_2410600 2012        PIE 8.954825e-01  2.026681e-03 8.526240e-01
      1646   372_2410600 2012      DomMc 3.563218e-01 -8.034704e-03 7.788065e-01
      1647   372_2410600 2012 expShannon 1.145151e+01  3.995053e-01 5.358768e-01
      1648   372_2410600 2011          S 1.400000e+01  7.000000e-01 3.965526e-01
      1649   372_2410600 2011          N 7.600000e+01  6.000000e-01 9.260500e-01
      1650   372_2410600 2011       maxN 2.200000e+01  1.200000e+00 3.890790e-01
      1651   372_2410600 2011    Shannon 2.217269e+00  3.834116e-02 6.070164e-01
      1652   372_2410600 2011    Simpson 8.518006e-01  2.076776e-03 8.629284e-01
      1653   372_2410600 2011 invSimpson 6.747664e+00  1.550558e-01 7.660759e-01
      1654   372_2410600 2011        PIE 8.631579e-01  2.026681e-03 8.526240e-01
      1655   372_2410600 2011      DomMc 4.473684e-01 -8.034704e-03 7.788065e-01
      1656   372_2410600 2011 expShannon 9.182222e+00  3.995053e-01 5.358768e-01
      1657   372_2374899 2009          S 2.900000e+01 -2.200000e+00 4.281372e-01
      1658   372_2374899 2009          N 1.620000e+02 -4.800000e+00 9.074214e-01
      1659   372_2374899 2009       maxN 2.600000e+01 -2.300000e+00 5.783187e-01
      1660   372_2374899 2009    Shannon 2.983702e+00 -5.981957e-02 5.323295e-01
      1661   372_2374899 2009    Simpson 9.336991e-01 -2.202732e-03 7.579640e-01
      1662   372_2374899 2009 invSimpson 1.508276e+01 -5.075620e-01 7.582037e-01
      1663   372_2374899 2009        PIE 9.394985e-01 -2.124235e-03 7.292085e-01
      1664   372_2374899 2009      DomMc 2.407407e-01 -1.895896e-03 9.351732e-01
      1665   372_2374899 2009 expShannon 1.976083e+01 -1.174663e+00 5.425847e-01
      1666   372_2374899 2010          S 3.600000e+01 -2.200000e+00 4.281372e-01
      1667   372_2374899 2010          N 2.830000e+02 -4.800000e+00 9.074214e-01
      1668   372_2374899 2010       maxN 3.500000e+01 -2.300000e+00 5.783187e-01
      1669   372_2374899 2010    Shannon 3.182439e+00 -5.981957e-02 5.323295e-01
      1670   372_2374899 2010    Simpson 9.470214e-01 -2.202732e-03 7.579640e-01
      1671   372_2374899 2010 invSimpson 1.887556e+01 -5.075620e-01 7.582037e-01
      1672   372_2374899 2010        PIE 9.503797e-01 -2.124235e-03 7.292085e-01
      1673   372_2374899 2010      DomMc 2.014134e-01 -1.895896e-03 9.351732e-01
      1674   372_2374899 2010 expShannon 2.410549e+01 -1.174663e+00 5.425847e-01
      1675   372_2374899 2011          S 2.600000e+01 -2.200000e+00 4.281372e-01
      1676   372_2374899 2011          N 1.270000e+02 -4.800000e+00 9.074214e-01
      1677   372_2374899 2011       maxN 1.800000e+01 -2.300000e+00 5.783187e-01
      1678   372_2374899 2011    Shannon 2.786625e+00 -5.981957e-02 5.323295e-01
      1679   372_2374899 2011    Simpson 9.184698e-01 -2.202732e-03 7.579640e-01
      1680   372_2374899 2011 invSimpson 1.226540e+01 -5.075620e-01 7.582037e-01
      1681   372_2374899 2011        PIE 9.257593e-01 -2.124235e-03 7.292085e-01
      1682   372_2374899 2011      DomMc 2.834646e-01 -1.895896e-03 9.351732e-01
      1683   372_2374899 2011 expShannon 1.622617e+01 -1.174663e+00 5.425847e-01
      1684   372_2374899 2012          S 2.500000e+01 -2.200000e+00 4.281372e-01
      1685   372_2374899 2012          N 1.980000e+02 -4.800000e+00 9.074214e-01
      1686   372_2374899 2012       maxN 2.400000e+01 -2.300000e+00 5.783187e-01
      1687   372_2374899 2012    Shannon 2.916241e+00 -5.981957e-02 5.323295e-01
      1688   372_2374899 2012    Simpson 9.358739e-01 -2.202732e-03 7.579640e-01
      1689   372_2374899 2012 invSimpson 1.559427e+01 -5.075620e-01 7.582037e-01
      1690   372_2374899 2012        PIE 9.406245e-01 -2.124235e-03 7.292085e-01
      1691   372_2374899 2012      DomMc 2.070707e-01 -1.895896e-03 9.351732e-01
      1692   372_2374899 2012 expShannon 1.847173e+01 -1.174663e+00 5.425847e-01
      1693   372_2406225 2010          S 2.500000e+01 -3.300000e+00 2.162150e-01
      1694   372_2406225 2010          N 5.830000e+02  2.640000e+01 6.961700e-01
      1695   372_2406225 2010       maxN 1.650000e+02  1.300000e+01 3.717426e-01
      1696   372_2406225 2010    Shannon 2.426218e+00 -2.036256e-01 2.530609e-01
      1697   372_2406225 2010    Simpson 8.531432e-01 -2.655277e-02 4.719761e-01
      1698   372_2406225 2010 invSimpson 6.809356e+00 -5.245965e-01 5.424651e-01
      1699   372_2406225 2010        PIE 8.546091e-01 -2.708787e-02 4.587300e-01
      1700   372_2406225 2010      DomMc 5.025729e-01  5.631347e-02 3.153562e-01
      1701   372_2406225 2010 expShannon 1.131601e+01 -1.251222e+00 3.373707e-01
      1702   372_2406225 2009          S 2.100000e+01 -3.300000e+00 2.162150e-01
      1703   372_2406225 2009          N 3.420000e+02  2.640000e+01 6.961700e-01
      1704   372_2406225 2009       maxN 8.000000e+01  1.300000e+01 3.717426e-01
      1705   372_2406225 2009    Shannon 2.476552e+00 -2.036256e-01 2.530609e-01
      1706   372_2406225 2009    Simpson 8.784925e-01 -2.655277e-02 4.719761e-01
      1707   372_2406225 2009 invSimpson 8.229947e+00 -5.245965e-01 5.424651e-01
      1708   372_2406225 2009        PIE 8.810688e-01 -2.708787e-02 4.587300e-01
      1709   372_2406225 2009      DomMc 4.269006e-01  5.631347e-02 3.153562e-01
      1710   372_2406225 2009 expShannon 1.190016e+01 -1.251222e+00 3.373707e-01
      1711   372_2406225 2011          S 1.000000e+01 -3.300000e+00 2.162150e-01
      1712   372_2406225 2011          N 4.380000e+02  2.640000e+01 6.961700e-01
      1713   372_2406225 2011       maxN 1.380000e+02  1.300000e+01 3.717426e-01
      1714   372_2406225 2011    Shannon 1.824873e+00 -2.036256e-01 2.530609e-01
      1715   372_2406225 2011    Simpson 7.900690e-01 -2.655277e-02 4.719761e-01
      1716   372_2406225 2011 invSimpson 4.763470e+00 -5.245965e-01 5.424651e-01
      1717   372_2406225 2011        PIE 7.918770e-01 -2.708787e-02 4.587300e-01
      1718   372_2406225 2011      DomMc 6.027397e-01  5.631347e-02 3.153562e-01
      1719   372_2406225 2011 expShannon 6.202009e+00 -1.251222e+00 3.373707e-01
      1720   372_2406225 2008          S 1.700000e+01 -3.300000e+00 2.162150e-01
      1721   372_2406225 2008          N 1.430000e+02  2.640000e+01 6.961700e-01
      1722   372_2406225 2008       maxN 7.000000e+01  1.300000e+01 3.717426e-01
      1723   372_2406225 2008    Shannon 1.919849e+00 -2.036256e-01 2.530609e-01
      1724   372_2406225 2008    Simpson 7.257079e-01 -2.655277e-02 4.719761e-01
      1725   372_2406225 2008 invSimpson 3.645748e+00 -5.245965e-01 5.424651e-01
      1726   372_2406225 2008        PIE 7.308185e-01 -2.708787e-02 4.587300e-01
      1727   372_2406225 2008      DomMc 6.433566e-01  5.631347e-02 3.153562e-01
      1728   372_2406225 2008 expShannon 6.819925e+00 -1.251222e+00 3.373707e-01
      1729   372_2406225 2012          S 6.000000e+00 -3.300000e+00 2.162150e-01
      1730   372_2406225 2012          N 2.270000e+02  2.640000e+01 6.961700e-01
      1731   372_2406225 2012       maxN 1.060000e+02  1.300000e+01 3.717426e-01
      1732   372_2406225 2012    Shannon 1.227560e+00 -2.036256e-01 2.530609e-01
      1733   372_2406225 2012    Simpson 6.371558e-01 -2.655277e-02 4.719761e-01
      1734   372_2406225 2012 invSimpson 2.756004e+00 -5.245965e-01 5.424651e-01
      1735   372_2406225 2012        PIE 6.399750e-01 -2.708787e-02 4.587300e-01
      1736   372_2406225 2012      DomMc 8.370044e-01  5.631347e-02 3.153562e-01
      1737   372_2406225 2012 expShannon 3.412892e+00 -1.251222e+00 3.373707e-01
      1738   372_2459505 2010          S 1.700000e+01  2.200000e+00 2.019761e-01
      1739   372_2459505 2010          N 9.200000e+01 -6.900000e+00 5.170809e-01
      1740   372_2459505 2010       maxN 2.900000e+01 -4.300000e+00 3.247369e-01
      1741   372_2459505 2010    Shannon 2.257848e+00  2.377565e-01 2.100758e-02
      1742   372_2459505 2010    Simpson 8.423913e-01  3.953470e-02 3.214479e-03
      1743   372_2459505 2010 invSimpson 6.344828e+00  1.269909e+00 6.511697e-03
      1744   372_2459505 2010        PIE 8.516484e-01  4.159607e-02 4.076911e-04
      1745   372_2459505 2010      DomMc 4.673913e-01 -7.873581e-02 3.399094e-02
      1746   372_2459505 2010 expShannon 9.562488e+00  1.950058e+00 2.329984e-02
      1747   372_2459505 2011          S 1.700000e+01  2.200000e+00 2.019761e-01
      1748   372_2459505 2011          N 5.300000e+01 -6.900000e+00 5.170809e-01
      1749   372_2459505 2011       maxN 1.400000e+01 -4.300000e+00 3.247369e-01
      1750   372_2459505 2011    Shannon 2.424484e+00  2.377565e-01 2.100758e-02
      1751   372_2459505 2011    Simpson 8.729085e-01  3.953470e-02 3.214479e-03
      1752   372_2459505 2011 invSimpson 7.868347e+00  1.269909e+00 6.511697e-03
      1753   372_2459505 2011        PIE 8.896952e-01  4.159607e-02 4.076911e-04
      1754   372_2459505 2011      DomMc 4.339623e-01 -7.873581e-02 3.399094e-02
      1755   372_2459505 2011 expShannon 1.129640e+01  1.950058e+00 2.329984e-02
      1756   372_2459505 2008          S 1.200000e+01  2.200000e+00 2.019761e-01
      1757   372_2459505 2008          N 7.600000e+01 -6.900000e+00 5.170809e-01
      1758   372_2459505 2008       maxN 2.700000e+01 -4.300000e+00 3.247369e-01
      1759   372_2459505 2008    Shannon 1.759423e+00  2.377565e-01 2.100758e-02
      1760   372_2459505 2008    Simpson 7.555402e-01  3.953470e-02 3.214479e-03
      1761   372_2459505 2008 invSimpson 4.090652e+00  1.269909e+00 6.511697e-03
      1762   372_2459505 2008        PIE 7.656140e-01  4.159607e-02 4.076911e-04
      1763   372_2459505 2008      DomMc 6.710526e-01 -7.873581e-02 3.399094e-02
      1764   372_2459505 2008 expShannon 5.809086e+00  1.950058e+00 2.329984e-02
      1765   372_2459505 2009          S 1.000000e+01  2.200000e+00 2.019761e-01
      1766   372_2459505 2009          N 9.200000e+01 -6.900000e+00 5.170809e-01
      1767   372_2459505 2009       maxN 3.300000e+01 -4.300000e+00 3.247369e-01
      1768   372_2459505 2009    Shannon 1.875466e+00  2.377565e-01 2.100758e-02
      1769   372_2459505 2009    Simpson 7.991493e-01  3.953470e-02 3.214479e-03
      1770   372_2459505 2009 invSimpson 4.978824e+00  1.269909e+00 6.511697e-03
      1771   372_2459505 2009        PIE 8.079312e-01  4.159607e-02 4.076911e-04
      1772   372_2459505 2009      DomMc 5.434783e-01 -7.873581e-02 3.399094e-02
      1773   372_2459505 2009 expShannon 6.523860e+00  1.950058e+00 2.329984e-02
      1774   372_2442010 2009          S 2.200000e+01 -1.000000e+01 2.754587e-01
      1775   372_2442010 2009          N 1.380000e+02 -6.750000e+01 1.367121e-01
      1776   372_2442010 2009       maxN 3.100000e+01 -1.450000e+01 1.847464e-01
      1777   372_2442010 2009    Shannon 2.566933e+00 -9.652094e-01 3.317561e-01
      1778   372_2442010 2009    Simpson 8.888889e-01 -2.222222e-01 3.325251e-01
      1779   372_2442010 2009 invSimpson 9.000000e+00 -3.600000e+00 3.293042e-01
      1780   372_2442010 2009        PIE 8.953771e-01 -1.143552e-01 3.386364e-01
      1781   372_2442010 2009      DomMc 3.840580e-01  3.079710e-01 3.321158e-01
      1782   372_2442010 2009 expShannon 1.302581e+01 -5.567966e+00 3.297755e-01
      1783   372_2442010 2010          S 2.000000e+01 -1.000000e+01 2.754587e-01
      1784   372_2442010 2010          N 9.600000e+01 -6.750000e+01 1.367121e-01
      1785   372_2442010 2010       maxN 2.400000e+01 -1.450000e+01 1.847464e-01
      1786   372_2442010 2010    Shannon 2.561419e+00 -9.652094e-01 3.317561e-01
      1787   372_2442010 2010    Simpson 8.882378e-01 -2.222222e-01 3.325251e-01
      1788   372_2442010 2010 invSimpson 8.947573e+00 -3.600000e+00 3.293042e-01
      1789   372_2442010 2010        PIE 8.975877e-01 -1.143552e-01 3.386364e-01
      1790   372_2442010 2010      DomMc 3.854167e-01  3.079710e-01 3.321158e-01
      1791   372_2442010 2010 expShannon 1.295418e+01 -5.567966e+00 3.297755e-01
      1792   372_2442010 2011          S 2.000000e+00 -1.000000e+01 2.754587e-01
      1793   372_2442010 2011          N 3.000000e+00 -6.750000e+01 1.367121e-01
      1794   372_2442010 2011       maxN 2.000000e+00 -1.450000e+01 1.847464e-01
      1795   372_2442010 2011    Shannon 6.365142e-01 -9.652094e-01 3.317561e-01
      1796   372_2442010 2011    Simpson 4.444444e-01 -2.222222e-01 3.325251e-01
      1797   372_2442010 2011 invSimpson 1.800000e+00 -3.600000e+00 3.293042e-01
      1798   372_2442010 2011        PIE 6.666667e-01 -1.143552e-01 3.386364e-01
      1799   372_2442010 2011      DomMc 1.000000e+00  3.079710e-01 3.321158e-01
      1800   372_2442010 2011 expShannon 1.889882e+00 -5.567966e+00 3.297755e-01
      1801   372_2433992 2009          S 3.700000e+01 -3.100000e+00 9.563705e-02
      1802   372_2433992 2009          N 2.200000e+02 -2.600000e+01 3.556535e-01
      1803   372_2433992 2009       maxN 4.800000e+01 -5.100000e+00 7.285352e-01
      1804   372_2433992 2009    Shannon 2.950209e+00 -4.342457e-02 7.952573e-01
      1805   372_2433992 2009    Simpson 9.109504e-01 -9.761303e-04 9.684375e-01
      1806   372_2433992 2009 invSimpson 1.122970e+01  3.971989e-01 8.832612e-01
      1807   372_2433992 2009        PIE 9.151100e-01  3.140483e-05 9.990165e-01
      1808   372_2433992 2009      DomMc 3.590909e-01 -8.211922e-03 9.151532e-01
      1809   372_2433992 2009 expShannon 1.910994e+01 -6.758212e-01 8.060514e-01
      1810   372_2433992 2012          S 2.900000e+01 -3.100000e+00 9.563705e-02
      1811   372_2433992 2012          N 1.190000e+02 -2.600000e+01 3.556535e-01
      1812   372_2433992 2012       maxN 1.600000e+01 -5.100000e+00 7.285352e-01
      1813   372_2433992 2012    Shannon 3.012156e+00 -4.342457e-02 7.952573e-01
      1814   372_2433992 2012    Simpson 9.362333e-01 -9.761303e-04 9.684375e-01
      1815   372_2433992 2012 invSimpson 1.568217e+01  3.971989e-01 8.832612e-01
      1816   372_2433992 2012        PIE 9.441675e-01  3.140483e-05 9.990165e-01
      1817   372_2433992 2012      DomMc 2.436975e-01 -8.211922e-03 9.151532e-01
      1818   372_2433992 2012 expShannon 2.033118e+01 -6.758212e-01 8.060514e-01
      1819   372_2433992 2010          S 3.500000e+01 -3.100000e+00 9.563705e-02
      1820   372_2433992 2010          N 1.940000e+02 -2.600000e+01 3.556535e-01
      1821   372_2433992 2010       maxN 2.500000e+01 -5.100000e+00 7.285352e-01
      1822   372_2433992 2010    Shannon 3.115881e+00 -4.342457e-02 7.952573e-01
      1823   372_2433992 2010    Simpson 9.381443e-01 -9.761303e-04 9.684375e-01
      1824   372_2433992 2010 invSimpson 1.616667e+01  3.971989e-01 8.832612e-01
      1825   372_2433992 2010        PIE 9.430052e-01  3.140483e-05 9.990165e-01
      1826   372_2433992 2010      DomMc 2.422680e-01 -8.211922e-03 9.151532e-01
      1827   372_2433992 2010 expShannon 2.255330e+01 -6.758212e-01 8.060514e-01
      1828   372_2433992 2011          S 2.800000e+01 -3.100000e+00 9.563705e-02
      1829   372_2433992 2011          N 2.370000e+02 -2.600000e+01 3.556535e-01
      1830   372_2433992 2011       maxN 7.000000e+01 -5.100000e+00 7.285352e-01
      1831   372_2433992 2011    Shannon 2.495795e+00 -4.342457e-02 7.952573e-01
      1832   372_2433992 2011    Simpson 8.525343e-01 -9.761303e-04 9.684375e-01
      1833   372_2433992 2011 invSimpson 6.781239e+00  3.971989e-01 8.832612e-01
      1834   372_2433992 2011        PIE 8.561467e-01  3.140483e-05 9.990165e-01
      1835   372_2433992 2011      DomMc 5.063291e-01 -8.211922e-03 9.151532e-01
      1836   372_2433992 2011 expShannon 1.213137e+01 -6.758212e-01 8.060514e-01
      1837   372_2366870 2006          S 1.900000e+01 -6.785714e-01 4.157762e-01
      1838   372_2366870 2006          N 4.300000e+01  6.142857e+00 3.975869e-01
      1839   372_2366870 2006       maxN 7.000000e+00  1.214286e+00 3.523110e-01
      1840   372_2366870 2006    Shannon 2.657316e+00 -5.770345e-02 8.314437e-02
      1841   372_2366870 2006    Simpson 9.118442e-01 -5.575943e-03 5.510474e-02
      1842   372_2366870 2006 invSimpson 1.134356e+01 -5.336487e-01 6.062796e-02
      1843   372_2366870 2006        PIE 9.335548e-01 -6.939649e-03 1.207044e-02
      1844   372_2366870 2006      DomMc 2.790698e-01  1.383858e-02 9.267930e-02
      1845   372_2366870 2006 expShannon 1.425797e+01 -7.326082e-01 8.188789e-02
      1846   372_2366870 2008          S 2.100000e+01 -6.785714e-01 4.157762e-01
      1847   372_2366870 2008          N 1.400000e+02  6.142857e+00 3.975869e-01
      1848   372_2366870 2008       maxN 1.900000e+01  1.214286e+00 3.523110e-01
      1849   372_2366870 2008    Shannon 2.744294e+00 -5.770345e-02 8.314437e-02
      1850   372_2366870 2008    Simpson 9.228571e-01 -5.575943e-03 5.510474e-02
      1851   372_2366870 2008 invSimpson 1.296296e+01 -5.336487e-01 6.062796e-02
      1852   372_2366870 2008        PIE 9.294964e-01 -6.939649e-03 1.207044e-02
      1853   372_2366870 2008      DomMc 2.500000e-01  1.383858e-02 9.267930e-02
      1854   372_2366870 2008 expShannon 1.555363e+01 -7.326082e-01 8.188789e-02
      1855   372_2366870 2009          S 1.800000e+01 -6.785714e-01 4.157762e-01
      1856   372_2366870 2009          N 1.350000e+02  6.142857e+00 3.975869e-01
      1857   372_2366870 2009       maxN 2.500000e+01  1.214286e+00 3.523110e-01
      1858   372_2366870 2009    Shannon 2.570331e+00 -5.770345e-02 8.314437e-02
      1859   372_2366870 2009    Simpson 9.033745e-01 -5.575943e-03 5.510474e-02
      1860   372_2366870 2009 invSimpson 1.034923e+01 -5.336487e-01 6.062796e-02
      1861   372_2366870 2009        PIE 9.101161e-01 -6.939649e-03 1.207044e-02
      1862   372_2366870 2009      DomMc 3.481481e-01  1.383858e-02 9.267930e-02
      1863   372_2366870 2009 expShannon 1.307016e+01 -7.326082e-01 8.188789e-02
      1864   372_2366870 2011          S 2.200000e+01 -6.785714e-01 4.157762e-01
      1865   372_2366870 2011          N 1.350000e+02  6.142857e+00 3.975869e-01
      1866   372_2366870 2011       maxN 2.500000e+01  1.214286e+00 3.523110e-01
      1867   372_2366870 2011    Shannon 2.650568e+00 -5.770345e-02 8.314437e-02
      1868   372_2366870 2011    Simpson 9.024966e-01 -5.575943e-03 5.510474e-02
      1869   372_2366870 2011 invSimpson 1.025605e+01 -5.336487e-01 6.062796e-02
      1870   372_2366870 2011        PIE 9.092316e-01 -6.939649e-03 1.207044e-02
      1871   372_2366870 2011      DomMc 3.629630e-01  1.383858e-02 9.267930e-02
      1872   372_2366870 2011 expShannon 1.416207e+01 -7.326082e-01 8.188789e-02
      1873   372_2366870 2012          S 1.500000e+01 -6.785714e-01 4.157762e-01
      1874   372_2366870 2012          N 8.800000e+01  6.142857e+00 3.975869e-01
      1875   372_2366870 2012       maxN 1.700000e+01  1.214286e+00 3.523110e-01
      1876   372_2366870 2012    Shannon 2.259000e+00 -5.770345e-02 8.314437e-02
      1877   372_2366870 2012    Simpson 8.706095e-01 -5.575943e-03 5.510474e-02
      1878   372_2366870 2012 invSimpson 7.728543e+00 -5.336487e-01 6.062796e-02
      1879   372_2366870 2012        PIE 8.806165e-01 -6.939649e-03 1.207044e-02
      1880   372_2366870 2012      DomMc 3.636364e-01  1.383858e-02 9.267930e-02
      1881   372_2366870 2012 expShannon 9.573509e+00 -7.326082e-01 8.188789e-02
      1882   372_2366870 2007          S 2.700000e+01 -6.785714e-01 4.157762e-01
      1883   372_2366870 2007          N 9.700000e+01  6.142857e+00 3.975869e-01
      1884   372_2366870 2007       maxN 2.100000e+01  1.214286e+00 3.523110e-01
      1885   372_2366870 2007    Shannon 2.821490e+00 -5.770345e-02 8.314437e-02
      1886   372_2366870 2007    Simpson 9.099798e-01 -5.575943e-03 5.510474e-02
      1887   372_2366870 2007 invSimpson 1.110862e+01 -5.336487e-01 6.062796e-02
      1888   372_2366870 2007        PIE 9.194588e-01 -6.939649e-03 1.207044e-02
      1889   372_2366870 2007      DomMc 3.195876e-01  1.383858e-02 9.267930e-02
      1890   372_2366870 2007 expShannon 1.680186e+01 -7.326082e-01 8.188789e-02
      1891   372_2366870 2010          S 2.400000e+01 -6.785714e-01 4.157762e-01
      1892   372_2366870 2010          N 1.010000e+02  6.142857e+00 3.975869e-01
      1893   372_2366870 2010       maxN 1.500000e+01  1.214286e+00 3.523110e-01
      1894   372_2366870 2010    Shannon 2.665391e+00 -5.770345e-02 8.314437e-02
      1895   372_2366870 2010    Simpson 9.054014e-01 -5.575943e-03 5.510474e-02
      1896   372_2366870 2010 invSimpson 1.057098e+01 -5.336487e-01 6.062796e-02
      1897   372_2366870 2010        PIE 9.144554e-01 -6.939649e-03 1.207044e-02
      1898   372_2366870 2010      DomMc 2.970297e-01  1.383858e-02 9.267930e-02
      1899   372_2366870 2010 expShannon 1.437357e+01 -7.326082e-01 8.188789e-02
      1900   372_2440508 2008          S 1.800000e+01 -1.700000e+00 2.586458e-02
      1901   372_2440508 2008          N 9.000000e+01  5.700000e+00 7.768724e-02
      1902   372_2440508 2008       maxN 2.200000e+01  5.500000e+00 1.543832e-01
      1903   372_2440508 2008    Shannon 2.517059e+00 -1.838334e-01 2.956960e-02
      1904   372_2440508 2008    Simpson 8.898765e-01 -3.101987e-02 9.305467e-02
      1905   372_2440508 2008 invSimpson 9.080717e+00 -1.142827e+00 6.864666e-02
      1906   372_2440508 2008        PIE 8.998752e-01 -3.183842e-02 9.187207e-02
      1907   372_2440508 2008      DomMc 3.666667e-01  5.905862e-02 1.159132e-01
      1908   372_2440508 2008 expShannon 1.239209e+01 -1.615887e+00 1.497377e-02
      1909   372_2440508 2009          S 1.900000e+01 -1.700000e+00 2.586458e-02
      1910   372_2440508 2009          N 8.500000e+01  5.700000e+00 7.768724e-02
      1911   372_2440508 2009       maxN 1.900000e+01  5.500000e+00 1.543832e-01
      1912   372_2440508 2009    Shannon 2.471818e+00 -1.838334e-01 2.956960e-02
      1913   372_2440508 2009    Simpson 8.805536e-01 -3.101987e-02 9.305467e-02
      1914   372_2440508 2009 invSimpson 8.371958e+00 -1.142827e+00 6.864666e-02
      1915   372_2440508 2009        PIE 8.910364e-01 -3.183842e-02 9.187207e-02
      1916   372_2440508 2009      DomMc 4.235294e-01  5.905862e-02 1.159132e-01
      1917   372_2440508 2009 expShannon 1.184396e+01 -1.615887e+00 1.497377e-02
      1918   372_2440508 2011          S 1.400000e+01 -1.700000e+00 2.586458e-02
      1919   372_2440508 2011          N 9.800000e+01  5.700000e+00 7.768724e-02
      1920   372_2440508 2011       maxN 2.600000e+01  5.500000e+00 1.543832e-01
      1921   372_2440508 2011    Shannon 2.233670e+00 -1.838334e-01 2.956960e-02
      1922   372_2440508 2011    Simpson 8.631820e-01 -3.101987e-02 9.305467e-02
      1923   372_2440508 2011 invSimpson 7.308980e+00 -1.142827e+00 6.864666e-02
      1924   372_2440508 2011        PIE 8.720808e-01 -3.183842e-02 9.187207e-02
      1925   372_2440508 2011      DomMc 4.081633e-01  5.905862e-02 1.159132e-01
      1926   372_2440508 2011 expShannon 9.334055e+00 -1.615887e+00 1.497377e-02
      1927   372_2440508 2012          S 1.200000e+01 -1.700000e+00 2.586458e-02
      1928   372_2440508 2012          N 1.120000e+02  5.700000e+00 7.768724e-02
      1929   372_2440508 2012       maxN 4.600000e+01  5.500000e+00 1.543832e-01
      1930   372_2440508 2012    Shannon 1.716966e+00 -1.838334e-01 2.956960e-02
      1931   372_2440508 2012    Simpson 7.434630e-01 -3.101987e-02 9.305467e-02
      1932   372_2440508 2012 invSimpson 3.898073e+00 -1.142827e+00 6.864666e-02
      1933   372_2440508 2012        PIE 7.501609e-01 -3.183842e-02 9.187207e-02
      1934   372_2440508 2012      DomMc 6.696429e-01  5.905862e-02 1.159132e-01
      1935   372_2440508 2012 expShannon 5.567611e+00 -1.615887e+00 1.497377e-02
      1936   372_2440508 2010          S 1.700000e+01 -1.700000e+00 2.586458e-02
      1937   372_2440508 2010          N 1.040000e+02  5.700000e+00 7.768724e-02
      1938   372_2440508 2010       maxN 4.000000e+01  5.500000e+00 1.543832e-01
      1939   372_2440508 2010    Shannon 2.234629e+00 -1.838334e-01 2.956960e-02
      1940   372_2440508 2010    Simpson 8.173077e-01 -3.101987e-02 9.305467e-02
      1941   372_2440508 2010 invSimpson 5.473684e+00 -1.142827e+00 6.864666e-02
      1942   372_2440508 2010        PIE 8.252427e-01 -3.183842e-02 9.187207e-02
      1943   372_2440508 2010      DomMc 4.807692e-01  5.905862e-02 1.159132e-01
      1944   372_2440508 2010 expShannon 9.343011e+00 -1.615887e+00 1.497377e-02
      1945   372_2442692 2012          S 2.600000e+01  6.571429e-01 5.250407e-01
      1946   372_2442692 2012          N 1.780000e+02 -3.848571e+01 7.718619e-02
      1947   372_2442692 2012       maxN 3.500000e+01 -1.465714e+01 1.899534e-01
      1948   372_2442692 2012    Shannon 2.664459e+00  1.147836e-01 3.528190e-01
      1949   372_2442692 2012    Simpson 8.979927e-01  1.596493e-02 3.719353e-01
      1950   372_2442692 2012 invSimpson 9.803218e+00  9.403699e-01 4.692187e-01
      1951   372_2442692 2012        PIE 9.030661e-01  1.660713e-02 3.604505e-01
      1952   372_2442692 2012      DomMc 3.595506e-01 -3.709485e-02 4.435513e-01
      1953   372_2442692 2012 expShannon 1.436018e+01  1.336405e+00 3.931425e-01
      1954   372_2442692 2008          S 2.400000e+01  6.571429e-01 5.250407e-01
      1955   372_2442692 2008          N 3.440000e+02 -3.848571e+01 7.718619e-02
      1956   372_2442692 2008       maxN 1.000000e+02 -1.465714e+01 1.899534e-01
      1957   372_2442692 2008    Shannon 2.153861e+00  1.147836e-01 3.528190e-01
      1958   372_2442692 2008    Simpson 8.225561e-01  1.596493e-02 3.719353e-01
      1959   372_2442692 2008 invSimpson 5.635584e+00  9.403699e-01 4.692187e-01
      1960   372_2442692 2008        PIE 8.249542e-01  1.660713e-02 3.604505e-01
      1961   372_2442692 2008      DomMc 5.406977e-01 -3.709485e-02 4.435513e-01
      1962   372_2442692 2008 expShannon 8.618069e+00  1.336405e+00 3.931425e-01
      1963   372_2442692 2009          S 2.400000e+01  6.571429e-01 5.250407e-01
      1964   372_2442692 2009          N 2.520000e+02 -3.848571e+01 7.718619e-02
      1965   372_2442692 2009       maxN 5.400000e+01 -1.465714e+01 1.899534e-01
      1966   372_2442692 2009    Shannon 2.586806e+00  1.147836e-01 3.528190e-01
      1967   372_2442692 2009    Simpson 8.961640e-01  1.596493e-02 3.719353e-01
      1968   372_2442692 2009 invSimpson 9.630573e+00  9.403699e-01 4.692187e-01
      1969   372_2442692 2009        PIE 8.997344e-01  1.660713e-02 3.604505e-01
      1970   372_2442692 2009      DomMc 3.412698e-01 -3.709485e-02 4.435513e-01
      1971   372_2442692 2009 expShannon 1.328726e+01  1.336405e+00 3.931425e-01
      1972   372_2442692 2010          S 2.900000e+01  6.571429e-01 5.250407e-01
      1973   372_2442692 2010          N 2.150000e+02 -3.848571e+01 7.718619e-02
      1974   372_2442692 2010       maxN 3.400000e+01 -1.465714e+01 1.899534e-01
      1975   372_2442692 2010    Shannon 2.874740e+00  1.147836e-01 3.528190e-01
      1976   372_2442692 2010    Simpson 9.232234e-01  1.596493e-02 3.719353e-01
      1977   372_2442692 2010 invSimpson 1.302480e+01  9.403699e-01 4.692187e-01
      1978   372_2442692 2010        PIE 9.275375e-01  1.660713e-02 3.604505e-01
      1979   372_2442692 2010      DomMc 2.744186e-01 -3.709485e-02 4.435513e-01
      1980   372_2442692 2010 expShannon 1.772082e+01  1.336405e+00 3.931425e-01
      1981   372_2432467 2009          S 2.600000e+01 -2.000000e+00 8.712907e-02
      1982   372_2432467 2009          N 1.880000e+02 -9.300000e+00 7.102438e-01
      1983   372_2432467 2009       maxN 3.600000e+01 -7.000000e+00 4.681072e-01
      1984   372_2432467 2009    Shannon 2.833988e+00 -5.845136e-02 5.443854e-01
      1985   372_2432467 2009    Simpson 9.189679e-01  2.188778e-03 8.839773e-01
      1986   372_2432467 2009 invSimpson 1.234078e+01  8.175358e-02 9.527884e-01
      1987   372_2432467 2009        PIE 9.238821e-01  2.646880e-03 8.631615e-01
      1988   372_2432467 2009      DomMc 2.978723e-01 -2.382874e-02 6.398876e-01
      1989   372_2432467 2009 expShannon 1.701318e+01 -8.045462e-01 5.604479e-01
      1990   372_2432467 2010          S 2.400000e+01 -2.000000e+00 8.712907e-02
      1991   372_2432467 2010          N 2.330000e+02 -9.300000e+00 7.102438e-01
      1992   372_2432467 2010       maxN 5.900000e+01 -7.000000e+00 4.681072e-01
      1993   372_2432467 2010    Shannon 2.444579e+00 -5.845136e-02 5.443854e-01
      1994   372_2432467 2010    Simpson 8.659213e-01  2.188778e-03 8.839773e-01
      1995   372_2432467 2010 invSimpson 7.458305e+00  8.175358e-02 9.527884e-01
      1996   372_2432467 2010        PIE 8.696537e-01  2.646880e-03 8.631615e-01
      1997   372_2432467 2010      DomMc 4.592275e-01 -2.382874e-02 6.398876e-01
      1998   372_2432467 2010 expShannon 1.152570e+01 -8.045462e-01 5.604479e-01
      1999   372_2432467 2011          S 2.000000e+01 -2.000000e+00 8.712907e-02
      2000   372_2432467 2011          N 1.320000e+02 -9.300000e+00 7.102438e-01
      2001   372_2432467 2011       maxN 2.100000e+01 -7.000000e+00 4.681072e-01
      2002   372_2432467 2011    Shannon 2.540745e+00 -5.845136e-02 5.443854e-01
      2003   372_2432467 2011    Simpson 8.971534e-01  2.188778e-03 8.839773e-01
      2004   372_2432467 2011 invSimpson 9.723214e+00  8.175358e-02 9.527884e-01
      2005   372_2432467 2011        PIE 9.040019e-01  2.646880e-03 8.631615e-01
      2006   372_2432467 2011      DomMc 3.106061e-01 -2.382874e-02 6.398876e-01
      2007   372_2432467 2011 expShannon 1.268912e+01 -8.045462e-01 5.604479e-01
      2008   372_2432467 2008          S 2.600000e+01 -2.000000e+00 8.712907e-02
      2009   372_2432467 2008          N 1.780000e+02 -9.300000e+00 7.102438e-01
      2010   372_2432467 2008       maxN 5.200000e+01 -7.000000e+00 4.681072e-01
      2011   372_2432467 2008    Shannon 2.605780e+00 -5.845136e-02 5.443854e-01
      2012   372_2432467 2008    Simpson 8.721752e-01  2.188778e-03 8.839773e-01
      2013   372_2432467 2008 invSimpson 7.823210e+00  8.175358e-02 9.527884e-01
      2014   372_2432467 2008        PIE 8.771028e-01  2.646880e-03 8.631615e-01
      2015   372_2432467 2008      DomMc 4.438202e-01 -2.382874e-02 6.398876e-01
      2016   372_2432467 2008 expShannon 1.354178e+01 -8.045462e-01 5.604479e-01
      2017   372_2428094 2009          S 2.100000e+01 -5.000000e-01 7.088887e-01
      2018   372_2428094 2009          N 2.130000e+02 -1.160000e+01 7.183935e-01
      2019   372_2428094 2009       maxN 5.200000e+01 -4.200000e+00 6.172316e-01
      2020   372_2428094 2009    Shannon 2.504899e+00  3.054443e-02 7.950691e-01
      2021   372_2428094 2009    Simpson 8.839516e-01  5.766840e-03 7.250673e-01
      2022   372_2428094 2009 invSimpson 8.617094e+00  3.585857e-01 6.946051e-01
      2023   372_2428094 2009        PIE 8.881212e-01  6.293404e-03 6.917445e-01
      2024   372_2428094 2009      DomMc 3.849765e-01 -1.142348e-02 7.681109e-01
      2025   372_2428094 2009 expShannon 1.224233e+01  3.485654e-01 7.826065e-01
      2026   372_2428094 2012          S 2.000000e+01 -5.000000e-01 7.088887e-01
      2027   372_2428094 2012          N 1.950000e+02 -1.160000e+01 7.183935e-01
      2028   372_2428094 2012       maxN 4.700000e+01 -4.200000e+00 6.172316e-01
      2029   372_2428094 2012    Shannon 2.570332e+00  3.054443e-02 7.950691e-01
      2030   372_2428094 2012    Simpson 8.936226e-01  5.766840e-03 7.250673e-01
      2031   372_2428094 2012 invSimpson 9.400494e+00  3.585857e-01 6.946051e-01
      2032   372_2428094 2012        PIE 8.982289e-01  6.293404e-03 6.917445e-01
      2033   372_2428094 2012      DomMc 3.641026e-01 -1.142348e-02 7.681109e-01
      2034   372_2428094 2012 expShannon 1.307016e+01  3.485654e-01 7.826065e-01
      2035   372_2428094 2011          S 1.600000e+01 -5.000000e-01 7.088887e-01
      2036   372_2428094 2011          N 9.300000e+01 -1.160000e+01 7.183935e-01
      2037   372_2428094 2011       maxN 2.100000e+01 -4.200000e+00 6.172316e-01
      2038   372_2428094 2011    Shannon 2.271286e+00  3.054443e-02 7.950691e-01
      2039   372_2428094 2011    Simpson 8.613713e-01  5.766840e-03 7.250673e-01
      2040   372_2428094 2011 invSimpson 7.213511e+00  3.585857e-01 6.946051e-01
      2041   372_2428094 2011        PIE 8.707340e-01  6.293404e-03 6.917445e-01
      2042   372_2428094 2011      DomMc 4.516129e-01 -1.142348e-02 7.681109e-01
      2043   372_2428094 2011 expShannon 9.691859e+00  3.485654e-01 7.826065e-01
      2044   372_2428094 2010          S 1.800000e+01 -5.000000e-01 7.088887e-01
      2045   372_2428094 2010          N 1.550000e+02 -1.160000e+01 7.183935e-01
      2046   372_2428094 2010       maxN 4.800000e+01 -4.200000e+00 6.172316e-01
      2047   372_2428094 2010    Shannon 2.162140e+00  3.054443e-02 7.950691e-01
      2048   372_2428094 2010    Simpson 8.327159e-01  5.766840e-03 7.250673e-01
      2049   372_2428094 2010 invSimpson 5.977855e+00  3.585857e-01 6.946051e-01
      2050   372_2428094 2010        PIE 8.381232e-01  6.293404e-03 6.917445e-01
      2051   372_2428094 2010      DomMc 5.032258e-01 -1.142348e-02 7.681109e-01
      2052   372_2428094 2010 expShannon 8.689709e+00  3.485654e-01 7.826065e-01
      2053   372_2421551 2009          S 2.100000e+01 -3.500000e+00 4.065197e-01
      2054   372_2421551 2009          N 1.140000e+02 -4.550000e+01 1.918830e-01
      2055   372_2421551 2009       maxN 2.500000e+01 -9.000000e+00 5.625889e-01
      2056   372_2421551 2009    Shannon 2.402491e+00 -2.002550e-02 5.867931e-01
      2057   372_2421551 2009    Simpson 8.714989e-01 -2.857212e-03 9.312632e-01
      2058   372_2421551 2009 invSimpson 7.782036e+00 -1.656659e-01 9.077874e-01
      2059   372_2421551 2009        PIE 8.792113e-01  1.296352e-02 7.728793e-01
      2060   372_2421551 2009      DomMc 3.947368e-01 -1.716247e-03 9.791772e-01
      2061   372_2421551 2009 expShannon 1.105067e+01 -2.169221e-01 5.811512e-01
      2062   372_2421551 2010          S 2.200000e+01 -3.500000e+00 4.065197e-01
      2063   372_2421551 2010          N 9.300000e+01 -4.550000e+01 1.918830e-01
      2064   372_2421551 2010       maxN 3.500000e+01 -9.000000e+00 5.625889e-01
      2065   372_2421551 2010    Shannon 2.336750e+00 -2.002550e-02 5.867931e-01
      2066   372_2421551 2010    Simpson 8.229853e-01 -2.857212e-03 9.312632e-01
      2067   372_2421551 2010 invSimpson 5.649249e+00 -1.656659e-01 9.077874e-01
      2068   372_2421551 2010        PIE 8.319308e-01  1.296352e-02 7.728793e-01
      2069   372_2421551 2010      DomMc 4.838710e-01 -1.716247e-03 9.791772e-01
      2070   372_2421551 2010 expShannon 1.034756e+01 -2.169221e-01 5.811512e-01
      2071   372_2421551 2011          S 1.400000e+01 -3.500000e+00 4.065197e-01
      2072   372_2421551 2011          N 2.300000e+01 -4.550000e+01 1.918830e-01
      2073   372_2421551 2011       maxN 7.000000e+00 -9.000000e+00 5.625889e-01
      2074   372_2421551 2011    Shannon 2.362440e+00 -2.002550e-02 5.867931e-01
      2075   372_2421551 2011    Simpson 8.657845e-01 -2.857212e-03 9.312632e-01
      2076   372_2421551 2011 invSimpson 7.450704e+00 -1.656659e-01 9.077874e-01
      2077   372_2421551 2011        PIE 9.051383e-01  1.296352e-02 7.728793e-01
      2078   372_2421551 2011      DomMc 3.913043e-01 -1.716247e-03 9.791772e-01
      2079   372_2421551 2011 expShannon 1.061682e+01 -2.169221e-01 5.811512e-01
      2080   372_2406229 2010          S 4.200000e+01  2.000000e-01 9.612217e-01
      2081   372_2406229 2010          N 6.870000e+02 -8.800000e+00 9.141935e-01
      2082   372_2406229 2010       maxN 2.780000e+02 -1.100000e+01 8.678549e-01
      2083   372_2406229 2010    Shannon 2.416640e+00  6.974297e-02 6.639706e-01
      2084   372_2406229 2010    Simpson 8.044978e-01  1.109569e-02 7.731711e-01
      2085   372_2406229 2010 invSimpson 5.115031e+00  7.719563e-01 8.057107e-01
      2086   372_2406229 2010        PIE 8.056705e-01  1.110304e-02 7.748294e-01
      2087   372_2406229 2010      DomMc 5.312955e-01 -2.019331e-02 8.153923e-01
      2088   372_2406229 2010 expShannon 1.120813e+01  1.100404e+00 6.505222e-01
      2089   372_2406229 2012          S 3.200000e+01  2.000000e-01 9.612217e-01
      2090   372_2406229 2012          N 4.480000e+02 -8.800000e+00 9.141935e-01
      2091   372_2406229 2012       maxN 9.100000e+01 -1.100000e+01 8.678549e-01
      2092   372_2406229 2012    Shannon 2.889521e+00  6.974297e-02 6.639706e-01
      2093   372_2406229 2012    Simpson 9.181680e-01  1.109569e-02 7.731711e-01
      2094   372_2406229 2012 invSimpson 1.222017e+01  7.719563e-01 8.057107e-01
      2095   372_2406229 2012        PIE 9.202221e-01  1.110304e-02 7.748294e-01
      2096   372_2406229 2012      DomMc 3.035714e-01 -2.019331e-02 8.153923e-01
      2097   372_2406229 2012 expShannon 1.798469e+01  1.100404e+00 6.505222e-01
      2098   372_2406229 2011          S 2.900000e+01  2.000000e-01 9.612217e-01
      2099   372_2406229 2011          N 4.370000e+02 -8.800000e+00 9.141935e-01
      2100   372_2406229 2011       maxN 5.400000e+01 -1.100000e+01 8.678549e-01
      2101   372_2406229 2011    Shannon 3.037342e+00  6.974297e-02 6.639706e-01
      2102   372_2406229 2011    Simpson 9.423414e-01  1.109569e-02 7.731711e-01
      2103   372_2406229 2011 invSimpson 1.734347e+01  7.719563e-01 8.057107e-01
      2104   372_2406229 2011        PIE 9.445028e-01  1.110304e-02 7.748294e-01
      2105   372_2406229 2011      DomMc 2.105263e-01 -2.019331e-02 8.153923e-01
      2106   372_2406229 2011 expShannon 2.084975e+01  1.100404e+00 6.505222e-01
      2107   372_2406229 2009          S 2.700000e+01  2.000000e-01 9.612217e-01
      2108   372_2406229 2009          N 3.940000e+02 -8.800000e+00 9.141935e-01
      2109   372_2406229 2009       maxN 5.300000e+01 -1.100000e+01 8.678549e-01
      2110   372_2406229 2009    Shannon 2.863945e+00  6.974297e-02 6.639706e-01
      2111   372_2406229 2009    Simpson 9.271303e-01  1.109569e-02 7.731711e-01
      2112   372_2406229 2009 invSimpson 1.372313e+01  7.719563e-01 8.057107e-01
      2113   372_2406229 2009        PIE 9.294894e-01  1.110304e-02 7.748294e-01
      2114   372_2406229 2009      DomMc 2.639594e-01 -2.019331e-02 8.153923e-01
      2115   372_2406229 2009 expShannon 1.753055e+01  1.100404e+00 6.505222e-01
      2116   372_2402583 2010          S 3.800000e+01 -2.300000e+00 4.204545e-01
      2117   372_2402583 2010          N 6.880000e+02 -4.440000e+01 3.420453e-01
      2118   372_2402583 2010       maxN 1.050000e+02 -4.500000e+00 7.572880e-01
      2119   372_2402583 2010    Shannon 3.000191e+00 -6.623444e-02 4.110969e-01
      2120   372_2402583 2010    Simpson 9.298650e-01 -6.306986e-03 4.567426e-01
      2121   372_2402583 2010 invSimpson 1.425821e+01 -7.571862e-01 5.241853e-01
      2122   372_2402583 2010        PIE 9.312185e-01 -6.242116e-03 4.607301e-01
      2123   372_2402583 2010      DomMc 2.747093e-01  1.194878e-02 4.965465e-01
      2124   372_2402583 2010 expShannon 2.008937e+01 -1.090995e+00 4.359431e-01
      2125   372_2402583 2011          S 4.200000e+01 -2.300000e+00 4.204545e-01
      2126   372_2402583 2011          N 7.960000e+02 -4.440000e+01 3.420453e-01
      2127   372_2402583 2011       maxN 1.200000e+02 -4.500000e+00 7.572880e-01
      2128   372_2402583 2011    Shannon 2.990468e+00 -6.623444e-02 4.110969e-01
      2129   372_2402583 2011    Simpson 9.270757e-01 -6.306986e-03 4.567426e-01
      2130   372_2402583 2011 invSimpson 1.371285e+01 -7.571862e-01 5.241853e-01
      2131   372_2402583 2011        PIE 9.282418e-01 -6.242116e-03 4.607301e-01
      2132   372_2402583 2011      DomMc 2.826633e-01  1.194878e-02 4.965465e-01
      2133   372_2402583 2011 expShannon 1.989498e+01 -1.090995e+00 4.359431e-01
      2134   372_2402583 2009          S 3.900000e+01 -2.300000e+00 4.204545e-01
      2135   372_2402583 2009          N 8.370000e+02 -4.440000e+01 3.420453e-01
      2136   372_2402583 2009       maxN 1.600000e+02 -4.500000e+00 7.572880e-01
      2137   372_2402583 2009    Shannon 2.905254e+00 -6.623444e-02 4.110969e-01
      2138   372_2402583 2009    Simpson 9.168804e-01 -6.306986e-03 4.567426e-01
      2139   372_2402583 2009 invSimpson 1.203086e+01 -7.571862e-01 5.241853e-01
      2140   372_2402583 2009        PIE 9.179772e-01 -6.242116e-03 4.607301e-01
      2141   372_2402583 2009      DomMc 3.058542e-01  1.194878e-02 4.965465e-01
      2142   372_2402583 2009 expShannon 1.826989e+01 -1.090995e+00 4.359431e-01
      2143   372_2402583 2012          S 3.000000e+01 -2.300000e+00 4.204545e-01
      2144   372_2402583 2012          N 6.530000e+02 -4.440000e+01 3.420453e-01
      2145   372_2402583 2012       maxN 1.400000e+02 -4.500000e+00 7.572880e-01
      2146   372_2402583 2012    Shannon 2.687714e+00 -6.623444e-02 4.110969e-01
      2147   372_2402583 2012    Simpson 8.967869e-01 -6.306986e-03 4.567426e-01
      2148   372_2402583 2012 invSimpson 9.688691e+00 -7.571862e-01 5.241853e-01
      2149   372_2402583 2012        PIE 8.981623e-01 -6.242116e-03 4.607301e-01
      2150   372_2402583 2012      DomMc 3.430322e-01  1.194878e-02 4.965465e-01
      2151   372_2402583 2012 expShannon 1.469804e+01 -1.090995e+00 4.359431e-01
      2152   372_2425903 2009          S 4.100000e+01 -2.500000e+00 4.327586e-01
      2153   372_2425903 2009          N 6.730000e+02 -1.170000e+02 1.510334e-01
      2154   372_2425903 2009       maxN 2.190000e+02 -5.000000e+01 4.626769e-01
      2155   372_2425903 2009    Shannon 2.513369e+00  7.609754e-02 5.987019e-01
      2156   372_2425903 2009    Simpson 8.471791e-01  1.290152e-02 7.019484e-01
      2157   372_2425903 2009 invSimpson 6.543609e+00  6.646511e-01 7.825293e-01
      2158   372_2425903 2009        PIE 8.484398e-01  1.326774e-02 6.956554e-01
      2159   372_2425903 2009      DomMc 4.606241e-01 -2.436985e-04 9.974962e-01
      2160   372_2425903 2009 expShannon 1.234646e+01  1.014801e+00 6.214472e-01
      2161   372_2425903 2010          S 3.500000e+01 -2.500000e+00 4.327586e-01
      2162   372_2425903 2010          N 5.070000e+02 -1.170000e+02 1.510334e-01
      2163   372_2425903 2010       maxN 9.200000e+01 -5.000000e+01 4.626769e-01
      2164   372_2425903 2010    Shannon 2.770105e+00  7.609754e-02 5.987019e-01
      2165   372_2425903 2010    Simpson 9.042712e-01  1.290152e-02 7.019484e-01
      2166   372_2425903 2010 invSimpson 1.044617e+01  6.646511e-01 7.825293e-01
      2167   372_2425903 2010        PIE 9.060583e-01  1.326774e-02 6.956554e-01
      2168   372_2425903 2010      DomMc 3.530572e-01 -2.436985e-04 9.974962e-01
      2169   372_2425903 2010 expShannon 1.596031e+01  1.014801e+00 6.214472e-01
      2170   372_2425903 2011          S 3.600000e+01 -2.500000e+00 4.327586e-01
      2171   372_2425903 2011          N 4.390000e+02 -1.170000e+02 1.510334e-01
      2172   372_2425903 2011       maxN 1.190000e+02 -5.000000e+01 4.626769e-01
      2173   372_2425903 2011    Shannon 2.665565e+00  7.609754e-02 5.987019e-01
      2174   372_2425903 2011    Simpson 8.729822e-01  1.290152e-02 7.019484e-01
      2175   372_2425903 2011 invSimpson 7.872911e+00  6.646511e-01 7.825293e-01
      2176   372_2425903 2011        PIE 8.749753e-01  1.326774e-02 6.956554e-01
      2177   372_2425903 2011      DomMc 4.601367e-01 -2.436985e-04 9.974962e-01
      2178   372_2425903 2011 expShannon 1.437606e+01  1.014801e+00 6.214472e-01
      2179   372_2426633 2009          S 3.300000e+01 -1.400000e+00 6.718349e-01
      2180   372_2426633 2009          N 8.370000e+02 -7.170000e+01 6.278853e-01
      2181   372_2426633 2009       maxN 2.730000e+02 -3.040000e+01 5.923922e-01
      2182   372_2426633 2009    Shannon 2.500609e+00 -2.504234e-02 8.991570e-01
      2183   372_2426633 2009    Simpson 8.515906e-01 -1.158108e-03 9.677904e-01
      2184   372_2426633 2009 invSimpson 6.738119e+00  2.618799e-01 9.227189e-01
      2185   372_2426633 2009        PIE 8.526093e-01 -1.087350e-03 9.699182e-01
      2186   372_2426633 2009      DomMc 4.492234e-01  1.213499e-03 9.860610e-01
      2187   372_2426633 2009 expShannon 1.218991e+01 -5.202127e-02 9.861481e-01
      2188   372_2426633 2010          S 2.700000e+01 -1.400000e+00 6.718349e-01
      2189   372_2426633 2010          N 2.960000e+02 -7.170000e+01 6.278853e-01
      2190   372_2426633 2010       maxN 4.700000e+01 -3.040000e+01 5.923922e-01
      2191   372_2426633 2010    Shannon 2.733689e+00 -2.504234e-02 8.991570e-01
      2192   372_2426633 2010    Simpson 9.127557e-01 -1.158108e-03 9.677904e-01
      2193   372_2426633 2010 invSimpson 1.146206e+01  2.618799e-01 9.227189e-01
      2194   372_2426633 2010        PIE 9.158497e-01 -1.087350e-03 9.699182e-01
      2195   372_2426633 2010      DomMc 2.837838e-01  1.213499e-03 9.860610e-01
      2196   372_2426633 2010 expShannon 1.538955e+01 -5.202127e-02 9.861481e-01
      2197   372_2426633 2011          S 3.700000e+01 -1.400000e+00 6.718349e-01
      2198   372_2426633 2011          N 7.310000e+02 -7.170000e+01 6.278853e-01
      2199   372_2426633 2011       maxN 1.030000e+02 -3.040000e+01 5.923922e-01
      2200   372_2426633 2011    Shannon 3.054434e+00 -2.504234e-02 8.991570e-01
      2201   372_2426633 2011    Simpson 9.356184e-01 -1.158108e-03 9.677904e-01
      2202   372_2426633 2011 invSimpson 1.553240e+01  2.618799e-01 9.227189e-01
      2203   372_2426633 2011        PIE 9.369001e-01 -1.087350e-03 9.699182e-01
      2204   372_2426633 2011      DomMc 2.462380e-01  1.213499e-03 9.860610e-01
      2205   372_2426633 2011 expShannon 2.120917e+01 -5.202127e-02 9.861481e-01
      2206   372_2426633 2012          S 2.500000e+01 -1.400000e+00 6.718349e-01
      2207   372_2426633 2012          N 4.530000e+02 -7.170000e+01 6.278853e-01
      2208   372_2426633 2012       maxN 1.530000e+02 -3.040000e+01 5.923922e-01
      2209   372_2426633 2012    Shannon 2.310219e+00 -2.504234e-02 8.991570e-01
      2210   372_2426633 2012    Simpson 8.401094e-01 -1.158108e-03 9.677904e-01
      2211   372_2426633 2012 invSimpson 6.254274e+00  2.618799e-01 9.227189e-01
      2212   372_2426633 2012        PIE 8.419680e-01 -1.087350e-03 9.699182e-01
      2213   372_2426633 2012      DomMc 4.657837e-01  1.213499e-03 9.860610e-01
      2214   372_2426633 2012 expShannon 1.007663e+01 -5.202127e-02 9.861481e-01
      2215   372_2403302 2010          S 2.200000e+01 -1.900000e+00 5.086024e-01
      2216   372_2403302 2010          N 2.120000e+02 -2.510000e+01 6.024253e-01
      2217   372_2403302 2010       maxN 3.700000e+01 -8.600000e+00 3.123300e-01
      2218   372_2403302 2010    Shannon 2.506905e+00  9.429241e-03 9.222207e-01
      2219   372_2403302 2010    Simpson 8.890174e-01  1.379928e-02 3.660730e-01
      2220   372_2403302 2010 invSimpson 9.010425e+00  5.981686e-01 4.465082e-01
      2221   372_2403302 2010        PIE 8.932308e-01  2.023974e-02 1.748901e-01
      2222   372_2403302 2010      DomMc 3.490566e-01 -3.098584e-02 4.340262e-01
      2223   372_2403302 2010 expShannon 1.226691e+01  5.846832e-02 9.535691e-01
      2224   372_2403302 2011          S 2.100000e+01 -1.900000e+00 5.086024e-01
      2225   372_2403302 2011          N 1.830000e+02 -2.510000e+01 6.024253e-01
      2226   372_2403302 2011       maxN 4.100000e+01 -8.600000e+00 3.123300e-01
      2227   372_2403302 2011    Shannon 2.406730e+00  9.429241e-03 9.222207e-01
      2228   372_2403302 2011    Simpson 8.736003e-01  1.379928e-02 3.660730e-01
      2229   372_2403302 2011 invSimpson 7.911410e+00  5.981686e-01 4.465082e-01
      2230   372_2403302 2011        PIE 8.784003e-01  2.023974e-02 1.748901e-01
      2231   372_2403302 2011      DomMc 4.207650e-01 -3.098584e-02 4.340262e-01
      2232   372_2403302 2011 expShannon 1.109761e+01  5.846832e-02 9.535691e-01
      2233   372_2403302 2009          S 1.700000e+01 -1.900000e+00 5.086024e-01
      2234   372_2403302 2009          N 1.050000e+02 -2.510000e+01 6.024253e-01
      2235   372_2403302 2009       maxN 3.600000e+01 -8.600000e+00 3.123300e-01
      2236   372_2403302 2009    Shannon 2.166790e+00  9.429241e-03 9.222207e-01
      2237   372_2403302 2009    Simpson 8.250340e-01  1.379928e-02 3.660730e-01
      2238   372_2403302 2009 invSimpson 5.715397e+00  5.981686e-01 4.465082e-01
      2239   372_2403302 2009        PIE 8.329670e-01  2.023974e-02 1.748901e-01
      2240   372_2403302 2009      DomMc 5.142857e-01 -3.098584e-02 4.340262e-01
      2241   372_2403302 2009 expShannon 8.730218e+00  5.846832e-02 9.535691e-01
      2242   372_2403302 2012          S 1.100000e+01 -1.900000e+00 5.086024e-01
      2243   372_2403302 2012          N 3.100000e+01 -2.510000e+01 6.024253e-01
      2244   372_2403302 2012       maxN 6.000000e+00 -8.600000e+00 3.123300e-01
      2245   372_2403302 2012    Shannon 2.231613e+00  9.429241e-03 9.222207e-01
      2246   372_2403302 2012    Simpson 8.761707e-01  1.379928e-02 3.660730e-01
      2247   372_2403302 2012 invSimpson 8.075630e+00  5.981686e-01 4.465082e-01
      2248   372_2403302 2012        PIE 9.053763e-01  2.023974e-02 1.748901e-01
      2249   372_2403302 2012      DomMc 3.870968e-01 -3.098584e-02 4.340262e-01
      2250   372_2403302 2012 expShannon 9.314879e+00  5.846832e-02 9.535691e-01
      2251   372_2369058 2008          S 1.700000e+01 -2.000000e+00 3.803992e-01
      2252   372_2369058 2008          N 1.700000e+02 -4.100000e+01 8.183577e-02
      2253   372_2369058 2008       maxN 1.280000e+02 -3.050000e+01 5.142691e-04
      2254   372_2369058 2008    Shannon 1.187858e+00  1.603792e-01 3.822711e-01
      2255   372_2369058 2008    Simpson 4.271972e-01  8.451917e-02 1.544407e-01
      2256   372_2369058 2008 invSimpson 1.745802e+00  1.003320e+00 1.497008e-01
      2257   372_2369058 2008        PIE 4.297250e-01  8.905210e-02 1.338713e-01
      2258   372_2369058 2008      DomMc 8.000000e-01 -7.170561e-02 1.372469e-01
      2259   372_2369058 2008 expShannon 3.280047e+00  8.450391e-01 4.904725e-01
      2260   372_2369058 2009          S 2.700000e+01 -2.000000e+00 3.803992e-01
      2261   372_2369058 2009          N 2.410000e+02 -4.100000e+01 8.183577e-02
      2262   372_2369058 2009       maxN 9.300000e+01 -3.050000e+01 5.142691e-04
      2263   372_2369058 2009    Shannon 2.347355e+00  1.603792e-01 3.822711e-01
      2264   372_2369058 2009    Simpson 8.177545e-01  8.451917e-02 1.544407e-01
      2265   372_2369058 2009 invSimpson 5.487104e+00  1.003320e+00 1.497008e-01
      2266   372_2369058 2009        PIE 8.211618e-01  8.905210e-02 1.338713e-01
      2267   372_2369058 2009      DomMc 4.854772e-01 -7.170561e-02 1.372469e-01
      2268   372_2369058 2009 expShannon 1.045787e+01  8.450391e-01 4.904725e-01
      2269   372_2369058 2011          S 2.100000e+01 -2.000000e+00 3.803992e-01
      2270   372_2369058 2011          N 9.500000e+01 -4.100000e+01 8.183577e-02
      2271   372_2369058 2011       maxN 2.600000e+01 -3.050000e+01 5.142691e-04
      2272   372_2369058 2011    Shannon 2.446603e+00  1.603792e-01 3.822711e-01
      2273   372_2369058 2011    Simpson 8.691413e-01  8.451917e-02 1.544407e-01
      2274   372_2369058 2011 invSimpson 7.641829e+00  1.003320e+00 1.497008e-01
      2275   372_2369058 2011        PIE 8.783875e-01  8.905210e-02 1.338713e-01
      2276   372_2369058 2011      DomMc 4.210526e-01 -7.170561e-02 1.372469e-01
      2277   372_2369058 2011 expShannon 1.154904e+01  8.450391e-01 4.904725e-01
      2278   372_2369058 2010          S 2.000000e+01 -2.000000e+00 3.803992e-01
      2279   372_2369058 2010          N 1.700000e+02 -4.100000e+01 8.183577e-02
      2280   372_2369058 2010       maxN 6.600000e+01 -3.050000e+01 5.142691e-04
      2281   372_2369058 2010    Shannon 2.118337e+00  1.603792e-01 3.822711e-01
      2282   372_2369058 2010    Simpson 8.017301e-01  8.451917e-02 1.544407e-01
      2283   372_2369058 2010 invSimpson 5.043630e+00  1.003320e+00 1.497008e-01
      2284   372_2369058 2010        PIE 8.064741e-01  8.905210e-02 1.338713e-01
      2285   372_2369058 2010      DomMc 5.235294e-01 -7.170561e-02 1.372469e-01
      2286   372_2369058 2010 expShannon 8.317291e+00  8.450391e-01 4.904725e-01
      2287   372_2369058 2012          S 1.000000e+01 -2.000000e+00 3.803992e-01
      2288   372_2369058 2012          N 3.800000e+01 -4.100000e+01 8.183577e-02
      2289   372_2369058 2012       maxN 9.000000e+00 -3.050000e+01 5.142691e-04
      2290   372_2369058 2012    Shannon 1.940130e+00  1.603792e-01 3.822711e-01
      2291   372_2369058 2012    Simpson 8.240997e-01  8.451917e-02 1.544407e-01
      2292   372_2369058 2012 invSimpson 5.685039e+00  1.003320e+00 1.497008e-01
      2293   372_2369058 2012        PIE 8.463727e-01  8.905210e-02 1.338713e-01
      2294   372_2369058 2012      DomMc 4.736842e-01 -7.170561e-02 1.372469e-01
      2295   372_2369058 2012 expShannon 6.959654e+00  8.450391e-01 4.904725e-01
      2296   372_2399671 2005          S 1.800000e+01  1.261905e+00 4.950093e-02
      2297   372_2399671 2005          N 2.470000e+02  1.729762e+01 2.948737e-01
      2298   372_2399671 2005       maxN 6.200000e+01  1.177381e+01 6.364514e-02
      2299   372_2399671 2005    Shannon 2.049360e+00  1.661273e-02 7.531522e-01
      2300   372_2399671 2005    Simpson 8.264682e-01 -7.062377e-03 4.570530e-01
      2301   372_2399671 2005 invSimpson 5.762633e+00 -2.631506e-01 6.613363e-01
      2302   372_2399671 2005        PIE 8.298279e-01 -7.326841e-03 4.434015e-01
      2303   372_2399671 2005      DomMc 4.696356e-01  1.439750e-02 4.442161e-01
      2304   372_2399671 2005 expShannon 7.762929e+00  1.754296e-01 7.868032e-01
      2305   372_2399671 2006          S 2.500000e+01  1.261905e+00 4.950093e-02
      2306   372_2399671 2006          N 1.990000e+02  1.729762e+01 2.948737e-01
      2307   372_2399671 2006       maxN 3.500000e+01  1.177381e+01 6.364514e-02
      2308   372_2399671 2006    Shannon 2.684615e+00  1.661273e-02 7.531522e-01
      2309   372_2399671 2006    Simpson 9.068963e-01 -7.062377e-03 4.570530e-01
      2310   372_2399671 2006 invSimpson 1.074071e+01 -2.631506e-01 6.613363e-01
      2311   372_2399671 2006        PIE 9.114766e-01 -7.326841e-03 4.434015e-01
      2312   372_2399671 2006      DomMc 3.115578e-01  1.439750e-02 4.442161e-01
      2313   372_2399671 2006 expShannon 1.465256e+01  1.754296e-01 7.868032e-01
      2314   372_2399671 2007          S 2.000000e+01  1.261905e+00 4.950093e-02
      2315   372_2399671 2007          N 1.480000e+02  1.729762e+01 2.948737e-01
      2316   372_2399671 2007       maxN 2.400000e+01  1.177381e+01 6.364514e-02
      2317   372_2399671 2007    Shannon 2.604554e+00  1.661273e-02 7.531522e-01
      2318   372_2399671 2007    Simpson 9.096056e-01 -7.062377e-03 4.570530e-01
      2319   372_2399671 2007 invSimpson 1.106263e+01 -2.631506e-01 6.613363e-01
      2320   372_2399671 2007        PIE 9.157933e-01 -7.326841e-03 4.434015e-01
      2321   372_2399671 2007      DomMc 2.837838e-01  1.439750e-02 4.442161e-01
      2322   372_2399671 2007 expShannon 1.352519e+01  1.754296e-01 7.868032e-01
      2323   372_2399671 2008          S 2.900000e+01  1.261905e+00 4.950093e-02
      2324   372_2399671 2008          N 4.200000e+02  1.729762e+01 2.948737e-01
      2325   372_2399671 2008       maxN 8.300000e+01  1.177381e+01 6.364514e-02
      2326   372_2399671 2008    Shannon 2.765089e+00  1.661273e-02 7.531522e-01
      2327   372_2399671 2008    Simpson 9.114399e-01 -7.062377e-03 4.570530e-01
      2328   372_2399671 2008 invSimpson 1.129177e+01 -2.631506e-01 6.613363e-01
      2329   372_2399671 2008        PIE 9.136152e-01 -7.326841e-03 4.434015e-01
      2330   372_2399671 2008      DomMc 2.976190e-01  1.439750e-02 4.442161e-01
      2331   372_2399671 2008 expShannon 1.588045e+01  1.754296e-01 7.868032e-01
      2332   372_2399671 2009          S 2.800000e+01  1.261905e+00 4.950093e-02
      2333   372_2399671 2009          N 3.410000e+02  1.729762e+01 2.948737e-01
      2334   372_2399671 2009       maxN 5.300000e+01  1.177381e+01 6.364514e-02
      2335   372_2399671 2009    Shannon 2.952838e+00  1.661273e-02 7.531522e-01
      2336   372_2399671 2009    Simpson 9.316225e-01 -7.062377e-03 4.570530e-01
      2337   372_2399671 2009 invSimpson 1.462470e+01 -2.631506e-01 6.613363e-01
      2338   372_2399671 2009        PIE 9.343626e-01 -7.326841e-03 4.434015e-01
      2339   372_2399671 2009      DomMc 2.521994e-01  1.439750e-02 4.442161e-01
      2340   372_2399671 2009 expShannon 1.916025e+01  1.754296e-01 7.868032e-01
      2341   372_2399671 2010          S 2.400000e+01  1.261905e+00 4.950093e-02
      2342   372_2399671 2010          N 2.180000e+02  1.729762e+01 2.948737e-01
      2343   372_2399671 2010       maxN 4.100000e+01  1.177381e+01 6.364514e-02
      2344   372_2399671 2010    Shannon 2.771088e+00  1.661273e-02 7.531522e-01
      2345   372_2399671 2010    Simpson 9.158741e-01 -7.062377e-03 4.570530e-01
      2346   372_2399671 2010 invSimpson 1.188694e+01 -2.631506e-01 6.613363e-01
      2347   372_2399671 2010        PIE 9.200947e-01 -7.326841e-03 4.434015e-01
      2348   372_2399671 2010      DomMc 3.073394e-01  1.439750e-02 4.442161e-01
      2349   372_2399671 2010 expShannon 1.597601e+01  1.754296e-01 7.868032e-01
      2350   372_2399671 2011          S 3.000000e+01  1.261905e+00 4.950093e-02
      2351   372_2399671 2011          N 4.130000e+02  1.729762e+01 2.948737e-01
      2352   372_2399671 2011       maxN 1.390000e+02  1.177381e+01 6.364514e-02
      2353   372_2399671 2011    Shannon 2.622654e+00  1.661273e-02 7.531522e-01
      2354   372_2399671 2011    Simpson 8.601798e-01 -7.062377e-03 4.570530e-01
      2355   372_2399671 2011 invSimpson 7.152040e+00 -2.631506e-01 6.613363e-01
      2356   372_2399671 2011        PIE 8.622676e-01 -7.326841e-03 4.434015e-01
      2357   372_2399671 2011      DomMc 3.995157e-01  1.439750e-02 4.442161e-01
      2358   372_2399671 2011 expShannon 1.377222e+01  1.754296e-01 7.868032e-01
      2359   372_2399671 2012          S 2.800000e+01  1.261905e+00 4.950093e-02
      2360   372_2399671 2012          N 2.830000e+02  1.729762e+01 2.948737e-01
      2361   372_2399671 2012       maxN 1.260000e+02  1.177381e+01 6.364514e-02
      2362   372_2399671 2012    Shannon 2.194778e+00  1.661273e-02 7.531522e-01
      2363   372_2399671 2012    Simpson 7.695189e-01 -7.062377e-03 4.570530e-01
      2364   372_2399671 2012 invSimpson 4.338751e+00 -2.631506e-01 6.613363e-01
      2365   372_2399671 2012        PIE 7.722477e-01 -7.326841e-03 4.434015e-01
      2366   372_2399671 2012      DomMc 5.759717e-01  1.439750e-02 4.442161e-01
      2367   372_2399671 2012 expShannon 8.978004e+00  1.754296e-01 7.868032e-01
      2368   372_2431035 2007          S 1.200000e+01  5.142857e-01 7.468164e-01
      2369   372_2431035 2007          N 6.200000e+01 -7.971429e+00 8.244970e-01
      2370   372_2431035 2007       maxN 2.000000e+01 -3.600000e+00 7.064580e-01
      2371   372_2431035 2007    Shannon 2.117871e+00  7.368484e-02 2.064261e-01
      2372   372_2431035 2007    Simpson 8.387097e-01  1.150559e-02 1.537257e-01
      2373   372_2431035 2007 invSimpson 6.200000e+00  8.045728e-01 1.886336e-01
      2374   372_2431035 2007        PIE 8.524590e-01  1.183212e-02 1.774196e-01
      2375   372_2431035 2007      DomMc 4.516129e-01 -2.713068e-02 1.770382e-01
      2376   372_2431035 2007 expShannon 8.313419e+00  8.102143e-01 2.410441e-01
      2377   372_2431035 2008          S 1.900000e+01  5.142857e-01 7.468164e-01
      2378   372_2431035 2008          N 6.400000e+01 -7.971429e+00 8.244970e-01
      2379   372_2431035 2008       maxN 1.500000e+01 -3.600000e+00 7.064580e-01
      2380   372_2431035 2008    Shannon 2.530507e+00  7.368484e-02 2.064261e-01
      2381   372_2431035 2008    Simpson 8.881836e-01  1.150559e-02 1.537257e-01
      2382   372_2431035 2008 invSimpson 8.943231e+00  8.045728e-01 1.886336e-01
      2383   372_2431035 2008        PIE 9.022817e-01  1.183212e-02 1.774196e-01
      2384   372_2431035 2008      DomMc 3.906250e-01 -2.713068e-02 1.770382e-01
      2385   372_2431035 2008 expShannon 1.255988e+01  8.102143e-01 2.410441e-01
      2386   372_2431035 2009          S 2.900000e+01  5.142857e-01 7.468164e-01
      2387   372_2431035 2009          N 3.780000e+02 -7.971429e+00 8.244970e-01
      2388   372_2431035 2009       maxN 9.800000e+01 -3.600000e+00 7.064580e-01
      2389   372_2431035 2009    Shannon 2.350953e+00  7.368484e-02 2.064261e-01
      2390   372_2431035 2009    Simpson 8.483665e-01  1.150559e-02 1.537257e-01
      2391   372_2431035 2009 invSimpson 6.594849e+00  8.045728e-01 1.886336e-01
      2392   372_2431035 2009        PIE 8.506168e-01  1.183212e-02 1.774196e-01
      2393   372_2431035 2009      DomMc 4.920635e-01 -2.713068e-02 1.770382e-01
      2394   372_2431035 2009 expShannon 1.049557e+01  8.102143e-01 2.410441e-01
      2395   372_2431035 2010          S 2.200000e+01  5.142857e-01 7.468164e-01
      2396   372_2431035 2010          N 8.800000e+01 -7.971429e+00 8.244970e-01
      2397   372_2431035 2010       maxN 1.700000e+01 -3.600000e+00 7.064580e-01
      2398   372_2431035 2010    Shannon 2.756470e+00  7.368484e-02 2.064261e-01
      2399   372_2431035 2010    Simpson 9.147727e-01  1.150559e-02 1.537257e-01
      2400   372_2431035 2010 invSimpson 1.173333e+01  8.045728e-01 1.886336e-01
      2401   372_2431035 2010        PIE 9.252874e-01  1.183212e-02 1.774196e-01
      2402   372_2431035 2010      DomMc 3.181818e-01 -2.713068e-02 1.770382e-01
      2403   372_2431035 2010 expShannon 1.574417e+01  8.102143e-01 2.410441e-01
      2404   372_2431035 2011          S 1.900000e+01  5.142857e-01 7.468164e-01
      2405   372_2431035 2011          N 6.100000e+01 -7.971429e+00 8.244970e-01
      2406   372_2431035 2011       maxN 1.000000e+01 -3.600000e+00 7.064580e-01
      2407   372_2431035 2011    Shannon 2.668788e+00  7.368484e-02 2.064261e-01
      2408   372_2431035 2011    Simpson 9.158828e-01  1.150559e-02 1.537257e-01
      2409   372_2431035 2011 invSimpson 1.188818e+01  8.045728e-01 1.886336e-01
      2410   372_2431035 2011        PIE 9.311475e-01  1.183212e-02 1.774196e-01
      2411   372_2431035 2011      DomMc 2.786885e-01 -2.713068e-02 1.770382e-01
      2412   372_2431035 2011 expShannon 1.442248e+01  8.102143e-01 2.410441e-01
      2413   372_2431035 2012          S 1.700000e+01  5.142857e-01 7.468164e-01
      2414   372_2431035 2012          N 6.600000e+01 -7.971429e+00 8.244970e-01
      2415   372_2431035 2012       maxN 1.400000e+01 -3.600000e+00 7.064580e-01
      2416   372_2431035 2012    Shannon 2.469593e+00  7.368484e-02 2.064261e-01
      2417   372_2431035 2012    Simpson 8.893480e-01  1.150559e-02 1.537257e-01
      2418   372_2431035 2012 invSimpson 9.037344e+00  8.045728e-01 1.886336e-01
      2419   372_2431035 2012        PIE 9.030303e-01  1.183212e-02 1.774196e-01
      2420   372_2431035 2012      DomMc 3.636364e-01 -2.713068e-02 1.770382e-01
      2421   372_2431035 2012 expShannon 1.181763e+01  8.102143e-01 2.410441e-01
      2422   372_2443467 2009          S 2.500000e+01 -4.771429e+00 4.578862e-02
      2423   372_2443467 2009          N 1.300000e+02 -2.508571e+01 5.172154e-02
      2424   372_2443467 2009       maxN 1.600000e+01 -1.257143e+00 5.330878e-01
      2425   372_2443467 2009    Shannon 2.884695e+00 -2.531039e-01 1.110783e-01
      2426   372_2443467 2009    Simpson 9.299408e-01 -3.317237e-02 2.187284e-01
      2427   372_2443467 2009 invSimpson 1.427365e+01 -2.269047e+00 1.027992e-01
      2428   372_2443467 2009        PIE 9.371497e-01 -3.129139e-02 2.288109e-01
      2429   372_2443467 2009      DomMc 2.461538e-01  6.353126e-02 1.568995e-01
      2430   372_2443467 2009 expShannon 1.789811e+01 -3.081172e+00 7.560016e-02
      2431   372_2443467 2012          S 1.300000e+01 -4.771429e+00 4.578862e-02
      2432   372_2443467 2012          N 6.900000e+01 -2.508571e+01 5.172154e-02
      2433   372_2443467 2012       maxN 1.700000e+01 -1.257143e+00 5.330878e-01
      2434   372_2443467 2012    Shannon 2.200006e+00 -2.531039e-01 1.110783e-01
      2435   372_2443467 2012    Simpson 8.590632e-01 -3.317237e-02 2.187284e-01
      2436   372_2443467 2012 invSimpson 7.095380e+00 -2.269047e+00 1.027992e-01
      2437   372_2443467 2012        PIE 8.716965e-01 -3.129139e-02 2.288109e-01
      2438   372_2443467 2012      DomMc 4.347826e-01  6.353126e-02 1.568995e-01
      2439   372_2443467 2012 expShannon 9.025072e+00 -3.081172e+00 7.560016e-02
      2440   372_2443467 2008          S 2.800000e+01 -4.771429e+00 4.578862e-02
      2441   372_2443467 2008          N 1.330000e+02 -2.508571e+01 5.172154e-02
      2442   372_2443467 2008       maxN 1.300000e+01 -1.257143e+00 5.330878e-01
      2443   372_2443467 2008    Shannon 3.041945e+00 -2.531039e-01 1.110783e-01
      2444   372_2443467 2008    Simpson 9.434112e-01 -3.317237e-02 2.187284e-01
      2445   372_2443467 2008 invSimpson 1.767133e+01 -2.269047e+00 1.027992e-01
      2446   372_2443467 2008        PIE 9.505582e-01 -3.129139e-02 2.288109e-01
      2447   372_2443467 2008      DomMc 1.879699e-01  6.353126e-02 1.568995e-01
      2448   372_2443467 2008 expShannon 2.094593e+01 -3.081172e+00 7.560016e-02
      2449   372_2443467 2007          S 3.500000e+01 -4.771429e+00 4.578862e-02
      2450   372_2443467 2007          N 1.970000e+02 -2.508571e+01 5.172154e-02
      2451   372_2443467 2007       maxN 3.300000e+01 -1.257143e+00 5.330878e-01
      2452   372_2443467 2007    Shannon 3.067740e+00 -2.531039e-01 1.110783e-01
      2453   372_2443467 2007    Simpson 9.321034e-01 -3.317237e-02 2.187284e-01
      2454   372_2443467 2007 invSimpson 1.472827e+01 -2.269047e+00 1.027992e-01
      2455   372_2443467 2007        PIE 9.368590e-01 -3.129139e-02 2.288109e-01
      2456   372_2443467 2007      DomMc 2.741117e-01  6.353126e-02 1.568995e-01
      2457   372_2443467 2007 expShannon 2.149327e+01 -3.081172e+00 7.560016e-02
      2458   372_2443467 2010          S 3.100000e+01 -4.771429e+00 4.578862e-02
      2459   372_2443467 2010          N 1.650000e+02 -2.508571e+01 5.172154e-02
      2460   372_2443467 2010       maxN 2.500000e+01 -1.257143e+00 5.330878e-01
      2461   372_2443467 2010    Shannon 3.104157e+00 -2.531039e-01 1.110783e-01
      2462   372_2443467 2010    Simpson 9.405326e-01 -3.317237e-02 2.187284e-01
      2463   372_2443467 2010 invSimpson 1.681594e+01 -2.269047e+00 1.027992e-01
      2464   372_2443467 2010        PIE 9.462676e-01 -3.129139e-02 2.288109e-01
      2465   372_2443467 2010      DomMc 2.303030e-01  6.353126e-02 1.568995e-01
      2466   372_2443467 2010 expShannon 2.229041e+01 -3.081172e+00 7.560016e-02
      2467   372_2443467 2011          S 7.000000e+00 -4.771429e+00 4.578862e-02
      2468   372_2443467 2011          N 4.200000e+01 -2.508571e+01 5.172154e-02
      2469   372_2443467 2011       maxN 2.200000e+01 -1.257143e+00 5.330878e-01
      2470   372_2443467 2011    Shannon 1.462135e+00 -2.531039e-01 1.110783e-01
      2471   372_2443467 2011    Simpson 6.746032e-01 -3.317237e-02 2.187284e-01
      2472   372_2443467 2011 invSimpson 3.073171e+00 -2.269047e+00 1.027992e-01
      2473   372_2443467 2011        PIE 6.910569e-01 -3.129139e-02 2.288109e-01
      2474   372_2443467 2011      DomMc 6.666667e-01  6.353126e-02 1.568995e-01
      2475   372_2443467 2011 expShannon 4.315161e+00 -3.081172e+00 7.560016e-02
      2476   372_2393839 2008          S 2.600000e+01  4.571429e-01 6.789458e-01
      2477   372_2393839 2008          N 4.790000e+02  1.114286e+00 9.714606e-01
      2478   372_2393839 2008       maxN 1.050000e+02 -3.714286e-01 9.616028e-01
      2479   372_2393839 2008    Shannon 2.526048e+00 -1.857539e-02 3.591261e-01
      2480   372_2393839 2008    Simpson 8.859968e-01 -2.550766e-03 2.564246e-01
      2481   372_2393839 2008 invSimpson 8.771686e+00 -1.677303e-01 3.105447e-01
      2482   372_2393839 2008        PIE 8.878504e-01 -2.582812e-03 2.501896e-01
      2483   372_2393839 2008      DomMc 3.883090e-01  1.085728e-03 8.082650e-01
      2484   372_2393839 2008 expShannon 1.250400e+01 -2.103678e-01 3.825619e-01
      2485   372_2393839 2009          S 1.900000e+01  4.571429e-01 6.789458e-01
      2486   372_2393839 2009          N 2.980000e+02  1.114286e+00 9.714606e-01
      2487   372_2393839 2009       maxN 5.900000e+01 -3.714286e-01 9.616028e-01
      2488   372_2393839 2009    Shannon 2.438626e+00 -1.857539e-02 3.591261e-01
      2489   372_2393839 2009    Simpson 8.818972e-01 -2.550766e-03 2.564246e-01
      2490   372_2393839 2009 invSimpson 8.467201e+00 -1.677303e-01 3.105447e-01
      2491   372_2393839 2009        PIE 8.848666e-01 -2.582812e-03 2.501896e-01
      2492   372_2393839 2009      DomMc 3.791946e-01  1.085728e-03 8.082650e-01
      2493   372_2393839 2009 expShannon 1.145729e+01 -2.103678e-01 3.825619e-01
      2494   372_2393839 2010          S 3.000000e+01  4.571429e-01 6.789458e-01
      2495   372_2393839 2010          N 6.050000e+02  1.114286e+00 9.714606e-01
      2496   372_2393839 2010       maxN 1.360000e+02 -3.714286e-01 9.616028e-01
      2497   372_2393839 2010    Shannon 2.452492e+00 -1.857539e-02 3.591261e-01
      2498   372_2393839 2010    Simpson 8.779127e-01 -2.550766e-03 2.564246e-01
      2499   372_2393839 2010 invSimpson 8.190861e+00 -1.677303e-01 3.105447e-01
      2500   372_2393839 2010        PIE 8.793662e-01 -2.582812e-03 2.501896e-01
      2501   372_2393839 2010      DomMc 3.884298e-01  1.085728e-03 8.082650e-01
      2502   372_2393839 2010 expShannon 1.161726e+01 -2.103678e-01 3.825619e-01
      2503   372_2393839 2011          S 2.600000e+01  4.571429e-01 6.789458e-01
      2504   372_2393839 2011          N 4.790000e+02  1.114286e+00 9.714606e-01
      2505   372_2393839 2011       maxN 1.040000e+02 -3.714286e-01 9.616028e-01
      2506   372_2393839 2011    Shannon 2.575846e+00 -1.857539e-02 3.591261e-01
      2507   372_2393839 2011    Simpson 8.936415e-01 -2.550766e-03 2.564246e-01
      2508   372_2393839 2011 invSimpson 9.402164e+00 -1.677303e-01 3.105447e-01
      2509   372_2393839 2011        PIE 8.955110e-01 -2.582812e-03 2.501896e-01
      2510   372_2393839 2011      DomMc 3.528184e-01  1.085728e-03 8.082650e-01
      2511   372_2393839 2011 expShannon 1.314243e+01 -2.103678e-01 3.825619e-01
      2512   372_2393839 2012          S 2.900000e+01  4.571429e-01 6.789458e-01
      2513   372_2393839 2012          N 5.280000e+02  1.114286e+00 9.714606e-01
      2514   372_2393839 2012       maxN 1.120000e+02 -3.714286e-01 9.616028e-01
      2515   372_2393839 2012    Shannon 2.463626e+00 -1.857539e-02 3.591261e-01
      2516   372_2393839 2012    Simpson 8.722237e-01 -2.550766e-03 2.564246e-01
      2517   372_2393839 2012 invSimpson 7.826175e+00 -1.677303e-01 3.105447e-01
      2518   372_2393839 2012        PIE 8.738787e-01 -2.582812e-03 2.501896e-01
      2519   372_2393839 2012      DomMc 3.958333e-01  1.085728e-03 8.082650e-01
      2520   372_2393839 2012 expShannon 1.174733e+01 -2.103678e-01 3.825619e-01
      2521   372_2393839 2013          S 2.400000e+01  4.571429e-01 6.789458e-01
      2522   372_2393839 2013          N 3.740000e+02  1.114286e+00 9.714606e-01
      2523   372_2393839 2013       maxN 7.700000e+01 -3.714286e-01 9.616028e-01
      2524   372_2393839 2013    Shannon 2.356350e+00 -1.857539e-02 3.591261e-01
      2525   372_2393839 2013    Simpson 8.707999e-01 -2.550766e-03 2.564246e-01
      2526   372_2393839 2013 invSimpson 7.739929e+00 -1.677303e-01 3.105447e-01
      2527   372_2393839 2013        PIE 8.731344e-01 -2.582812e-03 2.501896e-01
      2528   372_2393839 2013      DomMc 3.930481e-01  1.085728e-03 8.082650e-01
      2529   372_2393839 2013 expShannon 1.055236e+01 -2.103678e-01 3.825619e-01
      2530   372_2362487 2012          S 3.500000e+01  2.846154e+00 4.279225e-01
      2531   372_2362487 2012          N 3.670000e+02  3.576923e+00 9.502005e-01
      2532   372_2362487 2012       maxN 6.300000e+01 -7.307692e-01 8.651236e-01
      2533   372_2362487 2012    Shannon 2.896341e+00  9.033239e-02 5.421689e-01
      2534   372_2362487 2012    Simpson 9.188278e-01  5.140920e-03 7.928778e-01
      2535   372_2362487 2012 invSimpson 1.231949e+01  6.330962e-01 6.949839e-01
      2536   372_2362487 2012        PIE 9.213383e-01  5.198951e-03 7.830711e-01
      2537   372_2362487 2012      DomMc 3.079019e-01  9.652357e-04 9.873219e-01
      2538   372_2362487 2012 expShannon 1.810777e+01  1.305682e+00 5.353963e-01
      2539   372_2362487 2008          S 2.100000e+01  2.846154e+00 4.279225e-01
      2540   372_2362487 2008          N 3.000000e+02  3.576923e+00 9.502005e-01
      2541   372_2362487 2008       maxN 6.200000e+01 -7.307692e-01 8.651236e-01
      2542   372_2362487 2008    Shannon 2.415883e+00  9.033239e-02 5.421689e-01
      2543   372_2362487 2008    Simpson 8.806667e-01  5.140920e-03 7.928778e-01
      2544   372_2362487 2008 invSimpson 8.379888e+00  6.330962e-01 6.949839e-01
      2545   372_2362487 2008        PIE 8.836120e-01  5.198951e-03 7.830711e-01
      2546   372_2362487 2008      DomMc 3.600000e-01  9.652357e-04 9.873219e-01
      2547   372_2362487 2008 expShannon 1.119966e+01  1.305682e+00 5.353963e-01
      2548   372_2362487 2011          S 2.300000e+01  2.846154e+00 4.279225e-01
      2549   372_2362487 2011          N 1.790000e+02  3.576923e+00 9.502005e-01
      2550   372_2362487 2011       maxN 5.000000e+01 -7.307692e-01 8.651236e-01
      2551   372_2362487 2011    Shannon 2.389059e+00  9.033239e-02 5.421689e-01
      2552   372_2362487 2011    Simpson 8.520958e-01  5.140920e-03 7.928778e-01
      2553   372_2362487 2011 invSimpson 6.761131e+00  6.330962e-01 6.949839e-01
      2554   372_2362487 2011        PIE 8.568828e-01  5.198951e-03 7.830711e-01
      2555   372_2362487 2011      DomMc 5.027933e-01  9.652357e-04 9.873219e-01
      2556   372_2362487 2011 expShannon 1.090323e+01  1.305682e+00 5.353963e-01
      2557   372_2409874 2008          S 2.100000e+01  5.000000e-01 6.116069e-01
      2558   372_2409874 2008          N 1.750000e+02 -4.300000e+00 7.881104e-01
      2559   372_2409874 2008       maxN 3.800000e+01 -3.600000e+00 6.085903e-02
      2560   372_2409874 2008    Shannon 2.549279e+00  3.747280e-02 3.704172e-01
      2561   372_2409874 2008    Simpson 8.872490e-01  7.301003e-03 4.272536e-01
      2562   372_2409874 2008 invSimpson 8.869099e+00  6.587781e-01 3.530710e-01
      2563   372_2409874 2008        PIE 8.923481e-01  7.639047e-03 3.893960e-01
      2564   372_2409874 2008      DomMc 3.942857e-01 -2.515217e-02 3.398299e-01
      2565   372_2409874 2008 expShannon 1.279788e+01  5.077468e-01 3.599762e-01
      2566   372_2409874 2009          S 2.400000e+01  5.000000e-01 6.116069e-01
      2567   372_2409874 2009          N 1.430000e+02 -4.300000e+00 7.881104e-01
      2568   372_2409874 2009       maxN 3.900000e+01 -3.600000e+00 6.085903e-02
      2569   372_2409874 2009    Shannon 2.504235e+00  3.747280e-02 3.704172e-01
      2570   372_2409874 2009    Simpson 8.705560e-01  7.301003e-03 4.272536e-01
      2571   372_2409874 2009 invSimpson 7.725349e+00  6.587781e-01 3.530710e-01
      2572   372_2409874 2009        PIE 8.766867e-01  7.639047e-03 3.893960e-01
      2573   372_2409874 2009      DomMc 4.335664e-01 -2.515217e-02 3.398299e-01
      2574   372_2409874 2009 expShannon 1.223420e+01  5.077468e-01 3.599762e-01
      2575   372_2409874 2010          S 2.100000e+01  5.000000e-01 6.116069e-01
      2576   372_2409874 2010          N 1.200000e+02 -4.300000e+00 7.881104e-01
      2577   372_2409874 2010       maxN 3.900000e+01 -3.600000e+00 6.085903e-02
      2578   372_2409874 2010    Shannon 2.432065e+00  3.747280e-02 3.704172e-01
      2579   372_2409874 2010    Simpson 8.520833e-01  7.301003e-03 4.272536e-01
      2580   372_2409874 2010 invSimpson 6.760563e+00  6.587781e-01 3.530710e-01
      2581   372_2409874 2010        PIE 8.592437e-01  7.639047e-03 3.893960e-01
      2582   372_2409874 2010      DomMc 4.583333e-01 -2.515217e-02 3.398299e-01
      2583   372_2409874 2010 expShannon 1.138237e+01  5.077468e-01 3.599762e-01
      2584   372_2409874 2011          S 2.700000e+01  5.000000e-01 6.116069e-01
      2585   372_2409874 2011          N 2.140000e+02 -4.300000e+00 7.881104e-01
      2586   372_2409874 2011       maxN 3.100000e+01 -3.600000e+00 6.085903e-02
      2587   372_2409874 2011    Shannon 2.729724e+00  3.747280e-02 3.704172e-01
      2588   372_2409874 2011    Simpson 9.142720e-01  7.301003e-03 4.272536e-01
      2589   372_2409874 2011 invSimpson 1.166480e+01  6.587781e-01 3.530710e-01
      2590   372_2409874 2011        PIE 9.185643e-01  7.639047e-03 3.893960e-01
      2591   372_2409874 2011      DomMc 2.757009e-01 -2.515217e-02 3.398299e-01
      2592   372_2409874 2011 expShannon 1.532865e+01  5.077468e-01 3.599762e-01
      2593   372_2409874 2012          S 2.200000e+01  5.000000e-01 6.116069e-01
      2594   372_2409874 2012          N 1.180000e+02 -4.300000e+00 7.881104e-01
      2595   372_2409874 2012       maxN 2.400000e+01 -3.600000e+00 6.085903e-02
      2596   372_2409874 2012    Shannon 2.623899e+00  3.747280e-02 3.704172e-01
      2597   372_2409874 2012    Simpson 9.018960e-01  7.301003e-03 4.272536e-01
      2598   372_2409874 2012 invSimpson 1.019327e+01  6.587781e-01 3.530710e-01
      2599   372_2409874 2012        PIE 9.096045e-01  7.639047e-03 3.893960e-01
      2600   372_2409874 2012      DomMc 3.474576e-01 -2.515217e-02 3.398299e-01
      2601   372_2409874 2012 expShannon 1.378939e+01  5.077468e-01 3.599762e-01
      2602   372_2452208 2008          S 3.500000e+01  8.000000e-01 4.335516e-01
      2603   372_2452208 2008          N 2.870000e+02  2.750000e+01 2.453139e-01
      2604   372_2452208 2008       maxN 3.700000e+01  9.000000e-01 7.597717e-01
      2605   372_2452208 2008    Shannon 3.027920e+00  2.652950e-02 2.719957e-02
      2606   372_2452208 2008    Simpson 9.317826e-01  3.019152e-03 3.369953e-02
      2607   372_2452208 2008 invSimpson 1.465901e+01  7.581708e-01 3.372733e-02
      2608   372_2452208 2008        PIE 9.350406e-01  2.820843e-03 4.006845e-02
      2609   372_2452208 2008      DomMc 2.578397e-01 -1.330377e-02 2.100856e-01
      2610   372_2452208 2008 expShannon 2.065424e+01  5.804218e-01 2.793363e-02
      2611   372_2452208 2009          S 4.200000e+01  8.000000e-01 4.335516e-01
      2612   372_2452208 2009          N 4.030000e+02  2.750000e+01 2.453139e-01
      2613   372_2452208 2009       maxN 5.800000e+01  9.000000e-01 7.597717e-01
      2614   372_2452208 2009    Shannon 3.072629e+00  2.652950e-02 2.719957e-02
      2615   372_2452208 2009    Simpson 9.311922e-01  3.019152e-03 3.369953e-02
      2616   372_2452208 2009 invSimpson 1.453324e+01  7.581708e-01 3.372733e-02
      2617   372_2452208 2009        PIE 9.335086e-01  2.820843e-03 4.006845e-02
      2618   372_2452208 2009      DomMc 2.704715e-01 -1.330377e-02 2.100856e-01
      2619   372_2452208 2009 expShannon 2.159862e+01  5.804218e-01 2.793363e-02
      2620   372_2452208 2010          S 3.900000e+01  8.000000e-01 4.335516e-01
      2621   372_2452208 2010          N 2.960000e+02  2.750000e+01 2.453139e-01
      2622   372_2452208 2010       maxN 4.500000e+01  9.000000e-01 7.597717e-01
      2623   372_2452208 2010    Shannon 3.092861e+00  2.652950e-02 2.719957e-02
      2624   372_2452208 2010    Simpson 9.324096e-01  3.019152e-03 3.369953e-02
      2625   372_2452208 2010 invSimpson 1.479500e+01  7.581708e-01 3.372733e-02
      2626   372_2452208 2010        PIE 9.355703e-01  2.820843e-03 4.006845e-02
      2627   372_2452208 2010      DomMc 2.837838e-01 -1.330377e-02 2.100856e-01
      2628   372_2452208 2010 expShannon 2.204003e+01  5.804218e-01 2.793363e-02
      2629   372_2452208 2011          S 3.800000e+01  8.000000e-01 4.335516e-01
      2630   372_2452208 2011          N 3.620000e+02  2.750000e+01 2.453139e-01
      2631   372_2452208 2011       maxN 4.700000e+01  9.000000e-01 7.597717e-01
      2632   372_2452208 2011    Shannon 3.144868e+00  2.652950e-02 2.719957e-02
      2633   372_2452208 2011    Simpson 9.400354e-01  3.019152e-03 3.369953e-02
      2634   372_2452208 2011 invSimpson 1.667651e+01  7.581708e-01 3.372733e-02
      2635   372_2452208 2011        PIE 9.426394e-01  2.820843e-03 4.006845e-02
      2636   372_2452208 2011      DomMc 2.486188e-01 -1.330377e-02 2.100856e-01
      2637   372_2452208 2011 expShannon 2.321661e+01  5.804218e-01 2.793363e-02
      2638   372_2452208 2012          S 4.100000e+01  8.000000e-01 4.335516e-01
      2639   372_2452208 2012          N 4.450000e+02  2.750000e+01 2.453139e-01
      2640   372_2452208 2012       maxN 4.700000e+01  9.000000e-01 7.597717e-01
      2641   372_2452208 2012    Shannon 3.124449e+00  2.652950e-02 2.719957e-02
      2642   372_2452208 2012    Simpson 9.424568e-01  3.019152e-03 3.369953e-02
      2643   372_2452208 2012 invSimpson 1.737824e+01  7.581708e-01 3.372733e-02
      2644   372_2452208 2012        PIE 9.445794e-01  2.820843e-03 4.006845e-02
      2645   372_2452208 2012      DomMc 2.022472e-01 -1.330377e-02 2.100856e-01
      2646   372_2452208 2012 expShannon 2.274735e+01  5.804218e-01 2.793363e-02
      2647   372_2379269 2009          S 3.300000e+01 -9.000000e-01 8.327299e-01
      2648   372_2379269 2009          N 5.070000e+02  1.860000e+01 8.664033e-01
      2649   372_2379269 2009       maxN 1.120000e+02  6.700000e+00 7.643167e-01
      2650   372_2379269 2009    Shannon 2.607770e+00 -2.895195e-02 6.730491e-01
      2651   372_2379269 2009    Simpson 8.797467e-01 -3.683081e-04 9.564322e-01
      2652   372_2379269 2009 invSimpson 8.315778e+00 -1.806184e-03 9.964726e-01
      2653   372_2379269 2009        PIE 8.814853e-01 -5.602373e-04 9.303502e-01
      2654   372_2379269 2009      DomMc 4.319527e-01 -1.420183e-02 2.821668e-01
      2655   372_2379269 2009 expShannon 1.356876e+01 -3.750794e-01 6.472994e-01
      2656   372_2379269 2010          S 1.800000e+01 -9.000000e-01 8.327299e-01
      2657   372_2379269 2010          N 1.790000e+02  1.860000e+01 8.664033e-01
      2658   372_2379269 2010       maxN 4.100000e+01  6.700000e+00 7.643167e-01
      2659   372_2379269 2010    Shannon 2.371466e+00 -2.895195e-02 6.730491e-01
      2660   372_2379269 2010    Simpson 8.766268e-01 -3.683081e-04 9.564322e-01
      2661   372_2379269 2010 invSimpson 8.105490e+00 -1.806184e-03 9.964726e-01
      2662   372_2379269 2010        PIE 8.815517e-01 -5.602373e-04 9.303502e-01
      2663   372_2379269 2010      DomMc 4.022346e-01 -1.420183e-02 2.821668e-01
      2664   372_2379269 2010 expShannon 1.071308e+01 -3.750794e-01 6.472994e-01
      2665   372_2379269 2011          S 2.100000e+01 -9.000000e-01 8.327299e-01
      2666   372_2379269 2011          N 2.600000e+02  1.860000e+01 8.664033e-01
      2667   372_2379269 2011       maxN 7.800000e+01  6.700000e+00 7.643167e-01
      2668   372_2379269 2011    Shannon 2.375252e+00 -2.895195e-02 6.730491e-01
      2669   372_2379269 2011    Simpson 8.593195e-01 -3.683081e-04 9.564322e-01
      2670   372_2379269 2011 invSimpson 7.108307e+00 -1.806184e-03 9.964726e-01
      2671   372_2379269 2011        PIE 8.626374e-01 -5.602373e-04 9.303502e-01
      2672   372_2379269 2011      DomMc 4.269231e-01 -1.420183e-02 2.821668e-01
      2673   372_2379269 2011 expShannon 1.075372e+01 -3.750794e-01 6.472994e-01
      2674   372_2379269 2012          S 2.900000e+01 -9.000000e-01 8.327299e-01
      2675   372_2379269 2012          N 5.420000e+02  1.860000e+01 8.664033e-01
      2676   372_2379269 2012       maxN 1.220000e+02  6.700000e+00 7.643167e-01
      2677   372_2379269 2012    Shannon 2.510001e+00 -2.895195e-02 6.730491e-01
      2678   372_2379269 2012    Simpson 8.842881e-01 -3.683081e-04 9.564322e-01
      2679   372_2379269 2012 invSimpson 8.642151e+00 -1.806184e-03 9.964726e-01
      2680   372_2379269 2012        PIE 8.859226e-01 -5.602373e-04 9.303502e-01
      2681   372_2379269 2012      DomMc 3.763838e-01 -1.420183e-02 2.821668e-01
      2682   372_2379269 2012 expShannon 1.230495e+01 -3.750794e-01 6.472994e-01
      2683   372_2441280 2009          S 4.300000e+01 -2.300000e+00 1.275603e-01
      2684   372_2441280 2009          N 5.070000e+02  1.280000e+01 8.450459e-01
      2685   372_2441280 2009       maxN 7.900000e+01 -2.100000e+00 8.450807e-01
      2686   372_2441280 2009    Shannon 3.001768e+00 -1.895964e-02 7.719892e-01
      2687   372_2441280 2009    Simpson 9.252399e-01  7.329555e-04 8.948089e-01
      2688   372_2441280 2009 invSimpson 1.337613e+01  3.620713e-02 9.796388e-01
      2689   372_2441280 2009        PIE 9.270685e-01  6.678279e-04 9.081425e-01
      2690   372_2441280 2009      DomMc 2.682446e-01 -8.589279e-03 4.163934e-01
      2691   372_2441280 2009 expShannon 2.012108e+01 -4.274639e-01 7.705496e-01
      2692   372_2441280 2010          S 4.000000e+01 -2.300000e+00 1.275603e-01
      2693   372_2441280 2010          N 3.440000e+02  1.280000e+01 8.450459e-01
      2694   372_2441280 2010       maxN 4.200000e+01 -2.100000e+00 8.450807e-01
      2695   372_2441280 2010    Shannon 3.221617e+00 -1.895964e-02 7.719892e-01
      2696   372_2441280 2010    Simpson 9.466266e-01  7.329555e-04 8.948089e-01
      2697   372_2441280 2010 invSimpson 1.873591e+01  3.620713e-02 9.796388e-01
      2698   372_2441280 2010        PIE 9.493864e-01  6.678279e-04 9.081425e-01
      2699   372_2441280 2010      DomMc 2.238372e-01 -8.589279e-03 4.163934e-01
      2700   372_2441280 2010 expShannon 2.506862e+01 -4.274639e-01 7.705496e-01
      2701   372_2441280 2011          S 4.100000e+01 -2.300000e+00 1.275603e-01
      2702   372_2441280 2011          N 6.010000e+02  1.280000e+01 8.450459e-01
      2703   372_2441280 2011       maxN 7.800000e+01 -2.100000e+00 8.450807e-01
      2704   372_2441280 2011    Shannon 3.076486e+00 -1.895964e-02 7.719892e-01
      2705   372_2441280 2011    Simpson 9.353462e-01  7.329555e-04 8.948089e-01
      2706   372_2441280 2011 invSimpson 1.546701e+01  3.620713e-02 9.796388e-01
      2707   372_2441280 2011        PIE 9.369052e-01  6.678279e-04 9.081425e-01
      2708   372_2441280 2011      DomMc 2.379368e-01 -8.589279e-03 4.163934e-01
      2709   372_2441280 2011 expShannon 2.168208e+01 -4.274639e-01 7.705496e-01
      2710   372_2441280 2012          S 3.500000e+01 -2.300000e+00 1.275603e-01
      2711   372_2441280 2012          N 4.640000e+02  1.280000e+01 8.450459e-01
      2712   372_2441280 2012       maxN 6.000000e+01 -2.100000e+00 8.450807e-01
      2713   372_2441280 2012    Shannon 2.986946e+00 -1.895964e-02 7.719892e-01
      2714   372_2441280 2012    Simpson 9.314432e-01  7.329555e-04 8.948089e-01
      2715   372_2441280 2012 invSimpson 1.458645e+01  3.620713e-02 9.796388e-01
      2716   372_2441280 2012        PIE 9.334550e-01  6.678279e-04 9.081425e-01
      2717   372_2441280 2012      DomMc 2.349138e-01 -8.589279e-03 4.163934e-01
      2718   372_2441280 2012 expShannon 1.982505e+01 -4.274639e-01 7.705496e-01
      2719   372_2442005 2009          S 3.600000e+01 -2.100000e+00 2.818152e-01
      2720   372_2442005 2009          N 3.310000e+02  2.830000e+01 8.594708e-01
      2721   372_2442005 2009       maxN 3.800000e+01  4.970000e+01 7.246685e-01
      2722   372_2442005 2009    Shannon 3.024720e+00 -2.172271e-01 5.848808e-01
      2723   372_2442005 2009    Simpson 9.348582e-01 -4.505327e-02 6.965386e-01
      2724   372_2442005 2009 invSimpson 1.535113e+01 -2.384237e+00 4.974367e-01
      2725   372_2442005 2009        PIE 9.376911e-01 -4.519697e-02 6.982182e-01
      2726   372_2442005 2009      DomMc 2.145015e-01  7.284034e-02 6.065619e-01
      2727   372_2442005 2009 expShannon 2.058825e+01 -2.912252e+00 4.818092e-01
      2728   372_2442005 2010          S 3.300000e+01 -2.100000e+00 2.818152e-01
      2729   372_2442005 2010          N 1.710000e+02  2.830000e+01 8.594708e-01
      2730   372_2442005 2010       maxN 2.100000e+01  4.970000e+01 7.246685e-01
      2731   372_2442005 2010    Shannon 2.997311e+00 -2.172271e-01 5.848808e-01
      2732   372_2442005 2010    Simpson 9.331418e-01 -4.505327e-02 6.965386e-01
      2733   372_2442005 2010 invSimpson 1.495703e+01 -2.384237e+00 4.974367e-01
      2734   372_2442005 2010        PIE 9.386309e-01 -4.519697e-02 6.982182e-01
      2735   372_2442005 2010      DomMc 2.397661e-01  7.284034e-02 6.065619e-01
      2736   372_2442005 2010 expShannon 2.003161e+01 -2.912252e+00 4.818092e-01
      2737   372_2442005 2011          S 3.600000e+01 -2.100000e+00 2.818152e-01
      2738   372_2442005 2011          N 7.480000e+02  2.830000e+01 8.594708e-01
      2739   372_2442005 2011       maxN 5.000000e+02  4.970000e+01 7.246685e-01
      2740   372_2442005 2011    Shannon 1.598456e+00 -2.172271e-01 5.848808e-01
      2741   372_2442005 2011    Simpson 5.445287e-01 -4.505327e-02 6.965386e-01
      2742   372_2442005 2011 invSimpson 2.195528e+00 -2.384237e+00 4.974367e-01
      2743   372_2442005 2011        PIE 5.452577e-01 -4.519697e-02 6.982182e-01
      2744   372_2442005 2011      DomMc 7.232620e-01  7.284034e-02 6.065619e-01
      2745   372_2442005 2011 expShannon 4.945392e+00 -2.912252e+00 4.818092e-01
      2746   372_2442005 2012          S 2.800000e+01 -2.100000e+00 2.818152e-01
      2747   372_2442005 2012          N 2.330000e+02  2.830000e+01 8.594708e-01
      2748   372_2442005 2012       maxN 4.400000e+01  4.970000e+01 7.246685e-01
      2749   372_2442005 2012    Shannon 2.766915e+00 -2.172271e-01 5.848808e-01
      2750   372_2442005 2012    Simpson 9.142183e-01 -4.505327e-02 6.965386e-01
      2751   372_2442005 2012 invSimpson 1.165750e+01 -2.384237e+00 4.974367e-01
      2752   372_2442005 2012        PIE 9.181589e-01 -4.519697e-02 6.982182e-01
      2753   372_2442005 2012      DomMc 2.961373e-01  7.284034e-02 6.065619e-01
      2754   372_2442005 2012 expShannon 1.590948e+01 -2.912252e+00 4.818092e-01
      2755   372_2439790 2008          S 1.700000e+01  1.200000e+00 5.192850e-02
      2756   372_2439790 2008          N 1.660000e+02 -2.100000e+00 5.285172e-01
      2757   372_2439790 2008       maxN 3.600000e+01 -1.400000e+00 2.822500e-01
      2758   372_2439790 2008    Shannon 2.382919e+00  3.056173e-02 3.479912e-01
      2759   372_2439790 2008    Simpson 8.753085e-01  2.744190e-03 4.922852e-01
      2760   372_2439790 2008 invSimpson 8.019790e+00  2.007596e-01 5.566476e-01
      2761   372_2439790 2008        PIE 8.806134e-01  2.841987e-03 4.835239e-01
      2762   372_2439790 2008      DomMc 4.216867e-01 -1.008482e-02 5.162581e-01
      2763   372_2439790 2008 expShannon 1.083649e+01  3.656139e-01 3.507494e-01
      2764   372_2439790 2011          S 2.000000e+01  1.200000e+00 5.192850e-02
      2765   372_2439790 2011          N 1.700000e+02 -2.100000e+00 5.285172e-01
      2766   372_2439790 2011       maxN 3.300000e+01 -1.400000e+00 2.822500e-01
      2767   372_2439790 2011    Shannon 2.407796e+00  3.056173e-02 3.479912e-01
      2768   372_2439790 2011    Simpson 8.829758e-01  2.744190e-03 4.922852e-01
      2769   372_2439790 2011 invSimpson 8.545240e+00  2.007596e-01 5.566476e-01
      2770   372_2439790 2011        PIE 8.882005e-01  2.841987e-03 4.835239e-01
      2771   372_2439790 2011      DomMc 3.470588e-01 -1.008482e-02 5.162581e-01
      2772   372_2439790 2011 expShannon 1.110945e+01  3.656139e-01 3.507494e-01
      2773   372_2439790 2009          S 2.000000e+01  1.200000e+00 5.192850e-02
      2774   372_2439790 2009          N 1.550000e+02 -2.100000e+00 5.285172e-01
      2775   372_2439790 2009       maxN 3.100000e+01 -1.400000e+00 2.822500e-01
      2776   372_2439790 2009    Shannon 2.464395e+00  3.056173e-02 3.479912e-01
      2777   372_2439790 2009    Simpson 8.863267e-01  2.744190e-03 4.922852e-01
      2778   372_2439790 2009 invSimpson 8.797144e+00  2.007596e-01 5.566476e-01
      2779   372_2439790 2009        PIE 8.920821e-01  2.841987e-03 4.835239e-01
      2780   372_2439790 2009      DomMc 3.612903e-01 -1.008482e-02 5.162581e-01
      2781   372_2439790 2009 expShannon 1.175636e+01  3.656139e-01 3.507494e-01
      2782   372_2439790 2012          S 2.300000e+01  1.200000e+00 5.192850e-02
      2783   372_2439790 2012          N 1.480000e+02 -2.100000e+00 5.285172e-01
      2784   372_2439790 2012       maxN 2.800000e+01 -1.400000e+00 2.822500e-01
      2785   372_2439790 2012    Shannon 2.564027e+00  3.056173e-02 3.479912e-01
      2786   372_2439790 2012    Simpson 8.907049e-01  2.744190e-03 4.922852e-01
      2787   372_2439790 2012 invSimpson 9.149541e+00  2.007596e-01 5.566476e-01
      2788   372_2439790 2012        PIE 8.967641e-01  2.841987e-03 4.835239e-01
      2789   372_2439790 2012      DomMc 3.783784e-01 -1.008482e-02 5.162581e-01
      2790   372_2439790 2012 expShannon 1.298802e+01  3.656139e-01 3.507494e-01
      2791   372_2439790 2010          S 2.100000e+01  1.200000e+00 5.192850e-02
      2792   372_2439790 2010          N 1.610000e+02 -2.100000e+00 5.285172e-01
      2793   372_2439790 2010       maxN 2.700000e+01 -1.400000e+00 2.822500e-01
      2794   372_2439790 2010    Shannon 2.580710e+00  3.056173e-02 3.479912e-01
      2795   372_2439790 2010    Simpson 9.038232e-01  2.744190e-03 4.922852e-01
      2796   372_2439790 2010 invSimpson 1.039751e+01  2.007596e-01 5.566476e-01
      2797   372_2439790 2010        PIE 9.094720e-01  2.841987e-03 4.835239e-01
      2798   372_2439790 2010      DomMc 3.105590e-01 -1.008482e-02 5.162581e-01
      2799   372_2439790 2010 expShannon 1.320651e+01  3.656139e-01 3.507494e-01
      2800   372_2437599 2010          S 1.800000e+01  2.200000e+00 3.595552e-01
      2801   372_2437599 2010          N 8.400000e+01  3.370000e+01 9.899167e-02
      2802   372_2437599 2010       maxN 2.200000e+01  5.800000e+00 5.911576e-02
      2803   372_2437599 2010    Shannon 2.455284e+00  1.085208e-01 3.826926e-01
      2804   372_2437599 2010    Simpson 8.786848e-01  1.187692e-02 3.772910e-01
      2805   372_2437599 2010 invSimpson 8.242991e+00  1.258671e+00 4.678879e-01
      2806   372_2437599 2010        PIE 8.892714e-01  9.615800e-03 4.344195e-01
      2807   372_2437599 2010      DomMc 4.047619e-01 -3.518442e-02 3.788804e-01
      2808   372_2437599 2010 expShannon 1.164974e+01  1.556190e+00 4.175025e-01
      2809   372_2437599 2012          S 2.400000e+01  2.200000e+00 3.595552e-01
      2810   372_2437599 2012          N 1.630000e+02  3.370000e+01 9.899167e-02
      2811   372_2437599 2012       maxN 3.500000e+01  5.800000e+00 5.911576e-02
      2812   372_2437599 2012    Shannon 2.708863e+00  1.085208e-01 3.826926e-01
      2813   372_2437599 2012    Simpson 9.057925e-01  1.187692e-02 3.772910e-01
      2814   372_2437599 2012 invSimpson 1.061486e+01  1.258671e+00 4.678879e-01
      2815   372_2437599 2012        PIE 9.113838e-01  9.615800e-03 4.344195e-01
      2816   372_2437599 2012      DomMc 3.435583e-01 -3.518442e-02 3.788804e-01
      2817   372_2437599 2012 expShannon 1.501220e+01  1.556190e+00 4.175025e-01
      2818   372_2437599 2009          S 2.000000e+01  2.200000e+00 3.595552e-01
      2819   372_2437599 2009          N 7.800000e+01  3.370000e+01 9.899167e-02
      2820   372_2437599 2009       maxN 1.600000e+01  5.800000e+00 5.911576e-02
      2821   372_2437599 2009    Shannon 2.514907e+00  1.085208e-01 3.826926e-01
      2822   372_2437599 2009    Simpson 8.842867e-01  1.187692e-02 3.772910e-01
      2823   372_2437599 2009 invSimpson 8.642045e+00  1.258671e+00 4.678879e-01
      2824   372_2437599 2009        PIE 8.957709e-01  9.615800e-03 4.344195e-01
      2825   372_2437599 2009      DomMc 4.102564e-01 -3.518442e-02 3.788804e-01
      2826   372_2437599 2009 expShannon 1.236546e+01  1.556190e+00 4.175025e-01
      2827   372_2437599 2011          S 2.800000e+01  2.200000e+00 3.595552e-01
      2828   372_2437599 2011          N 1.660000e+02  3.370000e+01 9.899167e-02
      2829   372_2437599 2011       maxN 2.300000e+01  5.800000e+00 5.911576e-02
      2830   372_2437599 2011    Shannon 2.958623e+00  1.085208e-01 3.826926e-01
      2831   372_2437599 2011    Simpson 9.329366e-01  1.187692e-02 3.772910e-01
      2832   372_2437599 2011 invSimpson 1.491126e+01  1.258671e+00 4.678879e-01
      2833   372_2437599 2011        PIE 9.385907e-01  9.615800e-03 4.344195e-01
      2834   372_2437599 2011      DomMc 2.530120e-01 -3.518442e-02 3.788804e-01
      2835   372_2437599 2011 expShannon 1.927142e+01  1.556190e+00 4.175025e-01
      2836   372_2433956 2009          S 2.900000e+01 -7.000000e+00 2.028719e-01
      2837   372_2433956 2009          N 1.890000e+02 -6.750000e+01 3.535755e-02
      2838   372_2433956 2009       maxN 3.000000e+01 -7.500000e+00 4.019821e-01
      2839   372_2433956 2009    Shannon 2.781274e+00 -3.012260e-01 3.292032e-01
      2840   372_2433956 2009    Simpson 9.102769e-01 -3.401361e-02 4.201162e-01
      2841   372_2433956 2009 invSimpson 1.114540e+01 -2.403134e+00 3.812696e-01
      2842   372_2433956 2009        PIE 9.151188e-01 -2.848880e-02 4.964465e-01
      2843   372_2433956 2009      DomMc 3.174603e-01  8.201058e-02 4.946059e-01
      2844   372_2433956 2009 expShannon 1.613957e+01 -3.651840e+00 3.303194e-01
      2845   372_2433956 2011          S 1.500000e+01 -7.000000e+00 2.028719e-01
      2846   372_2433956 2011          N 5.400000e+01 -6.750000e+01 3.535755e-02
      2847   372_2433956 2011       maxN 1.500000e+01 -7.500000e+00 4.019821e-01
      2848   372_2433956 2011    Shannon 2.178822e+00 -3.012260e-01 3.292032e-01
      2849   372_2433956 2011    Simpson 8.422497e-01 -3.401361e-02 4.201162e-01
      2850   372_2433956 2011 invSimpson 6.339130e+00 -2.403134e+00 3.812696e-01
      2851   372_2433956 2011        PIE 8.581412e-01 -2.848880e-02 4.964465e-01
      2852   372_2433956 2011      DomMc 4.814815e-01  8.201058e-02 4.946059e-01
      2853   372_2433956 2011 expShannon 8.835892e+00 -3.651840e+00 3.303194e-01
      2854   372_2433956 2010          S 1.800000e+01 -7.000000e+00 2.028719e-01
      2855   372_2433956 2010          N 1.150000e+02 -6.750000e+01 3.535755e-02
      2856   372_2433956 2010       maxN 3.200000e+01 -7.500000e+00 4.019821e-01
      2857   372_2433956 2010    Shannon 2.183318e+00 -3.012260e-01 3.292032e-01
      2858   372_2433956 2010    Simpson 8.305482e-01 -3.401361e-02 4.201162e-01
      2859   372_2433956 2010 invSimpson 5.901383e+00 -2.403134e+00 3.812696e-01
      2860   372_2433956 2010        PIE 8.378337e-01 -2.848880e-02 4.964465e-01
      2861   372_2433956 2010      DomMc 5.391304e-01  8.201058e-02 4.946059e-01
      2862   372_2433956 2010 expShannon 8.875710e+00 -3.651840e+00 3.303194e-01
      2863   372_2435398 2009          S 3.500000e+01 -8.000000e-01 5.038611e-01
      2864   372_2435398 2009          N 6.330000e+02 -8.090000e+01 2.203021e-01
      2865   372_2435398 2009       maxN 8.900000e+01  6.000000e+00 7.215170e-01
      2866   372_2435398 2009    Shannon 2.948688e+00 -7.879459e-02 3.364092e-01
      2867   372_2435398 2009    Simpson 9.267736e-01 -1.216000e-02 2.444094e-01
      2868   372_2435398 2009 invSimpson 1.365628e+01 -1.438223e+00 2.560649e-01
      2869   372_2435398 2009        PIE 9.282400e-01 -1.190239e-02 2.590047e-01
      2870   372_2435398 2009      DomMc 2.717220e-01  3.747360e-02 2.258874e-01
      2871   372_2435398 2009 expShannon 1.908090e+01 -1.289102e+00 3.571512e-01
      2872   372_2435398 2010          S 3.800000e+01 -8.000000e-01 5.038611e-01
      2873   372_2435398 2010          N 6.300000e+02 -8.090000e+01 2.203021e-01
      2874   372_2435398 2010       maxN 8.500000e+01  6.000000e+00 7.215170e-01
      2875   372_2435398 2010    Shannon 2.940501e+00 -7.879459e-02 3.364092e-01
      2876   372_2435398 2010    Simpson 9.263391e-01 -1.216000e-02 2.444094e-01
      2877   372_2435398 2010 invSimpson 1.357573e+01 -1.438223e+00 2.560649e-01
      2878   372_2435398 2010        PIE 9.278118e-01 -1.190239e-02 2.590047e-01
      2879   372_2435398 2010      DomMc 2.634921e-01  3.747360e-02 2.258874e-01
      2880   372_2435398 2010 expShannon 1.892532e+01 -1.289102e+00 3.571512e-01
      2881   372_2435398 2011          S 3.600000e+01 -8.000000e-01 5.038611e-01
      2882   372_2435398 2011          N 3.640000e+02 -8.090000e+01 2.203021e-01
      2883   372_2435398 2011       maxN 5.200000e+01  6.000000e+00 7.215170e-01
      2884   372_2435398 2011    Shannon 3.006163e+00 -7.879459e-02 3.364092e-01
      2885   372_2435398 2011    Simpson 9.282544e-01 -1.216000e-02 2.444094e-01
      2886   372_2435398 2011 invSimpson 1.393814e+01 -1.438223e+00 2.560649e-01
      2887   372_2435398 2011        PIE 9.308116e-01 -1.190239e-02 2.590047e-01
      2888   372_2435398 2011      DomMc 2.719780e-01  3.747360e-02 2.258874e-01
      2889   372_2435398 2011 expShannon 2.020970e+01 -1.289102e+00 3.571512e-01
      2890   372_2435398 2012          S 3.300000e+01 -8.000000e-01 5.038611e-01
      2891   372_2435398 2012          N 4.520000e+02 -8.090000e+01 2.203021e-01
      2892   372_2435398 2012       maxN 1.200000e+02  6.000000e+00 7.215170e-01
      2893   372_2435398 2012    Shannon 2.664152e+00 -7.879459e-02 3.364092e-01
      2894   372_2435398 2012    Simpson 8.856018e-01 -1.216000e-02 2.444094e-01
      2895   372_2435398 2012 invSimpson 8.741400e+00 -1.438223e+00 2.560649e-01
      2896   372_2435398 2012        PIE 8.875655e-01 -1.190239e-02 2.590047e-01
      2897   372_2435398 2012      DomMc 3.938053e-01  3.747360e-02 2.258874e-01
      2898   372_2435398 2012 expShannon 1.435577e+01 -1.289102e+00 3.571512e-01
      2899   372_2425178 2008          S 2.700000e+01 -1.800000e+00 7.040665e-02
      2900   372_2425178 2008          N 1.710000e+02 -2.460000e+01 6.149457e-02
      2901   372_2425178 2008       maxN 2.600000e+01 -9.000000e+00 4.694546e-01
      2902   372_2425178 2008    Shannon 2.853360e+00 -2.876845e-03 9.766173e-01
      2903   372_2425178 2008    Simpson 9.240450e-01  1.047994e-02 6.921754e-01
      2904   372_2425178 2008 invSimpson 1.316569e+01  8.315619e-02 9.503580e-01
      2905   372_2425178 2008        PIE 9.294806e-01  1.174541e-02 6.633414e-01
      2906   372_2425178 2008      DomMc 2.807018e-01 -1.335033e-02 7.476839e-01
      2907   372_2425178 2008 expShannon 1.734596e+01 -2.236685e-01 8.540140e-01
      2908   372_2425178 2009          S 2.600000e+01 -1.800000e+00 7.040665e-02
      2909   372_2425178 2009          N 2.070000e+02 -2.460000e+01 6.149457e-02
      2910   372_2425178 2009       maxN 9.700000e+01 -9.000000e+00 4.694546e-01
      2911   372_2425178 2009    Shannon 2.193897e+00 -2.876845e-03 9.766173e-01
      2912   372_2425178 2009    Simpson 7.592709e-01  1.047994e-02 6.921754e-01
      2913   372_2425178 2009 invSimpson 4.154048e+00  8.315619e-02 9.503580e-01
      2914   372_2425178 2009        PIE 7.629567e-01  1.174541e-02 6.633414e-01
      2915   372_2425178 2009      DomMc 5.507246e-01 -1.335033e-02 7.476839e-01
      2916   372_2425178 2009 expShannon 8.970101e+00 -2.236685e-01 8.540140e-01
      2917   372_2425178 2011          S 2.400000e+01 -1.800000e+00 7.040665e-02
      2918   372_2425178 2011          N 1.090000e+02 -2.460000e+01 6.149457e-02
      2919   372_2425178 2011       maxN 2.700000e+01 -9.000000e+00 4.694546e-01
      2920   372_2425178 2011    Shannon 2.696494e+00 -2.876845e-03 9.766173e-01
      2921   372_2425178 2011    Simpson 8.985776e-01  1.047994e-02 6.921754e-01
      2922   372_2425178 2011 invSimpson 9.859751e+00  8.315619e-02 9.503580e-01
      2923   372_2425178 2011        PIE 9.068977e-01  1.174541e-02 6.633414e-01
      2924   372_2425178 2011      DomMc 3.394495e-01 -1.335033e-02 7.476839e-01
      2925   372_2425178 2011 expShannon 1.482766e+01 -2.236685e-01 8.540140e-01
      2926   372_2425178 2010          S 2.100000e+01 -1.800000e+00 7.040665e-02
      2927   372_2425178 2010          N 1.370000e+02 -2.460000e+01 6.149457e-02
      2928   372_2425178 2010       maxN 2.600000e+01 -9.000000e+00 4.694546e-01
      2929   372_2425178 2010    Shannon 2.682659e+00 -2.876845e-03 9.766173e-01
      2930   372_2425178 2010    Simpson 9.089456e-01  1.047994e-02 6.921754e-01
      2931   372_2425178 2010 invSimpson 1.098245e+01  8.315619e-02 9.503580e-01
      2932   372_2425178 2010        PIE 9.156290e-01  1.174541e-02 6.633414e-01
      2933   372_2425178 2010      DomMc 3.430657e-01 -1.335033e-02 7.476839e-01
      2934   372_2425178 2010 expShannon 1.462393e+01 -2.236685e-01 8.540140e-01
      2935   372_2425178 2012          S 1.900000e+01 -1.800000e+00 7.040665e-02
      2936   372_2425178 2012          N 9.700000e+01 -2.460000e+01 6.149457e-02
      2937   372_2425178 2012       maxN 1.600000e+01 -9.000000e+00 4.694546e-01
      2938   372_2425178 2012    Shannon 2.587677e+00 -2.876845e-03 9.766173e-01
      2939   372_2425178 2012    Simpson 9.067914e-01  1.047994e-02 6.921754e-01
      2940   372_2425178 2012 invSimpson 1.072862e+01  8.315619e-02 9.503580e-01
      2941   372_2425178 2012        PIE 9.162371e-01  1.174541e-02 6.633414e-01
      2942   372_2425178 2012      DomMc 3.195876e-01 -1.335033e-02 7.476839e-01
      2943   372_2425178 2012 expShannon 1.329884e+01 -2.236685e-01 8.540140e-01
      2944   372_2426634 2009          S 3.500000e+01 -5.000000e-01 4.870108e-01
      2945   372_2426634 2009          N 2.660000e+03 -2.989000e+02 4.061539e-01
      2946   372_2426634 2009       maxN 8.320000e+02 -1.831000e+02 3.851915e-01
      2947   372_2426634 2009    Shannon 2.029932e+00  1.620149e-01 1.913495e-01
      2948   372_2426634 2009    Simpson 7.896422e-01  2.923217e-02 2.549764e-01
      2949   372_2426634 2009 invSimpson 4.753804e+00  1.243995e+00 2.407872e-01
      2950   372_2426634 2009        PIE 7.899391e-01  2.928392e-02 2.548184e-01
      2951   372_2426634 2009      DomMc 6.109023e-01 -7.036986e-02 2.690297e-01
      2952   372_2426634 2009 expShannon 7.613568e+00  1.624963e+00 1.991261e-01
      2953   372_2426634 2010          S 3.500000e+01 -5.000000e-01 4.870108e-01
      2954   372_2426634 2010          N 3.576000e+03 -2.989000e+02 4.061539e-01
      2955   372_2426634 2010       maxN 1.334000e+03 -1.831000e+02 3.851915e-01
      2956   372_2426634 2010    Shannon 2.044852e+00  1.620149e-01 1.913495e-01
      2957   372_2426634 2010    Simpson 7.863244e-01  2.923217e-02 2.549764e-01
      2958   372_2426634 2010 invSimpson 4.679991e+00  1.243995e+00 2.407872e-01
      2959   372_2426634 2010        PIE 7.865443e-01  2.928392e-02 2.548184e-01
      2960   372_2426634 2010      DomMc 5.998322e-01 -7.036986e-02 2.690297e-01
      2961   372_2426634 2010 expShannon 7.728016e+00  1.624963e+00 1.991261e-01
      2962   372_2426634 2011          S 3.600000e+01 -5.000000e-01 4.870108e-01
      2963   372_2426634 2011          N 2.465000e+03 -2.989000e+02 4.061539e-01
      2964   372_2426634 2011       maxN 8.170000e+02 -1.831000e+02 3.851915e-01
      2965   372_2426634 2011    Shannon 2.065263e+00  1.620149e-01 1.913495e-01
      2966   372_2426634 2011    Simpson 7.839993e-01  2.923217e-02 2.549764e-01
      2967   372_2426634 2011 invSimpson 4.629614e+00  1.243995e+00 2.407872e-01
      2968   372_2426634 2011        PIE 7.843175e-01  2.928392e-02 2.548184e-01
      2969   372_2426634 2011      DomMc 6.300203e-01 -7.036986e-02 2.690297e-01
      2970   372_2426634 2011 expShannon 7.887371e+00  1.624963e+00 1.991261e-01
      2971   372_2426634 2012          S 3.300000e+01 -5.000000e-01 4.870108e-01
      2972   372_2426634 2012          N 2.034000e+03 -2.989000e+02 4.061539e-01
      2973   372_2426634 2012       maxN 3.940000e+02 -1.831000e+02 3.851915e-01
      2974   372_2426634 2012    Shannon 2.563178e+00  1.620149e-01 1.913495e-01
      2975   372_2426634 2012    Simpson 8.878577e-01  2.923217e-02 2.549764e-01
      2976   372_2426634 2012 invSimpson 8.917245e+00  1.243995e+00 2.407872e-01
      2977   372_2426634 2012        PIE 8.882945e-01  2.928392e-02 2.548184e-01
      2978   372_2426634 2012      DomMc 3.662734e-01 -7.036986e-02 2.690297e-01
      2979   372_2426634 2012 expShannon 1.297699e+01  1.624963e+00 1.991261e-01
      2980   372_2427362 2009          S 2.100000e+01  1.000000e+00 2.546440e-01
      2981   372_2427362 2009          N 3.440000e+02  1.380000e+01 7.532644e-01
      2982   372_2427362 2009       maxN 6.900000e+01  1.020000e+01 3.151122e-01
      2983   372_2427362 2009    Shannon 2.509204e+00 -1.004343e-02 6.877778e-01
      2984   372_2427362 2009    Simpson 8.943179e-01 -5.995253e-03 5.910197e-03
      2985   372_2427362 2009 invSimpson 9.462338e+00 -4.592448e-01 1.904509e-03
      2986   372_2427362 2009        PIE 8.969252e-01 -6.104679e-03 2.171927e-03
      2987   372_2427362 2009      DomMc 3.430233e-01  2.546476e-02 2.835124e-02
      2988   372_2427362 2009 expShannon 1.229513e+01 -1.195240e-01 6.999502e-01
      2989   372_2427362 2010          S 2.400000e+01  1.000000e+00 2.546440e-01
      2990   372_2427362 2010          N 4.930000e+02  1.380000e+01 7.532644e-01
      2991   372_2427362 2010       maxN 1.000000e+02  1.020000e+01 3.151122e-01
      2992   372_2427362 2010    Shannon 2.544580e+00 -1.004343e-02 6.877778e-01
      2993   372_2427362 2010    Simpson 8.895819e-01 -5.995253e-03 5.910197e-03
      2994   372_2427362 2010 invSimpson 9.056489e+00 -4.592448e-01 1.904509e-03
      2995   372_2427362 2010        PIE 8.913900e-01 -6.104679e-03 2.171927e-03
      2996   372_2427362 2010      DomMc 3.772819e-01  2.546476e-02 2.835124e-02
      2997   372_2427362 2010 expShannon 1.273788e+01 -1.195240e-01 6.999502e-01
      2998   372_2427362 2011          S 2.500000e+01  1.000000e+00 2.546440e-01
      2999   372_2427362 2011          N 4.840000e+02  1.380000e+01 7.532644e-01
      3000   372_2427362 2011       maxN 1.150000e+02  1.020000e+01 3.151122e-01
      3001   372_2427362 2011    Shannon 2.563614e+00 -1.004343e-02 6.877778e-01
      3002   372_2427362 2011    Simpson 8.838706e-01 -5.995253e-03 5.910197e-03
      3003   372_2427362 2011 invSimpson 8.611087e+00 -4.592448e-01 1.904509e-03
      3004   372_2427362 2011        PIE 8.857006e-01 -6.104679e-03 2.171927e-03
      3005   372_2427362 2011      DomMc 4.090909e-01  2.546476e-02 2.835124e-02
      3006   372_2427362 2011 expShannon 1.298265e+01 -1.195240e-01 6.999502e-01
      3007   372_2427362 2012          S 2.400000e+01  1.000000e+00 2.546440e-01
      3008   372_2427362 2012          N 3.930000e+02  1.380000e+01 7.532644e-01
      3009   372_2427362 2012       maxN 9.800000e+01  1.020000e+01 3.151122e-01
      3010   372_2427362 2012    Shannon 2.469381e+00 -1.004343e-02 6.877778e-01
      3011   372_2427362 2012    Simpson 8.762375e-01 -5.995253e-03 5.910197e-03
      3012   372_2427362 2012 invSimpson 8.079990e+00 -4.592448e-01 1.904509e-03
      3013   372_2427362 2012        PIE 8.784728e-01 -6.104679e-03 2.171927e-03
      3014   372_2427362 2012      DomMc 4.173028e-01  2.546476e-02 2.835124e-02
      3015   372_2427362 2012 expShannon 1.181513e+01 -1.195240e-01 6.999502e-01
      3016   372_2428818 2008          S 2.500000e+01 -1.200000e+00 1.946807e-01
      3017   372_2428818 2008          N 2.720000e+02 -3.260000e+01 7.188844e-02
      3018   372_2428818 2008       maxN 6.000000e+01 -8.900000e+00 6.441661e-02
      3019   372_2428818 2008    Shannon 2.522854e+00  2.489283e-02 5.039084e-01
      3020   372_2428818 2008    Simpson 8.856510e-01  5.013122e-03 8.940080e-02
      3021   372_2428818 2008 invSimpson 8.745154e+00  4.301281e-01 8.792343e-02
      3022   372_2428818 2008        PIE 8.889190e-01  5.872104e-03 5.888445e-02
      3023   372_2428818 2008      DomMc 4.007353e-01 -2.215616e-02 7.387927e-03
      3024   372_2428818 2008 expShannon 1.246412e+01  3.001889e-01 5.017336e-01
      3025   372_2428818 2010          S 2.200000e+01 -1.200000e+00 1.946807e-01
      3026   372_2428818 2010          N 2.730000e+02 -3.260000e+01 7.188844e-02
      3027   372_2428818 2010       maxN 5.900000e+01 -8.900000e+00 6.441661e-02
      3028   372_2428818 2010    Shannon 2.524212e+00  2.489283e-02 5.039084e-01
      3029   372_2428818 2010    Simpson 8.895598e-01  5.013122e-03 8.940080e-02
      3030   372_2428818 2010 invSimpson 9.054671e+00  4.301281e-01 8.792343e-02
      3031   372_2428818 2010        PIE 8.928302e-01  5.872104e-03 5.888445e-02
      3032   372_2428818 2010      DomMc 3.772894e-01 -2.215616e-02 7.387927e-03
      3033   372_2428818 2010 expShannon 1.248106e+01  3.001889e-01 5.017336e-01
      3034   372_2428818 2009          S 1.900000e+01 -1.200000e+00 1.946807e-01
      3035   372_2428818 2009          N 2.370000e+02 -3.260000e+01 7.188844e-02
      3036   372_2428818 2009       maxN 5.000000e+01 -8.900000e+00 6.441661e-02
      3037   372_2428818 2009    Shannon 2.352394e+00  2.489283e-02 5.039084e-01
      3038   372_2428818 2009    Simpson 8.790614e-01  5.013122e-03 8.940080e-02
      3039   372_2428818 2009 invSimpson 8.268659e+00  4.301281e-01 8.792343e-02
      3040   372_2428818 2009        PIE 8.827862e-01  5.872104e-03 5.888445e-02
      3041   372_2428818 2009      DomMc 3.839662e-01 -2.215616e-02 7.387927e-03
      3042   372_2428818 2009 expShannon 1.051070e+01  3.001889e-01 5.017336e-01
      3043   372_2428818 2011          S 2.100000e+01 -1.200000e+00 1.946807e-01
      3044   372_2428818 2011          N 2.030000e+02 -3.260000e+01 7.188844e-02
      3045   372_2428818 2011       maxN 4.100000e+01 -8.900000e+00 6.441661e-02
      3046   372_2428818 2011    Shannon 2.625935e+00  2.489283e-02 5.039084e-01
      3047   372_2428818 2011    Simpson 9.028125e-01  5.013122e-03 8.940080e-02
      3048   372_2428818 2011 invSimpson 1.028939e+01  4.301281e-01 8.792343e-02
      3049   372_2428818 2011        PIE 9.072819e-01  5.872104e-03 5.888445e-02
      3050   372_2428818 2011      DomMc 3.448276e-01 -2.215616e-02 7.387927e-03
      3051   372_2428818 2011 expShannon 1.381748e+01  3.001889e-01 5.017336e-01
      3052   372_2428818 2012          S 1.800000e+01 -1.200000e+00 1.946807e-01
      3053   372_2428818 2012          N 1.260000e+02 -3.260000e+01 7.188844e-02
      3054   372_2428818 2012       maxN 2.000000e+01 -8.900000e+00 6.441661e-02
      3055   372_2428818 2012    Shannon 2.510548e+00  2.489283e-02 5.039084e-01
      3056   372_2428818 2012    Simpson 8.988410e-01  5.013122e-03 8.940080e-02
      3057   372_2428818 2012 invSimpson 9.885430e+00  4.301281e-01 8.792343e-02
      3058   372_2428818 2012        PIE 9.060317e-01  5.872104e-03 5.888445e-02
      3059   372_2428818 2012      DomMc 3.095238e-01 -2.215616e-02 7.387927e-03
      3060   372_2428818 2012 expShannon 1.231167e+01  3.001889e-01 5.017336e-01
      3061   372_2428817 2009          S 2.200000e+01  2.100000e+00 5.175918e-01
      3062   372_2428817 2009          N 2.680000e+02  1.150000e+01 8.321222e-01
      3063   372_2428817 2009       maxN 4.700000e+01  5.200000e+00 5.825952e-01
      3064   372_2428817 2009    Shannon 2.569442e+00  1.194029e-02 8.961647e-01
      3065   372_2428817 2009    Simpson 8.997271e-01 -1.827241e-03 8.455512e-01
      3066   372_2428817 2009 invSimpson 9.972785e+00 -2.132614e-01 7.499487e-01
      3067   372_2428817 2009        PIE 9.030969e-01 -2.537171e-03 7.237367e-01
      3068   372_2428817 2009      DomMc 3.395522e-01  8.899942e-03 7.482789e-01
      3069   372_2428817 2009 expShannon 1.305853e+01  1.346067e-01 8.986191e-01
      3070   372_2428817 2010          S 1.500000e+01  2.100000e+00 5.175918e-01
      3071   372_2428817 2010          N 7.700000e+01  1.150000e+01 8.321222e-01
      3072   372_2428817 2010       maxN 1.900000e+01  5.200000e+00 5.825952e-01
      3073   372_2428817 2010    Shannon 2.286984e+00  1.194029e-02 8.961647e-01
      3074   372_2428817 2010    Simpson 8.628774e-01 -1.827241e-03 8.455512e-01
      3075   372_2428817 2010 invSimpson 7.292743e+00 -2.132614e-01 7.499487e-01
      3076   372_2428817 2010        PIE 8.742310e-01 -2.537171e-03 7.237367e-01
      3077   372_2428817 2010      DomMc 4.415584e-01  8.899942e-03 7.482789e-01
      3078   372_2428817 2010 expShannon 9.845203e+00  1.346067e-01 8.986191e-01
      3079   372_2428817 2011          S 1.800000e+01  2.100000e+00 5.175918e-01
      3080   372_2428817 2011          N 2.190000e+02  1.150000e+01 8.321222e-01
      3081   372_2428817 2011       maxN 4.100000e+01  5.200000e+00 5.825952e-01
      3082   372_2428817 2011    Shannon 2.363837e+00  1.194029e-02 8.961647e-01
      3083   372_2428817 2011    Simpson 8.830925e-01 -1.827241e-03 8.455512e-01
      3084   372_2428817 2011 invSimpson 8.553772e+00 -2.132614e-01 7.499487e-01
      3085   372_2428817 2011        PIE 8.871434e-01 -2.537171e-03 7.237367e-01
      3086   372_2428817 2011      DomMc 3.561644e-01  8.899942e-03 7.482789e-01
      3087   372_2428817 2011 expShannon 1.063167e+01  1.346067e-01 8.986191e-01
      3088   372_2428817 2012          S 2.800000e+01  2.100000e+00 5.175918e-01
      3089   372_2428817 2012          N 2.590000e+02  1.150000e+01 8.321222e-01
      3090   372_2428817 2012       maxN 5.700000e+01  5.200000e+00 5.825952e-01
      3091   372_2428817 2012    Shannon 2.583625e+00  1.194029e-02 8.961647e-01
      3092   372_2428817 2012    Simpson 8.868979e-01 -1.827241e-03 8.455512e-01
      3093   372_2428817 2012 invSimpson 8.841571e+00 -2.132614e-01 7.499487e-01
      3094   372_2428817 2012        PIE 8.903355e-01 -2.537171e-03 7.237367e-01
      3095   372_2428817 2012      DomMc 3.976834e-01  8.899942e-03 7.482789e-01
      3096   372_2428817 2012 expShannon 1.324507e+01  1.346067e-01 8.986191e-01
      3097   372_2425199 2009          S 1.800000e+01 -3.300000e+00 2.498062e-01
      3098   372_2425199 2009          N 4.700000e+02 -1.495000e+02 4.181922e-02
      3099   372_2425199 2009       maxN 1.600000e+02 -5.720000e+01 1.589872e-01
      3100   372_2425199 2009    Shannon 2.224706e+00 -1.401433e-01 4.929754e-01
      3101   372_2425199 2009    Simpson 8.352739e-01 -1.252755e-02 7.489117e-01
      3102   372_2425199 2009 invSimpson 6.070683e+00 -1.201469e-01 9.348446e-01
      3103   372_2425199 2009        PIE 8.370548e-01 -8.807304e-03 8.175240e-01
      3104   372_2425199 2009      DomMc 4.723404e-01  1.879582e-02 7.818617e-01
      3105   372_2425199 2009 expShannon 9.250759e+00 -8.606994e-01 6.020123e-01
      3106   372_2425199 2010          S 2.100000e+01 -3.300000e+00 2.498062e-01
      3107   372_2425199 2010          N 4.510000e+02 -1.495000e+02 4.181922e-02
      3108   372_2425199 2010       maxN 2.000000e+02 -5.720000e+01 1.589872e-01
      3109   372_2425199 2010    Shannon 2.025903e+00 -1.401433e-01 4.929754e-01
      3110   372_2425199 2010    Simpson 7.670267e-01 -1.252755e-02 7.489117e-01
      3111   372_2425199 2010 invSimpson 4.292338e+00 -1.201469e-01 9.348446e-01
      3112   372_2425199 2010        PIE 7.687312e-01 -8.807304e-03 8.175240e-01
      3113   372_2425199 2010      DomMc 5.543237e-01  1.879582e-02 7.818617e-01
      3114   372_2425199 2010 expShannon 7.582955e+00 -8.606994e-01 6.020123e-01
      3115   372_2425199 2011          S 1.800000e+01 -3.300000e+00 2.498062e-01
      3116   372_2425199 2011          N 1.920000e+02 -1.495000e+02 4.181922e-02
      3117   372_2425199 2011       maxN 3.900000e+01 -5.720000e+01 1.589872e-01
      3118   372_2425199 2011    Shannon 2.455791e+00 -1.401433e-01 4.929754e-01
      3119   372_2425199 2011    Simpson 8.913303e-01 -1.252755e-02 7.489117e-01
      3120   372_2425199 2011 invSimpson 9.202197e+00 -1.201469e-01 9.348446e-01
      3121   372_2425199 2011        PIE 8.959969e-01 -8.807304e-03 8.175240e-01
      3122   372_2425199 2011      DomMc 3.489583e-01  1.879582e-02 7.818617e-01
      3123   372_2425199 2011 expShannon 1.165565e+01 -8.606994e-01 6.020123e-01
      3124   372_2425199 2012          S 8.000000e+00 -3.300000e+00 2.498062e-01
      3125   372_2425199 2012          N 5.800000e+01 -1.495000e+02 4.181922e-02
      3126   372_2425199 2012       maxN 2.300000e+01 -5.720000e+01 1.589872e-01
      3127   372_2425199 2012    Shannon 1.614265e+00 -1.401433e-01 4.929754e-01
      3128   372_2425199 2012    Simpson 7.520809e-01 -1.252755e-02 7.489117e-01
      3129   372_2425199 2012 invSimpson 4.033573e+00 -1.201469e-01 9.348446e-01
      3130   372_2425199 2012        PIE 7.652753e-01 -8.807304e-03 8.175240e-01
      3131   372_2425199 2012      DomMc 6.034483e-01  1.879582e-02 7.818617e-01
      3132   372_2425199 2012 expShannon 5.024195e+00 -8.606994e-01 6.020123e-01
      3133   372_2423009 2009          S 1.400000e+01  5.500000e+00 3.333333e-01
      3134   372_2423009 2009          N 7.100000e+01 -2.385000e+02 4.123000e-01
      3135   372_2423009 2009       maxN 2.200000e+01 -2.435000e+02 3.456457e-01
      3136   372_2423009 2009    Shannon 2.223251e+00  1.014846e+00 1.747941e-01
      3137   372_2423009 2009    Simpson 8.454672e-01  3.065277e-01 2.759707e-01
      3138   372_2423009 2009 invSimpson 6.471117e+00  4.626174e+00 3.414032e-02
      3139   372_2423009 2009        PIE 8.575453e-01  3.094384e-01 2.821658e-01
      3140   372_2423009 2009      DomMc 4.788732e-01 -2.947555e-01 1.623859e-01
      3141   372_2423009 2009 expShannon 9.237310e+00  6.746185e+00 2.453007e-02
      3142   372_2423009 2010          S 2.500000e+01  5.500000e+00 3.333333e-01
      3143   372_2423009 2010          N 1.450000e+02 -2.385000e+02 4.123000e-01
      3144   372_2423009 2010       maxN 3.300000e+01 -2.435000e+02 3.456457e-01
      3145   372_2423009 2010    Shannon 2.742969e+00  1.014846e+00 1.747941e-01
      3146   372_2423009 2010    Simpson 9.062545e-01  3.065277e-01 2.759707e-01
      3147   372_2423009 2010 invSimpson 1.066717e+01  4.626174e+00 3.414032e-02
      3148   372_2423009 2010        PIE 9.125479e-01  3.094384e-01 2.821658e-01
      3149   372_2423009 2010      DomMc 3.172414e-01 -2.947555e-01 1.623859e-01
      3150   372_2423009 2010 expShannon 1.553304e+01  6.746185e+00 2.453007e-02
      3151   372_2423009 2008          S 1.400000e+01  5.500000e+00 3.333333e-01
      3152   372_2423009 2008          N 6.220000e+02 -2.385000e+02 4.123000e-01
      3153   372_2423009 2008       maxN 5.200000e+02 -2.435000e+02 3.456457e-01
      3154   372_2423009 2008    Shannon 7.132775e-01  1.014846e+00 1.747941e-01
      3155   372_2423009 2008    Simpson 2.931990e-01  3.065277e-01 2.759707e-01
      3156   372_2423009 2008 invSimpson 1.414825e+00  4.626174e+00 3.414032e-02
      3157   372_2423009 2008        PIE 2.936711e-01  3.094384e-01 2.821658e-01
      3158   372_2423009 2008      DomMc 9.067524e-01 -2.947555e-01 1.623859e-01
      3159   372_2423009 2008 expShannon 2.040669e+00  6.746185e+00 2.453007e-02
      3160   372_2404057 2011          S 2.400000e+01  2.000000e+00 1.789124e-01
      3161   372_2404057 2011          N 4.800000e+02  3.600000e+01 8.560272e-01
      3162   372_2404057 2011       maxN 1.110000e+02  2.150000e+01 6.290129e-01
      3163   372_2404057 2011    Shannon 2.676880e+00 -7.345120e-02 4.904246e-01
      3164   372_2404057 2011    Simpson 9.031163e-01 -2.233564e-02 2.893914e-01
      3165   372_2404057 2011 invSimpson 1.032166e+01 -1.730308e+00 2.697143e-01
      3166   372_2404057 2011        PIE 9.050017e-01 -2.320481e-02 2.465095e-01
      3167   372_2404057 2011      DomMc 3.187500e-01  5.498407e-02 2.677315e-01
      3168   372_2404057 2011 expShannon 1.453966e+01 -9.447781e-01 5.033808e-01
      3169   372_2404057 2012          S 2.500000e+01  2.000000e+00 1.789124e-01
      3170   372_2404057 2012          N 2.450000e+02  3.600000e+01 8.560272e-01
      3171   372_2404057 2012       maxN 7.600000e+01  2.150000e+01 6.290129e-01
      3172   372_2404057 2012    Shannon 2.479979e+00 -7.345120e-02 4.904246e-01
      3173   372_2404057 2012    Simpson 8.618742e-01 -2.233564e-02 2.893914e-01
      3174   372_2404057 2012 invSimpson 7.239778e+00 -1.730308e+00 2.697143e-01
      3175   372_2404057 2012        PIE 8.654065e-01 -2.320481e-02 2.465095e-01
      3176   372_2404057 2012      DomMc 4.163265e-01  5.498407e-02 2.677315e-01
      3177   372_2404057 2012 expShannon 1.194101e+01 -9.447781e-01 5.033808e-01
      3178   372_2404057 2010          S 2.100000e+01  2.000000e+00 1.789124e-01
      3179   372_2404057 2010          N 1.730000e+02  3.600000e+01 8.560272e-01
      3180   372_2404057 2010       maxN 3.300000e+01  2.150000e+01 6.290129e-01
      3181   372_2404057 2010    Shannon 2.626881e+00 -7.345120e-02 4.904246e-01
      3182   372_2404057 2010    Simpson 9.065455e-01 -2.233564e-02 2.893914e-01
      3183   372_2404057 2010 invSimpson 1.070039e+01 -1.730308e+00 2.697143e-01
      3184   372_2404057 2010        PIE 9.118161e-01 -2.320481e-02 2.465095e-01
      3185   372_2404057 2010      DomMc 3.063584e-01  5.498407e-02 2.677315e-01
      3186   372_2404057 2010 expShannon 1.383056e+01 -9.447781e-01 5.033808e-01
      3187   372_2412081 2008          S 2.700000e+01 -2.000000e+00 3.333333e-01
      3188   372_2412081 2008          N 3.110000e+02 -7.000000e+01 1.344828e-01
      3189   372_2412081 2008       maxN 5.400000e+01 -1.200000e+01 2.339080e-01
      3190   372_2412081 2008    Shannon 2.675312e+00  4.945754e-02 3.363200e-01
      3191   372_2412081 2008    Simpson 9.046433e-01  6.520411e-03 4.015477e-01
      3192   372_2412081 2008 invSimpson 1.048693e+01  8.306913e-01 3.917826e-01
      3193   372_2412081 2008        PIE 9.075615e-01  7.760380e-03 3.759773e-01
      3194   372_2412081 2008      DomMc 3.022508e-01  3.845358e-03 3.953605e-01
      3195   372_2412081 2008 expShannon 1.451687e+01  7.546782e-01 3.361743e-01
      3196   372_2412081 2009          S 2.700000e+01 -2.000000e+00 3.333333e-01
      3197   372_2412081 2009          N 2.670000e+02 -7.000000e+01 1.344828e-01
      3198   372_2412081 2009       maxN 5.000000e+01 -1.200000e+01 2.339080e-01
      3199   372_2412081 2009    Shannon 2.674774e+00  4.945754e-02 3.363200e-01
      3200   372_2412081 2009    Simpson 9.029163e-01  6.520411e-03 4.015477e-01
      3201   372_2412081 2009 invSimpson 1.030039e+01  8.306913e-01 3.917826e-01
      3202   372_2412081 2009        PIE 9.063107e-01  7.760380e-03 3.759773e-01
      3203   372_2412081 2009      DomMc 3.108614e-01  3.845358e-03 3.953605e-01
      3204   372_2412081 2009 expShannon 1.450908e+01  7.546782e-01 3.361743e-01
      3205   372_2412081 2010          S 2.300000e+01 -2.000000e+00 3.333333e-01
      3206   372_2412081 2010          N 1.710000e+02 -7.000000e+01 1.344828e-01
      3207   372_2412081 2010       maxN 3.000000e+01 -1.200000e+01 2.339080e-01
      3208   372_2412081 2010    Shannon 2.774227e+00  4.945754e-02 3.363200e-01
      3209   372_2412081 2010    Simpson 9.176841e-01  6.520411e-03 4.015477e-01
      3210   372_2412081 2010 invSimpson 1.214832e+01  8.306913e-01 3.917826e-01
      3211   372_2412081 2010        PIE 9.230822e-01  7.760380e-03 3.759773e-01
      3212   372_2412081 2010      DomMc 3.099415e-01  3.845358e-03 3.953605e-01
      3213   372_2412081 2010 expShannon 1.602623e+01  7.546782e-01 3.361743e-01
      3214   372_2419351 2009          S 2.200000e+01 -1.200000e+00 5.954801e-01
      3215   372_2419351 2009          N 2.170000e+02 -1.910000e+01 1.333835e-01
      3216   372_2419351 2009       maxN 3.800000e+01  6.200000e+00 5.920699e-01
      3217   372_2419351 2009    Shannon 2.439961e+00 -5.995904e-02 5.645538e-01
      3218   372_2419351 2009    Simpson 8.885302e-01 -1.625472e-02 4.198989e-01
      3219   372_2419351 2009 invSimpson 8.971042e+00 -1.105885e+00 4.459133e-01
      3220   372_2419351 2009        PIE 8.926438e-01 -1.583006e-02 4.350867e-01
      3221   372_2419351 2009      DomMc 3.179724e-01  4.898658e-02 2.290456e-01
      3222   372_2419351 2009 expShannon 1.147260e+01 -7.357861e-01 5.921532e-01
      3223   372_2419351 2010          S 2.600000e+01 -1.200000e+00 5.954801e-01
      3224   372_2419351 2010          N 2.040000e+02 -1.910000e+01 1.333835e-01
      3225   372_2419351 2010       maxN 3.200000e+01  6.200000e+00 5.920699e-01
      3226   372_2419351 2010    Shannon 2.750207e+00 -5.995904e-02 5.645538e-01
      3227   372_2419351 2010    Simpson 9.159938e-01 -1.625472e-02 4.198989e-01
      3228   372_2419351 2010 invSimpson 1.190389e+01 -1.105885e+00 4.459133e-01
      3229   372_2419351 2010        PIE 9.205061e-01 -1.583006e-02 4.350867e-01
      3230   372_2419351 2010      DomMc 2.990196e-01  4.898658e-02 2.290456e-01
      3231   372_2419351 2010 expShannon 1.564587e+01 -7.357861e-01 5.921532e-01
      3232   372_2419351 2011          S 2.600000e+01 -1.200000e+00 5.954801e-01
      3233   372_2419351 2011          N 2.050000e+02 -1.910000e+01 1.333835e-01
      3234   372_2419351 2011       maxN 7.600000e+01  6.200000e+00 5.920699e-01
      3235   372_2419351 2011    Shannon 2.417268e+00 -5.995904e-02 5.645538e-01
      3236   372_2419351 2011    Simpson 8.313147e-01 -1.625472e-02 4.198989e-01
      3237   372_2419351 2011 invSimpson 5.928199e+00 -1.105885e+00 4.459133e-01
      3238   372_2419351 2011        PIE 8.353898e-01 -1.583006e-02 4.350867e-01
      3239   372_2419351 2011      DomMc 4.682927e-01  4.898658e-02 2.290456e-01
      3240   372_2419351 2011 expShannon 1.121518e+01 -7.357861e-01 5.921532e-01
      3241   372_2419351 2012          S 1.800000e+01 -1.200000e+00 5.954801e-01
      3242   372_2419351 2012          N 1.530000e+02 -1.910000e+01 1.333835e-01
      3243   372_2419351 2012       maxN 4.400000e+01  6.200000e+00 5.920699e-01
      3244   372_2419351 2012    Shannon 2.351077e+00 -5.995904e-02 5.645538e-01
      3245   372_2419351 2012    Simpson 8.625742e-01 -1.625472e-02 4.198989e-01
      3246   372_2419351 2012 invSimpson 7.276655e+00 -1.105885e+00 4.459133e-01
      3247   372_2419351 2012        PIE 8.682491e-01 -1.583006e-02 4.350867e-01
      3248   372_2419351 2012      DomMc 4.248366e-01  4.898658e-02 2.290456e-01
      3249   372_2419351 2012 expShannon 1.049687e+01 -7.357861e-01 5.921532e-01
      3250   372_2418626 2008          S 1.600000e+01  1.000000e-01 9.353888e-01
      3251   372_2418626 2008          N 1.600000e+02 -1.030000e+01 4.128152e-01
      3252   372_2418626 2008       maxN 7.200000e+01 -8.900000e+00 2.484966e-01
      3253   372_2418626 2008    Shannon 1.803696e+00  1.193870e-01 3.252318e-01
      3254   372_2418626 2008    Simpson 7.274219e-01  2.944144e-02 2.206089e-01
      3255   372_2418626 2008 invSimpson 3.668673e+00  9.785071e-01 3.276496e-01
      3256   372_2418626 2008        PIE 7.319969e-01  3.015637e-02 2.200841e-01
      3257   372_2418626 2008      DomMc 6.937500e-01 -5.993086e-02 2.021638e-01
      3258   372_2418626 2008 expShannon 6.072046e+00  1.033399e+00 3.879518e-01
      3259   372_2418626 2009          S 2.300000e+01  1.000000e-01 9.353888e-01
      3260   372_2418626 2009          N 1.080000e+02 -1.030000e+01 4.128152e-01
      3261   372_2418626 2009       maxN 2.600000e+01 -8.900000e+00 2.484966e-01
      3262   372_2418626 2009    Shannon 2.550340e+00  1.193870e-01 3.252318e-01
      3263   372_2418626 2009    Simpson 8.796296e-01  2.944144e-02 2.206089e-01
      3264   372_2418626 2009 invSimpson 8.307692e+00  9.785071e-01 3.276496e-01
      3265   372_2418626 2009        PIE 8.878505e-01  3.015637e-02 2.200841e-01
      3266   372_2418626 2009      DomMc 4.351852e-01 -5.993086e-02 2.021638e-01
      3267   372_2418626 2009 expShannon 1.281146e+01  1.033399e+00 3.879518e-01
      3268   372_2418626 2010          S 2.100000e+01  1.000000e-01 9.353888e-01
      3269   372_2418626 2010          N 1.770000e+02 -1.030000e+01 4.128152e-01
      3270   372_2418626 2010       maxN 5.200000e+01 -8.900000e+00 2.484966e-01
      3271   372_2418626 2010    Shannon 2.310410e+00  1.193870e-01 3.252318e-01
      3272   372_2418626 2010    Simpson 8.445849e-01  2.944144e-02 2.206089e-01
      3273   372_2418626 2010 invSimpson 6.434381e+00  9.785071e-01 3.276496e-01
      3274   372_2418626 2010        PIE 8.493837e-01  3.015637e-02 2.200841e-01
      3275   372_2418626 2010      DomMc 5.084746e-01 -5.993086e-02 2.021638e-01
      3276   372_2418626 2010 expShannon 1.007855e+01  1.033399e+00 3.879518e-01
      3277   372_2418626 2011          S 2.200000e+01  1.000000e-01 9.353888e-01
      3278   372_2418626 2011          N 1.050000e+02 -1.030000e+01 4.128152e-01
      3279   372_2418626 2011       maxN 1.700000e+01 -8.900000e+00 2.484966e-01
      3280   372_2418626 2011    Shannon 2.686719e+00  1.193870e-01 3.252318e-01
      3281   372_2418626 2011    Simpson 9.112018e-01  2.944144e-02 2.206089e-01
      3282   372_2418626 2011 invSimpson 1.126149e+01  9.785071e-01 3.276496e-01
      3283   372_2418626 2011        PIE 9.199634e-01  3.015637e-02 2.200841e-01
      3284   372_2418626 2011      DomMc 3.142857e-01 -5.993086e-02 2.021638e-01
      3285   372_2418626 2011 expShannon 1.468342e+01  1.033399e+00 3.879518e-01
      3286   372_2418626 2012          S 1.700000e+01  1.000000e-01 9.353888e-01
      3287   372_2418626 2012          N 1.100000e+02 -1.030000e+01 4.128152e-01
      3288   372_2418626 2012       maxN 3.200000e+01 -8.900000e+00 2.484966e-01
      3289   372_2418626 2012    Shannon 2.332441e+00  1.193870e-01 3.252318e-01
      3290   372_2418626 2012    Simpson 8.588430e-01  2.944144e-02 2.206089e-01
      3291   372_2418626 2012 invSimpson 7.084309e+00  9.785071e-01 3.276496e-01
      3292   372_2418626 2012        PIE 8.667223e-01  3.015637e-02 2.200841e-01
      3293   372_2418626 2012      DomMc 4.545455e-01 -5.993086e-02 2.021638e-01
      3294   372_2418626 2012 expShannon 1.030306e+01  1.033399e+00 3.879518e-01
      3295   372_2409154 2012          S 1.600000e+01  3.500000e+00 4.065197e-01
      3296   372_2409154 2012          N 8.700000e+01  2.250000e+01 4.327586e-01
      3297   372_2409154 2012       maxN 2.300000e+01  1.500000e+00 5.934803e-01
      3298   372_2409154 2012    Shannon 2.141876e+00  2.184521e-01 5.600077e-01
      3299   372_2409154 2012    Simpson 8.360417e-01  5.350840e-02 5.939593e-01
      3300   372_2409154 2012 invSimpson 6.099114e+00  1.204369e+00 4.826273e-01
      3301   372_2409154 2012        PIE 8.457632e-01  4.947856e-02 6.007667e-01
      3302   372_2409154 2012      DomMc 4.942529e-01 -5.049261e-02 6.680200e-01
      3303   372_2409154 2012 expShannon 8.515401e+00  1.507084e+00 5.079372e-01
      3304   372_2409154 2011          S 8.000000e+00  3.500000e+00 4.065197e-01
      3305   372_2409154 2011          N 3.300000e+01  2.250000e+01 4.327586e-01
      3306   372_2409154 2011       maxN 1.800000e+01  1.500000e+00 5.934803e-01
      3307   372_2409154 2011    Shannon 1.466042e+00  2.184521e-01 5.600077e-01
      3308   372_2409154 2011    Simpson 6.574839e-01  5.350840e-02 5.939593e-01
      3309   372_2409154 2011 invSimpson 2.919571e+00  1.204369e+00 4.826273e-01
      3310   372_2409154 2011        PIE 6.780303e-01  4.947856e-02 6.007667e-01
      3311   372_2409154 2011      DomMc 6.969697e-01 -5.049261e-02 6.680200e-01
      3312   372_2409154 2011 expShannon 4.332056e+00  1.507084e+00 5.079372e-01
      3313   372_2409154 2010          S 9.000000e+00  3.500000e+00 4.065197e-01
      3314   372_2409154 2010          N 4.200000e+01  2.250000e+01 4.327586e-01
      3315   372_2409154 2010       maxN 2.000000e+01  1.500000e+00 5.934803e-01
      3316   372_2409154 2010    Shannon 1.704972e+00  2.184521e-01 5.600077e-01
      3317   372_2409154 2010    Simpson 7.290249e-01  5.350840e-02 5.939593e-01
      3318   372_2409154 2010 invSimpson 3.690377e+00  1.204369e+00 4.826273e-01
      3319   372_2409154 2010        PIE 7.468060e-01  4.947856e-02 6.007667e-01
      3320   372_2409154 2010      DomMc 5.952381e-01 -5.049261e-02 6.680200e-01
      3321   372_2409154 2010 expShannon 5.501233e+00  1.507084e+00 5.079372e-01
      3322   372_2403315 2009          S 5.000000e+01 -3.300000e+00 4.685019e-01
      3323   372_2403315 2009          N 7.740000e+02 -1.037000e+02 2.455608e-01
      3324   372_2403315 2009       maxN 1.200000e+02 -2.290000e+01 1.130092e-01
      3325   372_2403315 2009    Shannon 3.204683e+00 -1.172282e-02 8.995954e-01
      3326   372_2403315 2009    Simpson 9.372634e-01  2.969020e-03 6.015040e-01
      3327   372_2403315 2009 invSimpson 1.593966e+01  6.796519e-01 5.628100e-01
      3328   372_2403315 2009        PIE 9.384759e-01  3.280446e-03 5.664623e-01
      3329   372_2403315 2009      DomMc 2.648579e-01 -1.914269e-02 1.733721e-01
      3330   372_2403315 2009 expShannon 2.464769e+01 -3.592768e-01 8.500695e-01
      3331   372_2403315 2010          S 3.100000e+01 -3.300000e+00 4.685019e-01
      3332   372_2403315 2010          N 5.040000e+02 -1.037000e+02 2.455608e-01
      3333   372_2403315 2010       maxN 8.200000e+01 -2.290000e+01 1.130092e-01
      3334   372_2403315 2010    Shannon 2.851092e+00 -1.172282e-02 8.995954e-01
      3335   372_2403315 2010    Simpson 9.202727e-01  2.969020e-03 6.015040e-01
      3336   372_2403315 2010 invSimpson 1.254276e+01  6.796519e-01 5.628100e-01
      3337   372_2403315 2010        PIE 9.221023e-01  3.280446e-03 5.664623e-01
      3338   372_2403315 2010      DomMc 2.817460e-01 -1.914269e-02 1.733721e-01
      3339   372_2403315 2010 expShannon 1.730667e+01 -3.592768e-01 8.500695e-01
      3340   372_2403315 2011          S 3.700000e+01 -3.300000e+00 4.685019e-01
      3341   372_2403315 2011          N 3.520000e+02 -1.037000e+02 2.455608e-01
      3342   372_2403315 2011       maxN 4.500000e+01 -2.290000e+01 1.130092e-01
      3343   372_2403315 2011    Shannon 3.117706e+00 -1.172282e-02 8.995954e-01
      3344   372_2403315 2011    Simpson 9.400342e-01  2.969020e-03 6.015040e-01
      3345   372_2403315 2011 invSimpson 1.667618e+01  6.796519e-01 5.628100e-01
      3346   372_2403315 2011        PIE 9.427124e-01  3.280446e-03 5.664623e-01
      3347   372_2403315 2011      DomMc 2.272727e-01 -1.914269e-02 1.733721e-01
      3348   372_2403315 2011 expShannon 2.259449e+01 -3.592768e-01 8.500695e-01
      3349   372_2403315 2012          S 3.700000e+01 -3.300000e+00 4.685019e-01
      3350   372_2403315 2012          N 4.790000e+02 -1.037000e+02 2.455608e-01
      3351   372_2403315 2012       maxN 5.600000e+01 -2.290000e+01 1.130092e-01
      3352   372_2403315 2012    Shannon 3.076736e+00 -1.172282e-02 8.995954e-01
      3353   372_2403315 2012    Simpson 9.405730e-01  2.969020e-03 6.015040e-01
      3354   372_2403315 2012 invSimpson 1.682736e+01  6.796519e-01 5.628100e-01
      3355   372_2403315 2012        PIE 9.425407e-01  3.280446e-03 5.664623e-01
      3356   372_2403315 2012      DomMc 2.192067e-01 -1.914269e-02 1.733721e-01
      3357   372_2403315 2012 expShannon 2.168749e+01 -3.592768e-01 8.500695e-01
      3358   372_2400400 2009          S 1.200000e+01  4.000000e-01 7.123343e-01
      3359   372_2400400 2009          N 6.800000e+01  2.000000e+00 6.264163e-01
      3360   372_2400400 2009       maxN 3.000000e+01  5.000000e-01 8.874668e-01
      3361   372_2400400 2009    Shannon 1.940570e+00  1.261536e-02 9.158048e-01
      3362   372_2400400 2009    Simpson 7.681661e-01  1.641708e-03 9.457911e-01
      3363   372_2400400 2009 invSimpson 4.313433e+00  5.591352e-02 9.569245e-01
      3364   372_2400400 2009        PIE 7.796313e-01  6.382966e-04 9.796873e-01
      3365   372_2400400 2009      DomMc 5.588235e-01  6.536972e-04 9.876732e-01
      3366   372_2400400 2009 expShannon 6.962717e+00  1.486439e-01 8.939148e-01
      3367   372_2400400 2010          S 1.700000e+01  4.000000e-01 7.123343e-01
      3368   372_2400400 2010          N 6.300000e+01  2.000000e+00 6.264163e-01
      3369   372_2400400 2010       maxN 1.200000e+01  5.000000e-01 8.874668e-01
      3370   372_2400400 2010    Shannon 2.592083e+00  1.261536e-02 9.158048e-01
      3371   372_2400400 2010    Simpson 9.060217e-01  1.641708e-03 9.457911e-01
      3372   372_2400400 2010 invSimpson 1.064075e+01  5.591352e-02 9.569245e-01
      3373   372_2400400 2010        PIE 9.206349e-01  6.382966e-04 9.796873e-01
      3374   372_2400400 2010      DomMc 3.333333e-01  6.536972e-04 9.876732e-01
      3375   372_2400400 2010 expShannon 1.335756e+01  1.486439e-01 8.939148e-01
      3376   372_2400400 2012          S 1.400000e+01  4.000000e-01 7.123343e-01
      3377   372_2400400 2012          N 5.500000e+01  2.000000e+00 6.264163e-01
      3378   372_2400400 2012       maxN 1.400000e+01  5.000000e-01 8.874668e-01
      3379   372_2400400 2012    Shannon 2.290125e+00  1.261536e-02 9.158048e-01
      3380   372_2400400 2012    Simpson 8.694215e-01  1.641708e-03 9.457911e-01
      3381   372_2400400 2012 invSimpson 7.658228e+00  5.591352e-02 9.569245e-01
      3382   372_2400400 2012        PIE 8.855219e-01  6.382966e-04 9.796873e-01
      3383   372_2400400 2012      DomMc 3.818182e-01  6.536972e-04 9.876732e-01
      3384   372_2400400 2012 expShannon 9.876173e+00  1.486439e-01 8.939148e-01
      3385   372_2400400 2008          S 1.100000e+01  4.000000e-01 7.123343e-01
      3386   372_2400400 2008          N 4.000000e+01  2.000000e+00 6.264163e-01
      3387   372_2400400 2008       maxN 8.000000e+00  5.000000e-01 8.874668e-01
      3388   372_2400400 2008    Shannon 2.169717e+00  1.261536e-02 9.158048e-01
      3389   372_2400400 2008    Simpson 8.662500e-01  1.641708e-03 9.457911e-01
      3390   372_2400400 2008 invSimpson 7.476636e+00  5.591352e-02 9.569245e-01
      3391   372_2400400 2008        PIE 8.884615e-01  6.382966e-04 9.796873e-01
      3392   372_2400400 2008      DomMc 3.750000e-01  6.536972e-04 9.876732e-01
      3393   372_2400400 2008 expShannon 8.755810e+00  1.486439e-01 8.939148e-01
      3394   372_2400400 2011          S 1.000000e+01  4.000000e-01 7.123343e-01
      3395   372_2400400 2011          N 5.800000e+01  2.000000e+00 6.264163e-01
      3396   372_2400400 2011       maxN 2.300000e+01  5.000000e-01 8.874668e-01
      3397   372_2400400 2011    Shannon 1.825908e+00  1.261536e-02 9.158048e-01
      3398   372_2400400 2011    Simpson 7.782402e-01  1.641708e-03 9.457911e-01
      3399   372_2400400 2011 invSimpson 4.509383e+00  5.591352e-02 9.569245e-01
      3400   372_2400400 2011        PIE 7.918935e-01  6.382966e-04 9.796873e-01
      3401   372_2400400 2011      DomMc 5.517241e-01  6.536972e-04 9.876732e-01
      3402   372_2400400 2011 expShannon 6.208432e+00  1.486439e-01 8.939148e-01
      3403   372_2393850 2010          S 2.500000e+01 -2.100000e+00 3.653822e-01
      3404   372_2393850 2010          N 1.650000e+02  1.110000e+01 5.673263e-01
      3405   372_2393850 2010       maxN 3.700000e+01 -2.000000e-01 9.595112e-01
      3406   372_2393850 2010    Shannon 2.496006e+00  1.009327e-02 8.747099e-01
      3407   372_2393850 2010    Simpson 8.750046e-01  1.425450e-02 1.447010e-01
      3408   372_2393850 2010 invSimpson 8.000294e+00  7.785175e-01 1.374838e-01
      3409   372_2393850 2010        PIE 8.803400e-01  1.353751e-02 1.375077e-01
      3410   372_2393850 2010      DomMc 4.363636e-01 -5.422552e-02 4.110905e-02
      3411   372_2393850 2010 expShannon 1.213394e+01  1.287919e-01 8.540094e-01
      3412   372_2393850 2012          S 2.100000e+01 -2.100000e+00 3.653822e-01
      3413   372_2393850 2012          N 1.310000e+02  1.110000e+01 5.673263e-01
      3414   372_2393850 2012       maxN 2.600000e+01 -2.000000e-01 9.595112e-01
      3415   372_2393850 2012    Shannon 2.494051e+00  1.009327e-02 8.747099e-01
      3416   372_2393850 2012    Simpson 8.880601e-01  1.425450e-02 1.447010e-01
      3417   372_2393850 2012 invSimpson 8.933368e+00  7.785175e-01 1.374838e-01
      3418   372_2393850 2012        PIE 8.948914e-01  1.353751e-02 1.375077e-01
      3419   372_2393850 2012      DomMc 3.664122e-01 -5.422552e-02 4.110905e-02
      3420   372_2393850 2012 expShannon 1.211024e+01  1.287919e-01 8.540094e-01
      3421   372_2393850 2009          S 2.500000e+01 -2.100000e+00 3.653822e-01
      3422   372_2393850 2009          N 9.100000e+01  1.110000e+01 5.673263e-01
      3423   372_2393850 2009       maxN 2.700000e+01 -2.000000e-01 9.595112e-01
      3424   372_2393850 2009    Shannon 2.387589e+00  1.009327e-02 8.747099e-01
      3425   372_2393850 2009    Simpson 8.373385e-01  1.425450e-02 1.447010e-01
      3426   372_2393850 2009 invSimpson 6.147736e+00  7.785175e-01 1.374838e-01
      3427   372_2393850 2009        PIE 8.466422e-01  1.353751e-02 1.375077e-01
      3428   372_2393850 2009      DomMc 5.384615e-01 -5.422552e-02 4.110905e-02
      3429   372_2393850 2009 expShannon 1.088721e+01  1.287919e-01 8.540094e-01
      3430   372_2393850 2011          S 1.600000e+01 -2.100000e+00 3.653822e-01
      3431   372_2393850 2011          N 1.560000e+02  1.110000e+01 5.673263e-01
      3432   372_2393850 2011       maxN 3.800000e+01 -2.000000e-01 9.595112e-01
      3433   372_2393850 2011    Shannon 2.277551e+00  1.009327e-02 8.747099e-01
      3434   372_2393850 2011    Simpson 8.653846e-01  1.425450e-02 1.447010e-01
      3435   372_2393850 2011 invSimpson 7.428571e+00  7.785175e-01 1.374838e-01
      3436   372_2393850 2011        PIE 8.709677e-01  1.353751e-02 1.375077e-01
      3437   372_2393850 2011      DomMc 4.102564e-01 -5.422552e-02 4.110905e-02
      3438   372_2393850 2011 expShannon 9.752768e+00  1.287919e-01 8.540094e-01
      3439   372_2398940 2008          S 4.400000e+01 -3.400000e+00 2.276093e-01
      3440   372_2398940 2008          N 8.580000e+02 -1.019000e+02 3.573546e-01
      3441   372_2398940 2008       maxN 1.570000e+02 -1.820000e+01 4.086596e-01
      3442   372_2398940 2008    Shannon 2.995681e+00 -2.437833e-02 3.588730e-01
      3443   372_2398940 2008    Simpson 9.189827e-01  7.934840e-04 8.029615e-01
      3444   372_2398940 2008 invSimpson 1.234305e+01  1.901846e-01 7.437752e-01
      3445   372_2398940 2008        PIE 9.200551e-01  1.284372e-03 7.364443e-01
      3446   372_2398940 2008      DomMc 3.135198e-01 -5.963878e-03 7.476469e-01
      3447   372_2398940 2008 expShannon 1.999897e+01 -4.574504e-01 3.567632e-01
      3448   372_2398940 2009          S 3.000000e+01 -3.400000e+00 2.276093e-01
      3449   372_2398940 2009          N 2.430000e+02 -1.019000e+02 3.573546e-01
      3450   372_2398940 2009       maxN 4.100000e+01 -1.820000e+01 4.086596e-01
      3451   372_2398940 2009    Shannon 2.856639e+00 -2.437833e-02 3.588730e-01
      3452   372_2398940 2009    Simpson 9.176785e-01  7.934840e-04 8.029615e-01
      3453   372_2398940 2009 invSimpson 1.214750e+01  1.901846e-01 7.437752e-01
      3454   372_2398940 2009        PIE 9.214706e-01  1.284372e-03 7.364443e-01
      3455   372_2398940 2009      DomMc 3.045267e-01 -5.963878e-03 7.476469e-01
      3456   372_2398940 2009 expShannon 1.740294e+01 -4.574504e-01 3.567632e-01
      3457   372_2398940 2010          S 4.000000e+01 -3.400000e+00 2.276093e-01
      3458   372_2398940 2010          N 7.140000e+02 -1.019000e+02 3.573546e-01
      3459   372_2398940 2010       maxN 1.360000e+02 -1.820000e+01 4.086596e-01
      3460   372_2398940 2010    Shannon 2.999523e+00 -2.437833e-02 3.588730e-01
      3461   372_2398940 2010    Simpson 9.215019e-01  7.934840e-04 8.029615e-01
      3462   372_2398940 2010 invSimpson 1.273917e+01  1.901846e-01 7.437752e-01
      3463   372_2398940 2010        PIE 9.227944e-01  1.284372e-03 7.364443e-01
      3464   372_2398940 2010      DomMc 3.333333e-01 -5.963878e-03 7.476469e-01
      3465   372_2398940 2010 expShannon 2.007596e+01 -4.574504e-01 3.567632e-01
      3466   372_2398940 2011          S 2.400000e+01 -3.400000e+00 2.276093e-01
      3467   372_2398940 2011          N 1.520000e+02 -1.019000e+02 3.573546e-01
      3468   372_2398940 2011       maxN 1.900000e+01 -1.820000e+01 4.086596e-01
      3469   372_2398940 2011    Shannon 2.904068e+00 -2.437833e-02 3.588730e-01
      3470   372_2398940 2011    Simpson 9.351627e-01  7.934840e-04 8.029615e-01
      3471   372_2398940 2011 invSimpson 1.542323e+01  1.901846e-01 7.437752e-01
      3472   372_2398940 2011        PIE 9.413559e-01  1.284372e-03 7.364443e-01
      3473   372_2398940 2011      DomMc 2.171053e-01 -5.963878e-03 7.476469e-01
      3474   372_2398940 2011 expShannon 1.824823e+01 -4.574504e-01 3.567632e-01
      3475   372_2398940 2012          S 3.000000e+01 -3.400000e+00 2.276093e-01
      3476   372_2398940 2012          N 3.940000e+02 -1.019000e+02 3.573546e-01
      3477   372_2398940 2012       maxN 7.700000e+01 -1.820000e+01 4.086596e-01
      3478   372_2398940 2012    Shannon 2.850074e+00 -2.437833e-02 3.588730e-01
      3479   372_2398940 2012    Simpson 9.142080e-01  7.934840e-04 8.029615e-01
      3480   372_2398940 2012 invSimpson 1.165610e+01  1.901846e-01 7.437752e-01
      3481   372_2398940 2012        PIE 9.165343e-01  1.284372e-03 7.364443e-01
      3482   372_2398940 2012      DomMc 3.274112e-01 -5.963878e-03 7.476469e-01
      3483   372_2398940 2012 expShannon 1.728907e+01 -4.574504e-01 3.567632e-01
      3484   372_2375616 2010          S 1.500000e+01  7.000000e-01 7.844878e-01
      3485   372_2375616 2010          N 3.090000e+02  4.240000e+01 3.559176e-01
      3486   372_2375616 2010       maxN 1.170000e+02  2.630000e+01 2.651653e-01
      3487   372_2375616 2010    Shannon 1.578578e+00 -1.440006e-02 9.576906e-01
      3488   372_2375616 2010    Simpson 7.122883e-01 -3.578664e-03 9.431099e-01
      3489   372_2375616 2010 invSimpson 3.475702e+00 -8.175199e-01 6.343351e-01
      3490   372_2375616 2010        PIE 7.146009e-01 -3.828300e-03 9.392074e-01
      3491   372_2375616 2010      DomMc 7.346278e-01  9.423410e-03 9.292433e-01
      3492   372_2375616 2010 expShannon 4.848056e+00 -4.959511e-01 8.248375e-01
      3493   372_2375616 2011          S 2.500000e+01  7.000000e-01 7.844878e-01
      3494   372_2375616 2011          N 4.990000e+02  4.240000e+01 3.559176e-01
      3495   372_2375616 2011       maxN 1.700000e+02  2.630000e+01 2.651653e-01
      3496   372_2375616 2011    Shannon 2.174341e+00 -1.440006e-02 9.576906e-01
      3497   372_2375616 2011    Simpson 8.193461e-01 -3.578664e-03 9.431099e-01
      3498   372_2375616 2011 invSimpson 5.535447e+00 -8.175199e-01 6.343351e-01
      3499   372_2375616 2011        PIE 8.209914e-01 -3.828300e-03 9.392074e-01
      3500   372_2375616 2011      DomMc 5.270541e-01  9.423410e-03 9.292433e-01
      3501   372_2375616 2011 expShannon 8.796383e+00 -4.959511e-01 8.248375e-01
      3502   372_2375616 2012          S 2.100000e+01  7.000000e-01 7.844878e-01
      3503   372_2375616 2012          N 4.190000e+02  4.240000e+01 3.559176e-01
      3504   372_2375616 2012       maxN 1.280000e+02  2.630000e+01 2.651653e-01
      3505   372_2375616 2012    Shannon 2.362530e+00 -1.440006e-02 9.576906e-01
      3506   372_2375616 2012    Simpson 8.556798e-01 -3.578664e-03 9.431099e-01
      3507   372_2375616 2012 invSimpson 6.929037e+00 -8.175199e-01 6.343351e-01
      3508   372_2375616 2012        PIE 8.577269e-01 -3.828300e-03 9.392074e-01
      3509   372_2375616 2012      DomMc 4.319809e-01  9.423410e-03 9.292433e-01
      3510   372_2375616 2012 expShannon 1.061778e+01 -4.959511e-01 8.248375e-01
      3511   372_2375616 2009          S 2.200000e+01  7.000000e-01 7.844878e-01
      3512   372_2375616 2009          N 3.410000e+02  4.240000e+01 3.559176e-01
      3513   372_2375616 2009       maxN 5.800000e+01  2.630000e+01 2.651653e-01
      3514   372_2375616 2009    Shannon 2.609118e+00 -1.440006e-02 9.576906e-01
      3515   372_2375616 2009    Simpson 9.032946e-01 -3.578664e-03 9.431099e-01
      3516   372_2375616 2009 invSimpson 1.034068e+01 -8.175199e-01 6.343351e-01
      3517   372_2375616 2009        PIE 9.059514e-01 -3.828300e-03 9.392074e-01
      3518   372_2375616 2009      DomMc 3.313783e-01  9.423410e-03 9.292433e-01
      3519   372_2375616 2009 expShannon 1.358706e+01 -4.959511e-01 8.248375e-01
      3520   372_2363236 2009          S 3.200000e+01 -2.210768e-13 1.000000e+00
      3521   372_2363236 2009          N 4.890000e+02  1.050000e+01 9.695950e-01
      3522   372_2363236 2009       maxN 1.770000e+02 -4.400000e+01 5.232870e-01
      3523   372_2363236 2009    Shannon 2.443796e+00  1.722346e-01 8.455867e-03
      3524   372_2363236 2009    Simpson 8.321561e-01  4.134602e-02 4.263914e-02
      3525   372_2363236 2009 invSimpson 5.957917e+00  2.892904e+00 8.006378e-02
      3526   372_2363236 2009        PIE 8.338613e-01  4.139207e-02 3.593896e-02
      3527   372_2363236 2009      DomMc 5.010225e-01 -1.014916e-01 1.471725e-01
      3528   372_2363236 2009 expShannon 1.151667e+01  2.368062e+00 2.313304e-02
      3529   372_2363236 2010          S 3.500000e+01 -2.210768e-13 1.000000e+00
      3530   372_2363236 2010          N 8.800000e+02  1.050000e+01 9.695950e-01
      3531   372_2363236 2010       maxN 2.150000e+02 -4.400000e+01 5.232870e-01
      3532   372_2363236 2010    Shannon 2.619993e+00  1.722346e-01 8.455867e-03
      3533   372_2363236 2010    Simpson 8.783058e-01  4.134602e-02 4.263914e-02
      3534   372_2363236 2010 invSimpson 8.217317e+00  2.892904e+00 8.006378e-02
      3535   372_2363236 2010        PIE 8.793050e-01  4.139207e-02 3.593896e-02
      3536   372_2363236 2010      DomMc 4.409091e-01 -1.014916e-01 1.471725e-01
      3537   372_2363236 2010 expShannon 1.373563e+01  2.368062e+00 2.313304e-02
      3538   372_2363236 2011          S 3.200000e+01 -2.210768e-13 1.000000e+00
      3539   372_2363236 2011          N 5.100000e+02  1.050000e+01 9.695950e-01
      3540   372_2363236 2011       maxN 8.900000e+01 -4.400000e+01 5.232870e-01
      3541   372_2363236 2011    Shannon 2.788265e+00  1.722346e-01 8.455867e-03
      3542   372_2363236 2011    Simpson 9.148481e-01  4.134602e-02 4.263914e-02
      3543   372_2363236 2011 invSimpson 1.174372e+01  2.892904e+00 8.006378e-02
      3544   372_2363236 2011        PIE 9.166455e-01  4.139207e-02 3.593896e-02
      3545   372_2363236 2011      DomMc 2.980392e-01 -1.014916e-01 1.471725e-01
      3546   372_2363236 2011 expShannon 1.625280e+01  2.368062e+00 2.313304e-02
      3547   372_2365397 2009          S 1.200000e+01  1.000000e+00 8.712907e-02
      3548   372_2365397 2009          N 4.200000e+01 -2.000000e+00 6.507849e-01
      3549   372_2365397 2009       maxN 1.200000e+01 -1.600000e+00 4.037152e-01
      3550   372_2365397 2009    Shannon 2.118033e+00  1.002728e-01 1.719457e-01
      3551   372_2365397 2009    Simpson 8.435374e-01  1.390376e-02 3.541655e-01
      3552   372_2365397 2009 invSimpson 6.391304e+00  8.748913e-01 3.837120e-01
      3553   372_2365397 2009        PIE 8.641115e-01  1.558625e-02 3.511473e-01
      3554   372_2365397 2009      DomMc 4.761905e-01 -3.360806e-02 5.683652e-01
      3555   372_2365397 2009 expShannon 8.314764e+00  1.006394e+00 1.719300e-01
      3556   372_2365397 2011          S 1.300000e+01  1.000000e+00 8.712907e-02
      3557   372_2365397 2011          N 2.600000e+01 -2.000000e+00 6.507849e-01
      3558   372_2365397 2011       maxN 6.000000e+00 -1.600000e+00 4.037152e-01
      3559   372_2365397 2011    Shannon 2.271174e+00  1.002728e-01 1.719457e-01
      3560   372_2365397 2011    Simpson 8.639053e-01  1.390376e-02 3.541655e-01
      3561   372_2365397 2011 invSimpson 7.347826e+00  8.748913e-01 3.837120e-01
      3562   372_2365397 2011        PIE 8.984615e-01  1.558625e-02 3.511473e-01
      3563   372_2365397 2011      DomMc 4.615385e-01 -3.360806e-02 5.683652e-01
      3564   372_2365397 2011 expShannon 9.690767e+00  1.006394e+00 1.719300e-01
      3565   372_2365397 2012          S 1.500000e+01  1.000000e+00 8.712907e-02
      3566   372_2365397 2012          N 3.600000e+01 -2.000000e+00 6.507849e-01
      3567   372_2365397 2012       maxN 6.000000e+00 -1.600000e+00 4.037152e-01
      3568   372_2365397 2012    Shannon 2.486157e+00  1.002728e-01 1.719457e-01
      3569   372_2365397 2012    Simpson 9.012346e-01  1.390376e-02 3.541655e-01
      3570   372_2365397 2012 invSimpson 1.012500e+01  8.748913e-01 3.837120e-01
      3571   372_2365397 2012        PIE 9.269841e-01  1.558625e-02 3.511473e-01
      3572   372_2365397 2012      DomMc 3.055556e-01 -3.360806e-02 5.683652e-01
      3573   372_2365397 2012 expShannon 1.201501e+01  1.006394e+00 1.719300e-01
      3574   372_2365397 2010          S 1.200000e+01  1.000000e+00 8.712907e-02
      3575   372_2365397 2010          N 2.800000e+01 -2.000000e+00 6.507849e-01
      3576   372_2365397 2010       maxN 4.000000e+00 -1.600000e+00 4.037152e-01
      3577   372_2365397 2010    Shannon 2.372817e+00  1.002728e-01 1.719457e-01
      3578   372_2365397 2010    Simpson 8.979592e-01  1.390376e-02 3.541655e-01
      3579   372_2365397 2010 invSimpson 9.800000e+00  8.748913e-01 3.837120e-01
      3580   372_2365397 2010        PIE 9.312169e-01  1.558625e-02 3.511473e-01
      3581   372_2365397 2010      DomMc 2.857143e-01 -3.360806e-02 5.683652e-01
      3582   372_2365397 2010 expShannon 1.072757e+01  1.006394e+00 1.719300e-01
      3583   372_2434649 2009          S 1.200000e+01  1.200000e+00 1.816901e-01
      3584   372_2434649 2009          N 7.800000e+01  1.370000e+01 2.659286e-01
      3585   372_2434649 2009       maxN 2.000000e+01  3.600000e+00 5.270019e-01
      3586   372_2434649 2009    Shannon 2.110285e+00  6.882182e-02 3.586880e-01
      3587   372_2434649 2009    Simpson 8.468113e-01  8.641487e-03 6.119885e-01
      3588   372_2434649 2009 invSimpson 6.527897e+00  3.459524e-01 5.026956e-01
      3589   372_2434649 2009        PIE 8.578089e-01  6.790449e-03 6.926358e-01
      3590   372_2434649 2009      DomMc 4.487179e-01 -2.281657e-02 5.051550e-01
      3591   372_2434649 2009 expShannon 8.250594e+00  5.033399e-01 3.529926e-01
      3592   372_2434649 2012          S 1.400000e+01  1.200000e+00 1.816901e-01
      3593   372_2434649 2012          N 9.800000e+01  1.370000e+01 2.659286e-01
      3594   372_2434649 2012       maxN 2.100000e+01  3.600000e+00 5.270019e-01
      3595   372_2434649 2012    Shannon 2.219117e+00  6.882182e-02 3.586880e-01
      3596   372_2434649 2012    Simpson 8.654727e-01  8.641487e-03 6.119885e-01
      3597   372_2434649 2012 invSimpson 7.433437e+00  3.459524e-01 5.026956e-01
      3598   372_2434649 2012        PIE 8.743951e-01  6.790449e-03 6.926358e-01
      3599   372_2434649 2012      DomMc 3.877551e-01 -2.281657e-02 5.051550e-01
      3600   372_2434649 2012 expShannon 9.199203e+00  5.033399e-01 3.529926e-01
      3601   372_2434649 2010          S 1.500000e+01  1.200000e+00 1.816901e-01
      3602   372_2434649 2010          N 1.400000e+02  1.370000e+01 2.659286e-01
      3603   372_2434649 2010       maxN 4.300000e+01  3.600000e+00 5.270019e-01
      3604   372_2434649 2010    Shannon 1.967086e+00  6.882182e-02 3.586880e-01
      3605   372_2434649 2010    Simpson 8.157143e-01  8.641487e-03 6.119885e-01
      3606   372_2434649 2010 invSimpson 5.426357e+00  3.459524e-01 5.026956e-01
      3607   372_2434649 2010        PIE 8.215827e-01  6.790449e-03 6.926358e-01
      3608   372_2434649 2010      DomMc 5.142857e-01 -2.281657e-02 5.051550e-01
      3609   372_2434649 2010 expShannon 7.149813e+00  5.033399e-01 3.529926e-01
      3610   372_2434649 2011          S 1.200000e+01  1.200000e+00 1.816901e-01
      3611   372_2434649 2011          N 1.190000e+02  1.370000e+01 2.659286e-01
      3612   372_2434649 2011       maxN 5.000000e+01  3.600000e+00 5.270019e-01
      3613   372_2434649 2011    Shannon 1.807305e+00  6.882182e-02 3.586880e-01
      3614   372_2434649 2011    Simpson 7.606807e-01  8.641487e-03 6.119885e-01
      3615   372_2434649 2011 invSimpson 4.178519e+00  3.459524e-01 5.026956e-01
      3616   372_2434649 2011        PIE 7.671272e-01  6.790449e-03 6.926358e-01
      3617   372_2434649 2011      DomMc 6.050420e-01 -2.281657e-02 5.051550e-01
      3618   372_2434649 2011 expShannon 6.094003e+00  5.033399e-01 3.529926e-01
      3619   372_2434649 2008          S 8.000000e+00  1.200000e+00 1.816901e-01
      3620   372_2434649 2008          N 5.000000e+01  1.370000e+01 2.659286e-01
      3621   372_2434649 2008       maxN 1.800000e+01  3.600000e+00 5.270019e-01
      3622   372_2434649 2008    Shannon 1.723518e+00  6.882182e-02 3.586880e-01
      3623   372_2434649 2008    Simpson 7.792000e-01  8.641487e-03 6.119885e-01
      3624   372_2434649 2008 invSimpson 4.528986e+00  3.459524e-01 5.026956e-01
      3625   372_2434649 2008        PIE 7.951020e-01  6.790449e-03 6.926358e-01
      3626   372_2434649 2008      DomMc 5.800000e-01 -2.281657e-02 5.051550e-01
      3627   372_2434649 2008 expShannon 5.604208e+00  5.033399e-01 3.529926e-01
      3628   372_2428090 2009          S 2.000000e+00  0.000000e+00          NaN
      3629   372_2428090 2009          N 2.600000e+01 -6.000000e+00 4.274017e-01
      3630   372_2428090 2009       maxN 1.400000e+01 -3.100000e+00 4.028516e-01
      3631   372_2428090 2009    Shannon 6.901857e-01 -5.193025e-03 3.013613e-01
      3632   372_2428090 2009    Simpson 4.970414e-01 -5.153242e-03 3.018525e-01
      3633   372_2428090 2009 invSimpson 1.988235e+00 -1.971064e-02 3.047592e-01
      3634   372_2428090 2009        PIE 5.169231e-01  2.473875e-02 2.418351e-01
      3635   372_2428090 2009      DomMc 1.000000e+00  0.000000e+00          NaN
      3636   372_2428090 2009 expShannon 1.994086e+00 -1.026784e-02 3.020928e-01
      3637   372_2428090 2010          S 2.000000e+00  0.000000e+00          NaN
      3638   372_2428090 2010          N 3.200000e+01 -6.000000e+00 4.274017e-01
      3639   372_2428090 2010       maxN 1.600000e+01 -3.100000e+00 4.028516e-01
      3640   372_2428090 2010    Shannon 6.931472e-01 -5.193025e-03 3.013613e-01
      3641   372_2428090 2010    Simpson 5.000000e-01 -5.153242e-03 3.018525e-01
      3642   372_2428090 2010 invSimpson 2.000000e+00 -1.971064e-02 3.047592e-01
      3643   372_2428090 2010        PIE 5.161290e-01  2.473875e-02 2.418351e-01
      3644   372_2428090 2010      DomMc 1.000000e+00  0.000000e+00          NaN
      3645   372_2428090 2010 expShannon 2.000000e+00 -1.026784e-02 3.020928e-01
      3646   372_2428090 2011          S 2.000000e+00  0.000000e+00          NaN
      3647   372_2428090 2011          N 3.500000e+01 -6.000000e+00 4.274017e-01
      3648   372_2428090 2011       maxN 1.800000e+01 -3.100000e+00 4.028516e-01
      3649   372_2428090 2011    Shannon 6.927390e-01 -5.193025e-03 3.013613e-01
      3650   372_2428090 2011    Simpson 4.995918e-01 -5.153242e-03 3.018525e-01
      3651   372_2428090 2011 invSimpson 1.998369e+00 -1.971064e-02 3.047592e-01
      3652   372_2428090 2011        PIE 5.142857e-01  2.473875e-02 2.418351e-01
      3653   372_2428090 2011      DomMc 1.000000e+00  0.000000e+00          NaN
      3654   372_2428090 2011 expShannon 1.999184e+00 -1.026784e-02 3.020928e-01
      3655   372_2428090 2012          S 2.000000e+00  0.000000e+00          NaN
      3656   372_2428090 2012          N 5.000000e+00 -6.000000e+00 4.274017e-01
      3657   372_2428090 2012       maxN 3.000000e+00 -3.100000e+00 4.028516e-01
      3658   372_2428090 2012    Shannon 6.730117e-01 -5.193025e-03 3.013613e-01
      3659   372_2428090 2012    Simpson 4.800000e-01 -5.153242e-03 3.018525e-01
      3660   372_2428090 2012 invSimpson 1.923077e+00 -1.971064e-02 3.047592e-01
      3661   372_2428090 2012        PIE 6.000000e-01  2.473875e-02 2.418351e-01
      3662   372_2428090 2012      DomMc 1.000000e+00  0.000000e+00          NaN
      3663   372_2428090 2012 expShannon 1.960132e+00 -1.026784e-02 3.020928e-01
      3664   402_3191114 2010          S 3.600000e+01 -4.600000e+00 7.888660e-02
      3665   402_3191114 2010          N 4.300000e+02 -8.162857e+01 5.209804e-03
      3666   402_3191114 2010       maxN 8.900000e+01 -1.591429e+01 5.782039e-02
      3667   402_3191114 2010    Shannon 2.737146e+00 -1.861636e-01 1.911561e-01
      3668   402_3191114 2010    Simpson 9.017956e-01 -3.654082e-02 1.780576e-01
      3669   402_3191114 2010 invSimpson 1.018284e+01 -7.963640e-01 4.392499e-01
      3670   402_3191114 2010        PIE 9.038977e-01 -3.484292e-02 1.899735e-01
      3671   402_3191114 2010      DomMc 3.395349e-01  4.858482e-02 2.777232e-01
      3672   402_3191114 2010 expShannon 1.544285e+01 -1.510055e+00 2.688198e-01
      3673   402_3191114 2014          S 3.200000e+01 -4.600000e+00 7.888660e-02
      3674   402_3191114 2014          N 1.390000e+02 -8.162857e+01 5.209804e-03
      3675   402_3191114 2014       maxN 1.800000e+01 -1.591429e+01 5.782039e-02
      3676   402_3191114 2014    Shannon 2.939067e+00 -1.861636e-01 1.911561e-01
      3677   402_3191114 2014    Simpson 9.270742e-01 -3.654082e-02 1.780576e-01
      3678   402_3191114 2014 invSimpson 1.371256e+01 -7.963640e-01 4.392499e-01
      3679   402_3191114 2014        PIE 9.337921e-01 -3.484292e-02 1.899735e-01
      3680   402_3191114 2014      DomMc 2.446043e-01  4.858482e-02 2.777232e-01
      3681   402_3191114 2014 expShannon 1.889821e+01 -1.510055e+00 2.688198e-01
      3682   402_3191114 2015          S 8.000000e+00 -4.600000e+00 7.888660e-02
      3683   402_3191114 2015          N 5.800000e+01 -8.162857e+01 5.209804e-03
      3684   402_3191114 2015       maxN 3.300000e+01 -1.591429e+01 5.782039e-02
      3685   402_3191114 2015    Shannon 1.395788e+00 -1.861636e-01 1.911561e-01
      3686   402_3191114 2015    Simpson 6.337693e-01 -3.654082e-02 1.780576e-01
      3687   402_3191114 2015 invSimpson 2.730519e+00 -7.963640e-01 4.392499e-01
      3688   402_3191114 2015        PIE 6.448881e-01 -3.484292e-02 1.899735e-01
      3689   402_3191114 2015      DomMc 7.241379e-01  4.858482e-02 2.777232e-01
      3690   402_3191114 2015 expShannon 4.038156e+00 -1.510055e+00 2.688198e-01
      3691   402_3191114 2011          S 3.700000e+01 -4.600000e+00 7.888660e-02
      3692   402_3191114 2011          N 4.730000e+02 -8.162857e+01 5.209804e-03
      3693   402_3191114 2011       maxN 1.090000e+02 -1.591429e+01 5.782039e-02
      3694   402_3191114 2011    Shannon 2.826820e+00 -1.861636e-01 1.911561e-01
      3695   402_3191114 2011    Simpson 9.045586e-01 -3.654082e-02 1.780576e-01
      3696   402_3191114 2011 invSimpson 1.047764e+01 -7.963640e-01 4.392499e-01
      3697   402_3191114 2011        PIE 9.064751e-01 -3.484292e-02 1.899735e-01
      3698   402_3191114 2011      DomMc 3.255814e-01  4.858482e-02 2.777232e-01
      3699   402_3191114 2011 expShannon 1.689166e+01 -1.510055e+00 2.688198e-01
      3700   402_3191114 2012          S 3.800000e+01 -4.600000e+00 7.888660e-02
      3701   402_3191114 2012          N 3.200000e+02 -8.162857e+01 5.209804e-03
      3702   402_3191114 2012       maxN 9.500000e+01 -1.591429e+01 5.782039e-02
      3703   402_3191114 2012    Shannon 2.612471e+00 -1.861636e-01 1.911561e-01
      3704   402_3191114 2012    Simpson 8.614258e-01 -3.654082e-02 1.780576e-01
      3705   402_3191114 2012 invSimpson 7.216350e+00 -7.963640e-01 4.392499e-01
      3706   402_3191114 2012        PIE 8.641262e-01 -3.484292e-02 1.899735e-01
      3707   402_3191114 2012      DomMc 4.750000e-01  4.858482e-02 2.777232e-01
      3708   402_3191114 2012 expShannon 1.363270e+01 -1.510055e+00 2.688198e-01
      3709   402_3191114 2013          S 3.200000e+01 -4.600000e+00 7.888660e-02
      3710   402_3191114 2013          N 3.250000e+02 -8.162857e+01 5.209804e-03
      3711   402_3191114 2013       maxN 9.100000e+01 -1.591429e+01 5.782039e-02
      3712   402_3191114 2013    Shannon 2.466793e+00 -1.861636e-01 1.911561e-01
      3713   402_3191114 2013    Simpson 8.550817e-01 -3.654082e-02 1.780576e-01
      3714   402_3191114 2013 invSimpson 6.900438e+00 -7.963640e-01 4.392499e-01
      3715   402_3191114 2013        PIE 8.577208e-01 -3.484292e-02 1.899735e-01
      3716   402_3191114 2013      DomMc 4.953846e-01  4.858482e-02 2.777232e-01
      3717   402_3191114 2013 expShannon 1.178460e+01 -1.510055e+00 2.688198e-01
      3718   402_3191113 2013          S 1.300000e+01 -2.384615e+00 9.370671e-02
      3719   402_3191113 2013          N 1.780000e+02 -3.353846e+01 1.610139e-01
      3720   402_3191113 2013       maxN 1.000000e+02 -1.646154e+01 2.468243e-01
      3721   402_3191113 2013    Shannon 1.649992e+00 -1.181099e-01 7.377832e-02
      3722   402_3191113 2013    Simpson 6.583133e-01 -1.157578e-02 4.644234e-01
      3723   402_3191113 2013 invSimpson 2.926658e+00 -1.297603e-01 3.933919e-01
      3724   402_3191113 2013        PIE 6.620326e-01  1.770470e-03 9.318729e-01
      3725   402_3191113 2013      DomMc 6.741573e-01  3.263807e-02 7.087371e-02
      3726   402_3191113 2013 expShannon 5.206937e+00 -5.411088e-01 6.025480e-02
      3727   402_3191113 2010          S 1.600000e+01 -2.384615e+00 9.370671e-02
      3728   402_3191113 2010          N 1.890000e+02 -3.353846e+01 1.610139e-01
      3729   402_3191113 2010       maxN 9.100000e+01 -1.646154e+01 2.468243e-01
      3730   402_3191113 2010    Shannon 1.822060e+00 -1.181099e-01 7.377832e-02
      3731   402_3191113 2010    Simpson 7.279192e-01 -1.157578e-02 4.644234e-01
      3732   402_3191113 2010 invSimpson 3.675378e+00 -1.297603e-01 3.933919e-01
      3733   402_3191113 2010        PIE 7.317911e-01  1.770470e-03 9.318729e-01
      3734   402_3191113 2010      DomMc 6.296296e-01  3.263807e-02 7.087371e-02
      3735   402_3191113 2010 expShannon 6.184583e+00 -5.411088e-01 6.025480e-02
      3736   402_3191113 2012          S 1.500000e+01 -2.384615e+00 9.370671e-02
      3737   402_3191113 2012          N 1.550000e+02 -3.353846e+01 1.610139e-01
      3738   402_3191113 2012       maxN 9.300000e+01 -1.646154e+01 2.468243e-01
      3739   402_3191113 2012    Shannon 1.578298e+00 -1.181099e-01 7.377832e-02
      3740   402_3191113 2012    Simpson 6.196878e-01 -1.157578e-02 4.644234e-01
      3741   402_3191113 2012 invSimpson 2.629419e+00 -1.297603e-01 3.933919e-01
      3742   402_3191113 2012        PIE 6.237118e-01  1.770470e-03 9.318729e-01
      3743   402_3191113 2012      DomMc 6.774194e-01  3.263807e-02 7.087371e-02
      3744   402_3191113 2012 expShannon 4.846701e+00 -5.411088e-01 6.025480e-02
      3745   402_3191113 2015          S 4.000000e+00 -2.384615e+00 9.370671e-02
      3746   402_3191113 2015          N 1.000000e+01 -3.353846e+01 1.610139e-01
      3747   402_3191113 2015       maxN 4.000000e+00 -1.646154e+01 2.468243e-01
      3748   402_3191113 2015    Shannon 1.193550e+00 -1.181099e-01 7.377832e-02
      3749   402_3191113 2015    Simpson 6.600000e-01 -1.157578e-02 4.644234e-01
      3750   402_3191113 2015 invSimpson 2.941176e+00 -1.297603e-01 3.933919e-01
      3751   402_3191113 2015        PIE 7.333333e-01  1.770470e-03 9.318729e-01
      3752   402_3191113 2015      DomMc 8.000000e-01  3.263807e-02 7.087371e-02
      3753   402_3191113 2015 expShannon 3.298770e+00 -5.411088e-01 6.025480e-02
      3754   402_3190383 2010          S 1.300000e+01 -9.324324e-01 8.387741e-02
      3755   402_3190383 2010          N 9.800000e+01 -4.648649e+00 6.584549e-01
      3756   402_3190383 2010       maxN 3.100000e+01  3.337838e+00 6.144593e-01
      3757   402_3190383 2010    Shannon 1.906809e+00 -1.330294e-01 5.349953e-02
      3758   402_3190383 2010    Simpson 7.936277e-01 -4.575679e-02 7.113587e-02
      3759   402_3190383 2010 invSimpson 4.845610e+00 -6.113019e-01 1.480927e-01
      3760   402_3190383 2010        PIE 8.018094e-01 -4.550241e-02 7.232955e-02
      3761   402_3190383 2010      DomMc 5.918367e-01  4.610951e-02 2.255401e-01
      3762   402_3190383 2010 expShannon 6.731573e+00 -6.897410e-01 5.633234e-02
      3763   402_3190383 2012          S 1.000000e+01 -9.324324e-01 8.387741e-02
      3764   402_3190383 2012          N 8.100000e+01 -4.648649e+00 6.584549e-01
      3765   402_3190383 2012       maxN 1.900000e+01  3.337838e+00 6.144593e-01
      3766   402_3190383 2012    Shannon 1.985181e+00 -1.330294e-01 5.349953e-02
      3767   402_3190383 2012    Simpson 8.416400e-01 -4.575679e-02 7.113587e-02
      3768   402_3190383 2012 invSimpson 6.314726e+00 -6.113019e-01 1.480927e-01
      3769   402_3190383 2012        PIE 8.521605e-01 -4.550241e-02 7.232955e-02
      3770   402_3190383 2012      DomMc 4.197531e-01  4.610951e-02 2.255401e-01
      3771   402_3190383 2012 expShannon 7.280364e+00 -6.897410e-01 5.633234e-02
      3772   402_3190383 2013          S 1.000000e+01 -9.324324e-01 8.387741e-02
      3773   402_3190383 2013          N 1.340000e+02 -4.648649e+00 6.584549e-01
      3774   402_3190383 2013       maxN 6.700000e+01  3.337838e+00 6.144593e-01
      3775   402_3190383 2013    Shannon 1.642011e+00 -1.330294e-01 5.349953e-02
      3776   402_3190383 2013    Simpson 7.069503e-01 -4.575679e-02 7.113587e-02
      3777   402_3190383 2013 invSimpson 3.412391e+00 -6.113019e-01 1.480927e-01
      3778   402_3190383 2013        PIE 7.122657e-01 -4.550241e-02 7.232955e-02
      3779   402_3190383 2013      DomMc 6.194030e-01  4.610951e-02 2.255401e-01
      3780   402_3190383 2013 expShannon 5.165548e+00 -6.897410e-01 5.633234e-02
      3781   402_3190383 2014          S 1.100000e+01 -9.324324e-01 8.387741e-02
      3782   402_3190383 2014          N 1.150000e+02 -4.648649e+00 6.584549e-01
      3783   402_3190383 2014       maxN 6.000000e+01  3.337838e+00 6.144593e-01
      3784   402_3190383 2014    Shannon 1.569200e+00 -1.330294e-01 5.349953e-02
      3785   402_3190383 2014    Simpson 6.772023e-01 -4.575679e-02 7.113587e-02
      3786   402_3190383 2014 invSimpson 3.097915e+00 -6.113019e-01 1.480927e-01
      3787   402_3190383 2014        PIE 6.831426e-01 -4.550241e-02 7.232955e-02
      3788   402_3190383 2014      DomMc 7.130435e-01  4.610951e-02 2.255401e-01
      3789   402_3190383 2014 expShannon 4.802805e+00 -6.897410e-01 5.633234e-02
      3790   402_3190383 2015          S 7.000000e+00 -9.324324e-01 8.387741e-02
      3791   402_3190383 2015          N 4.800000e+01 -4.648649e+00 6.584549e-01
      3792   402_3190383 2015       maxN 3.000000e+01  3.337838e+00 6.144593e-01
      3793   402_3190383 2015    Shannon 1.248605e+00 -1.330294e-01 5.349953e-02
      3794   402_3190383 2015    Simpson 5.746528e-01 -4.575679e-02 7.113587e-02
      3795   402_3190383 2015 invSimpson 2.351020e+00 -6.113019e-01 1.480927e-01
      3796   402_3190383 2015        PIE 5.868794e-01 -4.550241e-02 7.232955e-02
      3797   402_3190383 2015      DomMc 7.708333e-01  4.610951e-02 2.255401e-01
      3798   402_3190383 2015 expShannon 3.485478e+00 -6.897410e-01 5.633234e-02
      3799   431_5117859 2004          S 4.000000e+00 -3.600000e-01 2.020410e-02
      3800   431_5117859 2004          N 5.900000e+01 -1.354000e+01 1.330038e-01
      3801   431_5117859 2004       maxN 4.000000e+01 -8.400000e+00 1.183744e-01
      3802   431_5117859 2004    Shannon 7.602526e-01 -2.203097e-02 3.631528e-02
      3803   431_5117859 2004    Simpson 4.567653e-01 -6.717352e-03 2.069334e-01
      3804   431_5117859 2004 invSimpson 1.840825e+00 -2.253805e-02 2.005777e-01
      3805   431_5117859 2004        PIE 4.646406e-01  1.122902e-02 5.713642e-01
      3806   431_5117859 2004      DomMc 9.661017e-01  4.181549e-03 3.933419e-02
      3807   431_5117859 2004 expShannon 2.138816e+00 -4.434505e-02 3.339358e-02
      3808   431_5117859 2003          S 5.000000e+00 -3.600000e-01 2.020410e-02
      3809   431_5117859 2003          N 1.490000e+02 -1.354000e+01 1.330038e-01
      3810   431_5117859 2003       maxN 9.200000e+01 -8.400000e+00 1.183744e-01
      3811   431_5117859 2003    Shannon 7.904140e-01 -2.203097e-02 3.631528e-02
      3812   431_5117859 2003    Simpson 4.919598e-01 -6.717352e-03 2.069334e-01
      3813   431_5117859 2003 invSimpson 1.968348e+00 -2.253805e-02 2.005777e-01
      3814   431_5117859 2003        PIE 4.952839e-01  1.122902e-02 5.713642e-01
      3815   431_5117859 2003      DomMc 9.731544e-01  4.181549e-03 3.933419e-02
      3816   431_5117859 2003 expShannon 2.204309e+00 -4.434505e-02 3.339358e-02
      3817   431_5117859 2010          S 2.000000e+00 -3.600000e-01 2.020410e-02
      3818   431_5117859 2010          N 2.800000e+01 -1.354000e+01 1.330038e-01
      3819   431_5117859 2010       maxN 2.000000e+01 -8.400000e+00 1.183744e-01
      3820   431_5117859 2010    Shannon 5.982696e-01 -2.203097e-02 3.631528e-02
      3821   431_5117859 2010    Simpson 4.081633e-01 -6.717352e-03 2.069334e-01
      3822   431_5117859 2010 invSimpson 1.689655e+00 -2.253805e-02 2.005777e-01
      3823   431_5117859 2010        PIE 4.232804e-01  1.122902e-02 5.713642e-01
      3824   431_5117859 2010      DomMc 1.000000e+00  4.181549e-03 3.933419e-02
      3825   431_5117859 2010 expShannon 1.818969e+00 -4.434505e-02 3.339358e-02
      3826   431_5117859 2011          S 2.000000e+00 -3.600000e-01 2.020410e-02
      3827   431_5117859 2011          N 3.000000e+00 -1.354000e+01 1.330038e-01
      3828   431_5117859 2011       maxN 2.000000e+00 -8.400000e+00 1.183744e-01
      3829   431_5117859 2011    Shannon 6.365142e-01 -2.203097e-02 3.631528e-02
      3830   431_5117859 2011    Simpson 4.444444e-01 -6.717352e-03 2.069334e-01
      3831   431_5117859 2011 invSimpson 1.800000e+00 -2.253805e-02 2.005777e-01
      3832   431_5117859 2011        PIE 6.666667e-01  1.122902e-02 5.713642e-01
      3833   431_5117859 2011      DomMc 1.000000e+00  4.181549e-03 3.933419e-02
      3834   431_5117859 2011 expShannon 1.889882e+00 -4.434505e-02 3.339358e-02
      3835   431_5122228 2011          S 2.000000e+00 -3.227848e-01 1.888454e-01
      3836   431_5122228 2011          N 3.480000e+02  2.255063e+01 5.723268e-01
      3837   431_5122228 2011       maxN 3.460000e+02  2.537342e+01 5.243762e-01
      3838   431_5122228 2011    Shannon 3.538032e-02 -1.017105e-01 2.161702e-01
      3839   431_5122228 2011    Simpson 1.142819e-02 -5.283282e-02 3.608660e-01
      3840   431_5122228 2011 invSimpson 1.011560e+00 -1.473731e-01 2.299031e-01
      3841   431_5122228 2011        PIE 1.146113e-02 -4.135816e-02 7.205173e-01
      3842   431_5122228 2011      DomMc 1.000000e+00  1.698867e-02 1.888454e-01
      3843   431_5122228 2011 expShannon 1.036014e+00 -1.990256e-01 1.181983e-01
      3844   431_5122228 2001          S 5.000000e+00 -3.227848e-01 1.888454e-01
      3845   431_5122228 2001          N 5.700000e+01  2.255063e+01 5.723268e-01
      3846   431_5122228 2001       maxN 2.900000e+01  2.537342e+01 5.243762e-01
      3847   431_5122228 2001    Shannon 1.135459e+00 -1.017105e-01 2.161702e-01
      3848   431_5122228 2001    Simpson 6.174207e-01 -5.283282e-02 3.608660e-01
      3849   431_5122228 2001 invSimpson 2.613837e+00 -1.473731e-01 2.299031e-01
      3850   431_5122228 2001        PIE 6.284461e-01 -4.135816e-02 7.205173e-01
      3851   431_5122228 2001      DomMc 8.421053e-01  1.698867e-02 1.888454e-01
      3852   431_5122228 2001 expShannon 3.112601e+00 -1.990256e-01 1.181983e-01
      3853   431_5122228 2008          S 2.000000e+00 -3.227848e-01 1.888454e-01
      3854   431_5122228 2008          N 2.000000e+00  2.255063e+01 5.723268e-01
      3855   431_5122228 2008       maxN 1.000000e+00  2.537342e+01 5.243762e-01
      3856   431_5122228 2008    Shannon 6.931472e-01 -1.017105e-01 2.161702e-01
      3857   431_5122228 2008    Simpson 5.000000e-01 -5.283282e-02 3.608660e-01
      3858   431_5122228 2008 invSimpson 2.000000e+00 -1.473731e-01 2.299031e-01
      3859   431_5122228 2008        PIE 1.000000e+00 -4.135816e-02 7.205173e-01
      3860   431_5122228 2008      DomMc 1.000000e+00  1.698867e-02 1.888454e-01
      3861   431_5122228 2008 expShannon 2.000000e+00 -1.990256e-01 1.181983e-01
      3862   431_5102575 1994          S 4.000000e+00  3.126241e-13 1.000000e+00
      3863   431_5102575 1994          N 4.500000e+01 -2.000000e+00 9.268136e-01
      3864   431_5102575 1994       maxN 4.000000e+01  1.000000e+00 9.655755e-01
      3865   431_5102575 1994    Shannon 4.544177e-01 -1.031543e-01 7.728255e-01
      3866   431_5102575 1994    Simpson 2.044444e-01 -7.819250e-02 7.631795e-01
      3867   431_5102575 1994 invSimpson 1.256983e+00 -4.010291e-01 6.259528e-01
      3868   431_5102575 1994        PIE 2.090909e-01 -7.814857e-02 7.831450e-01
      3869   431_5102575 1994      DomMc 9.555556e-01  1.131222e-02 8.975622e-01
      3870   431_5102575 1994 expShannon 1.575256e+00 -2.628729e-01 7.236414e-01
      3871   431_5102575 1995          S 3.000000e+00  3.126241e-13 1.000000e+00
      3872   431_5102575 1995          N 1.300000e+01 -2.000000e+00 9.268136e-01
      3873   431_5102575 1995       maxN 9.000000e+00  1.000000e+00 9.655755e-01
      3874   431_5102575 1995    Shannon 8.305178e-01 -1.031543e-01 7.728255e-01
      3875   431_5102575 1995    Simpson 4.733728e-01 -7.819250e-02 7.631795e-01
      3876   431_5102575 1995 invSimpson 1.898876e+00 -4.010291e-01 6.259528e-01
      3877   431_5102575 1995        PIE 5.128205e-01 -7.814857e-02 7.831450e-01
      3878   431_5102575 1995      DomMc 8.461538e-01  1.131222e-02 8.975622e-01
      3879   431_5102575 1995 expShannon 2.294507e+00 -2.628729e-01 7.236414e-01
      3880   431_5102575 1993          S 3.000000e+00  3.126241e-13 1.000000e+00
      3881   431_5102575 1993          N 1.700000e+01 -2.000000e+00 9.268136e-01
      3882   431_5102575 1993       maxN 7.000000e+00  1.000000e+00 9.655755e-01
      3883   431_5102575 1993    Shannon 1.036826e+00 -1.031543e-01 7.728255e-01
      3884   431_5102575 1993    Simpson 6.297578e-01 -7.819250e-02 7.631795e-01
      3885   431_5102575 1993 invSimpson 2.700935e+00 -4.010291e-01 6.259528e-01
      3886   431_5102575 1993        PIE 6.691176e-01 -7.814857e-02 7.831450e-01
      3887   431_5102575 1993      DomMc 8.235294e-01  1.131222e-02 8.975622e-01
      3888   431_5102575 1993 expShannon 2.820252e+00 -2.628729e-01 7.236414e-01
      3889   431_4748960 1996          S 2.000000e+00  5.881691e-17 3.401639e-01
      3890   431_4748960 1996          N 3.000000e+00 -3.504673e-01 7.134482e-01
      3891   431_4748960 1996       maxN 2.000000e+00 -3.504673e-01 7.134482e-01
      3892   431_4748960 1996    Shannon 6.365142e-01  1.301341e-02 6.977955e-01
      3893   431_4748960 1996    Simpson 4.444444e-01  1.107826e-02 6.906157e-01
      3894   431_4748960 1996 invSimpson 1.800000e+00  2.655305e-02 6.623385e-01
      3895   431_4748960 1996        PIE 6.666667e-01  2.870494e-02 6.173438e-01
      3896   431_4748960 1996      DomMc 1.000000e+00  2.940845e-17 3.401639e-01
      3897   431_4748960 1996 expShannon 1.889882e+00  2.135333e-02 6.890581e-01
      3898   431_4748960 1997          S 2.000000e+00  5.881691e-17 3.401639e-01
      3899   431_4748960 1997          N 3.000000e+00 -3.504673e-01 7.134482e-01
      3900   431_4748960 1997       maxN 2.000000e+00 -3.504673e-01 7.134482e-01
      3901   431_4748960 1997    Shannon 6.365142e-01  1.301341e-02 6.977955e-01
      3902   431_4748960 1997    Simpson 4.444444e-01  1.107826e-02 6.906157e-01
      3903   431_4748960 1997 invSimpson 1.800000e+00  2.655305e-02 6.623385e-01
      3904   431_4748960 1997        PIE 6.666667e-01  2.870494e-02 6.173438e-01
      3905   431_4748960 1997      DomMc 1.000000e+00  2.940845e-17 3.401639e-01
      3906   431_4748960 1997 expShannon 1.889882e+00  2.135333e-02 6.890581e-01
      3907   431_4748960 1998          S 2.000000e+00  5.881691e-17 3.401639e-01
      3908   431_4748960 1998          N 1.400000e+01 -3.504673e-01 7.134482e-01
      3909   431_4748960 1998       maxN 1.300000e+01 -3.504673e-01 7.134482e-01
      3910   431_4748960 1998    Shannon 2.573186e-01  1.301341e-02 6.977955e-01
      3911   431_4748960 1998    Simpson 1.326531e-01  1.107826e-02 6.906157e-01
      3912   431_4748960 1998 invSimpson 1.152941e+00  2.655305e-02 6.623385e-01
      3913   431_4748960 1998        PIE 1.428571e-01  2.870494e-02 6.173438e-01
      3914   431_4748960 1998      DomMc 1.000000e+00  2.940845e-17 3.401639e-01
      3915   431_4748960 1998 expShannon 1.293457e+00  2.135333e-02 6.890581e-01
      3916   431_4748960 2001          S 2.000000e+00  5.881691e-17 3.401639e-01
      3917   431_4748960 2001          N 2.000000e+00 -3.504673e-01 7.134482e-01
      3918   431_4748960 2001       maxN 1.000000e+00 -3.504673e-01 7.134482e-01
      3919   431_4748960 2001    Shannon 6.931472e-01  1.301341e-02 6.977955e-01
      3920   431_4748960 2001    Simpson 5.000000e-01  1.107826e-02 6.906157e-01
      3921   431_4748960 2001 invSimpson 2.000000e+00  2.655305e-02 6.623385e-01
      3922   431_4748960 2001        PIE 1.000000e+00  2.870494e-02 6.173438e-01
      3923   431_4748960 2001      DomMc 1.000000e+00  2.940845e-17 3.401639e-01
      3924   431_4748960 2001 expShannon 2.000000e+00  2.135333e-02 6.890581e-01
      3925   431_4748960 2004          S 2.000000e+00  5.881691e-17 3.401639e-01
      3926   431_4748960 2004          N 3.000000e+00 -3.504673e-01 7.134482e-01
      3927   431_4748960 2004       maxN 2.000000e+00 -3.504673e-01 7.134482e-01
      3928   431_4748960 2004    Shannon 6.365142e-01  1.301341e-02 6.977955e-01
      3929   431_4748960 2004    Simpson 4.444444e-01  1.107826e-02 6.906157e-01
      3930   431_4748960 2004 invSimpson 1.800000e+00  2.655305e-02 6.623385e-01
      3931   431_4748960 2004        PIE 6.666667e-01  2.870494e-02 6.173438e-01
      3932   431_4748960 2004      DomMc 1.000000e+00  2.940845e-17 3.401639e-01
      3933   431_4748960 2004 expShannon 1.889882e+00  2.135333e-02 6.890581e-01
      3934   431_5120046 1989          S 2.000000e+00 -1.495155e-17 1.279724e-01
      3935   431_5120046 1989          N 3.000000e+00  2.225914e-01 6.402181e-01
      3936   431_5120046 1989       maxN 2.000000e+00  1.661130e-01 7.103158e-01
      3937   431_5120046 1989    Shannon 6.365142e-01 -1.572560e-03 9.049260e-01
      3938   431_5120046 1989    Simpson 4.444444e-01 -1.326219e-03 9.123009e-01
      3939   431_5120046 1989 invSimpson 1.800000e+00 -2.176756e-03 9.466042e-01
      3940   431_5120046 1989        PIE 6.666667e-01 -8.748616e-03 6.759424e-01
      3941   431_5120046 1989      DomMc 1.000000e+00 -7.475777e-18 1.279724e-01
      3942   431_5120046 1989 expShannon 1.889882e+00 -2.491704e-03 9.148416e-01
      3943   431_5120046 2008          S 2.000000e+00 -1.495155e-17 1.279724e-01
      3944   431_5120046 2008          N 5.000000e+00  2.225914e-01 6.402181e-01
      3945   431_5120046 2008       maxN 3.000000e+00  1.661130e-01 7.103158e-01
      3946   431_5120046 2008    Shannon 6.730117e-01 -1.572560e-03 9.049260e-01
      3947   431_5120046 2008    Simpson 4.800000e-01 -1.326219e-03 9.123009e-01
      3948   431_5120046 2008 invSimpson 1.923077e+00 -2.176756e-03 9.466042e-01
      3949   431_5120046 2008        PIE 6.000000e-01 -8.748616e-03 6.759424e-01
      3950   431_5120046 2008      DomMc 1.000000e+00 -7.475777e-18 1.279724e-01
      3951   431_5120046 2008 expShannon 1.960132e+00 -2.491704e-03 9.148416e-01
      3952   431_5120046 2004          S 2.000000e+00 -1.495155e-17 1.279724e-01
      3953   431_5120046 2004          N 1.100000e+01  2.225914e-01 6.402181e-01
      3954   431_5120046 2004       maxN 9.000000e+00  1.661130e-01 7.103158e-01
      3955   431_5120046 2004    Shannon 4.741393e-01 -1.572560e-03 9.049260e-01
      3956   431_5120046 2004    Simpson 2.975207e-01 -1.326219e-03 9.123009e-01
      3957   431_5120046 2004 invSimpson 1.423529e+00 -2.176756e-03 9.466042e-01
      3958   431_5120046 2004        PIE 3.272727e-01 -8.748616e-03 6.759424e-01
      3959   431_5120046 2004      DomMc 1.000000e+00 -7.475777e-18 1.279724e-01
      3960   431_5120046 2004 expShannon 1.606631e+00 -2.491704e-03 9.148416e-01
      3961   431_5132431 2009          S 3.000000e+00  3.162349e-17 7.145180e-01
      3962   431_5132431 2009          N 6.000000e+00  2.255639e-02 9.521487e-01
      3963   431_5132431 2009       maxN 4.000000e+00  9.774436e-02 6.188153e-01
      3964   431_5132431 2009    Shannon 8.675632e-01 -5.188308e-03 5.767704e-01
      3965   431_5132431 2009    Simpson 5.000000e-01 -5.173872e-03 4.832167e-01
      3966   431_5132431 2009 invSimpson 2.000000e+00 -2.657868e-02 4.477685e-01
      3967   431_5132431 2009        PIE 6.000000e-01 -5.707722e-03 2.247661e-01
      3968   431_5132431 2009      DomMc 8.333333e-01 -5.231830e-03 2.446987e-01
      3969   431_5132431 2009 expShannon 2.381102e+00 -1.316067e-02 5.704703e-01
      3970   431_5132431 2010          S 3.000000e+00  3.162349e-17 7.145180e-01
      3971   431_5132431 2010          N 1.000000e+01  2.255639e-02 9.521487e-01
      3972   431_5132431 2010       maxN 6.000000e+00  9.774436e-02 6.188153e-01
      3973   431_5132431 2010    Shannon 9.502705e-01 -5.188308e-03 5.767704e-01
      3974   431_5132431 2010    Simpson 5.600000e-01 -5.173872e-03 4.832167e-01
      3975   431_5132431 2010 invSimpson 2.272727e+00 -2.657868e-02 4.477685e-01
      3976   431_5132431 2010        PIE 6.222222e-01 -5.707722e-03 2.247661e-01
      3977   431_5132431 2010      DomMc 8.000000e-01 -5.231830e-03 2.446987e-01
      3978   431_5132431 2010 expShannon 2.586409e+00 -1.316067e-02 5.704703e-01
      3979   431_5132431 1998          S 3.000000e+00  3.162349e-17 7.145180e-01
      3980   431_5132431 1998          N 8.000000e+00  2.255639e-02 9.521487e-01
      3981   431_5132431 1998       maxN 4.000000e+00  9.774436e-02 6.188153e-01
      3982   431_5132431 1998    Shannon 9.743148e-01 -5.188308e-03 5.767704e-01
      3983   431_5132431 1998    Simpson 5.937500e-01 -5.173872e-03 4.832167e-01
      3984   431_5132431 1998 invSimpson 2.461538e+00 -2.657868e-02 4.477685e-01
      3985   431_5132431 1998        PIE 6.785714e-01 -5.707722e-03 2.247661e-01
      3986   431_5132431 1998      DomMc 8.750000e-01 -5.231830e-03 2.446987e-01
      3987   431_5132431 1998 expShannon 2.649351e+00 -1.316067e-02 5.704703e-01
      3988   431_5133160 1998          S 2.000000e+00 -2.289023e-17 4.785132e-02
      3989   431_5133160 1998          N 1.100000e+01 -6.278195e-01 2.446987e-01
      3990   431_5133160 1998       maxN 1.000000e+01 -7.030075e-01 8.788589e-02
      3991   431_5133160 1998    Shannon 3.046361e-01  3.359306e-02 4.785132e-02
      3992   431_5133160 1998    Simpson 1.652893e-01  2.894115e-02 4.785132e-02
      3993   431_5133160 1998 invSimpson 1.198020e+00  6.934415e-02 4.785132e-02
      3994   431_5133160 1998        PIE 1.818182e-01  5.570745e-02 2.773146e-01
      3995   431_5133160 1998      DomMc 1.000000e+00 -1.144511e-17 4.785132e-02
      3996   431_5133160 1998 expShannon 1.356131e+00  5.567285e-02 4.785132e-02
      3997   431_5133160 2009          S 2.000000e+00 -2.289023e-17 4.785132e-02
      3998   431_5133160 2009          N 6.000000e+00 -6.278195e-01 2.446987e-01
      3999   431_5133160 2009       maxN 3.000000e+00 -7.030075e-01 8.788589e-02
      4000   431_5133160 2009    Shannon 6.931472e-01  3.359306e-02 4.785132e-02
      4001   431_5133160 2009    Simpson 5.000000e-01  2.894115e-02 4.785132e-02
      4002   431_5133160 2009 invSimpson 2.000000e+00  6.934415e-02 4.785132e-02
      4003   431_5133160 2009        PIE 6.000000e-01  5.570745e-02 2.773146e-01
      4004   431_5133160 2009      DomMc 1.000000e+00 -1.144511e-17 4.785132e-02
      4005   431_5133160 2009 expShannon 2.000000e+00  5.567285e-02 4.785132e-02
      4006   431_5133160 2010          S 2.000000e+00 -2.289023e-17 4.785132e-02
      4007   431_5133160 2010          N 2.000000e+00 -6.278195e-01 2.446987e-01
      4008   431_5133160 2010       maxN 1.000000e+00 -7.030075e-01 8.788589e-02
      4009   431_5133160 2010    Shannon 6.931472e-01  3.359306e-02 4.785132e-02
      4010   431_5133160 2010    Simpson 5.000000e-01  2.894115e-02 4.785132e-02
      4011   431_5133160 2010 invSimpson 2.000000e+00  6.934415e-02 4.785132e-02
      4012   431_5133160 2010        PIE 1.000000e+00  5.570745e-02 2.773146e-01
      4013   431_5133160 2010      DomMc 1.000000e+00 -1.144511e-17 4.785132e-02
      4014   431_5133160 2010 expShannon 2.000000e+00  5.567285e-02 4.785132e-02
      4015   431_5132432 2003          S 5.000000e+00 -3.918919e-01 8.248060e-02
      4016   431_5132432 2003          N 7.700000e+01 -2.235135e+01 2.921352e-01
      4017   431_5132432 2003       maxN 3.000000e+01 -1.062162e+01 3.658791e-01
      4018   431_5132432 2003    Shannon 1.198932e+00 -5.499500e-02 1.821229e-01
      4019   431_5132432 2003    Simpson 6.770113e-01 -2.723119e-02 1.018434e-01
      4020   431_5132432 2003 invSimpson 3.096084e+00 -1.441369e-01 1.561128e-01
      4021   431_5132432 2003        PIE 6.859193e-01 -1.738479e-02 2.293124e-01
      4022   431_5132432 2003      DomMc 6.883117e-01  2.363930e-02 3.918893e-01
      4023   431_5132432 2003 expShannon 3.316574e+00 -1.404026e-01 1.899661e-01
      4024   431_5132432 2010          S 3.000000e+00 -3.918919e-01 8.248060e-02
      4025   431_5132432 2010          N 1.000000e+01 -2.235135e+01 2.921352e-01
      4026   431_5132432 2010       maxN 7.000000e+00 -1.062162e+01 3.658791e-01
      4027   431_5132432 2010    Shannon 8.018186e-01 -5.499500e-02 1.821229e-01
      4028   431_5132432 2010    Simpson 4.600000e-01 -2.723119e-02 1.018434e-01
      4029   431_5132432 2010 invSimpson 1.851852e+00 -1.441369e-01 1.561128e-01
      4030   431_5132432 2010        PIE 5.111111e-01 -1.738479e-02 2.293124e-01
      4031   431_5132432 2010      DomMc 9.000000e-01  2.363930e-02 3.918893e-01
      4032   431_5132432 2010 expShannon 2.229592e+00 -1.404026e-01 1.899661e-01
      4033   431_5132432 2004          S 5.000000e+00 -3.918919e-01 8.248060e-02
      4034   431_5132432 2004          N 2.430000e+02 -2.235135e+01 2.921352e-01
      4035   431_5132432 2004       maxN 1.290000e+02 -1.062162e+01 3.658791e-01
      4036   431_5132432 2004    Shannon 8.944807e-01 -5.499500e-02 1.821229e-01
      4037   431_5132432 2004    Simpson 5.436502e-01 -2.723119e-02 1.018434e-01
      4038   431_5132432 2004 invSimpson 2.191301e+00 -1.441369e-01 1.561128e-01
      4039   431_5132432 2004        PIE 5.458967e-01 -1.738479e-02 2.293124e-01
      4040   431_5132432 2004      DomMc 9.465021e-01  2.363930e-02 3.918893e-01
      4041   431_5132432 2004 expShannon 2.446065e+00 -1.404026e-01 1.899661e-01
      4042   431_5132432 2009          S 2.000000e+00 -3.918919e-01 8.248060e-02
      4043   431_5132432 2009          N 6.000000e+00 -2.235135e+01 2.921352e-01
      4044   431_5132432 2009       maxN 4.000000e+00 -1.062162e+01 3.658791e-01
      4045   431_5132432 2009    Shannon 6.365142e-01 -5.499500e-02 1.821229e-01
      4046   431_5132432 2009    Simpson 4.444444e-01 -2.723119e-02 1.018434e-01
      4047   431_5132432 2009 invSimpson 1.800000e+00 -1.441369e-01 1.561128e-01
      4048   431_5132432 2009        PIE 5.333333e-01 -1.738479e-02 2.293124e-01
      4049   431_5132432 2009      DomMc 1.000000e+00  2.363930e-02 3.918893e-01
      4050   431_5132432 2009 expShannon 1.889882e+00 -1.404026e-01 1.899661e-01
      4051   431_4744569 1996          S 2.000000e+00 -1.509050e-17 3.147883e-02
      4052   431_4744569 1996          N 1.800000e+01  1.193811e+00 7.097511e-01
      4053   431_4744569 1996       maxN 1.300000e+01  1.032573e+00 7.237748e-01
      4054   431_4744569 1996    Shannon 5.908422e-01 -2.401615e-03 8.631832e-01
      4055   431_4744569 1996    Simpson 4.012346e-01 -1.953304e-03 8.749459e-01
      4056   431_4744569 1996 invSimpson 1.670103e+00 -3.008283e-03 9.217031e-01
      4057   431_4744569 1996        PIE 4.248366e-01 -2.309322e-03 8.687789e-01
      4058   431_4744569 1996      DomMc 1.000000e+00 -7.545249e-18 3.147883e-02
      4059   431_4744569 1996 expShannon 1.805508e+00 -3.656989e-03 8.782062e-01
      4060   431_4744569 2013          S 2.000000e+00 -1.509050e-17 3.147883e-02
      4061   431_4744569 2013          N 6.500000e+01  1.193811e+00 7.097511e-01
      4062   431_4744569 2013       maxN 5.500000e+01  1.032573e+00 7.237748e-01
      4063   431_4744569 2013    Shannon 4.293230e-01 -2.401615e-03 8.631832e-01
      4064   431_4744569 2013    Simpson 2.603550e-01 -1.953304e-03 8.749459e-01
      4065   431_4744569 2013 invSimpson 1.352000e+00 -3.008283e-03 9.217031e-01
      4066   431_4744569 2013        PIE 2.644231e-01 -2.309322e-03 8.687789e-01
      4067   431_4744569 2013      DomMc 1.000000e+00 -7.545249e-18 3.147883e-02
      4068   431_4744569 2013 expShannon 1.536217e+00 -3.656989e-03 8.782062e-01
      4069   431_4744569 2014          S 2.000000e+00 -1.509050e-17 3.147883e-02
      4070   431_4744569 2014          N 1.700000e+01  1.193811e+00 7.097511e-01
      4071   431_4744569 2014       maxN 1.100000e+01  1.032573e+00 7.237748e-01
      4072   431_4744569 2014    Shannon 6.492484e-01 -2.401615e-03 8.631832e-01
      4073   431_4744569 2014    Simpson 4.567474e-01 -1.953304e-03 8.749459e-01
      4074   431_4744569 2014 invSimpson 1.840764e+00 -3.008283e-03 9.217031e-01
      4075   431_4744569 2014        PIE 4.852941e-01 -2.309322e-03 8.687789e-01
      4076   431_4744569 2014      DomMc 1.000000e+00 -7.545249e-18 3.147883e-02
      4077   431_4744569 2014 expShannon 1.914102e+00 -3.656989e-03 8.782062e-01
      4078   431_5104025 2012          S 2.000000e+00  4.048583e-02 5.609407e-01
      4079   431_5104025 2012          N 4.000000e+00  2.874494e-01 3.486451e-01
      4080   431_5104025 2012       maxN 3.000000e+00  2.469636e-01 3.007937e-01
      4081   431_5104025 2012    Shannon 5.623351e-01 -1.193193e-03 9.235022e-01
      4082   431_5104025 2012    Simpson 3.750000e-01 -6.578947e-03 2.601469e-01
      4083   431_5104025 2012 invSimpson 1.600000e+00 -2.169188e-02 2.336984e-01
      4084   431_5104025 2012        PIE 5.000000e-01 -3.282244e-02 6.774841e-02
      4085   431_5104025 2012      DomMc 1.000000e+00 -5.060729e-03 5.609407e-01
      4086   431_5104025 2012 expShannon 1.754765e+00 -1.947353e-03 9.345574e-01
      4087   431_5104025 2015          S 3.000000e+00  4.048583e-02 5.609407e-01
      4088   431_5104025 2015          N 8.000000e+00  2.874494e-01 3.486451e-01
      4089   431_5104025 2015       maxN 6.000000e+00  2.469636e-01 3.007937e-01
      4090   431_5104025 2015    Shannon 7.356219e-01 -1.193193e-03 9.235022e-01
      4091   431_5104025 2015    Simpson 4.062500e-01 -6.578947e-03 2.601469e-01
      4092   431_5104025 2015 invSimpson 1.684211e+00 -2.169188e-02 2.336984e-01
      4093   431_5104025 2015        PIE 4.642857e-01 -3.282244e-02 6.774841e-02
      4094   431_5104025 2015      DomMc 8.750000e-01 -5.060729e-03 5.609407e-01
      4095   431_5104025 2015 expShannon 2.086779e+00 -1.947353e-03 9.345574e-01
      4096   431_5104025 1998          S 2.000000e+00  4.048583e-02 5.609407e-01
      4097   431_5104025 1998          N 2.000000e+00  2.874494e-01 3.486451e-01
      4098   431_5104025 1998       maxN 1.000000e+00  2.469636e-01 3.007937e-01
      4099   431_5104025 1998    Shannon 6.931472e-01 -1.193193e-03 9.235022e-01
      4100   431_5104025 1998    Simpson 5.000000e-01 -6.578947e-03 2.601469e-01
      4101   431_5104025 1998 invSimpson 2.000000e+00 -2.169188e-02 2.336984e-01
      4102   431_5104025 1998        PIE 1.000000e+00 -3.282244e-02 6.774841e-02
      4103   431_5104025 1998      DomMc 1.000000e+00 -5.060729e-03 5.609407e-01
      4104   431_5104025 1998 expShannon 2.000000e+00 -1.947353e-03 9.345574e-01
      4105   431_5122229 1992          S 2.000000e+00 -5.943536e-03 8.614569e-01
      4106   431_5122229 1992          N 1.000000e+01 -5.626300e+00 8.701007e-01
      4107   431_5122229 1992       maxN 9.000000e+00 -5.296434e+00 8.664142e-01
      4108   431_5122229 1992    Shannon 3.250830e-01  1.350244e-02 2.343495e-01
      4109   431_5122229 1992    Simpson 1.800000e-01  1.137118e-02 2.610702e-01
      4110   431_5122229 1992 invSimpson 1.219512e+00  2.428825e-02 3.182951e-01
      4111   431_5122229 1992        PIE 2.000000e-01  1.239741e-02 3.271961e-01
      4112   431_5122229 1992      DomMc 1.000000e+00  2.902117e-05 8.614569e-01
      4113   431_5122229 1992 expShannon 1.384145e+00  2.158658e-02 2.554496e-01
      4114   431_5122229 2004          S 3.000000e+00 -5.943536e-03 8.614569e-01
      4115   431_5122229 2004          N 1.024000e+03 -5.626300e+00 8.701007e-01
      4116   431_5122229 2004       maxN 9.350000e+02 -5.296434e+00 8.664142e-01
      4117   431_5122229 2004    Shannon 3.141409e-01  1.350244e-02 2.343495e-01
      4118   431_5122229 2004    Simpson 1.595211e-01  1.137118e-02 2.610702e-01
      4119   431_5122229 2004 invSimpson 1.189798e+00  2.428825e-02 3.182951e-01
      4120   431_5122229 2004        PIE 1.596770e-01  1.239741e-02 3.271961e-01
      4121   431_5122229 2004      DomMc 9.951172e-01  2.902117e-05 8.614569e-01
      4122   431_5122229 2004 expShannon 1.369083e+00  2.158658e-02 2.554496e-01
      4123   431_5122229 2009          S 2.000000e+00 -5.943536e-03 8.614569e-01
      4124   431_5122229 2009          N 6.000000e+00 -5.626300e+00 8.701007e-01
      4125   431_5122229 2009       maxN 3.000000e+00 -5.296434e+00 8.664142e-01
      4126   431_5122229 2009    Shannon 6.931472e-01  1.350244e-02 2.343495e-01
      4127   431_5122229 2009    Simpson 5.000000e-01  1.137118e-02 2.610702e-01
      4128   431_5122229 2009 invSimpson 2.000000e+00  2.428825e-02 3.182951e-01
      4129   431_5122229 2009        PIE 6.000000e-01  1.239741e-02 3.271961e-01
      4130   431_5122229 2009      DomMc 1.000000e+00  2.902117e-05 8.614569e-01
      4131   431_5122229 2009 expShannon 2.000000e+00  2.158658e-02 2.554496e-01
      4132   431_5122229 2012          S 2.000000e+00 -5.943536e-03 8.614569e-01
      4133   431_5122229 2012          N 1.800000e+01 -5.626300e+00 8.701007e-01
      4134   431_5122229 2012       maxN 1.500000e+01 -5.296434e+00 8.664142e-01
      4135   431_5122229 2012    Shannon 4.505612e-01  1.350244e-02 2.343495e-01
      4136   431_5122229 2012    Simpson 2.777778e-01  1.137118e-02 2.610702e-01
      4137   431_5122229 2012 invSimpson 1.384615e+00  2.428825e-02 3.182951e-01
      4138   431_5122229 2012        PIE 2.941176e-01  1.239741e-02 3.271961e-01
      4139   431_5122229 2012      DomMc 1.000000e+00  2.902117e-05 8.614569e-01
      4140   431_5122229 2012 expShannon 1.569193e+00  2.158658e-02 2.554496e-01
      4141   431_5122229 2011          S 2.000000e+00 -5.943536e-03 8.614569e-01
      4142   431_5122229 2011          N 2.300000e+01 -5.626300e+00 8.701007e-01
      4143   431_5122229 2011       maxN 1.600000e+01 -5.296434e+00 8.664142e-01
      4144   431_5122229 2011    Shannon 6.145033e-01  1.350244e-02 2.343495e-01
      4145   431_5122229 2011    Simpson 4.234405e-01  1.137118e-02 2.610702e-01
      4146   431_5122229 2011 invSimpson 1.734426e+00  2.428825e-02 3.182951e-01
      4147   431_5122229 2011        PIE 4.426877e-01  1.239741e-02 3.271961e-01
      4148   431_5122229 2011      DomMc 1.000000e+00  2.902117e-05 8.614569e-01
      4149   431_5122229 2011 expShannon 1.848738e+00  2.158658e-02 2.554496e-01
      4150   431_5101115 2003          S 2.000000e+00  0.000000e+00          NaN
      4151   431_5101115 2003          N 3.000000e+00  6.860000e+00 8.762762e-01
      4152   431_5101115 2003       maxN 2.000000e+00  6.800000e+00 8.761998e-01
      4153   431_5101115 2003    Shannon 6.365142e-01 -3.863357e-02 5.545347e-01
      4154   431_5101115 2003    Simpson 4.444444e-01 -3.278320e-02 4.930581e-01
      4155   431_5101115 2003 invSimpson 1.800000e+00 -7.412521e-02 3.907878e-01
      4156   431_5101115 2003        PIE 6.666667e-01 -5.959347e-02 4.053756e-01
      4157   431_5101115 2003      DomMc 1.000000e+00  0.000000e+00          NaN
      4158   431_5101115 2003 expShannon 1.889882e+00 -6.308925e-02 4.983866e-01
      4159   431_5101115 2010          S 2.000000e+00  0.000000e+00          NaN
      4160   431_5101115 2010          N 8.000000e+00  6.860000e+00 8.762762e-01
      4161   431_5101115 2010       maxN 7.000000e+00  6.800000e+00 8.761998e-01
      4162   431_5101115 2010    Shannon 3.767702e-01 -3.863357e-02 5.545347e-01
      4163   431_5101115 2010    Simpson 2.187500e-01 -3.278320e-02 4.930581e-01
      4164   431_5101115 2010 invSimpson 1.280000e+00 -7.412521e-02 3.907878e-01
      4165   431_5101115 2010        PIE 2.500000e-01 -5.959347e-02 4.053756e-01
      4166   431_5101115 2010      DomMc 1.000000e+00  0.000000e+00          NaN
      4167   431_5101115 2010 expShannon 1.457569e+00 -6.308925e-02 4.983866e-01
      4168   431_5101115 2006          S 2.000000e+00  0.000000e+00          NaN
      4169   431_5101115 2006          N 2.300000e+01  6.860000e+00 8.762762e-01
      4170   431_5101115 2006       maxN 2.200000e+01  6.800000e+00 8.761998e-01
      4171   431_5101115 2006    Shannon 1.788449e-01 -3.863357e-02 5.545347e-01
      4172   431_5101115 2006    Simpson 8.317580e-02 -3.278320e-02 4.930581e-01
      4173   431_5101115 2006 invSimpson 1.090722e+00 -7.412521e-02 3.907878e-01
      4174   431_5101115 2006        PIE 8.695652e-02 -5.959347e-02 4.053756e-01
      4175   431_5101115 2006      DomMc 1.000000e+00  0.000000e+00          NaN
      4176   431_5101115 2006 expShannon 1.195835e+00 -6.308925e-02 4.983866e-01
      4177   431_5101115 2007          S 2.000000e+00  0.000000e+00          NaN
      4178   431_5101115 2007          N 3.310000e+02  6.860000e+00 8.762762e-01
      4179   431_5101115 2007       maxN 3.270000e+02  6.800000e+00 8.761998e-01
      4180   431_5101115 2007    Shannon 6.537471e-02 -3.863357e-02 5.545347e-01
      4181   431_5101115 2007    Simpson 2.387711e-02 -3.278320e-02 4.930581e-01
      4182   431_5101115 2007 invSimpson 1.024461e+00 -7.412521e-02 3.907878e-01
      4183   431_5101115 2007        PIE 2.394946e-02 -5.959347e-02 4.053756e-01
      4184   431_5101115 2007      DomMc 1.000000e+00  0.000000e+00          NaN
      4185   431_5101115 2007 expShannon 1.067559e+00 -6.308925e-02 4.983866e-01
      4186   431_4743109 2005          S 4.000000e+00 -6.382979e-02 7.049735e-01
      4187   431_4743109 2005          N 7.000000e+00  2.200000e+00 1.121830e-01
      4188   431_4743109 2005       maxN 3.000000e+00  1.178723e+00 5.159786e-02
      4189   431_4743109 2005    Shannon 1.277034e+00 -1.275651e-02 8.166125e-01
      4190   431_4743109 2005    Simpson 6.938776e-01 -2.298149e-03 9.147271e-01
      4191   431_4743109 2005 invSimpson 3.266667e+00 -3.285689e-02 7.889557e-01
      4192   431_4743109 2005        PIE 8.095238e-01 -1.924679e-02 2.988260e-01
      4193   431_4743109 2005      DomMc 7.142857e-01  3.343465e-03 8.995214e-01
      4194   431_4743109 2005 expShannon 3.585989e+00 -4.530987e-02 7.507870e-01
      4195   431_4743109 2006          S 2.000000e+00 -6.382979e-02 7.049735e-01
      4196   431_4743109 2006          N 3.000000e+00  2.200000e+00 1.121830e-01
      4197   431_4743109 2006       maxN 2.000000e+00  1.178723e+00 5.159786e-02
      4198   431_4743109 2006    Shannon 6.365142e-01 -1.275651e-02 8.166125e-01
      4199   431_4743109 2006    Simpson 4.444444e-01 -2.298149e-03 9.147271e-01
      4200   431_4743109 2006 invSimpson 1.800000e+00 -3.285689e-02 7.889557e-01
      4201   431_4743109 2006        PIE 6.666667e-01 -1.924679e-02 2.988260e-01
      4202   431_4743109 2006      DomMc 1.000000e+00  3.343465e-03 8.995214e-01
      4203   431_4743109 2006 expShannon 1.889882e+00 -4.530987e-02 7.507870e-01
      4204   431_4743109 2012          S 2.000000e+00 -6.382979e-02 7.049735e-01
      4205   431_4743109 2012          N 1.300000e+01  2.200000e+00 1.121830e-01
      4206   431_4743109 2012       maxN 8.000000e+00  1.178723e+00 5.159786e-02
      4207   431_4743109 2012    Shannon 6.662784e-01 -1.275651e-02 8.166125e-01
      4208   431_4743109 2012    Simpson 4.733728e-01 -2.298149e-03 9.147271e-01
      4209   431_4743109 2012 invSimpson 1.898876e+00 -3.285689e-02 7.889557e-01
      4210   431_4743109 2012        PIE 5.128205e-01 -1.924679e-02 2.988260e-01
      4211   431_4743109 2012      DomMc 1.000000e+00  3.343465e-03 8.995214e-01
      4212   431_4743109 2012 expShannon 1.946978e+00 -4.530987e-02 7.507870e-01
      4213   431_4743109 2014          S 3.000000e+00 -6.382979e-02 7.049735e-01
      4214   431_4743109 2014          N 2.800000e+01  2.200000e+00 1.121830e-01
      4215   431_4743109 2014       maxN 1.400000e+01  1.178723e+00 5.159786e-02
      4216   431_4743109 2014    Shannon 1.034601e+00 -1.275651e-02 8.166125e-01
      4217   431_4743109 2014    Simpson 6.224490e-01 -2.298149e-03 9.147271e-01
      4218   431_4743109 2014 invSimpson 2.648649e+00 -3.285689e-02 7.889557e-01
      4219   431_4743109 2014        PIE 6.455026e-01 -1.924679e-02 2.988260e-01
      4220   431_4743109 2014      DomMc 7.857143e-01  3.343465e-03 8.995214e-01
      4221   431_4743109 2014 expShannon 2.813984e+00 -4.530987e-02 7.507870e-01
      4222   431_4748231 1993          S 2.000000e+00 -9.454659e-17 2.122956e-01
      4223   431_4748231 1993          N 6.000000e+00  7.142857e-01 8.789623e-01
      4224   431_4748231 1993       maxN 5.000000e+00 -1.428571e-01 9.666168e-01
      4225   431_4748231 1993    Shannon 4.505612e-01  8.149065e-02 2.550556e-02
      4226   431_4748231 1993    Simpson 2.777778e-01  7.434276e-02 1.195402e-02
      4227   431_4748231 1993 invSimpson 1.384615e+00  2.021677e-01 4.834824e-02
      4228   431_4748231 1993        PIE 3.333333e-01  8.511905e-02 1.439998e-01
      4229   431_4748231 1993      DomMc 1.000000e+00 -4.727329e-17 2.122956e-01
      4230   431_4748231 1993 expShannon 1.569193e+00  1.439276e-01 7.471139e-03
      4231   431_4748231 1995          S 2.000000e+00 -9.454659e-17 2.122956e-01
      4232   431_4748231 1995          N 1.600000e+01  7.142857e-01 8.789623e-01
      4233   431_4748231 1995       maxN 1.100000e+01 -1.428571e-01 9.666168e-01
      4234   431_4748231 1995    Shannon 6.210864e-01  8.149065e-02 2.550556e-02
      4235   431_4748231 1995    Simpson 4.296875e-01  7.434276e-02 1.195402e-02
      4236   431_4748231 1995 invSimpson 1.753425e+00  2.021677e-01 4.834824e-02
      4237   431_4748231 1995        PIE 4.583333e-01  8.511905e-02 1.439998e-01
      4238   431_4748231 1995      DomMc 1.000000e+00 -4.727329e-17 2.122956e-01
      4239   431_4748231 1995 expShannon 1.860949e+00  1.439276e-01 7.471139e-03
      4240   431_4748231 1996          S 2.000000e+00 -9.454659e-17 2.122956e-01
      4241   431_4748231 1996          N 6.000000e+00  7.142857e-01 8.789623e-01
      4242   431_4748231 1996       maxN 3.000000e+00 -1.428571e-01 9.666168e-01
      4243   431_4748231 1996    Shannon 6.931472e-01  8.149065e-02 2.550556e-02
      4244   431_4748231 1996    Simpson 5.000000e-01  7.434276e-02 1.195402e-02
      4245   431_4748231 1996 invSimpson 2.000000e+00  2.021677e-01 4.834824e-02
      4246   431_4748231 1996        PIE 6.000000e-01  8.511905e-02 1.439998e-01
      4247   431_4748231 1996      DomMc 1.000000e+00 -4.727329e-17 2.122956e-01
      4248   431_4748231 1996 expShannon 2.000000e+00  1.439276e-01 7.471139e-03
      4249   431_5101846 1999          S 2.000000e+00 -4.132231e-02 5.454545e-01
      4250   431_5101846 1999          N 7.000000e+00 -1.035813e+00 2.725626e-01
      4251   431_5101846 1999       maxN 5.000000e+00 -8.787879e-01 2.678728e-01
      4252   431_5101846 1999    Shannon 5.982696e-01  1.590586e-03 8.692033e-01
      4253   431_5101846 1999    Simpson 4.081633e-01  3.776646e-03 7.390319e-01
      4254   431_5101846 1999 invSimpson 1.689655e+00  7.417455e-03 7.631893e-01
      4255   431_5101846 1999        PIE 4.761905e-01  5.838596e-03 6.856459e-01
      4256   431_5101846 1999      DomMc 1.000000e+00  2.430724e-03 5.454545e-01
      4257   431_5101846 1999 expShannon 1.818969e+00  2.673665e-03 8.702146e-01
      4258   431_5101846 2005          S 2.000000e+00 -4.132231e-02 5.454545e-01
      4259   431_5101846 2005          N 1.100000e+01 -1.035813e+00 2.725626e-01
      4260   431_5101846 2005       maxN 9.000000e+00 -8.787879e-01 2.678728e-01
      4261   431_5101846 2005    Shannon 4.741393e-01  1.590586e-03 8.692033e-01
      4262   431_5101846 2005    Simpson 2.975207e-01  3.776646e-03 7.390319e-01
      4263   431_5101846 2005 invSimpson 1.423529e+00  7.417455e-03 7.631893e-01
      4264   431_5101846 2005        PIE 3.272727e-01  5.838596e-03 6.856459e-01
      4265   431_5101846 2005      DomMc 1.000000e+00  2.430724e-03 5.454545e-01
      4266   431_5101846 2005 expShannon 1.606631e+00  2.673665e-03 8.702146e-01
      4267   431_5101846 1994          S 3.000000e+00 -4.132231e-02 5.454545e-01
      4268   431_5101846 1994          N 1.700000e+01 -1.035813e+00 2.725626e-01
      4269   431_5101846 1994       maxN 1.500000e+01 -8.787879e-01 2.678728e-01
      4270   431_5101846 1994    Shannon 4.437573e-01  1.590586e-03 8.692033e-01
      4271   431_5101846 1994    Simpson 2.145329e-01  3.776646e-03 7.390319e-01
      4272   431_5101846 1994 invSimpson 1.273128e+00  7.417455e-03 7.631893e-01
      4273   431_5101846 1994        PIE 2.279412e-01  5.838596e-03 6.856459e-01
      4274   431_5101846 1994      DomMc 9.411765e-01  2.430724e-03 5.454545e-01
      4275   431_5101846 1994 expShannon 1.558552e+00  2.673665e-03 8.702146e-01
      4276   431_5101846 1993          S 2.000000e+00 -4.132231e-02 5.454545e-01
      4277   431_5101846 1993          N 2.500000e+01 -1.035813e+00 2.725626e-01
      4278   431_5101846 1993       maxN 2.000000e+01 -8.787879e-01 2.678728e-01
      4279   431_5101846 1993    Shannon 5.004024e-01  1.590586e-03 8.692033e-01
      4280   431_5101846 1993    Simpson 3.200000e-01  3.776646e-03 7.390319e-01
      4281   431_5101846 1993 invSimpson 1.470588e+00  7.417455e-03 7.631893e-01
      4282   431_5101846 1993        PIE 3.333333e-01  5.838596e-03 6.856459e-01
      4283   431_5101846 1993      DomMc 1.000000e+00  2.430724e-03 5.454545e-01
      4284   431_5101846 1993 expShannon 1.649385e+00  2.673665e-03 8.702146e-01
      4285   431_5113493 2001          S 4.000000e+00  1.992883e-01 2.171477e-01
      4286   431_5113493 2001          N 2.020000e+02  1.017438e+01 6.489643e-01
      4287   431_5113493 2001       maxN 1.520000e+02  6.455516e+00 6.928084e-01
      4288   431_5113493 2001    Shannon 6.080326e-01  3.226336e-02 3.576511e-01
      4289   431_5113493 2001    Simpson 3.772669e-01  1.167105e-02 4.800079e-01
      4290   431_5113493 2001 invSimpson 1.605824e+00  7.103458e-02 3.807320e-01
      4291   431_5113493 2001        PIE 3.791439e-01  5.805718e-03 7.737490e-01
      4292   431_5113493 2001      DomMc 9.900990e-01 -1.295428e-02 4.182333e-01
      4293   431_5113493 2001 expShannon 1.836814e+00  8.530827e-02 3.255662e-01
      4294   431_5113493 2003          S 5.000000e+00  1.992883e-01 2.171477e-01
      4295   431_5113493 2003          N 3.280000e+02  1.017438e+01 6.489643e-01
      4296   431_5113493 2003       maxN 2.340000e+02  6.455516e+00 6.928084e-01
      4297   431_5113493 2003    Shannon 8.948611e-01  3.226336e-02 3.576511e-01
      4298   431_5113493 2003    Simpson 4.566292e-01  1.167105e-02 4.800079e-01
      4299   431_5113493 2003 invSimpson 1.840364e+00  7.103458e-02 3.807320e-01
      4300   431_5113493 2003        PIE 4.580257e-01  5.805718e-03 7.737490e-01
      4301   431_5113493 2003      DomMc 8.750000e-01 -1.295428e-02 4.182333e-01
      4302   431_5113493 2003 expShannon 2.446996e+00  8.530827e-02 3.255662e-01
      4303   431_5113493 2006          S 4.000000e+00  1.992883e-01 2.171477e-01
      4304   431_5113493 2006          N 2.000000e+01  1.017438e+01 6.489643e-01
      4305   431_5113493 2006       maxN 9.000000e+00  6.455516e+00 6.928084e-01
      4306   431_5113493 2006    Shannon 1.192195e+00  3.226336e-02 3.576511e-01
      4307   431_5113493 2006    Simpson 6.650000e-01  1.167105e-02 4.800079e-01
      4308   431_5113493 2006 invSimpson 2.985075e+00  7.103458e-02 3.807320e-01
      4309   431_5113493 2006        PIE 7.000000e-01  5.805718e-03 7.737490e-01
      4310   431_5113493 2006      DomMc 7.500000e-01 -1.295428e-02 4.182333e-01
      4311   431_5113493 2006 expShannon 3.294303e+00  8.530827e-02 3.255662e-01
      4312   431_5113493 2005          S 4.000000e+00  1.992883e-01 2.171477e-01
      4313   431_5113493 2005          N 1.480000e+02  1.017438e+01 6.489643e-01
      4314   431_5113493 2005       maxN 1.010000e+02  6.455516e+00 6.928084e-01
      4315   431_5113493 2005    Shannon 7.326541e-01  3.226336e-02 3.576511e-01
      4316   431_5113493 2005    Simpson 4.494156e-01  1.167105e-02 4.800079e-01
      4317   431_5113493 2005 invSimpson 1.816252e+00  7.103458e-02 3.807320e-01
      4318   431_5113493 2005        PIE 4.524729e-01  5.805718e-03 7.737490e-01
      4319   431_5113493 2005      DomMc 9.729730e-01 -1.295428e-02 4.182333e-01
      4320   431_5113493 2005 expShannon 2.080595e+00  8.530827e-02 3.255662e-01
      4321   431_5113493 1998          S 3.000000e+00  1.992883e-01 2.171477e-01
      4322   431_5113493 1998          N 8.000000e+00  1.017438e+01 6.489643e-01
      4323   431_5113493 1998       maxN 5.000000e+00  6.455516e+00 6.928084e-01
      4324   431_5113493 1998    Shannon 9.002561e-01  3.226336e-02 3.576511e-01
      4325   431_5113493 1998    Simpson 5.312500e-01  1.167105e-02 4.800079e-01
      4326   431_5113493 1998 invSimpson 2.133333e+00  7.103458e-02 3.807320e-01
      4327   431_5113493 1998        PIE 6.071429e-01  5.805718e-03 7.737490e-01
      4328   431_5113493 1998      DomMc 8.750000e-01 -1.295428e-02 4.182333e-01
      4329   431_5113493 1998 expShannon 2.460233e+00  8.530827e-02 3.255662e-01
      4330   431_5113493 2000          S 2.000000e+00  1.992883e-01 2.171477e-01
      4331   431_5113493 2000          N 1.100000e+01  1.017438e+01 6.489643e-01
      4332   431_5113493 2000       maxN 7.000000e+00  6.455516e+00 6.928084e-01
      4333   431_5113493 2000    Shannon 6.554818e-01  3.226336e-02 3.576511e-01
      4334   431_5113493 2000    Simpson 4.628099e-01  1.167105e-02 4.800079e-01
      4335   431_5113493 2000 invSimpson 1.861538e+00  7.103458e-02 3.807320e-01
      4336   431_5113493 2000        PIE 5.090909e-01  5.805718e-03 7.737490e-01
      4337   431_5113493 2000      DomMc 1.000000e+00 -1.295428e-02 4.182333e-01
      4338   431_5113493 2000 expShannon 1.926070e+00  8.530827e-02 3.255662e-01
      4339   431_5100389 2004          S 3.000000e+00 -1.288344e-01 2.028719e-01
      4340   431_5100389 2004          N 2.060000e+02  2.328221e+00 8.965534e-01
      4341   431_5100389 2004       maxN 2.000000e+02  3.303681e+00 8.537547e-01
      4342   431_5100389 2004    Shannon 1.502308e-01 -4.029657e-02 4.722386e-01
      4343   431_5100389 2004    Simpson 5.693279e-02 -2.028809e-02 5.811513e-01
      4344   431_5100389 2004 invSimpson 1.060370e+00 -5.645175e-02 4.558586e-01
      4345   431_5100389 2004        PIE 5.721051e-02 -1.851868e-02 6.438798e-01
      4346   431_5100389 2004      DomMc 9.902913e-01  7.243419e-03 7.288084e-02
      4347   431_5100389 2004 expShannon 1.162102e+00 -7.944576e-02 3.992265e-01
      4348   431_5100389 2007          S 2.000000e+00 -1.288344e-01 2.028719e-01
      4349   431_5100389 2007          N 8.000000e+00  2.328221e+00 8.965534e-01
      4350   431_5100389 2007       maxN 6.000000e+00  3.303681e+00 8.537547e-01
      4351   431_5100389 2007    Shannon 5.623351e-01 -4.029657e-02 4.722386e-01
      4352   431_5100389 2007    Simpson 3.750000e-01 -2.028809e-02 5.811513e-01
      4353   431_5100389 2007 invSimpson 1.600000e+00 -5.645175e-02 4.558586e-01
      4354   431_5100389 2007        PIE 4.285714e-01 -1.851868e-02 6.438798e-01
      4355   431_5100389 2007      DomMc 1.000000e+00  7.243419e-03 7.288084e-02
      4356   431_5100389 2007 expShannon 1.754765e+00 -7.944576e-02 3.992265e-01
      4357   431_5100389 1993          S 4.000000e+00 -1.288344e-01 2.028719e-01
      4358   431_5100389 1993          N 4.100000e+01  2.328221e+00 8.965534e-01
      4359   431_5100389 1993       maxN 2.500000e+01  3.303681e+00 8.537547e-01
      4360   431_5100389 1993    Shannon 9.559290e-01 -4.029657e-02 4.722386e-01
      4361   431_5100389 1993    Simpson 5.377751e-01 -2.028809e-02 5.811513e-01
      4362   431_5100389 1993 invSimpson 2.163449e+00 -5.645175e-02 4.558586e-01
      4363   431_5100389 1993        PIE 5.512195e-01 -1.851868e-02 6.438798e-01
      4364   431_5100389 1993      DomMc 9.024390e-01  7.243419e-03 7.288084e-02
      4365   431_5100389 1993 expShannon 2.601086e+00 -7.944576e-02 3.992265e-01
      4366   431_4748944 2005          S 2.000000e+00  2.000870e-17 8.432322e-02
      4367   431_4748944 2005          N 1.100000e+01 -7.616279e-01 6.138223e-01
      4368   431_4748944 2005       maxN 1.000000e+01 -7.325581e-01 6.434142e-01
      4369   431_4748944 2005    Shannon 3.046361e-01  1.311909e-03 9.635633e-01
      4370   431_4748944 2005    Simpson 1.652893e-01 -1.313999e-05 9.995000e-01
      4371   431_4748944 2005 invSimpson 1.198020e+00 -2.153864e-03 9.487716e-01
      4372   431_4748944 2005        PIE 1.818182e-01  8.389543e-05 9.971766e-01
      4373   431_4748944 2005      DomMc 1.000000e+00  1.000435e-17 8.432322e-02
      4374   431_4748944 2005 expShannon 1.356131e+00  2.915501e-04 9.942224e-01
      4375   431_4748944 1991          S 2.000000e+00  2.000870e-17 8.432322e-02
      4376   431_4748944 1991          N 2.800000e+01 -7.616279e-01 6.138223e-01
      4377   431_4748944 1991       maxN 2.700000e+01 -7.325581e-01 6.434142e-01
      4378   431_4748944 1991    Shannon 1.540761e-01  1.311909e-03 9.635633e-01
      4379   431_4748944 1991    Simpson 6.887755e-02 -1.313999e-05 9.995000e-01
      4380   431_4748944 1991 invSimpson 1.073973e+00 -2.153864e-03 9.487716e-01
      4381   431_4748944 1991        PIE 7.142857e-02  8.389543e-05 9.971766e-01
      4382   431_4748944 1991      DomMc 1.000000e+00  1.000435e-17 8.432322e-02
      4383   431_4748944 1991 expShannon 1.166580e+00  2.915501e-04 9.942224e-01
      4384   431_4748944 1993          S 2.000000e+00  2.000870e-17 8.432322e-02
      4385   431_4748944 1993          N 1.000000e+01 -7.616279e-01 6.138223e-01
      4386   431_4748944 1993       maxN 8.000000e+00 -7.325581e-01 6.434142e-01
      4387   431_4748944 1993    Shannon 5.004024e-01  1.311909e-03 9.635633e-01
      4388   431_4748944 1993    Simpson 3.200000e-01 -1.313999e-05 9.995000e-01
      4389   431_4748944 1993 invSimpson 1.470588e+00 -2.153864e-03 9.487716e-01
      4390   431_4748944 1993        PIE 3.555556e-01  8.389543e-05 9.971766e-01
      4391   431_4748944 1993      DomMc 1.000000e+00  1.000435e-17 8.432322e-02
      4392   431_4748944 1993 expShannon 1.649385e+00  2.915501e-04 9.942224e-01
      4393   431_5122956 1992          S 4.000000e+00 -5.504587e-02 6.107074e-02
      4394   431_5122956 1992          N 7.500000e+01 -2.426606e+00 1.228234e-01
      4395   431_5122956 1992       maxN 2.600000e+01 -1.788991e-01 4.675905e-01
      4396   431_5122956 1992    Shannon 1.153504e+00 -2.637666e-02 7.968036e-02
      4397   431_5122956 1992    Simpson 6.744889e-01 -1.496619e-02 1.034804e-01
      4398   431_5122956 1992 invSimpson 3.072092e+00 -7.693536e-02 8.415092e-02
      4399   431_5122956 1992        PIE 6.836036e-01 -1.472356e-02 1.009298e-01
      4400   431_5122956 1992      DomMc 6.800000e-01  1.582251e-02 5.067629e-02
      4401   431_5122956 1992 expShannon 3.169280e+00 -6.641300e-02 7.556841e-02
      4402   431_5122956 2009          S 3.000000e+00 -5.504587e-02 6.107074e-02
      4403   431_5122956 2009          N 2.800000e+01 -2.426606e+00 1.228234e-01
      4404   431_5122956 2009       maxN 2.100000e+01 -1.788991e-01 4.675905e-01
      4405   431_5122956 2009    Shannon 6.648642e-01 -2.637666e-02 7.968036e-02
      4406   431_5122956 2009    Simpson 3.903061e-01 -1.496619e-02 1.034804e-01
      4407   431_5122956 2009 invSimpson 1.640167e+00 -7.693536e-02 8.415092e-02
      4408   431_5122956 2009        PIE 4.047619e-01 -1.472356e-02 1.009298e-01
      4409   431_5122956 2009      DomMc 9.642857e-01  1.582251e-02 5.067629e-02
      4410   431_5122956 2009 expShannon 1.944227e+00 -6.641300e-02 7.556841e-02
      4411   431_5122956 2011          S 3.000000e+00 -5.504587e-02 6.107074e-02
      4412   431_5122956 2011          N 3.300000e+01 -2.426606e+00 1.228234e-01
      4413   431_5122956 2011       maxN 2.400000e+01 -1.788991e-01 4.675905e-01
      4414   431_5122956 2011    Shannon 6.810886e-01 -2.637666e-02 7.968036e-02
      4415   431_5122956 2011    Simpson 4.113866e-01 -1.496619e-02 1.034804e-01
      4416   431_5122956 2011 invSimpson 1.698908e+00 -7.693536e-02 8.415092e-02
      4417   431_5122956 2011        PIE 4.242424e-01 -1.472356e-02 1.009298e-01
      4418   431_5122956 2011      DomMc 9.696970e-01  1.582251e-02 5.067629e-02
      4419   431_5122956 2011 expShannon 1.976028e+00 -6.641300e-02 7.556841e-02
      4420   431_5120045 1993          S 2.000000e+00  7.636364e-02 2.688738e-01
      4421   431_5120045 1993          N 4.000000e+00  1.488727e+01 1.602029e-01
      4422   431_5120045 1993       maxN 3.000000e+00  1.460727e+01 1.587213e-01
      4423   431_5120045 1993    Shannon 5.623351e-01 -4.986752e-02 1.704910e-01
      4424   431_5120045 1993    Simpson 3.750000e-01 -3.798338e-02 1.815957e-01
      4425   431_5120045 1993 invSimpson 1.600000e+00 -6.777576e-02 2.455599e-01
      4426   431_5120045 1993        PIE 5.000000e-01 -5.143296e-02 1.544345e-01
      4427   431_5120045 1993      DomMc 1.000000e+00 -4.172876e-04 2.688738e-01
      4428   431_5120045 1993 expShannon 1.754765e+00 -7.228216e-02 1.879966e-01
      4429   431_5120045 2004          S 3.000000e+00  7.636364e-02 2.688738e-01
      4430   431_5120045 2004          N 1.830000e+02  1.488727e+01 1.602029e-01
      4431   431_5120045 2004       maxN 1.780000e+02  1.460727e+01 1.587213e-01
      4432   431_5120045 2004    Shannon 1.389799e-01 -4.986752e-02 1.704910e-01
      4433   431_5120045 2004    Simpson 5.339067e-02 -3.798338e-02 1.815957e-01
      4434   431_5120045 2004 invSimpson 1.056402e+00 -6.777576e-02 2.455599e-01
      4435   431_5120045 2004        PIE 5.368402e-02 -5.143296e-02 1.544345e-01
      4436   431_5120045 2004      DomMc 9.945355e-01 -4.172876e-04 2.688738e-01
      4437   431_5120045 2004 expShannon 1.149101e+00 -7.228216e-02 1.879966e-01
      4438   431_5120045 1997          S 2.000000e+00  7.636364e-02 2.688738e-01
      4439   431_5120045 1997          N 5.000000e+00  1.488727e+01 1.602029e-01
      4440   431_5120045 1997       maxN 3.000000e+00  1.460727e+01 1.587213e-01
      4441   431_5120045 1997    Shannon 6.730117e-01 -4.986752e-02 1.704910e-01
      4442   431_5120045 1997    Simpson 4.800000e-01 -3.798338e-02 1.815957e-01
      4443   431_5120045 1997 invSimpson 1.923077e+00 -6.777576e-02 2.455599e-01
      4444   431_5120045 1997        PIE 6.000000e-01 -5.143296e-02 1.544345e-01
      4445   431_5120045 1997      DomMc 1.000000e+00 -4.172876e-04 2.688738e-01
      4446   431_5120045 1997 expShannon 1.960132e+00 -7.228216e-02 1.879966e-01
      4447   431_5120045 2001          S 2.000000e+00  7.636364e-02 2.688738e-01
      4448   431_5120045 2001          N 4.200000e+01  1.488727e+01 1.602029e-01
      4449   431_5120045 2001       maxN 4.100000e+01  1.460727e+01 1.587213e-01
      4450   431_5120045 2001    Shannon 1.125159e-01 -4.986752e-02 1.704910e-01
      4451   431_5120045 2001    Simpson 4.648526e-02 -3.798338e-02 1.815957e-01
      4452   431_5120045 2001 invSimpson 1.048751e+00 -6.777576e-02 2.455599e-01
      4453   431_5120045 2001        PIE 4.761905e-02 -5.143296e-02 1.544345e-01
      4454   431_5120045 2001      DomMc 1.000000e+00 -4.172876e-04 2.688738e-01
      4455   431_5120045 2001 expShannon 1.119090e+00 -7.228216e-02 1.879966e-01
      4456   431_5112765 2001          S 2.000000e+00 -4.000000e-01 1.393260e-01
      4457   431_5112765 2001          N 1.000000e+01  7.000000e-01 7.802206e-01
      4458   431_5112765 2001       maxN 5.000000e+00  9.000000e-01 6.979866e-01
      4459   431_5112765 2001    Shannon 6.931472e-01 -1.348129e-01 1.658654e-01
      4460   431_5112765 2001    Simpson 5.000000e-01 -5.353735e-02 3.599891e-01
      4461   431_5112765 2001 invSimpson 2.000000e+00 -2.334417e-01 2.433436e-01
      4462   431_5112765 2001        PIE 5.555556e-01 -5.808752e-02 3.506071e-01
      4463   431_5112765 2001      DomMc 1.000000e+00  6.727837e-02 6.506365e-02
      4464   431_5112765 2001 expShannon 2.000000e+00 -3.308164e-01 1.274692e-01
      4465   431_5112765 1997          S 4.000000e+00 -4.000000e-01 1.393260e-01
      4466   431_5112765 1997          N 1.100000e+01  7.000000e-01 7.802206e-01
      4467   431_5112765 1997       maxN 6.000000e+00  9.000000e-01 6.979866e-01
      4468   431_5112765 1997    Shannon 1.168518e+00 -1.348129e-01 1.658654e-01
      4469   431_5112765 1997    Simpson 6.280992e-01 -5.353735e-02 3.599891e-01
      4470   431_5112765 1997 invSimpson 2.688889e+00 -2.334417e-01 2.433436e-01
      4471   431_5112765 1997        PIE 6.909091e-01 -5.808752e-02 3.506071e-01
      4472   431_5112765 1997      DomMc 7.272727e-01  6.727837e-02 6.506365e-02
      4473   431_5112765 1997 expShannon 3.217222e+00 -3.308164e-01 1.274692e-01
      4474   431_5112765 1998          S 3.000000e+00 -4.000000e-01 1.393260e-01
      4475   431_5112765 1998          N 1.400000e+01  7.000000e-01 7.802206e-01
      4476   431_5112765 1998       maxN 8.000000e+00  9.000000e-01 6.979866e-01
      4477   431_5112765 1998    Shannon 9.799712e-01 -1.348129e-01 1.658654e-01
      4478   431_5112765 1998    Simpson 5.816327e-01 -5.353735e-02 3.599891e-01
      4479   431_5112765 1998 invSimpson 2.390244e+00 -2.334417e-01 2.433436e-01
      4480   431_5112765 1998        PIE 6.263736e-01 -5.808752e-02 3.506071e-01
      4481   431_5112765 1998      DomMc 7.857143e-01  6.727837e-02 6.506365e-02
      4482   431_5112765 1998 expShannon 2.664379e+00 -3.308164e-01 1.274692e-01
      4483   431_5112765 1999          S 2.000000e+00 -4.000000e-01 1.393260e-01
      4484   431_5112765 1999          N 6.000000e+00  7.000000e-01 7.802206e-01
      4485   431_5112765 1999       maxN 5.000000e+00  9.000000e-01 6.979866e-01
      4486   431_5112765 1999    Shannon 4.505612e-01 -1.348129e-01 1.658654e-01
      4487   431_5112765 1999    Simpson 2.777778e-01 -5.353735e-02 3.599891e-01
      4488   431_5112765 1999 invSimpson 1.384615e+00 -2.334417e-01 2.433436e-01
      4489   431_5112765 1999        PIE 3.333333e-01 -5.808752e-02 3.506071e-01
      4490   431_5112765 1999      DomMc 1.000000e+00  6.727837e-02 6.506365e-02
      4491   431_5112765 1999 expShannon 1.569193e+00 -3.308164e-01 1.274692e-01
      4492   431_5112765 2000          S 3.000000e+00 -4.000000e-01 1.393260e-01
      4493   431_5112765 2000          N 2.300000e+01  7.000000e-01 7.802206e-01
      4494   431_5112765 2000       maxN 1.900000e+01  9.000000e-01 6.979866e-01
      4495   431_5112765 2000    Shannon 5.825842e-01 -1.348129e-01 1.658654e-01
      4496   431_5112765 2000    Simpson 3.024575e-01 -5.353735e-02 3.599891e-01
      4497   431_5112765 2000 invSimpson 1.433604e+00 -2.334417e-01 2.433436e-01
      4498   431_5112765 2000        PIE 3.162055e-01 -5.808752e-02 3.506071e-01
      4499   431_5112765 2000      DomMc 9.130435e-01  6.727837e-02 6.506365e-02
      4500   431_5112765 2000 expShannon 1.790660e+00 -3.308164e-01 1.274692e-01
      4501   431_5101117 2010          S 2.000000e+00  9.302326e-02 5.823435e-01
      4502   431_5101117 2010          N 3.500000e+01  9.418605e-01 8.241763e-01
      4503   431_5101117 2010       maxN 3.400000e+01  7.558140e-01 8.669927e-01
      4504   431_5101117 2010    Shannon 1.297407e-01  3.930163e-02 7.050674e-01
      4505   431_5101117 2010    Simpson 5.551020e-02  2.315207e-02 7.074140e-01
      4506   431_5101117 2010 invSimpson 1.058773e+00  5.040248e-02 6.620730e-01
      4507   431_5101117 2010        PIE 5.714286e-02  2.570220e-02 7.074924e-01
      4508   431_5101117 2010      DomMc 1.000000e+00 -8.456660e-03 5.823435e-01
      4509   431_5101117 2010 expShannon 1.138533e+00  6.949059e-02 6.744054e-01
      4510   431_5101117 2011          S 3.000000e+00  9.302326e-02 5.823435e-01
      4511   431_5101117 2011          N 1.100000e+01  9.418605e-01 8.241763e-01
      4512   431_5101117 2011       maxN 8.000000e+00  7.558140e-01 8.669927e-01
      4513   431_5101117 2011    Shannon 7.595474e-01  3.930163e-02 7.050674e-01
      4514   431_5101117 2011    Simpson 4.297521e-01  2.315207e-02 7.074140e-01
      4515   431_5101117 2011 invSimpson 1.753623e+00  5.040248e-02 6.620730e-01
      4516   431_5101117 2011        PIE 4.727273e-01  2.570220e-02 7.074924e-01
      4517   431_5101117 2011      DomMc 9.090909e-01 -8.456660e-03 5.823435e-01
      4518   431_5101117 2011 expShannon 2.137309e+00  6.949059e-02 6.744054e-01
      4519   431_5101117 2004          S 2.000000e+00  9.302326e-02 5.823435e-01
      4520   431_5101117 2004          N 1.400000e+01  9.418605e-01 8.241763e-01
      4521   431_5101117 2004       maxN 1.300000e+01  7.558140e-01 8.669927e-01
      4522   431_5101117 2004    Shannon 2.573186e-01  3.930163e-02 7.050674e-01
      4523   431_5101117 2004    Simpson 1.326531e-01  2.315207e-02 7.074140e-01
      4524   431_5101117 2004 invSimpson 1.152941e+00  5.040248e-02 6.620730e-01
      4525   431_5101117 2004        PIE 1.428571e-01  2.570220e-02 7.074924e-01
      4526   431_5101117 2004      DomMc 1.000000e+00 -8.456660e-03 5.823435e-01
      4527   431_5101117 2004 expShannon 1.293457e+00  6.949059e-02 6.744054e-01
      4528   431_4751862 2008          S 2.000000e+00  8.600417e-18 8.352128e-01
      4529   431_4751862 2008          N 1.100000e+01 -4.673004e+00 6.479740e-01
      4530   431_4751862 2008       maxN 1.000000e+01 -4.676806e+00 5.682140e-01
      4531   431_4751862 2008    Shannon 3.046361e-01  6.773683e-03 5.280978e-01
      4532   431_4751862 2008    Simpson 1.652893e-01  5.992131e-03 4.840394e-01
      4533   431_4751862 2008 invSimpson 1.198020e+00  1.354012e-02 3.945071e-01
      4534   431_4751862 2008        PIE 1.818182e-01  6.444816e-03 4.590214e-01
      4535   431_4751862 2008      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4536   431_4751862 2008 expShannon 1.356131e+00  1.142259e-02 4.829980e-01
      4537   431_4751862 1999          S 2.000000e+00  8.600417e-18 8.352128e-01
      4538   431_4751862 1999          N 2.850000e+02 -4.673004e+00 6.479740e-01
      4539   431_4751862 1999       maxN 2.380000e+02 -4.676806e+00 5.682140e-01
      4540   431_4751862 1999    Shannon 4.477265e-01  6.773683e-03 5.280978e-01
      4541   431_4751862 1999    Simpson 2.754324e-01  5.992131e-03 4.840394e-01
      4542   431_4751862 1999 invSimpson 1.380134e+00  1.354012e-02 3.945071e-01
      4543   431_4751862 1999        PIE 2.764023e-01  6.444816e-03 4.590214e-01
      4544   431_4751862 1999      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4545   431_4751862 1999 expShannon 1.564751e+00  1.142259e-02 4.829980e-01
      4546   431_4751862 2000          S 2.000000e+00  8.600417e-18 8.352128e-01
      4547   431_4751862 2000          N 1.800000e+01 -4.673004e+00 6.479740e-01
      4548   431_4751862 2000       maxN 1.600000e+01 -4.676806e+00 5.682140e-01
      4549   431_4751862 2000    Shannon 3.488321e-01  6.773683e-03 5.280978e-01
      4550   431_4751862 2000    Simpson 1.975309e-01  5.992131e-03 4.840394e-01
      4551   431_4751862 2000 invSimpson 1.246154e+00  1.354012e-02 3.945071e-01
      4552   431_4751862 2000        PIE 2.091503e-01  6.444816e-03 4.590214e-01
      4553   431_4751862 2000      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4554   431_4751862 2000 expShannon 1.417411e+00  1.142259e-02 4.829980e-01
      4555   431_4751862 2009          S 2.000000e+00  8.600417e-18 8.352128e-01
      4556   431_4751862 2009          N 4.100000e+01 -4.673004e+00 6.479740e-01
      4557   431_4751862 2009       maxN 3.800000e+01 -4.676806e+00 5.682140e-01
      4558   431_4751862 2009    Shannon 2.617645e-01  6.773683e-03 5.280978e-01
      4559   431_4751862 2009    Simpson 1.356336e-01  5.992131e-03 4.840394e-01
      4560   431_4751862 2009 invSimpson 1.156917e+00  1.354012e-02 3.945071e-01
      4561   431_4751862 2009        PIE 1.390244e-01  6.444816e-03 4.590214e-01
      4562   431_4751862 2009      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4563   431_4751862 2009 expShannon 1.299221e+00  1.142259e-02 4.829980e-01
      4564   431_4751862 2010          S 2.000000e+00  8.600417e-18 8.352128e-01
      4565   431_4751862 2010          N 1.000000e+01 -4.673004e+00 6.479740e-01
      4566   431_4751862 2010       maxN 8.000000e+00 -4.676806e+00 5.682140e-01
      4567   431_4751862 2010    Shannon 5.004024e-01  6.773683e-03 5.280978e-01
      4568   431_4751862 2010    Simpson 3.200000e-01  5.992131e-03 4.840394e-01
      4569   431_4751862 2010 invSimpson 1.470588e+00  1.354012e-02 3.945071e-01
      4570   431_4751862 2010        PIE 3.555556e-01  6.444816e-03 4.590214e-01
      4571   431_4751862 2010      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4572   431_4751862 2010 expShannon 1.649385e+00  1.142259e-02 4.829980e-01
      4573   431_4751862 2014          S 2.000000e+00  8.600417e-18 8.352128e-01
      4574   431_4751862 2014          N 1.830000e+02 -4.673004e+00 6.479740e-01
      4575   431_4751862 2014       maxN 1.340000e+02 -4.676806e+00 5.682140e-01
      4576   431_4751862 2014    Shannon 5.810177e-01  6.773683e-03 5.280978e-01
      4577   431_4751862 2014    Simpson 3.921288e-01  5.992131e-03 4.840394e-01
      4578   431_4751862 2014 invSimpson 1.645085e+00  1.354012e-02 3.945071e-01
      4579   431_4751862 2014        PIE 3.942833e-01  6.444816e-03 4.590214e-01
      4580   431_4751862 2014      DomMc 1.000000e+00  4.300209e-18 8.352128e-01
      4581   431_4751862 2014 expShannon 1.787857e+00  1.142259e-02 4.829980e-01
      4582   431_5113490 1999          S 2.000000e+00  9.708738e-02 1.091826e-01
      4583   431_5113490 1999          N 9.500000e+01  1.310680e-01 9.881448e-01
      4584   431_5113490 1999       maxN 7.500000e+01  4.320388e-01 9.532855e-01
      4585   431_5113490 1999    Shannon 5.146532e-01  4.643585e-04 9.796066e-01
      4586   431_5113490 1999    Simpson 3.324100e-01 -8.057940e-03 6.866262e-01
      4587   431_5113490 1999 invSimpson 1.497925e+00 -2.153791e-02 7.087534e-01
      4588   431_5113490 1999        PIE 3.359462e-01 -9.120138e-03 7.037969e-01
      4589   431_5113490 1999      DomMc 1.000000e+00 -5.711022e-03 1.091826e-01
      4590   431_5113490 1999 expShannon 1.673058e+00  2.614402e-04 9.937205e-01
      4591   431_5113490 2001          S 2.000000e+00  9.708738e-02 1.091826e-01
      4592   431_5113490 2001          N 1.400000e+01  1.310680e-01 9.881448e-01
      4593   431_5113490 2001       maxN 8.000000e+00  4.320388e-01 9.532855e-01
      4594   431_5113490 2001    Shannon 6.829081e-01  4.643585e-04 9.796066e-01
      4595   431_5113490 2001    Simpson 4.897959e-01 -8.057940e-03 6.866262e-01
      4596   431_5113490 2001 invSimpson 1.960000e+00 -2.153791e-02 7.087534e-01
      4597   431_5113490 2001        PIE 5.274725e-01 -9.120138e-03 7.037969e-01
      4598   431_5113490 2001      DomMc 1.000000e+00 -5.711022e-03 1.091826e-01
      4599   431_5113490 2001 expShannon 1.979626e+00  2.614402e-04 9.937205e-01
      4600   431_5113490 2010          S 3.000000e+00  9.708738e-02 1.091826e-01
      4601   431_5113490 2010          N 6.800000e+01  1.310680e-01 9.881448e-01
      4602   431_5113490 2010       maxN 5.600000e+01  4.320388e-01 9.532855e-01
      4603   431_5113490 2010    Shannon 5.783253e-01  4.643585e-04 9.796066e-01
      4604   431_5113490 2010    Simpson 3.044983e-01 -8.057940e-03 6.866262e-01
      4605   431_5113490 2010 invSimpson 1.437811e+00 -2.153791e-02 7.087534e-01
      4606   431_5113490 2010        PIE 3.090430e-01 -9.120138e-03 7.037969e-01
      4607   431_5113490 2010      DomMc 9.411765e-01 -5.711022e-03 1.091826e-01
      4608   431_5113490 2010 expShannon 1.783050e+00  2.614402e-04 9.937205e-01
      4609   431_5114950 2008          S 2.000000e+00  2.500000e-01 3.333333e-01
      4610   431_5114950 2008          N 1.740000e+02  1.072500e+02 1.044352e-01
      4611   431_5114950 2008       maxN 1.730000e+02  1.000000e+02 8.404540e-02
      4612   431_5114950 2008    Shannon 3.538032e-02 -1.181437e-02 8.988782e-01
      4613   431_5114950 2008    Simpson 1.142819e-02 -1.086909e-02 8.317922e-01
      4614   431_5114950 2008 invSimpson 1.011560e+00 -1.507476e-02 8.065287e-01
      4615   431_5114950 2008        PIE 1.149425e-02 -1.295153e-02 8.071595e-01
      4616   431_5114950 2008      DomMc 1.000000e+00 -1.111111e-03 3.333333e-01
      4617   431_5114950 2008 expShannon 1.036014e+00 -1.580416e-02 8.858105e-01
      4618   431_5114950 2010          S 3.000000e+00  2.500000e-01 3.333333e-01
      4619   431_5114950 2010          N 4.500000e+02  1.072500e+02 1.044352e-01
      4620   431_5114950 2010       maxN 4.190000e+02  1.000000e+02 8.404540e-02
      4621   431_5114950 2010    Shannon 2.672347e-01 -1.181437e-02 8.988782e-01
      4622   431_5114950 2010    Simpson 1.288593e-01 -1.086909e-02 8.317922e-01
      4623   431_5114950 2010 invSimpson 1.147920e+00 -1.507476e-02 8.065287e-01
      4624   431_5114950 2010        PIE 1.291463e-01 -1.295153e-02 8.071595e-01
      4625   431_5114950 2010      DomMc 9.955556e-01 -1.111111e-03 3.333333e-01
      4626   431_5114950 2010 expShannon 1.306347e+00 -1.580416e-02 8.858105e-01
      4627   431_5114950 2006          S 2.000000e+00  2.500000e-01 3.333333e-01
      4628   431_5114950 2006          N 2.100000e+01  1.072500e+02 1.044352e-01
      4629   431_5114950 2006       maxN 1.900000e+01  1.000000e+02 8.404540e-02
      4630   431_5114950 2006    Shannon 3.144922e-01 -1.181437e-02 8.988782e-01
      4631   431_5114950 2006    Simpson 1.723356e-01 -1.086909e-02 8.317922e-01
      4632   431_5114950 2006 invSimpson 1.208219e+00 -1.507476e-02 8.065287e-01
      4633   431_5114950 2006        PIE 1.809524e-01 -1.295153e-02 8.071595e-01
      4634   431_5114950 2006      DomMc 1.000000e+00 -1.111111e-03 3.333333e-01
      4635   431_5114950 2006 expShannon 1.369564e+00 -1.580416e-02 8.858105e-01
      4636   431_4775942 2004          S 2.000000e+00 -3.054582e-17 4.877543e-01
      4637   431_4775942 2004          N 6.000000e+00 -8.076923e-01 5.530290e-01
      4638   431_4775942 2004       maxN 3.000000e+00 -5.769231e-01 7.098418e-01
      4639   431_4775942 2004    Shannon 6.931472e-01  1.494273e-02 8.455790e-01
      4640   431_4775942 2004    Simpson 5.000000e-01  1.287349e-02 8.455790e-01
      4641   431_4775942 2004 invSimpson 2.000000e+00  3.084539e-02 8.455790e-01
      4642   431_4775942 2004        PIE 6.000000e-01  7.762238e-02 5.204131e-01
      4643   431_4775942 2004      DomMc 1.000000e+00 -1.527291e-17 4.877543e-01
      4644   431_4775942 2004 expShannon 2.000000e+00  2.476418e-02 8.455790e-01
      4645   431_4775942 2006          S 2.000000e+00 -3.054582e-17 4.877543e-01
      4646   431_4775942 2006          N 1.100000e+01 -8.076923e-01 5.530290e-01
      4647   431_4775942 2006       maxN 1.000000e+01 -5.769231e-01 7.098418e-01
      4648   431_4775942 2006    Shannon 3.046361e-01  1.494273e-02 8.455790e-01
      4649   431_4775942 2006    Simpson 1.652893e-01  1.287349e-02 8.455790e-01
      4650   431_4775942 2006 invSimpson 1.198020e+00  3.084539e-02 8.455790e-01
      4651   431_4775942 2006        PIE 1.818182e-01  7.762238e-02 5.204131e-01
      4652   431_4775942 2006      DomMc 1.000000e+00 -1.527291e-17 4.877543e-01
      4653   431_4775942 2006 expShannon 1.356131e+00  2.476418e-02 8.455790e-01
      4654   431_4775942 2011          S 2.000000e+00 -3.054582e-17 4.877543e-01
      4655   431_4775942 2011          N 2.000000e+00 -8.076923e-01 5.530290e-01
      4656   431_4775942 2011       maxN 1.000000e+00 -5.769231e-01 7.098418e-01
      4657   431_4775942 2011    Shannon 6.931472e-01  1.494273e-02 8.455790e-01
      4658   431_4775942 2011    Simpson 5.000000e-01  1.287349e-02 8.455790e-01
      4659   431_4775942 2011 invSimpson 2.000000e+00  3.084539e-02 8.455790e-01
      4660   431_4775942 2011        PIE 1.000000e+00  7.762238e-02 5.204131e-01
      4661   431_4775942 2011      DomMc 1.000000e+00 -1.527291e-17 4.877543e-01
      4662   431_4775942 2011 expShannon 2.000000e+00  2.476418e-02 8.455790e-01
      4663   431_4751863 2006          S 3.000000e+00 -2.191781e-02 7.795525e-01
      4664   431_4751863 2006          N 2.400000e+01  1.264932e+01 1.767783e-02
      4665   431_4751863 2006       maxN 1.300000e+01  1.264110e+01 1.859759e-02
      4666   431_4751863 2006    Shannon 8.292958e-01 -4.751497e-02 1.936962e-01
      4667   431_4751863 2006    Simpson 5.312500e-01 -3.285158e-02 1.543700e-01
      4668   431_4751863 2006 invSimpson 2.133333e+00 -5.713089e-02 3.005386e-01
      4669   431_4751863 2006        PIE 5.543478e-01 -3.999209e-02 8.148495e-02
      4670   431_4751863 2006      DomMc 9.583333e-01  1.103501e-03 8.724267e-01
      4671   431_4751863 2006 expShannon 2.291704e+00 -6.889217e-02 2.702440e-01
      4672   431_4751863 2005          S 2.000000e+00 -2.191781e-02 7.795525e-01
      4673   431_4751863 2005          N 7.000000e+00  1.264932e+01 1.767783e-02
      4674   431_4751863 2005       maxN 6.000000e+00  1.264110e+01 1.859759e-02
      4675   431_4751863 2005    Shannon 4.101163e-01 -4.751497e-02 1.936962e-01
      4676   431_4751863 2005    Simpson 2.448980e-01 -3.285158e-02 1.543700e-01
      4677   431_4751863 2005 invSimpson 1.324324e+00 -5.713089e-02 3.005386e-01
      4678   431_4751863 2005        PIE 2.857143e-01 -3.999209e-02 8.148495e-02
      4679   431_4751863 2005      DomMc 1.000000e+00  1.103501e-03 8.724267e-01
      4680   431_4751863 2005 expShannon 1.506993e+00 -6.889217e-02 2.702440e-01
      4681   431_4751863 2003          S 2.000000e+00 -2.191781e-02 7.795525e-01
      4682   431_4751863 2003          N 5.000000e+00  1.264932e+01 1.767783e-02
      4683   431_4751863 2003       maxN 4.000000e+00  1.264110e+01 1.859759e-02
      4684   431_4751863 2003    Shannon 5.004024e-01 -4.751497e-02 1.936962e-01
      4685   431_4751863 2003    Simpson 3.200000e-01 -3.285158e-02 1.543700e-01
      4686   431_4751863 2003 invSimpson 1.470588e+00 -5.713089e-02 3.005386e-01
      4687   431_4751863 2003        PIE 4.000000e-01 -3.999209e-02 8.148495e-02
      4688   431_4751863 2003      DomMc 1.000000e+00  1.103501e-03 8.724267e-01
      4689   431_4751863 2003 expShannon 1.649385e+00 -6.889217e-02 2.702440e-01
      4690   431_4751863 2007          S 3.000000e+00 -2.191781e-02 7.795525e-01
      4691   431_4751863 2007          N 3.600000e+01  1.264932e+01 1.767783e-02
      4692   431_4751863 2007       maxN 2.700000e+01  1.264110e+01 1.859759e-02
      4693   431_4751863 2007    Shannon 7.340755e-01 -4.751497e-02 1.936962e-01
      4694   431_4751863 2007    Simpson 4.058642e-01 -3.285158e-02 1.543700e-01
      4695   431_4751863 2007 invSimpson 1.683117e+00 -5.713089e-02 3.005386e-01
      4696   431_4751863 2007        PIE 4.174603e-01 -3.999209e-02 8.148495e-02
      4697   431_4751863 2007      DomMc 8.888889e-01  1.103501e-03 8.724267e-01
      4698   431_4751863 2007 expShannon 2.083555e+00 -6.889217e-02 2.702440e-01
      4699   431_4751863 2013          S 2.000000e+00 -2.191781e-02 7.795525e-01
      4700   431_4751863 2013          N 1.370000e+02  1.264932e+01 1.767783e-02
      4701   431_4751863 2013       maxN 1.340000e+02  1.264110e+01 1.859759e-02
      4702   431_4751863 2013    Shannon 1.053359e-01 -4.751497e-02 1.936962e-01
      4703   431_4751863 2013    Simpson 4.283659e-02 -3.285158e-02 1.543700e-01
      4704   431_4751863 2013 invSimpson 1.044754e+00 -5.713089e-02 3.005386e-01
      4705   431_4751863 2013        PIE 4.315157e-02 -3.999209e-02 8.148495e-02
      4706   431_4751863 2013      DomMc 1.000000e+00  1.103501e-03 8.724267e-01
      4707   431_4751863 2013 expShannon 1.111084e+00 -6.889217e-02 2.702440e-01
      4708   431_4751863 2009          S 2.000000e+00 -2.191781e-02 7.795525e-01
      4709   431_4751863 2009          N 2.200000e+01  1.264932e+01 1.767783e-02
      4710   431_4751863 2009       maxN 2.000000e+01  1.264110e+01 1.859759e-02
      4711   431_4751863 2009    Shannon 3.046361e-01 -4.751497e-02 1.936962e-01
      4712   431_4751863 2009    Simpson 1.652893e-01 -3.285158e-02 1.543700e-01
      4713   431_4751863 2009 invSimpson 1.198020e+00 -5.713089e-02 3.005386e-01
      4714   431_4751863 2009        PIE 1.731602e-01 -3.999209e-02 8.148495e-02
      4715   431_4751863 2009      DomMc 1.000000e+00  1.103501e-03 8.724267e-01
      4716   431_4751863 2009 expShannon 1.356131e+00 -6.889217e-02 2.702440e-01
      4717   431_4753322 2009          S 3.000000e+00  1.213708e-02 5.838604e-01
      4718   431_4753322 2009          N 1.500000e+02 -8.162780e-01 8.748023e-01
      4719   431_4753322 2009       maxN 8.400000e+01 -1.366016e-01 9.736250e-01
      4720   431_4753322 2009    Shannon 7.204767e-01 -1.728341e-02 1.085449e-01
      4721   431_4753322 2009    Simpson 4.985778e-01 -1.467598e-02 9.559345e-02
      4722   431_4753322 2009 invSimpson 1.994327e+00 -3.309624e-02 9.830495e-02
      4723   431_4753322 2009        PIE 5.019239e-01 -2.020849e-02 1.342383e-01
      4724   431_4753322 2009      DomMc 9.933333e-01 -6.841282e-05 6.018385e-01
      4725   431_4753322 2009 expShannon 2.055413e+00 -2.764794e-02 1.129655e-01
      4726   431_4753322 2004          S 2.000000e+00  1.213708e-02 5.838604e-01
      4727   431_4753322 2004          N 2.000000e+00 -8.162780e-01 8.748023e-01
      4728   431_4753322 2004       maxN 1.000000e+00 -1.366016e-01 9.736250e-01
      4729   431_4753322 2004    Shannon 6.931472e-01 -1.728341e-02 1.085449e-01
      4730   431_4753322 2004    Simpson 5.000000e-01 -1.467598e-02 9.559345e-02
      4731   431_4753322 2004 invSimpson 2.000000e+00 -3.309624e-02 9.830495e-02
      4732   431_4753322 2004        PIE 1.000000e+00 -2.020849e-02 1.342383e-01
      4733   431_4753322 2004      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4734   431_4753322 2004 expShannon 2.000000e+00 -2.764794e-02 1.129655e-01
      4735   431_4753322 2010          S 3.000000e+00  1.213708e-02 5.838604e-01
      4736   431_4753322 2010          N 1.990000e+02 -8.162780e-01 8.748023e-01
      4737   431_4753322 2010       maxN 1.410000e+02 -1.366016e-01 9.736250e-01
      4738   431_4753322 2010    Shannon 6.288372e-01 -1.728341e-02 1.085449e-01
      4739   431_4753322 2010    Simpson 4.158986e-01 -1.467598e-02 9.559345e-02
      4740   431_4753322 2010 invSimpson 1.712031e+00 -3.309624e-02 9.830495e-02
      4741   431_4753322 2010        PIE 4.179991e-01 -2.020849e-02 1.342383e-01
      4742   431_4753322 2010      DomMc 9.949749e-01 -6.841282e-05 6.018385e-01
      4743   431_4753322 2010 expShannon 1.875428e+00 -2.764794e-02 1.129655e-01
      4744   431_4753322 1999          S 2.000000e+00  1.213708e-02 5.838604e-01
      4745   431_4753322 1999          N 7.500000e+01 -8.162780e-01 8.748023e-01
      4746   431_4753322 1999       maxN 4.100000e+01 -1.366016e-01 9.736250e-01
      4747   431_4753322 1999    Shannon 6.887853e-01 -1.728341e-02 1.085449e-01
      4748   431_4753322 1999    Simpson 4.956444e-01 -1.467598e-02 9.559345e-02
      4749   431_4753322 1999 invSimpson 1.982728e+00 -3.309624e-02 9.830495e-02
      4750   431_4753322 1999        PIE 5.023423e-01 -2.020849e-02 1.342383e-01
      4751   431_4753322 1999      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4752   431_4753322 1999 expShannon 1.991295e+00 -2.764794e-02 1.129655e-01
      4753   431_4753322 2001          S 2.000000e+00  1.213708e-02 5.838604e-01
      4754   431_4753322 2001          N 4.500000e+01 -8.162780e-01 8.748023e-01
      4755   431_4753322 2001       maxN 3.100000e+01 -1.366016e-01 9.736250e-01
      4756   431_4753322 2001    Shannon 6.199868e-01 -1.728341e-02 1.085449e-01
      4757   431_4753322 2001    Simpson 4.286420e-01 -1.467598e-02 9.559345e-02
      4758   431_4753322 2001 invSimpson 1.750216e+00 -3.309624e-02 9.830495e-02
      4759   431_4753322 2001        PIE 4.383838e-01 -2.020849e-02 1.342383e-01
      4760   431_4753322 2001      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4761   431_4753322 2001 expShannon 1.858904e+00 -2.764794e-02 1.129655e-01
      4762   431_4753322 2002          S 2.000000e+00  1.213708e-02 5.838604e-01
      4763   431_4753322 2002          N 3.000000e+02 -8.162780e-01 8.748023e-01
      4764   431_4753322 2002       maxN 2.480000e+02 -1.366016e-01 9.736250e-01
      4765   431_4753322 2002    Shannon 4.611325e-01 -1.728341e-02 1.085449e-01
      4766   431_4753322 2002    Simpson 2.865778e-01 -1.467598e-02 9.559345e-02
      4767   431_4753322 2002 invSimpson 1.401694e+00 -3.309624e-02 9.830495e-02
      4768   431_4753322 2002        PIE 2.875362e-01 -2.020849e-02 1.342383e-01
      4769   431_4753322 2002      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4770   431_4753322 2002 expShannon 1.585869e+00 -2.764794e-02 1.129655e-01
      4771   431_4753322 2005          S 2.000000e+00  1.213708e-02 5.838604e-01
      4772   431_4753322 2005          N 1.200000e+01 -8.162780e-01 8.748023e-01
      4773   431_4753322 2005       maxN 1.100000e+01 -1.366016e-01 9.736250e-01
      4774   431_4753322 2005    Shannon 2.868360e-01 -1.728341e-02 1.085449e-01
      4775   431_4753322 2005    Simpson 1.527778e-01 -1.467598e-02 9.559345e-02
      4776   431_4753322 2005 invSimpson 1.180328e+00 -3.309624e-02 9.830495e-02
      4777   431_4753322 2005        PIE 1.666667e-01 -2.020849e-02 1.342383e-01
      4778   431_4753322 2005      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4779   431_4753322 2005 expShannon 1.332206e+00 -2.764794e-02 1.129655e-01
      4780   431_4753322 2006          S 2.000000e+00  1.213708e-02 5.838604e-01
      4781   431_4753322 2006          N 4.200000e+01 -8.162780e-01 8.748023e-01
      4782   431_4753322 2006       maxN 2.400000e+01 -1.366016e-01 9.736250e-01
      4783   431_4753322 2006    Shannon 6.829081e-01 -1.728341e-02 1.085449e-01
      4784   431_4753322 2006    Simpson 4.897959e-01 -1.467598e-02 9.559345e-02
      4785   431_4753322 2006 invSimpson 1.960000e+00 -3.309624e-02 9.830495e-02
      4786   431_4753322 2006        PIE 5.017422e-01 -2.020849e-02 1.342383e-01
      4787   431_4753322 2006      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4788   431_4753322 2006 expShannon 1.979626e+00 -2.764794e-02 1.129655e-01
      4789   431_4753322 2008          S 2.000000e+00  1.213708e-02 5.838604e-01
      4790   431_4753322 2008          N 1.200000e+01 -8.162780e-01 8.748023e-01
      4791   431_4753322 2008       maxN 1.100000e+01 -1.366016e-01 9.736250e-01
      4792   431_4753322 2008    Shannon 2.868360e-01 -1.728341e-02 1.085449e-01
      4793   431_4753322 2008    Simpson 1.527778e-01 -1.467598e-02 9.559345e-02
      4794   431_4753322 2008 invSimpson 1.180328e+00 -3.309624e-02 9.830495e-02
      4795   431_4753322 2008        PIE 1.666667e-01 -2.020849e-02 1.342383e-01
      4796   431_4753322 2008      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4797   431_4753322 2008 expShannon 1.332206e+00 -2.764794e-02 1.129655e-01
      4798   431_4753322 2012          S 2.000000e+00  1.213708e-02 5.838604e-01
      4799   431_4753322 2012          N 8.300000e+01 -8.162780e-01 8.748023e-01
      4800   431_4753322 2012       maxN 5.800000e+01 -1.366016e-01 9.736250e-01
      4801   431_4753322 2012    Shannon 6.118817e-01 -1.728341e-02 1.085449e-01
      4802   431_4753322 2012    Simpson 4.209610e-01 -1.467598e-02 9.559345e-02
      4803   431_4753322 2012 invSimpson 1.726999e+00 -3.309624e-02 9.830495e-02
      4804   431_4753322 2012        PIE 4.260946e-01 -2.020849e-02 1.342383e-01
      4805   431_4753322 2012      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4806   431_4753322 2012 expShannon 1.843898e+00 -2.764794e-02 1.129655e-01
      4807   431_4753322 2013          S 2.000000e+00  1.213708e-02 5.838604e-01
      4808   431_4753322 2013          N 8.400000e+01 -8.162780e-01 8.748023e-01
      4809   431_4753322 2013       maxN 8.000000e+01 -1.366016e-01 9.736250e-01
      4810   431_4753322 2013    Shannon 1.914441e-01 -1.728341e-02 1.085449e-01
      4811   431_4753322 2013    Simpson 9.070295e-02 -1.467598e-02 9.559345e-02
      4812   431_4753322 2013 invSimpson 1.099751e+00 -3.309624e-02 9.830495e-02
      4813   431_4753322 2013        PIE 9.179575e-02 -2.020849e-02 1.342383e-01
      4814   431_4753322 2013      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4815   431_4753322 2013 expShannon 1.210997e+00 -2.764794e-02 1.129655e-01
      4816   431_4753322 2014          S 2.000000e+00  1.213708e-02 5.838604e-01
      4817   431_4753322 2014          N 1.240000e+02 -8.162780e-01 8.748023e-01
      4818   431_4753322 2014       maxN 1.080000e+02 -1.366016e-01 9.736250e-01
      4819   431_4753322 2014    Shannon 3.845429e-01 -1.728341e-02 1.085449e-01
      4820   431_4753322 2014    Simpson 2.247659e-01 -1.467598e-02 9.559345e-02
      4821   431_4753322 2014 invSimpson 1.289933e+00 -3.309624e-02 9.830495e-02
      4822   431_4753322 2014        PIE 2.265932e-01 -2.020849e-02 1.342383e-01
      4823   431_4753322 2014      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4824   431_4753322 2014 expShannon 1.468943e+00 -2.764794e-02 1.129655e-01
      4825   431_4753322 2015          S 2.000000e+00  1.213708e-02 5.838604e-01
      4826   431_4753322 2015          N 1.200000e+01 -8.162780e-01 8.748023e-01
      4827   431_4753322 2015       maxN 1.100000e+01 -1.366016e-01 9.736250e-01
      4828   431_4753322 2015    Shannon 2.868360e-01 -1.728341e-02 1.085449e-01
      4829   431_4753322 2015    Simpson 1.527778e-01 -1.467598e-02 9.559345e-02
      4830   431_4753322 2015 invSimpson 1.180328e+00 -3.309624e-02 9.830495e-02
      4831   431_4753322 2015        PIE 1.666667e-01 -2.020849e-02 1.342383e-01
      4832   431_4753322 2015      DomMc 1.000000e+00 -6.841282e-05 6.018385e-01
      4833   431_4753322 2015 expShannon 1.332206e+00 -2.764794e-02 1.129655e-01
      4834   431_4744570 2008          S 3.000000e+00  1.190476e-01 2.122956e-01
      4835   431_4744570 2008          N 3.000000e+00 -1.083333e+01 5.839164e-01
      4836   431_4744570 2008       maxN 1.000000e+00 -1.085714e+01 5.859162e-01
      4837   431_4744570 2008    Shannon 1.098612e+00  1.183212e-01 2.581302e-01
      4838   431_4744570 2008    Simpson 6.666667e-01  7.419932e-02 2.463565e-01
      4839   431_4744570 2008 invSimpson 3.000000e+00  2.326624e-01 2.240371e-01
      4840   431_4744570 2008        PIE 1.000000e+00  1.138151e-01 2.350005e-01
      4841   431_4744570 2008      DomMc 6.666667e-01 -3.968254e-02 2.122956e-01
      4842   431_4744570 2008 expShannon 3.000000e+00  2.248783e-01 2.387228e-01
      4843   431_4744570 1999          S 2.000000e+00  1.190476e-01 2.122956e-01
      4844   431_4744570 1999          N 7.600000e+01 -1.083333e+01 5.839164e-01
      4845   431_4744570 1999       maxN 7.400000e+01 -1.085714e+01 5.859162e-01
      4846   431_4744570 1999    Shannon 1.216924e-01  1.183212e-01 2.581302e-01
      4847   431_4744570 1999    Simpson 5.124654e-02  7.419932e-02 2.463565e-01
      4848   431_4744570 1999 invSimpson 1.054015e+00  2.326624e-01 2.240371e-01
      4849   431_4744570 1999        PIE 5.192982e-02  1.138151e-01 2.350005e-01
      4850   431_4744570 1999      DomMc 1.000000e+00 -3.968254e-02 2.122956e-01
      4851   431_4744570 1999 expShannon 1.129407e+00  2.248783e-01 2.387228e-01
      4852   431_4744570 2002          S 2.000000e+00  1.190476e-01 2.122956e-01
      4853   431_4744570 2002          N 1.660000e+02 -1.083333e+01 5.839164e-01
      4854   431_4744570 2002       maxN 1.650000e+02 -1.085714e+01 5.859162e-01
      4855   431_4744570 2002    Shannon 3.680102e-02  1.183212e-01 2.581302e-01
      4856   431_4744570 2002    Simpson 1.197561e-02  7.419932e-02 2.463565e-01
      4857   431_4744570 2002 invSimpson 1.012121e+00  2.326624e-01 2.240371e-01
      4858   431_4744570 2002        PIE 1.204819e-02  1.138151e-01 2.350005e-01
      4859   431_4744570 2002      DomMc 1.000000e+00 -3.968254e-02 2.122956e-01
      4860   431_4744570 2002 expShannon 1.037487e+00  2.248783e-01 2.387228e-01
      4861   431_4751864 2006          S 3.000000e+00 -2.692308e-01 1.544210e-01
      4862   431_4751864 2006          N 1.400000e+01  1.257692e+01 8.504796e-01
      4863   431_4751864 2006       maxN 8.000000e+00  2.096154e+01 5.365216e-01
      4864   431_4751864 2006    Shannon 8.760058e-01 -1.829371e-01 1.431798e-01
      4865   431_4751864 2006    Simpson 5.408163e-01 -1.213760e-01 1.604022e-01
      4866   431_4751864 2006 invSimpson 2.177778e+00 -2.918214e-01 1.663184e-01
      4867   431_4751864 2006        PIE 5.824176e-01 -1.293542e-01 1.143776e-01
      4868   431_4751864 2006      DomMc 9.285714e-01  1.792036e-02 7.779751e-03
      4869   431_4751864 2006 expShannon 2.401289e+00 -3.175608e-01 1.389538e-01
      4870   431_4751864 2007          S 3.000000e+00 -2.692308e-01 1.544210e-01
      4871   431_4751864 2007          N 2.390000e+02  1.257692e+01 8.504796e-01
      4872   431_4751864 2007       maxN 1.240000e+02  2.096154e+01 5.365216e-01
      4873   431_4751864 2007    Shannon 8.622105e-01 -1.829371e-01 1.431798e-01
      4874   431_4751864 2007    Simpson 5.457187e-01 -1.213760e-01 1.604022e-01
      4875   431_4751864 2007 invSimpson 2.201279e+00 -2.918214e-01 1.663184e-01
      4876   431_4751864 2007        PIE 5.480117e-01 -1.293542e-01 1.143776e-01
      4877   431_4751864 2007      DomMc 9.456067e-01  1.792036e-02 7.779751e-03
      4878   431_4751864 2007 expShannon 2.368390e+00 -3.175608e-01 1.389538e-01
      4879   431_4751864 2010          S 2.000000e+00 -2.692308e-01 1.544210e-01
      4880   431_4751864 2010          N 1.250000e+02  1.257692e+01 8.504796e-01
      4881   431_4751864 2010       maxN 1.190000e+02  2.096154e+01 5.365216e-01
      4882   431_4751864 2010    Shannon 1.925837e-01 -1.829371e-01 1.431798e-01
      4883   431_4751864 2010    Simpson 9.139200e-02 -1.213760e-01 1.604022e-01
      4884   431_4751864 2010 invSimpson 1.100585e+00 -2.918214e-01 1.663184e-01
      4885   431_4751864 2010        PIE 9.212903e-02 -1.293542e-01 1.143776e-01
      4886   431_4751864 2010      DomMc 1.000000e+00  1.792036e-02 7.779751e-03
      4887   431_4751864 2010 expShannon 1.212378e+00 -3.175608e-01 1.389538e-01
      4888   431_4752592 2000          S 3.000000e+00 -9.210526e-02 4.065197e-01
      4889   431_4752592 2000          N 6.100000e+01  1.000000e+00 8.959222e-01
      4890   431_4752592 2000       maxN 3.800000e+01  1.565789e+00 7.642853e-01
      4891   431_4752592 2000    Shannon 7.300344e-01 -1.689310e-02 4.487595e-01
      4892   431_4752592 2000    Simpson 4.815910e-01 -1.112792e-02 4.626870e-01
      4893   431_4752592 2000 invSimpson 1.928979e+00 -3.359025e-02 4.515393e-01
      4894   431_4752592 2000        PIE 4.896175e-01 -1.183611e-02 2.891558e-01
      4895   431_4752592 2000      DomMc 9.836066e-01  1.509922e-03 4.065197e-01
      4896   431_4752592 2000 expShannon 2.075152e+00 -3.203163e-02 4.448311e-01
      4897   431_4752592 2004          S 2.000000e+00 -9.210526e-02 4.065197e-01
      4898   431_4752592 2004          N 9.000000e+00  1.000000e+00 8.959222e-01
      4899   431_4752592 2004       maxN 7.000000e+00  1.565789e+00 7.642853e-01
      4900   431_4752592 2004    Shannon 5.297062e-01 -1.689310e-02 4.487595e-01
      4901   431_4752592 2004    Simpson 3.456790e-01 -1.112792e-02 4.626870e-01
      4902   431_4752592 2004 invSimpson 1.528302e+00 -3.359025e-02 4.515393e-01
      4903   431_4752592 2004        PIE 3.888889e-01 -1.183611e-02 2.891558e-01
      4904   431_4752592 2004      DomMc 1.000000e+00  1.509922e-03 4.065197e-01
      4905   431_4752592 2004 expShannon 1.698433e+00 -3.203163e-02 4.448311e-01
      4906   431_4752592 2010          S 2.000000e+00 -9.210526e-02 4.065197e-01
      4907   431_4752592 2010          N 6.400000e+01  1.000000e+00 8.959222e-01
      4908   431_4752592 2010       maxN 4.900000e+01  1.565789e+00 7.642853e-01
      4909   431_4752592 2010    Shannon 5.445089e-01 -1.689310e-02 4.487595e-01
      4910   431_4752592 2010    Simpson 3.588867e-01 -1.112792e-02 4.626870e-01
      4911   431_4752592 2010 invSimpson 1.559787e+00 -3.359025e-02 4.515393e-01
      4912   431_4752592 2010        PIE 3.645833e-01 -1.183611e-02 2.891558e-01
      4913   431_4752592 2010      DomMc 1.000000e+00  1.509922e-03 4.065197e-01
      4914   431_4752592 2010 expShannon 1.723762e+00 -3.203163e-02 4.448311e-01
      4915   431_4751135 2002          S 2.000000e+00 -3.781864e-17 5.456289e-01
      4916   431_4751135 2002          N 3.000000e+01 -9.285714e-01 8.629851e-01
      4917   431_4751135 2002       maxN 2.400000e+01 -7.142857e-02 9.881448e-01
      4918   431_4751135 2002    Shannon 5.004024e-01 -7.428825e-02 3.737079e-01
      4919   431_4751135 2002    Simpson 3.200000e-01 -5.821294e-02 4.112069e-01
      4920   431_4751135 2002 invSimpson 1.470588e+00 -1.106752e-01 5.135421e-01
      4921   431_4751135 2002        PIE 3.310345e-01 -6.429744e-02 4.707128e-01
      4922   431_4751135 2002      DomMc 1.000000e+00 -1.890932e-17 5.456289e-01
      4923   431_4751135 2002 expShannon 1.649385e+00 -1.114607e-01 4.147888e-01
      4924   431_4751135 2003          S 2.000000e+00 -3.781864e-17 5.456289e-01
      4925   431_4751135 2003          N 7.000000e+00 -9.285714e-01 8.629851e-01
      4926   431_4751135 2003       maxN 4.000000e+00 -7.142857e-02 9.881448e-01
      4927   431_4751135 2003    Shannon 6.829081e-01 -7.428825e-02 3.737079e-01
      4928   431_4751135 2003    Simpson 4.897959e-01 -5.821294e-02 4.112069e-01
      4929   431_4751135 2003 invSimpson 1.960000e+00 -1.106752e-01 5.135421e-01
      4930   431_4751135 2003        PIE 5.714286e-01 -6.429744e-02 4.707128e-01
      4931   431_4751135 2003      DomMc 1.000000e+00 -1.890932e-17 5.456289e-01
      4932   431_4751135 2003 expShannon 1.979626e+00 -1.114607e-01 4.147888e-01
      4933   431_4751135 2007          S 2.000000e+00 -3.781864e-17 5.456289e-01
      4934   431_4751135 2007          N 1.800000e+01 -9.285714e-01 8.629851e-01
      4935   431_4751135 2007       maxN 1.700000e+01 -7.142857e-02 9.881448e-01
      4936   431_4751135 2007    Shannon 2.145592e-01 -7.428825e-02 3.737079e-01
      4937   431_4751135 2007    Simpson 1.049383e-01 -5.821294e-02 4.112069e-01
      4938   431_4751135 2007 invSimpson 1.117241e+00 -1.106752e-01 5.135421e-01
      4939   431_4751135 2007        PIE 1.111111e-01 -6.429744e-02 4.707128e-01
      4940   431_4751135 2007      DomMc 1.000000e+00 -1.890932e-17 5.456289e-01
      4941   431_4751135 2007 expShannon 1.239315e+00 -1.114607e-01 4.147888e-01
      4942    466_544452 1986          S 2.700000e+01 -5.919003e-02 8.560994e-01
      4943    466_544452 1986          N 2.866000e+03 -1.308157e+02 6.217510e-01
      4944    466_544452 1986       maxN 2.228000e+03 -7.772430e+01 2.867777e-01
      4945    466_544452 1986    Shannon 9.698807e-01  1.872738e-02 1.563021e-01
      4946    466_544452 1986    Simpson 3.863649e-01  6.936803e-03 4.236760e-01
      4947    466_544452 1986 invSimpson 1.629633e+00  3.797686e-02 5.149626e-01
      4948    466_544452 1986        PIE 3.864997e-01  6.957521e-03 4.224391e-01
      4949    466_544452 1986      DomMc 8.384508e-01 -4.625993e-03 4.750129e-01
      4950    466_544452 1986 expShannon 2.637630e+00  6.943368e-02 1.621445e-01
      4951    466_544452 1995          S 1.800000e+01 -5.919003e-02 8.560994e-01
      4952    466_544452 1995          N 1.161000e+04 -1.308157e+02 6.217510e-01
      4953    466_544452 1995       maxN 3.849000e+03 -7.772430e+01 2.867777e-01
      4954    466_544452 1995    Shannon 1.474123e+00  1.872738e-02 1.563021e-01
      4955    466_544452 1995    Simpson 7.474689e-01  6.936803e-03 4.236760e-01
      4956    466_544452 1995 invSimpson 3.959908e+00  3.797686e-02 5.149626e-01
      4957    466_544452 1995        PIE 7.475333e-01  6.957521e-03 4.224391e-01
      4958    466_544452 1995      DomMc 5.747631e-01 -4.625993e-03 4.750129e-01
      4959    466_544452 1995 expShannon 4.367205e+00  6.943368e-02 1.621445e-01
      4960    466_544452 2006          S 2.100000e+01 -5.919003e-02 8.560994e-01
      4961    466_544452 2006          N 1.950000e+03 -1.308157e+02 6.217510e-01
      4962    466_544452 2006       maxN 1.272000e+03 -7.772430e+01 2.867777e-01
      4963    466_544452 2006    Shannon 1.294313e+00  1.872738e-02 1.563021e-01
      4964    466_544452 2006    Simpson 5.507766e-01  6.936803e-03 4.236760e-01
      4965    466_544452 2006 invSimpson 2.226064e+00  3.797686e-02 5.149626e-01
      4966    466_544452 2006        PIE 5.510592e-01  6.957521e-03 4.224391e-01
      4967    466_544452 2006      DomMc 7.579487e-01 -4.625993e-03 4.750129e-01
      4968    466_544452 2006 expShannon 3.648488e+00  6.943368e-02 1.621445e-01
      4969    466_544452 2007          S 1.800000e+01 -5.919003e-02 8.560994e-01
      4970    466_544452 2007          N 9.430000e+02 -1.308157e+02 6.217510e-01
      4971    466_544452 2007       maxN 4.240000e+02 -7.772430e+01 2.867777e-01
      4972    466_544452 2007    Shannon 1.625914e+00  1.872738e-02 1.563021e-01
      4973    466_544452 2007    Simpson 7.171917e-01  6.936803e-03 4.236760e-01
      4974    466_544452 2007 invSimpson 3.535964e+00  3.797686e-02 5.149626e-01
      4975    466_544452 2007        PIE 7.179530e-01  6.957521e-03 4.224391e-01
      4976    466_544452 2007      DomMc 6.914104e-01 -4.625993e-03 4.750129e-01
      4977    466_544452 2007 expShannon 5.083060e+00  6.943368e-02 1.621445e-01
      4978    466_544452 1988          S 1.300000e+01 -5.919003e-02 8.560994e-01
      4979    466_544452 1988          N 3.934000e+03 -1.308157e+02 6.217510e-01
      4980    466_544452 1988       maxN 2.153000e+03 -7.772430e+01 2.867777e-01
      4981    466_544452 1988    Shannon 1.225687e+00  1.872738e-02 1.563021e-01
      4982    466_544452 1988    Simpson 6.134500e-01  6.936803e-03 4.236760e-01
      4983    466_544452 1988 invSimpson 2.586987e+00  3.797686e-02 5.149626e-01
      4984    466_544452 1988        PIE 6.136059e-01  6.957521e-03 4.224391e-01
      4985    466_544452 1988      DomMc 8.169802e-01 -4.625993e-03 4.750129e-01
      4986    466_544452 1988 expShannon 3.406504e+00  6.943368e-02 1.621445e-01
      4987    466_541548 1986          S 1.800000e+01  3.165183e-02 7.945677e-01
      4988    466_541548 1986          N 9.830000e+02  1.868150e+01 6.580232e-01
      4989    466_541548 1986       maxN 4.790000e+02  1.150247e+01 7.275577e-01
      4990    466_541548 1986    Shannon 1.770016e+00  8.008615e-03 8.412924e-01
      4991    466_541548 1986    Simpson 7.207078e-01  3.874887e-03 8.098896e-01
      4992    466_541548 1986 invSimpson 3.580479e+00  3.149542e-02 8.060634e-01
      4993    466_541548 1986        PIE 7.214417e-01  3.885672e-03 8.097850e-01
      4994    466_541548 1986      DomMc 6.225839e-01 -1.214095e-03 9.086761e-01
      4995    466_541548 1986 expShannon 5.870949e+00  3.493630e-02 8.493084e-01
      4996    466_541548 1990          S 1.500000e+01  3.165183e-02 7.945677e-01
      4997    466_541548 1990          N 8.540000e+02  1.868150e+01 6.580232e-01
      4998    466_541548 1990       maxN 6.700000e+02  1.150247e+01 7.275577e-01
      4999    466_541548 1990    Shannon 9.573302e-01  8.008615e-03 8.412924e-01
      5000    466_541548 1990    Simpson 3.763663e-01  3.874887e-03 8.098896e-01
      5001    466_541548 1990 invSimpson 1.603506e+00  3.149542e-02 8.060634e-01
      5002    466_541548 1990        PIE 3.768076e-01  3.885672e-03 8.097850e-01
      5003    466_541548 1990      DomMc 8.442623e-01 -1.214095e-03 9.086761e-01
      5004    466_541548 1990 expShannon 2.604733e+00  3.493630e-02 8.493084e-01
      5005    466_541548 2002          S 1.800000e+01  3.165183e-02 7.945677e-01
      5006    466_541548 2002          N 5.320000e+02  1.868150e+01 6.580232e-01
      5007    466_541548 2002       maxN 1.860000e+02  1.150247e+01 7.275577e-01
      5008    466_541548 2002    Shannon 1.997930e+00  8.008615e-03 8.412924e-01
      5009    466_541548 2002    Simpson 7.989216e-01  3.874887e-03 8.098896e-01
      5010    466_541548 2002 invSimpson 4.973186e+00  3.149542e-02 8.060634e-01
      5011    466_541548 2002        PIE 8.004262e-01  3.885672e-03 8.097850e-01
      5012    466_541548 2002      DomMc 5.789474e-01 -1.214095e-03 9.086761e-01
      5013    466_541548 2002 expShannon 7.373776e+00  3.493630e-02 8.493084e-01
      5014    466_541548 2005          S 1.700000e+01  3.165183e-02 7.945677e-01
      5015    466_541548 2005          N 1.718000e+03  1.868150e+01 6.580232e-01
      5016    466_541548 2005       maxN 1.110000e+03  1.150247e+01 7.275577e-01
      5017    466_541548 2005    Shannon 1.329667e+00  8.008615e-03 8.412924e-01
      5018    466_541548 2005    Simpson 5.596892e-01  3.874887e-03 8.098896e-01
      5019    466_541548 2005 invSimpson 2.271123e+00  3.149542e-02 8.060634e-01
      5020    466_541548 2005        PIE 5.600151e-01  3.885672e-03 8.097850e-01
      5021    466_541548 2005      DomMc 7.566938e-01 -1.214095e-03 9.086761e-01
      5022    466_541548 2005 expShannon 3.779786e+00  3.493630e-02 8.493084e-01
      5023    466_544451 1994          S 2.500000e+01  8.913910e-02 6.316489e-01
      5024    466_544451 1994          N 9.370000e+03 -2.347769e+02 4.686052e-01
      5025    466_544451 1994       maxN 3.946000e+03 -1.278410e+02 4.491227e-01
      5026    466_544451 1994    Shannon 1.493463e+00  2.114062e-03 8.164675e-01
      5027    466_544451 1994    Simpson 7.164845e-01  1.010149e-03 7.635523e-01
      5028    466_544451 1994 invSimpson 3.527144e+00  5.265292e-03 8.251805e-01
      5029    466_544451 1994        PIE 7.165610e-01  1.011924e-03 7.631877e-01
      5030    466_544451 1994      DomMc 6.495197e-01 -1.513367e-03 6.497072e-01
      5031    466_544451 1994 expShannon 4.452487e+00  1.997658e-03 9.507206e-01
      5032    466_544451 1989          S 2.300000e+01  8.913910e-02 6.316489e-01
      5033    466_544451 1989          N 1.195000e+03 -2.347769e+02 4.686052e-01
      5034    466_544451 1989       maxN 7.430000e+02 -1.278410e+02 4.491227e-01
      5035    466_544451 1989    Shannon 1.507135e+00  2.114062e-03 8.164675e-01
      5036    466_544451 1989    Simpson 5.914896e-01  1.010149e-03 7.635523e-01
      5037    466_544451 1989 invSimpson 2.447918e+00  5.265292e-03 8.251805e-01
      5038    466_544451 1989        PIE 5.919850e-01  1.011924e-03 7.631877e-01
      5039    466_544451 1989      DomMc 7.372385e-01 -1.513367e-03 6.497072e-01
      5040    466_544451 1989 expShannon 4.513778e+00  1.997658e-03 9.507206e-01
      5041    466_544451 1990          S 2.100000e+01  8.913910e-02 6.316489e-01
      5042    466_544451 1990          N 1.958000e+03 -2.347769e+02 4.686052e-01
      5043    466_544451 1990       maxN 8.550000e+02 -1.278410e+02 4.491227e-01
      5044    466_544451 1990    Shannon 1.595005e+00  2.114062e-03 8.164675e-01
      5045    466_544451 1990    Simpson 7.146491e-01  1.010149e-03 7.635523e-01
      5046    466_544451 1990 invSimpson 3.504457e+00  5.265292e-03 8.251805e-01
      5047    466_544451 1990        PIE 7.150143e-01  1.011924e-03 7.631877e-01
      5048    466_544451 1990      DomMc 6.813075e-01 -1.513367e-03 6.497072e-01
      5049    466_544451 1990 expShannon 4.928351e+00  1.997658e-03 9.507206e-01
      5050    466_544451 1991          S 1.600000e+01  8.913910e-02 6.316489e-01
      5051    466_544451 1991          N 8.553000e+03 -2.347769e+02 4.686052e-01
      5052    466_544451 1991       maxN 6.162000e+03 -1.278410e+02 4.491227e-01
      5053    466_544451 1991    Shannon 8.687252e-01  2.114062e-03 8.164675e-01
      5054    466_544451 1991    Simpson 4.374661e-01  1.010149e-03 7.635523e-01
      5055    466_544451 1991 invSimpson 1.777671e+00  5.265292e-03 8.251805e-01
      5056    466_544451 1991        PIE 4.375173e-01  1.011924e-03 7.631877e-01
      5057    466_544451 1991      DomMc 9.235356e-01 -1.513367e-03 6.497072e-01
      5058    466_544451 1991 expShannon 2.383870e+00  1.997658e-03 9.507206e-01
      5059    466_544451 1992          S 2.100000e+01  8.913910e-02 6.316489e-01
      5060    466_544451 1992          N 7.537000e+03 -2.347769e+02 4.686052e-01
      5061    466_544451 1992       maxN 4.476000e+03 -1.278410e+02 4.491227e-01
      5062    466_544451 1992    Shannon 1.153833e+00  2.114062e-03 8.164675e-01
      5063    466_544451 1992    Simpson 5.795249e-01  1.010149e-03 7.635523e-01
      5064    466_544451 1992 invSimpson 2.378262e+00  5.265292e-03 8.251805e-01
      5065    466_544451 1992        PIE 5.796018e-01  1.011924e-03 7.631877e-01
      5066    466_544451 1992      DomMc 8.222104e-01 -1.513367e-03 6.497072e-01
      5067    466_544451 1992 expShannon 3.170323e+00  1.997658e-03 9.507206e-01
      5068    466_544451 1993          S 1.400000e+01  8.913910e-02 6.316489e-01
      5069    466_544451 1993          N 2.487000e+04 -2.347769e+02 4.686052e-01
      5070    466_544451 1993       maxN 1.209000e+04 -1.278410e+02 4.491227e-01
      5071    466_544451 1993    Shannon 1.289998e+00  2.114062e-03 8.164675e-01
      5072    466_544451 1993    Simpson 6.695881e-01  1.010149e-03 7.635523e-01
      5073    466_544451 1993 invSimpson 3.026525e+00  5.265292e-03 8.251805e-01
      5074    466_544451 1993        PIE 6.696150e-01  1.011924e-03 7.631877e-01
      5075    466_544451 1993      DomMc 7.230800e-01 -1.513367e-03 6.497072e-01
      5076    466_544451 1993 expShannon 3.632779e+00  1.997658e-03 9.507206e-01
      5077    466_544451 1996          S 1.600000e+01  8.913910e-02 6.316489e-01
      5078    466_544451 1996          N 1.650400e+04 -2.347769e+02 4.686052e-01
      5079    466_544451 1996       maxN 7.667000e+03 -1.278410e+02 4.491227e-01
      5080    466_544451 1996    Shannon 1.170322e+00  2.114062e-03 8.164675e-01
      5081    466_544451 1996    Simpson 6.502343e-01  1.010149e-03 7.635523e-01
      5082    466_544451 1996 invSimpson 2.859056e+00  5.265292e-03 8.251805e-01
      5083    466_544451 1996        PIE 6.502737e-01  1.011924e-03 7.631877e-01
      5084    466_544451 1996      DomMc 7.484852e-01 -1.513367e-03 6.497072e-01
      5085    466_544451 1996 expShannon 3.223031e+00  1.997658e-03 9.507206e-01
      5086    466_544451 1998          S 1.800000e+01  8.913910e-02 6.316489e-01
      5087    466_544451 1998          N 3.117100e+04 -2.347769e+02 4.686052e-01
      5088    466_544451 1998       maxN 1.681700e+04 -1.278410e+02 4.491227e-01
      5089    466_544451 1998    Shannon 1.138125e+00  2.114062e-03 8.164675e-01
      5090    466_544451 1998    Simpson 6.136881e-01  1.010149e-03 7.635523e-01
      5091    466_544451 1998 invSimpson 2.588582e+00  5.265292e-03 8.251805e-01
      5092    466_544451 1998        PIE 6.137078e-01  1.011924e-03 7.631877e-01
      5093    466_544451 1998      DomMc 7.735395e-01 -1.513367e-03 6.497072e-01
      5094    466_544451 1998 expShannon 3.120912e+00  1.997658e-03 9.507206e-01
      5095    466_544451 1999          S 2.000000e+01  8.913910e-02 6.316489e-01
      5096    466_544451 1999          N 3.961000e+03 -2.347769e+02 4.686052e-01
      5097    466_544451 1999       maxN 1.430000e+03 -1.278410e+02 4.491227e-01
      5098    466_544451 1999    Shannon 1.589769e+00  2.114062e-03 8.164675e-01
      5099    466_544451 1999    Simpson 7.336104e-01  1.010149e-03 7.635523e-01
      5100    466_544451 1999 invSimpson 3.753901e+00  5.265292e-03 8.251805e-01
      5101    466_544451 1999        PIE 7.337957e-01  1.011924e-03 7.631877e-01
      5102    466_544451 1999      DomMc 6.723050e-01 -1.513367e-03 6.497072e-01
      5103    466_544451 1999 expShannon 4.902617e+00  1.997658e-03 9.507206e-01
      5104    466_544451 2000          S 2.200000e+01  8.913910e-02 6.316489e-01
      5105    466_544451 2000          N 4.133000e+03 -2.347769e+02 4.686052e-01
      5106    466_544451 2000       maxN 1.775000e+03 -1.278410e+02 4.491227e-01
      5107    466_544451 2000    Shannon 1.413496e+00  2.114062e-03 8.164675e-01
      5108    466_544451 2000    Simpson 6.987025e-01  1.010149e-03 7.635523e-01
      5109    466_544451 2000 invSimpson 3.318978e+00  5.265292e-03 8.251805e-01
      5110    466_544451 2000        PIE 6.988715e-01  1.011924e-03 7.631877e-01
      5111    466_544451 2000      DomMc 6.798935e-01 -1.513367e-03 6.497072e-01
      5112    466_544451 2000 expShannon 4.110300e+00  1.997658e-03 9.507206e-01
      5113    466_544451 2001          S 1.800000e+01  8.913910e-02 6.316489e-01
      5114    466_544451 2001          N 5.875000e+03 -2.347769e+02 4.686052e-01
      5115    466_544451 2001       maxN 3.920000e+03 -1.278410e+02 4.491227e-01
      5116    466_544451 2001    Shannon 9.164885e-01  2.114062e-03 8.164675e-01
      5117    466_544451 2001    Simpson 4.904863e-01  1.010149e-03 7.635523e-01
      5118    466_544451 2001 invSimpson 1.962656e+00  5.265292e-03 8.251805e-01
      5119    466_544451 2001        PIE 4.905698e-01  1.011924e-03 7.631877e-01
      5120    466_544451 2001      DomMc 9.123404e-01 -1.513367e-03 6.497072e-01
      5121    466_544451 2001 expShannon 2.500494e+00  1.997658e-03 9.507206e-01
      5122    466_544451 2002          S 1.900000e+01  8.913910e-02 6.316489e-01
      5123    466_544451 2002          N 3.932000e+03 -2.347769e+02 4.686052e-01
      5124    466_544451 2002       maxN 1.999000e+03 -1.278410e+02 4.491227e-01
      5125    466_544451 2002    Shannon 1.349875e+00  2.114062e-03 8.164675e-01
      5126    466_544451 2002    Simpson 6.616111e-01  1.010149e-03 7.635523e-01
      5127    466_544451 2002 invSimpson 2.955179e+00  5.265292e-03 8.251805e-01
      5128    466_544451 2002        PIE 6.617794e-01  1.011924e-03 7.631877e-01
      5129    466_544451 2002      DomMc 7.253306e-01 -1.513367e-03 6.497072e-01
      5130    466_544451 2002 expShannon 3.856942e+00  1.997658e-03 9.507206e-01
      5131    466_544451 2003          S 2.300000e+01  8.913910e-02 6.316489e-01
      5132    466_544451 2003          N 4.444000e+03 -2.347769e+02 4.686052e-01
      5133    466_544451 2003       maxN 1.717000e+03 -1.278410e+02 4.491227e-01
      5134    466_544451 2003    Shannon 1.530192e+00  2.114062e-03 8.164675e-01
      5135    466_544451 2003    Simpson 7.165688e-01  1.010149e-03 7.635523e-01
      5136    466_544451 2003 invSimpson 3.528193e+00  5.265292e-03 8.251805e-01
      5137    466_544451 2003        PIE 7.167300e-01  1.011924e-03 7.631877e-01
      5138    466_544451 2003      DomMc 7.216472e-01 -1.513367e-03 6.497072e-01
      5139    466_544451 2003 expShannon 4.619065e+00  1.997658e-03 9.507206e-01
      5140    466_544451 2006          S 1.500000e+01  8.913910e-02 6.316489e-01
      5141    466_544451 2006          N 2.515000e+03 -2.347769e+02 4.686052e-01
      5142    466_544451 2006       maxN 1.001000e+03 -1.278410e+02 4.491227e-01
      5143    466_544451 2006    Shannon 1.406386e+00  2.114062e-03 8.164675e-01
      5144    466_544451 2006    Simpson 7.005278e-01  1.010149e-03 7.635523e-01
      5145    466_544451 2006 invSimpson 3.339208e+00  5.265292e-03 8.251805e-01
      5146    466_544451 2006        PIE 7.008065e-01  1.011924e-03 7.631877e-01
      5147    466_544451 2006      DomMc 7.041750e-01 -1.513367e-03 6.497072e-01
      5148    466_544451 2006 expShannon 4.081181e+00  1.997658e-03 9.507206e-01
      5149    466_544451 2007          S 1.900000e+01  8.913910e-02 6.316489e-01
      5150    466_544451 2007          N 2.309000e+03 -2.347769e+02 4.686052e-01
      5151    466_544451 2007       maxN 1.486000e+03 -1.278410e+02 4.491227e-01
      5152    466_544451 2007    Shannon 1.216419e+00  2.114062e-03 8.164675e-01
      5153    466_544451 2007    Simpson 5.478928e-01  1.010149e-03 7.635523e-01
      5154    466_544451 2007 invSimpson 2.211865e+00  5.265292e-03 8.251805e-01
      5155    466_544451 2007        PIE 5.481302e-01  1.011924e-03 7.631877e-01
      5156    466_544451 2007      DomMc 8.094413e-01 -1.513367e-03 6.497072e-01
      5157    466_544451 2007 expShannon 3.375078e+00  1.997658e-03 9.507206e-01
      5158    466_544451 2008          S 1.800000e+01  8.913910e-02 6.316489e-01
      5159    466_544451 2008          N 1.339000e+03 -2.347769e+02 4.686052e-01
      5160    466_544451 2008       maxN 8.360000e+02 -1.278410e+02 4.491227e-01
      5161    466_544451 2008    Shannon 1.262889e+00  2.114062e-03 8.164675e-01
      5162    466_544451 2008    Simpson 5.698433e-01  1.010149e-03 7.635523e-01
      5163    466_544451 2008 invSimpson 2.324734e+00  5.265292e-03 8.251805e-01
      5164    466_544451 2008        PIE 5.702692e-01  1.011924e-03 7.631877e-01
      5165    466_544451 2008      DomMc 7.819268e-01 -1.513367e-03 6.497072e-01
      5166    466_544451 2008 expShannon 3.535622e+00  1.997658e-03 9.507206e-01
      5167    466_544451 2004          S 1.400000e+01  8.913910e-02 6.316489e-01
      5168    466_544451 2004          N 7.255000e+03 -2.347769e+02 4.686052e-01
      5169    466_544451 2004       maxN 4.262000e+03 -1.278410e+02 4.491227e-01
      5170    466_544451 2004    Shannon 1.036075e+00  2.114062e-03 8.164675e-01
      5171    466_544451 2004    Simpson 5.732480e-01  1.010149e-03 7.635523e-01
      5172    466_544451 2004 invSimpson 2.343281e+00  5.265292e-03 8.251805e-01
      5173    466_544451 2004        PIE 5.733270e-01  1.011924e-03 7.631877e-01
      5174    466_544451 2004      DomMc 8.202619e-01 -1.513367e-03 6.497072e-01
      5175    466_544451 2004 expShannon 2.818134e+00  1.997658e-03 9.507206e-01
      5176    466_544451 1988          S 4.000000e+00  8.913910e-02 6.316489e-01
      5177    466_544451 1988          N 2.939000e+03 -2.347769e+02 4.686052e-01
      5178    466_544451 1988       maxN 1.652000e+03 -1.278410e+02 4.491227e-01
      5179    466_544451 1988    Shannon 9.480410e-01  2.114062e-03 8.164675e-01
      5180    466_544451 1988    Simpson 5.563194e-01  1.010149e-03 7.635523e-01
      5181    466_544451 1988 invSimpson 2.253874e+00  5.265292e-03 8.251805e-01
      5182    466_544451 1988        PIE 5.565088e-01  1.011924e-03 7.631877e-01
      5183    466_544451 1988      DomMc 9.118748e-01 -1.513367e-03 6.497072e-01
      5184    466_544451 1988 expShannon 2.580649e+00  1.997658e-03 9.507206e-01
      5185    466_541547 1991          S 1.700000e+01 -6.114508e-03 9.739068e-01
      5186    466_541547 1991          N 3.283000e+03 -6.874138e+01 5.014574e-01
      5187    466_541547 1991       maxN 1.851000e+03 -4.647582e+01 4.782098e-01
      5188    466_541547 1991    Shannon 1.162762e+00  2.490455e-02 1.553560e-01
      5189    466_541547 1991    Simpson 5.875541e-01  8.960237e-03 1.649473e-01
      5190    466_541547 1991 invSimpson 2.424560e+00  6.573561e-02 1.771377e-01
      5191    466_541547 1991        PIE 5.877331e-01  8.991602e-03 1.639251e-01
      5192    466_541547 1991      DomMc 8.604935e-01 -8.272474e-03 1.518765e-01
      5193    466_541547 1991 expShannon 3.198757e+00  9.994219e-02 1.647448e-01
      5194    466_541547 1994          S 1.800000e+01 -6.114508e-03 9.739068e-01
      5195    466_541547 1994          N 9.130000e+02 -6.874138e+01 5.014574e-01
      5196    466_541547 1994       maxN 3.750000e+02 -4.647582e+01 4.782098e-01
      5197    466_541547 1994    Shannon 1.813258e+00  2.490455e-02 1.553560e-01
      5198    466_541547 1994    Simpson 7.623004e-01  8.960237e-03 1.649473e-01
      5199    466_541547 1994 invSimpson 4.206991e+00  6.573561e-02 1.771377e-01
      5200    466_541547 1994        PIE 7.631363e-01  8.991602e-03 1.639251e-01
      5201    466_541547 1994      DomMc 6.199343e-01 -8.272474e-03 1.518765e-01
      5202    466_541547 1994 expShannon 6.130391e+00  9.994219e-02 1.647448e-01
      5203    466_541547 1998          S 2.000000e+01 -6.114508e-03 9.739068e-01
      5204    466_541547 1998          N 7.741000e+03 -6.874138e+01 5.014574e-01
      5205    466_541547 1998       maxN 3.907000e+03 -4.647582e+01 4.782098e-01
      5206    466_541547 1998    Shannon 1.169501e+00  2.490455e-02 1.553560e-01
      5207    466_541547 1998    Simpson 6.026717e-01  8.960237e-03 1.649473e-01
      5208    466_541547 1998 invSimpson 2.516810e+00  6.573561e-02 1.771377e-01
      5209    466_541547 1998        PIE 6.027495e-01  8.991602e-03 1.639251e-01
      5210    466_541547 1998      DomMc 8.762434e-01 -8.272474e-03 1.518765e-01
      5211    466_541547 1998 expShannon 3.220386e+00  9.994219e-02 1.647448e-01
      5212    466_541547 2000          S 2.000000e+01 -6.114508e-03 9.739068e-01
      5213    466_541547 2000          N 2.243000e+03 -6.874138e+01 5.014574e-01
      5214    466_541547 2000       maxN 1.049000e+03 -4.647582e+01 4.782098e-01
      5215    466_541547 2000    Shannon 1.553746e+00  2.490455e-02 1.553560e-01
      5216    466_541547 2000    Simpson 7.084606e-01  8.960237e-03 1.649473e-01
      5217    466_541547 2000 invSimpson 3.430068e+00  6.573561e-02 1.771377e-01
      5218    466_541547 2000        PIE 7.087766e-01  8.991602e-03 1.639251e-01
      5219    466_541547 2000      DomMc 6.758805e-01 -8.272474e-03 1.518765e-01
      5220    466_541547 2000 expShannon 4.729155e+00  9.994219e-02 1.647448e-01
      5221    466_541547 2003          S 1.900000e+01 -6.114508e-03 9.739068e-01
      5222    466_541547 2003          N 3.598000e+03 -6.874138e+01 5.014574e-01
      5223    466_541547 2003       maxN 2.566000e+03 -4.647582e+01 4.782098e-01
      5224    466_541547 2003    Shannon 1.071898e+00  2.490455e-02 1.553560e-01
      5225    466_541547 2003    Simpson 4.690786e-01  8.960237e-03 1.649473e-01
      5226    466_541547 2003 invSimpson 1.883518e+00  6.573561e-02 1.771377e-01
      5227    466_541547 2003        PIE 4.692090e-01  8.991602e-03 1.639251e-01
      5228    466_541547 2003      DomMc 8.396331e-01 -8.272474e-03 1.518765e-01
      5229    466_541547 2003 expShannon 2.920917e+00  9.994219e-02 1.647448e-01
      5230    466_541547 1988          S 1.400000e+01 -6.114508e-03 9.739068e-01
      5231    466_541547 1988          N 5.130000e+02 -6.874138e+01 5.014574e-01
      5232    466_541547 1988       maxN 3.970000e+02 -4.647582e+01 4.782098e-01
      5233    466_541547 1988    Shannon 9.381179e-01  2.490455e-02 1.553560e-01
      5234    466_541547 1988    Simpson 3.893088e-01  8.960237e-03 1.649473e-01
      5235    466_541547 1988 invSimpson 1.637489e+00  6.573561e-02 1.771377e-01
      5236    466_541547 1988        PIE 3.900691e-01  8.991602e-03 1.639251e-01
      5237    466_541547 1988      DomMc 8.557505e-01 -8.272474e-03 1.518765e-01
      5238    466_541547 1988 expShannon 2.555168e+00  9.994219e-02 1.647448e-01
      5239    466_541547 1995          S 1.400000e+01 -6.114508e-03 9.739068e-01
      5240    466_541547 1995          N 2.373000e+03 -6.874138e+01 5.014574e-01
      5241    466_541547 1995       maxN 1.007000e+03 -4.647582e+01 4.782098e-01
      5242    466_541547 1995    Shannon 1.222586e+00  2.490455e-02 1.553560e-01
      5243    466_541547 1995    Simpson 6.630372e-01  8.960237e-03 1.649473e-01
      5244    466_541547 1995 invSimpson 2.967687e+00  6.573561e-02 1.771377e-01
      5245    466_541547 1995        PIE 6.633167e-01  8.991602e-03 1.639251e-01
      5246    466_541547 1995      DomMc 7.597977e-01 -8.272474e-03 1.518765e-01
      5247    466_541547 1995 expShannon 3.395957e+00  9.994219e-02 1.647448e-01
      5248    466_541547 2001          S 1.200000e+01 -6.114508e-03 9.739068e-01
      5249    466_541547 2001          N 1.703000e+03 -6.874138e+01 5.014574e-01
      5250    466_541547 2001       maxN 8.660000e+02 -4.647582e+01 4.782098e-01
      5251    466_541547 2001    Shannon 1.398977e+00  2.490455e-02 1.553560e-01
      5252    466_541547 2001    Simpson 6.703869e-01  8.960237e-03 1.649473e-01
      5253    466_541547 2001 invSimpson 3.033860e+00  6.573561e-02 1.771377e-01
      5254    466_541547 2001        PIE 6.707807e-01  8.991602e-03 1.639251e-01
      5255    466_541547 2001      DomMc 7.146213e-01 -8.272474e-03 1.518765e-01
      5256    466_541547 2001 expShannon 4.051052e+00  9.994219e-02 1.647448e-01
      5257    466_541547 2006          S 1.200000e+01 -6.114508e-03 9.739068e-01
      5258    466_541547 2006          N 1.034000e+03 -6.874138e+01 5.014574e-01
      5259    466_541547 2006       maxN 5.070000e+02 -4.647582e+01 4.782098e-01
      5260    466_541547 2006    Shannon 1.349427e+00  2.490455e-02 1.553560e-01
      5261    466_541547 2006    Simpson 6.521705e-01  8.960237e-03 1.649473e-01
      5262    466_541547 2006 invSimpson 2.874972e+00  6.573561e-02 1.771377e-01
      5263    466_541547 2006        PIE 6.528018e-01  8.991602e-03 1.639251e-01
      5264    466_541547 2006      DomMc 8.007737e-01 -8.272474e-03 1.518765e-01
      5265    466_541547 2006 expShannon 3.855217e+00  9.994219e-02 1.647448e-01
      5266    466_541547 2007          S 2.300000e+01 -6.114508e-03 9.739068e-01
      5267    466_541547 2007          N 1.441000e+03 -6.874138e+01 5.014574e-01
      5268    466_541547 2007       maxN 4.950000e+02 -4.647582e+01 4.782098e-01
      5269    466_541547 2007    Shannon 2.016121e+00  2.490455e-02 1.553560e-01
      5270    466_541547 2007    Simpson 8.078379e-01  8.960237e-03 1.649473e-01
      5271    466_541547 2007 invSimpson 5.203939e+00  6.573561e-02 1.771377e-01
      5272    466_541547 2007        PIE 8.083989e-01  8.991602e-03 1.639251e-01
      5273    466_541547 2007      DomMc 5.558640e-01 -8.272474e-03 1.518765e-01
      5274    466_541547 2007 expShannon 7.509141e+00  9.994219e-02 1.647448e-01
      5275    466_541547 1997          S 1.200000e+01 -6.114508e-03 9.739068e-01
      5276    466_541547 1997          N 5.921000e+03 -6.874138e+01 5.014574e-01
      5277    466_541547 1997       maxN 4.567000e+03 -4.647582e+01 4.782098e-01
      5278    466_541547 1997    Shannon 6.863315e-01  2.490455e-02 1.553560e-01
      5279    466_541547 1997    Simpson 3.664680e-01  8.960237e-03 1.649473e-01
      5280    466_541547 1997 invSimpson 1.578452e+00  6.573561e-02 1.771377e-01
      5281    466_541547 1997        PIE 3.665299e-01  8.991602e-03 1.639251e-01
      5282    466_541547 1997      DomMc 9.670664e-01 -8.272474e-03 1.518765e-01
      5283    466_541547 1997 expShannon 1.986415e+00  9.994219e-02 1.647448e-01
      5284    466_541547 2004          S 1.500000e+01 -6.114508e-03 9.739068e-01
      5285    466_541547 2004          N 4.210000e+02 -6.874138e+01 5.014574e-01
      5286    466_541547 2004       maxN 1.780000e+02 -4.647582e+01 4.782098e-01
      5287    466_541547 2004    Shannon 1.731895e+00  2.490455e-02 1.553560e-01
      5288    466_541547 2004    Simpson 7.516771e-01  8.960237e-03 1.649473e-01
      5289    466_541547 2004 invSimpson 4.027015e+00  6.573561e-02 1.771377e-01
      5290    466_541547 2004        PIE 7.534668e-01  8.991602e-03 1.639251e-01
      5291    466_541547 2004      DomMc 6.128266e-01 -8.272474e-03 1.518765e-01
      5292    466_541547 2004 expShannon 5.651350e+00  9.994219e-02 1.647448e-01
      5293    466_541547 1996          S 1.500000e+01 -6.114508e-03 9.739068e-01
      5294    466_541547 1996          N 2.404000e+03 -6.874138e+01 5.014574e-01
      5295    466_541547 1996       maxN 1.732000e+03 -4.647582e+01 4.782098e-01
      5296    466_541547 1996    Shannon 7.316428e-01  2.490455e-02 1.553560e-01
      5297    466_541547 1996    Simpson 4.173732e-01  8.960237e-03 1.649473e-01
      5298    466_541547 1996 invSimpson 1.716365e+00  6.573561e-02 1.771377e-01
      5299    466_541547 1996        PIE 4.175469e-01  8.991602e-03 1.639251e-01
      5300    466_541547 1996      DomMc 9.721298e-01 -8.272474e-03 1.518765e-01
      5301    466_541547 1996 expShannon 2.078492e+00  9.994219e-02 1.647448e-01
      5302    466_541547 1999          S 1.100000e+01 -6.114508e-03 9.739068e-01
      5303    466_541547 1999          N 4.270000e+02 -6.874138e+01 5.014574e-01
      5304    466_541547 1999       maxN 2.490000e+02 -4.647582e+01 4.782098e-01
      5305    466_541547 1999    Shannon 1.305388e+00  2.490455e-02 1.553560e-01
      5306    466_541547 1999    Simpson 6.080656e-01  8.960237e-03 1.649473e-01
      5307    466_541547 1999 invSimpson 2.551448e+00  6.573561e-02 1.771377e-01
      5308    466_541547 1999        PIE 6.094930e-01  8.991602e-03 1.639251e-01
      5309    466_541547 1999      DomMc 7.751756e-01 -8.272474e-03 1.518765e-01
      5310    466_541547 1999 expShannon 3.689120e+00  9.994219e-02 1.647448e-01
      5311    466_541547 2008          S 1.000000e+01 -6.114508e-03 9.739068e-01
      5312    466_541547 2008          N 3.840000e+02 -6.874138e+01 5.014574e-01
      5313    466_541547 2008       maxN 2.490000e+02 -4.647582e+01 4.782098e-01
      5314    466_541547 2008    Shannon 1.106296e+00  2.490455e-02 1.553560e-01
      5315    466_541547 2008    Simpson 5.355360e-01  8.960237e-03 1.649473e-01
      5316    466_541547 2008 invSimpson 2.153020e+00  6.573561e-02 1.771377e-01
      5317    466_541547 2008        PIE 5.369343e-01  8.991602e-03 1.639251e-01
      5318    466_541547 2008      DomMc 7.968750e-01 -8.272474e-03 1.518765e-01
      5319    466_541547 2008 expShannon 3.023141e+00  9.994219e-02 1.647448e-01
      5320    466_544453 2002          S 2.000000e+01 -8.491379e-02 5.976034e-01
      5321    466_544453 2002          N 1.158900e+04 -2.009377e+02 3.413427e-01
      5322    466_544453 2002       maxN 8.595000e+03 -1.834693e+02 3.085649e-01
      5323    466_544453 2002    Shannon 8.131479e-01  1.501987e-02 3.486586e-01
      5324    466_544453 2002    Simpson 4.149122e-01  1.022341e-02 1.283711e-01
      5325    466_544453 2002 invSimpson 1.709145e+00  3.231611e-02 2.952968e-01
      5326    466_544453 2002        PIE 4.149480e-01  1.023749e-02 1.282442e-01
      5327    466_544453 2002      DomMc 9.195789e-01 -2.503884e-03 5.599869e-01
      5328    466_544453 2002 expShannon 2.254995e+00  2.773520e-02 6.102582e-01
      5329    466_544453 1991          S 2.600000e+01 -8.491379e-02 5.976034e-01
      5330    466_544453 1991          N 1.596800e+04 -2.009377e+02 3.413427e-01
      5331    466_544453 1991       maxN 1.442100e+04 -1.834693e+02 3.085649e-01
      5332    466_544453 1991    Shannon 4.652761e-01  1.501987e-02 3.486586e-01
      5333    466_544453 1991    Simpson 1.806733e-01  1.022341e-02 1.283711e-01
      5334    466_544453 1991 invSimpson 1.220514e+00  3.231611e-02 2.952968e-01
      5335    466_544453 1991        PIE 1.806847e-01  1.023749e-02 1.282442e-01
      5336    466_544453 1991      DomMc 9.621743e-01 -2.503884e-03 5.599869e-01
      5337    466_544453 1991 expShannon 1.592454e+00  2.773520e-02 6.102582e-01
      5338    466_544453 1992          S 2.200000e+01 -8.491379e-02 5.976034e-01
      5339    466_544453 1992          N 6.372000e+03 -2.009377e+02 3.413427e-01
      5340    466_544453 1992       maxN 3.163000e+03 -1.834693e+02 3.085649e-01
      5341    466_544453 1992    Shannon 1.263754e+00  1.501987e-02 3.486586e-01
      5342    466_544453 1992    Simpson 6.230881e-01  1.022341e-02 1.283711e-01
      5343    466_544453 1992 invSimpson 2.653140e+00  3.231611e-02 2.952968e-01
      5344    466_544453 1992        PIE 6.231859e-01  1.023749e-02 1.282442e-01
      5345    466_544453 1992      DomMc 8.485562e-01 -2.503884e-03 5.599869e-01
      5346    466_544453 1992 expShannon 3.538682e+00  2.773520e-02 6.102582e-01
      5347    466_544453 1993          S 2.500000e+01 -8.491379e-02 5.976034e-01
      5348    466_544453 1993          N 4.579000e+03 -2.009377e+02 3.413427e-01
      5349    466_544453 1993       maxN 2.722000e+03 -1.834693e+02 3.085649e-01
      5350    466_544453 1993    Shannon 1.193939e+00  1.501987e-02 3.486586e-01
      5351    466_544453 1993    Simpson 5.721961e-01  1.022341e-02 1.283711e-01
      5352    466_544453 1993 invSimpson 2.337520e+00  3.231611e-02 2.952968e-01
      5353    466_544453 1993        PIE 5.723211e-01  1.023749e-02 1.282442e-01
      5354    466_544453 1993      DomMc 8.565189e-01 -2.503884e-03 5.599869e-01
      5355    466_544453 1993 expShannon 3.300056e+00  2.773520e-02 6.102582e-01
      5356    466_544453 1994          S 2.200000e+01 -8.491379e-02 5.976034e-01
      5357    466_544453 1994          N 2.168000e+03 -2.009377e+02 3.413427e-01
      5358    466_544453 1994       maxN 1.021000e+03 -1.834693e+02 3.085649e-01
      5359    466_544453 1994    Shannon 1.839346e+00  1.501987e-02 3.486586e-01
      5360    466_544453 1994    Simpson 7.347999e-01  1.022341e-02 1.283711e-01
      5361    466_544453 1994 invSimpson 3.770737e+00  3.231611e-02 2.952968e-01
      5362    466_544453 1994        PIE 7.351390e-01  1.023749e-02 1.282442e-01
      5363    466_544453 1994      DomMc 6.268450e-01 -2.503884e-03 5.599869e-01
      5364    466_544453 1994 expShannon 6.292424e+00  2.773520e-02 6.102582e-01
      5365    466_544453 1996          S 1.700000e+01 -8.491379e-02 5.976034e-01
      5366    466_544453 1996          N 8.923000e+03 -2.009377e+02 3.413427e-01
      5367    466_544453 1996       maxN 6.181000e+03 -1.834693e+02 3.085649e-01
      5368    466_544453 1996    Shannon 9.801969e-01  1.501987e-02 3.486586e-01
      5369    466_544453 1996    Simpson 4.807168e-01  1.022341e-02 1.283711e-01
      5370    466_544453 1996 invSimpson 1.925731e+00  3.231611e-02 2.952968e-01
      5371    466_544453 1996        PIE 4.807707e-01  1.023749e-02 1.282442e-01
      5372    466_544453 1996      DomMc 8.730248e-01 -2.503884e-03 5.599869e-01
      5373    466_544453 1996 expShannon 2.664981e+00  2.773520e-02 6.102582e-01
      5374    466_544453 1997          S 1.800000e+01 -8.491379e-02 5.976034e-01
      5375    466_544453 1997          N 4.714000e+03 -2.009377e+02 3.413427e-01
      5376    466_544453 1997       maxN 3.475000e+03 -1.834693e+02 3.085649e-01
      5377    466_544453 1997    Shannon 9.630414e-01  1.501987e-02 3.486586e-01
      5378    466_544453 1997    Simpson 4.353576e-01  1.022341e-02 1.283711e-01
      5379    466_544453 1997 invSimpson 1.771032e+00  3.231611e-02 2.952968e-01
      5380    466_544453 1997        PIE 4.354500e-01  1.023749e-02 1.282442e-01
      5381    466_544453 1997      DomMc 8.538396e-01 -2.503884e-03 5.599869e-01
      5382    466_544453 1997 expShannon 2.619652e+00  2.773520e-02 6.102582e-01
      5383    466_544453 1998          S 2.000000e+01 -8.491379e-02 5.976034e-01
      5384    466_544453 1998          N 1.383900e+04 -2.009377e+02 3.413427e-01
      5385    466_544453 1998       maxN 1.066000e+04 -1.834693e+02 3.085649e-01
      5386    466_544453 1998    Shannon 7.983415e-01  1.501987e-02 3.486586e-01
      5387    466_544453 1998    Simpson 3.842089e-01  1.022341e-02 1.283711e-01
      5388    466_544453 1998 invSimpson 1.623927e+00  3.231611e-02 2.952968e-01
      5389    466_544453 1998        PIE 3.842367e-01  1.023749e-02 1.282442e-01
      5390    466_544453 1998      DomMc 8.938507e-01 -2.503884e-03 5.599869e-01
      5391    466_544453 1998 expShannon 2.221853e+00  2.773520e-02 6.102582e-01
      5392    466_544453 1999          S 1.700000e+01 -8.491379e-02 5.976034e-01
      5393    466_544453 1999          N 1.306000e+03 -2.009377e+02 3.413427e-01
      5394    466_544453 1999       maxN 7.670000e+02 -1.834693e+02 3.085649e-01
      5395    466_544453 1999    Shannon 1.333715e+00  1.501987e-02 3.486586e-01
      5396    466_544453 1999    Simpson 6.010415e-01  1.022341e-02 1.283711e-01
      5397    466_544453 1999 invSimpson 2.506526e+00  3.231611e-02 2.952968e-01
      5398    466_544453 1999        PIE 6.015021e-01  1.023749e-02 1.282442e-01
      5399    466_544453 1999      DomMc 7.978560e-01 -2.503884e-03 5.599869e-01
      5400    466_544453 1999 expShannon 3.795116e+00  2.773520e-02 6.102582e-01
      5401    466_544453 2000          S 1.900000e+01 -8.491379e-02 5.976034e-01
      5402    466_544453 2000          N 4.978000e+03 -2.009377e+02 3.413427e-01
      5403    466_544453 2000       maxN 1.994000e+03 -1.834693e+02 3.085649e-01
      5404    466_544453 2000    Shannon 1.314274e+00  1.501987e-02 3.486586e-01
      5405    466_544453 2000    Simpson 6.879390e-01  1.022341e-02 1.283711e-01
      5406    466_544453 2000 invSimpson 3.204502e+00  3.231611e-02 2.952968e-01
      5407    466_544453 2000        PIE 6.880772e-01  1.023749e-02 1.282442e-01
      5408    466_544453 2000      DomMc 6.960627e-01 -2.503884e-03 5.599869e-01
      5409    466_544453 2000 expShannon 3.722047e+00  2.773520e-02 6.102582e-01
      5410    466_544453 2003          S 1.800000e+01 -8.491379e-02 5.976034e-01
      5411    466_544453 2003          N 1.781000e+03 -2.009377e+02 3.413427e-01
      5412    466_544453 2003       maxN 8.150000e+02 -1.834693e+02 3.085649e-01
      5413    466_544453 2003    Shannon 1.434586e+00  1.501987e-02 3.486586e-01
      5414    466_544453 2003    Simpson 6.859820e-01  1.022341e-02 1.283711e-01
      5415    466_544453 2003 invSimpson 3.184530e+00  3.231611e-02 2.952968e-01
      5416    466_544453 2003        PIE 6.863673e-01  1.023749e-02 1.282442e-01
      5417    466_544453 2003      DomMc 7.478944e-01 -2.503884e-03 5.599869e-01
      5418    466_544453 2003 expShannon 4.197907e+00  2.773520e-02 6.102582e-01
      5419    466_544453 2004          S 1.800000e+01 -8.491379e-02 5.976034e-01
      5420    466_544453 2004          N 3.235000e+03 -2.009377e+02 3.413427e-01
      5421    466_544453 2004       maxN 1.818000e+03 -1.834693e+02 3.085649e-01
      5422    466_544453 2004    Shannon 1.168805e+00  1.501987e-02 3.486586e-01
      5423    466_544453 2004    Simpson 5.976449e-01  1.022341e-02 1.283711e-01
      5424    466_544453 2004 invSimpson 2.485367e+00  3.231611e-02 2.952968e-01
      5425    466_544453 2004        PIE 5.978297e-01  1.023749e-02 1.282442e-01
      5426    466_544453 2004      DomMc 8.256569e-01 -2.503884e-03 5.599869e-01
      5427    466_544453 2004 expShannon 3.218145e+00  2.773520e-02 6.102582e-01
      5428    466_544453 2006          S 1.600000e+01 -8.491379e-02 5.976034e-01
      5429    466_544453 2006          N 7.780000e+02 -2.009377e+02 3.413427e-01
      5430    466_544453 2006       maxN 4.320000e+02 -1.834693e+02 3.085649e-01
      5431    466_544453 2006    Shannon 1.518717e+00  1.501987e-02 3.486586e-01
      5432    466_544453 2006    Simpson 6.512711e-01  1.022341e-02 1.283711e-01
      5433    466_544453 2006 invSimpson 2.867557e+00  3.231611e-02 2.952968e-01
      5434    466_544453 2006        PIE 6.521093e-01  1.023749e-02 1.282442e-01
      5435    466_544453 2006      DomMc 6.979434e-01 -2.503884e-03 5.599869e-01
      5436    466_544453 2006 expShannon 4.566364e+00  2.773520e-02 6.102582e-01
      5437    466_544453 2007          S 2.100000e+01 -8.491379e-02 5.976034e-01
      5438    466_544453 2007          N 8.550000e+02 -2.009377e+02 3.413427e-01
      5439    466_544453 2007       maxN 5.120000e+02 -1.834693e+02 3.085649e-01
      5440    466_544453 2007    Shannon 1.357501e+00  1.501987e-02 3.486586e-01
      5441    466_544453 2007    Simpson 5.854984e-01  1.022341e-02 1.283711e-01
      5442    466_544453 2007 invSimpson 2.412536e+00  3.231611e-02 2.952968e-01
      5443    466_544453 2007        PIE 5.861840e-01  1.023749e-02 1.282442e-01
      5444    466_544453 2007      DomMc 8.245614e-01 -2.503884e-03 5.599869e-01
      5445    466_544453 2007 expShannon 3.886470e+00  2.773520e-02 6.102582e-01
      5446    466_544453 1989          S 1.700000e+01 -8.491379e-02 5.976034e-01
      5447    466_544453 1989          N 6.710000e+02 -2.009377e+02 3.413427e-01
      5448    466_544453 1989       maxN 3.870000e+02 -1.834693e+02 3.085649e-01
      5449    466_544453 1989    Shannon 1.656101e+00  1.501987e-02 3.486586e-01
      5450    466_544453 1989    Simpson 6.447614e-01  1.022341e-02 1.283711e-01
      5451    466_544453 1989 invSimpson 2.815009e+00  3.231611e-02 2.952968e-01
      5452    466_544453 1989        PIE 6.457237e-01  1.023749e-02 1.282442e-01
      5453    466_544453 1989      DomMc 6.602086e-01 -2.503884e-03 5.599869e-01
      5454    466_544453 1989 expShannon 5.238846e+00  2.773520e-02 6.102582e-01
      5455    466_544453 2001          S 1.400000e+01 -8.491379e-02 5.976034e-01
      5456    466_544453 2001          N 1.308000e+03 -2.009377e+02 3.413427e-01
      5457    466_544453 2001       maxN 7.040000e+02 -1.834693e+02 3.085649e-01
      5458    466_544453 2001    Shannon 1.255721e+00  1.501987e-02 3.486586e-01
      5459    466_544453 2001    Simpson 6.200972e-01  1.022341e-02 1.283711e-01
      5460    466_544453 2001 invSimpson 2.632252e+00  3.231611e-02 2.952968e-01
      5461    466_544453 2001        PIE 6.205717e-01  1.023749e-02 1.282442e-01
      5462    466_544453 2001      DomMc 8.195719e-01 -2.503884e-03 5.599869e-01
      5463    466_544453 2001 expShannon 3.510368e+00  2.773520e-02 6.102582e-01
      5464    466_544453 1988          S 1.200000e+01 -8.491379e-02 5.976034e-01
      5465    466_544453 1988          N 3.380000e+03 -2.009377e+02 3.413427e-01
      5466    466_544453 1988       maxN 2.888000e+03 -1.834693e+02 3.085649e-01
      5467    466_544453 1988    Shannon 6.398583e-01  1.501987e-02 3.486586e-01
      5468    466_544453 1988    Simpson 2.642973e-01  1.022341e-02 1.283711e-01
      5469    466_544453 1988 invSimpson 1.359245e+00  3.231611e-02 2.952968e-01
      5470    466_544453 1988        PIE 2.643755e-01  1.023749e-02 1.282442e-01
      5471    466_544453 1988      DomMc 9.109467e-01 -2.503884e-03 5.599869e-01
      5472    466_544453 1988 expShannon 1.896212e+00  2.773520e-02 6.102582e-01
      5473    466_540093 1992          S 2.300000e+01  8.134848e-02 6.806673e-01
      5474    466_540093 1992          N 5.760000e+02 -3.576182e+01 5.540873e-01
      5475    466_540093 1992       maxN 2.460000e+02 -1.127263e+01 8.125207e-01
      5476    466_540093 1992    Shannon 1.927954e+00 -3.407021e-03 8.859165e-01
      5477    466_540093 1992    Simpson 7.563477e-01 -6.121914e-03 4.830141e-01
      5478    466_540093 1992 invSimpson 4.104208e+00  5.314803e-03 9.396839e-01
      5479    466_540093 1992        PIE 7.576630e-01 -6.097392e-03 4.857471e-01
      5480    466_540093 1992      DomMc 6.423611e-01 -3.742591e-03 6.330550e-01
      5481    466_540093 1992 expShannon 6.875431e+00  3.193812e-03 9.751169e-01
      5482    466_540093 1993          S 2.000000e+01  8.134848e-02 6.806673e-01
      5483    466_540093 1993          N 1.692000e+03 -3.576182e+01 5.540873e-01
      5484    466_540093 1993       maxN 9.330000e+02 -1.127263e+01 8.125207e-01
      5485    466_540093 1993    Shannon 1.579249e+00 -3.407021e-03 8.859165e-01
      5486    466_540093 1993    Simpson 6.598651e-01 -6.121914e-03 4.830141e-01
      5487    466_540093 1993 invSimpson 2.940010e+00  5.314803e-03 9.396839e-01
      5488    466_540093 1993        PIE 6.602553e-01 -6.097392e-03 4.857471e-01
      5489    466_540093 1993      DomMc 6.950355e-01 -3.742591e-03 6.330550e-01
      5490    466_540093 1993 expShannon 4.851310e+00  3.193812e-03 9.751169e-01
      5491    466_540093 1988          S 1.300000e+01  8.134848e-02 6.806673e-01
      5492    466_540093 1988          N 1.648000e+03 -3.576182e+01 5.540873e-01
      5493    466_540093 1988       maxN 1.014000e+03 -1.127263e+01 8.125207e-01
      5494    466_540093 1988    Shannon 9.868793e-01 -3.407021e-03 8.859165e-01
      5495    466_540093 1988    Simpson 5.284878e-01 -6.121914e-03 4.830141e-01
      5496    466_540093 1988 invSimpson 2.120836e+00  5.314803e-03 9.396839e-01
      5497    466_540093 1988        PIE 5.288086e-01 -6.097392e-03 4.857471e-01
      5498    466_540093 1988      DomMc 9.150485e-01 -3.742591e-03 6.330550e-01
      5499    466_540093 1988 expShannon 2.682849e+00  3.193812e-03 9.751169e-01
      5500    466_540093 2006          S 1.700000e+01  8.134848e-02 6.806673e-01
      5501    466_540093 2006          N 3.670000e+02 -3.576182e+01 5.540873e-01
      5502    466_540093 2006       maxN 2.370000e+02 -1.127263e+01 8.125207e-01
      5503    466_540093 2006    Shannon 1.427687e+00 -3.407021e-03 8.859165e-01
      5504    466_540093 2006    Simpson 5.634313e-01 -6.121914e-03 4.830141e-01
      5505    466_540093 2006 invSimpson 2.290590e+00  5.314803e-03 9.396839e-01
      5506    466_540093 2006        PIE 5.649707e-01 -6.097392e-03 4.857471e-01
      5507    466_540093 2006      DomMc 7.574932e-01 -3.742591e-03 6.330550e-01
      5508    466_540093 2006 expShannon 4.169044e+00  3.193812e-03 9.751169e-01
      5509    466_540093 2007          S 2.300000e+01  8.134848e-02 6.806673e-01
      5510    466_540093 2007          N 5.670000e+02 -3.576182e+01 5.540873e-01
      5511    466_540093 2007       maxN 1.190000e+02 -1.127263e+01 8.125207e-01
      5512    466_540093 2007    Shannon 2.129299e+00 -3.407021e-03 8.859165e-01
      5513    466_540093 2007    Simpson 8.410739e-01 -6.121914e-03 4.830141e-01
      5514    466_540093 2007 invSimpson 6.292232e+00  5.314803e-03 9.396839e-01
      5515    466_540093 2007        PIE 8.425599e-01 -6.097392e-03 4.857471e-01
      5516    466_540093 2007      DomMc 4.162257e-01 -3.742591e-03 6.330550e-01
      5517    466_540093 2007 expShannon 8.408971e+00  3.193812e-03 9.751169e-01
      5518    466_540093 2008          S 1.800000e+01  8.134848e-02 6.806673e-01
      5519    466_540093 2008          N 1.119000e+03 -3.576182e+01 5.540873e-01
      5520    466_540093 2008       maxN 9.630000e+02 -1.127263e+01 8.125207e-01
      5521    466_540093 2008    Shannon 7.139281e-01 -3.407021e-03 8.859165e-01
      5522    466_540093 2008    Simpson 2.563999e-01 -6.121914e-03 4.830141e-01
      5523    466_540093 2008 invSimpson 1.344809e+00  5.314803e-03 9.396839e-01
      5524    466_540093 2008        PIE 2.566293e-01 -6.097392e-03 4.857471e-01
      5525    466_540093 2008      DomMc 8.990170e-01 -3.742591e-03 6.330550e-01
      5526    466_540093 2008 expShannon 2.041997e+00  3.193812e-03 9.751169e-01
      5527    466_540093 1996          S 1.200000e+01  8.134848e-02 6.806673e-01
      5528    466_540093 1996          N 3.803000e+03 -3.576182e+01 5.540873e-01
      5529    466_540093 1996       maxN 2.175000e+03 -1.127263e+01 8.125207e-01
      5530    466_540093 1996    Shannon 1.005848e+00 -3.407021e-03 8.859165e-01
      5531    466_540093 1996    Simpson 5.574064e-01 -6.121914e-03 4.830141e-01
      5532    466_540093 1996 invSimpson 2.259409e+00  5.314803e-03 9.396839e-01
      5533    466_540093 1996        PIE 5.575530e-01 -6.097392e-03 4.857471e-01
      5534    466_540093 1996      DomMc 9.040231e-01 -3.742591e-03 6.330550e-01
      5535    466_540093 1996 expShannon 2.734225e+00  3.193812e-03 9.751169e-01
      5536    466_540093 2003          S 1.400000e+01  8.134848e-02 6.806673e-01
      5537    466_540093 2003          N 1.681000e+03 -3.576182e+01 5.540873e-01
      5538    466_540093 2003       maxN 8.740000e+02 -1.127263e+01 8.125207e-01
      5539    466_540093 2003    Shannon 1.122825e+00 -3.407021e-03 8.859165e-01
      5540    466_540093 2003    Simpson 5.788402e-01 -6.121914e-03 4.830141e-01
      5541    466_540093 2003 invSimpson 2.374396e+00  5.314803e-03 9.396839e-01
      5542    466_540093 2003        PIE 5.791847e-01 -6.097392e-03 4.857471e-01
      5543    466_540093 2003      DomMc 9.066032e-01 -3.742591e-03 6.330550e-01
      5544    466_540093 2003 expShannon 3.073525e+00  3.193812e-03 9.751169e-01
      5545    466_540093 2004          S 1.500000e+01  8.134848e-02 6.806673e-01
      5546    466_540093 2004          N 3.953000e+03 -3.576182e+01 5.540873e-01
      5547    466_540093 2004       maxN 3.371000e+03 -1.127263e+01 8.125207e-01
      5548    466_540093 2004    Shannon 6.258393e-01 -3.407021e-03 8.859165e-01
      5549    466_540093 2004    Simpson 2.650163e-01 -6.121914e-03 4.830141e-01
      5550    466_540093 2004 invSimpson 1.360574e+00  5.314803e-03 9.396839e-01
      5551    466_540093 2004        PIE 2.650834e-01 -6.097392e-03 4.857471e-01
      5552    466_540093 2004      DomMc 9.294207e-01 -3.742591e-03 6.330550e-01
      5553    466_540093 2004 expShannon 1.869815e+00  3.193812e-03 9.751169e-01
      5554    466_540093 2005          S 1.400000e+01  8.134848e-02 6.806673e-01
      5555    466_540093 2005          N 4.020000e+02 -3.576182e+01 5.540873e-01
      5556    466_540093 2005       maxN 2.800000e+02 -1.127263e+01 8.125207e-01
      5557    466_540093 2005    Shannon 1.193931e+00 -3.407021e-03 8.859165e-01
      5558    466_540093 2005    Simpson 4.970050e-01 -6.121914e-03 4.830141e-01
      5559    466_540093 2005 invSimpson 1.988091e+00  5.314803e-03 9.396839e-01
      5560    466_540093 2005        PIE 4.982444e-01 -6.097392e-03 4.857471e-01
      5561    466_540093 2005      DomMc 7.786070e-01 -3.742591e-03 6.330550e-01
      5562    466_540093 2005 expShannon 3.300029e+00  3.193812e-03 9.751169e-01
      5563    466_540093 1995          S 1.200000e+01  8.134848e-02 6.806673e-01
      5564    466_540093 1995          N 1.820000e+03 -3.576182e+01 5.540873e-01
      5565    466_540093 1995       maxN 1.370000e+03 -1.127263e+01 8.125207e-01
      5566    466_540093 1995    Shannon 8.118022e-01 -3.407021e-03 8.859165e-01
      5567    466_540093 1995    Simpson 4.015505e-01 -6.121914e-03 4.830141e-01
      5568    466_540093 1995 invSimpson 1.670985e+00  5.314803e-03 9.396839e-01
      5569    466_540093 1995        PIE 4.017713e-01 -6.097392e-03 4.857471e-01
      5570    466_540093 1995      DomMc 9.258242e-01 -3.742591e-03 6.330550e-01
      5571    466_540093 1995 expShannon 2.251963e+00  3.193812e-03 9.751169e-01
      5572    466_548093 1992          S 2.700000e+01 -2.928137e-01 1.634520e-02
      5573    466_548093 1992          N 7.859000e+03 -4.335274e+02 2.180748e-01
      5574    466_548093 1992       maxN 5.340000e+03 -2.878430e+02 2.084735e-01
      5575    466_548093 1992    Shannon 1.059771e+00  1.645470e-02 3.870441e-02
      5576    466_548093 1992    Simpson 4.971647e-01  5.913855e-03 9.348923e-02
      5577    466_548093 1992 invSimpson 1.988723e+00  4.310140e-02 4.655636e-02
      5578    466_548093 1992        PIE 4.972280e-01  5.927397e-03 9.303996e-02
      5579    466_548093 1992      DomMc 8.694490e-01 -4.405062e-03 2.137567e-01
      5580    466_548093 1992 expShannon 2.885709e+00  6.016191e-02 2.377897e-02
      5581    466_548093 1986          S 2.300000e+01 -2.928137e-01 1.634520e-02
      5582    466_548093 1986          N 6.561000e+03 -4.335274e+02 2.180748e-01
      5583    466_548093 1986       maxN 3.735000e+03 -2.878430e+02 2.084735e-01
      5584    466_548093 1986    Shannon 1.151600e+00  1.645470e-02 3.870441e-02
      5585    466_548093 1986    Simpson 5.927910e-01  5.913855e-03 9.348923e-02
      5586    466_548093 1986 invSimpson 2.455742e+00  4.310140e-02 4.655636e-02
      5587    466_548093 1986        PIE 5.928814e-01  5.927397e-03 9.303996e-02
      5588    466_548093 1986      DomMc 8.195397e-01 -4.405062e-03 2.137567e-01
      5589    466_548093 1986 expShannon 3.163250e+00  6.016191e-02 2.377897e-02
      5590    466_548093 1987          S 1.700000e+01 -2.928137e-01 1.634520e-02
      5591    466_548093 1987          N 7.724000e+03 -4.335274e+02 2.180748e-01
      5592    466_548093 1987       maxN 4.407000e+03 -2.878430e+02 2.084735e-01
      5593    466_548093 1987    Shannon 1.124940e+00  1.645470e-02 3.870441e-02
      5594    466_548093 1987    Simpson 5.954222e-01  5.913855e-03 9.348923e-02
      5595    466_548093 1987 invSimpson 2.471713e+00  4.310140e-02 4.655636e-02
      5596    466_548093 1987        PIE 5.954993e-01  5.927397e-03 9.303996e-02
      5597    466_548093 1987      DomMc 7.955722e-01 -4.405062e-03 2.137567e-01
      5598    466_548093 1987 expShannon 3.080032e+00  6.016191e-02 2.377897e-02
      5599    466_548093 1993          S 1.900000e+01 -2.928137e-01 1.634520e-02
      5600    466_548093 1993          N 3.152000e+04 -4.335274e+02 2.180748e-01
      5601    466_548093 1993       maxN 2.156000e+04 -2.878430e+02 2.084735e-01
      5602    466_548093 1993    Shannon 9.351998e-01  1.645470e-02 3.870441e-02
      5603    466_548093 1993    Simpson 4.872396e-01  5.913855e-03 9.348923e-02
      5604    466_548093 1993 invSimpson 1.950228e+00  4.310140e-02 4.655636e-02
      5605    466_548093 1993        PIE 4.872550e-01  5.927397e-03 9.303996e-02
      5606    466_548093 1993      DomMc 8.599302e-01 -4.405062e-03 2.137567e-01
      5607    466_548093 1993 expShannon 2.547722e+00  6.016191e-02 2.377897e-02
      5608    466_548093 1995          S 2.200000e+01 -2.928137e-01 1.634520e-02
      5609    466_548093 1995          N 8.011000e+03 -4.335274e+02 2.180748e-01
      5610    466_548093 1995       maxN 3.973000e+03 -2.878430e+02 2.084735e-01
      5611    466_548093 1995    Shannon 1.221331e+00  1.645470e-02 3.870441e-02
      5612    466_548093 1995    Simpson 6.474941e-01  5.913855e-03 9.348923e-02
      5613    466_548093 1995 invSimpson 2.836832e+00  4.310140e-02 4.655636e-02
      5614    466_548093 1995        PIE 6.475749e-01  5.927397e-03 9.303996e-02
      5615    466_548093 1995      DomMc 7.373611e-01 -4.405062e-03 2.137567e-01
      5616    466_548093 1995 expShannon 3.391699e+00  6.016191e-02 2.377897e-02
      5617    466_548093 1996          S 1.900000e+01 -2.928137e-01 1.634520e-02
      5618    466_548093 1996          N 1.344100e+04 -4.335274e+02 2.180748e-01
      5619    466_548093 1996       maxN 9.883000e+03 -2.878430e+02 2.084735e-01
      5620    466_548093 1996    Shannon 8.349912e-01  1.645470e-02 3.870441e-02
      5621    466_548093 1996    Simpson 4.245649e-01  5.913855e-03 9.348923e-02
      5622    466_548093 1996 invSimpson 1.737815e+00  4.310140e-02 4.655636e-02
      5623    466_548093 1996        PIE 4.245965e-01  5.927397e-03 9.303996e-02
      5624    466_548093 1996      DomMc 9.113161e-01 -4.405062e-03 2.137567e-01
      5625    466_548093 1996 expShannon 2.304794e+00  6.016191e-02 2.377897e-02
      5626    466_548093 1997          S 1.900000e+01 -2.928137e-01 1.634520e-02
      5627    466_548093 1997          N 2.647900e+04 -4.335274e+02 2.180748e-01
      5628    466_548093 1997       maxN 1.388300e+04 -2.878430e+02 2.084735e-01
      5629    466_548093 1997    Shannon 1.044091e+00  1.645470e-02 3.870441e-02
      5630    466_548093 1997    Simpson 5.837357e-01  5.913855e-03 9.348923e-02
      5631    466_548093 1997 invSimpson 2.402320e+00  4.310140e-02 4.655636e-02
      5632    466_548093 1997        PIE 5.837577e-01  5.927397e-03 9.303996e-02
      5633    466_548093 1997      DomMc 8.903660e-01 -4.405062e-03 2.137567e-01
      5634    466_548093 1997 expShannon 2.840815e+00  6.016191e-02 2.377897e-02
      5635    466_548093 1998          S 2.000000e+01 -2.928137e-01 1.634520e-02
      5636    466_548093 1998          N 1.585400e+04 -4.335274e+02 2.180748e-01
      5637    466_548093 1998       maxN 5.709000e+03 -2.878430e+02 2.084735e-01
      5638    466_548093 1998    Shannon 1.239025e+00  1.645470e-02 3.870441e-02
      5639    466_548093 1998    Simpson 6.808953e-01  5.913855e-03 9.348923e-02
      5640    466_548093 1998 invSimpson 3.133768e+00  4.310140e-02 4.655636e-02
      5641    466_548093 1998        PIE 6.809383e-01  5.927397e-03 9.303996e-02
      5642    466_548093 1998      DomMc 6.914974e-01 -4.405062e-03 2.137567e-01
      5643    466_548093 1998 expShannon 3.452245e+00  6.016191e-02 2.377897e-02
      5644    466_548093 1999          S 1.400000e+01 -2.928137e-01 1.634520e-02
      5645    466_548093 1999          N 3.468000e+03 -4.335274e+02 2.180748e-01
      5646    466_548093 1999       maxN 1.473000e+03 -2.878430e+02 2.084735e-01
      5647    466_548093 1999    Shannon 1.326323e+00  1.645470e-02 3.870441e-02
      5648    466_548093 1999    Simpson 6.861262e-01  5.913855e-03 9.348923e-02
      5649    466_548093 1999 invSimpson 3.185994e+00  4.310140e-02 4.655636e-02
      5650    466_548093 1999        PIE 6.863241e-01  5.927397e-03 9.303996e-02
      5651    466_548093 1999      DomMc 6.957901e-01 -4.405062e-03 2.137567e-01
      5652    466_548093 1999 expShannon 3.767167e+00  6.016191e-02 2.377897e-02
      5653    466_548093 2000          S 1.800000e+01 -2.928137e-01 1.634520e-02
      5654    466_548093 2000          N 4.187000e+03 -4.335274e+02 2.180748e-01
      5655    466_548093 2000       maxN 1.726000e+03 -2.878430e+02 2.084735e-01
      5656    466_548093 2000    Shannon 1.327277e+00  1.645470e-02 3.870441e-02
      5657    466_548093 2000    Simpson 6.888004e-01  5.913855e-03 9.348923e-02
      5658    466_548093 2000 invSimpson 3.213371e+00  4.310140e-02 4.655636e-02
      5659    466_548093 2000        PIE 6.889649e-01  5.927397e-03 9.303996e-02
      5660    466_548093 2000      DomMc 6.809171e-01 -4.405062e-03 2.137567e-01
      5661    466_548093 2000 expShannon 3.770763e+00  6.016191e-02 2.377897e-02
      5662    466_548093 2002          S 1.700000e+01 -2.928137e-01 1.634520e-02
      5663    466_548093 2002          N 2.032300e+04 -4.335274e+02 2.180748e-01
      5664    466_548093 2002       maxN 1.305300e+04 -2.878430e+02 2.084735e-01
      5665    466_548093 2002    Shannon 8.994348e-01  1.645470e-02 3.870441e-02
      5666    466_548093 2002    Simpson 5.021734e-01  5.913855e-03 9.348923e-02
      5667    466_548093 2002 invSimpson 2.008732e+00  4.310140e-02 4.655636e-02
      5668    466_548093 2002        PIE 5.021982e-01  5.927397e-03 9.303996e-02
      5669    466_548093 2002      DomMc 9.296364e-01 -4.405062e-03 2.137567e-01
      5670    466_548093 2002 expShannon 2.458213e+00  6.016191e-02 2.377897e-02
      5671    466_548093 2003          S 1.800000e+01 -2.928137e-01 1.634520e-02
      5672    466_548093 2003          N 9.139000e+03 -4.335274e+02 2.180748e-01
      5673    466_548093 2003       maxN 6.033000e+03 -2.878430e+02 2.084735e-01
      5674    466_548093 2003    Shannon 9.945247e-01  1.645470e-02 3.870441e-02
      5675    466_548093 2003    Simpson 5.086911e-01  5.913855e-03 9.348923e-02
      5676    466_548093 2003 invSimpson 2.035379e+00  4.310140e-02 4.655636e-02
      5677    466_548093 2003        PIE 5.087468e-01  5.927397e-03 9.303996e-02
      5678    466_548093 2003      DomMc 8.799650e-01 -4.405062e-03 2.137567e-01
      5679    466_548093 2003 expShannon 2.703439e+00  6.016191e-02 2.377897e-02
      5680    466_548093 2004          S 1.500000e+01 -2.928137e-01 1.634520e-02
      5681    466_548093 2004          N 5.187000e+03 -4.335274e+02 2.180748e-01
      5682    466_548093 2004       maxN 2.326000e+03 -2.878430e+02 2.084735e-01
      5683    466_548093 2004    Shannon 1.400238e+00  1.645470e-02 3.870441e-02
      5684    466_548093 2004    Simpson 6.823780e-01  5.913855e-03 9.348923e-02
      5685    466_548093 2004 invSimpson 3.148396e+00  4.310140e-02 4.655636e-02
      5686    466_548093 2004        PIE 6.825095e-01  5.927397e-03 9.303996e-02
      5687    466_548093 2004      DomMc 7.632543e-01 -4.405062e-03 2.137567e-01
      5688    466_548093 2004 expShannon 4.056166e+00  6.016191e-02 2.377897e-02
      5689    466_548093 2005          S 2.000000e+01 -2.928137e-01 1.634520e-02
      5690    466_548093 2005          N 1.788000e+03 -4.335274e+02 2.180748e-01
      5691    466_548093 2005       maxN 8.060000e+02 -2.878430e+02 2.084735e-01
      5692    466_548093 2005    Shannon 1.350923e+00  1.645470e-02 3.870441e-02
      5693    466_548093 2005    Simpson 6.697477e-01  5.913855e-03 9.348923e-02
      5694    466_548093 2005 invSimpson 3.027988e+00  4.310140e-02 4.655636e-02
      5695    466_548093 2005        PIE 6.701225e-01  5.927397e-03 9.303996e-02
      5696    466_548093 2005      DomMc 7.695749e-01 -4.405062e-03 2.137567e-01
      5697    466_548093 2005 expShannon 3.860987e+00  6.016191e-02 2.377897e-02
      5698    466_548093 2008          S 1.500000e+01 -2.928137e-01 1.634520e-02
      5699    466_548093 2008          N 2.226000e+03 -4.335274e+02 2.180748e-01
      5700    466_548093 2008       maxN 1.086000e+03 -2.878430e+02 2.084735e-01
      5701    466_548093 2008    Shannon 1.410511e+00  1.645470e-02 3.870441e-02
      5702    466_548093 2008    Simpson 6.721136e-01  5.913855e-03 9.348923e-02
      5703    466_548093 2008 invSimpson 3.049837e+00  4.310140e-02 4.655636e-02
      5704    466_548093 2008        PIE 6.724157e-01  5.927397e-03 9.303996e-02
      5705    466_548093 2008      DomMc 7.434861e-01 -4.405062e-03 2.137567e-01
      5706    466_548093 2008 expShannon 4.098049e+00  6.016191e-02 2.377897e-02
      5707    466_548093 2007          S 1.600000e+01 -2.928137e-01 1.634520e-02
      5708    466_548093 2007          N 1.353000e+03 -4.335274e+02 2.180748e-01
      5709    466_548093 2007       maxN 6.040000e+02 -2.878430e+02 2.084735e-01
      5710    466_548093 2007    Shannon 1.614719e+00  1.645470e-02 3.870441e-02
      5711    466_548093 2007    Simpson 7.255181e-01  5.913855e-03 9.348923e-02
      5712    466_548093 2007 invSimpson 3.643228e+00  4.310140e-02 4.655636e-02
      5713    466_548093 2007        PIE 7.260547e-01  5.927397e-03 9.303996e-02
      5714    466_548093 2007      DomMc 6.311899e-01 -4.405062e-03 2.137567e-01
      5715    466_548093 2007 expShannon 5.026476e+00  6.016191e-02 2.377897e-02
      5716    466_548093 2001          S 1.600000e+01 -2.928137e-01 1.634520e-02
      5717    466_548093 2001          N 4.489000e+03 -4.335274e+02 2.180748e-01
      5718    466_548093 2001       maxN 2.101000e+03 -2.878430e+02 2.084735e-01
      5719    466_548093 2001    Shannon 1.230711e+00  1.645470e-02 3.870441e-02
      5720    466_548093 2001    Simpson 6.459679e-01  5.913855e-03 9.348923e-02
      5721    466_548093 2001 invSimpson 2.824603e+00  4.310140e-02 4.655636e-02
      5722    466_548093 2001        PIE 6.461119e-01  5.927397e-03 9.303996e-02
      5723    466_548093 2001      DomMc 8.061929e-01 -4.405062e-03 2.137567e-01
      5724    466_548093 2001 expShannon 3.423664e+00  6.016191e-02 2.377897e-02
      5725    466_560475 1993          S 1.900000e+01  3.501946e-02 8.960523e-01
      5726    466_560475 1993          N 2.500000e+03 -1.139776e+02 8.138047e-02
      5727    466_560475 1993       maxN 9.600000e+02 -4.572860e+01 1.111874e-01
      5728    466_560475 1993    Shannon 1.444923e+00  1.757613e-02 1.020108e-01
      5729    466_560475 1993    Simpson 7.224931e-01  2.352421e-03 5.270018e-01
      5730    466_560475 1993 invSimpson 3.603514e+00  3.769707e-02 4.531389e-01
      5731    466_560475 1993        PIE 7.227822e-01  2.410372e-03 5.181401e-01
      5732    466_560475 1993      DomMc 6.444000e-01 -3.343600e-03 5.403760e-01
      5733    466_560475 1993 expShannon 4.241526e+00  9.131331e-02 9.055735e-02
      5734    466_560475 1991          S 1.200000e+01  3.501946e-02 8.960523e-01
      5735    466_560475 1991          N 1.046000e+03 -1.139776e+02 8.138047e-02
      5736    466_560475 1991       maxN 4.990000e+02 -4.572860e+01 1.111874e-01
      5737    466_560475 1991    Shannon 1.389262e+00  1.757613e-02 1.020108e-01
      5738    466_560475 1991    Simpson 6.746085e-01  2.352421e-03 5.270018e-01
      5739    466_560475 1991 invSimpson 3.073221e+00  3.769707e-02 4.531389e-01
      5740    466_560475 1991        PIE 6.752541e-01  2.410372e-03 5.181401e-01
      5741    466_560475 1991      DomMc 7.370937e-01 -3.343600e-03 5.403760e-01
      5742    466_560475 1991 expShannon 4.011888e+00  9.131331e-02 9.055735e-02
      5743    466_560475 1992          S 2.500000e+01  3.501946e-02 8.960523e-01
      5744    466_560475 1992          N 3.619000e+03 -1.139776e+02 8.138047e-02
      5745    466_560475 1992       maxN 1.593000e+03 -4.572860e+01 1.111874e-01
      5746    466_560475 1992    Shannon 1.559411e+00  1.757613e-02 1.020108e-01
      5747    466_560475 1992    Simpson 7.039565e-01  2.352421e-03 5.270018e-01
      5748    466_560475 1992 invSimpson 3.377882e+00  3.769707e-02 4.531389e-01
      5749    466_560475 1992        PIE 7.041511e-01  2.410372e-03 5.181401e-01
      5750    466_560475 1992      DomMc 7.250622e-01 -3.343600e-03 5.403760e-01
      5751    466_560475 1992 expShannon 4.756021e+00  9.131331e-02 9.055735e-02
      5752    466_560475 2004          S 1.700000e+01  3.501946e-02 8.960523e-01
      5753    466_560475 2004          N 1.282000e+03 -1.139776e+02 8.138047e-02
      5754    466_560475 2004       maxN 7.210000e+02 -4.572860e+01 1.111874e-01
      5755    466_560475 2004    Shannon 1.440664e+00  1.757613e-02 1.020108e-01
      5756    466_560475 2004    Simpson 6.404531e-01  2.352421e-03 5.270018e-01
      5757    466_560475 2004 invSimpson 2.781278e+00  3.769707e-02 4.531389e-01
      5758    466_560475 2004        PIE 6.409530e-01  2.410372e-03 5.181401e-01
      5759    466_560475 2004      DomMc 7.035881e-01 -3.343600e-03 5.403760e-01
      5760    466_560475 2004 expShannon 4.223501e+00  9.131331e-02 9.055735e-02
      5761    466_560475 2008          S 2.100000e+01  3.501946e-02 8.960523e-01
      5762    466_560475 2008          N 5.640000e+02 -1.139776e+02 8.138047e-02
      5763    466_560475 2008       maxN 2.040000e+02 -4.572860e+01 1.111874e-01
      5764    466_560475 2008    Shannon 1.847434e+00  1.757613e-02 1.020108e-01
      5765    466_560475 2008    Simpson 7.707988e-01  2.352421e-03 5.270018e-01
      5766    466_560475 2008 invSimpson 4.362978e+00  3.769707e-02 4.531389e-01
      5767    466_560475 2008        PIE 7.721678e-01  2.410372e-03 5.181401e-01
      5768    466_560475 2008      DomMc 6.294326e-01 -3.343600e-03 5.403760e-01
      5769    466_560475 2008 expShannon 6.343524e+00  9.131331e-02 9.055735e-02
      5770    466_560475 1997          S 1.800000e+01  3.501946e-02 8.960523e-01
      5771    466_560475 1997          N 2.161000e+03 -1.139776e+02 8.138047e-02
      5772    466_560475 1997       maxN 5.450000e+02 -4.572860e+01 1.111874e-01
      5773    466_560475 1997    Shannon 1.722298e+00  1.757613e-02 1.020108e-01
      5774    466_560475 1997    Simpson 7.949903e-01  2.352421e-03 5.270018e-01
      5775    466_560475 1997 invSimpson 4.877819e+00  3.769707e-02 4.531389e-01
      5776    466_560475 1997        PIE 7.953584e-01  2.410372e-03 5.181401e-01
      5777    466_560475 1997      DomMc 4.956039e-01 -3.343600e-03 5.403760e-01
      5778    466_560475 1997 expShannon 5.597374e+00  9.131331e-02 9.055735e-02
      5779    466_560475 2005          S 1.700000e+01  3.501946e-02 8.960523e-01
      5780    466_560475 2005          N 5.090000e+02 -1.139776e+02 8.138047e-02
      5781    466_560475 2005       maxN 1.840000e+02 -4.572860e+01 1.111874e-01
      5782    466_560475 2005    Shannon 1.780482e+00  1.757613e-02 1.020108e-01
      5783    466_560475 2005    Simpson 7.707783e-01  2.352421e-03 5.270018e-01
      5784    466_560475 2005 invSimpson 4.362588e+00  3.769707e-02 4.531389e-01
      5785    466_560475 2005        PIE 7.722955e-01  2.410372e-03 5.181401e-01
      5786    466_560475 2005      DomMc 6.188605e-01 -3.343600e-03 5.403760e-01
      5787    466_560475 2005 expShannon 5.932717e+00  9.131331e-02 9.055735e-02
      5788    466_542986 1993          S 2.100000e+01 -2.508442e-02 8.675960e-01
      5789    466_542986 1993          N 2.840000e+03  2.163177e+02 6.066250e-01
      5790    466_542986 1993       maxN 1.147000e+03  2.271669e+02 5.785824e-01
      5791    466_542986 1993    Shannon 1.449569e+00 -1.818105e-02 5.498512e-01
      5792    466_542986 1993    Simpson 6.903524e-01 -8.566398e-03 5.380654e-01
      5793    466_542986 1993 invSimpson 3.229477e+00 -6.008561e-02 5.017964e-01
      5794    466_542986 1993        PIE 6.905955e-01 -8.552240e-03 5.394917e-01
      5795    466_542986 1993      DomMc 7.524648e-01  5.514950e-03 5.595298e-01
      5796    466_542986 1993 expShannon 4.261277e+00 -6.727691e-02 5.469548e-01
      5797    466_542986 1996          S 1.600000e+01 -2.508442e-02 8.675960e-01
      5798    466_542986 1996          N 9.020000e+02  2.163177e+02 6.066250e-01
      5799    466_542986 1996       maxN 4.010000e+02  2.271669e+02 5.785824e-01
      5800    466_542986 1996    Shannon 1.534560e+00 -1.818105e-02 5.498512e-01
      5801    466_542986 1996    Simpson 7.003727e-01 -8.566398e-03 5.380654e-01
      5802    466_542986 1996 invSimpson 3.337479e+00 -6.008561e-02 5.017964e-01
      5803    466_542986 1996        PIE 7.011500e-01 -8.552240e-03 5.394917e-01
      5804    466_542986 1996      DomMc 7.261641e-01  5.514950e-03 5.595298e-01
      5805    466_542986 1996 expShannon 4.639285e+00 -6.727691e-02 5.469548e-01
      5806    466_542986 2000          S 1.600000e+01 -2.508442e-02 8.675960e-01
      5807    466_542986 2000          N 1.310000e+03  2.163177e+02 6.066250e-01
      5808    466_542986 2000       maxN 1.076000e+03  2.271669e+02 5.785824e-01
      5809    466_542986 2000    Shannon 8.524259e-01 -1.818105e-02 5.498512e-01
      5810    466_542986 2000    Simpson 3.205454e-01 -8.566398e-03 5.380654e-01
      5811    466_542986 2000 invSimpson 1.471769e+00 -6.008561e-02 5.017964e-01
      5812    466_542986 2000        PIE 3.207903e-01 -8.552240e-03 5.394917e-01
      5813    466_542986 2000      DomMc 8.671756e-01  5.514950e-03 5.595298e-01
      5814    466_542986 2000 expShannon 2.345329e+00 -6.727691e-02 5.469548e-01
      5815    466_542986 2001          S 1.800000e+01 -2.508442e-02 8.675960e-01
      5816    466_542986 2001          N 2.315000e+03  2.163177e+02 6.066250e-01
      5817    466_542986 2001       maxN 1.289000e+03  2.271669e+02 5.785824e-01
      5818    466_542986 2001    Shannon 1.046174e+00 -1.818105e-02 5.498512e-01
      5819    466_542986 2001    Simpson 5.541499e-01 -8.566398e-03 5.380654e-01
      5820    466_542986 2001 invSimpson 2.242906e+00 -6.008561e-02 5.017964e-01
      5821    466_542986 2001        PIE 5.543894e-01 -8.552240e-03 5.394917e-01
      5822    466_542986 2001      DomMc 9.239741e-01  5.514950e-03 5.595298e-01
      5823    466_542986 2001 expShannon 2.846740e+00 -6.727691e-02 5.469548e-01
      5824    466_542986 1997          S 1.200000e+01 -2.508442e-02 8.675960e-01
      5825    466_542986 1997          N 3.673000e+03  2.163177e+02 6.066250e-01
      5826    466_542986 1997       maxN 2.922000e+03  2.271669e+02 5.785824e-01
      5827    466_542986 1997    Shannon 7.231263e-01 -1.818105e-02 5.498512e-01
      5828    466_542986 1997    Simpson 3.477879e-01 -8.566398e-03 5.380654e-01
      5829    466_542986 1997 invSimpson 1.533244e+00 -6.008561e-02 5.017964e-01
      5830    466_542986 1997        PIE 3.478826e-01 -8.552240e-03 5.394917e-01
      5831    466_542986 1997      DomMc 9.213177e-01  5.514950e-03 5.595298e-01
      5832    466_542986 1997 expShannon 2.060866e+00 -6.727691e-02 5.469548e-01
      5833    466_542986 1987          S 1.200000e+01 -2.508442e-02 8.675960e-01
      5834    466_542986 1987          N 2.322000e+03  2.163177e+02 6.066250e-01
      5835    466_542986 1987       maxN 1.698000e+03  2.271669e+02 5.785824e-01
      5836    466_542986 1987    Shannon 8.779150e-01 -1.818105e-02 5.498512e-01
      5837    466_542986 1987    Simpson 4.288337e-01 -8.566398e-03 5.380654e-01
      5838    466_542986 1987 invSimpson 1.750804e+00 -6.008561e-02 5.017964e-01
      5839    466_542986 1987        PIE 4.290185e-01 -8.552240e-03 5.394917e-01
      5840    466_542986 1987      DomMc 9.160207e-01  5.514950e-03 5.595298e-01
      5841    466_542986 1987 expShannon 2.405878e+00 -6.727691e-02 5.469548e-01
      5842    466_542986 1988          S 1.700000e+01 -2.508442e-02 8.675960e-01
      5843    466_542986 1988          N 1.448000e+03  2.163177e+02 6.066250e-01
      5844    466_542986 1988       maxN 1.264000e+03  2.271669e+02 5.785824e-01
      5845    466_542986 1988    Shannon 6.667261e-01 -1.818105e-02 5.498512e-01
      5846    466_542986 1988    Simpson 2.359055e-01 -8.566398e-03 5.380654e-01
      5847    466_542986 1988 invSimpson 1.308739e+00 -6.008561e-02 5.017964e-01
      5848    466_542986 1988        PIE 2.360685e-01 -8.552240e-03 5.394917e-01
      5849    466_542986 1988      DomMc 8.984807e-01  5.514950e-03 5.595298e-01
      5850    466_542986 1988 expShannon 1.947850e+00 -6.727691e-02 5.469548e-01
      5851    466_542986 1989          S 1.800000e+01 -2.508442e-02 8.675960e-01
      5852    466_542986 1989          N 6.670000e+02  2.163177e+02 6.066250e-01
      5853    466_542986 1989       maxN 1.590000e+02  2.271669e+02 5.785824e-01
      5854    466_542986 1989    Shannon 2.017535e+00 -1.818105e-02 5.498512e-01
      5855    466_542986 1989    Simpson 8.342396e-01 -8.566398e-03 5.380654e-01
      5856    466_542986 1989 invSimpson 6.032802e+00 -6.008561e-02 5.017964e-01
      5857    466_542986 1989        PIE 8.354922e-01 -8.552240e-03 5.394917e-01
      5858    466_542986 1989      DomMc 4.602699e-01  5.514950e-03 5.595298e-01
      5859    466_542986 1989 expShannon 7.519767e+00 -6.727691e-02 5.469548e-01
      5860    466_542986 1990          S 1.800000e+01 -2.508442e-02 8.675960e-01
      5861    466_542986 1990          N 1.459000e+03  2.163177e+02 6.066250e-01
      5862    466_542986 1990       maxN 6.970000e+02  2.271669e+02 5.785824e-01
      5863    466_542986 1990    Shannon 1.375809e+00 -1.818105e-02 5.498512e-01
      5864    466_542986 1990    Simpson 6.517764e-01 -8.566398e-03 5.380654e-01
      5865    466_542986 1990 invSimpson 2.871718e+00 -6.008561e-02 5.017964e-01
      5866    466_542986 1990        PIE 6.522234e-01 -8.552240e-03 5.394917e-01
      5867    466_542986 1990      DomMc 8.087731e-01  5.514950e-03 5.595298e-01
      5868    466_542986 1990 expShannon 3.958276e+00 -6.727691e-02 5.469548e-01
      5869    466_542986 1994          S 1.400000e+01 -2.508442e-02 8.675960e-01
      5870    466_542986 1994          N 4.587000e+03  2.163177e+02 6.066250e-01
      5871    466_542986 1994       maxN 2.304000e+03  2.271669e+02 5.785824e-01
      5872    466_542986 1994    Shannon 1.334164e+00 -1.818105e-02 5.498512e-01
      5873    466_542986 1994    Simpson 6.638057e-01 -8.566398e-03 5.380654e-01
      5874    466_542986 1994 invSimpson 2.974471e+00 -6.008561e-02 5.017964e-01
      5875    466_542986 1994        PIE 6.639505e-01 -8.552240e-03 5.394917e-01
      5876    466_542986 1994      DomMc 7.165904e-01  5.514950e-03 5.595298e-01
      5877    466_542986 1994 expShannon 3.796821e+00 -6.727691e-02 5.469548e-01
      5878    466_542986 1998          S 1.500000e+01 -2.508442e-02 8.675960e-01
      5879    466_542986 1998          N 2.695100e+04  2.163177e+02 6.066250e-01
      5880    466_542986 1998       maxN 2.578700e+04  2.271669e+02 5.785824e-01
      5881    466_542986 1998    Shannon 2.381373e-01 -1.818105e-02 5.498512e-01
      5882    466_542986 1998    Simpson 8.378904e-02 -8.566398e-03 5.380654e-01
      5883    466_542986 1998 invSimpson 1.091452e+00 -6.008561e-02 5.017964e-01
      5884    466_542986 1998        PIE 8.379214e-02 -8.552240e-03 5.394917e-01
      5885    466_542986 1998      DomMc 9.820044e-01  5.514950e-03 5.595298e-01
      5886    466_542986 1998 expShannon 1.268883e+00 -6.727691e-02 5.469548e-01
      5887    466_542986 1999          S 1.500000e+01 -2.508442e-02 8.675960e-01
      5888    466_542986 1999          N 3.300000e+02  2.163177e+02 6.066250e-01
      5889    466_542986 1999       maxN 1.110000e+02  2.271669e+02 5.785824e-01
      5890    466_542986 1999    Shannon 1.910455e+00 -1.818105e-02 5.498512e-01
      5891    466_542986 1999    Simpson 8.028466e-01 -8.566398e-03 5.380654e-01
      5892    466_542986 1999 invSimpson 5.072194e+00 -6.008561e-02 5.017964e-01
      5893    466_542986 1999        PIE 8.052869e-01 -8.552240e-03 5.394917e-01
      5894    466_542986 1999      DomMc 5.212121e-01  5.514950e-03 5.595298e-01
      5895    466_542986 1999 expShannon 6.756161e+00 -6.727691e-02 5.469548e-01
      5896    466_542986 2002          S 1.600000e+01 -2.508442e-02 8.675960e-01
      5897    466_542986 2002          N 6.570000e+02  2.163177e+02 6.066250e-01
      5898    466_542986 2002       maxN 5.320000e+02  2.271669e+02 5.785824e-01
      5899    466_542986 2002    Shannon 8.696456e-01 -1.818105e-02 5.498512e-01
      5900    466_542986 2002    Simpson 3.372601e-01 -8.566398e-03 5.380654e-01
      5901    466_542986 2002 invSimpson 1.508888e+00 -6.008561e-02 5.017964e-01
      5902    466_542986 2002        PIE 3.377743e-01 -8.552240e-03 5.394917e-01
      5903    466_542986 2002      DomMc 8.751903e-01  5.514950e-03 5.595298e-01
      5904    466_542986 2002 expShannon 2.386065e+00 -6.727691e-02 5.469548e-01
      5905    466_569206 1994          S 2.600000e+01 -1.537668e-01 5.061018e-01
      5906    466_569206 1994          N 1.464000e+03 -2.261517e+02 1.944460e-02
      5907    466_569206 1994       maxN 9.460000e+02 -1.616295e+02 1.596366e-02
      5908    466_569206 1994    Shannon 1.391949e+00  4.020657e-02 9.435519e-02
      5909    466_569206 1994    Simpson 5.584362e-01  1.374434e-02 1.432517e-01
      5910    466_569206 1994 invSimpson 2.264678e+00  1.428214e-01 1.132426e-01
      5911    466_569206 1994        PIE 5.588179e-01  1.382039e-02 1.427402e-01
      5912    466_569206 1994      DomMc 7.752732e-01 -1.695385e-02 5.043027e-02
      5913    466_569206 1994 expShannon 4.022681e+00  1.735756e-01 1.178402e-01
      5914    466_569206 1999          S 2.400000e+01 -1.537668e-01 5.061018e-01
      5915    466_569206 1999          N 1.384000e+03 -2.261517e+02 1.944460e-02
      5916    466_569206 1999       maxN 4.110000e+02 -1.616295e+02 1.596366e-02
      5917    466_569206 1999    Shannon 1.883053e+00  4.020657e-02 9.435519e-02
      5918    466_569206 1999    Simpson 8.035423e-01  1.374434e-02 1.432517e-01
      5919    466_569206 1999 invSimpson 5.090155e+00  1.428214e-01 1.132426e-01
      5920    466_569206 1999        PIE 8.041234e-01  1.382039e-02 1.427402e-01
      5921    466_569206 1999      DomMc 5.354046e-01 -1.695385e-02 5.043027e-02
      5922    466_569206 1999 expShannon 6.573543e+00  1.735756e-01 1.178402e-01
      5923    466_569206 2002          S 2.500000e+01 -1.537668e-01 5.061018e-01
      5924    466_569206 2002          N 2.382000e+03 -2.261517e+02 1.944460e-02
      5925    466_569206 2002       maxN 6.360000e+02 -1.616295e+02 1.596366e-02
      5926    466_569206 2002    Shannon 1.935821e+00  4.020657e-02 9.435519e-02
      5927    466_569206 2002    Simpson 8.139598e-01  1.374434e-02 1.432517e-01
      5928    466_569206 2002 invSimpson 5.375182e+00  1.428214e-01 1.132426e-01
      5929    466_569206 2002        PIE 8.143016e-01  1.382039e-02 1.427402e-01
      5930    466_569206 2002      DomMc 5.062972e-01 -1.695385e-02 5.043027e-02
      5931    466_569206 2002 expShannon 6.929732e+00  1.735756e-01 1.178402e-01
      5932    466_569206 1992          S 2.300000e+01 -1.537668e-01 5.061018e-01
      5933    466_569206 1992          N 5.597000e+03 -2.261517e+02 1.944460e-02
      5934    466_569206 1992       maxN 3.300000e+03 -1.616295e+02 1.596366e-02
      5935    466_569206 1992    Shannon 1.167500e+00  4.020657e-02 9.435519e-02
      5936    466_569206 1992    Simpson 5.844475e-01  1.374434e-02 1.432517e-01
      5937    466_569206 1992 invSimpson 2.406435e+00  1.428214e-01 1.132426e-01
      5938    466_569206 1992        PIE 5.845519e-01  1.382039e-02 1.427402e-01
      5939    466_569206 1992      DomMc 8.059675e-01 -1.695385e-02 5.043027e-02
      5940    466_569206 1992 expShannon 3.213947e+00  1.735756e-01 1.178402e-01
      5941    466_569206 1995          S 1.300000e+01 -1.537668e-01 5.061018e-01
      5942    466_569206 1995          N 1.479000e+03 -2.261517e+02 1.944460e-02
      5943    466_569206 1995       maxN 1.088000e+03 -1.616295e+02 1.596366e-02
      5944    466_569206 1995    Shannon 9.425052e-01  4.020657e-02 9.435519e-02
      5945    466_569206 1995    Simpson 4.295211e-01  1.374434e-02 1.432517e-01
      5946    466_569206 1995 invSimpson 1.752913e+00  1.428214e-01 1.132426e-01
      5947    466_569206 1995        PIE 4.298117e-01  1.382039e-02 1.427402e-01
      5948    466_569206 1995      DomMc 9.012847e-01 -1.695385e-02 5.043027e-02
      5949    466_569206 1995 expShannon 2.566403e+00  1.735756e-01 1.178402e-01
      5950    466_569206 1997          S 1.800000e+01 -1.537668e-01 5.061018e-01
      5951    466_569206 1997          N 1.350000e+02 -2.261517e+02 1.944460e-02
      5952    466_569206 1997       maxN 3.200000e+01 -1.616295e+02 1.596366e-02
      5953    466_569206 1997    Shannon 2.323395e+00  4.020657e-02 9.435519e-02
      5954    466_569206 1997    Simpson 8.667215e-01  1.374434e-02 1.432517e-01
      5955    466_569206 1997 invSimpson 7.503088e+00  1.428214e-01 1.132426e-01
      5956    466_569206 1997        PIE 8.731896e-01  1.382039e-02 1.427402e-01
      5957    466_569206 1997      DomMc 4.296296e-01 -1.695385e-02 5.043027e-02
      5958    466_569206 1997 expShannon 1.021028e+01  1.735756e-01 1.178402e-01
      5959    466_569206 1998          S 1.900000e+01 -1.537668e-01 5.061018e-01
      5960    466_569206 1998          N 1.340000e+03 -2.261517e+02 1.944460e-02
      5961    466_569206 1998       maxN 3.950000e+02 -1.616295e+02 1.596366e-02
      5962    466_569206 1998    Shannon 1.885278e+00  4.020657e-02 9.435519e-02
      5963    466_569206 1998    Simpson 8.062954e-01  1.374434e-02 1.432517e-01
      5964    466_569206 1998 invSimpson 5.162500e+00  1.428214e-01 1.132426e-01
      5965    466_569206 1998        PIE 8.068976e-01  1.382039e-02 1.427402e-01
      5966    466_569206 1998      DomMc 4.977612e-01 -1.695385e-02 5.043027e-02
      5967    466_569206 1998 expShannon 6.588188e+00  1.735756e-01 1.178402e-01
      5968    466_569206 2001          S 1.400000e+01 -1.537668e-01 5.061018e-01
      5969    466_569206 2001          N 1.416000e+03 -2.261517e+02 1.944460e-02
      5970    466_569206 2001       maxN 6.500000e+02 -1.616295e+02 1.596366e-02
      5971    466_569206 2001    Shannon 1.489285e+00  4.020657e-02 9.435519e-02
      5972    466_569206 2001    Simpson 7.002478e-01  1.374434e-02 1.432517e-01
      5973    466_569206 2001 invSimpson 3.336089e+00  1.428214e-01 1.132426e-01
      5974    466_569206 2001        PIE 7.007426e-01  1.382039e-02 1.427402e-01
      5975    466_569206 2001      DomMc 6.984463e-01 -1.695385e-02 5.043027e-02
      5976    466_569206 2001 expShannon 4.433925e+00  1.735756e-01 1.178402e-01
      5977    466_569206 2004          S 1.200000e+01 -1.537668e-01 5.061018e-01
      5978    466_569206 2004          N 1.896000e+03 -2.261517e+02 1.944460e-02
      5979    466_569206 2004       maxN 1.587000e+03 -1.616295e+02 1.596366e-02
      5980    466_569206 2004    Shannon 6.182376e-01  4.020657e-02 9.435519e-02
      5981    466_569206 2004    Simpson 2.844763e-01  1.374434e-02 1.432517e-01
      5982    466_569206 2004 invSimpson 1.397578e+00  1.428214e-01 1.132426e-01
      5983    466_569206 2004        PIE 2.846264e-01  1.382039e-02 1.427402e-01
      5984    466_569206 2004      DomMc 9.578059e-01 -1.695385e-02 5.043027e-02
      5985    466_569206 2004 expShannon 1.855655e+00  1.735756e-01 1.178402e-01
      5986    466_569206 2005          S 1.900000e+01 -1.537668e-01 5.061018e-01
      5987    466_569206 2005          N 2.620000e+02 -2.261517e+02 1.944460e-02
      5988    466_569206 2005       maxN 9.500000e+01 -1.616295e+02 1.596366e-02
      5989    466_569206 2005    Shannon 2.006132e+00  4.020657e-02 9.435519e-02
      5990    466_569206 2005    Simpson 7.962240e-01  1.374434e-02 1.432517e-01
      5991    466_569206 2005 invSimpson 4.907349e+00  1.428214e-01 1.132426e-01
      5992    466_569206 2005        PIE 7.992747e-01  1.382039e-02 1.427402e-01
      5993    466_569206 2005      DomMc 5.725191e-01 -1.695385e-02 5.043027e-02
      5994    466_569206 2005 expShannon 7.434507e+00  1.735756e-01 1.178402e-01
      5995    466_569206 2006          S 1.000000e+01 -1.537668e-01 5.061018e-01
      5996    466_569206 2006          N 2.740000e+02 -2.261517e+02 1.944460e-02
      5997    466_569206 2006       maxN 7.400000e+01 -1.616295e+02 1.596366e-02
      5998    466_569206 2006    Shannon 1.888705e+00  4.020657e-02 9.435519e-02
      5999    466_569206 2006    Simpson 8.294528e-01  1.374434e-02 1.432517e-01
      6000    466_569206 2006 invSimpson 5.863480e+00  1.428214e-01 1.132426e-01
      6001    466_569206 2006        PIE 8.324911e-01  1.382039e-02 1.427402e-01
      6002    466_569206 2006      DomMc 4.306569e-01 -1.695385e-02 5.043027e-02
      6003    466_569206 2006 expShannon 6.610801e+00  1.735756e-01 1.178402e-01
      6004    466_569206 2007          S 1.500000e+01 -1.537668e-01 5.061018e-01
      6005    466_569206 2007          N 5.480000e+02 -2.261517e+02 1.944460e-02
      6006    466_569206 2007       maxN 4.030000e+02 -1.616295e+02 1.596366e-02
      6007    466_569206 2007    Shannon 1.165422e+00  4.020657e-02 9.435519e-02
      6008    466_569206 2007    Simpson 4.500373e-01  1.374434e-02 1.432517e-01
      6009    466_569206 2007 invSimpson 1.818305e+00  1.428214e-01 1.132426e-01
      6010    466_569206 2007        PIE 4.508600e-01  1.382039e-02 1.427402e-01
      6011    466_569206 2007      DomMc 7.919708e-01 -1.695385e-02 5.043027e-02
      6012    466_569206 2007 expShannon 3.207276e+00  1.735756e-01 1.178402e-01
      6013    466_569206 2008          S 1.800000e+01 -1.537668e-01 5.061018e-01
      6014    466_569206 2008          N 5.500000e+02 -2.261517e+02 1.944460e-02
      6015    466_569206 2008       maxN 1.180000e+02 -1.616295e+02 1.596366e-02
      6016    466_569206 2008    Shannon 2.063990e+00  4.020657e-02 9.435519e-02
      6017    466_569206 2008    Simpson 8.432595e-01  1.374434e-02 1.432517e-01
      6018    466_569206 2008 invSimpson 6.379972e+00  1.428214e-01 1.132426e-01
      6019    466_569206 2008        PIE 8.447955e-01  1.382039e-02 1.427402e-01
      6020    466_569206 2008      DomMc 4.218182e-01 -1.695385e-02 5.043027e-02
      6021    466_569206 2008 expShannon 7.877340e+00  1.735756e-01 1.178402e-01
      6022    466_569206 1991          S 1.100000e+01 -1.537668e-01 5.061018e-01
      6023    466_569206 1991          N 1.488000e+03 -2.261517e+02 1.944460e-02
      6024    466_569206 1991       maxN 1.042000e+03 -1.616295e+02 1.596366e-02
      6025    466_569206 1991    Shannon 9.683871e-01  4.020657e-02 9.435519e-02
      6026    466_569206 1991    Simpson 4.702287e-01  1.374434e-02 1.432517e-01
      6027    466_569206 1991 invSimpson 1.887607e+00  1.428214e-01 1.132426e-01
      6028    466_569206 1991        PIE 4.705449e-01  1.382039e-02 1.427402e-01
      6029    466_569206 1991      DomMc 8.884409e-01 -1.695385e-02 5.043027e-02
      6030    466_569206 1991 expShannon 2.633693e+00  1.735756e-01 1.178402e-01
      6031    466_569206 1993          S 1.700000e+01 -1.537668e-01 5.061018e-01
      6032    466_569206 1993          N 6.536000e+03 -2.261517e+02 1.944460e-02
      6033    466_569206 1993       maxN 5.815000e+03 -1.616295e+02 1.596366e-02
      6034    466_569206 1993    Shannon 5.259392e-01  4.020657e-02 9.435519e-02
      6035    466_569206 1993    Simpson 2.050565e-01  1.374434e-02 1.432517e-01
      6036    466_569206 1993 invSimpson 1.257951e+00  1.428214e-01 1.132426e-01
      6037    466_569206 1993        PIE 2.050879e-01  1.382039e-02 1.427402e-01
      6038    466_569206 1993      DomMc 9.325275e-01 -1.695385e-02 5.043027e-02
      6039    466_569206 1993 expShannon 1.692047e+00  1.735756e-01 1.178402e-01
      6040    466_569206 1996          S 1.600000e+01 -1.537668e-01 5.061018e-01
      6041    466_569206 1996          N 7.525000e+03 -2.261517e+02 1.944460e-02
      6042    466_569206 1996       maxN 3.526000e+03 -1.616295e+02 1.596366e-02
      6043    466_569206 1996    Shannon 1.127470e+00  4.020657e-02 9.435519e-02
      6044    466_569206 1996    Simpson 5.952174e-01  1.374434e-02 1.432517e-01
      6045    466_569206 1996 invSimpson 2.470462e+00  1.428214e-01 1.132426e-01
      6046    466_569206 1996        PIE 5.952965e-01  1.382039e-02 1.427402e-01
      6047    466_569206 1996      DomMc 8.954153e-01 -1.695385e-02 5.043027e-02
      6048    466_569206 1996 expShannon 3.087835e+00  1.735756e-01 1.178402e-01
      6049    466_569206 2000          S 1.200000e+01 -1.537668e-01 5.061018e-01
      6050    466_569206 2000          N 5.090000e+02 -2.261517e+02 1.944460e-02
      6051    466_569206 2000       maxN 1.350000e+02 -1.616295e+02 1.596366e-02
      6052    466_569206 2000    Shannon 1.900619e+00  4.020657e-02 9.435519e-02
      6053    466_569206 2000    Simpson 8.165091e-01  1.374434e-02 1.432517e-01
      6054    466_569206 2000 invSimpson 5.449862e+00  1.428214e-01 1.132426e-01
      6055    466_569206 2000        PIE 8.181164e-01  1.382039e-02 1.427402e-01
      6056    466_569206 2000      DomMc 5.147348e-01 -1.695385e-02 5.043027e-02
      6057    466_569206 2000 expShannon 6.690035e+00  1.735756e-01 1.178402e-01
      6058    466_569206 2003          S 1.900000e+01 -1.537668e-01 5.061018e-01
      6059    466_569206 2003          N 7.860000e+02 -2.261517e+02 1.944460e-02
      6060    466_569206 2003       maxN 4.600000e+02 -1.616295e+02 1.596366e-02
      6061    466_569206 2003    Shannon 1.401870e+00  4.020657e-02 9.435519e-02
      6062    466_569206 2003    Simpson 6.144261e-01  1.374434e-02 1.432517e-01
      6063    466_569206 2003 invSimpson 2.593537e+00  1.428214e-01 1.132426e-01
      6064    466_569206 2003        PIE 6.152088e-01  1.382039e-02 1.427402e-01
      6065    466_569206 2003      DomMc 7.519084e-01 -1.695385e-02 5.043027e-02
      6066    466_569206 2003 expShannon 4.062792e+00  1.735756e-01 1.178402e-01
      6067    466_540822 1994          S 2.100000e+01 -4.657534e-02 8.806059e-01
      6068    466_540822 1994          N 1.204000e+03  4.251781e+01 8.224214e-01
      6069    466_540822 1994       maxN 4.670000e+02  4.377260e+01 7.263616e-01
      6070    466_540822 1994    Shannon 1.627131e+00 -2.515168e-02 3.905780e-01
      6071    466_540822 1994    Simpson 7.337240e-01 -1.067460e-02 3.180998e-01
      6072    466_540822 1994 invSimpson 3.755501e+00 -9.107475e-02 3.123518e-01
      6073    466_540822 1994        PIE 7.343339e-01 -1.065224e-02 3.228875e-01
      6074    466_540822 1994      DomMc 6.769103e-01  7.660390e-03 4.901627e-01
      6075    466_540822 1994 expShannon 5.089255e+00 -1.076306e-01 3.914520e-01
      6076    466_540822 1997          S 2.500000e+01 -4.657534e-02 8.806059e-01
      6077    466_540822 1997          N 4.923000e+03  4.251781e+01 8.224214e-01
      6078    466_540822 1997       maxN 3.520000e+03  4.377260e+01 7.263616e-01
      6079    466_540822 1997    Shannon 1.155688e+00 -2.515168e-02 3.905780e-01
      6080    466_540822 1997    Simpson 4.719515e-01 -1.067460e-02 3.180998e-01
      6081    466_540822 1997 invSimpson 1.893766e+00 -9.107475e-02 3.123518e-01
      6082    466_540822 1997        PIE 4.720474e-01 -1.065224e-02 3.228875e-01
      6083    466_540822 1997      DomMc 8.171846e-01  7.660390e-03 4.901627e-01
      6084    466_540822 1997 expShannon 3.176208e+00 -1.076306e-01 3.914520e-01
      6085    466_540822 1998          S 2.000000e+01 -4.657534e-02 8.806059e-01
      6086    466_540822 1998          N 7.087000e+03  4.251781e+01 8.224214e-01
      6087    466_540822 1998       maxN 4.085000e+03  4.377260e+01 7.263616e-01
      6088    466_540822 1998    Shannon 1.191943e+00 -2.515168e-02 3.905780e-01
      6089    466_540822 1998    Simpson 5.747865e-01 -1.067460e-02 3.180998e-01
      6090    466_540822 1998 invSimpson 2.351760e+00 -9.107475e-02 3.123518e-01
      6091    466_540822 1998        PIE 5.748676e-01 -1.065224e-02 3.228875e-01
      6092    466_540822 1998      DomMc 8.772400e-01  7.660390e-03 4.901627e-01
      6093    466_540822 1998 expShannon 3.293474e+00 -1.076306e-01 3.914520e-01
      6094    466_540822 1999          S 1.200000e+01 -4.657534e-02 8.806059e-01
      6095    466_540822 1999          N 1.340000e+02  4.251781e+01 8.224214e-01
      6096    466_540822 1999       maxN 5.300000e+01  4.377260e+01 7.263616e-01
      6097    466_540822 1999    Shannon 1.825193e+00 -2.515168e-02 3.905780e-01
      6098    466_540822 1999    Simpson 7.757853e-01 -1.067460e-02 3.180998e-01
      6099    466_540822 1999 invSimpson 4.460010e+00 -9.107475e-02 3.123518e-01
      6100    466_540822 1999        PIE 7.816182e-01 -1.065224e-02 3.228875e-01
      6101    466_540822 1999      DomMc 5.597015e-01  7.660390e-03 4.901627e-01
      6102    466_540822 1999 expShannon 6.203993e+00 -1.076306e-01 3.914520e-01
      6103    466_540822 2002          S 1.800000e+01 -4.657534e-02 8.806059e-01
      6104    466_540822 2002          N 1.073000e+03  4.251781e+01 8.224214e-01
      6105    466_540822 2002       maxN 7.830000e+02  4.377260e+01 7.263616e-01
      6106    466_540822 2002    Shannon 1.017625e+00 -2.515168e-02 3.905780e-01
      6107    466_540822 2002    Simpson 4.415575e-01 -1.067460e-02 3.180998e-01
      6108    466_540822 2002 invSimpson 1.790695e+00 -9.107475e-02 3.123518e-01
      6109    466_540822 2002        PIE 4.419694e-01 -1.065224e-02 3.228875e-01
      6110    466_540822 2002      DomMc 8.844362e-01  7.660390e-03 4.901627e-01
      6111    466_540822 2002 expShannon 2.766616e+00 -1.076306e-01 3.914520e-01
      6112    466_540822 2003          S 1.900000e+01 -4.657534e-02 8.806059e-01
      6113    466_540822 2003          N 7.540000e+02  4.251781e+01 8.224214e-01
      6114    466_540822 2003       maxN 3.250000e+02  4.377260e+01 7.263616e-01
      6115    466_540822 2003    Shannon 1.734378e+00 -2.515168e-02 3.905780e-01
      6116    466_540822 2003    Simpson 7.396590e-01 -1.067460e-02 3.180998e-01
      6117    466_540822 2003 invSimpson 3.841117e+00 -9.107475e-02 3.123518e-01
      6118    466_540822 2003        PIE 7.406413e-01 -1.065224e-02 3.228875e-01
      6119    466_540822 2003      DomMc 6.644562e-01  7.660390e-03 4.901627e-01
      6120    466_540822 2003 expShannon 5.665404e+00 -1.076306e-01 3.914520e-01
      6121    466_540822 1990          S 1.800000e+01 -4.657534e-02 8.806059e-01
      6122    466_540822 1990          N 6.730000e+02  4.251781e+01 8.224214e-01
      6123    466_540822 1990       maxN 2.130000e+02  4.377260e+01 7.263616e-01
      6124    466_540822 1990    Shannon 1.914574e+00 -2.515168e-02 3.905780e-01
      6125    466_540822 1990    Simpson 7.946853e-01 -1.067460e-02 3.180998e-01
      6126    466_540822 1990 invSimpson 4.870571e+00 -9.107475e-02 3.123518e-01
      6127    466_540822 1990        PIE 7.958678e-01 -1.065224e-02 3.228875e-01
      6128    466_540822 1990      DomMc 5.988113e-01  7.660390e-03 4.901627e-01
      6129    466_540822 1990 expShannon 6.784051e+00 -1.076306e-01 3.914520e-01
      6130    466_540822 1991          S 1.400000e+01 -4.657534e-02 8.806059e-01
      6131    466_540822 1991          N 1.302000e+03  4.251781e+01 8.224214e-01
      6132    466_540822 1991       maxN 6.660000e+02  4.377260e+01 7.263616e-01
      6133    466_540822 1991    Shannon 1.181298e+00 -2.515168e-02 3.905780e-01
      6134    466_540822 1991    Simpson 6.001531e-01 -1.067460e-02 3.180998e-01
      6135    466_540822 1991 invSimpson 2.500957e+00 -9.107475e-02 3.123518e-01
      6136    466_540822 1991        PIE 6.006144e-01 -1.065224e-02 3.228875e-01
      6137    466_540822 1991      DomMc 8.786482e-01  7.660390e-03 4.901627e-01
      6138    466_540822 1991 expShannon 3.258602e+00 -1.076306e-01 3.914520e-01
      6139    466_540822 2001          S 1.500000e+01 -4.657534e-02 8.806059e-01
      6140    466_540822 2001          N 1.138000e+03  4.251781e+01 8.224214e-01
      6141    466_540822 2001       maxN 5.690000e+02  4.377260e+01 7.263616e-01
      6142    466_540822 2001    Shannon 1.175676e+00 -2.515168e-02 3.905780e-01
      6143    466_540822 2001    Simpson 5.957049e-01 -1.067460e-02 3.180998e-01
      6144    466_540822 2001 invSimpson 2.473441e+00 -9.107475e-02 3.123518e-01
      6145    466_540822 2001        PIE 5.962288e-01 -1.065224e-02 3.228875e-01
      6146    466_540822 2001      DomMc 8.901582e-01  7.660390e-03 4.901627e-01
      6147    466_540822 2001 expShannon 3.240332e+00 -1.076306e-01 3.914520e-01
      6148    466_540822 2000          S 1.500000e+01 -4.657534e-02 8.806059e-01
      6149    466_540822 2000          N 4.497000e+03  4.251781e+01 8.224214e-01
      6150    466_540822 2000       maxN 3.154000e+03  4.377260e+01 7.263616e-01
      6151    466_540822 2000    Shannon 8.613408e-01 -2.515168e-02 3.905780e-01
      6152    466_540822 2000    Simpson 4.503436e-01 -1.067460e-02 3.180998e-01
      6153    466_540822 2000 invSimpson 1.819318e+00 -9.107475e-02 3.123518e-01
      6154    466_540822 2000        PIE 4.504437e-01 -1.065224e-02 3.228875e-01
      6155    466_540822 2000      DomMc 9.399600e-01  7.660390e-03 4.901627e-01
      6156    466_540822 2000 expShannon 2.366331e+00 -1.076306e-01 3.914520e-01
      6157    466_540821 1994          S 2.100000e+01 -1.394737e+00 2.079746e-02
      6158    466_540821 1994          N 1.708000e+03 -5.378947e+01 9.237526e-01
      6159    466_540821 1994       maxN 6.760000e+02 -1.047368e+01 9.686336e-01
      6160    466_540821 1994    Shannon 1.513167e+00 -2.998044e-02 1.597328e-01
      6161    466_540821 1994    Simpson 6.951116e-01 -2.308791e-03 4.522839e-01
      6162    466_540821 1994 invSimpson 3.279888e+00 -2.383111e-02 4.542641e-01
      6163    466_540821 1994        PIE 6.955188e-01 -2.282521e-03 4.447935e-01
      6164    466_540821 1994      DomMc 7.634660e-01 -6.101013e-03 6.729757e-01
      6165    466_540821 1994 expShannon 4.541089e+00 -1.264710e-01 1.464832e-01
      6166    466_540821 1997          S 1.700000e+01 -1.394737e+00 2.079746e-02
      6167    466_540821 1997          N 3.353000e+03 -5.378947e+01 9.237526e-01
      6168    466_540821 1997       maxN 1.503000e+03 -1.047368e+01 9.686336e-01
      6169    466_540821 1997    Shannon 1.454281e+00 -2.998044e-02 1.597328e-01
      6170    466_540821 1997    Simpson 6.962126e-01 -2.308791e-03 4.522839e-01
      6171    466_540821 1997 invSimpson 3.291776e+00 -2.383111e-02 4.542641e-01
      6172    466_540821 1997        PIE 6.964203e-01 -2.282521e-03 4.447935e-01
      6173    466_540821 1997      DomMc 7.014614e-01 -6.101013e-03 6.729757e-01
      6174    466_540821 1997 expShannon 4.281404e+00 -1.264710e-01 1.464832e-01
      6175    466_540821 1999          S 1.400000e+01 -1.394737e+00 2.079746e-02
      6176    466_540821 1999          N 1.181000e+03 -5.378947e+01 9.237526e-01
      6177    466_540821 1999       maxN 5.010000e+02 -1.047368e+01 9.686336e-01
      6178    466_540821 1999    Shannon 1.358828e+00 -2.998044e-02 1.597328e-01
      6179    466_540821 1999    Simpson 6.824209e-01 -2.308791e-03 4.522839e-01
      6180    466_540821 1999 invSimpson 3.148821e+00 -2.383111e-02 4.542641e-01
      6181    466_540821 1999        PIE 6.829992e-01 -2.282521e-03 4.447935e-01
      6182    466_540821 1999      DomMc 7.392041e-01 -6.101013e-03 6.729757e-01
      6183    466_540821 1999 expShannon 3.891630e+00 -1.264710e-01 1.464832e-01
      6184    466_542996 1995          S 2.700000e+01 -1.727519e-01 3.169047e-01
      6185    466_542996 1995          N 3.840000e+03 -6.694361e+02 1.043734e-01
      6186    466_542996 1995       maxN 2.394000e+03 -5.072113e+02 1.435572e-01
      6187    466_542996 1995    Shannon 1.244909e+00  5.135554e-02 1.800968e-02
      6188    466_542996 1995    Simpson 5.711197e-01  1.613247e-02 6.594993e-02
      6189    466_542996 1995 invSimpson 2.331653e+00  1.214833e-01 2.698204e-02
      6190    466_542996 1995        PIE 5.712684e-01  1.629066e-02 6.388408e-02
      6191    466_542996 1995      DomMc 7.700521e-01 -1.329817e-02 2.727421e-02
      6192    466_542996 1995 expShannon 3.472617e+00  2.350473e-01 8.900250e-03
      6193    466_542996 1996          S 2.400000e+01 -1.727519e-01 3.169047e-01
      6194    466_542996 1996          N 3.322300e+04 -6.694361e+02 1.043734e-01
      6195    466_542996 1996       maxN 2.733600e+04 -5.072113e+02 1.435572e-01
      6196    466_542996 1996    Shannon 7.356340e-01  5.135554e-02 1.800968e-02
      6197    466_542996 1996    Simpson 3.137267e-01  1.613247e-02 6.594993e-02
      6198    466_542996 1996 invSimpson 1.457145e+00  1.214833e-01 2.698204e-02
      6199    466_542996 1996        PIE 3.137362e-01  1.629066e-02 6.388408e-02
      6200    466_542996 1996      DomMc 9.026277e-01 -1.329817e-02 2.727421e-02
      6201    466_542996 1996 expShannon 2.086805e+00  2.350473e-01 8.900250e-03
      6202    466_542996 2001          S 2.000000e+01 -1.727519e-01 3.169047e-01
      6203    466_542996 2001          N 1.781000e+03 -6.694361e+02 1.043734e-01
      6204    466_542996 2001       maxN 8.320000e+02 -5.072113e+02 1.435572e-01
      6205    466_542996 2001    Shannon 1.515180e+00  5.135554e-02 1.800968e-02
      6206    466_542996 2001    Simpson 6.994235e-01  1.613247e-02 6.594993e-02
      6207    466_542996 2001 invSimpson 3.326940e+00  1.214833e-01 2.698204e-02
      6208    466_542996 2001        PIE 6.998164e-01  1.629066e-02 6.388408e-02
      6209    466_542996 2001      DomMc 7.024144e-01 -1.329817e-02 2.727421e-02
      6210    466_542996 2001 expShannon 4.550239e+00  2.350473e-01 8.900250e-03
      6211    466_542996 2000          S 1.500000e+01 -1.727519e-01 3.169047e-01
      6212    466_542996 2000          N 8.880000e+02 -6.694361e+02 1.043734e-01
      6213    466_542996 2000       maxN 3.080000e+02 -5.072113e+02 1.435572e-01
      6214    466_542996 2000    Shannon 1.642956e+00  5.135554e-02 1.800968e-02
      6215    466_542996 2000    Simpson 7.494166e-01  1.613247e-02 6.594993e-02
      6216    466_542996 2000 invSimpson 3.990688e+00  1.214833e-01 2.698204e-02
      6217    466_542996 2000        PIE 7.502615e-01  1.629066e-02 6.388408e-02
      6218    466_542996 2000      DomMc 6.587838e-01 -1.329817e-02 2.727421e-02
      6219    466_542996 2000 expShannon 5.170431e+00  2.350473e-01 8.900250e-03
      6220    466_542996 1992          S 2.200000e+01 -1.727519e-01 3.169047e-01
      6221    466_542996 1992          N 3.224000e+03 -6.694361e+02 1.043734e-01
      6222    466_542996 1992       maxN 1.390000e+03 -5.072113e+02 1.435572e-01
      6223    466_542996 1992    Shannon 1.766216e+00  5.135554e-02 1.800968e-02
      6224    466_542996 1992    Simpson 7.509646e-01  1.613247e-02 6.594993e-02
      6225    466_542996 1992 invSimpson 4.015493e+00  1.214833e-01 2.698204e-02
      6226    466_542996 1992        PIE 7.511976e-01  1.629066e-02 6.388408e-02
      6227    466_542996 1992      DomMc 5.939826e-01 -1.329817e-02 2.727421e-02
      6228    466_542996 1992 expShannon 5.848682e+00  2.350473e-01 8.900250e-03
      6229    466_542996 1993          S 1.800000e+01 -1.727519e-01 3.169047e-01
      6230    466_542996 1993          N 7.835000e+03 -6.694361e+02 1.043734e-01
      6231    466_542996 1993       maxN 5.512000e+03 -5.072113e+02 1.435572e-01
      6232    466_542996 1993    Shannon 9.791323e-01  5.135554e-02 1.800968e-02
      6233    466_542996 1993    Simpson 4.711314e-01  1.613247e-02 6.594993e-02
      6234    466_542996 1993 invSimpson 1.890829e+00  1.214833e-01 2.698204e-02
      6235    466_542996 1993        PIE 4.711915e-01  1.629066e-02 6.388408e-02
      6236    466_542996 1993      DomMc 8.585833e-01 -1.329817e-02 2.727421e-02
      6237    466_542996 1993 expShannon 2.662145e+00  2.350473e-01 8.900250e-03
      6238    466_542996 1997          S 1.900000e+01 -1.727519e-01 3.169047e-01
      6239    466_542996 1997          N 5.699000e+03 -6.694361e+02 1.043734e-01
      6240    466_542996 1997       maxN 3.032000e+03 -5.072113e+02 1.435572e-01
      6241    466_542996 1997    Shannon 1.420784e+00  5.135554e-02 1.800968e-02
      6242    466_542996 1997    Simpson 6.542637e-01  1.613247e-02 6.594993e-02
      6243    466_542996 1997 invSimpson 2.892378e+00  1.214833e-01 2.698204e-02
      6244    466_542996 1997        PIE 6.543785e-01  1.629066e-02 6.388408e-02
      6245    466_542996 1997      DomMc 7.324092e-01 -1.329817e-02 2.727421e-02
      6246    466_542996 1997 expShannon 4.140364e+00  2.350473e-01 8.900250e-03
      6247    466_542996 1998          S 2.000000e+01 -1.727519e-01 3.169047e-01
      6248    466_542996 1998          N 5.763000e+03 -6.694361e+02 1.043734e-01
      6249    466_542996 1998       maxN 3.387000e+03 -5.072113e+02 1.435572e-01
      6250    466_542996 1998    Shannon 1.318366e+00  5.135554e-02 1.800968e-02
      6251    466_542996 1998    Simpson 6.065135e-01  1.613247e-02 6.594993e-02
      6252    466_542996 1998 invSimpson 2.541383e+00  1.214833e-01 2.698204e-02
      6253    466_542996 1998        PIE 6.066188e-01  1.629066e-02 6.388408e-02
      6254    466_542996 1998      DomMc 7.477009e-01 -1.329817e-02 2.727421e-02
      6255    466_542996 1998 expShannon 3.737311e+00  2.350473e-01 8.900250e-03
      6256    466_542996 2002          S 2.100000e+01 -1.727519e-01 3.169047e-01
      6257    466_542996 2002          N 5.085000e+03 -6.694361e+02 1.043734e-01
      6258    466_542996 2002       maxN 2.168000e+03 -5.072113e+02 1.435572e-01
      6259    466_542996 2002    Shannon 1.496319e+00  5.135554e-02 1.800968e-02
      6260    466_542996 2002    Simpson 7.036716e-01  1.613247e-02 6.594993e-02
      6261    466_542996 2002 invSimpson 3.374634e+00  1.214833e-01 2.698204e-02
      6262    466_542996 2002        PIE 7.038100e-01  1.629066e-02 6.388408e-02
      6263    466_542996 2002      DomMc 7.380531e-01 -1.329817e-02 2.727421e-02
      6264    466_542996 2002 expShannon 4.465221e+00  2.350473e-01 8.900250e-03
      6265    466_542996 2005          S 2.000000e+01 -1.727519e-01 3.169047e-01
      6266    466_542996 2005          N 1.261000e+03 -6.694361e+02 1.043734e-01
      6267    466_542996 2005       maxN 4.940000e+02 -5.072113e+02 1.435572e-01
      6268    466_542996 2005    Shannon 1.654463e+00  5.135554e-02 1.800968e-02
      6269    466_542996 2005    Simpson 7.422441e-01  1.613247e-02 6.594993e-02
      6270    466_542996 2005 invSimpson 3.879640e+00  1.214833e-01 2.698204e-02
      6271    466_542996 2005        PIE 7.428332e-01  1.629066e-02 6.388408e-02
      6272    466_542996 2005      DomMc 6.574148e-01 -1.329817e-02 2.727421e-02
      6273    466_542996 2005 expShannon 5.230268e+00  2.350473e-01 8.900250e-03
      6274    466_542996 2006          S 1.800000e+01 -1.727519e-01 3.169047e-01
      6275    466_542996 2006          N 1.189000e+03 -6.694361e+02 1.043734e-01
      6276    466_542996 2006       maxN 5.670000e+02 -5.072113e+02 1.435572e-01
      6277    466_542996 2006    Shannon 1.643766e+00  5.135554e-02 1.800968e-02
      6278    466_542996 2006    Simpson 7.096124e-01  1.613247e-02 6.594993e-02
      6279    466_542996 2006 invSimpson 3.443674e+00  1.214833e-01 2.698204e-02
      6280    466_542996 2006        PIE 7.102098e-01  1.629066e-02 6.388408e-02
      6281    466_542996 2006      DomMc 6.576955e-01 -1.329817e-02 2.727421e-02
      6282    466_542996 2006 expShannon 5.174620e+00  2.350473e-01 8.900250e-03
      6283    466_542996 2003          S 2.100000e+01 -1.727519e-01 3.169047e-01
      6284    466_542996 2003          N 4.664000e+03 -6.694361e+02 1.043734e-01
      6285    466_542996 2003       maxN 2.619000e+03 -5.072113e+02 1.435572e-01
      6286    466_542996 2003    Shannon 1.342671e+00  5.135554e-02 1.800968e-02
      6287    466_542996 2003    Simpson 6.261730e-01  1.613247e-02 6.594993e-02
      6288    466_542996 2003 invSimpson 2.675034e+00  1.214833e-01 2.698204e-02
      6289    466_542996 2003        PIE 6.263073e-01  1.629066e-02 6.388408e-02
      6290    466_542996 2003      DomMc 7.446398e-01 -1.329817e-02 2.727421e-02
      6291    466_542996 2003 expShannon 3.829257e+00  2.350473e-01 8.900250e-03
      6292    466_542996 2008          S 1.700000e+01 -1.727519e-01 3.169047e-01
      6293    466_542996 2008          N 2.230000e+02 -6.694361e+02 1.043734e-01
      6294    466_542996 2008       maxN 9.400000e+01 -5.072113e+02 1.435572e-01
      6295    466_542996 2008    Shannon 2.085926e+00  5.135554e-02 1.800968e-02
      6296    466_542996 2008    Simpson 7.865431e-01  1.613247e-02 6.594993e-02
      6297    466_542996 2008 invSimpson 4.684786e+00  1.214833e-01 2.698204e-02
      6298    466_542996 2008        PIE 7.900861e-01  1.629066e-02 6.388408e-02
      6299    466_542996 2008      DomMc 5.381166e-01 -1.329817e-02 2.727421e-02
      6300    466_542996 2008 expShannon 8.052044e+00  2.350473e-01 8.900250e-03
      6301    466_542996 2007          S 2.200000e+01 -1.727519e-01 3.169047e-01
      6302    466_542996 2007          N 1.910000e+02 -6.694361e+02 1.043734e-01
      6303    466_542996 2007       maxN 9.500000e+01 -5.072113e+02 1.435572e-01
      6304    466_542996 2007    Shannon 1.988907e+00  5.135554e-02 1.800968e-02
      6305    466_542996 2007    Simpson 7.272827e-01  1.613247e-02 6.594993e-02
      6306    466_542996 2007 invSimpson 3.666801e+00  1.214833e-01 2.698204e-02
      6307    466_542996 2007        PIE 7.311105e-01  1.629066e-02 6.388408e-02
      6308    466_542996 2007      DomMc 5.863874e-01 -1.329817e-02 2.727421e-02
      6309    466_542996 2007 expShannon 7.307539e+00  2.350473e-01 8.900250e-03
      6310    466_542996 2004          S 1.900000e+01 -1.727519e-01 3.169047e-01
      6311    466_542996 2004          N 8.320000e+02 -6.694361e+02 1.043734e-01
      6312    466_542996 2004       maxN 3.010000e+02 -5.072113e+02 1.435572e-01
      6313    466_542996 2004    Shannon 2.015179e+00  5.135554e-02 1.800968e-02
      6314    466_542996 2004    Simpson 8.041154e-01  1.613247e-02 6.594993e-02
      6315    466_542996 2004 invSimpson 5.105047e+00  1.214833e-01 2.698204e-02
      6316    466_542996 2004        PIE 8.050831e-01  1.629066e-02 6.388408e-02
      6317    466_542996 2004      DomMc 5.360577e-01 -1.329817e-02 2.727421e-02
      6318    466_542996 2004 expShannon 7.502068e+00  2.350473e-01 8.900250e-03
      6319    466_542996 1999          S 1.400000e+01 -1.727519e-01 3.169047e-01
      6320    466_542996 1999          N 2.630000e+03 -6.694361e+02 1.043734e-01
      6321    466_542996 1999       maxN 2.344000e+03 -5.072113e+02 1.435572e-01
      6322    466_542996 1999    Shannon 5.336554e-01  5.135554e-02 1.800968e-02
      6323    466_542996 1999    Simpson 2.025098e-01  1.613247e-02 6.594993e-02
      6324    466_542996 1999 invSimpson 1.253934e+00  1.214833e-01 2.698204e-02
      6325    466_542996 1999        PIE 2.025868e-01  1.629066e-02 6.388408e-02
      6326    466_542996 1999      DomMc 9.395437e-01 -1.329817e-02 2.727421e-02
      6327    466_542996 1999 expShannon 1.705154e+00  2.350473e-01 8.900250e-03
      6328    466_541536 1997          S 2.000000e+01 -4.456415e-02 8.178412e-01
      6329    466_541536 1997          N 6.043000e+03 -7.683217e+02 4.274420e-01
      6330    466_541536 1997       maxN 3.539000e+03 -3.860049e+02 6.262099e-01
      6331    466_541536 1997    Shannon 1.119450e+00  6.376918e-03 7.382315e-01
      6332    466_541536 1997    Simpson 5.703514e-01 -3.031468e-03 7.133509e-01
      6333    466_541536 1997 invSimpson 2.327484e+00  6.962695e-03 8.668868e-01
      6334    466_541536 1997        PIE 5.704458e-01 -3.016690e-03 7.149219e-01
      6335    466_541536 1997      DomMc 8.667880e-01 -4.339529e-03 4.070482e-01
      6336    466_541536 1997 expShannon 3.063168e+00  3.653163e-02 5.509580e-01
      6337    466_541536 1992          S 2.100000e+01 -4.456415e-02 8.178412e-01
      6338    466_541536 1992          N 2.867700e+04 -7.683217e+02 4.274420e-01
      6339    466_541536 1992       maxN 1.903100e+04 -3.860049e+02 6.262099e-01
      6340    466_541536 1992    Shannon 1.003780e+00  6.376918e-03 7.382315e-01
      6341    466_541536 1992    Simpson 5.099103e-01 -3.031468e-03 7.133509e-01
      6342    466_541536 1992 invSimpson 2.040443e+00  6.962695e-03 8.668868e-01
      6343    466_541536 1992        PIE 5.099281e-01 -3.016690e-03 7.149219e-01
      6344    466_541536 1992      DomMc 8.566098e-01 -4.339529e-03 4.070482e-01
      6345    466_541536 1992 expShannon 2.728576e+00  3.653163e-02 5.509580e-01
      6346    466_541536 1993          S 2.200000e+01 -4.456415e-02 8.178412e-01
      6347    466_541536 1993          N 9.120000e+03 -7.683217e+02 4.274420e-01
      6348    466_541536 1993       maxN 6.664000e+03 -3.860049e+02 6.262099e-01
      6349    466_541536 1993    Shannon 9.227908e-01  6.376918e-03 7.382315e-01
      6350    466_541536 1993    Simpson 4.369981e-01 -3.031468e-03 7.133509e-01
      6351    466_541536 1993 invSimpson 1.776193e+00  6.962695e-03 8.668868e-01
      6352    466_541536 1993        PIE 4.370460e-01 -3.016690e-03 7.149219e-01
      6353    466_541536 1993      DomMc 8.777412e-01 -4.339529e-03 4.070482e-01
      6354    466_541536 1993 expShannon 2.516303e+00  3.653163e-02 5.509580e-01
      6355    466_541536 1995          S 1.800000e+01 -4.456415e-02 8.178412e-01
      6356    466_541536 1995          N 5.496500e+04 -7.683217e+02 4.274420e-01
      6357    466_541536 1995       maxN 4.223500e+04 -3.860049e+02 6.262099e-01
      6358    466_541536 1995    Shannon 7.286962e-01  6.376918e-03 7.382315e-01
      6359    466_541536 1995    Simpson 3.775779e-01 -3.031468e-03 7.133509e-01
      6360    466_541536 1995 invSimpson 1.606627e+00  6.962695e-03 8.668868e-01
      6361    466_541536 1995        PIE 3.775848e-01 -3.016690e-03 7.149219e-01
      6362    466_541536 1995      DomMc 9.419631e-01 -4.339529e-03 4.070482e-01
      6363    466_541536 1995 expShannon 2.072377e+00  3.653163e-02 5.509580e-01
      6364    466_541536 1998          S 2.300000e+01 -4.456415e-02 8.178412e-01
      6365    466_541536 1998          N 5.943000e+03 -7.683217e+02 4.274420e-01
      6366    466_541536 1998       maxN 4.055000e+03 -3.860049e+02 6.262099e-01
      6367    466_541536 1998    Shannon 1.006623e+00  6.376918e-03 7.382315e-01
      6368    466_541536 1998    Simpson 4.829471e-01 -3.031468e-03 7.133509e-01
      6369    466_541536 1998 invSimpson 1.934038e+00  6.962695e-03 8.668868e-01
      6370    466_541536 1998        PIE 4.830284e-01 -3.016690e-03 7.149219e-01
      6371    466_541536 1998      DomMc 9.056032e-01 -4.339529e-03 4.070482e-01
      6372    466_541536 1998 expShannon 2.736345e+00  3.653163e-02 5.509580e-01
      6373    466_541536 2000          S 1.600000e+01 -4.456415e-02 8.178412e-01
      6374    466_541536 2000          N 1.044500e+04 -7.683217e+02 4.274420e-01
      6375    466_541536 2000       maxN 7.086000e+03 -3.860049e+02 6.262099e-01
      6376    466_541536 2000    Shannon 8.865478e-01  6.376918e-03 7.382315e-01
      6377    466_541536 2000    Simpson 4.732555e-01 -3.031468e-03 7.133509e-01
      6378    466_541536 2000 invSimpson 1.898454e+00  6.962695e-03 8.668868e-01
      6379    466_541536 2000        PIE 4.733008e-01 -3.016690e-03 7.149219e-01
      6380    466_541536 2000      DomMc 9.324079e-01 -4.339529e-03 4.070482e-01
      6381    466_541536 2000 expShannon 2.426738e+00  3.653163e-02 5.509580e-01
      6382    466_541536 2001          S 1.600000e+01 -4.456415e-02 8.178412e-01
      6383    466_541536 2001          N 2.931000e+03 -7.683217e+02 4.274420e-01
      6384    466_541536 2001       maxN 1.889000e+03 -3.860049e+02 6.262099e-01
      6385    466_541536 2001    Shannon 1.077413e+00  6.376918e-03 7.382315e-01
      6386    466_541536 2001    Simpson 5.256824e-01 -3.031468e-03 7.133509e-01
      6387    466_541536 2001 invSimpson 2.108292e+00  6.962695e-03 8.668868e-01
      6388    466_541536 2001        PIE 5.258618e-01 -3.016690e-03 7.149219e-01
      6389    466_541536 2001      DomMc 8.792221e-01 -4.339529e-03 4.070482e-01
      6390    466_541536 2001 expShannon 2.937072e+00  3.653163e-02 5.509580e-01
      6391    466_541536 2002          S 2.000000e+01 -4.456415e-02 8.178412e-01
      6392    466_541536 2002          N 2.185000e+03 -7.683217e+02 4.274420e-01
      6393    466_541536 2002       maxN 8.140000e+02 -3.860049e+02 6.262099e-01
      6394    466_541536 2002    Shannon 1.700492e+00  6.376918e-03 7.382315e-01
      6395    466_541536 2002    Simpson 7.538405e-01 -3.031468e-03 7.133509e-01
      6396    466_541536 2002 invSimpson 4.062406e+00  6.962695e-03 8.668868e-01
      6397    466_541536 2002        PIE 7.541856e-01 -3.016690e-03 7.149219e-01
      6398    466_541536 2002      DomMc 6.549199e-01 -4.339529e-03 4.070482e-01
      6399    466_541536 2002 expShannon 5.476641e+00  3.653163e-02 5.509580e-01
      6400    466_541536 2004          S 1.600000e+01 -4.456415e-02 8.178412e-01
      6401    466_541536 2004          N 1.644800e+04 -7.683217e+02 4.274420e-01
      6402    466_541536 2004       maxN 1.321100e+04 -3.860049e+02 6.262099e-01
      6403    466_541536 2004    Shannon 7.860110e-01  6.376918e-03 7.382315e-01
      6404    466_541536 2004    Simpson 3.440448e-01 -3.031468e-03 7.133509e-01
      6405    466_541536 2004 invSimpson 1.524494e+00  6.962695e-03 8.668868e-01
      6406    466_541536 2004        PIE 3.440657e-01 -3.016690e-03 7.149219e-01
      6407    466_541536 2004      DomMc 8.803502e-01 -4.339529e-03 4.070482e-01
      6408    466_541536 2004 expShannon 2.194625e+00  3.653163e-02 5.509580e-01
      6409    466_541536 2005          S 1.800000e+01 -4.456415e-02 8.178412e-01
      6410    466_541536 2005          N 7.620000e+02 -7.683217e+02 4.274420e-01
      6411    466_541536 2005       maxN 4.790000e+02 -3.860049e+02 6.262099e-01
      6412    466_541536 2005    Shannon 1.491608e+00  6.376918e-03 7.382315e-01
      6413    466_541536 2005    Simpson 5.862353e-01 -3.031468e-03 7.133509e-01
      6414    466_541536 2005 invSimpson 2.416832e+00  6.962695e-03 8.668868e-01
      6415    466_541536 2005        PIE 5.870056e-01 -3.016690e-03 7.149219e-01
      6416    466_541536 2005      DomMc 7.020997e-01 -4.339529e-03 4.070482e-01
      6417    466_541536 2005 expShannon 4.444235e+00  3.653163e-02 5.509580e-01
      6418    466_541536 2006          S 2.300000e+01 -4.456415e-02 8.178412e-01
      6419    466_541536 2006          N 9.521000e+03 -7.683217e+02 4.274420e-01
      6420    466_541536 2006       maxN 6.795000e+03 -3.860049e+02 6.262099e-01
      6421    466_541536 2006    Shannon 1.035899e+00  6.376918e-03 7.382315e-01
      6422    466_541536 2006    Simpson 4.648586e-01 -3.031468e-03 7.133509e-01
      6423    466_541536 2006 invSimpson 1.868665e+00  6.962695e-03 8.668868e-01
      6424    466_541536 2006        PIE 4.649074e-01 -3.016690e-03 7.149219e-01
      6425    466_541536 2006      DomMc 8.547421e-01 -4.339529e-03 4.070482e-01
      6426    466_541536 2006 expShannon 2.817639e+00  3.653163e-02 5.509580e-01
      6427    466_541536 2007          S 2.300000e+01 -4.456415e-02 8.178412e-01
      6428    466_541536 2007          N 3.761200e+04 -7.683217e+02 4.274420e-01
      6429    466_541536 2007       maxN 3.360500e+04 -3.860049e+02 6.262099e-01
      6430    466_541536 2007    Shannon 4.825057e-01  6.376918e-03 7.382315e-01
      6431    466_541536 2007    Simpson 1.972467e-01 -3.031468e-03 7.133509e-01
      6432    466_541536 2007 invSimpson 1.245713e+00  6.962695e-03 8.668868e-01
      6433    466_541536 2007        PIE 1.972519e-01 -3.016690e-03 7.149219e-01
      6434    466_541536 2007      DomMc 9.549612e-01 -4.339529e-03 4.070482e-01
      6435    466_541536 2007 expShannon 1.620129e+00  3.653163e-02 5.509580e-01
      6436    466_541536 1999          S 1.400000e+01 -4.456415e-02 8.178412e-01
      6437    466_541536 1999          N 6.815000e+03 -7.683217e+02 4.274420e-01
      6438    466_541536 1999       maxN 4.090000e+03 -3.860049e+02 6.262099e-01
      6439    466_541536 1999    Shannon 1.102976e+00  6.376918e-03 7.382315e-01
      6440    466_541536 1999    Simpson 5.530761e-01 -3.031468e-03 7.133509e-01
      6441    466_541536 1999 invSimpson 2.237518e+00  6.962695e-03 8.668868e-01
      6442    466_541536 1999        PIE 5.531573e-01 -3.016690e-03 7.149219e-01
      6443    466_541536 1999      DomMc 8.905356e-01 -4.339529e-03 4.070482e-01
      6444    466_541536 1999 expShannon 3.013119e+00  3.653163e-02 5.509580e-01
      6445    466_541536 2003          S 1.600000e+01 -4.456415e-02 8.178412e-01
      6446    466_541536 2003          N 3.787000e+03 -7.683217e+02 4.274420e-01
      6447    466_541536 2003       maxN 2.108000e+03 -3.860049e+02 6.262099e-01
      6448    466_541536 2003    Shannon 1.295366e+00  6.376918e-03 7.382315e-01
      6449    466_541536 2003    Simpson 6.152435e-01 -3.031468e-03 7.133509e-01
      6450    466_541536 2003 invSimpson 2.599046e+00  6.962695e-03 8.668868e-01
      6451    466_541536 2003        PIE 6.154060e-01 -3.016690e-03 7.149219e-01
      6452    466_541536 2003      DomMc 8.080275e-01 -4.339529e-03 4.070482e-01
      6453    466_541536 2003 expShannon 3.652334e+00  3.653163e-02 5.509580e-01
      6454    466_545180 1990          S 1.900000e+01 -1.234770e-01 2.144846e-01
      6455    466_545180 1990          N 1.194000e+03  1.499836e+01 9.274127e-01
      6456    466_545180 1990       maxN 7.180000e+02  2.331244e+01 8.241290e-01
      6457    466_545180 1990    Shannon 1.441676e+00 -1.026149e-02 3.784882e-01
      6458    466_545180 1990    Simpson 6.075338e-01 -1.580437e-03 7.304638e-01
      6459    466_545180 1990 invSimpson 2.547990e+00 -1.133169e-02 7.448846e-01
      6460    466_545180 1990        PIE 6.080430e-01 -1.554070e-03 7.356573e-01
      6461    466_545180 1990      DomMc 7.311558e-01  2.726105e-03 5.189411e-01
      6462    466_545180 1990 expShannon 4.227776e+00 -3.650012e-02 4.074566e-01
      6463    466_545180 1991          S 1.700000e+01 -1.234770e-01 2.144846e-01
      6464    466_545180 1991          N 3.437000e+03  1.499836e+01 9.274127e-01
      6465    466_545180 1991       maxN 2.505000e+03  2.331244e+01 8.241290e-01
      6466    466_545180 1991    Shannon 9.765579e-01 -1.026149e-02 3.784882e-01
      6467    466_545180 1991    Simpson 4.452049e-01 -1.580437e-03 7.304638e-01
      6468    466_545180 1991 invSimpson 1.802467e+00 -1.133169e-02 7.448846e-01
      6469    466_545180 1991        PIE 4.453345e-01 -1.554070e-03 7.356573e-01
      6470    466_545180 1991      DomMc 8.521967e-01  2.726105e-03 5.189411e-01
      6471    466_545180 1991 expShannon 2.655301e+00 -3.650012e-02 4.074566e-01
      6472    466_545180 1992          S 2.000000e+01 -1.234770e-01 2.144846e-01
      6473    466_545180 1992          N 2.314000e+03  1.499836e+01 9.274127e-01
      6474    466_545180 1992       maxN 1.148000e+03  2.331244e+01 8.241290e-01
      6475    466_545180 1992    Shannon 1.440572e+00 -1.026149e-02 3.784882e-01
      6476    466_545180 1992    Simpson 6.633393e-01 -1.580437e-03 7.304638e-01
      6477    466_545180 1992 invSimpson 2.970350e+00 -1.133169e-02 7.448846e-01
      6478    466_545180 1992        PIE 6.636261e-01 -1.554070e-03 7.356573e-01
      6479    466_545180 1992      DomMc 7.791703e-01  2.726105e-03 5.189411e-01
      6480    466_545180 1992 expShannon 4.223110e+00 -3.650012e-02 4.074566e-01
      6481    466_545180 1993          S 2.200000e+01 -1.234770e-01 2.144846e-01
      6482    466_545180 1993          N 4.217000e+03  1.499836e+01 9.274127e-01
      6483    466_545180 1993       maxN 1.711000e+03  2.331244e+01 8.241290e-01
      6484    466_545180 1993    Shannon 1.553804e+00 -1.026149e-02 3.784882e-01
      6485    466_545180 1993    Simpson 7.236943e-01 -1.580437e-03 7.304638e-01
      6486    466_545180 1993 invSimpson 3.619180e+00 -1.133169e-02 7.448846e-01
      6487    466_545180 1993        PIE 7.238659e-01 -1.554070e-03 7.356573e-01
      6488    466_545180 1993      DomMc 6.580507e-01  2.726105e-03 5.189411e-01
      6489    466_545180 1993 expShannon 4.729428e+00 -3.650012e-02 4.074566e-01
      6490    466_545180 1994          S 2.200000e+01 -1.234770e-01 2.144846e-01
      6491    466_545180 1994          N 8.283000e+03  1.499836e+01 9.274127e-01
      6492    466_545180 1994       maxN 5.329000e+03  2.331244e+01 8.241290e-01
      6493    466_545180 1994    Shannon 1.171727e+00 -1.026149e-02 3.784882e-01
      6494    466_545180 1994    Simpson 5.413020e-01 -1.580437e-03 7.304638e-01
      6495    466_545180 1994 invSimpson 2.180084e+00 -1.133169e-02 7.448846e-01
      6496    466_545180 1994        PIE 5.413674e-01 -1.554070e-03 7.356573e-01
      6497    466_545180 1994      DomMc 8.413618e-01  2.726105e-03 5.189411e-01
      6498    466_545180 1994 expShannon 3.227563e+00 -3.650012e-02 4.074566e-01
      6499    466_545180 1995          S 1.900000e+01 -1.234770e-01 2.144846e-01
      6500    466_545180 1995          N 1.977000e+03  1.499836e+01 9.274127e-01
      6501    466_545180 1995       maxN 6.650000e+02  2.331244e+01 8.241290e-01
      6502    466_545180 1995    Shannon 1.674013e+00 -1.026149e-02 3.784882e-01
      6503    466_545180 1995    Simpson 7.641565e-01 -1.580437e-03 7.304638e-01
      6504    466_545180 1995 invSimpson 4.240101e+00 -1.133169e-02 7.448846e-01
      6505    466_545180 1995        PIE 7.645433e-01 -1.554070e-03 7.356573e-01
      6506    466_545180 1995      DomMc 6.160850e-01  2.726105e-03 5.189411e-01
      6507    466_545180 1995 expShannon 5.333526e+00 -3.650012e-02 4.074566e-01
      6508    466_545180 1996          S 1.900000e+01 -1.234770e-01 2.144846e-01
      6509    466_545180 1996          N 9.872000e+03  1.499836e+01 9.274127e-01
      6510    466_545180 1996       maxN 4.266000e+03  2.331244e+01 8.241290e-01
      6511    466_545180 1996    Shannon 1.260449e+00 -1.026149e-02 3.784882e-01
      6512    466_545180 1996    Simpson 6.584672e-01 -1.580437e-03 7.304638e-01
      6513    466_545180 1996 invSimpson 2.927976e+00 -1.133169e-02 7.448846e-01
      6514    466_545180 1996        PIE 6.585339e-01 -1.554070e-03 7.356573e-01
      6515    466_545180 1996      DomMc 7.872771e-01  2.726105e-03 5.189411e-01
      6516    466_545180 1996 expShannon 3.527006e+00 -3.650012e-02 4.074566e-01
      6517    466_545180 1998          S 2.100000e+01 -1.234770e-01 2.144846e-01
      6518    466_545180 1998          N 1.190400e+04  1.499836e+01 9.274127e-01
      6519    466_545180 1998       maxN 8.274000e+03  2.331244e+01 8.241290e-01
      6520    466_545180 1998    Shannon 9.192097e-01 -1.026149e-02 3.784882e-01
      6521    466_545180 1998    Simpson 4.640040e-01 -1.580437e-03 7.304638e-01
      6522    466_545180 1998 invSimpson 1.865686e+00 -1.133169e-02 7.448846e-01
      6523    466_545180 1998        PIE 4.640430e-01 -1.554070e-03 7.356573e-01
      6524    466_545180 1998      DomMc 9.217070e-01  2.726105e-03 5.189411e-01
      6525    466_545180 1998 expShannon 2.507308e+00 -3.650012e-02 4.074566e-01
      6526    466_545180 1999          S 1.700000e+01 -1.234770e-01 2.144846e-01
      6527    466_545180 1999          N 2.481000e+03  1.499836e+01 9.274127e-01
      6528    466_545180 1999       maxN 1.768000e+03  2.331244e+01 8.241290e-01
      6529    466_545180 1999    Shannon 1.034203e+00 -1.026149e-02 3.784882e-01
      6530    466_545180 1999    Simpson 4.685821e-01 -1.580437e-03 7.304638e-01
      6531    466_545180 1999 invSimpson 1.881758e+00 -1.133169e-02 7.448846e-01
      6532    466_545180 1999        PIE 4.687710e-01 -1.554070e-03 7.356573e-01
      6533    466_545180 1999      DomMc 8.218460e-01  2.726105e-03 5.189411e-01
      6534    466_545180 1999 expShannon 2.812864e+00 -3.650012e-02 4.074566e-01
      6535    466_545180 2000          S 2.000000e+01 -1.234770e-01 2.144846e-01
      6536    466_545180 2000          N 4.434000e+03  1.499836e+01 9.274127e-01
      6537    466_545180 2000       maxN 2.647000e+03  2.331244e+01 8.241290e-01
      6538    466_545180 2000    Shannon 1.071657e+00 -1.026149e-02 3.784882e-01
      6539    466_545180 2000    Simpson 5.541334e-01 -1.580437e-03 7.304638e-01
      6540    466_545180 2000 invSimpson 2.242823e+00 -1.133169e-02 7.448846e-01
      6541    466_545180 2000        PIE 5.542584e-01 -1.554070e-03 7.356573e-01
      6542    466_545180 2000      DomMc 8.876861e-01  2.726105e-03 5.189411e-01
      6543    466_545180 2000 expShannon 2.920215e+00 -3.650012e-02 4.074566e-01
      6544    466_545180 2001          S 2.000000e+01 -1.234770e-01 2.144846e-01
      6545    466_545180 2001          N 1.269000e+03  1.499836e+01 9.274127e-01
      6546    466_545180 2001       maxN 7.040000e+02  2.331244e+01 8.241290e-01
      6547    466_545180 2001    Shannon 1.288931e+00 -1.026149e-02 3.784882e-01
      6548    466_545180 2001    Simpson 6.215389e-01 -1.580437e-03 7.304638e-01
      6549    466_545180 2001 invSimpson 2.642279e+00 -1.133169e-02 7.448846e-01
      6550    466_545180 2001        PIE 6.220291e-01 -1.554070e-03 7.356573e-01
      6551    466_545180 2001      DomMc 7.659574e-01  2.726105e-03 5.189411e-01
      6552    466_545180 2001 expShannon 3.628904e+00 -3.650012e-02 4.074566e-01
      6553    466_545180 2002          S 2.000000e+01 -1.234770e-01 2.144846e-01
      6554    466_545180 2002          N 8.140000e+02  1.499836e+01 9.274127e-01
      6555    466_545180 2002       maxN 4.750000e+02  2.331244e+01 8.241290e-01
      6556    466_545180 2002    Shannon 1.421929e+00 -1.026149e-02 3.784882e-01
      6557    466_545180 2002    Simpson 6.189624e-01 -1.580437e-03 7.304638e-01
      6558    466_545180 2002 invSimpson 2.624413e+00 -1.133169e-02 7.448846e-01
      6559    466_545180 2002        PIE 6.197237e-01 -1.554070e-03 7.356573e-01
      6560    466_545180 2002      DomMc 7.334152e-01  2.726105e-03 5.189411e-01
      6561    466_545180 2002 expShannon 4.145109e+00 -3.650012e-02 4.074566e-01
      6562    466_545180 2003          S 1.800000e+01 -1.234770e-01 2.144846e-01
      6563    466_545180 2003          N 8.810000e+03  1.499836e+01 9.274127e-01
      6564    466_545180 2003       maxN 5.499000e+03  2.331244e+01 8.241290e-01
      6565    466_545180 2003    Shannon 9.810617e-01 -1.026149e-02 3.784882e-01
      6566    466_545180 2003    Simpson 5.243265e-01 -1.580437e-03 7.304638e-01
      6567    466_545180 2003 invSimpson 2.102282e+00 -1.133169e-02 7.448846e-01
      6568    466_545180 2003        PIE 5.243860e-01 -1.554070e-03 7.356573e-01
      6569    466_545180 2003      DomMc 9.121453e-01  2.726105e-03 5.189411e-01
      6570    466_545180 2003 expShannon 2.667287e+00 -3.650012e-02 4.074566e-01
      6571    466_545180 1989          S 1.900000e+01 -1.234770e-01 2.144846e-01
      6572    466_545180 1989          N 9.580000e+02  1.499836e+01 9.274127e-01
      6573    466_545180 1989       maxN 4.970000e+02  2.331244e+01 8.241290e-01
      6574    466_545180 1989    Shannon 1.542313e+00 -1.026149e-02 3.784882e-01
      6575    466_545180 1989    Simpson 6.700176e-01 -1.580437e-03 7.304638e-01
      6576    466_545180 1989 invSimpson 3.030464e+00 -1.133169e-02 7.448846e-01
      6577    466_545180 1989        PIE 6.707177e-01 -1.554070e-03 7.356573e-01
      6578    466_545180 1989      DomMc 7.338205e-01  2.726105e-03 5.189411e-01
      6579    466_545180 1989 expShannon 4.675390e+00 -3.650012e-02 4.074566e-01
      6580    466_545180 2004          S 1.700000e+01 -1.234770e-01 2.144846e-01
      6581    466_545180 2004          N 3.829000e+03  1.499836e+01 9.274127e-01
      6582    466_545180 2004       maxN 2.346000e+03  2.331244e+01 8.241290e-01
      6583    466_545180 2004    Shannon 1.109155e+00 -1.026149e-02 3.784882e-01
      6584    466_545180 2004    Simpson 5.579405e-01 -1.580437e-03 7.304638e-01
      6585    466_545180 2004 invSimpson 2.262139e+00 -1.133169e-02 7.448846e-01
      6586    466_545180 2004        PIE 5.580862e-01 -1.554070e-03 7.356573e-01
      6587    466_545180 2004      DomMc 8.474798e-01  2.726105e-03 5.189411e-01
      6588    466_545180 2004 expShannon 3.031796e+00 -3.650012e-02 4.074566e-01
      6589    466_545180 2007          S 2.000000e+01 -1.234770e-01 2.144846e-01
      6590    466_545180 2007          N 3.062000e+03  1.499836e+01 9.274127e-01
      6591    466_545180 2007       maxN 1.856000e+03  2.331244e+01 8.241290e-01
      6592    466_545180 2007    Shannon 1.175625e+00 -1.026149e-02 3.784882e-01
      6593    466_545180 2007    Simpson 5.758323e-01 -1.580437e-03 7.304638e-01
      6594    466_545180 2007 invSimpson 2.357558e+00 -1.133169e-02 7.448846e-01
      6595    466_545180 2007        PIE 5.760204e-01 -1.554070e-03 7.356573e-01
      6596    466_545180 2007      DomMc 7.877204e-01  2.726105e-03 5.189411e-01
      6597    466_545180 2007 expShannon 3.240168e+00 -3.650012e-02 4.074566e-01
      6598    466_545180 2005          S 1.300000e+01 -1.234770e-01 2.144846e-01
      6599    466_545180 2005          N 2.960000e+02  1.499836e+01 9.274127e-01
      6600    466_545180 2005       maxN 1.020000e+02  2.331244e+01 8.241290e-01
      6601    466_545180 2005    Shannon 1.700792e+00 -1.026149e-02 3.784882e-01
      6602    466_545180 2005    Simpson 7.585829e-01 -1.580437e-03 7.304638e-01
      6603    466_545180 2005 invSimpson 4.142209e+00 -1.133169e-02 7.448846e-01
      6604    466_545180 2005        PIE 7.611544e-01 -1.554070e-03 7.356573e-01
      6605    466_545180 2005      DomMc 6.418919e-01  2.726105e-03 5.189411e-01
      6606    466_545180 2005 expShannon 5.478283e+00 -3.650012e-02 4.074566e-01
      6607    466_559014 2000          S 2.500000e+01 -6.296801e-02 6.436032e-01
      6608    466_559014 2000          N 6.515000e+03 -6.540436e+02 2.358391e-02
      6609    466_559014 2000       maxN 3.610000e+03 -6.821535e+02 1.638490e-02
      6610    466_559014 2000    Shannon 1.258290e+00  6.332708e-02 5.639882e-03
      6611    466_559014 2000    Simpson 6.199837e-01  2.793042e-02 7.677474e-03
      6612    466_559014 2000 invSimpson 2.631466e+00  1.306163e-01 3.110262e-02
      6613    466_559014 2000        PIE 6.200789e-01  2.796477e-02 7.629300e-03
      6614    466_559014 2000      DomMc 7.593246e-01 -1.459753e-02 1.359147e-02
      6615    466_559014 2000 expShannon 3.519399e+00  1.937926e-01 1.929895e-02
      6616    466_559014 2003          S 2.300000e+01 -6.296801e-02 6.436032e-01
      6617    466_559014 2003          N 1.680000e+03 -6.540436e+02 2.358391e-02
      6618    466_559014 2003       maxN 4.820000e+02 -6.821535e+02 1.638490e-02
      6619    466_559014 2003    Shannon 2.098400e+00  6.332708e-02 5.639882e-03
      6620    466_559014 2003    Simpson 8.288350e-01  2.793042e-02 7.677474e-03
      6621    466_559014 2003 invSimpson 5.842317e+00  1.306163e-01 3.110262e-02
      6622    466_559014 2003        PIE 8.293287e-01  2.796477e-02 7.629300e-03
      6623    466_559014 2003      DomMc 5.172619e-01 -1.459753e-02 1.359147e-02
      6624    466_559014 2003 expShannon 8.153111e+00  1.937926e-01 1.929895e-02
      6625    466_559014 2004          S 2.000000e+01 -6.296801e-02 6.436032e-01
      6626    466_559014 2004          N 7.960000e+02 -6.540436e+02 2.358391e-02
      6627    466_559014 2004       maxN 2.560000e+02 -6.821535e+02 1.638490e-02
      6628    466_559014 2004    Shannon 1.978163e+00  6.332708e-02 5.639882e-03
      6629    466_559014 2004    Simpson 8.129466e-01  2.793042e-02 7.677474e-03
      6630    466_559014 2004 invSimpson 5.346068e+00  1.306163e-01 3.110262e-02
      6631    466_559014 2004        PIE 8.139692e-01  2.796477e-02 7.629300e-03
      6632    466_559014 2004      DomMc 5.238693e-01 -1.459753e-02 1.359147e-02
      6633    466_559014 2004 expShannon 7.229448e+00  1.937926e-01 1.929895e-02
      6634    466_559014 1989          S 2.200000e+01 -6.296801e-02 6.436032e-01
      6635    466_559014 1989          N 4.675000e+03 -6.540436e+02 2.358391e-02
      6636    466_559014 1989       maxN 4.457000e+03 -6.821535e+02 1.638490e-02
      6637    466_559014 1989    Shannon 2.994542e-01  6.332708e-02 5.639882e-03
      6638    466_559014 1989    Simpson 9.082120e-02  2.793042e-02 7.677474e-03
      6639    466_559014 1989 invSimpson 1.099894e+00  1.306163e-01 3.110262e-02
      6640    466_559014 1989        PIE 9.084063e-02  2.796477e-02 7.629300e-03
      6641    466_559014 1989      DomMc 9.638503e-01 -1.459753e-02 1.359147e-02
      6642    466_559014 1989 expShannon 1.349122e+00  1.937926e-01 1.929895e-02
      6643    466_559014 1993          S 2.100000e+01 -6.296801e-02 6.436032e-01
      6644    466_559014 1993          N 1.301000e+03 -6.540436e+02 2.358391e-02
      6645    466_559014 1993       maxN 5.040000e+02 -6.821535e+02 1.638490e-02
      6646    466_559014 1993    Shannon 1.556895e+00  6.332708e-02 5.639882e-03
      6647    466_559014 1993    Simpson 7.191405e-01  2.793042e-02 7.677474e-03
      6648    466_559014 1993 invSimpson 3.560500e+00  1.306163e-01 3.110262e-02
      6649    466_559014 1993        PIE 7.196937e-01  2.796477e-02 7.629300e-03
      6650    466_559014 1993      DomMc 7.148347e-01 -1.459753e-02 1.359147e-02
      6651    466_559014 1993 expShannon 4.744069e+00  1.937926e-01 1.929895e-02
      6652    466_559014 1995          S 1.800000e+01 -6.296801e-02 6.436032e-01
      6653    466_559014 1995          N 6.694000e+03 -6.540436e+02 2.358391e-02
      6654    466_559014 1995       maxN 5.904000e+03 -6.821535e+02 1.638490e-02
      6655    466_559014 1995    Shannon 5.539322e-01  6.332708e-02 5.639882e-03
      6656    466_559014 1995    Simpson 2.176967e-01  2.793042e-02 7.677474e-03
      6657    466_559014 1995 invSimpson 1.278277e+00  1.306163e-01 3.110262e-02
      6658    466_559014 1995        PIE 2.177293e-01  2.796477e-02 7.629300e-03
      6659    466_559014 1995      DomMc 9.436809e-01 -1.459753e-02 1.359147e-02
      6660    466_559014 1995 expShannon 1.740082e+00  1.937926e-01 1.929895e-02
      6661    466_559014 1998          S 1.900000e+01 -6.296801e-02 6.436032e-01
      6662    466_559014 1998          N 3.815000e+03 -6.540436e+02 2.358391e-02
      6663    466_559014 1998       maxN 1.987000e+03 -6.821535e+02 1.638490e-02
      6664    466_559014 1998    Shannon 1.448051e+00  6.332708e-02 5.639882e-03
      6665    466_559014 1998    Simpson 6.685259e-01  2.793042e-02 7.677474e-03
      6666    466_559014 1998 invSimpson 3.016827e+00  1.306163e-01 3.110262e-02
      6667    466_559014 1998        PIE 6.687012e-01  2.796477e-02 7.629300e-03
      6668    466_559014 1998      DomMc 6.943644e-01 -1.459753e-02 1.359147e-02
      6669    466_559014 1998 expShannon 4.254815e+00  1.937926e-01 1.929895e-02
      6670    466_559014 1986          S 1.900000e+01 -6.296801e-02 6.436032e-01
      6671    466_559014 1986          N 5.922000e+03 -6.540436e+02 2.358391e-02
      6672    466_559014 1986       maxN 5.456000e+03 -6.821535e+02 1.638490e-02
      6673    466_559014 1986    Shannon 4.059048e-01  6.332708e-02 5.639882e-03
      6674    466_559014 1986    Simpson 1.494035e-01  2.793042e-02 7.677474e-03
      6675    466_559014 1986 invSimpson 1.175646e+00  1.306163e-01 3.110262e-02
      6676    466_559014 1986        PIE 1.494288e-01  2.796477e-02 7.629300e-03
      6677    466_559014 1986      DomMc 9.522121e-01 -1.459753e-02 1.359147e-02
      6678    466_559014 1986 expShannon 1.500660e+00  1.937926e-01 1.929895e-02
      6679    466_559014 1987          S 1.900000e+01 -6.296801e-02 6.436032e-01
      6680    466_559014 1987          N 2.313200e+04 -6.540436e+02 2.358391e-02
      6681    466_559014 1987       maxN 2.172800e+04 -6.821535e+02 1.638490e-02
      6682    466_559014 1987    Shannon 3.292747e-01  6.332708e-02 5.639882e-03
      6683    466_559014 1987    Simpson 1.166607e-01  2.793042e-02 7.677474e-03
      6684    466_559014 1987 invSimpson 1.132068e+00  1.306163e-01 3.110262e-02
      6685    466_559014 1987        PIE 1.166658e-01  2.796477e-02 7.629300e-03
      6686    466_559014 1987      DomMc 9.682258e-01 -1.459753e-02 1.359147e-02
      6687    466_559014 1987 expShannon 1.389960e+00  1.937926e-01 1.929895e-02
      6688    466_559014 1991          S 1.600000e+01 -6.296801e-02 6.436032e-01
      6689    466_559014 1991          N 2.358000e+04 -6.540436e+02 2.358391e-02
      6690    466_559014 1991       maxN 2.299300e+04 -6.821535e+02 1.638490e-02
      6691    466_559014 1991    Shannon 1.626206e-01  6.332708e-02 5.639882e-03
      6692    466_559014 1991    Simpson 4.904896e-02  2.793042e-02 7.677474e-03
      6693    466_559014 1991 invSimpson 1.051579e+00  1.306163e-01 3.110262e-02
      6694    466_559014 1991        PIE 4.905104e-02  2.796477e-02 7.629300e-03
      6695    466_559014 1991      DomMc 9.824003e-01 -1.459753e-02 1.359147e-02
      6696    466_559014 1991 expShannon 1.176590e+00  1.937926e-01 1.929895e-02
      6697    466_559014 1994          S 2.200000e+01 -6.296801e-02 6.436032e-01
      6698    466_559014 1994          N 4.120000e+03 -6.540436e+02 2.358391e-02
      6699    466_559014 1994       maxN 2.447000e+03 -6.821535e+02 1.638490e-02
      6700    466_559014 1994    Shannon 1.119744e+00  6.332708e-02 5.639882e-03
      6701    466_559014 1994    Simpson 5.628821e-01  2.793042e-02 7.677474e-03
      6702    466_559014 1994 invSimpson 2.287712e+00  1.306163e-01 3.110262e-02
      6703    466_559014 1994        PIE 5.630188e-01  2.796477e-02 7.629300e-03
      6704    466_559014 1994      DomMc 8.733010e-01 -1.459753e-02 1.359147e-02
      6705    466_559014 1994 expShannon 3.064070e+00  1.937926e-01 1.929895e-02
      6706    466_559014 2002          S 2.000000e+01 -6.296801e-02 6.436032e-01
      6707    466_559014 2002          N 6.218000e+03 -6.540436e+02 2.358391e-02
      6708    466_559014 2002       maxN 2.459000e+03 -6.821535e+02 1.638490e-02
      6709    466_559014 2002    Shannon 1.427452e+00  6.332708e-02 5.639882e-03
      6710    466_559014 2002    Simpson 6.887230e-01  2.793042e-02 7.677474e-03
      6711    466_559014 2002 invSimpson 3.212573e+00  1.306163e-01 3.110262e-02
      6712    466_559014 2002        PIE 6.888338e-01  2.796477e-02 7.629300e-03
      6713    466_559014 2002      DomMc 7.645545e-01 -1.459753e-02 1.359147e-02
      6714    466_559014 2002 expShannon 4.168067e+00  1.937926e-01 1.929895e-02
      6715    466_559014 1999          S 1.500000e+01 -6.296801e-02 6.436032e-01
      6716    466_559014 1999          N 1.442000e+03 -6.540436e+02 2.358391e-02
      6717    466_559014 1999       maxN 9.710000e+02 -6.821535e+02 1.638490e-02
      6718    466_559014 1999    Shannon 1.004745e+00  6.332708e-02 5.639882e-03
      6719    466_559014 1999    Simpson 5.033587e-01  2.793042e-02 7.677474e-03
      6720    466_559014 1999 invSimpson 2.013526e+00  1.306163e-01 3.110262e-02
      6721    466_559014 1999        PIE 5.037080e-01  2.796477e-02 7.629300e-03
      6722    466_559014 1999      DomMc 8.307906e-01 -1.459753e-02 1.359147e-02
      6723    466_559014 1999 expShannon 2.731210e+00  1.937926e-01 1.929895e-02
      6724    466_559014 2001          S 1.800000e+01 -6.296801e-02 6.436032e-01
      6725    466_559014 2001          N 2.100000e+03 -6.540436e+02 2.358391e-02
      6726    466_559014 2001       maxN 1.619000e+03 -6.821535e+02 1.638490e-02
      6727    466_559014 2001    Shannon 9.495890e-01  6.332708e-02 5.639882e-03
      6728    466_559014 2001    Simpson 3.936073e-01  2.793042e-02 7.677474e-03
      6729    466_559014 2001 invSimpson 1.649096e+00  1.306163e-01 3.110262e-02
      6730    466_559014 2001        PIE 3.937948e-01  2.796477e-02 7.629300e-03
      6731    466_559014 2001      DomMc 8.466667e-01 -1.459753e-02 1.359147e-02
      6732    466_559014 2001 expShannon 2.584647e+00  1.937926e-01 1.929895e-02
      6733    466_559014 2007          S 1.300000e+01 -6.296801e-02 6.436032e-01
      6734    466_559014 2007          N 3.650000e+02 -6.540436e+02 2.358391e-02
      6735    466_559014 2007       maxN 2.960000e+02 -6.821535e+02 1.638490e-02
      6736    466_559014 2007    Shannon 8.261686e-01  6.332708e-02 5.639882e-03
      6737    466_559014 2007    Simpson 3.324901e-01  2.793042e-02 7.677474e-03
      6738    466_559014 2007 invSimpson 1.498105e+00  1.306163e-01 3.110262e-02
      6739    466_559014 2007        PIE 3.334036e-01  2.796477e-02 7.629300e-03
      6740    466_559014 2007      DomMc 9.041096e-01 -1.459753e-02 1.359147e-02
      6741    466_559014 2007 expShannon 2.284549e+00  1.937926e-01 1.929895e-02
      6742    466_543722 2001          S 1.800000e+01 -6.153846e-01 3.667166e-01
      6743    466_543722 2001          N 2.671000e+03 -3.784231e+02 4.843270e-02
      6744    466_543722 2001       maxN 1.229000e+03 -1.221154e+02 2.029464e-01
      6745    466_543722 2001    Shannon 1.604534e+00 -7.951435e-02 4.033538e-01
      6746    466_543722 2001    Simpson 7.097024e-01 -3.373692e-02 2.083340e-01
      6747    466_543722 2001 invSimpson 3.444741e+00 -2.795086e-01 1.919107e-01
      6748    466_543722 2001        PIE 7.099682e-01 -3.368044e-02 2.091261e-01
      6749    466_543722 2001      DomMc 7.109697e-01  1.217726e-02 7.069895e-01
      6750    466_543722 2001 expShannon 4.975541e+00 -3.401157e-01 3.694857e-01
      6751    466_543722 2004          S 1.500000e+01 -6.153846e-01 3.667166e-01
      6752    466_543722 2004          N 1.619000e+03 -3.784231e+02 4.843270e-02
      6753    466_543722 2004       maxN 9.790000e+02 -1.221154e+02 2.029464e-01
      6754    466_543722 2004    Shannon 1.197367e+00 -7.951435e-02 4.033538e-01
      6755    466_543722 2004    Simpson 5.754320e-01 -3.373692e-02 2.083340e-01
      6756    466_543722 2004 invSimpson 2.355335e+00 -2.795086e-01 1.919107e-01
      6757    466_543722 2004        PIE 5.757877e-01 -3.368044e-02 2.091261e-01
      6758    466_543722 2004      DomMc 8.184064e-01  1.217726e-02 7.069895e-01
      6759    466_543722 2004 expShannon 3.311387e+00 -3.401157e-01 3.694857e-01
      6760    466_543722 2005          S 1.600000e+01 -6.153846e-01 3.667166e-01
      6761    466_543722 2005          N 1.124000e+03 -3.784231e+02 4.843270e-02
      6762    466_543722 2005       maxN 6.940000e+02 -1.221154e+02 2.029464e-01
      6763    466_543722 2005    Shannon 1.353926e+00 -7.951435e-02 4.033538e-01
      6764    466_543722 2005    Simpson 5.879786e-01 -3.373692e-02 2.083340e-01
      6765    466_543722 2005 invSimpson 2.427058e+00 -2.795086e-01 1.919107e-01
      6766    466_543722 2005        PIE 5.885021e-01 -3.368044e-02 2.091261e-01
      6767    466_543722 2005      DomMc 7.313167e-01  1.217726e-02 7.069895e-01
      6768    466_543722 2005 expShannon 3.872600e+00 -3.401157e-01 3.694857e-01
      6769    466_547367 1992          S 2.200000e+01 -3.107248e-01 7.058731e-03
      6770    466_547367 1992          N 6.492000e+03 -2.934046e+02 1.737994e-02
      6771    466_547367 1992       maxN 5.093000e+03 -2.705054e+02 7.225383e-03
      6772    466_547367 1992    Shannon 8.128338e-01  3.800002e-02 1.262881e-03
      6773    466_547367 1992    Simpson 3.686898e-01  2.043977e-02 5.613073e-04
      6774    466_547367 1992 invSimpson 1.584007e+00  1.029781e-01 1.472486e-04
      6775    466_547367 1992        PIE 3.687466e-01  2.050141e-02 5.535413e-04
      6776    466_547367 1992      DomMc 8.830869e-01 -1.140262e-02 1.408527e-03
      6777    466_547367 1992 expShannon 2.254287e+00  1.167857e-01 5.514961e-04
      6778    466_547367 1990          S 1.700000e+01 -3.107248e-01 7.058731e-03
      6779    466_547367 1990          N 1.012000e+03 -2.934046e+02 1.737994e-02
      6780    466_547367 1990       maxN 7.580000e+02 -2.705054e+02 7.225383e-03
      6781    466_547367 1990    Shannon 1.045957e+00  3.800002e-02 1.262881e-03
      6782    466_547367 1990    Simpson 4.251062e-01  2.043977e-02 5.613073e-04
      6783    466_547367 1990 invSimpson 1.739452e+00  1.029781e-01 1.472486e-04
      6784    466_547367 1990        PIE 4.255267e-01  2.050141e-02 5.535413e-04
      6785    466_547367 1990      DomMc 8.369565e-01 -1.140262e-02 1.408527e-03
      6786    466_547367 1990 expShannon 2.846120e+00  1.167857e-01 5.514961e-04
      6787    466_547367 1991          S 1.700000e+01 -3.107248e-01 7.058731e-03
      6788    466_547367 1991          N 1.228000e+04 -2.934046e+02 1.737994e-02
      6789    466_547367 1991       maxN 1.137600e+04 -2.705054e+02 7.225383e-03
      6790    466_547367 1991    Shannon 3.757516e-01  3.800002e-02 1.262881e-03
      6791    466_547367 1991    Simpson 1.401159e-01  2.043977e-02 5.613073e-04
      6792    466_547367 1991 invSimpson 1.162947e+00  1.029781e-01 1.472486e-04
      6793    466_547367 1991        PIE 1.401273e-01  2.050141e-02 5.535413e-04
      6794    466_547367 1991      DomMc 9.621336e-01 -1.140262e-02 1.408527e-03
      6795    466_547367 1991 expShannon 1.456085e+00  1.167857e-01 5.514961e-04
      6796    466_547367 1993          S 2.000000e+01 -3.107248e-01 7.058731e-03
      6797    466_547367 1993          N 6.468000e+03 -2.934046e+02 1.737994e-02
      6798    466_547367 1993       maxN 4.978000e+03 -2.705054e+02 7.225383e-03
      6799    466_547367 1993    Shannon 7.778026e-01  3.800002e-02 1.262881e-03
      6800    466_547367 1993    Simpson 3.764373e-01  2.043977e-02 5.613073e-04
      6801    466_547367 1993 invSimpson 1.603688e+00  1.029781e-01 1.472486e-04
      6802    466_547367 1993        PIE 3.764955e-01  2.050141e-02 5.535413e-04
      6803    466_547367 1993      DomMc 9.446506e-01 -1.140262e-02 1.408527e-03
      6804    466_547367 1993 expShannon 2.176684e+00  1.167857e-01 5.514961e-04
      6805    466_547367 2002          S 2.000000e+01 -3.107248e-01 7.058731e-03
      6806    466_547367 2002          N 2.342000e+03 -2.934046e+02 1.737994e-02
      6807    466_547367 2002       maxN 2.073000e+03 -2.705054e+02 7.225383e-03
      6808    466_547367 2002    Shannon 5.286275e-01  3.800002e-02 1.262881e-03
      6809    466_547367 2002    Simpson 2.113870e-01  2.043977e-02 5.613073e-04
      6810    466_547367 2002 invSimpson 1.268049e+00  1.029781e-01 1.472486e-04
      6811    466_547367 2002        PIE 2.114773e-01  2.050141e-02 5.535413e-04
      6812    466_547367 2002      DomMc 9.538856e-01 -1.140262e-02 1.408527e-03
      6813    466_547367 2002 expShannon 1.696602e+00  1.167857e-01 5.514961e-04
      6814    466_547367 2004          S 1.500000e+01 -3.107248e-01 7.058731e-03
      6815    466_547367 2004          N 2.485000e+03 -2.934046e+02 1.737994e-02
      6816    466_547367 2004       maxN 1.181000e+03 -2.705054e+02 7.225383e-03
      6817    466_547367 2004    Shannon 1.300418e+00  3.800002e-02 1.262881e-03
      6818    466_547367 2004    Simpson 6.643421e-01  2.043977e-02 5.613073e-04
      6819    466_547367 2004 invSimpson 2.979224e+00  1.029781e-01 1.472486e-04
      6820    466_547367 2004        PIE 6.646096e-01  2.050141e-02 5.535413e-04
      6821    466_547367 2004      DomMc 7.171026e-01 -1.140262e-02 1.408527e-03
      6822    466_547367 2004 expShannon 3.670830e+00  1.167857e-01 5.514961e-04
      6823    466_547367 2003          S 1.400000e+01 -3.107248e-01 7.058731e-03
      6824    466_547367 2003          N 5.311000e+03 -2.934046e+02 1.737994e-02
      6825    466_547367 2003       maxN 3.003000e+03 -2.705054e+02 7.225383e-03
      6826    466_547367 2003    Shannon 1.044912e+00  3.800002e-02 1.262881e-03
      6827    466_547367 2003    Simpson 5.660220e-01  2.043977e-02 5.613073e-04
      6828    466_547367 2003 invSimpson 2.304264e+00  1.029781e-01 1.472486e-04
      6829    466_547367 2003        PIE 5.661286e-01  2.050141e-02 5.535413e-04
      6830    466_547367 2003      DomMc 8.960648e-01 -1.140262e-02 1.408527e-03
      6831    466_547367 2003 expShannon 2.843149e+00  1.167857e-01 5.514961e-04
      6832    466_547367 2005          S 1.600000e+01 -3.107248e-01 7.058731e-03
      6833    466_547367 2005          N 1.376000e+03 -2.934046e+02 1.737994e-02
      6834    466_547367 2005       maxN 5.400000e+02 -2.705054e+02 7.225383e-03
      6835    466_547367 2005    Shannon 1.505961e+00  3.800002e-02 1.262881e-03
      6836    466_547367 2005    Simpson 7.206662e-01  2.043977e-02 5.613073e-04
      6837    466_547367 2005 invSimpson 3.579946e+00  1.029781e-01 1.472486e-04
      6838    466_547367 2005        PIE 7.211903e-01  2.050141e-02 5.535413e-04
      6839    466_547367 2005      DomMc 7.100291e-01 -1.140262e-02 1.408527e-03
      6840    466_547367 2005 expShannon 4.508484e+00  1.167857e-01 5.514961e-04
      6841    466_547367 1994          S 2.100000e+01 -3.107248e-01 7.058731e-03
      6842    466_547367 1994          N 6.109000e+03 -2.934046e+02 1.737994e-02
      6843    466_547367 1994       maxN 5.161000e+03 -2.705054e+02 7.225383e-03
      6844    466_547367 1994    Shannon 6.407608e-01  3.800002e-02 1.262881e-03
      6845    466_547367 1994    Simpson 2.760238e-01  2.043977e-02 5.613073e-04
      6846    466_547367 1994 invSimpson 1.381261e+00  1.029781e-01 1.472486e-04
      6847    466_547367 1994        PIE 2.760690e-01  2.050141e-02 5.535413e-04
      6848    466_547367 1994      DomMc 9.422164e-01 -1.140262e-02 1.408527e-03
      6849    466_547367 1994 expShannon 1.897924e+00  1.167857e-01 5.514961e-04
      6850    466_547367 1986          S 2.000000e+01 -3.107248e-01 7.058731e-03
      6851    466_547367 1986          N 6.025000e+03 -2.934046e+02 1.737994e-02
      6852    466_547367 1986       maxN 4.792000e+03 -2.705054e+02 7.225383e-03
      6853    466_547367 1986    Shannon 8.000852e-01  3.800002e-02 1.262881e-03
      6854    466_547367 1986    Simpson 3.508897e-01  2.043977e-02 5.613073e-04
      6855    466_547367 1986 invSimpson 1.540570e+00  1.029781e-01 1.472486e-04
      6856    466_547367 1986        PIE 3.509480e-01  2.050141e-02 5.535413e-04
      6857    466_547367 1986      DomMc 9.190041e-01 -1.140262e-02 1.408527e-03
      6858    466_547367 1986 expShannon 2.225731e+00  1.167857e-01 5.514961e-04
      6859    466_547367 1996          S 1.700000e+01 -3.107248e-01 7.058731e-03
      6860    466_547367 1996          N 3.825000e+03 -2.934046e+02 1.737994e-02
      6861    466_547367 1996       maxN 2.850000e+03 -2.705054e+02 7.225383e-03
      6862    466_547367 1996    Shannon 7.610702e-01  3.800002e-02 1.262881e-03
      6863    466_547367 1996    Simpson 3.990693e-01  2.043977e-02 5.613073e-04
      6864    466_547367 1996 invSimpson 1.664086e+00  1.029781e-01 1.472486e-04
      6865    466_547367 1996        PIE 3.991737e-01  2.050141e-02 5.535413e-04
      6866    466_547367 1996      DomMc 9.581699e-01 -1.140262e-02 1.408527e-03
      6867    466_547367 1996 expShannon 2.140566e+00  1.167857e-01 5.514961e-04
      6868    466_547367 1997          S 1.700000e+01 -3.107248e-01 7.058731e-03
      6869    466_547367 1997          N 1.214100e+04 -2.934046e+02 1.737994e-02
      6870    466_547367 1997       maxN 8.046000e+03 -2.705054e+02 7.225383e-03
      6871    466_547367 1997    Shannon 1.009824e+00  3.800002e-02 1.262881e-03
      6872    466_547367 1997    Simpson 5.083663e-01  2.043977e-02 5.613073e-04
      6873    466_547367 1997 invSimpson 2.034035e+00  1.029781e-01 1.472486e-04
      6874    466_547367 1997        PIE 5.084082e-01  2.050141e-02 5.535413e-04
      6875    466_547367 1997      DomMc 8.792521e-01 -1.140262e-02 1.408527e-03
      6876    466_547367 1997 expShannon 2.745117e+00  1.167857e-01 5.514961e-04
      6877    466_547367 1995          S 1.000000e+01 -3.107248e-01 7.058731e-03
      6878    466_547367 1995          N 1.848000e+03 -2.934046e+02 1.737994e-02
      6879    466_547367 1995       maxN 1.568000e+03 -2.705054e+02 7.225383e-03
      6880    466_547367 1995    Shannon 6.056851e-01  3.800002e-02 1.262881e-03
      6881    466_547367 1995    Simpson 2.698091e-01  2.043977e-02 5.613073e-04
      6882    466_547367 1995 invSimpson 1.369505e+00  1.029781e-01 1.472486e-04
      6883    466_547367 1995        PIE 2.699551e-01  2.050141e-02 5.535413e-04
      6884    466_547367 1995      DomMc 9.448052e-01 -1.140262e-02 1.408527e-03
      6885    466_547367 1995 expShannon 1.832507e+00  1.167857e-01 5.514961e-04
      6886    466_547367 1998          S 1.500000e+01 -3.107248e-01 7.058731e-03
      6887    466_547367 1998          N 6.240000e+03 -2.934046e+02 1.737994e-02
      6888    466_547367 1998       maxN 4.294000e+03 -2.705054e+02 7.225383e-03
      6889    466_547367 1998    Shannon 9.639502e-01  3.800002e-02 1.262881e-03
      6890    466_547367 1998    Simpson 4.787876e-01  2.043977e-02 5.613073e-04
      6891    466_547367 1998 invSimpson 1.918604e+00  1.029781e-01 1.472486e-04
      6892    466_547367 1998        PIE 4.788644e-01  2.050141e-02 5.535413e-04
      6893    466_547367 1998      DomMc 8.996795e-01 -1.140262e-02 1.408527e-03
      6894    466_547367 1998 expShannon 2.622034e+00  1.167857e-01 5.514961e-04
      6895    466_547367 1999          S 1.300000e+01 -3.107248e-01 7.058731e-03
      6896    466_547367 1999          N 2.329000e+03 -2.934046e+02 1.737994e-02
      6897    466_547367 1999       maxN 1.475000e+03 -2.705054e+02 7.225383e-03
      6898    466_547367 1999    Shannon 1.022054e+00  3.800002e-02 1.262881e-03
      6899    466_547367 1999    Simpson 5.360805e-01  2.043977e-02 5.613073e-04
      6900    466_547367 1999 invSimpson 2.155547e+00  1.029781e-01 1.472486e-04
      6901    466_547367 1999        PIE 5.363108e-01  2.050141e-02 5.535413e-04
      6902    466_547367 1999      DomMc 8.501503e-01 -1.140262e-02 1.408527e-03
      6903    466_547367 1999 expShannon 2.778897e+00  1.167857e-01 5.514961e-04
      6904    466_547367 2000          S 1.400000e+01 -3.107248e-01 7.058731e-03
      6905    466_547367 2000          N 5.200000e+03 -2.934046e+02 1.737994e-02
      6906    466_547367 2000       maxN 3.938000e+03 -2.705054e+02 7.225383e-03
      6907    466_547367 2000    Shannon 7.863020e-01  3.800002e-02 1.262881e-03
      6908    466_547367 2000    Simpson 3.954805e-01  2.043977e-02 5.613073e-04
      6909    466_547367 2000 invSimpson 1.654206e+00  1.029781e-01 1.472486e-04
      6910    466_547367 2000        PIE 3.955565e-01  2.050141e-02 5.535413e-04
      6911    466_547367 2000      DomMc 9.269231e-01 -1.140262e-02 1.408527e-03
      6912    466_547367 2000 expShannon 2.195263e+00  1.167857e-01 5.514961e-04
      6913    466_547367 2001          S 1.400000e+01 -3.107248e-01 7.058731e-03
      6914    466_547367 2001          N 5.675000e+03 -2.934046e+02 1.737994e-02
      6915    466_547367 2001       maxN 4.741000e+03 -2.705054e+02 7.225383e-03
      6916    466_547367 2001    Shannon 6.252825e-01  3.800002e-02 1.262881e-03
      6917    466_547367 2001    Simpson 2.892792e-01  2.043977e-02 5.613073e-04
      6918    466_547367 2001 invSimpson 1.407022e+00  1.029781e-01 1.472486e-04
      6919    466_547367 2001        PIE 2.893301e-01  2.050141e-02 5.535413e-04
      6920    466_547367 2001      DomMc 9.406167e-01 -1.140262e-02 1.408527e-03
      6921    466_547367 2001 expShannon 1.868774e+00  1.167857e-01 5.514961e-04
      6922    466_547367 2007          S 1.400000e+01 -3.107248e-01 7.058731e-03
      6923    466_547367 2007          N 2.310000e+02 -2.934046e+02 1.737994e-02
      6924    466_547367 2007       maxN 1.180000e+02 -2.705054e+02 7.225383e-03
      6925    466_547367 2007    Shannon 1.512574e+00  3.800002e-02 1.262881e-03
      6926    466_547367 2007    Simpson 6.733007e-01  2.043977e-02 5.613073e-04
      6927    466_547367 2007 invSimpson 3.060919e+00  1.029781e-01 1.472486e-04
      6928    466_547367 2007        PIE 6.762281e-01  2.050141e-02 5.535413e-04
      6929    466_547367 2007      DomMc 6.969697e-01 -1.140262e-02 1.408527e-03
      6930    466_547367 2007 expShannon 4.538397e+00  1.167857e-01 5.514961e-04
      6931    466_547367 2008          S 1.200000e+01 -3.107248e-01 7.058731e-03
      6932    466_547367 2008          N 7.230000e+02 -2.934046e+02 1.737994e-02
      6933    466_547367 2008       maxN 3.040000e+02 -2.705054e+02 7.225383e-03
      6934    466_547367 2008    Shannon 1.444078e+00  3.800002e-02 1.262881e-03
      6935    466_547367 2008    Simpson 7.044874e-01  2.043977e-02 5.613073e-04
      6936    466_547367 2008 invSimpson 3.383951e+00  1.029781e-01 1.472486e-04
      6937    466_547367 2008        PIE 7.054632e-01  2.050141e-02 5.535413e-04
      6938    466_547367 2008      DomMc 7.275242e-01 -1.140262e-02 1.408527e-03
      6939    466_547367 2008 expShannon 4.237941e+00  1.167857e-01 5.514961e-04
      6940    466_547367 2006          S 1.200000e+01 -3.107248e-01 7.058731e-03
      6941    466_547367 2006          N 5.730000e+02 -2.934046e+02 1.737994e-02
      6942    466_547367 2006       maxN 1.930000e+02 -2.705054e+02 7.225383e-03
      6943    466_547367 2006    Shannon 1.565693e+00  3.800002e-02 1.262881e-03
      6944    466_547367 2006    Simpson 7.525683e-01  2.043977e-02 5.613073e-04
      6945    466_547367 2006 invSimpson 4.041519e+00  1.029781e-01 1.472486e-04
      6946    466_547367 2006        PIE 7.538840e-01  2.050141e-02 5.535413e-04
      6947    466_547367 2006      DomMc 6.160558e-01 -1.140262e-02 1.408527e-03
      6948    466_547367 2006 expShannon 4.785991e+00  1.167857e-01 5.514961e-04
      6949    466_565568 1999          S 1.700000e+01 -4.101166e-01 6.249617e-04
      6950    466_565568 1999          N 3.924000e+03 -4.483019e+02 1.950654e-01
      6951    466_565568 1999       maxN 3.545000e+03 -3.850962e+02 2.364113e-01
      6952    466_565568 1999    Shannon 5.011231e-01  3.095780e-02 2.128581e-01
      6953    466_565568 1999    Simpson 1.820449e-01  1.437250e-02 1.500404e-01
      6954    466_565568 1999 invSimpson 1.222561e+00  9.437613e-02 1.420568e-01
      6955    466_565568 1999        PIE 1.820913e-01  1.447599e-02 1.481572e-01
      6956    466_565568 1999      DomMc 9.311927e-01 -1.253841e-02 7.240985e-02
      6957    466_565568 1999 expShannon 1.650574e+00  9.935306e-02 3.112170e-01
      6958    466_565568 2002          S 1.700000e+01 -4.101166e-01 6.249617e-04
      6959    466_565568 2002          N 4.860000e+02 -4.483019e+02 1.950654e-01
      6960    466_565568 2002       maxN 1.840000e+02 -3.850962e+02 2.364113e-01
      6961    466_565568 2002    Shannon 2.027718e+00  3.095780e-02 2.128581e-01
      6962    466_565568 2002    Simpson 8.036377e-01  1.437250e-02 1.500404e-01
      6963    466_565568 2002 invSimpson 5.092626e+00  9.437613e-02 1.420568e-01
      6964    466_565568 2002        PIE 8.052946e-01  1.447599e-02 1.481572e-01
      6965    466_565568 2002      DomMc 4.979424e-01 -1.253841e-02 7.240985e-02
      6966    466_565568 2002 expShannon 7.596729e+00  9.935306e-02 3.112170e-01
      6967    466_565568 1988          S 2.300000e+01 -4.101166e-01 6.249617e-04
      6968    466_565568 1988          N 5.507000e+03 -4.483019e+02 1.950654e-01
      6969    466_565568 1988       maxN 4.151000e+03 -3.850962e+02 2.364113e-01
      6970    466_565568 1988    Shannon 9.452404e-01  3.095780e-02 2.128581e-01
      6971    466_565568 1988    Simpson 4.087633e-01  1.437250e-02 1.500404e-01
      6972    466_565568 1988 invSimpson 1.691370e+00  9.437613e-02 1.420568e-01
      6973    466_565568 1988        PIE 4.088375e-01  1.447599e-02 1.481572e-01
      6974    466_565568 1988      DomMc 8.997639e-01 -1.253841e-02 7.240985e-02
      6975    466_565568 1988 expShannon 2.573432e+00  9.935306e-02 3.112170e-01
      6976    466_565568 1994          S 2.200000e+01 -4.101166e-01 6.249617e-04
      6977    466_565568 1994          N 3.294500e+04 -4.483019e+02 1.950654e-01
      6978    466_565568 1994       maxN 3.053400e+04 -3.850962e+02 2.364113e-01
      6979    466_565568 1994    Shannon 3.718534e-01  3.095780e-02 2.128581e-01
      6980    466_565568 1994    Simpson 1.387888e-01  1.437250e-02 1.500404e-01
      6981    466_565568 1994 invSimpson 1.161155e+00  9.437613e-02 1.420568e-01
      6982    466_565568 1994        PIE 1.387930e-01  1.447599e-02 1.481572e-01
      6983    466_565568 1994      DomMc 9.724996e-01 -1.253841e-02 7.240985e-02
      6984    466_565568 1994 expShannon 1.450420e+00  9.935306e-02 3.112170e-01
      6985    466_565568 1997          S 2.100000e+01 -4.101166e-01 6.249617e-04
      6986    466_565568 1997          N 1.123000e+03 -4.483019e+02 1.950654e-01
      6987    466_565568 1997       maxN 4.950000e+02 -3.850962e+02 2.364113e-01
      6988    466_565568 1997    Shannon 1.967760e+00  3.095780e-02 2.128581e-01
      6989    466_565568 1997    Simpson 7.646387e-01  1.437250e-02 1.500404e-01
      6990    466_565568 1997 invSimpson 4.248786e+00  9.437613e-02 1.420568e-01
      6991    466_565568 1997        PIE 7.653202e-01  1.447599e-02 1.481572e-01
      6992    466_565568 1997      DomMc 5.796972e-01 -1.253841e-02 7.240985e-02
      6993    466_565568 1997 expShannon 7.154634e+00  9.935306e-02 3.112170e-01
      6994    466_565568 2000          S 1.700000e+01 -4.101166e-01 6.249617e-04
      6995    466_565568 2000          N 6.038000e+03 -4.483019e+02 1.950654e-01
      6996    466_565568 2000       maxN 4.081000e+03 -3.850962e+02 2.364113e-01
      6997    466_565568 2000    Shannon 9.741852e-01  3.095780e-02 2.128581e-01
      6998    466_565568 2000    Simpson 4.889869e-01  1.437250e-02 1.500404e-01
      6999    466_565568 2000 invSimpson 1.956897e+00  9.437613e-02 1.420568e-01
      7000    466_565568 2000        PIE 4.890679e-01  1.447599e-02 1.481572e-01
      7001    466_565568 2000      DomMc 9.009606e-01 -1.253841e-02 7.240985e-02
      7002    466_565568 2000 expShannon 2.649008e+00  9.935306e-02 3.112170e-01
      7003    466_565568 2006          S 1.200000e+01 -4.101166e-01 6.249617e-04
      7004    466_565568 2006          N 2.310000e+02 -4.483019e+02 1.950654e-01
      7005    466_565568 2006       maxN 6.900000e+01 -3.850962e+02 2.364113e-01
      7006    466_565568 2006    Shannon 1.852291e+00  3.095780e-02 2.128581e-01
      7007    466_565568 2006    Simpson 8.139653e-01  1.437250e-02 1.500404e-01
      7008    466_565568 2006 invSimpson 5.375340e+00  9.437613e-02 1.420568e-01
      7009    466_565568 2006        PIE 8.175042e-01  1.447599e-02 1.481572e-01
      7010    466_565568 2006      DomMc 4.935065e-01 -1.253841e-02 7.240985e-02
      7011    466_565568 2006 expShannon 6.374404e+00  9.935306e-02 3.112170e-01
      7012    466_565568 1992          S 2.500000e+01 -4.101166e-01 6.249617e-04
      7013    466_565568 1992          N 1.566000e+03 -4.483019e+02 1.950654e-01
      7014    466_565568 1992       maxN 5.360000e+02 -3.850962e+02 2.364113e-01
      7015    466_565568 1992    Shannon 2.145160e+00  3.095780e-02 2.128581e-01
      7016    466_565568 1992    Simpson 8.122116e-01  1.437250e-02 1.500404e-01
      7017    466_565568 1992 invSimpson 5.325143e+00  9.437613e-02 1.420568e-01
      7018    466_565568 1992        PIE 8.127306e-01  1.447599e-02 1.481572e-01
      7019    466_565568 1992      DomMc 5.696041e-01 -1.253841e-02 7.240985e-02
      7020    466_565568 1992 expShannon 8.543409e+00  9.935306e-02 3.112170e-01
      7021    466_565568 1993          S 2.100000e+01 -4.101166e-01 6.249617e-04
      7022    466_565568 1993          N 4.480000e+02 -4.483019e+02 1.950654e-01
      7023    466_565568 1993       maxN 1.900000e+02 -3.850962e+02 2.364113e-01
      7024    466_565568 1993    Shannon 1.794688e+00  3.095780e-02 2.128581e-01
      7025    466_565568 1993    Simpson 7.406828e-01  1.437250e-02 1.500404e-01
      7026    466_565568 1993 invSimpson 3.856281e+00  9.437613e-02 1.420568e-01
      7027    466_565568 1993        PIE 7.423398e-01  1.447599e-02 1.481572e-01
      7028    466_565568 1993      DomMc 6.696429e-01 -1.253841e-02 7.240985e-02
      7029    466_565568 1993 expShannon 6.017600e+00  9.935306e-02 3.112170e-01
      7030    466_565568 1996          S 1.600000e+01 -4.101166e-01 6.249617e-04
      7031    466_565568 1996          N 1.117700e+04 -4.483019e+02 1.950654e-01
      7032    466_565568 1996       maxN 9.915000e+03 -3.850962e+02 2.364113e-01
      7033    466_565568 1996    Shannon 4.752556e-01  3.095780e-02 2.128581e-01
      7034    466_565568 1996    Simpson 2.074937e-01  1.437250e-02 1.500404e-01
      7035    466_565568 1996 invSimpson 1.261820e+00  9.437613e-02 1.420568e-01
      7036    466_565568 1996        PIE 2.075123e-01  1.447599e-02 1.481572e-01
      7037    466_565568 1996      DomMc 9.503445e-01 -1.253841e-02 7.240985e-02
      7038    466_565568 1996 expShannon 1.608425e+00  9.935306e-02 3.112170e-01
      7039    466_565568 2001          S 1.800000e+01 -4.101166e-01 6.249617e-04
      7040    466_565568 2001          N 8.130000e+02 -4.483019e+02 1.950654e-01
      7041    466_565568 2001       maxN 4.950000e+02 -3.850962e+02 2.364113e-01
      7042    466_565568 2001    Shannon 1.372057e+00  3.095780e-02 2.128581e-01
      7043    466_565568 2001    Simpson 5.916949e-01  1.437250e-02 1.500404e-01
      7044    466_565568 2001 invSimpson 2.449149e+00  9.437613e-02 1.420568e-01
      7045    466_565568 2001        PIE 5.924236e-01  1.447599e-02 1.481572e-01
      7046    466_565568 2001      DomMc 7.736777e-01 -1.253841e-02 7.240985e-02
      7047    466_565568 2001 expShannon 3.943456e+00  9.935306e-02 3.112170e-01
      7048    466_565568 2005          S 1.600000e+01 -4.101166e-01 6.249617e-04
      7049    466_565568 2005          N 5.790000e+02 -4.483019e+02 1.950654e-01
      7050    466_565568 2005       maxN 1.830000e+02 -3.850962e+02 2.364113e-01
      7051    466_565568 2005    Shannon 1.869317e+00  3.095780e-02 2.128581e-01
      7052    466_565568 2005    Simpson 7.950579e-01  1.437250e-02 1.500404e-01
      7053    466_565568 2005 invSimpson 4.879427e+00  9.437613e-02 1.420568e-01
      7054    466_565568 2005        PIE 7.964334e-01  1.447599e-02 1.481572e-01
      7055    466_565568 2005      DomMc 5.664940e-01 -1.253841e-02 7.240985e-02
      7056    466_565568 2005 expShannon 6.483867e+00  9.935306e-02 3.112170e-01
      7057    466_565568 2007          S 1.800000e+01 -4.101166e-01 6.249617e-04
      7058    466_565568 2007          N 5.080000e+02 -4.483019e+02 1.950654e-01
      7059    466_565568 2007       maxN 2.690000e+02 -3.850962e+02 2.364113e-01
      7060    466_565568 2007    Shannon 1.554185e+00  3.095780e-02 2.128581e-01
      7061    466_565568 2007    Simpson 6.704538e-01  1.437250e-02 1.500404e-01
      7062    466_565568 2007 invSimpson 3.034476e+00  9.437613e-02 1.420568e-01
      7063    466_565568 2007        PIE 6.717762e-01  1.447599e-02 1.481572e-01
      7064    466_565568 2007      DomMc 6.830709e-01 -1.253841e-02 7.240985e-02
      7065    466_565568 2007 expShannon 4.731228e+00  9.935306e-02 3.112170e-01
      7066    466_565568 2003          S 1.900000e+01 -4.101166e-01 6.249617e-04
      7067    466_565568 2003          N 9.900000e+02 -4.483019e+02 1.950654e-01
      7068    466_565568 2003       maxN 4.120000e+02 -3.850962e+02 2.364113e-01
      7069    466_565568 2003    Shannon 1.462987e+00  3.095780e-02 2.128581e-01
      7070    466_565568 2003    Simpson 6.826875e-01  1.437250e-02 1.500404e-01
      7071    466_565568 2003 invSimpson 3.151467e+00  9.437613e-02 1.420568e-01
      7072    466_565568 2003        PIE 6.833778e-01  1.447599e-02 1.481572e-01
      7073    466_565568 2003      DomMc 7.808081e-01 -1.253841e-02 7.240985e-02
      7074    466_565568 2003 expShannon 4.318842e+00  9.935306e-02 3.112170e-01
      7075    466_565568 1990          S 1.900000e+01 -4.101166e-01 6.249617e-04
      7076    466_565568 1990          N 2.814000e+03 -4.483019e+02 1.950654e-01
      7077    466_565568 1990       maxN 1.534000e+03 -3.850962e+02 2.364113e-01
      7078    466_565568 1990    Shannon 1.212920e+00  3.095780e-02 2.128581e-01
      7079    466_565568 1990    Simpson 6.141124e-01  1.437250e-02 1.500404e-01
      7080    466_565568 1990 invSimpson 2.591428e+00  9.437613e-02 1.420568e-01
      7081    466_565568 1990        PIE 6.143307e-01  1.447599e-02 1.481572e-01
      7082    466_565568 1990      DomMc 8.031272e-01 -1.253841e-02 7.240985e-02
      7083    466_565568 1990 expShannon 3.363291e+00  9.935306e-02 3.112170e-01
      7084    466_565568 2008          S 1.400000e+01 -4.101166e-01 6.249617e-04
      7085    466_565568 2008          N 3.100000e+02 -4.483019e+02 1.950654e-01
      7086    466_565568 2008       maxN 1.180000e+02 -3.850962e+02 2.364113e-01
      7087    466_565568 2008    Shannon 1.773502e+00  3.095780e-02 2.128581e-01
      7088    466_565568 2008    Simpson 7.748179e-01  1.437250e-02 1.500404e-01
      7089    466_565568 2008 invSimpson 4.440850e+00  9.437613e-02 1.420568e-01
      7090    466_565568 2008        PIE 7.773254e-01  1.447599e-02 1.481572e-01
      7091    466_565568 2008      DomMc 5.677419e-01 -1.253841e-02 7.240985e-02
      7092    466_565568 2008 expShannon 5.891448e+00  9.935306e-02 3.112170e-01
      7093    466_562656 2007          S 1.300000e+01 -8.000000e-01 5.219086e-01
      7094    466_562656 2007          N 9.940000e+02  1.408000e+02 4.471387e-01
      7095    466_562656 2007       maxN 4.200000e+02  6.230000e+01 3.913342e-01
      7096    466_562656 2007    Shannon 1.431557e+00 -2.482440e-02 3.199721e-01
      7097    466_562656 2007    Simpson 6.941326e-01 -7.669716e-03 4.708373e-01
      7098    466_562656 2007 invSimpson 3.269391e+00 -8.228671e-02 4.518724e-01
      7099    466_562656 2007        PIE 6.948316e-01 -7.789947e-03 4.436779e-01
      7100    466_562656 2007      DomMc 7.394366e-01  1.361316e-02 3.848604e-01
      7101    466_562656 2007 expShannon 4.185210e+00 -1.080317e-01 3.303018e-01
      7102    466_562656 2004          S 1.400000e+01 -8.000000e-01 5.219086e-01
      7103    466_562656 2004          N 4.540000e+02  1.408000e+02 4.471387e-01
      7104    466_562656 2004       maxN 1.870000e+02  6.230000e+01 3.913342e-01
      7105    466_562656 2004    Shannon 1.484029e+00 -2.482440e-02 3.199721e-01
      7106    466_562656 2004    Simpson 7.058064e-01 -7.669716e-03 4.708373e-01
      7107    466_562656 2004 invSimpson 3.399123e+00 -8.228671e-02 4.518724e-01
      7108    466_562656 2004        PIE 7.073645e-01 -7.789947e-03 4.436779e-01
      7109    466_562656 2004      DomMc 6.982379e-01  1.361316e-02 3.848604e-01
      7110    466_562656 2004 expShannon 4.410679e+00 -1.080317e-01 3.303018e-01
      7111    466_562656 2005          S 1.500000e+01 -8.000000e-01 5.219086e-01
      7112    466_562656 2005          N 4.350000e+02  1.408000e+02 4.471387e-01
      7113    466_562656 2005       maxN 1.920000e+02  6.230000e+01 3.913342e-01
      7114    466_562656 2005    Shannon 1.537288e+00 -2.482440e-02 3.199721e-01
      7115    466_562656 2005    Simpson 7.101387e-01 -7.669716e-03 4.708373e-01
      7116    466_562656 2005 invSimpson 3.449926e+00 -8.228671e-02 4.518724e-01
      7117    466_562656 2005        PIE 7.117750e-01 -7.789947e-03 4.436779e-01
      7118    466_562656 2005      DomMc 6.735632e-01  1.361316e-02 3.848604e-01
      7119    466_562656 2005 expShannon 4.651956e+00 -1.080317e-01 3.303018e-01
      7120    466_562656 2006          S 1.000000e+01 -8.000000e-01 5.219086e-01
      7121    466_562656 2006          N 2.230000e+02  1.408000e+02 4.471387e-01
      7122    466_562656 2006       maxN 1.160000e+02  6.230000e+01 3.913342e-01
      7123    466_562656 2006    Shannon 1.446459e+00 -2.482440e-02 3.199721e-01
      7124    466_562656 2006    Simpson 6.684631e-01 -7.669716e-03 4.708373e-01
      7125    466_562656 2006 invSimpson 3.016255e+00 -8.228671e-02 4.518724e-01
      7126    466_562656 2006        PIE 6.714742e-01 -7.789947e-03 4.436779e-01
      7127    466_562656 2006      DomMc 6.860987e-01  1.361316e-02 3.848604e-01
      7128    466_562656 2006 expShannon 4.248045e+00 -1.080317e-01 3.303018e-01
      7129    466_559741 1995          S 1.600000e+01 -9.716599e-02 8.480712e-01
      7130    466_559741 1995          N 1.195000e+04 -6.768765e+02 2.065512e-01
      7131    466_559741 1995       maxN 8.444000e+03 -6.285911e+02 1.611559e-01
      7132    466_559741 1995    Shannon 9.527616e-01  7.619163e-02 1.344490e-01
      7133    466_559741 1995    Simpson 4.658362e-01  3.565061e-02 8.249479e-02
      7134    466_559741 1995 invSimpson 1.872085e+00  2.654719e-01 4.884091e-02
      7135    466_559741 1995        PIE 4.658751e-01  3.567813e-02 8.245216e-02
      7136    466_559741 1995      DomMc 8.613389e-01 -2.649622e-02 9.103407e-02
      7137    466_559741 1995 expShannon 2.592860e+00  2.906118e-01 1.265696e-01
      7138    466_559741 1992          S 2.200000e+01 -9.716599e-02 8.480712e-01
      7139    466_559741 1992          N 1.086500e+04 -6.768765e+02 2.065512e-01
      7140    466_559741 1992       maxN 9.120000e+03 -6.285911e+02 1.611559e-01
      7141    466_559741 1992    Shannon 7.161958e-01  7.619163e-02 1.344490e-01
      7142    466_559741 1992    Simpson 2.888658e-01  3.565061e-02 8.249479e-02
      7143    466_559741 1992 invSimpson 1.406204e+00  2.654719e-01 4.884091e-02
      7144    466_559741 1992        PIE 2.888924e-01  3.567813e-02 8.245216e-02
      7145    466_559741 1992      DomMc 9.070410e-01 -2.649622e-02 9.103407e-02
      7146    466_559741 1992 expShannon 2.046633e+00  2.906118e-01 1.265696e-01
      7147    466_559741 1994          S 2.700000e+01 -9.716599e-02 8.480712e-01
      7148    466_559741 1994          N 2.615000e+03 -6.768765e+02 2.065512e-01
      7149    466_559741 1994       maxN 1.395000e+03 -6.285911e+02 1.611559e-01
      7150    466_559741 1994    Shannon 1.621635e+00  7.619163e-02 1.344490e-01
      7151    466_559741 1994    Simpson 6.699750e-01  3.565061e-02 8.249479e-02
      7152    466_559741 1994 invSimpson 3.030074e+00  2.654719e-01 4.884091e-02
      7153    466_559741 1994        PIE 6.702313e-01  3.567813e-02 8.245216e-02
      7154    466_559741 1994      DomMc 6.841300e-01 -2.649622e-02 9.103407e-02
      7155    466_559741 1994 expShannon 5.061358e+00  2.906118e-01 1.265696e-01
      7156    466_559741 2002          S 2.300000e+01 -9.716599e-02 8.480712e-01
      7157    466_559741 2002          N 2.904000e+03 -6.768765e+02 2.065512e-01
      7158    466_559741 2002       maxN 9.200000e+02 -6.285911e+02 1.611559e-01
      7159    466_559741 2002    Shannon 1.862794e+00  7.619163e-02 1.344490e-01
      7160    466_559741 2002    Simpson 8.023463e-01  3.565061e-02 8.249479e-02
      7161    466_559741 2002 invSimpson 5.059355e+00  2.654719e-01 4.884091e-02
      7162    466_559741 2002        PIE 8.026227e-01  3.567813e-02 8.245216e-02
      7163    466_559741 2002      DomMc 5.182507e-01 -2.649622e-02 9.103407e-02
      7164    466_559741 2002 expShannon 6.441712e+00  2.906118e-01 1.265696e-01
      7165    466_559741 2003          S 2.000000e+01 -9.716599e-02 8.480712e-01
      7166    466_559741 2003          N 1.783000e+03 -6.768765e+02 2.065512e-01
      7167    466_559741 2003       maxN 6.800000e+02 -6.285911e+02 1.611559e-01
      7168    466_559741 2003    Shannon 1.654456e+00  7.619163e-02 1.344490e-01
      7169    466_559741 2003    Simpson 7.486000e-01  3.565061e-02 8.249479e-02
      7170    466_559741 2003 invSimpson 3.977725e+00  2.654719e-01 4.884091e-02
      7171    466_559741 2003        PIE 7.490201e-01  3.567813e-02 8.245216e-02
      7172    466_559741 2003      DomMc 6.371284e-01 -2.649622e-02 9.103407e-02
      7173    466_559741 2003 expShannon 5.230235e+00  2.906118e-01 1.265696e-01
      7174    466_560470 2002          S 1.500000e+01 -2.350917e-02 8.836180e-01
      7175    466_560470 2002          N 5.401000e+03 -3.288578e+02 1.335360e-01
      7176    466_560470 2002       maxN 4.121000e+03 -2.913584e+02 1.418203e-01
      7177    466_560470 2002    Shannon 7.380916e-01  2.344374e-02 3.611952e-01
      7178    466_560470 2002    Simpson 3.800063e-01  7.584412e-03 4.521994e-01
      7179    466_560470 2002 invSimpson 1.612920e+00  6.133819e-02 4.352829e-01
      7180    466_560470 2002        PIE 3.800767e-01  7.627978e-03 4.510961e-01
      7181    466_560470 2002      DomMc 9.563044e-01 -3.466556e-03 6.572489e-01
      7182    466_560470 2002 expShannon 2.091940e+00  1.000214e-01 3.539993e-01
      7183    466_560470 2008          S 1.700000e+01 -2.350917e-02 8.836180e-01
      7184    466_560470 2008          N 1.865000e+03 -3.288578e+02 1.335360e-01
      7185    466_560470 2008       maxN 1.497000e+03 -2.913584e+02 1.418203e-01
      7186    466_560470 2008    Shannon 8.520567e-01  2.344374e-02 3.611952e-01
      7187    466_560470 2008    Simpson 3.456890e-01  7.584412e-03 4.521994e-01
      7188    466_560470 2008 invSimpson 1.528325e+00  6.133819e-02 4.352829e-01
      7189    466_560470 2008        PIE 3.458744e-01  7.627978e-03 4.510961e-01
      7190    466_560470 2008      DomMc 8.900804e-01 -3.466556e-03 6.572489e-01
      7191    466_560470 2008 expShannon 2.344464e+00  1.000214e-01 3.539993e-01
      7192    466_560470 1993          S 2.300000e+01 -2.350917e-02 8.836180e-01
      7193    466_560470 1993          N 7.351000e+03 -3.288578e+02 1.335360e-01
      7194    466_560470 1993       maxN 5.755000e+03 -2.913584e+02 1.418203e-01
      7195    466_560470 1993    Shannon 8.553735e-01  2.344374e-02 3.611952e-01
      7196    466_560470 1993    Simpson 3.728754e-01  7.584412e-03 4.521994e-01
      7197    466_560470 1993 invSimpson 1.594579e+00  6.133819e-02 4.352829e-01
      7198    466_560470 1993        PIE 3.729261e-01  7.627978e-03 4.510961e-01
      7199    466_560470 1993      DomMc 8.723983e-01 -3.466556e-03 6.572489e-01
      7200    466_560470 1993 expShannon 2.352253e+00  1.000214e-01 3.539993e-01
      7201    466_560470 2001          S 2.100000e+01 -2.350917e-02 8.836180e-01
      7202    466_560470 2001          N 3.678000e+03 -3.288578e+02 1.335360e-01
      7203    466_560470 2001       maxN 2.626000e+03 -2.913584e+02 1.418203e-01
      7204    466_560470 2001    Shannon 1.018637e+00  2.344374e-02 3.611952e-01
      7205    466_560470 2001    Simpson 4.604757e-01  7.584412e-03 4.521994e-01
      7206    466_560470 2001 invSimpson 1.853485e+00  6.133819e-02 4.352829e-01
      7207    466_560470 2001        PIE 4.606009e-01  7.627978e-03 4.510961e-01
      7208    466_560470 2001      DomMc 8.703100e-01 -3.466556e-03 6.572489e-01
      7209    466_560470 2001 expShannon 2.769418e+00  1.000214e-01 3.539993e-01
      7210    466_560470 1988          S 2.200000e+01 -2.350917e-02 8.836180e-01
      7211    466_560470 1988          N 1.592000e+03 -3.288578e+02 1.335360e-01
      7212    466_560470 1988       maxN 8.630000e+02 -2.913584e+02 1.418203e-01
      7213    466_560470 1988    Shannon 1.488779e+00  2.344374e-02 3.611952e-01
      7214    466_560470 1988    Simpson 6.478427e-01  7.584412e-03 4.521994e-01
      7215    466_560470 1988 invSimpson 2.839640e+00  6.133819e-02 4.352829e-01
      7216    466_560470 1988        PIE 6.482499e-01  7.627978e-03 4.510961e-01
      7217    466_560470 1988      DomMc 7.185930e-01 -3.466556e-03 6.572489e-01
      7218    466_560470 1988 expShannon 4.431679e+00  1.000214e-01 3.539993e-01
      7219    466_560470 1998          S 1.700000e+01 -2.350917e-02 8.836180e-01
      7220    466_560470 1998          N 1.533500e+04 -3.288578e+02 1.335360e-01
      7221    466_560470 1998       maxN 1.272100e+04 -2.913584e+02 1.418203e-01
      7222    466_560470 1998    Shannon 7.326855e-01  2.344374e-02 3.611952e-01
      7223    466_560470 1998    Simpson 3.045089e-01  7.584412e-03 4.521994e-01
      7224    466_560470 1998 invSimpson 1.437833e+00  6.133819e-02 4.352829e-01
      7225    466_560470 1998        PIE 3.045288e-01  7.627978e-03 4.510961e-01
      7226    466_560470 1998      DomMc 8.915553e-01 -3.466556e-03 6.572489e-01
      7227    466_560470 1998 expShannon 2.080661e+00  1.000214e-01 3.539993e-01
      7228    466_560470 2003          S 1.600000e+01 -2.350917e-02 8.836180e-01
      7229    466_560470 2003          N 9.150000e+02 -3.288578e+02 1.335360e-01
      7230    466_560470 2003       maxN 2.170000e+02 -2.913584e+02 1.418203e-01
      7231    466_560470 2003    Shannon 1.940192e+00  2.344374e-02 3.611952e-01
      7232    466_560470 2003    Simpson 8.229281e-01  7.584412e-03 4.521994e-01
      7233    466_560470 2003 invSimpson 5.647424e+00  6.133819e-02 4.352829e-01
      7234    466_560470 2003        PIE 8.238285e-01  7.627978e-03 4.510961e-01
      7235    466_560470 2003      DomMc 4.732240e-01 -3.466556e-03 6.572489e-01
      7236    466_560470 2003 expShannon 6.960088e+00  1.000214e-01 3.539993e-01
      7237    466_560470 2004          S 2.300000e+01 -2.350917e-02 8.836180e-01
      7238    466_560470 2004          N 4.770000e+02 -3.288578e+02 1.335360e-01
      7239    466_560470 2004       maxN 1.670000e+02 -2.913584e+02 1.418203e-01
      7240    466_560470 2004    Shannon 2.134846e+00  2.344374e-02 3.611952e-01
      7241    466_560470 2004    Simpson 8.072202e-01  7.584412e-03 4.521994e-01
      7242    466_560470 2004 invSimpson 5.187265e+00  6.133819e-02 4.352829e-01
      7243    466_560470 2004        PIE 8.089160e-01  7.627978e-03 4.510961e-01
      7244    466_560470 2004      DomMc 5.765199e-01 -3.466556e-03 6.572489e-01
      7245    466_560470 2004 expShannon 8.455743e+00  1.000214e-01 3.539993e-01
      7246    466_560470 2005          S 2.200000e+01 -2.350917e-02 8.836180e-01
      7247    466_560470 2005          N 5.620000e+02 -3.288578e+02 1.335360e-01
      7248    466_560470 2005       maxN 2.120000e+02 -2.913584e+02 1.418203e-01
      7249    466_560470 2005    Shannon 1.824965e+00  2.344374e-02 3.611952e-01
      7250    466_560470 2005    Simpson 7.561011e-01  7.584412e-03 4.521994e-01
      7251    466_560470 2005 invSimpson 4.100060e+00  6.133819e-02 4.352829e-01
      7252    466_560470 2005        PIE 7.574489e-01  7.627978e-03 4.510961e-01
      7253    466_560470 2005      DomMc 6.654804e-01 -3.466556e-03 6.572489e-01
      7254    466_560470 2005 expShannon 6.202580e+00  1.000214e-01 3.539993e-01
      7255    466_560470 2007          S 1.800000e+01 -2.350917e-02 8.836180e-01
      7256    466_560470 2007          N 1.269000e+03 -3.288578e+02 1.335360e-01
      7257    466_560470 2007       maxN 8.560000e+02 -2.913584e+02 1.418203e-01
      7258    466_560470 2007    Shannon 1.248075e+00  2.344374e-02 3.611952e-01
      7259    466_560470 2007    Simpson 5.183360e-01  7.584412e-03 4.521994e-01
      7260    466_560470 2007 invSimpson 2.076136e+00  6.133819e-02 4.352829e-01
      7261    466_560470 2007        PIE 5.187447e-01  7.627978e-03 4.510961e-01
      7262    466_560470 2007      DomMc 8.219070e-01 -3.466556e-03 6.572489e-01
      7263    466_560470 2007 expShannon 3.483630e+00  1.000214e-01 3.539993e-01
      7264    466_560470 2000          S 2.100000e+01 -2.350917e-02 8.836180e-01
      7265    466_560470 2000          N 6.175000e+03 -3.288578e+02 1.335360e-01
      7266    466_560470 2000       maxN 4.467000e+03 -2.913584e+02 1.418203e-01
      7267    466_560470 2000    Shannon 9.204757e-01  2.344374e-02 3.611952e-01
      7268    466_560470 2000    Simpson 4.437721e-01  7.584412e-03 4.521994e-01
      7269    466_560470 2000 invSimpson 1.797824e+00  6.133819e-02 4.352829e-01
      7270    466_560470 2000        PIE 4.438440e-01  7.627978e-03 4.510961e-01
      7271    466_560470 2000      DomMc 8.889069e-01 -3.466556e-03 6.572489e-01
      7272    466_560470 2000 expShannon 2.510484e+00  1.000214e-01 3.539993e-01
      7273    466_560470 1990          S 2.000000e+01 -2.350917e-02 8.836180e-01
      7274    466_560470 1990          N 1.233000e+03 -3.288578e+02 1.335360e-01
      7275    466_560470 1990       maxN 4.680000e+02 -2.913584e+02 1.418203e-01
      7276    466_560470 1990    Shannon 1.660520e+00  2.344374e-02 3.611952e-01
      7277    466_560470 1990    Simpson 7.554643e-01  7.584412e-03 4.521994e-01
      7278    466_560470 1990 invSimpson 4.089382e+00  6.133819e-02 4.352829e-01
      7279    466_560470 1990        PIE 7.560775e-01  7.627978e-03 4.510961e-01
      7280    466_560470 1990      DomMc 5.766423e-01 -3.466556e-03 6.572489e-01
      7281    466_560470 1990 expShannon 5.262044e+00  1.000214e-01 3.539993e-01
      7282    466_560470 1999          S 1.600000e+01 -2.350917e-02 8.836180e-01
      7283    466_560470 1999          N 2.570000e+02 -3.288578e+02 1.335360e-01
      7284    466_560470 1999       maxN 6.800000e+01 -2.913584e+02 1.418203e-01
      7285    466_560470 1999    Shannon 2.086610e+00  2.344374e-02 3.611952e-01
      7286    466_560470 1999    Simpson 8.295962e-01  7.584412e-03 4.521994e-01
      7287    466_560470 1999 invSimpson 5.868414e+00  6.133819e-02 4.352829e-01
      7288    466_560470 1999        PIE 8.328368e-01  7.627978e-03 4.510961e-01
      7289    466_560470 1999      DomMc 5.058366e-01 -3.466556e-03 6.572489e-01
      7290    466_560470 1999 expShannon 8.057552e+00  1.000214e-01 3.539993e-01
      7291    466_560470 2006          S 1.600000e+01 -2.350917e-02 8.836180e-01
      7292    466_560470 2006          N 3.260000e+02 -3.288578e+02 1.335360e-01
      7293    466_560470 2006       maxN 9.900000e+01 -2.913584e+02 1.418203e-01
      7294    466_560470 2006    Shannon 2.061582e+00  2.344374e-02 3.611952e-01
      7295    466_560470 2006    Simpson 8.294817e-01  7.584412e-03 4.521994e-01
      7296    466_560470 2006 invSimpson 5.864474e+00  6.133819e-02 4.352829e-01
      7297    466_560470 2006        PIE 8.320340e-01  7.627978e-03 4.510961e-01
      7298    466_560470 2006      DomMc 5.030675e-01 -3.466556e-03 6.572489e-01
      7299    466_560470 2006 expShannon 7.858390e+00  1.000214e-01 3.539993e-01
      7300    466_560470 1991          S 1.000000e+01 -2.350917e-02 8.836180e-01
      7301    466_560470 1991          N 1.621600e+04 -3.288578e+02 1.335360e-01
      7302    466_560470 1991       maxN 1.520000e+04 -2.913584e+02 1.418203e-01
      7303    466_560470 1991    Shannon 3.212628e-01  2.344374e-02 3.611952e-01
      7304    466_560470 1991    Simpson 1.201089e-01  7.584412e-03 4.521994e-01
      7305    466_560470 1991 invSimpson 1.136504e+00  6.133819e-02 4.352829e-01
      7306    466_560470 1991        PIE 1.201163e-01  7.627978e-03 4.510961e-01
      7307    466_560470 1991      DomMc 9.648495e-01 -3.466556e-03 6.572489e-01
      7308    466_560470 1991 expShannon 1.378868e+00  1.000214e-01 3.539993e-01
      7309    466_545900 2002          S 1.700000e+01 -2.287308e-01 3.303918e-01
      7310    466_545900 2002          N 4.497000e+03  3.064575e+01 8.107230e-01
      7311    466_545900 2002       maxN 1.737000e+03  6.668061e+00 8.933349e-01
      7312    466_545900 2002    Shannon 1.409219e+00 -1.031646e-02 5.109073e-01
      7313    466_545900 2002    Simpson 6.869159e-01 -5.226235e-04 9.060084e-01
      7314    466_545900 2002 invSimpson 3.194030e+00 -3.852807e-02 6.401864e-01
      7315    466_545900 2002        PIE 6.870687e-01 -5.985973e-04 8.940333e-01
      7316    466_545900 2002      DomMc 7.720703e-01  4.108481e-03 6.472926e-01
      7317    466_545900 2002 expShannon 4.092758e+00 -6.935052e-02 4.294511e-01
      7318    466_545900 2001          S 1.200000e+01 -2.287308e-01 3.303918e-01
      7319    466_545900 2001          N 2.857000e+03  3.064575e+01 8.107230e-01
      7320    466_545900 2001       maxN 1.056000e+03  6.668061e+00 8.933349e-01
      7321    466_545900 2001    Shannon 1.531471e+00 -1.031646e-02 5.109073e-01
      7322    466_545900 2001    Simpson 7.251108e-01 -5.226235e-04 9.060084e-01
      7323    466_545900 2001 invSimpson 3.637829e+00 -3.852807e-02 6.401864e-01
      7324    466_545900 2001        PIE 7.253647e-01 -5.985973e-04 8.940333e-01
      7325    466_545900 2001      DomMc 7.063353e-01  4.108481e-03 6.472926e-01
      7326    466_545900 2001 expShannon 4.624977e+00 -6.935052e-02 4.294511e-01
      7327    466_545900 1992          S 1.200000e+01 -2.287308e-01 3.303918e-01
      7328    466_545900 1992          N 2.450000e+02  3.064575e+01 8.107230e-01
      7329    466_545900 1992       maxN 7.100000e+01  6.668061e+00 8.933349e-01
      7330    466_545900 1992    Shannon 2.009465e+00 -1.031646e-02 5.109073e-01
      7331    466_545900 1992    Simpson 8.352853e-01 -5.226235e-04 9.060084e-01
      7332    466_545900 1992 invSimpson 6.071103e+00 -3.852807e-02 6.401864e-01
      7333    466_545900 1992        PIE 8.387086e-01 -5.985973e-04 8.940333e-01
      7334    466_545900 1992      DomMc 4.408163e-01  4.108481e-03 6.472926e-01
      7335    466_545900 1992 expShannon 7.459327e+00 -6.935052e-02 4.294511e-01
      7336    466_545900 1994          S 1.800000e+01 -2.287308e-01 3.303918e-01
      7337    466_545900 1994          N 8.860000e+02  3.064575e+01 8.107230e-01
      7338    466_545900 1994       maxN 4.290000e+02  6.668061e+00 8.933349e-01
      7339    466_545900 1994    Shannon 1.527479e+00 -1.031646e-02 5.109073e-01
      7340    466_545900 1994    Simpson 6.917972e-01 -5.226235e-04 9.060084e-01
      7341    466_545900 1994 invSimpson 3.244616e+00 -3.852807e-02 6.401864e-01
      7342    466_545900 1994        PIE 6.925788e-01 -5.985973e-04 8.940333e-01
      7343    466_545900 1994      DomMc 7.009029e-01  4.108481e-03 6.472926e-01
      7344    466_545900 1994 expShannon 4.606549e+00 -6.935052e-02 4.294511e-01
      7345    466_545900 2005          S 1.000000e+01 -2.287308e-01 3.303918e-01
      7346    466_545900 2005          N 9.270000e+02  3.064575e+01 8.107230e-01
      7347    466_545900 2005       maxN 2.520000e+02  6.668061e+00 8.933349e-01
      7348    466_545900 2005    Shannon 1.750668e+00 -1.031646e-02 5.109073e-01
      7349    466_545900 2005    Simpson 7.951553e-01 -5.226235e-04 9.060084e-01
      7350    466_545900 2005 invSimpson 4.881747e+00 -3.852807e-02 6.401864e-01
      7351    466_545900 2005        PIE 7.960140e-01 -5.985973e-04 8.940333e-01
      7352    466_545900 2005      DomMc 5.372168e-01  4.108481e-03 6.472926e-01
      7353    466_545900 2005 expShannon 5.758447e+00 -6.935052e-02 4.294511e-01
      7354    466_545900 2008          S 1.200000e+01 -2.287308e-01 3.303918e-01
      7355    466_545900 2008          N 5.610000e+02  3.064575e+01 8.107230e-01
      7356    466_545900 2008       maxN 1.830000e+02  6.668061e+00 8.933349e-01
      7357    466_545900 2008    Shannon 1.709417e+00 -1.031646e-02 5.109073e-01
      7358    466_545900 2008    Simpson 7.759444e-01 -5.226235e-04 9.060084e-01
      7359    466_545900 2008 invSimpson 4.463178e+00 -3.852807e-02 6.401864e-01
      7360    466_545900 2008        PIE 7.773300e-01 -5.985973e-04 8.940333e-01
      7361    466_545900 2008      DomMc 6.024955e-01  4.108481e-03 6.472926e-01
      7362    466_545900 2008 expShannon 5.525739e+00 -6.935052e-02 4.294511e-01
      7363    466_545900 2004          S 1.100000e+01 -2.287308e-01 3.303918e-01
      7364    466_545900 2004          N 3.590000e+02  3.064575e+01 8.107230e-01
      7365    466_545900 2004       maxN 1.430000e+02  6.668061e+00 8.933349e-01
      7366    466_545900 2004    Shannon 1.548482e+00 -1.031646e-02 5.109073e-01
      7367    466_545900 2004    Simpson 7.348795e-01 -5.226235e-04 9.060084e-01
      7368    466_545900 2004 invSimpson 3.771869e+00 -3.852807e-02 6.401864e-01
      7369    466_545900 2004        PIE 7.369322e-01 -5.985973e-04 8.940333e-01
      7370    466_545900 2004      DomMc 6.490251e-01  4.108481e-03 6.472926e-01
      7371    466_545900 2004 expShannon 4.704322e+00 -6.935052e-02 4.294511e-01
      7372    466_545893 2002          S 2.200000e+01  4.341927e-02 7.367382e-01
      7373    466_545893 2002          N 3.340000e+03 -5.194335e+01 5.289993e-01
      7374    466_545893 2002       maxN 1.821000e+03 -5.652408e+01 4.358391e-01
      7375    466_545893 2002    Shannon 1.280855e+00  1.578589e-02 4.401195e-01
      7376    466_545893 2002    Simpson 6.165174e-01  7.850811e-03 3.835403e-01
      7377    466_545893 2002 invSimpson 2.607681e+00  3.446297e-02 5.492371e-01
      7378    466_545893 2002        PIE 6.167021e-01  7.867058e-03 3.837426e-01
      7379    466_545893 2002      DomMc 8.230539e-01 -1.850262e-03 7.565176e-01
      7380    466_545893 2002 expShannon 3.599716e+00  5.233282e-02 4.900127e-01
      7381    466_545893 1989          S 1.600000e+01  4.341927e-02 7.367382e-01
      7382    466_545893 1989          N 2.980000e+02 -5.194335e+01 5.289993e-01
      7383    466_545893 1989       maxN 1.970000e+02 -5.652408e+01 4.358391e-01
      7384    466_545893 1989    Shannon 1.324861e+00  1.578589e-02 4.401195e-01
      7385    466_545893 1989    Simpson 5.382415e-01  7.850811e-03 3.835403e-01
      7386    466_545893 1989 invSimpson 2.165634e+00  3.446297e-02 5.492371e-01
      7387    466_545893 1989        PIE 5.400538e-01  7.867058e-03 3.837426e-01
      7388    466_545893 1989      DomMc 8.020134e-01 -1.850262e-03 7.565176e-01
      7389    466_545893 1989 expShannon 3.761661e+00  5.233282e-02 4.900127e-01
      7390    466_545893 1992          S 1.500000e+01  4.341927e-02 7.367382e-01
      7391    466_545893 1992          N 7.990000e+02 -5.194335e+01 5.289993e-01
      7392    466_545893 1992       maxN 2.480000e+02 -5.652408e+01 4.358391e-01
      7393    466_545893 1992    Shannon 1.953337e+00  1.578589e-02 4.401195e-01
      7394    466_545893 1992    Simpson 8.244693e-01  7.850811e-03 3.835403e-01
      7395    466_545893 1992 invSimpson 5.697008e+00  3.446297e-02 5.492371e-01
      7396    466_545893 1992        PIE 8.255024e-01  7.867058e-03 3.837426e-01
      7397    466_545893 1992      DomMc 4.518148e-01 -1.850262e-03 7.565176e-01
      7398    466_545893 1992 expShannon 7.052180e+00  5.233282e-02 4.900127e-01
      7399    466_545893 1999          S 2.200000e+01  4.341927e-02 7.367382e-01
      7400    466_545893 1999          N 5.050000e+03 -5.194335e+01 5.289993e-01
      7401    466_545893 1999       maxN 4.317000e+03 -5.652408e+01 4.358391e-01
      7402    466_545893 1999    Shannon 6.648352e-01  1.578589e-02 4.401195e-01
      7403    466_545893 1999    Simpson 2.639394e-01  7.850811e-03 3.835403e-01
      7404    466_545893 1999 invSimpson 1.358584e+00  3.446297e-02 5.492371e-01
      7405    466_545893 1999        PIE 2.639917e-01  7.867058e-03 3.837426e-01
      7406    466_545893 1999      DomMc 9.132673e-01 -1.850262e-03 7.565176e-01
      7407    466_545893 1999 expShannon 1.944170e+00  5.233282e-02 4.900127e-01
      7408    466_545893 2000          S 2.000000e+01  4.341927e-02 7.367382e-01
      7409    466_545893 2000          N 8.820000e+02 -5.194335e+01 5.289993e-01
      7410    466_545893 2000       maxN 4.210000e+02 -5.652408e+01 4.358391e-01
      7411    466_545893 2000    Shannon 1.568846e+00  1.578589e-02 4.401195e-01
      7412    466_545893 2000    Simpson 7.024722e-01  7.850811e-03 3.835403e-01
      7413    466_545893 2000 invSimpson 3.361031e+00  3.446297e-02 5.492371e-01
      7414    466_545893 2000        PIE 7.032696e-01  7.867058e-03 3.837426e-01
      7415    466_545893 2000      DomMc 6.723356e-01 -1.850262e-03 7.565176e-01
      7416    466_545893 2000 expShannon 4.801105e+00  5.233282e-02 4.900127e-01
      7417    466_545893 2001          S 1.700000e+01  4.341927e-02 7.367382e-01
      7418    466_545893 2001          N 2.073000e+03 -5.194335e+01 5.289993e-01
      7419    466_545893 2001       maxN 1.749000e+03 -5.652408e+01 4.358391e-01
      7420    466_545893 2001    Shannon 7.261583e-01  1.578589e-02 4.401195e-01
      7421    466_545893 2001    Simpson 2.830707e-01  7.850811e-03 3.835403e-01
      7422    466_545893 2001 invSimpson 1.394838e+00  3.446297e-02 5.492371e-01
      7423    466_545893 2001        PIE 2.832073e-01  7.867058e-03 3.837426e-01
      7424    466_545893 2001      DomMc 8.938736e-01 -1.850262e-03 7.565176e-01
      7425    466_545893 2001 expShannon 2.067124e+00  5.233282e-02 4.900127e-01
      7426    466_545893 2004          S 1.800000e+01  4.341927e-02 7.367382e-01
      7427    466_545893 2004          N 1.110000e+03 -5.194335e+01 5.289993e-01
      7428    466_545893 2004       maxN 5.130000e+02 -5.652408e+01 4.358391e-01
      7429    466_545893 2004    Shannon 1.755253e+00  1.578589e-02 4.401195e-01
      7430    466_545893 2004    Simpson 7.313660e-01  7.850811e-03 3.835403e-01
      7431    466_545893 2004 invSimpson 3.722536e+00  3.446297e-02 5.492371e-01
      7432    466_545893 2004        PIE 7.320254e-01  7.867058e-03 3.837426e-01
      7433    466_545893 2004      DomMc 6.234234e-01 -1.850262e-03 7.565176e-01
      7434    466_545893 2004 expShannon 5.784910e+00  5.233282e-02 4.900127e-01
      7435    466_545893 2007          S 1.900000e+01  4.341927e-02 7.367382e-01
      7436    466_545893 2007          N 6.530000e+02 -5.194335e+01 5.289993e-01
      7437    466_545893 2007       maxN 5.030000e+02 -5.652408e+01 4.358391e-01
      7438    466_545893 2007    Shannon 1.031056e+00  1.578589e-02 4.401195e-01
      7439    466_545893 2007    Simpson 3.965207e-01  7.850811e-03 3.835403e-01
      7440    466_545893 2007 invSimpson 1.657058e+00  3.446297e-02 5.492371e-01
      7441    466_545893 2007        PIE 3.971289e-01  7.867058e-03 3.837426e-01
      7442    466_545893 2007      DomMc 8.591118e-01 -1.850262e-03 7.565176e-01
      7443    466_545893 2007 expShannon 2.804026e+00  5.233282e-02 4.900127e-01
      7444    466_545893 1993          S 1.500000e+01  4.341927e-02 7.367382e-01
      7445    466_545893 1993          N 5.668000e+03 -5.194335e+01 5.289993e-01
      7446    466_545893 1993       maxN 5.303000e+03 -5.652408e+01 4.358391e-01
      7447    466_545893 1993    Shannon 3.651052e-01  1.578589e-02 4.401195e-01
      7448    466_545893 1993    Simpson 1.238556e-01  7.850811e-03 3.835403e-01
      7449    466_545893 1993 invSimpson 1.141364e+00  3.446297e-02 5.492371e-01
      7450    466_545893 1993        PIE 1.238775e-01  7.867058e-03 3.837426e-01
      7451    466_545893 1993      DomMc 9.565984e-01 -1.850262e-03 7.565176e-01
      7452    466_545893 1993 expShannon 1.440666e+00  5.233282e-02 4.900127e-01
      7453    466_545893 1997          S 1.300000e+01  4.341927e-02 7.367382e-01
      7454    466_545893 1997          N 4.859000e+03 -5.194335e+01 5.289993e-01
      7455    466_545893 1997       maxN 3.573000e+03 -5.652408e+01 4.358391e-01
      7456    466_545893 1997    Shannon 9.206674e-01  1.578589e-02 4.401195e-01
      7457    466_545893 1997    Simpson 4.345337e-01  7.850811e-03 3.835403e-01
      7458    466_545893 1997 invSimpson 1.768452e+00  3.446297e-02 5.492371e-01
      7459    466_545893 1997        PIE 4.346231e-01  7.867058e-03 3.837426e-01
      7460    466_545893 1997      DomMc 8.608767e-01 -1.850262e-03 7.565176e-01
      7461    466_545893 1997 expShannon 2.510966e+00  5.233282e-02 4.900127e-01
      7462    466_545893 2006          S 1.900000e+01  4.341927e-02 7.367382e-01
      7463    466_545893 2006          N 2.750000e+02 -5.194335e+01 5.289993e-01
      7464    466_545893 2006       maxN 8.300000e+01 -5.652408e+01 4.358391e-01
      7465    466_545893 2006    Shannon 1.946794e+00  1.578589e-02 4.401195e-01
      7466    466_545893 2006    Simpson 7.926479e-01  7.850811e-03 3.835403e-01
      7467    466_545893 2006 invSimpson 4.822715e+00  3.446297e-02 5.492371e-01
      7468    466_545893 2006        PIE 7.955408e-01  7.867058e-03 3.837426e-01
      7469    466_545893 2006      DomMc 6.000000e-01 -1.850262e-03 7.565176e-01
      7470    466_545893 2006 expShannon 7.006189e+00  5.233282e-02 4.900127e-01
      7471    466_545893 2005          S 1.400000e+01  4.341927e-02 7.367382e-01
      7472    466_545893 2005          N 5.180000e+02 -5.194335e+01 5.289993e-01
      7473    466_545893 2005       maxN 2.580000e+02 -5.652408e+01 4.358391e-01
      7474    466_545893 2005    Shannon 1.406433e+00  1.578589e-02 4.401195e-01
      7475    466_545893 2005    Simpson 6.494089e-01  7.850811e-03 3.835403e-01
      7476    466_545893 2005 invSimpson 2.852326e+00  3.446297e-02 5.492371e-01
      7477    466_545893 2005        PIE 6.506650e-01  7.867058e-03 3.837426e-01
      7478    466_545893 2005      DomMc 8.069498e-01 -1.850262e-03 7.565176e-01
      7479    466_545893 2005 expShannon 4.081369e+00  5.233282e-02 4.900127e-01
      7480    466_545893 1988          S 2.000000e+01  4.341927e-02 7.367382e-01
      7481    466_545893 1988          N 5.300000e+02 -5.194335e+01 5.289993e-01
      7482    466_545893 1988       maxN 3.410000e+02 -5.652408e+01 4.358391e-01
      7483    466_545893 1988    Shannon 1.378482e+00  1.578589e-02 4.401195e-01
      7484    466_545893 1988    Simpson 5.598291e-01  7.850811e-03 3.835403e-01
      7485    466_545893 1988 invSimpson 2.271845e+00  3.446297e-02 5.492371e-01
      7486    466_545893 1988        PIE 5.608874e-01  7.867058e-03 3.837426e-01
      7487    466_545893 1988      DomMc 7.830189e-01 -1.850262e-03 7.565176e-01
      7488    466_545893 1988 expShannon 3.968874e+00  5.233282e-02 4.900127e-01
      7489    466_545893 2003          S 2.000000e+01  4.341927e-02 7.367382e-01
      7490    466_545893 2003          N 2.572000e+03 -5.194335e+01 5.289993e-01
      7491    466_545893 2003       maxN 1.511000e+03 -5.652408e+01 4.358391e-01
      7492    466_545893 2003    Shannon 1.395813e+00  1.578589e-02 4.401195e-01
      7493    466_545893 2003    Simpson 6.076012e-01  7.850811e-03 3.835403e-01
      7494    466_545893 2003 invSimpson 2.548428e+00  3.446297e-02 5.492371e-01
      7495    466_545893 2003        PIE 6.078376e-01  7.867058e-03 3.837426e-01
      7496    466_545893 2003      DomMc 7.725505e-01 -1.850262e-03 7.565176e-01
      7497    466_545893 2003 expShannon 4.038254e+00  5.233282e-02 4.900127e-01
      7498    466_545893 2008          S 1.400000e+01  4.341927e-02 7.367382e-01
      7499    466_545893 2008          N 4.210000e+02 -5.194335e+01 5.289993e-01
      7500    466_545893 2008       maxN 1.730000e+02 -5.652408e+01 4.358391e-01
      7501    466_545893 2008    Shannon 1.728316e+00  1.578589e-02 4.401195e-01
      7502    466_545893 2008    Simpson 7.434510e-01  7.850811e-03 3.835403e-01
      7503    466_545893 2008 invSimpson 3.897891e+00  3.446297e-02 5.492371e-01
      7504    466_545893 2008        PIE 7.452211e-01  7.867058e-03 3.837426e-01
      7505    466_545893 2008      DomMc 6.674584e-01 -1.850262e-03 7.565176e-01
      7506    466_545893 2008 expShannon 5.631161e+00  5.233282e-02 4.900127e-01
      7507    466_548775 1986          S 1.200000e+01 -2.159091e-02 7.061016e-01
      7508    466_548775 1986          N 3.377000e+03 -1.037568e+02 2.472913e-01
      7509    466_548775 1986       maxN 2.504000e+03 -8.163295e+01 2.672009e-01
      7510    466_548775 1986    Shannon 8.115917e-01  1.275245e-02 1.340813e-01
      7511    466_548775 1986    Simpson 4.107879e-01  8.621446e-03 9.411369e-02
      7512    466_548775 1986 invSimpson 1.697182e+00  2.718464e-02 1.049561e-01
      7513    466_548775 1986        PIE 4.109096e-01  8.648712e-03 9.351385e-02
      7514    466_548775 1986      DomMc 9.375185e-01 -1.187676e-03 4.277290e-01
      7515    466_548775 1986 expShannon 2.251489e+00  2.904043e-02 1.343124e-01
      7516    466_548775 1992          S 1.300000e+01 -2.159091e-02 7.061016e-01
      7517    466_548775 1992          N 6.699000e+03 -1.037568e+02 2.472913e-01
      7518    466_548775 1992       maxN 2.965000e+03 -8.163295e+01 2.672009e-01
      7519    466_548775 1992    Shannon 1.174417e+00  1.275245e-02 1.340813e-01
      7520    466_548775 1992    Simpson 6.214616e-01  8.621446e-03 9.411369e-02
      7521    466_548775 1992 invSimpson 2.641740e+00  2.718464e-02 1.049561e-01
      7522    466_548775 1992        PIE 6.215544e-01  8.648712e-03 9.351385e-02
      7523    466_548775 1992      DomMc 8.607255e-01 -1.187676e-03 4.277290e-01
      7524    466_548775 1992 expShannon 3.236257e+00  2.904043e-02 1.343124e-01
      7525    466_548775 1997          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7526    466_548775 1997          N 1.554000e+03 -1.037568e+02 2.472913e-01
      7527    466_548775 1997       maxN 1.136000e+03 -8.163295e+01 2.672009e-01
      7528    466_548775 1997    Shannon 8.366915e-01  1.275245e-02 1.340813e-01
      7529    466_548775 1997    Simpson 4.270691e-01  8.621446e-03 9.411369e-02
      7530    466_548775 1997 invSimpson 1.745411e+00  2.718464e-02 1.049561e-01
      7531    466_548775 1997        PIE 4.273441e-01  8.648712e-03 9.351385e-02
      7532    466_548775 1997      DomMc 9.189189e-01 -1.187676e-03 4.277290e-01
      7533    466_548775 1997 expShannon 2.308716e+00  2.904043e-02 1.343124e-01
      7534    466_548775 2007          S 1.300000e+01 -2.159091e-02 7.061016e-01
      7535    466_548775 2007          N 2.116000e+03 -1.037568e+02 2.472913e-01
      7536    466_548775 2007       maxN 1.797000e+03 -8.163295e+01 2.672009e-01
      7537    466_548775 2007    Shannon 5.659867e-01  1.275245e-02 1.340813e-01
      7538    466_548775 2007    Simpson 2.667425e-01  8.621446e-03 9.411369e-02
      7539    466_548775 2007 invSimpson 1.363777e+00  2.718464e-02 1.049561e-01
      7540    466_548775 2007        PIE 2.668687e-01  8.648712e-03 9.351385e-02
      7541    466_548775 2007      DomMc 9.532136e-01 -1.187676e-03 4.277290e-01
      7542    466_548775 2007 expShannon 1.761185e+00  2.904043e-02 1.343124e-01
      7543    466_548775 2008          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7544    466_548775 2008          N 4.390000e+02 -1.037568e+02 2.472913e-01
      7545    466_548775 2008       maxN 2.130000e+02 -8.163295e+01 2.672009e-01
      7546    466_548775 2008    Shannon 1.216067e+00  1.275245e-02 1.340813e-01
      7547    466_548775 2008    Simpson 6.403765e-01  8.621446e-03 9.411369e-02
      7548    466_548775 2008 invSimpson 2.780686e+00  2.718464e-02 1.049561e-01
      7549    466_548775 2008        PIE 6.418385e-01  8.648712e-03 9.351385e-02
      7550    466_548775 2008      DomMc 8.063781e-01 -1.187676e-03 4.277290e-01
      7551    466_548775 2008 expShannon 3.373894e+00  2.904043e-02 1.343124e-01
      7552    466_548775 1988          S 1.200000e+01 -2.159091e-02 7.061016e-01
      7553    466_548775 1988          N 1.013000e+03 -1.037568e+02 2.472913e-01
      7554    466_548775 1988       maxN 8.550000e+02 -8.163295e+01 2.672009e-01
      7555    466_548775 1988    Shannon 6.810220e-01  1.275245e-02 1.340813e-01
      7556    466_548775 1988    Simpson 2.808056e-01  8.621446e-03 9.411369e-02
      7557    466_548775 1988 invSimpson 1.390445e+00  2.718464e-02 1.049561e-01
      7558    466_548775 1988        PIE 2.810831e-01  8.648712e-03 9.351385e-02
      7559    466_548775 1988      DomMc 9.072063e-01 -1.187676e-03 4.277290e-01
      7560    466_548775 1988 expShannon 1.975896e+00  2.904043e-02 1.343124e-01
      7561    466_548775 2002          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7562    466_548775 2002          N 1.459000e+03 -1.037568e+02 2.472913e-01
      7563    466_548775 2002       maxN 1.220000e+03 -8.163295e+01 2.672009e-01
      7564    466_548775 2002    Shannon 6.009621e-01  1.275245e-02 1.340813e-01
      7565    466_548775 2002    Simpson 2.857666e-01  8.621446e-03 9.411369e-02
      7566    466_548775 2002 invSimpson 1.400103e+00  2.718464e-02 1.049561e-01
      7567    466_548775 2002        PIE 2.859626e-01  8.648712e-03 9.351385e-02
      7568    466_548775 2002      DomMc 9.561343e-01 -1.187676e-03 4.277290e-01
      7569    466_548775 2002 expShannon 1.823873e+00  2.904043e-02 1.343124e-01
      7570    466_548775 2006          S 1.100000e+01 -2.159091e-02 7.061016e-01
      7571    466_548775 2006          N 1.363000e+03 -1.037568e+02 2.472913e-01
      7572    466_548775 2006       maxN 7.610000e+02 -8.163295e+01 2.672009e-01
      7573    466_548775 2006    Shannon 1.094314e+00  1.275245e-02 1.340813e-01
      7574    466_548775 2006    Simpson 5.744622e-01  8.621446e-03 9.411369e-02
      7575    466_548775 2006 invSimpson 2.349967e+00  2.718464e-02 1.049561e-01
      7576    466_548775 2006        PIE 5.748839e-01  8.648712e-03 9.351385e-02
      7577    466_548775 2006      DomMc 8.906823e-01 -1.187676e-03 4.277290e-01
      7578    466_548775 2006 expShannon 2.987132e+00  2.904043e-02 1.343124e-01
      7579    466_548775 1996          S 9.000000e+00 -2.159091e-02 7.061016e-01
      7580    466_548775 1996          N 6.059000e+03 -1.037568e+02 2.472913e-01
      7581    466_548775 1996       maxN 4.600000e+03 -8.163295e+01 2.672009e-01
      7582    466_548775 1996    Shannon 8.121614e-01  1.275245e-02 1.340813e-01
      7583    466_548775 1996    Simpson 4.008239e-01  8.621446e-03 9.411369e-02
      7584    466_548775 1996 invSimpson 1.668958e+00  2.718464e-02 1.049561e-01
      7585    466_548775 1996        PIE 4.008900e-01  8.648712e-03 9.351385e-02
      7586    466_548775 1996      DomMc 8.656544e-01 -1.187676e-03 4.277290e-01
      7587    466_548775 1996 expShannon 2.252772e+00  2.904043e-02 1.343124e-01
      7588    466_548775 1995          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7589    466_548775 1995          N 2.357000e+03 -1.037568e+02 2.472913e-01
      7590    466_548775 1995       maxN 1.314000e+03 -8.163295e+01 2.672009e-01
      7591    466_548775 1995    Shannon 1.045403e+00  1.275245e-02 1.340813e-01
      7592    466_548775 1995    Simpson 5.737437e-01  8.621446e-03 9.411369e-02
      7593    466_548775 1995 invSimpson 2.346007e+00  2.718464e-02 1.049561e-01
      7594    466_548775 1995        PIE 5.739872e-01  8.648712e-03 9.351385e-02
      7595    466_548775 1995      DomMc 8.862961e-01 -1.187676e-03 4.277290e-01
      7596    466_548775 1995 expShannon 2.844543e+00  2.904043e-02 1.343124e-01
      7597    466_548775 2003          S 9.000000e+00 -2.159091e-02 7.061016e-01
      7598    466_548775 2003          N 2.647000e+03 -1.037568e+02 2.472913e-01
      7599    466_548775 2003       maxN 2.082000e+03 -8.163295e+01 2.672009e-01
      7600    466_548775 2003    Shannon 7.251004e-01  1.275245e-02 1.340813e-01
      7601    466_548775 2003    Simpson 3.565068e-01  8.621446e-03 9.411369e-02
      7602    466_548775 2003 invSimpson 1.554018e+00  2.718464e-02 1.049561e-01
      7603    466_548775 2003        PIE 3.566416e-01  8.648712e-03 9.351385e-02
      7604    466_548775 2003      DomMc 9.406876e-01 -1.187676e-03 4.277290e-01
      7605    466_548775 2003 expShannon 2.064938e+00  2.904043e-02 1.343124e-01
      7606    466_548775 2005          S 9.000000e+00 -2.159091e-02 7.061016e-01
      7607    466_548775 2005          N 1.059000e+03 -1.037568e+02 2.472913e-01
      7608    466_548775 2005       maxN 6.070000e+02 -8.163295e+01 2.672009e-01
      7609    466_548775 2005    Shannon 9.659860e-01  1.275245e-02 1.340813e-01
      7610    466_548775 2005    Simpson 5.434920e-01  8.621446e-03 9.411369e-02
      7611    466_548775 2005 invSimpson 2.190542e+00  2.718464e-02 1.049561e-01
      7612    466_548775 2005        PIE 5.440057e-01  8.648712e-03 9.351385e-02
      7613    466_548775 2005      DomMc 9.282342e-01 -1.187676e-03 4.277290e-01
      7614    466_548775 2005 expShannon 2.627377e+00  2.904043e-02 1.343124e-01
      7615    466_548775 1987          S 9.000000e+00 -2.159091e-02 7.061016e-01
      7616    466_548775 1987          N 1.187000e+03 -1.037568e+02 2.472913e-01
      7617    466_548775 1987       maxN 1.047000e+03 -8.163295e+01 2.672009e-01
      7618    466_548775 1987    Shannon 4.908635e-01  1.275245e-02 1.340813e-01
      7619    466_548775 1987    Simpson 2.162134e-01  8.621446e-03 9.411369e-02
      7620    466_548775 1987 invSimpson 1.275858e+00  2.718464e-02 1.049561e-01
      7621    466_548775 1987        PIE 2.163957e-01  8.648712e-03 9.351385e-02
      7622    466_548775 1987      DomMc 9.435552e-01 -1.187676e-03 4.277290e-01
      7623    466_548775 1987 expShannon 1.633726e+00  2.904043e-02 1.343124e-01
      7624    466_548775 1990          S 8.000000e+00 -2.159091e-02 7.061016e-01
      7625    466_548775 1990          N 6.490000e+02 -1.037568e+02 2.472913e-01
      7626    466_548775 1990       maxN 5.290000e+02 -8.163295e+01 2.672009e-01
      7627    466_548775 1990    Shannon 6.484184e-01  1.275245e-02 1.340813e-01
      7628    466_548775 1990    Simpson 3.154408e-01  8.621446e-03 9.411369e-02
      7629    466_548775 1990 invSimpson 1.460794e+00  2.718464e-02 1.049561e-01
      7630    466_548775 1990        PIE 3.159276e-01  8.648712e-03 9.351385e-02
      7631    466_548775 1990      DomMc 9.553159e-01 -1.187676e-03 4.277290e-01
      7632    466_548775 1990 expShannon 1.912514e+00  2.904043e-02 1.343124e-01
      7633    466_548775 1991          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7634    466_548775 1991          N 7.105000e+03 -1.037568e+02 2.472913e-01
      7635    466_548775 1991       maxN 6.756000e+03 -8.163295e+01 2.672009e-01
      7636    466_548775 1991    Shannon 2.790886e-01  1.275245e-02 1.340813e-01
      7637    466_548775 1991    Simpson 9.530876e-02  8.621446e-03 9.411369e-02
      7638    466_548775 1991 invSimpson 1.105349e+00  2.718464e-02 1.049561e-01
      7639    466_548775 1991        PIE 9.532218e-02  8.648712e-03 9.351385e-02
      7640    466_548775 1991      DomMc 9.643913e-01 -1.187676e-03 4.277290e-01
      7641    466_548775 1991 expShannon 1.321925e+00  2.904043e-02 1.343124e-01
      7642    466_548775 1993          S 1.000000e+01 -2.159091e-02 7.061016e-01
      7643    466_548775 1993          N 6.922000e+03 -1.037568e+02 2.472913e-01
      7644    466_548775 1993       maxN 5.822000e+03 -8.163295e+01 2.672009e-01
      7645    466_548775 1993    Shannon 6.109329e-01  1.275245e-02 1.340813e-01
      7646    466_548775 1993    Simpson 2.819399e-01  8.621446e-03 9.411369e-02
      7647    466_548775 1993 invSimpson 1.392641e+00  2.718464e-02 1.049561e-01
      7648    466_548775 1993        PIE 2.819806e-01  8.648712e-03 9.351385e-02
      7649    466_548775 1993      DomMc 9.260329e-01 -1.187676e-03 4.277290e-01
      7650    466_548775 1993 expShannon 1.842149e+00  2.904043e-02 1.343124e-01
      7651    466_548775 1999          S 9.000000e+00 -2.159091e-02 7.061016e-01
      7652    466_548775 1999          N 7.490000e+03 -1.037568e+02 2.472913e-01
      7653    466_548775 1999       maxN 6.067000e+03 -8.163295e+01 2.672009e-01
      7654    466_548775 1999    Shannon 6.061713e-01  1.275245e-02 1.340813e-01
      7655    466_548775 1999    Simpson 3.193919e-01  8.621446e-03 9.411369e-02
      7656    466_548775 1999 invSimpson 1.469274e+00  2.718464e-02 1.049561e-01
      7657    466_548775 1999        PIE 3.194346e-01  8.648712e-03 9.351385e-02
      7658    466_548775 1999      DomMc 9.636849e-01 -1.187676e-03 4.277290e-01
      7659    466_548775 1999 expShannon 1.833398e+00  2.904043e-02 1.343124e-01
      7660    466_548775 2001          S 7.000000e+00 -2.159091e-02 7.061016e-01
      7661    466_548775 2001          N 2.680000e+02 -1.037568e+02 2.472913e-01
      7662    466_548775 2001       maxN 1.770000e+02 -8.163295e+01 2.672009e-01
      7663    466_548775 2001    Shannon 8.596670e-01  1.275245e-02 1.340813e-01
      7664    466_548775 2001    Simpson 4.804801e-01  8.621446e-03 9.411369e-02
      7665    466_548775 2001 invSimpson 1.924854e+00  2.718464e-02 1.049561e-01
      7666    466_548775 2001        PIE 4.822796e-01  8.648712e-03 9.351385e-02
      7667    466_548775 2001      DomMc 9.477612e-01 -1.187676e-03 4.277290e-01
      7668    466_548775 2001 expShannon 2.362374e+00  2.904043e-02 1.343124e-01
      7669    466_552414 1989          S 1.100000e+01 -3.224073e-02 5.905851e-01
      7670    466_552414 1989          N 1.347000e+03 -1.885909e+02 7.255850e-03
      7671    466_552414 1989       maxN 5.280000e+02 -1.789796e+02 3.327334e-03
      7672    466_552414 1989    Shannon 1.570059e+00  1.237863e-02 2.594073e-01
      7673    466_552414 1989    Simpson 7.304274e-01  9.855409e-03 8.525569e-02
      7674    466_552414 1989 invSimpson 3.709575e+00  1.411651e-02 5.220728e-01
      7675    466_552414 1989        PIE 7.309700e-01  9.899262e-03 8.409336e-02
      7676    466_552414 1989      DomMc 6.896808e-01  1.677055e-03 5.221368e-01
      7677    466_552414 1989 expShannon 4.806934e+00  1.377829e-02 6.312238e-01
      7678    466_552414 1991          S 1.000000e+01 -3.224073e-02 5.905851e-01
      7679    466_552414 1991          N 3.696000e+03 -1.885909e+02 7.255850e-03
      7680    466_552414 1991       maxN 3.245000e+03 -1.789796e+02 3.327334e-03
      7681    466_552414 1991    Shannon 4.902522e-01  1.237863e-02 2.594073e-01
      7682    466_552414 1991    Simpson 2.206675e-01  9.855409e-03 8.525569e-02
      7683    466_552414 1991 invSimpson 1.283149e+00  1.411651e-02 5.220728e-01
      7684    466_552414 1991        PIE 2.207272e-01  9.899262e-03 8.409336e-02
      7685    466_552414 1991      DomMc 9.688853e-01  1.677055e-03 5.221368e-01
      7686    466_552414 1991 expShannon 1.632728e+00  1.377829e-02 6.312238e-01
      7687    466_552414 1996          S 1.500000e+01 -3.224073e-02 5.905851e-01
      7688    466_552414 1996          N 3.612000e+03 -1.885909e+02 7.255850e-03
      7689    466_552414 1996       maxN 1.894000e+03 -1.789796e+02 3.327334e-03
      7690    466_552414 1996    Shannon 1.208719e+00  1.237863e-02 2.594073e-01
      7691    466_552414 1996    Simpson 6.176888e-01  9.855409e-03 8.525569e-02
      7692    466_552414 1996 invSimpson 2.615670e+00  1.411651e-02 5.220728e-01
      7693    466_552414 1996        PIE 6.178598e-01  9.899262e-03 8.409336e-02
      7694    466_552414 1996      DomMc 8.347176e-01  1.677055e-03 5.221368e-01
      7695    466_552414 1996 expShannon 3.349191e+00  1.377829e-02 6.312238e-01
      7696    466_552414 2005          S 1.000000e+01 -3.224073e-02 5.905851e-01
      7697    466_552414 2005          N 1.013000e+03 -1.885909e+02 7.255850e-03
      7698    466_552414 2005       maxN 8.500000e+02 -1.789796e+02 3.327334e-03
      7699    466_552414 2005    Shannon 6.386126e-01  1.237863e-02 2.594073e-01
      7700    466_552414 2005    Simpson 2.842066e-01  9.855409e-03 8.525569e-02
      7701    466_552414 2005 invSimpson 1.397051e+00  1.411651e-02 5.220728e-01
      7702    466_552414 2005        PIE 2.844874e-01  9.899262e-03 8.409336e-02
      7703    466_552414 2005      DomMc 9.437315e-01  1.677055e-03 5.221368e-01
      7704    466_552414 2005 expShannon 1.893851e+00  1.377829e-02 6.312238e-01
      7705    466_552414 2006          S 1.100000e+01 -3.224073e-02 5.905851e-01
      7706    466_552414 2006          N 1.718000e+03 -1.885909e+02 7.255850e-03
      7707    466_552414 2006       maxN 9.780000e+02 -1.789796e+02 3.327334e-03
      7708    466_552414 2006    Shannon 9.892348e-01  1.237863e-02 2.594073e-01
      7709    466_552414 2006    Simpson 5.520280e-01  9.855409e-03 8.525569e-02
      7710    466_552414 2006 invSimpson 2.232283e+00  1.411651e-02 5.220728e-01
      7711    466_552414 2006        PIE 5.523495e-01  9.899262e-03 8.409336e-02
      7712    466_552414 2006      DomMc 9.173458e-01  1.677055e-03 5.221368e-01
      7713    466_552414 2006 expShannon 2.689176e+00  1.377829e-02 6.312238e-01
      7714    466_552414 1993          S 9.000000e+00 -3.224073e-02 5.905851e-01
      7715    466_552414 1993          N 3.496000e+03 -1.885909e+02 7.255850e-03
      7716    466_552414 1993       maxN 2.605000e+03 -1.789796e+02 3.327334e-03
      7717    466_552414 1993    Shannon 8.526741e-01  1.237863e-02 2.594073e-01
      7718    466_552414 1993    Simpson 4.152533e-01  9.855409e-03 8.525569e-02
      7719    466_552414 1993 invSimpson 1.710142e+00  1.411651e-02 5.220728e-01
      7720    466_552414 1993        PIE 4.153721e-01  9.899262e-03 8.409336e-02
      7721    466_552414 1993      DomMc 9.056064e-01  1.677055e-03 5.221368e-01
      7722    466_552414 1993 expShannon 2.345912e+00  1.377829e-02 6.312238e-01
      7723    466_552414 1995          S 1.100000e+01 -3.224073e-02 5.905851e-01
      7724    466_552414 1995          N 6.782000e+03 -1.885909e+02 7.255850e-03
      7725    466_552414 1995       maxN 3.653000e+03 -1.789796e+02 3.327334e-03
      7726    466_552414 1995    Shannon 1.031722e+00  1.237863e-02 2.594073e-01
      7727    466_552414 1995    Simpson 5.827481e-01  9.855409e-03 8.525569e-02
      7728    466_552414 1995 invSimpson 2.396634e+00  1.411651e-02 5.220728e-01
      7729    466_552414 1995        PIE 5.828340e-01  9.899262e-03 8.409336e-02
      7730    466_552414 1995      DomMc 8.814509e-01  1.677055e-03 5.221368e-01
      7731    466_552414 1995 expShannon 2.805894e+00  1.377829e-02 6.312238e-01
      7732    466_552414 1999          S 9.000000e+00 -3.224073e-02 5.905851e-01
      7733    466_552414 1999          N 2.058000e+03 -1.885909e+02 7.255850e-03
      7734    466_552414 1999       maxN 1.217000e+03 -1.789796e+02 3.327334e-03
      7735    466_552414 1999    Shannon 8.023864e-01  1.237863e-02 2.594073e-01
      7736    466_552414 1999    Simpson 5.020334e-01  9.855409e-03 8.525569e-02
      7737    466_552414 1999 invSimpson 2.008167e+00  1.411651e-02 5.220728e-01
      7738    466_552414 1999        PIE 5.022774e-01  9.899262e-03 8.409336e-02
      7739    466_552414 1999      DomMc 9.761905e-01  1.677055e-03 5.221368e-01
      7740    466_552414 1999 expShannon 2.230858e+00  1.377829e-02 6.312238e-01
      7741    466_552414 2001          S 9.000000e+00 -3.224073e-02 5.905851e-01
      7742    466_552414 2001          N 3.782000e+03 -1.885909e+02 7.255850e-03
      7743    466_552414 2001       maxN 2.621000e+03 -1.789796e+02 3.327334e-03
      7744    466_552414 2001    Shannon 7.458288e-01  1.237863e-02 2.594073e-01
      7745    466_552414 2001    Simpson 4.412306e-01  9.855409e-03 8.525569e-02
      7746    466_552414 2001 invSimpson 1.789647e+00  1.411651e-02 5.220728e-01
      7747    466_552414 2001        PIE 4.413473e-01  9.899262e-03 8.409336e-02
      7748    466_552414 2001      DomMc 9.727657e-01  1.677055e-03 5.221368e-01
      7749    466_552414 2001 expShannon 2.108188e+00  1.377829e-02 6.312238e-01
      7750    466_552414 2008          S 8.000000e+00 -3.224073e-02 5.905851e-01
      7751    466_552414 2008          N 1.890000e+02 -1.885909e+02 7.255850e-03
      7752    466_552414 2008       maxN 1.220000e+02 -1.789796e+02 3.327334e-03
      7753    466_552414 2008    Shannon 9.806772e-01  1.237863e-02 2.594073e-01
      7754    466_552414 2008    Simpson 5.088323e-01  9.855409e-03 8.525569e-02
      7755    466_552414 2008 invSimpson 2.035965e+00  1.411651e-02 5.220728e-01
      7756    466_552414 2008        PIE 5.115389e-01  9.899262e-03 8.409336e-02
      7757    466_552414 2008      DomMc 9.153439e-01  1.677055e-03 5.221368e-01
      7758    466_552414 2008 expShannon 2.666261e+00  1.377829e-02 6.312238e-01
      7759    466_552414 2007          S 1.100000e+01 -3.224073e-02 5.905851e-01
      7760    466_552414 2007          N 7.830000e+02 -1.885909e+02 7.255850e-03
      7761    466_552414 2007       maxN 4.060000e+02 -1.789796e+02 3.327334e-03
      7762    466_552414 2007    Shannon 1.045199e+00  1.237863e-02 2.594073e-01
      7763    466_552414 2007    Simpson 5.678034e-01  9.855409e-03 8.525569e-02
      7764    466_552414 2007 invSimpson 2.313762e+00  1.411651e-02 5.220728e-01
      7765    466_552414 2007        PIE 5.685295e-01  9.899262e-03 8.409336e-02
      7766    466_552414 2007      DomMc 9.208174e-01  1.677055e-03 5.221368e-01
      7767    466_552414 2007 expShannon 2.843963e+00  1.377829e-02 6.312238e-01
      7768    466_552414 2003          S 1.000000e+01 -3.224073e-02 5.905851e-01
      7769    466_552414 2003          N 3.297000e+03 -1.885909e+02 7.255850e-03
      7770    466_552414 2003       maxN 1.937000e+03 -1.789796e+02 3.327334e-03
      7771    466_552414 2003    Shannon 8.234946e-01  1.237863e-02 2.594073e-01
      7772    466_552414 2003    Simpson 5.060725e-01  9.855409e-03 8.525569e-02
      7773    466_552414 2003 invSimpson 2.024589e+00  1.411651e-02 5.220728e-01
      7774    466_552414 2003        PIE 5.062261e-01  9.899262e-03 8.409336e-02
      7775    466_552414 2003      DomMc 9.730058e-01  1.677055e-03 5.221368e-01
      7776    466_552414 2003 expShannon 2.278448e+00  1.377829e-02 6.312238e-01
      7777    466_552414 1986          S 8.000000e+00 -3.224073e-02 5.905851e-01
      7778    466_552414 1986          N 8.207000e+03 -1.885909e+02 7.255850e-03
      7779    466_552414 1986       maxN 7.995000e+03 -1.789796e+02 3.327334e-03
      7780    466_552414 1986    Shannon 1.572414e-01  1.237863e-02 2.594073e-01
      7781    466_552414 1986    Simpson 5.080187e-02  9.855409e-03 8.525569e-02
      7782    466_552414 1986 invSimpson 1.053521e+00  1.411651e-02 5.220728e-01
      7783    466_552414 1986        PIE 5.080806e-02  9.899262e-03 8.409336e-02
      7784    466_552414 1986      DomMc 9.848909e-01  1.677055e-03 5.221368e-01
      7785    466_552414 1986 expShannon 1.170278e+00  1.377829e-02 6.312238e-01
      7786    466_552414 1988          S 1.100000e+01 -3.224073e-02 5.905851e-01
      7787    466_552414 1988          N 5.388000e+03 -1.885909e+02 7.255850e-03
      7788    466_552414 1988       maxN 4.581000e+03 -1.789796e+02 3.327334e-03
      7789    466_552414 1988    Shannon 5.778955e-01  1.237863e-02 2.594073e-01
      7790    466_552414 1988    Simpson 2.657756e-01  9.855409e-03 8.525569e-02
      7791    466_552414 1988 invSimpson 1.361981e+00  1.411651e-02 5.220728e-01
      7792    466_552414 1988        PIE 2.658249e-01  9.899262e-03 8.409336e-02
      7793    466_552414 1988      DomMc 9.519302e-01  1.677055e-03 5.221368e-01
      7794    466_552414 1988 expShannon 1.782284e+00  1.377829e-02 6.312238e-01
      7795    466_552414 1990          S 1.200000e+01 -3.224073e-02 5.905851e-01
      7796    466_552414 1990          N 2.644000e+03 -1.885909e+02 7.255850e-03
      7797    466_552414 1990       maxN 2.177000e+03 -1.789796e+02 3.327334e-03
      7798    466_552414 1990    Shannon 5.908571e-01  1.237863e-02 2.594073e-01
      7799    466_552414 1990    Simpson 2.993874e-01  9.855409e-03 8.525569e-02
      7800    466_552414 1990 invSimpson 1.427322e+00  1.411651e-02 5.220728e-01
      7801    466_552414 1990        PIE 2.995006e-01  9.899262e-03 8.409336e-02
      7802    466_552414 1990      DomMc 9.735250e-01  1.677055e-03 5.221368e-01
      7803    466_552414 1990 expShannon 1.805535e+00  1.377829e-02 6.312238e-01
      7804    466_552414 1994          S 1.000000e+01 -3.224073e-02 5.905851e-01
      7805    466_552414 1994          N 1.356000e+03 -1.885909e+02 7.255850e-03
      7806    466_552414 1994       maxN 1.033000e+03 -1.789796e+02 3.327334e-03
      7807    466_552414 1994    Shannon 8.068902e-01  1.237863e-02 2.594073e-01
      7808    466_552414 1994    Simpson 3.959775e-01  9.855409e-03 8.525569e-02
      7809    466_552414 1994 invSimpson 1.655567e+00  1.411651e-02 5.220728e-01
      7810    466_552414 1994        PIE 3.962697e-01  9.899262e-03 8.409336e-02
      7811    466_552414 1994      DomMc 8.827434e-01  1.677055e-03 5.221368e-01
      7812    466_552414 1994 expShannon 2.240928e+00  1.377829e-02 6.312238e-01
      7813    466_552414 1997          S 9.000000e+00 -3.224073e-02 5.905851e-01
      7814    466_552414 1997          N 1.009000e+03 -1.885909e+02 7.255850e-03
      7815    466_552414 1997       maxN 6.740000e+02 -1.789796e+02 3.327334e-03
      7816    466_552414 1997    Shannon 1.053132e+00  1.237863e-02 2.594073e-01
      7817    466_552414 1997    Simpson 5.132774e-01  9.855409e-03 8.525569e-02
      7818    466_552414 1997 invSimpson 2.054559e+00  1.411651e-02 5.220728e-01
      7819    466_552414 1997        PIE 5.137866e-01  9.899262e-03 8.409336e-02
      7820    466_552414 1997      DomMc 8.424182e-01  1.677055e-03 5.221368e-01
      7821    466_552414 1997 expShannon 2.866616e+00  1.377829e-02 6.312238e-01
      7822    466_552414 2002          S 9.000000e+00 -3.224073e-02 5.905851e-01
      7823    466_552414 2002          N 1.709000e+03 -1.885909e+02 7.255850e-03
      7824    466_552414 2002       maxN 1.122000e+03 -1.789796e+02 3.327334e-03
      7825    466_552414 2002    Shannon 9.046948e-01  1.237863e-02 2.594073e-01
      7826    466_552414 2002    Simpson 4.880006e-01  9.855409e-03 8.525569e-02
      7827    466_552414 2002 invSimpson 1.953127e+00  1.411651e-02 5.220728e-01
      7828    466_552414 2002        PIE 4.882863e-01  9.899262e-03 8.409336e-02
      7829    466_552414 2002      DomMc 9.397308e-01  1.677055e-03 5.221368e-01
      7830    466_552414 2002 expShannon 2.471178e+00  1.377829e-02 6.312238e-01
      7831    466_553870 1986          S 1.000000e+01  2.307692e-01 4.116516e-01
      7832    466_553870 1986          N 1.917000e+03  2.066154e+02 4.862828e-01
      7833    466_553870 1986       maxN 1.852000e+03 -6.153846e+00 9.861988e-01
      7834    466_553870 1986    Shannon 2.051388e-01  1.767076e-01 2.045926e-01
      7835    466_553870 1986    Simpson 6.640582e-02  9.367946e-02 2.390792e-01
      7836    466_553870 1986 invSimpson 1.071129e+00  2.649822e-01 2.168041e-01
      7837    466_553870 1986        PIE 6.644047e-02  9.371065e-02 2.390974e-01
      7838    466_553870 1986      DomMc 9.754825e-01 -2.573846e-02 1.878448e-01
      7839    466_553870 1986 expShannon 1.227695e+00  3.798808e-01 1.976604e-01
      7840    466_553870 1991          S 1.100000e+01  2.307692e-01 4.116516e-01
      7841    466_553870 1991          N 2.774000e+03  2.066154e+02 4.862828e-01
      7842    466_553870 1991       maxN 1.488000e+03 -6.153846e+00 9.861988e-01
      7843    466_553870 1991    Shannon 1.222514e+00  1.767076e-01 2.045926e-01
      7844    466_553870 1991    Simpson 6.146720e-01  9.367946e-02 2.390792e-01
      7845    466_553870 1991 invSimpson 2.595192e+00  2.649822e-01 2.168041e-01
      7846    466_553870 1991        PIE 6.148937e-01  9.371065e-02 2.390974e-01
      7847    466_553870 1991      DomMc 8.327325e-01 -2.573846e-02 1.878448e-01
      7848    466_553870 1991 expShannon 3.395714e+00  3.798808e-01 1.976604e-01
      7849    466_553870 1988          S 9.000000e+00  2.307692e-01 4.116516e-01
      7850    466_553870 1988          N 2.872000e+03  2.066154e+02 4.862828e-01
      7851    466_553870 1988       maxN 1.908000e+03 -6.153846e+00 9.861988e-01
      7852    466_553870 1988    Shannon 9.069555e-01  1.767076e-01 2.045926e-01
      7853    466_553870 1988    Simpson 4.882782e-01  9.367946e-02 2.390792e-01
      7854    466_553870 1988 invSimpson 1.954187e+00  2.649822e-01 2.168041e-01
      7855    466_553870 1988        PIE 4.884483e-01  9.371065e-02 2.390974e-01
      7856    466_553870 1988      DomMc 9.251393e-01 -2.573846e-02 1.878448e-01
      7857    466_553870 1988 expShannon 2.476771e+00  3.798808e-01 1.976604e-01
      7858    466_553870 1989          S 1.000000e+01  2.307692e-01 4.116516e-01
      7859    466_553870 1989          N 3.959000e+03  2.066154e+02 4.862828e-01
      7860    466_553870 1989       maxN 3.568000e+03 -6.153846e+00 9.861988e-01
      7861    466_553870 1989    Shannon 4.144761e-01  1.767076e-01 2.045926e-01
      7862    466_553870 1989    Simpson 1.826130e-01  9.367946e-02 2.390792e-01
      7863    466_553870 1989 invSimpson 1.223411e+00  2.649822e-01 2.168041e-01
      7864    466_553870 1989        PIE 1.826591e-01  9.371065e-02 2.390974e-01
      7865    466_553870 1989      DomMc 9.696893e-01 -2.573846e-02 1.878448e-01
      7866    466_553870 1989 expShannon 1.513578e+00  3.798808e-01 1.976604e-01
      7867    466_555327 1986          S 1.000000e+01 -9.237875e-02 1.302519e-01
      7868    466_555327 1986          N 1.517800e+04  1.769226e+02 4.308124e-01
      7869    466_555327 1986       maxN 1.480300e+04  1.495508e+02 4.941677e-01
      7870    466_555327 1986    Shannon 1.462632e-01  2.875115e-03 8.044105e-01
      7871    466_555327 1986    Simpson 4.856479e-02  4.993571e-04 9.463437e-01
      7872    466_555327 1986 invSimpson 1.051044e+00 -2.312831e-03 9.023409e-01
      7873    466_555327 1986        PIE 4.856799e-02  4.985687e-04 9.464486e-01
      7874    466_555327 1986      DomMc 9.894584e-01 -9.441546e-04 7.020470e-01
      7875    466_555327 1986 expShannon 1.157501e+00  2.985733e-03 8.925683e-01
      7876    466_555327 1988          S 1.100000e+01 -9.237875e-02 1.302519e-01
      7877    466_555327 1988          N 6.529000e+03  1.769226e+02 4.308124e-01
      7878    466_555327 1988       maxN 3.756000e+03  1.495508e+02 4.941677e-01
      7879    466_555327 1988    Shannon 8.528349e-01  2.875115e-03 8.044105e-01
      7880    466_555327 1988    Simpson 5.182420e-01  4.993571e-04 9.463437e-01
      7881    466_555327 1988 invSimpson 2.075731e+00 -2.312831e-03 9.023409e-01
      7882    466_555327 1988        PIE 5.183214e-01  4.985687e-04 9.464486e-01
      7883    466_555327 1988      DomMc 9.627814e-01 -9.441546e-04 7.020470e-01
      7884    466_555327 1988 expShannon 2.346289e+00  2.985733e-03 8.925683e-01
      7885    466_555327 1992          S 1.200000e+01 -9.237875e-02 1.302519e-01
      7886    466_555327 1992          N 5.506000e+03  1.769226e+02 4.308124e-01
      7887    466_555327 1992       maxN 3.321000e+03  1.495508e+02 4.941677e-01
      7888    466_555327 1992    Shannon 9.185720e-01  2.875115e-03 8.044105e-01
      7889    466_555327 1992    Simpson 5.222957e-01  4.993571e-04 9.463437e-01
      7890    466_555327 1992 invSimpson 2.093345e+00 -2.312831e-03 9.023409e-01
      7891    466_555327 1992        PIE 5.223906e-01  4.985687e-04 9.464486e-01
      7892    466_555327 1992      DomMc 9.382492e-01 -9.441546e-04 7.020470e-01
      7893    466_555327 1992 expShannon 2.505710e+00  2.985733e-03 8.925683e-01
      7894    466_555327 1989          S 1.100000e+01 -9.237875e-02 1.302519e-01
      7895    466_555327 1989          N 2.217000e+03  1.769226e+02 4.308124e-01
      7896    466_555327 1989       maxN 1.788000e+03  1.495508e+02 4.941677e-01
      7897    466_555327 1989    Shannon 7.300162e-01  2.875115e-03 8.044105e-01
      7898    466_555327 1989    Simpson 3.356143e-01  4.993571e-04 9.463437e-01
      7899    466_555327 1989 invSimpson 1.505150e+00 -2.312831e-03 9.023409e-01
      7900    466_555327 1989        PIE 3.357657e-01  4.985687e-04 9.464486e-01
      7901    466_555327 1989      DomMc 8.894903e-01 -9.441546e-04 7.020470e-01
      7902    466_555327 1989 expShannon 2.075114e+00  2.985733e-03 8.925683e-01
      7903    466_555327 1990          S 1.000000e+01 -9.237875e-02 1.302519e-01
      7904    466_555327 1990          N 4.297000e+03  1.769226e+02 4.308124e-01
      7905    466_555327 1990       maxN 2.419000e+03  1.495508e+02 4.941677e-01
      7906    466_555327 1990    Shannon 8.526019e-01  2.875115e-03 8.044105e-01
      7907    466_555327 1990    Simpson 5.221397e-01  4.993571e-04 9.463437e-01
      7908    466_555327 1990 invSimpson 2.092662e+00 -2.312831e-03 9.023409e-01
      7909    466_555327 1990        PIE 5.222612e-01  4.985687e-04 9.464486e-01
      7910    466_555327 1990      DomMc 9.634629e-01 -9.441546e-04 7.020470e-01
      7911    466_555327 1990 expShannon 2.345742e+00  2.985733e-03 8.925683e-01
      7912    466_555327 1994          S 1.000000e+01 -9.237875e-02 1.302519e-01
      7913    466_555327 1994          N 2.547000e+03  1.769226e+02 4.308124e-01
      7914    466_555327 1994       maxN 1.634000e+03  1.495508e+02 4.941677e-01
      7915    466_555327 1994    Shannon 9.401839e-01  2.875115e-03 8.044105e-01
      7916    466_555327 1994    Simpson 5.107574e-01  4.993571e-04 9.463437e-01
      7917    466_555327 1994 invSimpson 2.043976e+00 -2.312831e-03 9.023409e-01
      7918    466_555327 1994        PIE 5.109580e-01  4.985687e-04 9.464486e-01
      7919    466_555327 1994      DomMc 9.128386e-01 -9.441546e-04 7.020470e-01
      7920    466_555327 1994 expShannon 2.560452e+00  2.985733e-03 8.925683e-01
      7921    466_555327 2008          S 1.000000e+01 -9.237875e-02 1.302519e-01
      7922    466_555327 2008          N 1.819000e+04  1.769226e+02 4.308124e-01
      7923    466_555327 2008       maxN 1.589100e+04  1.495508e+02 4.941677e-01
      7924    466_555327 2008    Shannon 5.067607e-01  2.875115e-03 8.044105e-01
      7925    466_555327 2008    Simpson 2.298776e-01  4.993571e-04 9.463437e-01
      7926    466_555327 2008 invSimpson 1.298495e+00 -2.312831e-03 9.023409e-01
      7927    466_555327 2008        PIE 2.298902e-01  4.985687e-04 9.464486e-01
      7928    466_555327 2008      DomMc 9.490379e-01 -9.441546e-04 7.020470e-01
      7929    466_555327 2008 expShannon 1.659906e+00  2.985733e-03 8.925683e-01
      7930    466_555327 1991          S 9.000000e+00 -9.237875e-02 1.302519e-01
      7931    466_555327 1991          N 5.822000e+03  1.769226e+02 4.308124e-01
      7932    466_555327 1991       maxN 4.725000e+03  1.495508e+02 4.941677e-01
      7933    466_555327 1991    Shannon 6.338253e-01  2.875115e-03 8.044105e-01
      7934    466_555327 1991    Simpson 3.184961e-01  4.993571e-04 9.463437e-01
      7935    466_555327 1991 invSimpson 1.467343e+00 -2.312831e-03 9.023409e-01
      7936    466_555327 1991        PIE 3.185508e-01  4.985687e-04 9.464486e-01
      7937    466_555327 1991      DomMc 9.611817e-01 -9.441546e-04 7.020470e-01
      7938    466_555327 1991 expShannon 1.884807e+00  2.985733e-03 8.925683e-01
      7939    466_555327 1993          S 9.000000e+00 -9.237875e-02 1.302519e-01
      7940    466_555327 1993          N 3.830000e+03  1.769226e+02 4.308124e-01
      7941    466_555327 1993       maxN 2.977000e+03  1.495508e+02 4.941677e-01
      7942    466_555327 1993    Shannon 7.350665e-01  2.875115e-03 8.044105e-01
      7943    466_555327 1993    Simpson 3.730123e-01  4.993571e-04 9.463437e-01
      7944    466_555327 1993 invSimpson 1.594928e+00 -2.312831e-03 9.023409e-01
      7945    466_555327 1993        PIE 3.731097e-01  4.985687e-04 9.464486e-01
      7946    466_555327 1993      DomMc 8.958225e-01 -9.441546e-04 7.020470e-01
      7947    466_555327 1993 expShannon 2.085621e+00  2.985733e-03 8.925683e-01
      7948    466_555327 1996          S 7.000000e+00 -9.237875e-02 1.302519e-01
      7949    466_555327 1996          N 1.611000e+03  1.769226e+02 4.308124e-01
      7950    466_555327 1996       maxN 9.410000e+02  1.495508e+02 4.941677e-01
      7951    466_555327 1996    Shannon 1.050758e+00  2.875115e-03 8.044105e-01
      7952    466_555327 1996    Simpson 5.786806e-01  4.993571e-04 9.463437e-01
      7953    466_555327 1996 invSimpson 2.373496e+00 -2.312831e-03 9.023409e-01
      7954    466_555327 1996        PIE 5.790401e-01  4.985687e-04 9.464486e-01
      7955    466_555327 1996      DomMc 8.063315e-01 -9.441546e-04 7.020470e-01
      7956    466_555327 1996 expShannon 2.859817e+00  2.985733e-03 8.925683e-01
      7957    466_555327 1997          S 1.000000e+01 -9.237875e-02 1.302519e-01
      7958    466_555327 1997          N 4.528000e+03  1.769226e+02 4.308124e-01
      7959    466_555327 1997       maxN 3.067000e+03  1.495508e+02 4.941677e-01
      7960    466_555327 1997    Shannon 9.412272e-01  2.875115e-03 8.044105e-01
      7961    466_555327 1997    Simpson 4.947196e-01  4.993571e-04 9.463437e-01
      7962    466_555327 1997 invSimpson 1.979099e+00 -2.312831e-03 9.023409e-01
      7963    466_555327 1997        PIE 4.948289e-01  4.985687e-04 9.464486e-01
      7964    466_555327 1997      DomMc 8.473940e-01 -9.441546e-04 7.020470e-01
      7965    466_555327 1997 expShannon 2.563125e+00  2.985733e-03 8.925683e-01
      7966    466_555327 1999          S 8.000000e+00 -9.237875e-02 1.302519e-01
      7967    466_555327 1999          N 4.358000e+03  1.769226e+02 4.308124e-01
      7968    466_555327 1999       maxN 3.898000e+03  1.495508e+02 4.941677e-01
      7969    466_555327 1999    Shannon 4.257988e-01  2.875115e-03 8.044105e-01
      7970    466_555327 1999    Simpson 1.934642e-01  4.993571e-04 9.463437e-01
      7971    466_555327 1999 invSimpson 1.239871e+00 -2.312831e-03 9.023409e-01
      7972    466_555327 1999        PIE 1.935086e-01  4.985687e-04 9.464486e-01
      7973    466_555327 1999      DomMc 9.729234e-01 -9.441546e-04 7.020470e-01
      7974    466_555327 1999 expShannon 1.530813e+00  2.985733e-03 8.925683e-01
      7975    466_555327 2001          S 9.000000e+00 -9.237875e-02 1.302519e-01
      7976    466_555327 2001          N 4.044000e+03  1.769226e+02 4.308124e-01
      7977    466_555327 2001       maxN 2.644000e+03  1.495508e+02 4.941677e-01
      7978    466_555327 2001    Shannon 8.107324e-01  2.875115e-03 8.044105e-01
      7979    466_555327 2001    Simpson 4.783963e-01  4.993571e-04 9.463437e-01
      7980    466_555327 2001 invSimpson 1.917164e+00 -2.312831e-03 9.023409e-01
      7981    466_555327 2001        PIE 4.785146e-01  4.985687e-04 9.464486e-01
      7982    466_555327 2001      DomMc 9.591988e-01 -9.441546e-04 7.020470e-01
      7983    466_555327 2001 expShannon 2.249555e+00  2.985733e-03 8.925683e-01
      7984    466_555327 2002          S 8.000000e+00 -9.237875e-02 1.302519e-01
      7985    466_555327 2002          N 5.950000e+03  1.769226e+02 4.308124e-01
      7986    466_555327 2002       maxN 4.119000e+03  1.495508e+02 4.941677e-01
      7987    466_555327 2002    Shannon 8.561540e-01  2.875115e-03 8.044105e-01
      7988    466_555327 2002    Simpson 4.624237e-01  4.993571e-04 9.463437e-01
      7989    466_555327 2002 invSimpson 1.860201e+00 -2.312831e-03 9.023409e-01
      7990    466_555327 2002        PIE 4.625015e-01  4.985687e-04 9.464486e-01
      7991    466_555327 2002      DomMc 9.289076e-01 -9.441546e-04 7.020470e-01
      7992    466_555327 2002 expShannon 2.354089e+00  2.985733e-03 8.925683e-01
      7993    466_558967 1986          S 8.000000e+00  2.271497e-01 3.754155e-05
      7994    466_558967 1986          N 2.013000e+03 -3.147429e+01 8.500441e-01
      7995    466_558967 1986       maxN 1.955000e+03 -2.763877e+01 8.156142e-01
      7996    466_558967 1986    Shannon 1.737494e-01  1.173420e-02 2.895347e-01
      7997    466_558967 1986    Simpson 5.657217e-02  5.514462e-03 4.167371e-01
      7998    466_558967 1986 invSimpson 1.059964e+00  9.492243e-03 5.591839e-01
      7999    466_558967 1986        PIE 5.660029e-02  5.520773e-03 4.162778e-01
      8000    466_558967 1986      DomMc 9.821162e-01 -1.256566e-03 3.700424e-01
      8001    466_558967 1986 expShannon 1.189757e+00  1.900833e-02 3.482835e-01
      8002    466_558967 1994          S 9.000000e+00  2.271497e-01 3.754155e-05
      8003    466_558967 1994          N 1.523100e+04 -3.147429e+01 8.500441e-01
      8004    466_558967 1994       maxN 7.379000e+03 -2.763877e+01 8.156142e-01
      8005    466_558967 1994    Shannon 8.798465e-01  1.173420e-02 2.895347e-01
      8006    466_558967 1994    Simpson 5.407727e-01  5.514462e-03 4.167371e-01
      8007    466_558967 1994 invSimpson 2.177571e+00  9.492243e-03 5.591839e-01
      8008    466_558967 1994        PIE 5.408083e-01  5.520773e-03 4.162778e-01
      8009    466_558967 1994      DomMc 9.574552e-01 -1.256566e-03 3.700424e-01
      8010    466_558967 1994 expShannon 2.410530e+00  1.900833e-02 3.482835e-01
      8011    466_558967 1991          S 1.000000e+01  2.271497e-01 3.754155e-05
      8012    466_558967 1991          N 7.606000e+03 -3.147429e+01 8.500441e-01
      8013    466_558967 1991       maxN 6.747000e+03 -2.763877e+01 8.156142e-01
      8014    466_558967 1991    Shannon 4.620016e-01  1.173420e-02 2.895347e-01
      8015    466_558967 1991    Simpson 2.057412e-01  5.514462e-03 4.167371e-01
      8016    466_558967 1991 invSimpson 1.259035e+00  9.492243e-03 5.591839e-01
      8017    466_558967 1991        PIE 2.057682e-01  5.520773e-03 4.162778e-01
      8018    466_558967 1991      DomMc 9.718643e-01 -1.256566e-03 3.700424e-01
      8019    466_558967 1991 expShannon 1.587248e+00  1.900833e-02 3.482835e-01
      8020    466_558967 1992          S 7.000000e+00  2.271497e-01 3.754155e-05
      8021    466_558967 1992          N 1.029900e+04 -3.147429e+01 8.500441e-01
      8022    466_558967 1992       maxN 1.016700e+04 -2.763877e+01 8.156142e-01
      8023    466_558967 1992    Shannon 8.474183e-02  1.173420e-02 2.895347e-01
      8024    466_558967 1992    Simpson 2.540701e-02  5.514462e-03 4.167371e-01
      8025    466_558967 1992 invSimpson 1.026069e+00  9.492243e-03 5.591839e-01
      8026    466_558967 1992        PIE 2.540947e-02  5.520773e-03 4.162778e-01
      8027    466_558967 1992      DomMc 9.944655e-01 -1.256566e-03 3.700424e-01
      8028    466_558967 1992 expShannon 1.088436e+00  1.900833e-02 3.482835e-01
      8029    466_558967 1997          S 1.000000e+01  2.271497e-01 3.754155e-05
      8030    466_558967 1997          N 3.924000e+03 -3.147429e+01 8.500441e-01
      8031    466_558967 1997       maxN 2.351000e+03 -2.763877e+01 8.156142e-01
      8032    466_558967 1997    Shannon 1.051288e+00  1.173420e-02 2.895347e-01
      8033    466_558967 1997    Simpson 5.627646e-01  5.514462e-03 4.167371e-01
      8034    466_558967 1997 invSimpson 2.287098e+00  9.492243e-03 5.591839e-01
      8035    466_558967 1997        PIE 5.629081e-01  5.520773e-03 4.162778e-01
      8036    466_558967 1997      DomMc 8.509174e-01 -1.256566e-03 3.700424e-01
      8037    466_558967 1997 expShannon 2.861335e+00  1.900833e-02 3.482835e-01
      8038    466_558967 2006          S 1.200000e+01  2.271497e-01 3.754155e-05
      8039    466_558967 2006          N 3.460000e+03 -3.147429e+01 8.500441e-01
      8040    466_558967 2006       maxN 3.075000e+03 -2.763877e+01 8.156142e-01
      8041    466_558967 2006    Shannon 4.604914e-01  1.173420e-02 2.895347e-01
      8042    466_558967 2006    Simpson 2.035380e-01  5.514462e-03 4.167371e-01
      8043    466_558967 2006 invSimpson 1.255553e+00  9.492243e-03 5.591839e-01
      8044    466_558967 2006        PIE 2.035969e-01  5.520773e-03 4.162778e-01
      8045    466_558967 2006      DomMc 9.676301e-01 -1.256566e-03 3.700424e-01
      8046    466_558967 2006 expShannon 1.584853e+00  1.900833e-02 3.482835e-01
      8047    466_558967 2008          S 1.200000e+01  2.271497e-01 3.754155e-05
      8048    466_558967 2008          N 6.290000e+02 -3.147429e+01 8.500441e-01
      8049    466_558967 2008       maxN 5.680000e+02 -2.763877e+01 8.156142e-01
      8050    466_558967 2008    Shannon 5.043426e-01  1.173420e-02 2.895347e-01
      8051    466_558967 2008    Simpson 1.826049e-01  5.514462e-03 4.167371e-01
      8052    466_558967 2008 invSimpson 1.223399e+00  9.492243e-03 5.591839e-01
      8053    466_558967 2008        PIE 1.828957e-01  5.520773e-03 4.162778e-01
      8054    466_558967 2008      DomMc 9.395866e-01 -1.256566e-03 3.700424e-01
      8055    466_558967 2008 expShannon 1.655897e+00  1.900833e-02 3.482835e-01
      8056    466_558967 2005          S 1.100000e+01  2.271497e-01 3.754155e-05
      8057    466_558967 2005          N 7.999000e+03 -3.147429e+01 8.500441e-01
      8058    466_558967 2005       maxN 7.668000e+03 -2.763877e+01 8.156142e-01
      8059    466_558967 2005    Shannon 2.373640e-01  1.173420e-02 2.895347e-01
      8060    466_558967 2005    Simpson 8.064572e-02  5.514462e-03 4.167371e-01
      8061    466_558967 2005 invSimpson 1.087720e+00  9.492243e-03 5.591839e-01
      8062    466_558967 2005        PIE 8.065581e-02  5.520773e-03 4.162778e-01
      8063    466_558967 2005      DomMc 9.702463e-01 -1.256566e-03 3.700424e-01
      8064    466_558967 2005 expShannon 1.267903e+00  1.900833e-02 3.482835e-01
      8065    466_558967 2003          S 1.100000e+01  2.271497e-01 3.754155e-05
      8066    466_558967 2003          N 1.716000e+03 -3.147429e+01 8.500441e-01
      8067    466_558967 2003       maxN 1.313000e+03 -2.763877e+01 8.156142e-01
      8068    466_558967 2003    Shannon 7.994452e-01  1.173420e-02 2.895347e-01
      8069    466_558967 2003    Simpson 3.866380e-01  5.514462e-03 4.167371e-01
      8070    466_558967 2003 invSimpson 1.630359e+00  9.492243e-03 5.591839e-01
      8071    466_558967 2003        PIE 3.868635e-01  5.520773e-03 4.162778e-01
      8072    466_558967 2003      DomMc 9.271562e-01 -1.256566e-03 3.700424e-01
      8073    466_558967 2003 expShannon 2.224306e+00  1.900833e-02 3.482835e-01
      8074    466_558967 1988          S 8.000000e+00  2.271497e-01 3.754155e-05
      8075    466_558967 1988          N 1.998000e+03 -3.147429e+01 8.500441e-01
      8076    466_558967 1988       maxN 1.851000e+03 -2.763877e+01 8.156142e-01
      8077    466_558967 1988    Shannon 3.830391e-01  1.173420e-02 2.895347e-01
      8078    466_558967 1988    Simpson 1.406131e-01  5.514462e-03 4.167371e-01
      8079    466_558967 1988 invSimpson 1.163620e+00  9.492243e-03 5.591839e-01
      8080    466_558967 1988        PIE 1.406835e-01  5.520773e-03 4.162778e-01
      8081    466_558967 1988      DomMc 9.444444e-01 -1.256566e-03 3.700424e-01
      8082    466_558967 1988 expShannon 1.466735e+00  1.900833e-02 3.482835e-01
      8083    466_558967 1989          S 8.000000e+00  2.271497e-01 3.754155e-05
      8084    466_558967 1989          N 2.572000e+03 -3.147429e+01 8.500441e-01
      8085    466_558967 1989       maxN 2.336000e+03 -2.763877e+01 8.156142e-01
      8086    466_558967 1989    Shannon 4.124816e-01  1.173420e-02 2.895347e-01
      8087    466_558967 1989    Simpson 1.714837e-01  5.514462e-03 4.167371e-01
      8088    466_558967 1989 invSimpson 1.206977e+00  9.492243e-03 5.591839e-01
      8089    466_558967 1989        PIE 1.715504e-01  5.520773e-03 4.162778e-01
      8090    466_558967 1989      DomMc 9.642302e-01 -1.256566e-03 3.700424e-01
      8091    466_558967 1989 expShannon 1.510562e+00  1.900833e-02 3.482835e-01
      8092    466_558967 1990          S 7.000000e+00  2.271497e-01 3.754155e-05
      8093    466_558967 1990          N 1.988000e+03 -3.147429e+01 8.500441e-01
      8094    466_558967 1990       maxN 1.795000e+03 -2.763877e+01 8.156142e-01
      8095    466_558967 1990    Shannon 4.547532e-01  1.173420e-02 2.895347e-01
      8096    466_558967 1990    Simpson 1.819473e-01  5.514462e-03 4.167371e-01
      8097    466_558967 1990 invSimpson 1.222415e+00  9.492243e-03 5.591839e-01
      8098    466_558967 1990        PIE 1.820389e-01  5.520773e-03 4.162778e-01
      8099    466_558967 1990      DomMc 9.456740e-01 -1.256566e-03 3.700424e-01
      8100    466_558967 1990 expShannon 1.575784e+00  1.900833e-02 3.482835e-01
      8101    466_558967 1987          S 6.000000e+00  2.271497e-01 3.754155e-05
      8102    466_558967 1987          N 4.019000e+03 -3.147429e+01 8.500441e-01
      8103    466_558967 1987       maxN 3.897000e+03 -2.763877e+01 8.156142e-01
      8104    466_558967 1987    Shannon 1.724787e-01  1.173420e-02 2.895347e-01
      8105    466_558967 1987    Simpson 5.947812e-02  5.514462e-03 4.167371e-01
      8106    466_558967 1987 invSimpson 1.063239e+00  9.492243e-03 5.591839e-01
      8107    466_558967 1987        PIE 5.949292e-02  5.520773e-03 4.162778e-01
      8108    466_558967 1987      DomMc 9.828316e-01 -1.256566e-03 3.700424e-01
      8109    466_558967 1987 expShannon 1.188246e+00  1.900833e-02 3.482835e-01
      8110    466_553871 1987          S 9.000000e+00  2.528573e-03 9.657426e-01
      8111    466_553871 1987          N 2.292000e+03 -1.871620e+02 4.014946e-02
      8112    466_553871 1987       maxN 2.163000e+03 -1.712800e+02 2.476912e-02
      8113    466_553871 1987    Shannon 2.765829e-01  2.108296e-02 3.784119e-02
      8114    466_553871 1987    Simpson 1.077787e-01  1.156529e-02 3.920410e-02
      8115    466_553871 1987 invSimpson 1.120798e+00  2.728315e-02 6.031118e-02
      8116    466_553871 1987        PIE 1.078258e-01  1.159726e-02 3.879820e-02
      8117    466_553871 1987      DomMc 9.829843e-01 -2.456206e-03 2.726284e-01
      8118    466_553871 1987 expShannon 1.318616e+00  4.057981e-02 5.588397e-02
      8119    466_553871 1999          S 1.000000e+01  2.528573e-03 9.657426e-01
      8120    466_553871 1999          N 2.732000e+03 -1.871620e+02 4.014946e-02
      8121    466_553871 1999       maxN 1.512000e+03 -1.712800e+02 2.476912e-02
      8122    466_553871 1999    Shannon 1.073573e+00  2.108296e-02 3.784119e-02
      8123    466_553871 1999    Simpson 5.788459e-01  1.156529e-02 3.920410e-02
      8124    466_553871 1999 invSimpson 2.374428e+00  2.728315e-02 6.031118e-02
      8125    466_553871 1999        PIE 5.790579e-01  1.159726e-02 3.879820e-02
      8126    466_553871 1999      DomMc 8.846999e-01 -2.456206e-03 2.726284e-01
      8127    466_553871 1999 expShannon 2.925816e+00  4.057981e-02 5.588397e-02
      8128    466_553871 2008          S 9.000000e+00  2.528573e-03 9.657426e-01
      8129    466_553871 2008          N 8.660000e+02 -1.871620e+02 4.014946e-02
      8130    466_553871 2008       maxN 5.940000e+02 -1.712800e+02 2.476912e-02
      8131    466_553871 2008    Shannon 9.634381e-01  2.108296e-02 3.784119e-02
      8132    466_553871 2008    Simpson 4.882073e-01  1.156529e-02 3.920410e-02
      8133    466_553871 2008 invSimpson 1.953916e+00  2.728315e-02 6.031118e-02
      8134    466_553871 2008        PIE 4.887717e-01  1.159726e-02 3.879820e-02
      8135    466_553871 2008      DomMc 8.545035e-01 -2.456206e-03 2.726284e-01
      8136    466_553871 2008 expShannon 2.620691e+00  4.057981e-02 5.588397e-02
      8137    466_553871 1990          S 1.200000e+01  2.528573e-03 9.657426e-01
      8138    466_553871 1990          N 2.447000e+03 -1.871620e+02 4.014946e-02
      8139    466_553871 1990       maxN 1.702000e+03 -1.712800e+02 2.476912e-02
      8140    466_553871 1990    Shannon 1.079975e+00  2.108296e-02 3.784119e-02
      8141    466_553871 1990    Simpson 4.896125e-01  1.156529e-02 3.920410e-02
      8142    466_553871 1990 invSimpson 1.959296e+00  2.728315e-02 6.031118e-02
      8143    466_553871 1990        PIE 4.898126e-01  1.159726e-02 3.879820e-02
      8144    466_553871 1990      DomMc 8.324479e-01 -2.456206e-03 2.726284e-01
      8145    466_553871 1990 expShannon 2.944607e+00  4.057981e-02 5.588397e-02
      8146    466_553871 2001          S 1.000000e+01  2.528573e-03 9.657426e-01
      8147    466_553871 2001          N 5.882000e+03 -1.871620e+02 4.014946e-02
      8148    466_553871 2001       maxN 4.031000e+03 -1.712800e+02 2.476912e-02
      8149    466_553871 2001    Shannon 7.495585e-01  2.108296e-02 3.784119e-02
      8150    466_553871 2001    Simpson 4.469006e-01  1.156529e-02 3.920410e-02
      8151    466_553871 2001 invSimpson 1.807993e+00  2.728315e-02 6.031118e-02
      8152    466_553871 2001        PIE 4.469766e-01  1.159726e-02 3.879820e-02
      8153    466_553871 2001      DomMc 9.738184e-01 -2.456206e-03 2.726284e-01
      8154    466_553871 2001 expShannon 2.116066e+00  4.057981e-02 5.588397e-02
      8155    466_553871 2003          S 9.000000e+00  2.528573e-03 9.657426e-01
      8156    466_553871 2003          N 2.126000e+03 -1.871620e+02 4.014946e-02
      8157    466_553871 2003       maxN 1.230000e+03 -1.712800e+02 2.476912e-02
      8158    466_553871 2003    Shannon 1.010363e+00  2.108296e-02 3.784119e-02
      8159    466_553871 2003    Simpson 5.511735e-01  1.156529e-02 3.920410e-02
      8160    466_553871 2003 invSimpson 2.228033e+00  2.728315e-02 6.031118e-02
      8161    466_553871 2003        PIE 5.514329e-01  1.159726e-02 3.879820e-02
      8162    466_553871 2003      DomMc 9.125118e-01 -2.456206e-03 2.726284e-01
      8163    466_553871 2003 expShannon 2.746597e+00  4.057981e-02 5.588397e-02
      8164    466_553871 2005          S 8.000000e+00  2.528573e-03 9.657426e-01
      8165    466_553871 2005          N 3.630000e+02 -1.871620e+02 4.014946e-02
      8166    466_553871 2005       maxN 2.430000e+02 -1.712800e+02 2.476912e-02
      8167    466_553871 2005    Shannon 1.139506e+00  2.108296e-02 3.784119e-02
      8168    466_553871 2005    Simpson 5.222321e-01  1.156529e-02 3.920410e-02
      8169    466_553871 2005 invSimpson 2.093066e+00  2.728315e-02 6.031118e-02
      8170    466_553871 2005        PIE 5.236747e-01  1.159726e-02 3.879820e-02
      8171    466_553871 2005      DomMc 8.071625e-01 -2.456206e-03 2.726284e-01
      8172    466_553871 2005 expShannon 3.125223e+00  4.057981e-02 5.588397e-02
      8173    466_553871 2006          S 8.000000e+00  2.528573e-03 9.657426e-01
      8174    466_553871 2006          N 1.496000e+03 -1.871620e+02 4.014946e-02
      8175    466_553871 2006       maxN 1.256000e+03 -1.712800e+02 2.476912e-02
      8176    466_553871 2006    Shannon 6.947293e-01  2.108296e-02 3.784119e-02
      8177    466_553871 2006    Simpson 2.888219e-01  1.156529e-02 3.920410e-02
      8178    466_553871 2006 invSimpson 1.406118e+00  2.728315e-02 6.031118e-02
      8179    466_553871 2006        PIE 2.890151e-01  1.159726e-02 3.879820e-02
      8180    466_553871 2006      DomMc 8.950535e-01 -2.456206e-03 2.726284e-01
      8181    466_553871 2006 expShannon 2.003167e+00  4.057981e-02 5.588397e-02
      8182    466_553871 2007          S 1.200000e+01  2.528573e-03 9.657426e-01
      8183    466_553871 2007          N 7.080000e+02 -1.871620e+02 4.014946e-02
      8184    466_553871 2007       maxN 5.080000e+02 -1.712800e+02 2.476912e-02
      8185    466_553871 2007    Shannon 9.291057e-01  2.108296e-02 3.784119e-02
      8186    466_553871 2007    Simpson 4.454858e-01  1.156529e-02 3.920410e-02
      8187    466_553871 2007 invSimpson 1.803380e+00  2.728315e-02 6.031118e-02
      8188    466_553871 2007        PIE 4.461159e-01  1.159726e-02 3.879820e-02
      8189    466_553871 2007      DomMc 9.124294e-01 -2.456206e-03 2.726284e-01
      8190    466_553871 2007 expShannon 2.532244e+00  4.057981e-02 5.588397e-02
      8191    466_553871 1992          S 9.000000e+00  2.528573e-03 9.657426e-01
      8192    466_553871 1992          N 6.793000e+03 -1.871620e+02 4.014946e-02
      8193    466_553871 1992       maxN 6.418000e+03 -1.712800e+02 2.476912e-02
      8194    466_553871 1992    Shannon 2.636086e-01  2.108296e-02 3.784119e-02
      8195    466_553871 1992    Simpson 1.056260e-01  1.156529e-02 3.920410e-02
      8196    466_553871 1992 invSimpson 1.118100e+00  2.728315e-02 6.031118e-02
      8197    466_553871 1992        PIE 1.056416e-01  1.159726e-02 3.879820e-02
      8198    466_553871 1992      DomMc 9.852790e-01 -2.456206e-03 2.726284e-01
      8199    466_553871 1992 expShannon 1.301619e+00  4.057981e-02 5.588397e-02
      8200    466_553871 1994          S 9.000000e+00  2.528573e-03 9.657426e-01
      8201    466_553871 1994          N 5.549000e+03 -1.871620e+02 4.014946e-02
      8202    466_553871 1994       maxN 4.085000e+03 -1.712800e+02 2.476912e-02
      8203    466_553871 1994    Shannon 8.579760e-01  2.108296e-02 3.784119e-02
      8204    466_553871 1994    Simpson 4.289565e-01  1.156529e-02 3.920410e-02
      8205    466_553871 1994 invSimpson 1.751180e+00  2.728315e-02 6.031118e-02
      8206    466_553871 1994        PIE 4.290338e-01  1.159726e-02 3.879820e-02
      8207    466_553871 1994      DomMc 8.698865e-01 -2.456206e-03 2.726284e-01
      8208    466_553871 1994 expShannon 2.358382e+00  4.057981e-02 5.588397e-02
      8209    466_553871 1995          S 8.000000e+00  2.528573e-03 9.657426e-01
      8210    466_553871 1995          N 3.209000e+03 -1.871620e+02 4.014946e-02
      8211    466_553871 1995       maxN 2.580000e+03 -1.712800e+02 2.476912e-02
      8212    466_553871 1995    Shannon 6.360698e-01  2.108296e-02 3.784119e-02
      8213    466_553871 1995    Simpson 3.297146e-01  1.156529e-02 3.920410e-02
      8214    466_553871 1995 invSimpson 1.491902e+00  2.728315e-02 6.031118e-02
      8215    466_553871 1995        PIE 3.298174e-01  1.159726e-02 3.879820e-02
      8216    466_553871 1995      DomMc 9.538797e-01 -2.456206e-03 2.726284e-01
      8217    466_553871 1995 expShannon 1.889042e+00  4.057981e-02 5.588397e-02
      8218    466_553871 1996          S 9.000000e+00  2.528573e-03 9.657426e-01
      8219    466_553871 1996          N 2.535000e+03 -1.871620e+02 4.014946e-02
      8220    466_553871 1996       maxN 1.818000e+03 -1.712800e+02 2.476912e-02
      8221    466_553871 1996    Shannon 8.678993e-01  2.108296e-02 3.784119e-02
      8222    466_553871 1996    Simpson 4.476753e-01  1.156529e-02 3.920410e-02
      8223    466_553871 1996 invSimpson 1.810529e+00  2.728315e-02 6.031118e-02
      8224    466_553871 1996        PIE 4.478519e-01  1.159726e-02 3.879820e-02
      8225    466_553871 1996      DomMc 8.911243e-01 -2.456206e-03 2.726284e-01
      8226    466_553871 1996 expShannon 2.381902e+00  4.057981e-02 5.588397e-02
      8227    466_553871 1997          S 8.000000e+00  2.528573e-03 9.657426e-01
      8228    466_553871 1997          N 2.217000e+03 -1.871620e+02 4.014946e-02
      8229    466_553871 1997       maxN 1.477000e+03 -1.712800e+02 2.476912e-02
      8230    466_553871 1997    Shannon 9.506433e-01  2.108296e-02 3.784119e-02
      8231    466_553871 1997    Simpson 5.049333e-01  1.156529e-02 3.920410e-02
      8232    466_553871 1997 invSimpson 2.019930e+00  2.728315e-02 6.031118e-02
      8233    466_553871 1997        PIE 5.051611e-01  1.159726e-02 3.879820e-02
      8234    466_553871 1997      DomMc 8.534055e-01 -2.456206e-03 2.726284e-01
      8235    466_553871 1997 expShannon 2.587374e+00  4.057981e-02 5.588397e-02
      8236    466_553871 2002          S 8.000000e+00  2.528573e-03 9.657426e-01
      8237    466_553871 2002          N 3.372000e+03 -1.871620e+02 4.014946e-02
      8238    466_553871 2002       maxN 2.095000e+03 -1.712800e+02 2.476912e-02
      8239    466_553871 2002    Shannon 8.806828e-01  2.108296e-02 3.784119e-02
      8240    466_553871 2002    Simpson 5.055771e-01  1.156529e-02 3.920410e-02
      8241    466_553871 2002 invSimpson 2.022560e+00  2.728315e-02 6.031118e-02
      8242    466_553871 2002        PIE 5.057271e-01  1.159726e-02 3.879820e-02
      8243    466_553871 2002      DomMc 9.492883e-01 -2.456206e-03 2.726284e-01
      8244    466_553871 2002 expShannon 2.412546e+00  4.057981e-02 5.588397e-02
      8245    466_553871 1993          S 7.000000e+00  2.528573e-03 9.657426e-01
      8246    466_553871 1993          N 8.534000e+03 -1.871620e+02 4.014946e-02
      8247    466_553871 1993       maxN 6.851000e+03 -1.712800e+02 2.476912e-02
      8248    466_553871 1993    Shannon 6.796556e-01  2.108296e-02 3.784119e-02
      8249    466_553871 1993    Simpson 3.377641e-01  1.156529e-02 3.920410e-02
      8250    466_553871 1993 invSimpson 1.510036e+00  2.728315e-02 6.031118e-02
      8251    466_553871 1993        PIE 3.378037e-01  1.159726e-02 3.879820e-02
      8252    466_553871 1993      DomMc 9.118819e-01 -2.456206e-03 2.726284e-01
      8253    466_553871 1993 expShannon 1.973198e+00  4.057981e-02 5.588397e-02
      8254    466_552418 1988          S 1.100000e+01  8.914769e-02 4.966080e-02
      8255    466_552418 1988          N 4.258000e+03 -1.348753e+02 2.258430e-01
      8256    466_552418 1988       maxN 4.046000e+03 -1.513115e+02 1.447055e-01
      8257    466_552418 1988    Shannon 2.749803e-01  3.806781e-02 3.004699e-03
      8258    466_552418 1988    Simpson 9.638840e-02  2.070362e-02 2.397764e-03
      8259    466_552418 1988 invSimpson 1.106670e+00  5.467074e-02 1.382549e-03
      8260    466_552418 1988        PIE 9.641104e-02  2.071671e-02 2.401680e-03
      8261    466_552418 1988      DomMc 9.697041e-01 -6.230225e-03 1.079722e-02
      8262    466_552418 1988 expShannon 1.316505e+00  8.224471e-02 2.023344e-03
      8263    466_552418 1992          S 9.000000e+00  8.914769e-02 4.966080e-02
      8264    466_552418 1992          N 5.066000e+03 -1.348753e+02 2.258430e-01
      8265    466_552418 1992       maxN 4.852000e+03 -1.513115e+02 1.447055e-01
      8266    466_552418 1992    Shannon 2.429452e-01  3.806781e-02 3.004699e-03
      8267    466_552418 1992    Simpson 8.225634e-02  2.070362e-02 2.397764e-03
      8268    466_552418 1992 invSimpson 1.089629e+00  5.467074e-02 1.382549e-03
      8269    466_552418 1992        PIE 8.227258e-02  2.071671e-02 2.401680e-03
      8270    466_552418 1992      DomMc 9.735492e-01 -6.230225e-03 1.079722e-02
      8271    466_552418 1992 expShannon 1.274999e+00  8.224471e-02 2.023344e-03
      8272    466_552418 1995          S 1.100000e+01  8.914769e-02 4.966080e-02
      8273    466_552418 1995          N 3.152000e+03 -1.348753e+02 2.258430e-01
      8274    466_552418 1995       maxN 2.145000e+03 -1.513115e+02 1.447055e-01
      8275    466_552418 1995    Shannon 9.308361e-01  3.806781e-02 3.004699e-03
      8276    466_552418 1995    Simpson 4.910624e-01  2.070362e-02 2.397764e-03
      8277    466_552418 1995 invSimpson 1.964877e+00  5.467074e-02 1.382549e-03
      8278    466_552418 1995        PIE 4.912182e-01  2.071671e-02 2.401680e-03
      8279    466_552418 1995      DomMc 8.366117e-01 -6.230225e-03 1.079722e-02
      8280    466_552418 1995 expShannon 2.536629e+00  8.224471e-02 2.023344e-03
      8281    466_552418 2001          S 1.100000e+01  8.914769e-02 4.966080e-02
      8282    466_552418 2001          N 2.415000e+03 -1.348753e+02 2.258430e-01
      8283    466_552418 2001       maxN 1.946000e+03 -1.513115e+02 1.447055e-01
      8284    466_552418 2001    Shannon 7.691957e-01  3.806781e-02 3.004699e-03
      8285    466_552418 2001    Simpson 3.392054e-01  2.070362e-02 2.397764e-03
      8286    466_552418 2001 invSimpson 1.513329e+00  5.467074e-02 1.382549e-03
      8287    466_552418 2001        PIE 3.393459e-01  2.071671e-02 2.401680e-03
      8288    466_552418 2001      DomMc 8.935818e-01 -6.230225e-03 1.079722e-02
      8289    466_552418 2001 expShannon 2.158030e+00  8.224471e-02 2.023344e-03
      8290    466_552418 2002          S 1.100000e+01  8.914769e-02 4.966080e-02
      8291    466_552418 2002          N 1.453000e+03 -1.348753e+02 2.258430e-01
      8292    466_552418 2002       maxN 9.300000e+02 -1.513115e+02 1.447055e-01
      8293    466_552418 2002    Shannon 1.107524e+00  3.806781e-02 3.004699e-03
      8294    466_552418 2002    Simpson 5.367702e-01  2.070362e-02 2.397764e-03
      8295    466_552418 2002 invSimpson 2.158756e+00  5.467074e-02 1.382549e-03
      8296    466_552418 2002        PIE 5.371398e-01  2.071671e-02 2.401680e-03
      8297    466_552418 2002      DomMc 8.602891e-01 -6.230225e-03 1.079722e-02
      8298    466_552418 2002 expShannon 3.026855e+00  8.224471e-02 2.023344e-03
      8299    466_552418 1990          S 1.100000e+01  8.914769e-02 4.966080e-02
      8300    466_552418 1990          N 1.011000e+03 -1.348753e+02 2.258430e-01
      8301    466_552418 1990       maxN 8.580000e+02 -1.513115e+02 1.447055e-01
      8302    466_552418 1990    Shannon 6.749062e-01  3.806781e-02 3.004699e-03
      8303    466_552418 1990    Simpson 2.737151e-01  2.070362e-02 2.397764e-03
      8304    466_552418 1990 invSimpson 1.376870e+00  5.467074e-02 1.382549e-03
      8305    466_552418 1990        PIE 2.739862e-01  2.071671e-02 2.401680e-03
      8306    466_552418 1990      DomMc 9.149357e-01 -6.230225e-03 1.079722e-02
      8307    466_552418 1990 expShannon 1.963849e+00  8.224471e-02 2.023344e-03
      8308    466_552418 2003          S 1.200000e+01  8.914769e-02 4.966080e-02
      8309    466_552418 2003          N 9.170000e+02 -1.348753e+02 2.258430e-01
      8310    466_552418 2003       maxN 5.840000e+02 -1.513115e+02 1.447055e-01
      8311    466_552418 2003    Shannon 1.186382e+00  3.806781e-02 3.004699e-03
      8312    466_552418 2003    Simpson 5.552600e-01  2.070362e-02 2.397764e-03
      8313    466_552418 2003 invSimpson 2.248505e+00  5.467074e-02 1.382549e-03
      8314    466_552418 2003        PIE 5.558661e-01  2.071671e-02 2.401680e-03
      8315    466_552418 2003      DomMc 8.058888e-01 -6.230225e-03 1.079722e-02
      8316    466_552418 2003 expShannon 3.275209e+00  8.224471e-02 2.023344e-03
      8317    466_552418 2006          S 1.100000e+01  8.914769e-02 4.966080e-02
      8318    466_552418 2006          N 1.987000e+03 -1.348753e+02 2.258430e-01
      8319    466_552418 2006       maxN 1.208000e+03 -1.513115e+02 1.447055e-01
      8320    466_552418 2006    Shannon 1.056854e+00  3.806781e-02 3.004699e-03
      8321    466_552418 2006    Simpson 5.488691e-01  2.070362e-02 2.397764e-03
      8322    466_552418 2006 invSimpson 2.216652e+00  5.467074e-02 1.382549e-03
      8323    466_552418 2006        PIE 5.491455e-01  2.071671e-02 2.401680e-03
      8324    466_552418 2006      DomMc 8.862607e-01 -6.230225e-03 1.079722e-02
      8325    466_552418 2006 expShannon 2.877304e+00  8.224471e-02 2.023344e-03
      8326    466_552418 1994          S 1.200000e+01  8.914769e-02 4.966080e-02
      8327    466_552418 1994          N 3.326000e+03 -1.348753e+02 2.258430e-01
      8328    466_552418 1994       maxN 2.771000e+03 -1.513115e+02 1.447055e-01
      8329    466_552418 1994    Shannon 6.731258e-01  3.806781e-02 3.004699e-03
      8330    466_552418 1994    Simpson 2.950903e-01  2.070362e-02 2.397764e-03
      8331    466_552418 1994 invSimpson 1.418621e+00  5.467074e-02 1.382549e-03
      8332    466_552418 1994        PIE 2.951790e-01  2.071671e-02 2.401680e-03
      8333    466_552418 1994      DomMc 9.284426e-01 -6.230225e-03 1.079722e-02
      8334    466_552418 1994 expShannon 1.960355e+00  8.224471e-02 2.023344e-03
      8335    466_552418 1997          S 1.200000e+01  8.914769e-02 4.966080e-02
      8336    466_552418 1997          N 3.037000e+03 -1.348753e+02 2.258430e-01
      8337    466_552418 1997       maxN 2.117000e+03 -1.513115e+02 1.447055e-01
      8338    466_552418 1997    Shannon 9.465037e-01  3.806781e-02 3.004699e-03
      8339    466_552418 1997    Simpson 4.768815e-01  2.070362e-02 2.397764e-03
      8340    466_552418 1997 invSimpson 1.911613e+00  5.467074e-02 1.382549e-03
      8341    466_552418 1997        PIE 4.770386e-01  2.071671e-02 2.401680e-03
      8342    466_552418 1997      DomMc 8.419493e-01 -6.230225e-03 1.079722e-02
      8343    466_552418 1997 expShannon 2.576685e+00  8.224471e-02 2.023344e-03
      8344    466_552418 2005          S 1.100000e+01  8.914769e-02 4.966080e-02
      8345    466_552418 2005          N 3.171000e+03 -1.348753e+02 2.258430e-01
      8346    466_552418 2005       maxN 2.873000e+03 -1.513115e+02 1.447055e-01
      8347    466_552418 2005    Shannon 4.383826e-01  3.806781e-02 3.004699e-03
      8348    466_552418 2005    Simpson 1.762548e-01  2.070362e-02 2.397764e-03
      8349    466_552418 2005 invSimpson 1.213968e+00  5.467074e-02 1.382549e-03
      8350    466_552418 2005        PIE 1.763104e-01  2.071671e-02 2.401680e-03
      8351    466_552418 2005      DomMc 9.448124e-01 -6.230225e-03 1.079722e-02
      8352    466_552418 2005 expShannon 1.550198e+00  8.224471e-02 2.023344e-03
      8353    466_552418 2007          S 1.200000e+01  8.914769e-02 4.966080e-02
      8354    466_552418 2007          N 1.352000e+03 -1.348753e+02 2.258430e-01
      8355    466_552418 2007       maxN 8.100000e+02 -1.513115e+02 1.447055e-01
      8356    466_552418 2007    Shannon 1.228010e+00  3.806781e-02 3.004699e-03
      8357    466_552418 2007    Simpson 5.911328e-01  2.070362e-02 2.397764e-03
      8358    466_552418 2007 invSimpson 2.445782e+00  5.467074e-02 1.382549e-03
      8359    466_552418 2007        PIE 5.915703e-01  2.071671e-02 2.401680e-03
      8360    466_552418 2007      DomMc 7.744083e-01 -6.230225e-03 1.079722e-02
      8361    466_552418 2007 expShannon 3.414429e+00  8.224471e-02 2.023344e-03
      8362    466_552418 1989          S 9.000000e+00  8.914769e-02 4.966080e-02
      8363    466_552418 1989          N 4.936000e+03 -1.348753e+02 2.258430e-01
      8364    466_552418 1989       maxN 4.747000e+03 -1.513115e+02 1.447055e-01
      8365    466_552418 1989    Shannon 1.971702e-01  3.806781e-02 3.004699e-03
      8366    466_552418 1989    Simpson 7.423998e-02  2.070362e-02 2.397764e-03
      8367    466_552418 1989 invSimpson 1.080194e+00  5.467074e-02 1.382549e-03
      8368    466_552418 1989        PIE 7.425502e-02  2.071671e-02 2.401680e-03
      8369    466_552418 1989      DomMc 9.908833e-01 -6.230225e-03 1.079722e-02
      8370    466_552418 1989 expShannon 1.217951e+00  8.224471e-02 2.023344e-03
      8371    466_552418 1991          S 1.000000e+01  8.914769e-02 4.966080e-02
      8372    466_552418 1991          N 5.700000e+02 -1.348753e+02 2.258430e-01
      8373    466_552418 1991       maxN 4.790000e+02 -1.513115e+02 1.447055e-01
      8374    466_552418 1991    Shannon 7.494590e-01  3.806781e-02 3.004699e-03
      8375    466_552418 1991    Simpson 2.896522e-01  2.070362e-02 2.397764e-03
      8376    466_552418 1991 invSimpson 1.407761e+00  5.467074e-02 1.382549e-03
      8377    466_552418 1991        PIE 2.901613e-01  2.071671e-02 2.401680e-03
      8378    466_552418 1991      DomMc 8.789474e-01 -6.230225e-03 1.079722e-02
      8379    466_552418 1991 expShannon 2.115855e+00  8.224471e-02 2.023344e-03
      8380    466_552418 1993          S 9.000000e+00  8.914769e-02 4.966080e-02
      8381    466_552418 1993          N 7.693000e+03 -1.348753e+02 2.258430e-01
      8382    466_552418 1993       maxN 7.289000e+03 -1.513115e+02 1.447055e-01
      8383    466_552418 1993    Shannon 2.914864e-01  3.806781e-02 3.004699e-03
      8384    466_552418 1993    Simpson 1.015725e-01  2.070362e-02 2.397764e-03
      8385    466_552418 1993 invSimpson 1.113056e+00  5.467074e-02 1.382549e-03
      8386    466_552418 1993        PIE 1.015857e-01  2.071671e-02 2.401680e-03
      8387    466_552418 1993      DomMc 9.691928e-01 -6.230225e-03 1.079722e-02
      8388    466_552418 1993 expShannon 1.338415e+00  8.224471e-02 2.023344e-03
      8389    466_552418 1996          S 9.000000e+00  8.914769e-02 4.966080e-02
      8390    466_552418 1996          N 1.060300e+04 -1.348753e+02 2.258430e-01
      8391    466_552418 1996       maxN 9.140000e+03 -1.513115e+02 1.447055e-01
      8392    466_552418 1996    Shannon 5.289195e-01  3.806781e-02 3.004699e-03
      8393    466_552418 1996    Simpson 2.482852e-01  2.070362e-02 2.397764e-03
      8394    466_552418 1996 invSimpson 1.330292e+00  5.467074e-02 1.382549e-03
      8395    466_552418 1996        PIE 2.483086e-01  2.071671e-02 2.401680e-03
      8396    466_552418 1996      DomMc 9.330378e-01 -6.230225e-03 1.079722e-02
      8397    466_552418 1996 expShannon 1.697098e+00  8.224471e-02 2.023344e-03
      8398    466_553142 1988          S 9.000000e+00  5.902539e-02 3.355153e-01
      8399    466_553142 1988          N 4.325000e+03 -2.929581e+02 2.534946e-02
      8400    466_553142 1988       maxN 3.188000e+03 -2.532828e+02 3.562324e-02
      8401    466_553142 1988    Shannon 6.974868e-01  2.271527e-02 1.229154e-01
      8402    466_553142 1988    Simpson 4.003914e-01  1.153649e-02 2.416907e-01
      8403    466_553142 1988 invSimpson 1.667755e+00  3.486398e-02 2.006847e-01
      8404    466_553142 1988        PIE 4.004840e-01  1.155757e-02 2.410230e-01
      8405    466_553142 1988      DomMc 9.738728e-01 -3.929845e-03 2.522156e-01
      8406    466_553142 1988 expShannon 2.008698e+00  4.973517e-02 1.032798e-01
      8407    466_553142 1995          S 8.000000e+00  5.902539e-02 3.355153e-01
      8408    466_553142 1995          N 4.196000e+03 -2.929581e+02 2.534946e-02
      8409    466_553142 1995       maxN 2.755000e+03 -2.532828e+02 3.562324e-02
      8410    466_553142 1995    Shannon 9.178474e-01  2.271527e-02 1.229154e-01
      8411    466_553142 1995    Simpson 5.109752e-01  1.153649e-02 2.416907e-01
      8412    466_553142 1995 invSimpson 2.044886e+00  3.486398e-02 2.006847e-01
      8413    466_553142 1995        PIE 5.110970e-01  1.155757e-02 2.410230e-01
      8414    466_553142 1995      DomMc 8.527169e-01 -3.929845e-03 2.522156e-01
      8415    466_553142 1995 expShannon 2.503895e+00  4.973517e-02 1.032798e-01
      8416    466_553142 2002          S 9.000000e+00  5.902539e-02 3.355153e-01
      8417    466_553142 2002          N 1.449000e+03 -2.929581e+02 2.534946e-02
      8418    466_553142 2002       maxN 1.226000e+03 -2.532828e+02 3.562324e-02
      8419    466_553142 2002    Shannon 5.993805e-01  2.271527e-02 1.229154e-01
      8420    466_553142 2002    Simpson 2.716935e-01  1.153649e-02 2.416907e-01
      8421    466_553142 2002 invSimpson 1.373048e+00  3.486398e-02 2.006847e-01
      8422    466_553142 2002        PIE 2.718812e-01  1.155757e-02 2.410230e-01
      8423    466_553142 2002      DomMc 9.558316e-01 -3.929845e-03 2.522156e-01
      8424    466_553142 2002 expShannon 1.820990e+00  4.973517e-02 1.032798e-01
      8425    466_553142 1991          S 1.000000e+01  5.902539e-02 3.355153e-01
      8426    466_553142 1991          N 5.614000e+03 -2.929581e+02 2.534946e-02
      8427    466_553142 1991       maxN 5.160000e+03 -2.532828e+02 3.562324e-02
      8428    466_553142 1991    Shannon 3.922467e-01  2.271527e-02 1.229154e-01
      8429    466_553142 1991    Simpson 1.526574e-01  1.153649e-02 2.416907e-01
      8430    466_553142 1991 invSimpson 1.180160e+00  3.486398e-02 2.006847e-01
      8431    466_553142 1991        PIE 1.526846e-01  1.155757e-02 2.410230e-01
      8432    466_553142 1991      DomMc 9.672248e-01 -3.929845e-03 2.522156e-01
      8433    466_553142 1991 expShannon 1.480303e+00  4.973517e-02 1.032798e-01
      8434    466_553142 1993          S 1.100000e+01  5.902539e-02 3.355153e-01
      8435    466_553142 1993          N 9.347000e+03 -2.929581e+02 2.534946e-02
      8436    466_553142 1993       maxN 5.995000e+03 -2.532828e+02 3.562324e-02
      8437    466_553142 1993    Shannon 8.584898e-01  2.271527e-02 1.229154e-01
      8438    466_553142 1993    Simpson 4.977592e-01  1.153649e-02 2.416907e-01
      8439    466_553142 1993 invSimpson 1.991077e+00  3.486398e-02 2.006847e-01
      8440    466_553142 1993        PIE 4.978124e-01  1.155757e-02 2.410230e-01
      8441    466_553142 1993      DomMc 9.381620e-01 -3.929845e-03 2.522156e-01
      8442    466_553142 1993 expShannon 2.359594e+00  4.973517e-02 1.032798e-01
      8443    466_553142 1994          S 9.000000e+00  5.902539e-02 3.355153e-01
      8444    466_553142 1994          N 6.049000e+03 -2.929581e+02 2.534946e-02
      8445    466_553142 1994       maxN 5.417000e+03 -2.532828e+02 3.562324e-02
      8446    466_553142 1994    Shannon 4.671749e-01  2.271527e-02 1.229154e-01
      8447    466_553142 1994    Simpson 1.941314e-01  1.153649e-02 2.416907e-01
      8448    466_553142 1994 invSimpson 1.240897e+00  3.486398e-02 2.006847e-01
      8449    466_553142 1994        PIE 1.941635e-01  1.155757e-02 2.410230e-01
      8450    466_553142 1994      DomMc 9.457762e-01 -3.929845e-03 2.522156e-01
      8451    466_553142 1994 expShannon 1.595480e+00  4.973517e-02 1.032798e-01
      8452    466_553142 1996          S 1.000000e+01  5.902539e-02 3.355153e-01
      8453    466_553142 1996          N 2.603000e+03 -2.929581e+02 2.534946e-02
      8454    466_553142 1996       maxN 1.409000e+03 -2.532828e+02 3.562324e-02
      8455    466_553142 1996    Shannon 1.098388e+00  2.271527e-02 1.229154e-01
      8456    466_553142 1996    Simpson 6.097964e-01  1.153649e-02 2.416907e-01
      8457    466_553142 1996 invSimpson 2.562765e+00  3.486398e-02 2.006847e-01
      8458    466_553142 1996        PIE 6.100308e-01  1.155757e-02 2.410230e-01
      8459    466_553142 1996      DomMc 7.710334e-01 -3.929845e-03 2.522156e-01
      8460    466_553142 1996 expShannon 2.999327e+00  4.973517e-02 1.032798e-01
      8461    466_553142 1997          S 1.200000e+01  5.902539e-02 3.355153e-01
      8462    466_553142 1997          N 2.932000e+03 -2.929581e+02 2.534946e-02
      8463    466_553142 1997       maxN 1.778000e+03 -2.532828e+02 3.562324e-02
      8464    466_553142 1997    Shannon 9.659921e-01  2.271527e-02 1.229154e-01
      8465    466_553142 1997    Simpson 5.367868e-01  1.153649e-02 2.416907e-01
      8466    466_553142 1997 invSimpson 2.158833e+00  3.486398e-02 2.006847e-01
      8467    466_553142 1997        PIE 5.369699e-01  1.155757e-02 2.410230e-01
      8468    466_553142 1997      DomMc 9.058663e-01 -3.929845e-03 2.522156e-01
      8469    466_553142 1997 expShannon 2.627393e+00  4.973517e-02 1.032798e-01
      8470    466_553142 2001          S 1.000000e+01  5.902539e-02 3.355153e-01
      8471    466_553142 2001          N 4.768000e+03 -2.929581e+02 2.534946e-02
      8472    466_553142 2001       maxN 3.044000e+03 -2.532828e+02 3.562324e-02
      8473    466_553142 2001    Shannon 8.171916e-01  2.271527e-02 1.229154e-01
      8474    466_553142 2001    Simpson 4.858838e-01  1.153649e-02 2.416907e-01
      8475    466_553142 2001 invSimpson 1.945085e+00  3.486398e-02 2.006847e-01
      8476    466_553142 2001        PIE 4.859857e-01  1.155757e-02 2.410230e-01
      8477    466_553142 2001      DomMc 9.641359e-01 -3.929845e-03 2.522156e-01
      8478    466_553142 2001 expShannon 2.264132e+00  4.973517e-02 1.032798e-01
      8479    466_553142 2007          S 1.100000e+01  5.902539e-02 3.355153e-01
      8480    466_553142 2007          N 9.990000e+02 -2.929581e+02 2.534946e-02
      8481    466_553142 2007       maxN 5.240000e+02 -2.532828e+02 3.562324e-02
      8482    466_553142 2007    Shannon 1.137269e+00  2.271527e-02 1.229154e-01
      8483    466_553142 2007    Simpson 5.998511e-01  1.153649e-02 2.416907e-01
      8484    466_553142 2007 invSimpson 2.499070e+00  3.486398e-02 2.006847e-01
      8485    466_553142 2007        PIE 6.004522e-01  1.155757e-02 2.410230e-01
      8486    466_553142 2007      DomMc 8.668669e-01 -3.929845e-03 2.522156e-01
      8487    466_553142 2007 expShannon 3.118241e+00  4.973517e-02 1.032798e-01
      8488    466_553142 1989          S 9.000000e+00  5.902539e-02 3.355153e-01
      8489    466_553142 1989          N 4.739000e+03 -2.929581e+02 2.534946e-02
      8490    466_553142 1989       maxN 2.641000e+03 -2.532828e+02 3.562324e-02
      8491    466_553142 1989    Shannon 8.803284e-01  2.271527e-02 1.229154e-01
      8492    466_553142 1989    Simpson 5.323034e-01  1.153649e-02 2.416907e-01
      8493    466_553142 1989 invSimpson 2.138138e+00  3.486398e-02 2.006847e-01
      8494    466_553142 1989        PIE 5.324157e-01  1.155757e-02 2.410230e-01
      8495    466_553142 1989      DomMc 9.518886e-01 -3.929845e-03 2.522156e-01
      8496    466_553142 1989 expShannon 2.411692e+00  4.973517e-02 1.032798e-01
      8497    466_553142 1990          S 1.000000e+01  5.902539e-02 3.355153e-01
      8498    466_553142 1990          N 9.191000e+03 -2.929581e+02 2.534946e-02
      8499    466_553142 1990       maxN 8.736000e+03 -2.532828e+02 3.562324e-02
      8500    466_553142 1990    Shannon 2.622681e-01  2.271527e-02 1.229154e-01
      8501    466_553142 1990    Simpson 9.555754e-02  1.153649e-02 2.416907e-01
      8502    466_553142 1990 invSimpson 1.105654e+00  3.486398e-02 2.006847e-01
      8503    466_553142 1990        PIE 9.556794e-02  1.155757e-02 2.410230e-01
      8504    466_553142 1990      DomMc 9.808508e-01 -3.929845e-03 2.522156e-01
      8505    466_553142 1990 expShannon 1.299875e+00  4.973517e-02 1.032798e-01
      8506    466_553146 1988          S 1.200000e+01 -5.595426e-02 5.088794e-01
      8507    466_553146 1988          N 1.952000e+03 -1.262340e+02 5.104580e-01
      8508    466_553146 1988       maxN 1.606000e+03 -1.082556e+02 5.163674e-01
      8509    466_553146 1988    Shannon 7.462810e-01  1.911814e-02 2.895869e-01
      8510    466_553146 1988    Simpson 3.142988e-01  1.055093e-02 2.359290e-01
      8511    466_553146 1988 invSimpson 1.458361e+00  4.580913e-02 1.958363e-01
      8512    466_553146 1988        PIE 3.144599e-01  1.058454e-02 2.352108e-01
      8513    466_553146 1988      DomMc 8.970287e-01 -5.093046e-03 2.545833e-01
      8514    466_553146 1988 expShannon 2.109141e+00  5.296370e-02 2.722433e-01
      8515    466_553146 1995          S 1.100000e+01 -5.595426e-02 5.088794e-01
      8516    466_553146 1995          N 4.615000e+03 -1.262340e+02 5.104580e-01
      8517    466_553146 1995       maxN 3.594000e+03 -1.082556e+02 5.163674e-01
      8518    466_553146 1995    Shannon 7.083437e-01  1.911814e-02 2.895869e-01
      8519    466_553146 1995    Simpson 3.663030e-01  1.055093e-02 2.359290e-01
      8520    466_553146 1995 invSimpson 1.578041e+00  4.580913e-02 1.958363e-01
      8521    466_553146 1995        PIE 3.663824e-01  1.058454e-02 2.352108e-01
      8522    466_553146 1995      DomMc 9.339112e-01 -5.093046e-03 2.545833e-01
      8523    466_553146 1995 expShannon 2.030625e+00  5.296370e-02 2.722433e-01
      8524    466_553146 2005          S 1.000000e+01 -5.595426e-02 5.088794e-01
      8525    466_553146 2005          N 2.861000e+03 -1.262340e+02 5.104580e-01
      8526    466_553146 2005       maxN 2.691000e+03 -1.082556e+02 5.163674e-01
      8527    466_553146 2005    Shannon 3.107510e-01  1.911814e-02 2.895869e-01
      8528    466_553146 2005    Simpson 1.143090e-01  1.055093e-02 2.359290e-01
      8529    466_553146 2005 invSimpson 1.129062e+00  4.580913e-02 1.958363e-01
      8530    466_553146 2005        PIE 1.143490e-01  1.058454e-02 2.352108e-01
      8531    466_553146 2005      DomMc 9.615519e-01 -5.093046e-03 2.545833e-01
      8532    466_553146 2005 expShannon 1.364449e+00  5.296370e-02 2.722433e-01
      8533    466_553146 2002          S 1.300000e+01 -5.595426e-02 5.088794e-01
      8534    466_553146 2002          N 1.633000e+03 -1.262340e+02 5.104580e-01
      8535    466_553146 2002       maxN 1.153000e+03 -1.082556e+02 5.163674e-01
      8536    466_553146 2002    Shannon 1.124736e+00  1.911814e-02 2.895869e-01
      8537    466_553146 2002    Simpson 4.830282e-01  1.055093e-02 2.359290e-01
      8538    466_553146 2002 invSimpson 1.934342e+00  4.580913e-02 1.958363e-01
      8539    466_553146 2002        PIE 4.833242e-01  1.058454e-02 2.352108e-01
      8540    466_553146 2002      DomMc 8.089406e-01 -5.093046e-03 2.545833e-01
      8541    466_553146 2002 expShannon 3.079405e+00  5.296370e-02 2.722433e-01
      8542    466_553146 1993          S 1.100000e+01 -5.595426e-02 5.088794e-01
      8543    466_553146 1993          N 8.510000e+03 -1.262340e+02 5.104580e-01
      8544    466_553146 1993       maxN 7.273000e+03 -1.082556e+02 5.163674e-01
      8545    466_553146 1993    Shannon 5.582013e-01  1.911814e-02 2.895869e-01
      8546    466_553146 1993    Simpson 2.572600e-01  1.055093e-02 2.359290e-01
      8547    466_553146 1993 invSimpson 1.346366e+00  4.580913e-02 1.958363e-01
      8548    466_553146 1993        PIE 2.572902e-01  1.058454e-02 2.352108e-01
      8549    466_553146 1993      DomMc 9.645123e-01 -5.093046e-03 2.545833e-01
      8550    466_553146 1993 expShannon 1.747526e+00  5.296370e-02 2.722433e-01
      8551    466_553146 2001          S 9.000000e+00 -5.595426e-02 5.088794e-01
      8552    466_553146 2001          N 1.975000e+03 -1.262340e+02 5.104580e-01
      8553    466_553146 2001       maxN 1.620000e+03 -1.082556e+02 5.163674e-01
      8554    466_553146 2001    Shannon 7.437375e-01  1.911814e-02 2.895869e-01
      8555    466_553146 2001    Simpson 3.183874e-01  1.055093e-02 2.359290e-01
      8556    466_553146 2001 invSimpson 1.467109e+00  4.580913e-02 1.958363e-01
      8557    466_553146 2001        PIE 3.185487e-01  1.058454e-02 2.352108e-01
      8558    466_553146 2001      DomMc 8.982278e-01 -5.093046e-03 2.545833e-01
      8559    466_553146 2001 expShannon 2.103784e+00  5.296370e-02 2.722433e-01
      8560    466_553146 2007          S 1.300000e+01 -5.595426e-02 5.088794e-01
      8561    466_553146 2007          N 1.036000e+03 -1.262340e+02 5.104580e-01
      8562    466_553146 2007       maxN 6.520000e+02 -1.082556e+02 5.163674e-01
      8563    466_553146 2007    Shannon 1.063929e+00  1.911814e-02 2.895869e-01
      8564    466_553146 2007    Simpson 5.349242e-01  1.055093e-02 2.359290e-01
      8565    466_553146 2007 invSimpson 2.150187e+00  4.580913e-02 1.958363e-01
      8566    466_553146 2007        PIE 5.354410e-01  1.058454e-02 2.352108e-01
      8567    466_553146 2007      DomMc 8.851351e-01 -5.093046e-03 2.545833e-01
      8568    466_553146 2007 expShannon 2.897734e+00  5.296370e-02 2.722433e-01
      8569    466_553146 2006          S 8.000000e+00 -5.595426e-02 5.088794e-01
      8570    466_553146 2006          N 3.681000e+03 -1.262340e+02 5.104580e-01
      8571    466_553146 2006       maxN 3.343000e+03 -1.082556e+02 5.163674e-01
      8572    466_553146 2006    Shannon 4.366090e-01  1.911814e-02 2.895869e-01
      8573    466_553146 2006    Simpson 1.729843e-01  1.055093e-02 2.359290e-01
      8574    466_553146 2006 invSimpson 1.209167e+00  4.580913e-02 1.958363e-01
      8575    466_553146 2006        PIE 1.730313e-01  1.058454e-02 2.352108e-01
      8576    466_553146 2006      DomMc 9.410486e-01 -5.093046e-03 2.545833e-01
      8577    466_553146 2006 expShannon 1.547451e+00  5.296370e-02 2.722433e-01
      8578    466_553146 1989          S 1.100000e+01 -5.595426e-02 5.088794e-01
      8579    466_553146 1989          N 1.697000e+03 -1.262340e+02 5.104580e-01
      8580    466_553146 1989       maxN 1.529000e+03 -1.082556e+02 5.163674e-01
      8581    466_553146 1989    Shannon 4.886437e-01  1.911814e-02 2.895869e-01
      8582    466_553146 1989    Simpson 1.856345e-01  1.055093e-02 2.359290e-01
      8583    466_553146 1989 invSimpson 1.227950e+00  4.580913e-02 1.958363e-01
      8584    466_553146 1989        PIE 1.857440e-01  1.058454e-02 2.352108e-01
      8585    466_553146 1989      DomMc 9.451974e-01 -5.093046e-03 2.545833e-01
      8586    466_553146 1989 expShannon 1.630104e+00  5.296370e-02 2.722433e-01
      8587    466_553146 1991          S 9.000000e+00 -5.595426e-02 5.088794e-01
      8588    466_553146 1991          N 1.204000e+03 -1.262340e+02 5.104580e-01
      8589    466_553146 1991       maxN 1.117000e+03 -1.082556e+02 5.163674e-01
      8590    466_553146 1991    Shannon 3.683435e-01  1.911814e-02 2.895869e-01
      8591    466_553146 1991    Simpson 1.377165e-01  1.055093e-02 2.359290e-01
      8592    466_553146 1991 invSimpson 1.159711e+00  4.580913e-02 1.958363e-01
      8593    466_553146 1991        PIE 1.378309e-01  1.058454e-02 2.352108e-01
      8594    466_553146 1991      DomMc 9.617940e-01 -5.093046e-03 2.545833e-01
      8595    466_553146 1991 expShannon 1.445338e+00  5.296370e-02 2.722433e-01
      8596    466_553146 1996          S 1.200000e+01 -5.595426e-02 5.088794e-01
      8597    466_553146 1996          N 1.722000e+04 -1.262340e+02 5.104580e-01
      8598    466_553146 1996       maxN 1.471200e+04 -1.082556e+02 5.163674e-01
      8599    466_553146 1996    Shannon 5.481039e-01  1.911814e-02 2.895869e-01
      8600    466_553146 1996    Simpson 2.581985e-01  1.055093e-02 2.359290e-01
      8601    466_553146 1996 invSimpson 1.348070e+00  4.580913e-02 1.958363e-01
      8602    466_553146 1996        PIE 2.582135e-01  1.058454e-02 2.352108e-01
      8603    466_553146 1996      DomMc 9.602207e-01 -5.093046e-03 2.545833e-01
      8604    466_553146 1996 expShannon 1.729970e+00  5.296370e-02 2.722433e-01
      8605    466_553146 1997          S 1.300000e+01 -5.595426e-02 5.088794e-01
      8606    466_553146 1997          N 1.494000e+03 -1.262340e+02 5.104580e-01
      8607    466_553146 1997       maxN 7.120000e+02 -1.082556e+02 5.163674e-01
      8608    466_553146 1997    Shannon 1.592911e+00  1.911814e-02 2.895869e-01
      8609    466_553146 1997    Simpson 7.118407e-01  1.055093e-02 2.359290e-01
      8610    466_553146 1997 invSimpson 3.470302e+00  4.580913e-02 1.958363e-01
      8611    466_553146 1997        PIE 7.123175e-01  1.058454e-02 2.352108e-01
      8612    466_553146 1997      DomMc 6.559572e-01 -5.093046e-03 2.545833e-01
      8613    466_553146 1997 expShannon 4.918047e+00  5.296370e-02 2.722433e-01
      8614    466_553146 1999          S 7.000000e+00 -5.595426e-02 5.088794e-01
      8615    466_553146 1999          N 5.364000e+03 -1.262340e+02 5.104580e-01
      8616    466_553146 1999       maxN 5.121000e+03 -1.082556e+02 5.163674e-01
      8617    466_553146 1999    Shannon 2.490391e-01  1.911814e-02 2.895869e-01
      8618    466_553146 1999    Simpson 8.801259e-02  1.055093e-02 2.359290e-01
      8619    466_553146 1999 invSimpson 1.096506e+00  4.580913e-02 1.958363e-01
      8620    466_553146 1999        PIE 8.802900e-02  1.058454e-02 2.352108e-01
      8621    466_553146 1999      DomMc 9.707308e-01 -5.093046e-03 2.545833e-01
      8622    466_553146 1999 expShannon 1.282792e+00  5.296370e-02 2.722433e-01
      8623    466_553146 2008          S 9.000000e+00 -5.595426e-02 5.088794e-01
      8624    466_553146 2008          N 3.960000e+02 -1.262340e+02 5.104580e-01
      8625    466_553146 2008       maxN 1.480000e+02 -1.082556e+02 5.163674e-01
      8626    466_553146 2008    Shannon 1.476808e+00  1.911814e-02 2.895869e-01
      8627    466_553146 2008    Simpson 7.281400e-01  1.055093e-02 2.359290e-01
      8628    466_553146 2008 invSimpson 3.678364e+00  4.580913e-02 1.958363e-01
      8629    466_553146 2008        PIE 7.299834e-01  1.058454e-02 2.352108e-01
      8630    466_553146 2008      DomMc 6.742424e-01 -5.093046e-03 2.545833e-01
      8631    466_553146 2008 expShannon 4.378946e+00  5.296370e-02 2.722433e-01
      8632    466_556057 1988          S 1.000000e+01 -5.917160e-03 9.755086e-01
      8633    466_556057 1988          N 2.753000e+03 -6.011538e+01 7.443456e-01
      8634    466_556057 1988       maxN 2.465000e+03 -1.083491e+02 5.229514e-01
      8635    466_556057 1988    Shannon 5.223684e-01  3.599970e-02 3.411866e-02
      8636    466_556057 1988    Simpson 1.961710e-01  2.574512e-02 1.235443e-02
      8637    466_556057 1988 invSimpson 1.244046e+00  7.727218e-02 1.009856e-01
      8638    466_556057 1988        PIE 1.962423e-01  2.576073e-02 1.218023e-02
      8639    466_556057 1988      DomMc 9.233563e-01 -7.586934e-04 8.161208e-01
      8640    466_556057 1988 expShannon 1.686016e+00  8.076913e-02 1.533180e-02
      8641    466_556057 1995          S 1.200000e+01 -5.917160e-03 9.755086e-01
      8642    466_556057 1995          N 4.212000e+03 -6.011538e+01 7.443456e-01
      8643    466_556057 1995       maxN 3.253000e+03 -1.083491e+02 5.229514e-01
      8644    466_556057 1995    Shannon 8.000108e-01  3.599970e-02 3.411866e-02
      8645    466_556057 1995    Simpson 3.830221e-01  2.574512e-02 1.235443e-02
      8646    466_556057 1995 invSimpson 1.620804e+00  7.727218e-02 1.009856e-01
      8647    466_556057 1995        PIE 3.831131e-01  2.576073e-02 1.218023e-02
      8648    466_556057 1995      DomMc 8.841406e-01 -7.586934e-04 8.161208e-01
      8649    466_556057 1995 expShannon 2.225565e+00  8.076913e-02 1.533180e-02
      8650    466_556057 2003          S 1.000000e+01 -5.917160e-03 9.755086e-01
      8651    466_556057 2003          N 1.933000e+03 -6.011538e+01 7.443456e-01
      8652    466_556057 2003       maxN 9.070000e+02 -1.083491e+02 5.229514e-01
      8653    466_556057 2003    Shannon 1.063479e+00  3.599970e-02 3.411866e-02
      8654    466_556057 2003    Simpson 5.826363e-01  2.574512e-02 1.235443e-02
      8655    466_556057 2003 invSimpson 2.395992e+00  7.727218e-02 1.009856e-01
      8656    466_556057 2003        PIE 5.829378e-01  2.576073e-02 1.218023e-02
      8657    466_556057 2003      DomMc 9.105018e-01 -7.586934e-04 8.161208e-01
      8658    466_556057 2003 expShannon 2.896430e+00  8.076913e-02 1.533180e-02
      8659    466_557512 1988          S 1.300000e+01  1.119254e-01 1.857117e-01
      8660    466_557512 1988          N 1.232000e+03 -2.103058e+02 4.984011e-02
      8661    466_557512 1988       maxN 8.520000e+02 -1.652139e+02 5.988173e-02
      8662    466_557512 1988    Shannon 1.126061e+00  1.297547e-02 3.461267e-01
      8663    466_557512 1988    Simpson 4.947029e-01  5.001365e-03 5.091801e-01
      8664    466_557512 1988 invSimpson 1.979034e+00  1.823699e-02 4.076683e-01
      8665    466_557512 1988        PIE 4.951048e-01  5.014442e-03 5.084020e-01
      8666    466_557512 1988      DomMc 8.384740e-01 -4.207446e-03 1.655034e-01
      8667    466_557512 1988 expShannon 3.083487e+00  3.168302e-02 3.177919e-01
      8668    466_557512 2005          S 1.200000e+01  1.119254e-01 1.857117e-01
      8669    466_557512 2005          N 1.690000e+03 -2.103058e+02 4.984011e-02
      8670    466_557512 2005       maxN 9.770000e+02 -1.652139e+02 5.988173e-02
      8671    466_557512 2005    Shannon 1.139625e+00  1.297547e-02 3.461267e-01
      8672    466_557512 2005    Simpson 5.818585e-01  5.001365e-03 5.091801e-01
      8673    466_557512 2005 invSimpson 2.391535e+00  1.823699e-02 4.076683e-01
      8674    466_557512 2005        PIE 5.822030e-01  5.014442e-03 5.084020e-01
      8675    466_557512 2005      DomMc 8.508876e-01 -4.207446e-03 1.655034e-01
      8676    466_557512 2005 expShannon 3.125597e+00  3.168302e-02 3.177919e-01
      8677    466_557512 2008          S 1.500000e+01  1.119254e-01 1.857117e-01
      8678    466_557512 2008          N 6.050000e+02 -2.103058e+02 4.984011e-02
      8679    466_557512 2008       maxN 5.620000e+02 -1.652139e+02 5.988173e-02
      8680    466_557512 2008    Shannon 4.207950e-01  1.297547e-02 3.461267e-01
      8681    466_557512 2008    Simpson 1.364661e-01  5.001365e-03 5.091801e-01
      8682    466_557512 2008 invSimpson 1.158032e+00  1.823699e-02 4.076683e-01
      8683    466_557512 2008        PIE 1.366920e-01  5.014442e-03 5.084020e-01
      8684    466_557512 2008      DomMc 9.454545e-01 -4.207446e-03 1.655034e-01
      8685    466_557512 2008 expShannon 1.523172e+00  3.168302e-02 3.177919e-01
      8686    466_557512 1989          S 1.100000e+01  1.119254e-01 1.857117e-01
      8687    466_557512 1989          N 2.926000e+03 -2.103058e+02 4.984011e-02
      8688    466_557512 1989       maxN 2.647000e+03 -1.652139e+02 5.988173e-02
      8689    466_557512 1989    Shannon 4.305182e-01  1.297547e-02 3.461267e-01
      8690    466_557512 1989    Simpson 1.772993e-01  5.001365e-03 5.091801e-01
      8691    466_557512 1989 invSimpson 1.215509e+00  1.823699e-02 4.076683e-01
      8692    466_557512 1989        PIE 1.773599e-01  5.014442e-03 5.084020e-01
      8693    466_557512 1989      DomMc 9.688995e-01 -4.207446e-03 1.655034e-01
      8694    466_557512 1989 expShannon 1.538054e+00  3.168302e-02 3.177919e-01
      8695    466_557512 2006          S 1.200000e+01  1.119254e-01 1.857117e-01
      8696    466_557512 2006          N 1.868000e+03 -2.103058e+02 4.984011e-02
      8697    466_557512 2006       maxN 1.500000e+03 -1.652139e+02 5.988173e-02
      8698    466_557512 2006    Shannon 7.893660e-01  1.297547e-02 3.461267e-01
      8699    466_557512 2006    Simpson 3.433971e-01  5.001365e-03 5.091801e-01
      8700    466_557512 2006 invSimpson 1.522990e+00  1.823699e-02 4.076683e-01
      8701    466_557512 2006        PIE 3.435810e-01  5.014442e-03 5.084020e-01
      8702    466_557512 2006      DomMc 8.870450e-01 -4.207446e-03 1.655034e-01
      8703    466_557512 2006 expShannon 2.202000e+00  3.168302e-02 3.177919e-01
      8704    466_557512 1992          S 1.000000e+01  1.119254e-01 1.857117e-01
      8705    466_557512 1992          N 9.251000e+03 -2.103058e+02 4.984011e-02
      8706    466_557512 1992       maxN 8.733000e+03 -1.652139e+02 5.988173e-02
      8707    466_557512 1992    Shannon 2.718190e-01  1.297547e-02 3.461267e-01
      8708    466_557512 1992    Simpson 1.071144e-01  5.001365e-03 5.091801e-01
      8709    466_557512 1992 invSimpson 1.119964e+00  1.823699e-02 4.076683e-01
      8710    466_557512 1992        PIE 1.071260e-01  5.014442e-03 5.084020e-01
      8711    466_557512 1992      DomMc 9.849746e-01 -4.207446e-03 1.655034e-01
      8712    466_557512 1992 expShannon 1.312349e+00  3.168302e-02 3.177919e-01
      8713    466_557512 1996          S 1.100000e+01  1.119254e-01 1.857117e-01
      8714    466_557512 1996          N 3.418000e+03 -2.103058e+02 4.984011e-02
      8715    466_557512 1996       maxN 2.341000e+03 -1.652139e+02 5.988173e-02
      8716    466_557512 1996    Shannon 9.722610e-01  1.297547e-02 3.461267e-01
      8717    466_557512 1996    Simpson 4.896789e-01  5.001365e-03 5.091801e-01
      8718    466_557512 1996 invSimpson 1.959551e+00  1.823699e-02 4.076683e-01
      8719    466_557512 1996        PIE 4.898223e-01  5.014442e-03 5.084020e-01
      8720    466_557512 1996      DomMc 8.525453e-01 -4.207446e-03 1.655034e-01
      8721    466_557512 1996 expShannon 2.643916e+00  3.168302e-02 3.177919e-01
      8722    466_557512 2001          S 9.000000e+00  1.119254e-01 1.857117e-01
      8723    466_557512 2001          N 6.400000e+02 -2.103058e+02 4.984011e-02
      8724    466_557512 2001       maxN 3.560000e+02 -1.652139e+02 5.988173e-02
      8725    466_557512 2001    Shannon 1.296410e+00  1.297547e-02 3.461267e-01
      8726    466_557512 2001    Simpson 6.295361e-01  5.001365e-03 5.091801e-01
      8727    466_557512 2001 invSimpson 2.699319e+00  1.823699e-02 4.076683e-01
      8728    466_557512 2001        PIE 6.305213e-01  5.014442e-03 5.084020e-01
      8729    466_557512 2001      DomMc 7.546875e-01 -4.207446e-03 1.655034e-01
      8730    466_557512 2001 expShannon 3.656147e+00  3.168302e-02 3.177919e-01
      8731    466_557512 2003          S 1.000000e+01  1.119254e-01 1.857117e-01
      8732    466_557512 2003          N 1.815000e+03 -2.103058e+02 4.984011e-02
      8733    466_557512 2003       maxN 1.224000e+03 -1.652139e+02 5.988173e-02
      8734    466_557512 2003    Shannon 1.039257e+00  1.297547e-02 3.461267e-01
      8735    466_557512 2003    Simpson 5.067559e-01  5.001365e-03 5.091801e-01
      8736    466_557512 2003 invSimpson 2.027394e+00  1.823699e-02 4.076683e-01
      8737    466_557512 2003        PIE 5.070353e-01  5.014442e-03 5.084020e-01
      8738    466_557512 2003      DomMc 8.308540e-01 -4.207446e-03 1.655034e-01
      8739    466_557512 2003 expShannon 2.827115e+00  3.168302e-02 3.177919e-01
      8740    466_557512 2007          S 1.200000e+01  1.119254e-01 1.857117e-01
      8741    466_557512 2007          N 1.406000e+03 -2.103058e+02 4.984011e-02
      8742    466_557512 2007       maxN 8.120000e+02 -1.652139e+02 5.988173e-02
      8743    466_557512 2007    Shannon 1.275833e+00  1.297547e-02 3.461267e-01
      8744    466_557512 2007    Simpson 6.034866e-01  5.001365e-03 5.091801e-01
      8745    466_557512 2007 invSimpson 2.521983e+00  1.823699e-02 4.076683e-01
      8746    466_557512 2007        PIE 6.039161e-01  5.014442e-03 5.084020e-01
      8747    466_557512 2007      DomMc 8.086771e-01 -4.207446e-03 1.655034e-01
      8748    466_557512 2007 expShannon 3.581685e+00  3.168302e-02 3.177919e-01
      8749    466_557512 1999          S 1.000000e+01  1.119254e-01 1.857117e-01
      8750    466_557512 1999          N 1.358000e+03 -2.103058e+02 4.984011e-02
      8751    466_557512 1999       maxN 8.660000e+02 -1.652139e+02 5.988173e-02
      8752    466_557512 1999    Shannon 1.186511e+00  1.297547e-02 3.461267e-01
      8753    466_557512 1999    Simpson 5.578983e-01  5.001365e-03 5.091801e-01
      8754    466_557512 1999 invSimpson 2.261923e+00  1.823699e-02 4.076683e-01
      8755    466_557512 1999        PIE 5.583094e-01  5.014442e-03 5.084020e-01
      8756    466_557512 1999      DomMc 7.614138e-01 -4.207446e-03 1.655034e-01
      8757    466_557512 1999 expShannon 3.275633e+00  3.168302e-02 3.177919e-01
      8758    466_557512 1993          S 1.000000e+01  1.119254e-01 1.857117e-01
      8759    466_557512 1993          N 4.433000e+03 -2.103058e+02 4.984011e-02
      8760    466_557512 1993       maxN 2.323000e+03 -1.652139e+02 5.988173e-02
      8761    466_557512 1993    Shannon 9.645854e-01  1.297547e-02 3.461267e-01
      8762    466_557512 1993    Simpson 5.523288e-01  5.001365e-03 5.091801e-01
      8763    466_557512 1993 invSimpson 2.233782e+00  1.823699e-02 4.076683e-01
      8764    466_557512 1993        PIE 5.524535e-01  5.014442e-03 5.084020e-01
      8765    466_557512 1993      DomMc 9.386420e-01 -4.207446e-03 1.655034e-01
      8766    466_557512 1993 expShannon 2.623700e+00  3.168302e-02 3.177919e-01
      8767    466_557512 1994          S 9.000000e+00  1.119254e-01 1.857117e-01
      8768    466_557512 1994          N 8.352000e+03 -2.103058e+02 4.984011e-02
      8769    466_557512 1994       maxN 4.012000e+03 -1.652139e+02 5.988173e-02
      8770    466_557512 1994    Shannon 9.145138e-01  1.297547e-02 3.461267e-01
      8771    466_557512 1994    Simpson 5.453966e-01  5.001365e-03 5.091801e-01
      8772    466_557512 1994 invSimpson 2.199720e+00  1.823699e-02 4.076683e-01
      8773    466_557512 1994        PIE 5.454619e-01  5.014442e-03 5.084020e-01
      8774    466_557512 1994      DomMc 9.527059e-01 -4.207446e-03 1.655034e-01
      8775    466_557512 1994 expShannon 2.495562e+00  3.168302e-02 3.177919e-01
      8776    466_557512 1995          S 7.000000e+00  1.119254e-01 1.857117e-01
      8777    466_557512 1995          N 5.384000e+03 -2.103058e+02 4.984011e-02
      8778    466_557512 1995       maxN 4.541000e+03 -1.652139e+02 5.988173e-02
      8779    466_557512 1995    Shannon 5.775555e-01  1.297547e-02 3.461267e-01
      8780    466_557512 1995    Simpson 2.775298e-01  5.001365e-03 5.091801e-01
      8781    466_557512 1995 invSimpson 1.384140e+00  1.823699e-02 4.076683e-01
      8782    466_557512 1995        PIE 2.775814e-01  5.014442e-03 5.084020e-01
      8783    466_557512 1995      DomMc 9.234770e-01 -4.207446e-03 1.655034e-01
      8784    466_557512 1995 expShannon 1.781678e+00  3.168302e-02 3.177919e-01
      8785    466_557512 1997          S 8.000000e+00  1.119254e-01 1.857117e-01
      8786    466_557512 1997          N 2.085000e+03 -2.103058e+02 4.984011e-02
      8787    466_557512 1997       maxN 1.631000e+03 -1.652139e+02 5.988173e-02
      8788    466_557512 1997    Shannon 8.824387e-01  1.297547e-02 3.461267e-01
      8789    466_557512 1997    Simpson 3.770125e-01  5.001365e-03 5.091801e-01
      8790    466_557512 1997 invSimpson 1.605169e+00  1.823699e-02 4.076683e-01
      8791    466_557512 1997        PIE 3.771934e-01  5.014442e-03 5.084020e-01
      8792    466_557512 1997      DomMc 8.642686e-01 -4.207446e-03 1.655034e-01
      8793    466_557512 1997 expShannon 2.416786e+00  3.168302e-02 3.177919e-01
      8794    466_554599 1988          S 1.300000e+01 -5.502063e-02 5.453826e-01
      8795    466_554599 1988          N 4.432000e+03 -2.990399e+02 2.976687e-01
      8796    466_554599 1988       maxN 3.888000e+03 -3.061176e+02 2.710251e-01
      8797    466_554599 1988    Shannon 5.321003e-01  2.126313e-02 1.394427e-01
      8798    466_554599 1988    Simpson 2.248301e-01  1.414269e-02 8.213106e-02
      8799    466_554599 1988 invSimpson 1.290040e+00  3.438489e-02 1.735218e-01
      8800    466_554599 1988        PIE 2.248809e-01  1.416929e-02 8.169180e-02
      8801    466_554599 1988      DomMc 9.408845e-01 -2.117330e-03 5.556714e-01
      8802    466_554599 1988 expShannon 1.702504e+00  4.205106e-02 1.717648e-01
      8803    466_554599 1995          S 1.300000e+01 -5.502063e-02 5.453826e-01
      8804    466_554599 1995          N 6.088000e+03 -2.990399e+02 2.976687e-01
      8805    466_554599 1995       maxN 2.723000e+03 -3.061176e+02 2.710251e-01
      8806    466_554599 1995    Shannon 1.257280e+00  2.126313e-02 1.394427e-01
      8807    466_554599 1995    Simpson 6.680268e-01  1.414269e-02 8.213106e-02
      8808    466_554599 1995 invSimpson 3.012292e+00  3.438489e-02 1.735218e-01
      8809    466_554599 1995        PIE 6.681366e-01  1.416929e-02 8.169180e-02
      8810    466_554599 1995      DomMc 7.368594e-01 -2.117330e-03 5.556714e-01
      8811    466_554599 1995 expShannon 3.515847e+00  4.205106e-02 1.717648e-01
      8812    466_554599 2007          S 1.100000e+01 -5.502063e-02 5.453826e-01
      8813    466_554599 2007          N 8.560000e+02 -2.990399e+02 2.976687e-01
      8814    466_554599 2007       maxN 5.550000e+02 -3.061176e+02 2.710251e-01
      8815    466_554599 2007    Shannon 9.825152e-01  2.126313e-02 1.394427e-01
      8816    466_554599 2007    Simpson 5.064116e-01  1.414269e-02 8.213106e-02
      8817    466_554599 2007 invSimpson 2.025979e+00  3.438489e-02 1.735218e-01
      8818    466_554599 2007        PIE 5.070039e-01  1.416929e-02 8.169180e-02
      8819    466_554599 2007      DomMc 9.158879e-01 -2.117330e-03 5.556714e-01
      8820    466_554599 2007 expShannon 2.671166e+00  4.205106e-02 1.717648e-01
      8821    466_554599 1989          S 9.000000e+00 -5.502063e-02 5.453826e-01
      8822    466_554599 1989          N 2.243000e+03 -2.990399e+02 2.976687e-01
      8823    466_554599 1989       maxN 1.639000e+03 -3.061176e+02 2.710251e-01
      8824    466_554599 1989    Shannon 9.333443e-01  2.126313e-02 1.394427e-01
      8825    466_554599 1989    Simpson 4.409637e-01  1.414269e-02 8.213106e-02
      8826    466_554599 1989 invSimpson 1.788793e+00  3.438489e-02 1.735218e-01
      8827    466_554599 1989        PIE 4.411604e-01  1.416929e-02 8.169180e-02
      8828    466_554599 1989      DomMc 8.573339e-01 -2.117330e-03 5.556714e-01
      8829    466_554599 1989 expShannon 2.542999e+00  4.205106e-02 1.717648e-01
      8830    466_554599 1991          S 9.000000e+00 -5.502063e-02 5.453826e-01
      8831    466_554599 1991          N 7.401000e+03 -2.990399e+02 2.976687e-01
      8832    466_554599 1991       maxN 6.436000e+03 -3.061176e+02 2.710251e-01
      8833    466_554599 1991    Shannon 5.508602e-01  2.126313e-02 1.394427e-01
      8834    466_554599 1991    Simpson 2.375713e-01  1.414269e-02 8.213106e-02
      8835    466_554599 1991 invSimpson 1.311598e+00  3.438489e-02 1.735218e-01
      8836    466_554599 1991        PIE 2.376034e-01  1.416929e-02 8.169180e-02
      8837    466_554599 1991      DomMc 9.351439e-01 -2.117330e-03 5.556714e-01
      8838    466_554599 1991 expShannon 1.734745e+00  4.205106e-02 1.717648e-01
      8839    466_554599 1994          S 9.000000e+00 -5.502063e-02 5.453826e-01
      8840    466_554599 1994          N 3.960000e+03 -2.990399e+02 2.976687e-01
      8841    466_554599 1994       maxN 3.136000e+03 -3.061176e+02 2.710251e-01
      8842    466_554599 1994    Shannon 6.964115e-01  2.126313e-02 1.394427e-01
      8843    466_554599 1994    Simpson 3.487841e-01  1.414269e-02 8.213106e-02
      8844    466_554599 1994 invSimpson 1.535589e+00  3.438489e-02 1.735218e-01
      8845    466_554599 1994        PIE 3.488722e-01  1.416929e-02 8.169180e-02
      8846    466_554599 1994      DomMc 9.414141e-01 -2.117330e-03 5.556714e-01
      8847    466_554599 1994 expShannon 2.006539e+00  4.205106e-02 1.717648e-01
      8848    466_554599 2008          S 8.000000e+00 -5.502063e-02 5.453826e-01
      8849    466_554599 2008          N 7.510000e+02 -2.990399e+02 2.976687e-01
      8850    466_554599 2008       maxN 5.160000e+02 -3.061176e+02 2.710251e-01
      8851    466_554599 2008    Shannon 9.457828e-01  2.126313e-02 1.394427e-01
      8852    466_554599 2008    Simpson 4.866445e-01  1.414269e-02 8.213106e-02
      8853    466_554599 2008 invSimpson 1.947968e+00  3.438489e-02 1.735218e-01
      8854    466_554599 2008        PIE 4.872934e-01  1.416929e-02 8.169180e-02
      8855    466_554599 2008      DomMc 8.362184e-01 -2.117330e-03 5.556714e-01
      8856    466_554599 2008 expShannon 2.574828e+00  4.205106e-02 1.717648e-01
      8857    466_554599 1992          S 7.000000e+00 -5.502063e-02 5.453826e-01
      8858    466_554599 1992          N 9.297000e+03 -2.990399e+02 2.976687e-01
      8859    466_554599 1992       maxN 8.535000e+03 -3.061176e+02 2.710251e-01
      8860    466_554599 1992    Shannon 3.727340e-01  2.126313e-02 1.394427e-01
      8861    466_554599 1992    Simpson 1.544475e-01  1.414269e-02 8.213106e-02
      8862    466_554599 1992 invSimpson 1.182659e+00  3.438489e-02 1.735218e-01
      8863    466_554599 1992        PIE 1.544641e-01  1.416929e-02 8.169180e-02
      8864    466_554599 1992      DomMc 9.614930e-01 -2.117330e-03 5.556714e-01
      8865    466_554599 1992 expShannon 1.451698e+00  4.205106e-02 1.717648e-01
      8866    466_554599 1996          S 9.000000e+00 -5.502063e-02 5.453826e-01
      8867    466_554599 1996          N 1.895200e+04 -2.990399e+02 2.976687e-01
      8868    466_554599 1996       maxN 1.798100e+04 -3.061176e+02 2.710251e-01
      8869    466_554599 1996    Shannon 2.500457e-01  2.126313e-02 1.394427e-01
      8870    466_554599 1996    Simpson 9.862357e-02  1.414269e-02 8.213106e-02
      8871    466_554599 1996 invSimpson 1.109414e+00  3.438489e-02 1.735218e-01
      8872    466_554599 1996        PIE 9.862878e-02  1.416929e-02 8.169180e-02
      8873    466_554599 1996      DomMc 9.780498e-01 -2.117330e-03 5.556714e-01
      8874    466_554599 1996 expShannon 1.284084e+00  4.205106e-02 1.717648e-01
      8875    466_554599 1997          S 9.000000e+00 -5.502063e-02 5.453826e-01
      8876    466_554599 1997          N 5.894000e+03 -2.990399e+02 2.976687e-01
      8877    466_554599 1997       maxN 4.549000e+03 -3.061176e+02 2.710251e-01
      8878    466_554599 1997    Shannon 6.846560e-01  2.126313e-02 1.394427e-01
      8879    466_554599 1997    Simpson 3.689390e-01  1.414269e-02 8.213106e-02
      8880    466_554599 1997 invSimpson 1.584633e+00  3.438489e-02 1.735218e-01
      8881    466_554599 1997        PIE 3.690016e-01  1.416929e-02 8.169180e-02
      8882    466_554599 1997      DomMc 9.569053e-01 -2.117330e-03 5.556714e-01
      8883    466_554599 1997 expShannon 1.983090e+00  4.205106e-02 1.717648e-01
      8884    466_554599 2001          S 8.000000e+00 -5.502063e-02 5.453826e-01
      8885    466_554599 2001          N 1.013600e+04 -2.990399e+02 2.976687e-01
      8886    466_554599 2001       maxN 6.292000e+03 -3.061176e+02 2.710251e-01
      8887    466_554599 2001    Shannon 7.857977e-01  2.126313e-02 1.394427e-01
      8888    466_554599 2001    Simpson 4.894700e-01  1.414269e-02 8.213106e-02
      8889    466_554599 2001 invSimpson 1.958749e+00  3.438489e-02 1.735218e-01
      8890    466_554599 2001        PIE 4.895183e-01  1.416929e-02 8.169180e-02
      8891    466_554599 2001      DomMc 9.741515e-01 -2.117330e-03 5.556714e-01
      8892    466_554599 2001 expShannon 2.194156e+00  4.205106e-02 1.717648e-01
      8893    466_554599 1990          S 1.000000e+01 -5.502063e-02 5.453826e-01
      8894    466_554599 1990          N 1.833800e+04 -2.990399e+02 2.976687e-01
      8895    466_554599 1990       maxN 1.721100e+04 -3.061176e+02 2.710251e-01
      8896    466_554599 1990    Shannon 2.547294e-01  2.126313e-02 1.394427e-01
      8897    466_554599 1990    Simpson 1.159417e-01  1.414269e-02 8.213106e-02
      8898    466_554599 1990 invSimpson 1.131147e+00  3.438489e-02 1.735218e-01
      8899    466_554599 1990        PIE 1.159481e-01  1.416929e-02 8.169180e-02
      8900    466_554599 1990      DomMc 9.949831e-01 -2.117330e-03 5.556714e-01
      8901    466_554599 1990 expShannon 1.290112e+00  4.205106e-02 1.717648e-01
      8902    466_553872 1988          S 1.100000e+01  3.640257e-02 7.536029e-01
      8903    466_553872 1988          N 7.097000e+03 -4.450321e+02 3.545213e-02
      8904    466_553872 1988       maxN 6.374000e+03 -3.769764e+02 1.108487e-02
      8905    466_553872 1988    Shannon 4.579610e-01  2.322580e-03 8.957016e-01
      8906    466_553872 1988    Simpson 1.896257e-01 -1.752855e-03 8.806971e-01
      8907    466_553872 1988 invSimpson 1.233998e+00 -4.487437e-03 8.609658e-01
      8908    466_553872 1988        PIE 1.896524e-01 -1.751229e-03 8.808132e-01
      8909    466_553872 1988      DomMc 9.432154e-01 -1.950212e-03 5.458508e-01
      8910    466_553872 1988 expShannon 1.580847e+00  4.060251e-03 9.032516e-01
      8911    466_553872 1994          S 1.200000e+01  3.640257e-02 7.536029e-01
      8912    466_553872 1994          N 1.074600e+04 -4.450321e+02 3.545213e-02
      8913    466_553872 1994       maxN 7.267000e+03 -3.769764e+02 1.108487e-02
      8914    466_553872 1994    Shannon 9.259659e-01  2.322580e-03 8.957016e-01
      8915    466_553872 1994    Simpson 4.915791e-01 -1.752855e-03 8.806971e-01
      8916    466_553872 1994 invSimpson 1.966874e+00 -4.487437e-03 8.609658e-01
      8917    466_553872 1994        PIE 4.916249e-01 -1.751229e-03 8.808132e-01
      8918    466_553872 1994      DomMc 8.767914e-01 -1.950212e-03 5.458508e-01
      8919    466_553872 1994 expShannon 2.524305e+00  4.060251e-03 9.032516e-01
      8920    466_553872 2001          S 9.000000e+00  3.640257e-02 7.536029e-01
      8921    466_553872 2001          N 3.734000e+03 -4.450321e+02 3.545213e-02
      8922    466_553872 2001       maxN 3.445000e+03 -3.769764e+02 1.108487e-02
      8923    466_553872 2001    Shannon 3.832243e-01  2.322580e-03 8.957016e-01
      8924    466_553872 2001    Simpson 1.469058e-01 -1.752855e-03 8.806971e-01
      8925    466_553872 2001 invSimpson 1.172204e+00 -4.487437e-03 8.609658e-01
      8926    466_553872 2001        PIE 1.469452e-01 -1.751229e-03 8.808132e-01
      8927    466_553872 2001      DomMc 9.606320e-01 -1.950212e-03 5.458508e-01
      8928    466_553872 2001 expShannon 1.467007e+00  4.060251e-03 9.032516e-01
      8929    466_553872 2002          S 9.000000e+00  3.640257e-02 7.536029e-01
      8930    466_553872 2002          N 3.528000e+03 -4.450321e+02 3.545213e-02
      8931    466_553872 2002       maxN 3.242000e+03 -3.769764e+02 1.108487e-02
      8932    466_553872 2002    Shannon 4.032897e-01  2.322580e-03 8.957016e-01
      8933    466_553872 2002    Simpson 1.537123e-01 -1.752855e-03 8.806971e-01
      8934    466_553872 2002 invSimpson 1.181631e+00 -4.487437e-03 8.609658e-01
      8935    466_553872 2002        PIE 1.537559e-01 -1.751229e-03 8.808132e-01
      8936    466_553872 2002      DomMc 9.503968e-01 -1.950212e-03 5.458508e-01
      8937    466_553872 2002 expShannon 1.496740e+00  4.060251e-03 9.032516e-01
      8938    466_553872 1986          S 7.000000e+00  3.640257e-02 7.536029e-01
      8939    466_553872 1986          N 1.125100e+04 -4.450321e+02 3.545213e-02
      8940    466_553872 1986       maxN 1.059000e+04 -3.769764e+02 1.108487e-02
      8941    466_553872 1986    Shannon 2.844818e-01  2.322580e-03 8.957016e-01
      8942    466_553872 1986    Simpson 1.125124e-01 -1.752855e-03 8.806971e-01
      8943    466_553872 1986 invSimpson 1.126776e+00 -4.487437e-03 8.609658e-01
      8944    466_553872 1986        PIE 1.125224e-01 -1.751229e-03 8.808132e-01
      8945    466_553872 1986      DomMc 9.776020e-01 -1.950212e-03 5.458508e-01
      8946    466_553872 1986 expShannon 1.329073e+00  4.060251e-03 9.032516e-01
      8947    466_553872 1990          S 8.000000e+00  3.640257e-02 7.536029e-01
      8948    466_553872 1990          N 1.273900e+04 -4.450321e+02 3.545213e-02
      8949    466_553872 1990       maxN 8.349000e+03 -3.769764e+02 1.108487e-02
      8950    466_553872 1990    Shannon 6.900586e-01  2.322580e-03 8.957016e-01
      8951    466_553872 1990    Simpson 4.569759e-01 -1.752855e-03 8.806971e-01
      8952    466_553872 1990 invSimpson 1.841539e+00 -4.487437e-03 8.609658e-01
      8953    466_553872 1990        PIE 4.570118e-01 -1.751229e-03 8.808132e-01
      8954    466_553872 1990      DomMc 9.922286e-01 -1.950212e-03 5.458508e-01
      8955    466_553872 1990 expShannon 1.993832e+00  4.060251e-03 9.032516e-01
      8956    466_553872 1993          S 9.000000e+00  3.640257e-02 7.536029e-01
      8957    466_553872 1993          N 1.043800e+04 -4.450321e+02 3.545213e-02
      8958    466_553872 1993       maxN 9.538000e+03 -3.769764e+02 1.108487e-02
      8959    466_553872 1993    Shannon 4.174066e-01  2.322580e-03 8.957016e-01
      8960    466_553872 1993    Simpson 1.628582e-01 -1.752855e-03 8.806971e-01
      8961    466_553872 1993 invSimpson 1.194541e+00 -4.487437e-03 8.609658e-01
      8962    466_553872 1993        PIE 1.628738e-01 -1.751229e-03 8.808132e-01
      8963    466_553872 1993      DomMc 9.517149e-01 -1.950212e-03 5.458508e-01
      8964    466_553872 1993 expShannon 1.518020e+00  4.060251e-03 9.032516e-01
      8965    466_553872 1996          S 9.000000e+00  3.640257e-02 7.536029e-01
      8966    466_553872 1996          N 9.255000e+03 -4.450321e+02 3.545213e-02
      8967    466_553872 1996       maxN 6.943000e+03 -3.769764e+02 1.108487e-02
      8968    466_553872 1996    Shannon 8.640439e-01  2.322580e-03 8.957016e-01
      8969    466_553872 1996    Simpson 4.145521e-01 -1.752855e-03 8.806971e-01
      8970    466_553872 1996 invSimpson 1.708094e+00 -4.487437e-03 8.609658e-01
      8971    466_553872 1996        PIE 4.145969e-01 -1.751229e-03 8.808132e-01
      8972    466_553872 1996      DomMc 8.687196e-01 -1.950212e-03 5.458508e-01
      8973    466_553872 1996 expShannon 2.372737e+00  4.060251e-03 9.032516e-01
      8974    466_549505 1989          S 1.100000e+01 -2.254374e-02 7.899428e-01
      8975    466_549505 1989          N 6.762000e+03 -9.271198e+01 8.129902e-01
      8976    466_549505 1989       maxN 6.563000e+03 -1.208449e+02 7.412665e-01
      8977    466_549505 1989    Shannon 1.810521e-01  3.915394e-02 7.517323e-02
      8978    466_549505 1989    Simpson 5.777462e-02  2.260190e-02 5.694035e-02
      8979    466_549505 1989 invSimpson 1.061317e+00  6.544324e-02 8.822239e-02
      8980    466_549505 1989        PIE 5.778317e-02  2.261291e-02 5.690625e-02
      8981    466_549505 1989      DomMc 9.819580e-01 -8.679368e-03 1.416694e-01
      8982    466_549505 1989 expShannon 1.198478e+00  8.657664e-02 8.815155e-02
      8983    466_549505 1996          S 1.200000e+01 -2.254374e-02 7.899428e-01
      8984    466_549505 1996          N 9.694000e+03 -9.271198e+01 8.129902e-01
      8985    466_549505 1996       maxN 7.000000e+03 -1.208449e+02 7.412665e-01
      8986    466_549505 1996    Shannon 8.522895e-01  3.915394e-02 7.517323e-02
      8987    466_549505 1996    Simpson 4.410061e-01  2.260190e-02 5.694035e-02
      8988    466_549505 1996 invSimpson 1.788928e+00  6.544324e-02 8.822239e-02
      8989    466_549505 1996        PIE 4.410516e-01  2.261291e-02 5.690625e-02
      8990    466_549505 1996      DomMc 9.003507e-01 -8.679368e-03 1.416694e-01
      8991    466_549505 1996 expShannon 2.345010e+00  8.657664e-02 8.815155e-02
      8992    466_549505 1997          S 1.100000e+01 -2.254374e-02 7.899428e-01
      8993    466_549505 1997          N 3.294000e+03 -9.271198e+01 8.129902e-01
      8994    466_549505 1997       maxN 1.639000e+03 -1.208449e+02 7.412665e-01
      8995    466_549505 1997    Shannon 1.374390e+00  3.915394e-02 7.517323e-02
      8996    466_549505 1997    Simpson 6.766191e-01  2.260190e-02 5.694035e-02
      8997    466_549505 1997 invSimpson 3.092328e+00  6.544324e-02 8.822239e-02
      8998    466_549505 1997        PIE 6.768245e-01  2.261291e-02 5.690625e-02
      8999    466_549505 1997      DomMc 6.863995e-01 -8.679368e-03 1.416694e-01
      9000    466_549505 1997 expShannon 3.952666e+00  8.657664e-02 8.815155e-02
      9001    466_549505 2007          S 1.200000e+01 -2.254374e-02 7.899428e-01
      9002    466_549505 2007          N 1.288000e+03 -9.271198e+01 8.129902e-01
      9003    466_549505 2007       maxN 7.830000e+02 -1.208449e+02 7.412665e-01
      9004    466_549505 2007    Shannon 1.131278e+00  3.915394e-02 7.517323e-02
      9005    466_549505 2007    Simpson 5.692826e-01  2.260190e-02 5.694035e-02
      9006    466_549505 2007 invSimpson 2.321708e+00  6.544324e-02 8.822239e-02
      9007    466_549505 2007        PIE 5.697250e-01  2.261291e-02 5.690625e-02
      9008    466_549505 2007      DomMc 8.159938e-01 -8.679368e-03 1.416694e-01
      9009    466_549505 2007 expShannon 3.099617e+00  8.657664e-02 8.815155e-02
      9010    466_549505 1994          S 1.000000e+01 -2.254374e-02 7.899428e-01
      9011    466_549505 1994          N 1.861300e+04 -9.271198e+01 8.129902e-01
      9012    466_549505 1994       maxN 1.691700e+04 -1.208449e+02 7.412665e-01
      9013    466_549505 1994    Shannon 4.022279e-01  3.915394e-02 7.517323e-02
      9014    466_549505 1994    Simpson 1.698079e-01  2.260190e-02 5.694035e-02
      9015    466_549505 1994 invSimpson 1.204541e+00  6.544324e-02 8.822239e-02
      9016    466_549505 1994        PIE 1.698171e-01  2.261291e-02 5.690625e-02
      9017    466_549505 1994      DomMc 9.709880e-01 -8.679368e-03 1.416694e-01
      9018    466_549505 1994 expShannon 1.495152e+00  8.657664e-02 8.815155e-02
      9019    466_549505 1993          S 1.100000e+01 -2.254374e-02 7.899428e-01
      9020    466_549505 1993          N 8.035000e+03 -9.271198e+01 8.129902e-01
      9021    466_549505 1993       maxN 7.071000e+03 -1.208449e+02 7.412665e-01
      9022    466_549505 1993    Shannon 4.679934e-01  3.915394e-02 7.517323e-02
      9023    466_549505 1993    Simpson 2.170689e-01  2.260190e-02 5.694035e-02
      9024    466_549505 1993 invSimpson 1.277252e+00  6.544324e-02 8.822239e-02
      9025    466_549505 1993        PIE 2.170959e-01  2.261291e-02 5.690625e-02
      9026    466_549505 1993      DomMc 9.695084e-01 -8.679368e-03 1.416694e-01
      9027    466_549505 1993 expShannon 1.596787e+00  8.657664e-02 8.815155e-02
      9028    466_549505 1995          S 1.200000e+01 -2.254374e-02 7.899428e-01
      9029    466_549505 1995          N 9.052000e+03 -9.271198e+01 8.129902e-01
      9030    466_549505 1995       maxN 6.340000e+03 -1.208449e+02 7.412665e-01
      9031    466_549505 1995    Shannon 8.993261e-01  3.915394e-02 7.517323e-02
      9032    466_549505 1995    Simpson 4.647754e-01  2.260190e-02 5.694035e-02
      9033    466_549505 1995 invSimpson 1.868375e+00  6.544324e-02 8.822239e-02
      9034    466_549505 1995        PIE 4.648268e-01  2.261291e-02 5.690625e-02
      9035    466_549505 1995      DomMc 8.986964e-01 -8.679368e-03 1.416694e-01
      9036    466_549505 1995 expShannon 2.457946e+00  8.657664e-02 8.815155e-02
      9037    466_549505 1999          S 9.000000e+00 -2.254374e-02 7.899428e-01
      9038    466_549505 1999          N 4.399000e+03 -9.271198e+01 8.129902e-01
      9039    466_549505 1999       maxN 2.650000e+03 -1.208449e+02 7.412665e-01
      9040    466_549505 1999    Shannon 1.049456e+00  3.915394e-02 7.517323e-02
      9041    466_549505 1999    Simpson 5.669850e-01  2.260190e-02 5.694035e-02
      9042    466_549505 1999 invSimpson 2.309389e+00  6.544324e-02 8.822239e-02
      9043    466_549505 1999        PIE 5.671139e-01  2.261291e-02 5.690625e-02
      9044    466_549505 1999      DomMc 7.897249e-01 -8.679368e-03 1.416694e-01
      9045    466_549505 1999 expShannon 2.856096e+00  8.657664e-02 8.815155e-02
      9046    466_549505 1990          S 1.100000e+01 -2.254374e-02 7.899428e-01
      9047    466_549505 1990          N 6.150000e+02 -9.271198e+01 8.129902e-01
      9048    466_549505 1990       maxN 5.250000e+02 -1.208449e+02 7.412665e-01
      9049    466_549505 1990    Shannon 6.885836e-01  3.915394e-02 7.517323e-02
      9050    466_549505 1990    Simpson 2.672801e-01  2.260190e-02 5.694035e-02
      9051    466_549505 1990 invSimpson 1.364778e+00  6.544324e-02 8.822239e-02
      9052    466_549505 1990        PIE 2.677154e-01  2.261291e-02 5.690625e-02
      9053    466_549505 1990      DomMc 8.943089e-01 -8.679368e-03 1.416694e-01
      9054    466_549505 1990 expShannon 1.990894e+00  8.657664e-02 8.815155e-02
      9055    466_549505 1992          S 1.000000e+01 -2.254374e-02 7.899428e-01
      9056    466_549505 1992          N 1.159000e+04 -9.271198e+01 8.129902e-01
      9057    466_549505 1992       maxN 9.811000e+03 -1.208449e+02 7.412665e-01
      9058    466_549505 1992    Shannon 5.376823e-01  3.915394e-02 7.517323e-02
      9059    466_549505 1992    Simpson 2.669149e-01  2.260190e-02 5.694035e-02
      9060    466_549505 1992 invSimpson 1.364098e+00  6.544324e-02 8.822239e-02
      9061    466_549505 1992        PIE 2.669380e-01  2.261291e-02 5.690625e-02
      9062    466_549505 1992      DomMc 9.743745e-01 -8.679368e-03 1.416694e-01
      9063    466_549505 1992 expShannon 1.712034e+00  8.657664e-02 8.815155e-02
      9064    466_549505 2001          S 8.000000e+00 -2.254374e-02 7.899428e-01
      9065    466_549505 2001          N 1.745900e+04 -9.271198e+01 8.129902e-01
      9066    466_549505 2001       maxN 1.568400e+04 -1.208449e+02 7.412665e-01
      9067    466_549505 2001    Shannon 4.173893e-01  3.915394e-02 7.517323e-02
      9068    466_549505 2001    Simpson 1.877372e-01  2.260190e-02 5.694035e-02
      9069    466_549505 2001 invSimpson 1.231129e+00  6.544324e-02 8.822239e-02
      9070    466_549505 2001        PIE 1.877479e-01  2.261291e-02 5.690625e-02
      9071    466_549505 2001      DomMc 9.648319e-01 -8.679368e-03 1.416694e-01
      9072    466_549505 2001 expShannon 1.517993e+00  8.657664e-02 8.815155e-02
      9073    466_551687 1989          S 1.100000e+01  1.032389e-01 1.326942e-01
      9074    466_551687 1989          N 4.543100e+04 -6.686987e+02 3.829424e-01
      9075    466_551687 1989       maxN 4.459600e+04 -6.795931e+02 3.814540e-01
      9076    466_551687 1989    Shannon 1.189676e-01  5.800959e-03 8.239849e-01
      9077    466_551687 1989    Simpson 3.632489e-02  3.893300e-03 7.825503e-01
      9078    466_551687 1989 invSimpson 1.037694e+00  9.348562e-03 8.594826e-01
      9079    466_551687 1989        PIE 3.632569e-02  3.894251e-03 7.826228e-01
      9080    466_551687 1989      DomMc 9.895226e-01  7.512327e-04 9.084889e-01
      9081    466_551687 1989 expShannon 1.126333e+00  9.085310e-03 8.880915e-01
      9082    466_551687 1997          S 1.100000e+01  1.032389e-01 1.326942e-01
      9083    466_551687 1997          N 1.200000e+03 -6.686987e+02 3.829424e-01
      9084    466_551687 1997       maxN 4.230000e+02 -6.795931e+02 3.814540e-01
      9085    466_551687 1997    Shannon 1.583465e+00  5.800959e-03 8.239849e-01
      9086    466_551687 1997    Simpson 7.441444e-01  3.893300e-03 7.825503e-01
      9087    466_551687 1997 invSimpson 3.908455e+00  9.348562e-03 8.594826e-01
      9088    466_551687 1997        PIE 7.447651e-01  3.894251e-03 7.826228e-01
      9089    466_551687 1997      DomMc 6.358333e-01  7.512327e-04 9.084889e-01
      9090    466_551687 1997 expShannon 4.871806e+00  9.085310e-03 8.880915e-01
      9091    466_551687 2007          S 1.200000e+01  1.032389e-01 1.326942e-01
      9092    466_551687 2007          N 1.158600e+04 -6.686987e+02 3.829424e-01
      9093    466_551687 2007       maxN 1.070000e+04 -6.795931e+02 3.814540e-01
      9094    466_551687 2007    Shannon 3.384742e-01  5.800959e-03 8.239849e-01
      9095    466_551687 2007    Simpson 1.440559e-01  3.893300e-03 7.825503e-01
      9096    466_551687 2007 invSimpson 1.168301e+00  9.348562e-03 8.594826e-01
      9097    466_551687 2007        PIE 1.440684e-01  3.894251e-03 7.826228e-01
      9098    466_551687 2007      DomMc 9.746245e-01  7.512327e-04 9.084889e-01
      9099    466_551687 2007 expShannon 1.402806e+00  9.085310e-03 8.880915e-01
      9100    466_551687 2001          S 1.000000e+01  1.032389e-01 1.326942e-01
      9101    466_551687 2001          N 4.342000e+03 -6.686987e+02 3.829424e-01
      9102    466_551687 2001       maxN 2.274000e+03 -6.795931e+02 3.814540e-01
      9103    466_551687 2001    Shannon 1.029307e+00  5.800959e-03 8.239849e-01
      9104    466_551687 2001    Simpson 5.834072e-01  3.893300e-03 7.825503e-01
      9105    466_551687 2001 invSimpson 2.400425e+00  9.348562e-03 8.594826e-01
      9106    466_551687 2001        PIE 5.835415e-01  3.894251e-03 7.826228e-01
      9107    466_551687 2001      DomMc 8.896822e-01  7.512327e-04 9.084889e-01
      9108    466_551687 2001 expShannon 2.799126e+00  9.085310e-03 8.880915e-01
      9109    466_551687 2006          S 1.200000e+01  1.032389e-01 1.326942e-01
      9110    466_551687 2006          N 2.633000e+03 -6.686987e+02 3.829424e-01
      9111    466_551687 2006       maxN 1.300000e+03 -6.795931e+02 3.814540e-01
      9112    466_551687 2006    Shannon 9.918890e-01  5.800959e-03 8.239849e-01
      9113    466_551687 2006    Simpson 5.604602e-01  3.893300e-03 7.825503e-01
      9114    466_551687 2006 invSimpson 2.275107e+00  9.348562e-03 8.594826e-01
      9115    466_551687 2006        PIE 5.606731e-01  3.894251e-03 7.826228e-01
      9116    466_551687 2006      DomMc 9.350551e-01  7.512327e-04 9.084889e-01
      9117    466_551687 2006 expShannon 2.696323e+00  9.085310e-03 8.880915e-01
      9118    466_551687 1988          S 1.000000e+01  1.032389e-01 1.326942e-01
      9119    466_551687 1988          N 2.518000e+03 -6.686987e+02 3.829424e-01
      9120    466_551687 1988       maxN 1.365000e+03 -6.795931e+02 3.814540e-01
      9121    466_551687 1988    Shannon 1.094470e+00  5.800959e-03 8.239849e-01
      9122    466_551687 1988    Simpson 5.842525e-01  3.893300e-03 7.825503e-01
      9123    466_551687 1988 invSimpson 2.405306e+00  9.348562e-03 8.594826e-01
      9124    466_551687 1988        PIE 5.844846e-01  3.894251e-03 7.826228e-01
      9125    466_551687 1988      DomMc 8.840349e-01  7.512327e-04 9.084889e-01
      9126    466_551687 1988 expShannon 2.987600e+00  9.085310e-03 8.880915e-01
      9127    466_551687 1992          S 1.000000e+01  1.032389e-01 1.326942e-01
      9128    466_551687 1992          N 1.109500e+04 -6.686987e+02 3.829424e-01
      9129    466_551687 1992       maxN 9.830000e+03 -6.795931e+02 3.814540e-01
      9130    466_551687 1992    Shannon 4.176160e-01  5.800959e-03 8.239849e-01
      9131    466_551687 1992    Simpson 2.049913e-01  3.893300e-03 7.825503e-01
      9132    466_551687 1992 invSimpson 1.257848e+00  9.348562e-03 8.594826e-01
      9133    466_551687 1992        PIE 2.050098e-01  3.894251e-03 7.826228e-01
      9134    466_551687 1992      DomMc 9.858495e-01  7.512327e-04 9.084889e-01
      9135    466_551687 1992 expShannon 1.518337e+00  9.085310e-03 8.880915e-01
      9136    466_551687 1993          S 9.000000e+00  1.032389e-01 1.326942e-01
      9137    466_551687 1993          N 2.811000e+03 -6.686987e+02 3.829424e-01
      9138    466_551687 1993       maxN 2.123000e+03 -6.795931e+02 3.814540e-01
      9139    466_551687 1993    Shannon 8.061718e-01  5.800959e-03 8.239849e-01
      9140    466_551687 1993    Simpson 4.036832e-01  3.893300e-03 7.825503e-01
      9141    466_551687 1993 invSimpson 1.676961e+00  9.348562e-03 8.594826e-01
      9142    466_551687 1993        PIE 4.038269e-01  3.894251e-03 7.826228e-01
      9143    466_551687 1993      DomMc 8.754891e-01  7.512327e-04 9.084889e-01
      9144    466_551687 1993 expShannon 2.239319e+00  9.085310e-03 8.880915e-01
      9145    466_551687 1995          S 8.000000e+00  1.032389e-01 1.326942e-01
      9146    466_551687 1995          N 4.408000e+03 -6.686987e+02 3.829424e-01
      9147    466_551687 1995       maxN 1.769000e+03 -6.795931e+02 3.814540e-01
      9148    466_551687 1995    Shannon 1.128474e+00  5.800959e-03 8.239849e-01
      9149    466_551687 1995    Simpson 6.547296e-01  3.893300e-03 7.825503e-01
      9150    466_551687 1995 invSimpson 2.896281e+00  9.348562e-03 8.594826e-01
      9151    466_551687 1995        PIE 6.548782e-01  3.894251e-03 7.826228e-01
      9152    466_551687 1995      DomMc 7.695100e-01  7.512327e-04 9.084889e-01
      9153    466_551687 1995 expShannon 3.090937e+00  9.085310e-03 8.880915e-01
      9154    466_550229 1989          S 1.100000e+01 -1.748858e-01 8.059742e-02
      9155    466_550229 1989          N 1.943000e+03  6.481015e+01 4.151235e-01
      9156    466_550229 1989       maxN 1.497000e+03  8.786104e+01 2.094360e-01
      9157    466_550229 1989    Shannon 9.008062e-01 -1.126299e-02 4.224749e-01
      9158    466_550229 1989    Simpson 3.904601e-01 -4.411711e-03 5.670798e-01
      9159    466_550229 1989 invSimpson 1.640582e+00 -5.219432e-03 8.311649e-01
      9160    466_550229 1989        PIE 3.906611e-01 -4.403003e-03 5.681554e-01
      9161    466_550229 1989      DomMc 8.857437e-01  1.437494e-03 6.774772e-01
      9162    466_550229 1989 expShannon 2.461587e+00 -1.879327e-02 5.497763e-01
      9163    466_550229 1993          S 1.500000e+01 -1.748858e-01 8.059742e-02
      9164    466_550229 1993          N 5.137000e+03  6.481015e+01 4.151235e-01
      9165    466_550229 1993       maxN 2.625000e+03  8.786104e+01 2.094360e-01
      9166    466_550229 1993    Shannon 1.144079e+00 -1.126299e-02 4.224749e-01
      9167    466_550229 1993    Simpson 6.139255e-01 -4.411711e-03 5.670798e-01
      9168    466_550229 1993 invSimpson 2.590174e+00 -5.219432e-03 8.311649e-01
      9169    466_550229 1993        PIE 6.140450e-01 -4.403003e-03 5.681554e-01
      9170    466_550229 1993      DomMc 8.405684e-01  1.437494e-03 6.774772e-01
      9171    466_550229 1993 expShannon 3.139550e+00 -1.879327e-02 5.497763e-01
      9172    466_550229 1996          S 1.400000e+01 -1.748858e-01 8.059742e-02
      9173    466_550229 1996          N 4.411000e+03  6.481015e+01 4.151235e-01
      9174    466_550229 1996       maxN 2.747000e+03  8.786104e+01 2.094360e-01
      9175    466_550229 1996    Shannon 1.161074e+00 -1.126299e-02 4.224749e-01
      9176    466_550229 1996    Simpson 5.623604e-01 -4.411711e-03 5.670798e-01
      9177    466_550229 1996 invSimpson 2.284985e+00 -5.219432e-03 8.311649e-01
      9178    466_550229 1996        PIE 5.624879e-01 -4.403003e-03 5.681554e-01
      9179    466_550229 1996      DomMc 7.973249e-01  1.437494e-03 6.774772e-01
      9180    466_550229 1996 expShannon 3.193360e+00 -1.879327e-02 5.497763e-01
      9181    466_550229 2003          S 1.000000e+01 -1.748858e-01 8.059742e-02
      9182    466_550229 2003          N 5.308000e+03  6.481015e+01 4.151235e-01
      9183    466_550229 2003       maxN 4.188000e+03  8.786104e+01 2.094360e-01
      9184    466_550229 2003    Shannon 5.823641e-01 -1.126299e-02 4.224749e-01
      9185    466_550229 2003    Simpson 3.380136e-01 -4.411711e-03 5.670798e-01
      9186    466_550229 2003 invSimpson 1.510605e+00 -5.219432e-03 8.311649e-01
      9187    466_550229 2003        PIE 3.380773e-01 -4.403003e-03 5.681554e-01
      9188    466_550229 2003      DomMc 9.875659e-01  1.437494e-03 6.774772e-01
      9189    466_550229 2003 expShannon 1.790266e+00 -1.879327e-02 5.497763e-01
      9190    466_550229 2007          S 8.000000e+00 -1.748858e-01 8.059742e-02
      9191    466_550229 2007          N 6.523000e+03  6.481015e+01 4.151235e-01
      9192    466_550229 2007       maxN 6.307000e+03  8.786104e+01 2.094360e-01
      9193    466_550229 2007    Shannon 1.806814e-01 -1.126299e-02 4.224749e-01
      9194    466_550229 2007    Simpson 6.467493e-02 -4.411711e-03 5.670798e-01
      9195    466_550229 2007 invSimpson 1.069147e+00 -5.219432e-03 8.311649e-01
      9196    466_550229 2007        PIE 6.468485e-02 -4.403003e-03 5.681554e-01
      9197    466_550229 2007      DomMc 9.828300e-01  1.437494e-03 6.774772e-01
      9198    466_550229 2007 expShannon 1.198033e+00 -1.879327e-02 5.497763e-01
      9199    466_550229 1992          S 1.100000e+01 -1.748858e-01 8.059742e-02
      9200    466_550229 1992          N 3.253000e+03  6.481015e+01 4.151235e-01
      9201    466_550229 1992       maxN 2.439000e+03  8.786104e+01 2.094360e-01
      9202    466_550229 1992    Shannon 6.789259e-01 -1.126299e-02 4.224749e-01
      9203    466_550229 1992    Simpson 3.857218e-01 -4.411711e-03 5.670798e-01
      9204    466_550229 1992 invSimpson 1.627927e+00 -5.219432e-03 8.311649e-01
      9205    466_550229 1992        PIE 3.858405e-01 -4.403003e-03 5.681554e-01
      9206    466_550229 1992      DomMc 9.778666e-01  1.437494e-03 6.774772e-01
      9207    466_550229 1992 expShannon 1.971759e+00 -1.879327e-02 5.497763e-01
      9208    466_550229 2005          S 1.100000e+01 -1.748858e-01 8.059742e-02
      9209    466_550229 2005          N 2.685000e+03  6.481015e+01 4.151235e-01
      9210    466_550229 2005       maxN 2.172000e+03  8.786104e+01 2.094360e-01
      9211    466_550229 2005    Shannon 6.840646e-01 -1.126299e-02 4.224749e-01
      9212    466_550229 2005    Simpson 3.257648e-01 -4.411711e-03 5.670798e-01
      9213    466_550229 2005 invSimpson 1.483162e+00 -5.219432e-03 8.311649e-01
      9214    466_550229 2005        PIE 3.258862e-01 -4.403003e-03 5.681554e-01
      9215    466_550229 2005      DomMc 9.471136e-01  1.437494e-03 6.774772e-01
      9216    466_550229 2005 expShannon 1.981917e+00 -1.879327e-02 5.497763e-01
      9217    466_550229 2001          S 8.000000e+00 -1.748858e-01 8.059742e-02
      9218    466_550229 2001          N 3.821000e+03  6.481015e+01 4.151235e-01
      9219    466_550229 2001       maxN 2.264000e+03  8.786104e+01 2.094360e-01
      9220    466_550229 2001    Shannon 8.098233e-01 -1.126299e-02 4.224749e-01
      9221    466_550229 2001    Simpson 5.040623e-01 -4.411711e-03 5.670798e-01
      9222    466_550229 2001 invSimpson 2.016382e+00 -5.219432e-03 8.311649e-01
      9223    466_550229 2001        PIE 5.041942e-01 -4.403003e-03 5.681554e-01
      9224    466_550229 2001      DomMc 9.727820e-01  1.437494e-03 6.774772e-01
      9225    466_550229 2001 expShannon 2.247511e+00 -1.879327e-02 5.497763e-01
      9226    466_550229 2006          S 1.100000e+01 -1.748858e-01 8.059742e-02
      9227    466_550229 2006          N 4.758000e+03  6.481015e+01 4.151235e-01
      9228    466_550229 2006       maxN 3.836000e+03  8.786104e+01 2.094360e-01
      9229    466_550229 2006    Shannon 5.883648e-01 -1.126299e-02 4.224749e-01
      9230    466_550229 2006    Simpson 3.199393e-01 -4.411711e-03 5.670798e-01
      9231    466_550229 2006 invSimpson 1.470457e+00 -5.219432e-03 8.311649e-01
      9232    466_550229 2006        PIE 3.200065e-01 -4.403003e-03 5.681554e-01
      9233    466_550229 2006      DomMc 9.791929e-01  1.437494e-03 6.774772e-01
      9234    466_550229 2006 expShannon 1.801041e+00 -1.879327e-02 5.497763e-01
      9235    466_550229 1990          S 1.000000e+01 -1.748858e-01 8.059742e-02
      9236    466_550229 1990          N 1.437000e+03  6.481015e+01 4.151235e-01
      9237    466_550229 1990       maxN 1.214000e+03  8.786104e+01 2.094360e-01
      9238    466_550229 1990    Shannon 5.758078e-01 -1.126299e-02 4.224749e-01
      9239    466_550229 1990    Simpson 2.718094e-01 -4.411711e-03 5.670798e-01
      9240    466_550229 1990 invSimpson 1.373267e+00 -5.219432e-03 8.311649e-01
      9241    466_550229 1990        PIE 2.719987e-01 -4.403003e-03 5.681554e-01
      9242    466_550229 1990      DomMc 9.638135e-01  1.437494e-03 6.774772e-01
      9243    466_550229 1990 expShannon 1.778567e+00 -1.879327e-02 5.497763e-01
      9244    466_550229 1997          S 1.000000e+01 -1.748858e-01 8.059742e-02
      9245    466_550229 1997          N 3.297000e+03  6.481015e+01 4.151235e-01
      9246    466_550229 1997       maxN 1.954000e+03  8.786104e+01 2.094360e-01
      9247    466_550229 1997    Shannon 1.004380e+00 -1.126299e-02 4.224749e-01
      9248    466_550229 1997    Simpson 5.535687e-01 -4.411711e-03 5.670798e-01
      9249    466_550229 1997 invSimpson 2.239987e+00 -5.219432e-03 8.311649e-01
      9250    466_550229 1997        PIE 5.537367e-01 -4.403003e-03 5.681554e-01
      9251    466_550229 1997      DomMc 8.865635e-01  1.437494e-03 6.774772e-01
      9252    466_550229 1997 expShannon 2.730213e+00 -1.879327e-02 5.497763e-01
      9253    466_550229 2008          S 7.000000e+00 -1.748858e-01 8.059742e-02
      9254    466_550229 2008          N 6.650000e+02  6.481015e+01 4.151235e-01
      9255    466_550229 2008       maxN 3.430000e+02  8.786104e+01 2.094360e-01
      9256    466_550229 2008    Shannon 1.214539e+00 -1.126299e-02 4.224749e-01
      9257    466_550229 2008    Simpson 6.344237e-01 -4.411711e-03 5.670798e-01
      9258    466_550229 2008 invSimpson 2.735407e+00 -5.219432e-03 8.311649e-01
      9259    466_550229 2008        PIE 6.353791e-01 -4.403003e-03 5.681554e-01
      9260    466_550229 2008      DomMc 7.924812e-01  1.437494e-03 6.774772e-01
      9261    466_550229 2008 expShannon 3.368740e+00 -1.879327e-02 5.497763e-01
      9262    466_549503 1989          S 1.100000e+01 -1.368098e-01 6.147519e-02
      9263    466_549503 1989          N 1.834000e+03 -1.274172e+01 9.161711e-01
      9264    466_549503 1989       maxN 1.420000e+03  2.190859e+01 8.413171e-01
      9265    466_549503 1989    Shannon 8.203591e-01 -1.909177e-02 2.043541e-01
      9266    466_549503 1989    Simpson 3.819725e-01 -6.129572e-03 3.882303e-01
      9267    466_549503 1989 invSimpson 1.618051e+00 -3.471984e-02 3.289673e-01
      9268    466_549503 1989        PIE 3.821809e-01 -6.120899e-03 3.892619e-01
      9269    466_549503 1989      DomMc 8.778626e-01  9.170476e-03 5.676115e-02
      9270    466_549503 1989 expShannon 2.271315e+00 -5.937710e-02 1.983831e-01
      9271    466_549503 1990          S 1.300000e+01 -1.368098e-01 6.147519e-02
      9272    466_549503 1990          N 2.073000e+03 -1.274172e+01 9.161711e-01
      9273    466_549503 1990       maxN 8.910000e+02  2.190859e+01 8.413171e-01
      9274    466_549503 1990    Shannon 1.701017e+00 -1.909177e-02 2.043541e-01
      9275    466_549503 1990    Simpson 7.507910e-01 -6.129572e-03 3.882303e-01
      9276    466_549503 1990 invSimpson 4.012696e+00 -3.471984e-02 3.289673e-01
      9277    466_549503 1990        PIE 7.511534e-01 -6.120899e-03 3.892619e-01
      9278    466_549503 1990      DomMc 6.034732e-01  9.170476e-03 5.676115e-02
      9279    466_549503 1990 expShannon 5.479520e+00 -5.937710e-02 1.983831e-01
      9280    466_549503 1994          S 1.100000e+01 -1.368098e-01 6.147519e-02
      9281    466_549503 1994          N 3.998000e+03 -1.274172e+01 9.161711e-01
      9282    466_549503 1994       maxN 2.874000e+03  2.190859e+01 8.413171e-01
      9283    466_549503 1994    Shannon 8.642116e-01 -1.909177e-02 2.043541e-01
      9284    466_549503 1994    Simpson 4.476402e-01 -6.129572e-03 3.882303e-01
      9285    466_549503 1994 invSimpson 1.810414e+00 -3.471984e-02 3.289673e-01
      9286    466_549503 1994        PIE 4.477521e-01 -6.120899e-03 3.892619e-01
      9287    466_549503 1994      DomMc 8.644322e-01  9.170476e-03 5.676115e-02
      9288    466_549503 1994 expShannon 2.373134e+00 -5.937710e-02 1.983831e-01
      9289    466_549503 2001          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9290    466_549503 2001          N 1.364000e+03 -1.274172e+01 9.161711e-01
      9291    466_549503 2001       maxN 7.470000e+02  2.190859e+01 8.413171e-01
      9292    466_549503 2001    Shannon 1.105591e+00 -1.909177e-02 2.043541e-01
      9293    466_549503 2001    Simpson 5.862179e-01 -6.129572e-03 3.882303e-01
      9294    466_549503 2001 invSimpson 2.416731e+00 -3.471984e-02 3.289673e-01
      9295    466_549503 2001        PIE 5.866480e-01 -6.120899e-03 3.892619e-01
      9296    466_549503 2001      DomMc 8.768328e-01  9.170476e-03 5.676115e-02
      9297    466_549503 2001 expShannon 3.021011e+00 -5.937710e-02 1.983831e-01
      9298    466_549503 2003          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9299    466_549503 2003          N 1.669000e+03 -1.274172e+01 9.161711e-01
      9300    466_549503 2003       maxN 1.260000e+03  2.190859e+01 8.413171e-01
      9301    466_549503 2003    Shannon 7.040363e-01 -1.909177e-02 2.043541e-01
      9302    466_549503 2003    Simpson 3.852093e-01 -6.129572e-03 3.882303e-01
      9303    466_549503 2003 invSimpson 1.626570e+00 -3.471984e-02 3.289673e-01
      9304    466_549503 2003        PIE 3.854402e-01 -6.120899e-03 3.892619e-01
      9305    466_549503 2003      DomMc 9.658478e-01  9.170476e-03 5.676115e-02
      9306    466_549503 2003 expShannon 2.021897e+00 -5.937710e-02 1.983831e-01
      9307    466_549503 1993          S 8.000000e+00 -1.368098e-01 6.147519e-02
      9308    466_549503 1993          N 3.899000e+03 -1.274172e+01 9.161711e-01
      9309    466_549503 1993       maxN 2.768000e+03  2.190859e+01 8.413171e-01
      9310    466_549503 1993    Shannon 8.556797e-01 -1.909177e-02 2.043541e-01
      9311    466_549503 1993    Simpson 4.570251e-01 -6.129572e-03 3.882303e-01
      9312    466_549503 1993 invSimpson 1.841706e+00 -3.471984e-02 3.289673e-01
      9313    466_549503 1993        PIE 4.571424e-01 -6.120899e-03 3.892619e-01
      9314    466_549503 1993      DomMc 8.499615e-01  9.170476e-03 5.676115e-02
      9315    466_549503 1993 expShannon 2.352973e+00 -5.937710e-02 1.983831e-01
      9316    466_549503 1996          S 1.300000e+01 -1.368098e-01 6.147519e-02
      9317    466_549503 1996          N 4.845000e+03 -1.274172e+01 9.161711e-01
      9318    466_549503 1996       maxN 1.947000e+03  2.190859e+01 8.413171e-01
      9319    466_549503 1996    Shannon 1.425908e+00 -1.909177e-02 2.043541e-01
      9320    466_549503 1996    Simpson 7.176658e-01 -6.129572e-03 3.882303e-01
      9321    466_549503 1996 invSimpson 3.541902e+00 -3.471984e-02 3.289673e-01
      9322    466_549503 1996        PIE 7.178140e-01 -6.120899e-03 3.892619e-01
      9323    466_549503 1996      DomMc 6.474716e-01  9.170476e-03 5.676115e-02
      9324    466_549503 1996 expShannon 4.161633e+00 -5.937710e-02 1.983831e-01
      9325    466_549503 1991          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9326    466_549503 1991          N 3.059000e+03 -1.274172e+01 9.161711e-01
      9327    466_549503 1991       maxN 1.683000e+03  2.190859e+01 8.413171e-01
      9328    466_549503 1991    Shannon 1.338054e+00 -1.909177e-02 2.043541e-01
      9329    466_549503 1991    Simpson 6.385310e-01 -6.129572e-03 3.882303e-01
      9330    466_549503 1991 invSimpson 2.766489e+00 -3.471984e-02 3.289673e-01
      9331    466_549503 1991        PIE 6.387398e-01 -6.120899e-03 3.892619e-01
      9332    466_549503 1991      DomMc 7.234390e-01  9.170476e-03 5.676115e-02
      9333    466_549503 1991 expShannon 3.811617e+00 -5.937710e-02 1.983831e-01
      9334    466_549503 1999          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9335    466_549503 1999          N 3.446000e+03 -1.274172e+01 9.161711e-01
      9336    466_549503 1999       maxN 2.260000e+03  2.190859e+01 8.413171e-01
      9337    466_549503 1999    Shannon 9.328534e-01 -1.909177e-02 2.043541e-01
      9338    466_549503 1999    Simpson 5.026284e-01 -6.129572e-03 3.882303e-01
      9339    466_549503 1999 invSimpson 2.010569e+00 -3.471984e-02 3.289673e-01
      9340    466_549503 1999        PIE 5.027743e-01 -6.120899e-03 3.892619e-01
      9341    466_549503 1999      DomMc 9.045270e-01  9.170476e-03 5.676115e-02
      9342    466_549503 1999 expShannon 2.541752e+00 -5.937710e-02 1.983831e-01
      9343    466_549503 2005          S 8.000000e+00 -1.368098e-01 6.147519e-02
      9344    466_549503 2005          N 7.740000e+02 -1.274172e+01 9.161711e-01
      9345    466_549503 2005       maxN 3.900000e+02  2.190859e+01 8.413171e-01
      9346    466_549503 2005    Shannon 1.198760e+00 -1.909177e-02 2.043541e-01
      9347    466_549503 2005    Simpson 6.181853e-01 -6.129572e-03 3.882303e-01
      9348    466_549503 2005 invSimpson 2.619072e+00 -3.471984e-02 3.289673e-01
      9349    466_549503 2005        PIE 6.189851e-01 -6.120899e-03 3.892619e-01
      9350    466_549503 2005      DomMc 8.527132e-01  9.170476e-03 5.676115e-02
      9351    466_549503 2005 expShannon 3.316002e+00 -5.937710e-02 1.983831e-01
      9352    466_549503 1992          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9353    466_549503 1992          N 6.575000e+03 -1.274172e+01 9.161711e-01
      9354    466_549503 1992       maxN 5.554000e+03  2.190859e+01 8.413171e-01
      9355    466_549503 1992    Shannon 5.972247e-01 -1.909177e-02 2.043541e-01
      9356    466_549503 1992    Simpson 2.738284e-01 -6.129572e-03 3.882303e-01
      9357    466_549503 1992 invSimpson 1.377085e+00 -3.471984e-02 3.289673e-01
      9358    466_549503 1992        PIE 2.738700e-01 -6.120899e-03 3.892619e-01
      9359    466_549503 1992      DomMc 9.549810e-01  9.170476e-03 5.676115e-02
      9360    466_549503 1992 expShannon 1.817069e+00 -5.937710e-02 1.983831e-01
      9361    466_549503 1995          S 1.000000e+01 -1.368098e-01 6.147519e-02
      9362    466_549503 1995          N 9.077000e+03 -1.274172e+01 9.161711e-01
      9363    466_549503 1995       maxN 7.250000e+03  2.190859e+01 8.413171e-01
      9364    466_549503 1995    Shannon 6.737300e-01 -1.909177e-02 2.043541e-01
      9365    466_549503 1995    Simpson 3.398055e-01 -6.129572e-03 3.882303e-01
      9366    466_549503 1995 invSimpson 1.514705e+00 -3.471984e-02 3.289673e-01
      9367    466_549503 1995        PIE 3.398430e-01 -6.120899e-03 3.892619e-01
      9368    466_549503 1995      DomMc 9.395175e-01  9.170476e-03 5.676115e-02
      9369    466_549503 1995 expShannon 1.961540e+00 -5.937710e-02 1.983831e-01
      9370    466_549503 1997          S 7.000000e+00 -1.368098e-01 6.147519e-02
      9371    466_549503 1997          N 3.137000e+03 -1.274172e+01 9.161711e-01
      9372    466_549503 1997       maxN 2.171000e+03  2.190859e+01 8.413171e-01
      9373    466_549503 1997    Shannon 9.436513e-01 -1.909177e-02 2.043541e-01
      9374    466_549503 1997    Simpson 4.770107e-01 -6.129572e-03 3.882303e-01
      9375    466_549503 1997 invSimpson 1.912085e+00 -3.471984e-02 3.289673e-01
      9376    466_549503 1997        PIE 4.771628e-01 -6.120899e-03 3.892619e-01
      9377    466_549503 1997      DomMc 8.881097e-01  9.170476e-03 5.676115e-02
      9378    466_549503 1997 expShannon 2.569346e+00 -5.937710e-02 1.983831e-01
      9379    466_549503 2007          S 9.000000e+00 -1.368098e-01 6.147519e-02
      9380    466_549503 2007          N 9.418000e+03 -1.274172e+01 9.161711e-01
      9381    466_549503 2007       maxN 8.412000e+03  2.190859e+01 8.413171e-01
      9382    466_549503 2007    Shannon 4.171873e-01 -1.909177e-02 2.043541e-01
      9383    466_549503 2007    Simpson 1.948526e-01 -6.129572e-03 3.882303e-01
      9384    466_549503 2007 invSimpson 1.242009e+00 -3.471984e-02 3.289673e-01
      9385    466_549503 2007        PIE 1.948733e-01 -6.120899e-03 3.892619e-01
      9386    466_549503 2007      DomMc 9.777023e-01  9.170476e-03 5.676115e-02
      9387    466_549503 2007 expShannon 1.517687e+00 -5.937710e-02 1.983831e-01
      9388    466_549503 2008          S 8.000000e+00 -1.368098e-01 6.147519e-02
      9389    466_549503 2008          N 1.850000e+03 -1.274172e+01 9.161711e-01
      9390    466_549503 2008       maxN 1.351000e+03  2.190859e+01 8.413171e-01
      9391    466_549503 2008    Shannon 7.642323e-01 -1.909177e-02 2.043541e-01
      9392    466_549503 2008    Simpson 4.173066e-01 -6.129572e-03 3.882303e-01
      9393    466_549503 2008 invSimpson 1.716169e+00 -3.471984e-02 3.289673e-01
      9394    466_549503 2008        PIE 4.175323e-01 -6.120899e-03 3.892619e-01
      9395    466_549503 2008      DomMc 9.497297e-01  9.170476e-03 5.676115e-02
      9396    466_549503 2008 expShannon 2.147345e+00 -5.937710e-02 1.983831e-01
      9397    466_553873 1989          S 1.000000e+01 -9.512625e-02 3.848880e-01
      9398    466_553873 1989          N 5.152000e+03 -2.774686e+02 2.782647e-01
      9399    466_553873 1989       maxN 4.904000e+03 -2.826514e+02 2.138599e-01
      9400    466_553873 1989    Shannon 2.652091e-01  2.794148e-02 2.648997e-02
      9401    466_553873 1989    Simpson 9.329836e-02  1.537415e-02 4.407034e-02
      9402    466_553873 1989 invSimpson 1.102899e+00  3.845912e-02 6.645414e-02
      9403    466_553873 1989        PIE 9.331647e-02  1.538171e-02 4.400217e-02
      9404    466_553873 1989      DomMc 9.722438e-01 -4.014669e-03 1.333440e-02
      9405    466_553873 1989 expShannon 1.303703e+00  5.513184e-02 3.725340e-02
      9406    466_553873 1990          S 1.300000e+01 -9.512625e-02 3.848880e-01
      9407    466_553873 1990          N 6.883000e+03 -2.774686e+02 2.782647e-01
      9408    466_553873 1990       maxN 6.162000e+03 -2.826514e+02 2.138599e-01
      9409    466_553873 1990    Shannon 4.404607e-01  2.794148e-02 2.648997e-02
      9410    466_553873 1990    Simpson 1.921438e-01  1.537415e-02 4.407034e-02
      9411    466_553873 1990 invSimpson 1.237844e+00  3.845912e-02 6.645414e-02
      9412    466_553873 1990        PIE 1.921717e-01  1.538171e-02 4.400217e-02
      9413    466_553873 1990      DomMc 9.742845e-01 -4.014669e-03 1.333440e-02
      9414    466_553873 1990 expShannon 1.553423e+00  5.513184e-02 3.725340e-02
      9415    466_553873 1991          S 1.100000e+01 -9.512625e-02 3.848880e-01
      9416    466_553873 1991          N 3.342000e+03 -2.774686e+02 2.782647e-01
      9417    466_553873 1991       maxN 3.096000e+03 -2.826514e+02 2.138599e-01
      9418    466_553873 1991    Shannon 3.475864e-01  2.794148e-02 2.648997e-02
      9419    466_553873 1991    Simpson 1.390980e-01  1.537415e-02 4.407034e-02
      9420    466_553873 1991 invSimpson 1.161572e+00  3.845912e-02 6.645414e-02
      9421    466_553873 1991        PIE 1.391396e-01  1.538171e-02 4.400217e-02
      9422    466_553873 1991      DomMc 9.772591e-01 -4.014669e-03 1.333440e-02
      9423    466_553873 1991 expShannon 1.415647e+00  5.513184e-02 3.725340e-02
      9424    466_553873 2006          S 1.400000e+01 -9.512625e-02 3.848880e-01
      9425    466_553873 2006          N 3.641000e+03 -2.774686e+02 2.782647e-01
      9426    466_553873 2006       maxN 2.051000e+03 -2.826514e+02 2.138599e-01
      9427    466_553873 2006    Shannon 1.161286e+00  2.794148e-02 2.648997e-02
      9428    466_553873 2006    Simpson 5.922643e-01  1.537415e-02 4.407034e-02
      9429    466_553873 2006 invSimpson 2.452569e+00  3.845912e-02 6.645414e-02
      9430    466_553873 2006        PIE 5.924271e-01  1.538171e-02 4.400217e-02
      9431    466_553873 2006      DomMc 8.478440e-01 -4.014669e-03 1.333440e-02
      9432    466_553873 2006 expShannon 3.194040e+00  5.513184e-02 3.725340e-02
      9433    466_553873 2003          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9434    466_553873 2003          N 1.674000e+03 -2.774686e+02 2.782647e-01
      9435    466_553873 2003       maxN 1.538000e+03 -2.826514e+02 2.138599e-01
      9436    466_553873 2003    Shannon 3.970152e-01  2.794148e-02 2.648997e-02
      9437    466_553873 2003    Simpson 1.537993e-01  1.537415e-02 4.407034e-02
      9438    466_553873 2003 invSimpson 1.181753e+00  3.845912e-02 6.645414e-02
      9439    466_553873 2003        PIE 1.538912e-01  1.538171e-02 4.400217e-02
      9440    466_553873 2003      DomMc 9.563919e-01 -4.014669e-03 1.333440e-02
      9441    466_553873 2003 expShannon 1.487379e+00  5.513184e-02 3.725340e-02
      9442    466_553873 2005          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9443    466_553873 2005          N 2.940000e+03 -2.774686e+02 2.782647e-01
      9444    466_553873 2005       maxN 2.387000e+03 -2.826514e+02 2.138599e-01
      9445    466_553873 2005    Shannon 7.281869e-01  2.794148e-02 2.648997e-02
      9446    466_553873 2005    Simpson 3.282320e-01  1.537415e-02 4.407034e-02
      9447    466_553873 2005 invSimpson 1.488609e+00  3.845912e-02 6.645414e-02
      9448    466_553873 2005        PIE 3.283437e-01  1.538171e-02 4.400217e-02
      9449    466_553873 2005      DomMc 9.136054e-01 -4.014669e-03 1.333440e-02
      9450    466_553873 2005 expShannon 2.071322e+00  5.513184e-02 3.725340e-02
      9451    466_553873 1995          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9452    466_553873 1995          N 1.363100e+04 -2.774686e+02 2.782647e-01
      9453    466_553873 1995       maxN 1.019000e+04 -2.826514e+02 2.138599e-01
      9454    466_553873 1995    Shannon 8.087471e-01  2.794148e-02 2.648997e-02
      9455    466_553873 1995    Simpson 4.087724e-01  1.537415e-02 4.407034e-02
      9456    466_553873 1995 invSimpson 1.691396e+00  3.845912e-02 6.645414e-02
      9457    466_553873 1995        PIE 4.088024e-01  1.538171e-02 4.400217e-02
      9458    466_553873 1995      DomMc 9.202553e-01 -4.014669e-03 1.333440e-02
      9459    466_553873 1995 expShannon 2.245093e+00  5.513184e-02 3.725340e-02
      9460    466_553873 1997          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9461    466_553873 1997          N 1.819100e+04 -2.774686e+02 2.782647e-01
      9462    466_553873 1997       maxN 1.679900e+04 -2.826514e+02 2.138599e-01
      9463    466_553873 1997    Shannon 3.652363e-01  2.794148e-02 2.648997e-02
      9464    466_553873 1997    Simpson 1.453100e-01  1.537415e-02 4.407034e-02
      9465    466_553873 1997 invSimpson 1.170015e+00  3.845912e-02 6.645414e-02
      9466    466_553873 1997        PIE 1.453180e-01  1.538171e-02 4.400217e-02
      9467    466_553873 1997      DomMc 9.542631e-01 -4.014669e-03 1.333440e-02
      9468    466_553873 1997 expShannon 1.440854e+00  5.513184e-02 3.725340e-02
      9469    466_553873 2007          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9470    466_553873 2007          N 3.637000e+03 -2.774686e+02 2.782647e-01
      9471    466_553873 2007       maxN 1.953000e+03 -2.826514e+02 2.138599e-01
      9472    466_553873 2007    Shannon 9.937921e-01  2.794148e-02 2.648997e-02
      9473    466_553873 2007    Simpson 5.599383e-01  1.537415e-02 4.407034e-02
      9474    466_553873 2007 invSimpson 2.272408e+00  3.845912e-02 6.645414e-02
      9475    466_553873 2007        PIE 5.600923e-01  1.538171e-02 4.400217e-02
      9476    466_553873 2007      DomMc 9.241133e-01 -4.014669e-03 1.333440e-02
      9477    466_553873 2007 expShannon 2.701459e+00  5.513184e-02 3.725340e-02
      9478    466_553873 2008          S 8.000000e+00 -9.512625e-02 3.848880e-01
      9479    466_553873 2008          N 1.836000e+03 -2.774686e+02 2.782647e-01
      9480    466_553873 2008       maxN 1.536000e+03 -2.826514e+02 2.138599e-01
      9481    466_553873 2008    Shannon 6.912266e-01  2.794148e-02 2.648997e-02
      9482    466_553873 2008    Simpson 2.928948e-01  1.537415e-02 4.407034e-02
      9483    466_553873 2008 invSimpson 1.414217e+00  3.845912e-02 6.645414e-02
      9484    466_553873 2008        PIE 2.930544e-01  1.538171e-02 4.400217e-02
      9485    466_553873 2008      DomMc 9.052288e-01 -4.014669e-03 1.333440e-02
      9486    466_553873 2008 expShannon 1.996163e+00  5.513184e-02 3.725340e-02
      9487    466_550233 1991          S 1.100000e+01  2.636204e-03 9.698109e-01
      9488    466_550233 1991          N 5.092000e+03 -3.160105e+01 8.777053e-01
      9489    466_550233 1991       maxN 4.879000e+03 -9.453647e+01 4.539831e-01
      9490    466_550233 1991    Shannon 2.503470e-01  3.114309e-02 2.187593e-01
      9491    466_550233 1991    Simpson 8.154806e-02  1.595035e-02 3.132446e-01
      9492    466_550233 1991 invSimpson 1.088789e+00  3.184428e-02 4.855297e-01
      9493    466_550233 1991        PIE 8.156408e-02  1.595997e-02 3.129830e-01
      9494    466_550233 1991      DomMc 9.736842e-01 -5.450370e-03 3.967728e-01
      9495    466_550233 1991 expShannon 1.284471e+00  5.271933e-02 2.969529e-01
      9496    466_550233 1993          S 1.100000e+01  2.636204e-03 9.698109e-01
      9497    466_550233 1993          N 6.830000e+03 -3.160105e+01 8.777053e-01
      9498    466_550233 1993       maxN 4.695000e+03 -9.453647e+01 4.539831e-01
      9499    466_550233 1993    Shannon 1.018714e+00  3.114309e-02 2.187593e-01
      9500    466_550233 1993    Simpson 4.946085e-01  1.595035e-02 3.132446e-01
      9501    466_550233 1993 invSimpson 1.978664e+00  3.184428e-02 4.855297e-01
      9502    466_550233 1993        PIE 4.946809e-01  1.595997e-02 3.129830e-01
      9503    466_550233 1993      DomMc 8.311859e-01 -5.450370e-03 3.967728e-01
      9504    466_550233 1993 expShannon 2.769629e+00  5.271933e-02 2.969529e-01
      9505    466_550233 1986          S 9.000000e+00  2.636204e-03 9.698109e-01
      9506    466_550233 1986          N 2.188000e+03 -3.160105e+01 8.777053e-01
      9507    466_550233 1986       maxN 2.027000e+03 -9.453647e+01 4.539831e-01
      9508    466_550233 1986    Shannon 3.340688e-01  3.114309e-02 2.187593e-01
      9509    466_550233 1986    Simpson 1.387947e-01  1.595035e-02 3.132446e-01
      9510    466_550233 1986 invSimpson 1.161163e+00  3.184428e-02 4.855297e-01
      9511    466_550233 1986        PIE 1.388582e-01  1.595997e-02 3.129830e-01
      9512    466_550233 1986      DomMc 9.794333e-01 -5.450370e-03 3.967728e-01
      9513    466_550233 1986 expShannon 1.396639e+00  5.271933e-02 2.969529e-01
      9514    466_550233 1995          S 8.000000e+00  2.636204e-03 9.698109e-01
      9515    466_550233 1995          N 9.949000e+03 -3.160105e+01 8.777053e-01
      9516    466_550233 1995       maxN 4.842000e+03 -9.453647e+01 4.539831e-01
      9517    466_550233 1995    Shannon 8.402286e-01  3.114309e-02 2.187593e-01
      9518    466_550233 1995    Simpson 5.300620e-01  1.595035e-02 3.132446e-01
      9519    466_550233 1995 invSimpson 2.127940e+00  3.184428e-02 4.855297e-01
      9520    466_550233 1995        PIE 5.301153e-01  1.595997e-02 3.129830e-01
      9521    466_550233 1995      DomMc 9.689416e-01 -5.450370e-03 3.967728e-01
      9522    466_550233 1995 expShannon 2.316896e+00  5.271933e-02 2.969529e-01
      9523    466_550233 2006          S 1.000000e+01  2.636204e-03 9.698109e-01
      9524    466_550233 2006          N 1.307000e+03 -3.160105e+01 8.777053e-01
      9525    466_550233 2006       maxN 1.102000e+03 -9.453647e+01 4.539831e-01
      9526    466_550233 2006    Shannon 6.805021e-01  3.114309e-02 2.187593e-01
      9527    466_550233 2006    Simpson 2.828651e-01  1.595035e-02 3.132446e-01
      9528    466_550233 2006 invSimpson 1.394438e+00  3.184428e-02 4.855297e-01
      9529    466_550233 2006        PIE 2.830817e-01  1.595997e-02 3.129830e-01
      9530    466_550233 2006      DomMc 9.005356e-01 -5.450370e-03 3.967728e-01
      9531    466_550233 2006 expShannon 1.974869e+00  5.271933e-02 2.969529e-01
      9532    466_550233 1989          S 1.000000e+01  2.636204e-03 9.698109e-01
      9533    466_550233 1989          N 4.959000e+03 -3.160105e+01 8.777053e-01
      9534    466_550233 1989       maxN 4.821000e+03 -9.453647e+01 4.539831e-01
      9535    466_550233 1989    Shannon 1.653320e-01  3.114309e-02 2.187593e-01
      9536    466_550233 1989    Simpson 5.461961e-02  1.595035e-02 3.132446e-01
      9537    466_550233 1989 invSimpson 1.057775e+00  3.184428e-02 4.855297e-01
      9538    466_550233 1989        PIE 5.463063e-02  1.595997e-02 3.129830e-01
      9539    466_550233 1989      DomMc 9.862876e-01 -5.450370e-03 3.967728e-01
      9540    466_550233 1989 expShannon 1.179785e+00  5.271933e-02 2.969529e-01
      9541    466_550233 1990          S 1.000000e+01  2.636204e-03 9.698109e-01
      9542    466_550233 1990          N 1.725000e+03 -3.160105e+01 8.777053e-01
      9543    466_550233 1990       maxN 1.670000e+03 -9.453647e+01 4.539831e-01
      9544    466_550233 1990    Shannon 1.979653e-01  3.114309e-02 2.187593e-01
      9545    466_550233 1990    Simpson 6.253140e-02  1.595035e-02 3.132446e-01
      9546    466_550233 1990 invSimpson 1.066702e+00  3.184428e-02 4.855297e-01
      9547    466_550233 1990        PIE 6.256767e-02  1.595997e-02 3.129830e-01
      9548    466_550233 1990      DomMc 9.791304e-01 -5.450370e-03 3.967728e-01
      9549    466_550233 1990 expShannon 1.218920e+00  5.271933e-02 2.969529e-01
      9550    466_550233 1992          S 9.000000e+00  2.636204e-03 9.698109e-01
      9551    466_550233 1992          N 6.962000e+03 -3.160105e+01 8.777053e-01
      9552    466_550233 1992       maxN 6.634000e+03 -9.453647e+01 4.539831e-01
      9553    466_550233 1992    Shannon 2.673928e-01  3.114309e-02 2.187593e-01
      9554    466_550233 1992    Simpson 9.150561e-02  1.595035e-02 3.132446e-01
      9555    466_550233 1992 invSimpson 1.100722e+00  3.184428e-02 4.855297e-01
      9556    466_550233 1992        PIE 9.151875e-02  1.595997e-02 3.129830e-01
      9557    466_550233 1992      DomMc 9.668199e-01 -5.450370e-03 3.967728e-01
      9558    466_550233 1992 expShannon 1.306554e+00  5.271933e-02 2.969529e-01
      9559    466_550233 1994          S 9.000000e+00  2.636204e-03 9.698109e-01
      9560    466_550233 1994          N 7.432000e+03 -3.160105e+01 8.777053e-01
      9561    466_550233 1994       maxN 3.195000e+03 -9.453647e+01 4.539831e-01
      9562    466_550233 1994    Shannon 1.164039e+00  3.114309e-02 2.187593e-01
      9563    466_550233 1994    Simpson 6.620262e-01  1.595035e-02 3.132446e-01
      9564    466_550233 1994 invSimpson 2.958810e+00  3.184428e-02 4.855297e-01
      9565    466_550233 1994        PIE 6.621153e-01  1.595997e-02 3.129830e-01
      9566    466_550233 1994      DomMc 7.080194e-01 -5.450370e-03 3.967728e-01
      9567    466_550233 1994 expShannon 3.202845e+00  5.271933e-02 2.969529e-01
      9568    466_556056 1989          S 1.300000e+01  1.327739e-01 1.602597e-01
      9569    466_556056 1989          N 4.022000e+03 -2.080136e+02 9.137276e-02
      9570    466_556056 1989       maxN 3.323000e+03 -1.817853e+02 8.832058e-02
      9571    466_556056 1989    Shannon 6.036420e-01  2.681679e-02 4.277835e-02
      9572    466_556056 1989    Simpson 2.980733e-01  1.213602e-02 8.047659e-02
      9573    466_556056 1989 invSimpson 1.424650e+00  5.758712e-02 7.659997e-02
      9574    466_556056 1989        PIE 2.981474e-01  1.215108e-02 8.036413e-02
      9575    466_556056 1989      DomMc 9.634510e-01 -8.566565e-03 4.685136e-02
      9576    466_556056 1989 expShannon 1.828767e+00  7.321525e-02 4.718908e-02
      9577    466_556056 1993          S 1.300000e+01  1.327739e-01 1.602597e-01
      9578    466_556056 1993          N 1.131100e+04 -2.080136e+02 9.137276e-02
      9579    466_556056 1993       maxN 9.069000e+03 -1.817853e+02 8.832058e-02
      9580    466_556056 1993    Shannon 6.261115e-01  2.681679e-02 4.277835e-02
      9581    466_556056 1993    Simpson 3.287168e-01  1.213602e-02 8.047659e-02
      9582    466_556056 1993 invSimpson 1.489684e+00  5.758712e-02 7.659997e-02
      9583    466_556056 1993        PIE 3.287459e-01  1.215108e-02 8.036413e-02
      9584    466_556056 1993      DomMc 9.694103e-01 -8.566565e-03 4.685136e-02
      9585    466_556056 1993 expShannon 1.870324e+00  7.321525e-02 4.718908e-02
      9586    466_556056 2008          S 1.400000e+01  1.327739e-01 1.602597e-01
      9587    466_556056 2008          N 3.481000e+03 -2.080136e+02 9.137276e-02
      9588    466_556056 2008       maxN 2.727000e+03 -1.817853e+02 8.832058e-02
      9589    466_556056 2008    Shannon 6.564304e-01  2.681679e-02 4.277835e-02
      9590    466_556056 2008    Simpson 3.500995e-01  1.213602e-02 8.047659e-02
      9591    466_556056 2008 invSimpson 1.538697e+00  5.758712e-02 7.659997e-02
      9592    466_556056 2008        PIE 3.502001e-01  1.215108e-02 8.036413e-02
      9593    466_556056 2008      DomMc 9.732835e-01 -8.566565e-03 4.685136e-02
      9594    466_556056 2008 expShannon 1.927898e+00  7.321525e-02 4.718908e-02
      9595    466_556056 1990          S 1.100000e+01  1.327739e-01 1.602597e-01
      9596    466_556056 1990          N 3.692000e+03 -2.080136e+02 9.137276e-02
      9597    466_556056 1990       maxN 2.866000e+03 -1.817853e+02 8.832058e-02
      9598    466_556056 1990    Shannon 6.106484e-01  2.681679e-02 4.277835e-02
      9599    466_556056 1990    Simpson 3.535237e-01  1.213602e-02 8.047659e-02
      9600    466_556056 1990 invSimpson 1.546847e+00  5.758712e-02 7.659997e-02
      9601    466_556056 1990        PIE 3.536195e-01  1.215108e-02 8.036413e-02
      9602    466_556056 1990      DomMc 9.856446e-01 -8.566565e-03 4.685136e-02
      9603    466_556056 1990 expShannon 1.841625e+00  7.321525e-02 4.718908e-02
      9604    466_556056 1994          S 1.300000e+01  1.327739e-01 1.602597e-01
      9605    466_556056 1994          N 3.454000e+03 -2.080136e+02 9.137276e-02
      9606    466_556056 1994       maxN 1.938000e+03 -1.817853e+02 8.832058e-02
      9607    466_556056 1994    Shannon 1.146036e+00  2.681679e-02 4.277835e-02
      9608    466_556056 1994    Simpson 5.902439e-01  1.213602e-02 8.047659e-02
      9609    466_556056 1994 invSimpson 2.440476e+00  5.758712e-02 7.659997e-02
      9610    466_556056 1994        PIE 5.904148e-01  1.215108e-02 8.036413e-02
      9611    466_556056 1994      DomMc 8.569774e-01 -8.566565e-03 4.685136e-02
      9612    466_556056 1994 expShannon 3.145698e+00  7.321525e-02 4.718908e-02
      9613    466_556056 1996          S 1.400000e+01  1.327739e-01 1.602597e-01
      9614    466_556056 1996          N 8.473000e+03 -2.080136e+02 9.137276e-02
      9615    466_556056 1996       maxN 7.440000e+03 -1.817853e+02 8.832058e-02
      9616    466_556056 1996    Shannon 5.369135e-01  2.681679e-02 4.277835e-02
      9617    466_556056 1996    Simpson 2.234995e-01  1.213602e-02 8.047659e-02
      9618    466_556056 1996 invSimpson 1.287829e+00  5.758712e-02 7.659997e-02
      9619    466_556056 1996        PIE 2.235259e-01  1.215108e-02 8.036413e-02
      9620    466_556056 1996      DomMc 9.453558e-01 -8.566565e-03 4.685136e-02
      9621    466_556056 1996 expShannon 1.710719e+00  7.321525e-02 4.718908e-02
      9622    466_556056 1997          S 9.000000e+00  1.327739e-01 1.602597e-01
      9623    466_556056 1997          N 3.209000e+03 -2.080136e+02 9.137276e-02
      9624    466_556056 1997       maxN 2.328000e+03 -1.817853e+02 8.832058e-02
      9625    466_556056 1997    Shannon 8.541461e-01  2.681679e-02 4.277835e-02
      9626    466_556056 1997    Simpson 4.309184e-01  1.213602e-02 8.047659e-02
      9627    466_556056 1997 invSimpson 1.757217e+00  5.758712e-02 7.659997e-02
      9628    466_556056 1997        PIE 4.310527e-01  1.215108e-02 8.036413e-02
      9629    466_556056 1997      DomMc 9.292615e-01 -8.566565e-03 4.685136e-02
      9630    466_556056 1997 expShannon 2.349367e+00  7.321525e-02 4.718908e-02
      9631    466_556056 1999          S 1.100000e+01  1.327739e-01 1.602597e-01
      9632    466_556056 1999          N 1.329000e+03 -2.080136e+02 9.137276e-02
      9633    466_556056 1999       maxN 5.760000e+02 -1.817853e+02 8.832058e-02
      9634    466_556056 1999    Shannon 1.311139e+00  2.681679e-02 4.277835e-02
      9635    466_556056 1999    Simpson 6.582126e-01  1.213602e-02 8.047659e-02
      9636    466_556056 1999 invSimpson 2.925795e+00  5.758712e-02 7.659997e-02
      9637    466_556056 1999        PIE 6.587082e-01  1.215108e-02 8.036413e-02
      9638    466_556056 1999      DomMc 8.103837e-01 -8.566565e-03 4.685136e-02
      9639    466_556056 1999 expShannon 3.710398e+00  7.321525e-02 4.718908e-02
      9640    466_556056 2001          S 9.000000e+00  1.327739e-01 1.602597e-01
      9641    466_556056 2001          N 1.381000e+03 -2.080136e+02 9.137276e-02
      9642    466_556056 2001       maxN 5.240000e+02 -1.817853e+02 8.832058e-02
      9643    466_556056 2001    Shannon 1.374075e+00  2.681679e-02 4.277835e-02
      9644    466_556056 2001    Simpson 6.976904e-01  1.213602e-02 8.047659e-02
      9645    466_556056 2001 invSimpson 3.307868e+00  5.758712e-02 7.659997e-02
      9646    466_556056 2001        PIE 6.981960e-01  1.215108e-02 8.036413e-02
      9647    466_556056 2001      DomMc 7.451122e-01 -8.566565e-03 4.685136e-02
      9648    466_556056 2001 expShannon 3.951419e+00  7.321525e-02 4.718908e-02
      9649    466_556056 2006          S 1.200000e+01  1.327739e-01 1.602597e-01
      9650    466_556056 2006          N 1.455000e+03 -2.080136e+02 9.137276e-02
      9651    466_556056 2006       maxN 1.091000e+03 -1.817853e+02 8.832058e-02
      9652    466_556056 2006    Shannon 9.676192e-01  2.681679e-02 4.277835e-02
      9653    466_556056 2006    Simpson 4.226261e-01  1.213602e-02 8.047659e-02
      9654    466_556056 2006 invSimpson 1.731980e+00  5.758712e-02 7.659997e-02
      9655    466_556056 2006        PIE 4.229168e-01  1.215108e-02 8.036413e-02
      9656    466_556056 2006      DomMc 8.460481e-01 -8.566565e-03 4.685136e-02
      9657    466_556056 2006 expShannon 2.631672e+00  7.321525e-02 4.718908e-02
      9658    466_556056 2007          S 1.500000e+01  1.327739e-01 1.602597e-01
      9659    466_556056 2007          N 1.472000e+03 -2.080136e+02 9.137276e-02
      9660    466_556056 2007       maxN 4.570000e+02 -1.817853e+02 8.832058e-02
      9661    466_556056 2007    Shannon 1.495097e+00  2.681679e-02 4.277835e-02
      9662    466_556056 2007    Simpson 7.347211e-01  1.213602e-02 8.047659e-02
      9663    466_556056 2007 invSimpson 3.769618e+00  5.758712e-02 7.659997e-02
      9664    466_556056 2007        PIE 7.352206e-01  1.215108e-02 8.036413e-02
      9665    466_556056 2007      DomMc 6.127717e-01 -8.566565e-03 4.685136e-02
      9666    466_556056 2007 expShannon 4.459769e+00  7.321525e-02 4.718908e-02
      9667    466_556056 2005          S 1.300000e+01  1.327739e-01 1.602597e-01
      9668    466_556056 2005          N 2.629000e+03 -2.080136e+02 9.137276e-02
      9669    466_556056 2005       maxN 1.330000e+03 -1.817853e+02 8.832058e-02
      9670    466_556056 2005    Shannon 1.094344e+00  2.681679e-02 4.277835e-02
      9671    466_556056 2005    Simpson 5.861390e-01  1.213602e-02 8.047659e-02
      9672    466_556056 2005 invSimpson 2.416270e+00  5.758712e-02 7.659997e-02
      9673    466_556056 2005        PIE 5.863620e-01  1.215108e-02 8.036413e-02
      9674    466_556056 2005      DomMc 8.999620e-01 -8.566565e-03 4.685136e-02
      9675    466_556056 2005 expShannon 2.987221e+00  7.321525e-02 4.718908e-02
      9676    466_556056 1991          S 9.000000e+00  1.327739e-01 1.602597e-01
      9677    466_556056 1991          N 2.994000e+03 -2.080136e+02 9.137276e-02
      9678    466_556056 1991       maxN 2.545000e+03 -1.817853e+02 8.832058e-02
      9679    466_556056 1991    Shannon 6.027645e-01  2.681679e-02 4.277835e-02
      9680    466_556056 1991    Simpson 2.690837e-01  1.213602e-02 8.047659e-02
      9681    466_556056 1991 invSimpson 1.368146e+00  5.758712e-02 7.659997e-02
      9682    466_556056 1991        PIE 2.691736e-01  1.215108e-02 8.036413e-02
      9683    466_556056 1991      DomMc 9.154977e-01 -8.566565e-03 4.685136e-02
      9684    466_556056 1991 expShannon 1.827163e+00  7.321525e-02 4.718908e-02
      9685    466_556056 1992          S 8.000000e+00  1.327739e-01 1.602597e-01
      9686    466_556056 1992          N 7.129000e+03 -2.080136e+02 9.137276e-02
      9687    466_556056 1992       maxN 4.583000e+03 -1.817853e+02 8.832058e-02
      9688    466_556056 1992    Shannon 7.955166e-01  2.681679e-02 4.277835e-02
      9689    466_556056 1992    Simpson 4.803698e-01  1.213602e-02 8.047659e-02
      9690    466_556056 1992 invSimpson 1.924446e+00  5.758712e-02 7.659997e-02
      9691    466_556056 1992        PIE 4.804372e-01  1.215108e-02 8.036413e-02
      9692    466_556056 1992      DomMc 9.682985e-01 -8.566565e-03 4.685136e-02
      9693    466_556056 1992 expShannon 2.215585e+00  7.321525e-02 4.718908e-02
      9694    466_556058 1989          S 1.100000e+01  1.573046e-01 9.903977e-03
      9695    466_556058 1989          N 3.121000e+03 -7.608177e+01 1.008978e-01
      9696    466_556058 1989       maxN 2.682000e+03 -9.278584e+01 2.383873e-02
      9697    466_556058 1989    Shannon 6.650278e-01  4.684963e-02 2.717684e-03
      9698    466_556058 1989    Simpson 2.576596e-01  2.351459e-02 1.403701e-03
      9699    466_556058 1989 invSimpson 1.347091e+00  9.972983e-02 4.198789e-03
      9700    466_556058 1989        PIE 2.577422e-01  2.357734e-02 1.405973e-03
      9701    466_556058 1989      DomMc 9.070811e-01 -1.036211e-02 1.447669e-02
      9702    466_556058 1989 expShannon 1.944545e+00  1.310501e-01 4.807023e-03
      9703    466_556058 1991          S 1.100000e+01  1.573046e-01 9.903977e-03
      9704    466_556058 1991          N 1.444000e+03 -7.608177e+01 1.008978e-01
      9705    466_556058 1991       maxN 1.119000e+03 -9.278584e+01 2.383873e-02
      9706    466_556058 1991    Shannon 8.898025e-01  4.684963e-02 2.717684e-03
      9707    466_556058 1991    Simpson 3.858473e-01  2.351459e-02 1.403701e-03
      9708    466_556058 1991 invSimpson 1.628259e+00  9.972983e-02 4.198789e-03
      9709    466_556058 1991        PIE 3.861146e-01  2.357734e-02 1.405973e-03
      9710    466_556058 1991      DomMc 8.580332e-01 -1.036211e-02 1.447669e-02
      9711    466_556058 1991 expShannon 2.434649e+00  1.310501e-01 4.807023e-03
      9712    466_556058 2006          S 1.200000e+01  1.573046e-01 9.903977e-03
      9713    466_556058 2006          N 3.377000e+03 -7.608177e+01 1.008978e-01
      9714    466_556058 2006       maxN 1.915000e+03 -9.278584e+01 2.383873e-02
      9715    466_556058 2006    Shannon 1.019307e+00  4.684963e-02 2.717684e-03
      9716    466_556058 2006    Simpson 5.532729e-01  2.351459e-02 1.403701e-03
      9717    466_556058 2006 invSimpson 2.238503e+00  9.972983e-02 4.198789e-03
      9718    466_556058 2006        PIE 5.534368e-01  2.357734e-02 1.405973e-03
      9719    466_556058 2006      DomMc 9.182707e-01 -1.036211e-02 1.447669e-02
      9720    466_556058 2006 expShannon 2.771274e+00  1.310501e-01 4.807023e-03
      9721    466_556058 2005          S 1.200000e+01  1.573046e-01 9.903977e-03
      9722    466_556058 2005          N 1.514000e+03 -7.608177e+01 1.008978e-01
      9723    466_556058 2005       maxN 1.312000e+03 -9.278584e+01 2.383873e-02
      9724    466_556058 2005    Shannon 6.114160e-01  4.684963e-02 2.717684e-03
      9725    466_556058 2005    Simpson 2.447836e-01  2.351459e-02 1.403701e-03
      9726    466_556058 2005 invSimpson 1.324124e+00  9.972983e-02 4.198789e-03
      9727    466_556058 2005        PIE 2.449454e-01  2.357734e-02 1.405973e-03
      9728    466_556058 2005      DomMc 9.062087e-01 -1.036211e-02 1.447669e-02
      9729    466_556058 2005 expShannon 1.843039e+00  1.310501e-01 4.807023e-03
      9730    466_556058 2008          S 1.400000e+01  1.573046e-01 9.903977e-03
      9731    466_556058 2008          N 2.810000e+02 -7.608177e+01 1.008978e-01
      9732    466_556058 2008       maxN 9.900000e+01 -9.278584e+01 2.383873e-02
      9733    466_556058 2008    Shannon 1.735833e+00  4.684963e-02 2.717684e-03
      9734    466_556058 2008    Simpson 7.603754e-01  2.351459e-02 1.403701e-03
      9735    466_556058 2008 invSimpson 4.173194e+00  9.972983e-02 4.198789e-03
      9736    466_556058 2008        PIE 7.630910e-01  2.357734e-02 1.405973e-03
      9737    466_556058 2008      DomMc 6.441281e-01 -1.036211e-02 1.447669e-02
      9738    466_556058 2008 expShannon 5.673650e+00  1.310501e-01 4.807023e-03
      9739    466_556058 2007          S 1.100000e+01  1.573046e-01 9.903977e-03
      9740    466_556058 2007          N 5.050000e+02 -7.608177e+01 1.008978e-01
      9741    466_556058 2007       maxN 2.040000e+02 -9.278584e+01 2.383873e-02
      9742    466_556058 2007    Shannon 1.614463e+00  4.684963e-02 2.717684e-03
      9743    466_556058 2007    Simpson 7.491815e-01  2.351459e-02 1.403701e-03
      9744    466_556058 2007 invSimpson 3.986946e+00  9.972983e-02 4.198789e-03
      9745    466_556058 2007        PIE 7.506679e-01  2.357734e-02 1.405973e-03
      9746    466_556058 2007      DomMc 5.940594e-01 -1.036211e-02 1.447669e-02
      9747    466_556058 2007 expShannon 5.025188e+00  1.310501e-01 4.807023e-03
      9748    466_556058 1987          S 9.000000e+00  1.573046e-01 9.903977e-03
      9749    466_556058 1987          N 1.174000e+03 -7.608177e+01 1.008978e-01
      9750    466_556058 1987       maxN 1.086000e+03 -9.278584e+01 2.383873e-02
      9751    466_556058 1987    Shannon 3.808079e-01  4.684963e-02 2.717684e-03
      9752    466_556058 1987    Simpson 1.427464e-01  2.351459e-02 1.403701e-03
      9753    466_556058 1987 invSimpson 1.166516e+00  9.972983e-02 4.198789e-03
      9754    466_556058 1987        PIE 1.428681e-01  2.357734e-02 1.405973e-03
      9755    466_556058 1987      DomMc 9.574106e-01 -1.036211e-02 1.447669e-02
      9756    466_556058 1987 expShannon 1.463466e+00  1.310501e-01 4.807023e-03
      9757    466_556058 1988          S 1.000000e+01  1.573046e-01 9.903977e-03
      9758    466_556058 1988          N 3.530000e+03 -7.608177e+01 1.008978e-01
      9759    466_556058 1988       maxN 3.258000e+03 -9.278584e+01 2.383873e-02
      9760    466_556058 1988    Shannon 4.187014e-01  4.684963e-02 2.717684e-03
      9761    466_556058 1988    Simpson 1.471732e-01  2.351459e-02 1.403701e-03
      9762    466_556058 1988 invSimpson 1.172571e+00  9.972983e-02 4.198789e-03
      9763    466_556058 1988        PIE 1.472149e-01  2.357734e-02 1.405973e-03
      9764    466_556058 1988      DomMc 9.416431e-01 -1.036211e-02 1.447669e-02
      9765    466_556058 1988 expShannon 1.519986e+00  1.310501e-01 4.807023e-03
      9766    466_556058 1994          S 9.000000e+00  1.573046e-01 9.903977e-03
      9767    466_556058 1994          N 1.641000e+03 -7.608177e+01 1.008978e-01
      9768    466_556058 1994       maxN 1.323000e+03 -9.278584e+01 2.383873e-02
      9769    466_556058 1994    Shannon 7.505656e-01  4.684963e-02 2.717684e-03
      9770    466_556058 1994    Simpson 3.371645e-01  2.351459e-02 1.403701e-03
      9771    466_556058 1994 invSimpson 1.508670e+00  9.972983e-02 4.198789e-03
      9772    466_556058 1994        PIE 3.373701e-01  2.357734e-02 1.405973e-03
      9773    466_556058 1994      DomMc 9.067642e-01 -1.036211e-02 1.447669e-02
      9774    466_556058 1994 expShannon 2.118198e+00  1.310501e-01 4.807023e-03
      9775    466_556058 1986          S 9.000000e+00  1.573046e-01 9.903977e-03
      9776    466_556058 1986          N 4.266000e+03 -7.608177e+01 1.008978e-01
      9777    466_556058 1986       maxN 4.109000e+03 -9.278584e+01 2.383873e-02
      9778    466_556058 1986    Shannon 2.177500e-01  4.684963e-02 2.717684e-03
      9779    466_556058 1986    Simpson 7.194294e-02  2.351459e-02 1.403701e-03
      9780    466_556058 1986 invSimpson 1.077520e+00  9.972983e-02 4.198789e-03
      9781    466_556058 1986        PIE 7.195981e-02  2.357734e-02 1.405973e-03
      9782    466_556058 1986      DomMc 9.758556e-01 -1.036211e-02 1.447669e-02
      9783    466_556058 1986 expShannon 1.243276e+00  1.310501e-01 4.807023e-03
      9784    466_556058 1990          S 7.000000e+00  1.573046e-01 9.903977e-03
      9785    466_556058 1990          N 2.355000e+03 -7.608177e+01 1.008978e-01
      9786    466_556058 1990       maxN 2.291000e+03 -9.278584e+01 2.383873e-02
      9787    466_556058 1990    Shannon 1.608700e-01  4.684963e-02 2.717684e-03
      9788    466_556058 1990    Simpson 5.336363e-02  2.351459e-02 1.403701e-03
      9789    466_556058 1990 invSimpson 1.056372e+00  9.972983e-02 4.198789e-03
      9790    466_556058 1990        PIE 5.338629e-02  2.357734e-02 1.405973e-03
      9791    466_556058 1990      DomMc 9.868365e-01 -1.036211e-02 1.447669e-02
      9792    466_556058 1990 expShannon 1.174532e+00  1.310501e-01 4.807023e-03
      9793    466_556059 1989          S 1.200000e+01  9.369025e-02 1.315277e-01
      9794    466_556059 1989          N 4.360000e+02 -1.837349e+02 2.146216e-01
      9795    466_556059 1989       maxN 2.620000e+02 -1.783773e+02 2.044668e-01
      9796    466_556059 1989    Shannon 1.458411e+00  3.095189e-02 1.436082e-01
      9797    466_556059 1989    Simpson 6.122801e-01  1.247307e-02 1.675715e-01
      9798    466_556059 1989 invSimpson 2.579182e+00  1.003589e-01 1.250167e-01
      9799    466_556059 1989        PIE 6.136877e-01  1.256181e-02 1.663763e-01
      9800    466_556059 1989      DomMc 6.995413e-01 -8.442066e-03 1.787569e-01
      9801    466_556059 1989 expShannon 4.299121e+00  1.125367e-01 1.440885e-01
      9802    466_556059 1993          S 9.000000e+00  9.369025e-02 1.315277e-01
      9803    466_556059 1993          N 1.512600e+04 -1.837349e+02 2.146216e-01
      9804    466_556059 1993       maxN 1.398000e+04 -1.783773e+02 2.044668e-01
      9805    466_556059 1993    Shannon 3.524903e-01  3.095189e-02 1.436082e-01
      9806    466_556059 1993    Simpson 1.429997e-01  1.247307e-02 1.675715e-01
      9807    466_556059 1993 invSimpson 1.166861e+00  1.003589e-01 1.250167e-01
      9808    466_556059 1993        PIE 1.430092e-01  1.256181e-02 1.663763e-01
      9809    466_556059 1993      DomMc 9.756049e-01 -8.442066e-03 1.787569e-01
      9810    466_556059 1993 expShannon 1.422606e+00  1.125367e-01 1.440885e-01
      9811    466_556059 2002          S 1.100000e+01  9.369025e-02 1.315277e-01
      9812    466_556059 2002          N 2.736000e+03 -1.837349e+02 2.146216e-01
      9813    466_556059 2002       maxN 2.524000e+03 -1.783773e+02 2.044668e-01
      9814    466_556059 2002    Shannon 4.000422e-01  3.095189e-02 1.436082e-01
      9815    466_556059 2002    Simpson 1.474241e-01  1.247307e-02 1.675715e-01
      9816    466_556059 2002 invSimpson 1.172916e+00  1.003589e-01 1.250167e-01
      9817    466_556059 2002        PIE 1.474780e-01  1.256181e-02 1.663763e-01
      9818    466_556059 2002      DomMc 9.561404e-01 -8.442066e-03 1.787569e-01
      9819    466_556059 2002 expShannon 1.491888e+00  1.125367e-01 1.440885e-01
      9820    466_556059 1991          S 1.000000e+01  9.369025e-02 1.315277e-01
      9821    466_556059 1991          N 3.270000e+02 -1.837349e+02 2.146216e-01
      9822    466_556059 1991       maxN 2.540000e+02 -1.783773e+02 2.044668e-01
      9823    466_556059 1991    Shannon 9.316885e-01  3.095189e-02 1.436082e-01
      9824    466_556059 1991    Simpson 3.862189e-01  1.247307e-02 1.675715e-01
      9825    466_556059 1991 invSimpson 1.629245e+00  1.003589e-01 1.250167e-01
      9826    466_556059 1991        PIE 3.874036e-01  1.256181e-02 1.663763e-01
      9827    466_556059 1991      DomMc 8.532110e-01 -8.442066e-03 1.787569e-01
      9828    466_556059 1991 expShannon 2.538792e+00  1.125367e-01 1.440885e-01
      9829    466_556059 1999          S 1.200000e+01  9.369025e-02 1.315277e-01
      9830    466_556059 1999          N 4.780000e+02 -1.837349e+02 2.146216e-01
      9831    466_556059 1999       maxN 1.620000e+02 -1.783773e+02 2.044668e-01
      9832    466_556059 1999    Shannon 1.900888e+00  3.095189e-02 1.436082e-01
      9833    466_556059 1999    Simpson 8.090457e-01  1.247307e-02 1.675715e-01
      9834    466_556059 1999 invSimpson 5.236855e+00  1.003589e-01 1.250167e-01
      9835    466_556059 1999        PIE 8.107418e-01  1.256181e-02 1.663763e-01
      9836    466_556059 1999      DomMc 5.000000e-01 -8.442066e-03 1.787569e-01
      9837    466_556059 1999 expShannon 6.691836e+00  1.125367e-01 1.440885e-01
      9838    466_556059 2006          S 1.300000e+01  9.369025e-02 1.315277e-01
      9839    466_556059 2006          N 1.297000e+03 -1.837349e+02 2.146216e-01
      9840    466_556059 2006       maxN 8.680000e+02 -1.783773e+02 2.044668e-01
      9841    466_556059 2006    Shannon 1.093170e+00  3.095189e-02 1.436082e-01
      9842    466_556059 2006    Simpson 5.122633e-01  1.247307e-02 1.675715e-01
      9843    466_556059 2006 invSimpson 2.050287e+00  1.003589e-01 1.250167e-01
      9844    466_556059 2006        PIE 5.126586e-01  1.256181e-02 1.663763e-01
      9845    466_556059 2006      DomMc 8.450270e-01 -8.442066e-03 1.787569e-01
      9846    466_556059 2006 expShannon 2.983717e+00  1.125367e-01 1.440885e-01
      9847    466_556059 1988          S 1.200000e+01  9.369025e-02 1.315277e-01
      9848    466_556059 1988          N 1.366000e+03 -1.837349e+02 2.146216e-01
      9849    466_556059 1988       maxN 8.510000e+02 -1.783773e+02 2.044668e-01
      9850    466_556059 1988    Shannon 1.146305e+00  3.095189e-02 1.436082e-01
      9851    466_556059 1988    Simpson 5.559649e-01  1.247307e-02 1.675715e-01
      9852    466_556059 1988 invSimpson 2.252074e+00  1.003589e-01 1.250167e-01
      9853    466_556059 1988        PIE 5.563722e-01  1.256181e-02 1.663763e-01
      9854    466_556059 1988      DomMc 8.411420e-01 -8.442066e-03 1.787569e-01
      9855    466_556059 1988 expShannon 3.146545e+00  1.125367e-01 1.440885e-01
      9856    466_556059 1990          S 1.000000e+01  9.369025e-02 1.315277e-01
      9857    466_556059 1990          N 2.188000e+03 -1.837349e+02 2.146216e-01
      9858    466_556059 1990       maxN 2.008000e+03 -1.783773e+02 2.044668e-01
      9859    466_556059 1990    Shannon 4.176634e-01  3.095189e-02 1.436082e-01
      9860    466_556059 1990    Simpson 1.560373e-01  1.247307e-02 1.675715e-01
      9861    466_556059 1990 invSimpson 1.184886e+00  1.003589e-01 1.250167e-01
      9862    466_556059 1990        PIE 1.561086e-01  1.256181e-02 1.663763e-01
      9863    466_556059 1990      DomMc 9.524680e-01 -8.442066e-03 1.787569e-01
      9864    466_556059 1990 expShannon 1.518409e+00  1.125367e-01 1.440885e-01
      9865    466_556059 1992          S 1.000000e+01  9.369025e-02 1.315277e-01
      9866    466_556059 1992          N 8.042000e+03 -1.837349e+02 2.146216e-01
      9867    466_556059 1992       maxN 7.919000e+03 -1.783773e+02 2.044668e-01
      9868    466_556059 1992    Shannon 1.038591e-01  3.095189e-02 1.436082e-01
      9869    466_556059 1992    Simpson 3.029117e-02  1.247307e-02 1.675715e-01
      9870    466_556059 1992 invSimpson 1.031237e+00  1.003589e-01 1.250167e-01
      9871    466_556059 1992        PIE 3.029494e-02  1.256181e-02 1.663763e-01
      9872    466_556059 1992      DomMc 9.917931e-01 -8.442066e-03 1.787569e-01
      9873    466_556059 1992 expShannon 1.109444e+00  1.125367e-01 1.440885e-01
      9874    466_556059 2001          S 1.000000e+01  9.369025e-02 1.315277e-01
      9875    466_556059 2001          N 9.740000e+02 -1.837349e+02 2.146216e-01
      9876    466_556059 2001       maxN 7.230000e+02 -1.783773e+02 2.044668e-01
      9877    466_556059 2001    Shannon 9.944767e-01  3.095189e-02 1.436082e-01
      9878    466_556059 2001    Simpson 4.320653e-01  1.247307e-02 1.675715e-01
      9879    466_556059 2001 invSimpson 1.760766e+00  1.003589e-01 1.250167e-01
      9880    466_556059 2001        PIE 4.325094e-01  1.256181e-02 1.663763e-01
      9881    466_556059 2001      DomMc 8.552361e-01 -8.442066e-03 1.787569e-01
      9882    466_556059 2001 expShannon 2.703309e+00  1.125367e-01 1.440885e-01
      9883    466_556059 2007          S 1.200000e+01  9.369025e-02 1.315277e-01
      9884    466_556059 2007          N 1.380000e+02 -1.837349e+02 2.146216e-01
      9885    466_556059 2007       maxN 2.800000e+01 -1.783773e+02 2.044668e-01
      9886    466_556059 2007    Shannon 2.235185e+00  3.095189e-02 1.436082e-01
      9887    466_556059 2007    Simpson 8.782819e-01  1.247307e-02 1.675715e-01
      9888    466_556059 2007 invSimpson 8.215703e+00  1.003589e-01 1.250167e-01
      9889    466_556059 2007        PIE 8.846927e-01  1.256181e-02 1.663763e-01
      9890    466_556059 2007      DomMc 3.550725e-01 -8.442066e-03 1.787569e-01
      9891    466_556059 2007 expShannon 9.348214e+00  1.125367e-01 1.440885e-01
      9892    466_556059 2008          S 1.200000e+01  9.369025e-02 1.315277e-01
      9893    466_556059 2008          N 2.930000e+02 -1.837349e+02 2.146216e-01
      9894    466_556059 2008       maxN 2.420000e+02 -1.783773e+02 2.044668e-01
      9895    466_556059 2008    Shannon 7.300121e-01  3.095189e-02 1.436082e-01
      9896    466_556059 2008    Simpson 3.074002e-01  1.247307e-02 1.675715e-01
      9897    466_556059 2008 invSimpson 1.443835e+00  1.003589e-01 1.250167e-01
      9898    466_556059 2008        PIE 3.084529e-01  1.256181e-02 1.663763e-01
      9899    466_556059 2008      DomMc 9.215017e-01 -8.442066e-03 1.787569e-01
      9900    466_556059 2008 expShannon 2.075106e+00  1.125367e-01 1.440885e-01
      9901    466_556059 2003          S 9.000000e+00  9.369025e-02 1.315277e-01
      9902    466_556059 2003          N 9.900000e+02 -1.837349e+02 2.146216e-01
      9903    466_556059 2003       maxN 8.560000e+02 -1.783773e+02 2.044668e-01
      9904    466_556059 2003    Shannon 6.008154e-01  3.095189e-02 1.436082e-01
      9905    466_556059 2003    Simpson 2.470911e-01  1.247307e-02 1.675715e-01
      9906    466_556059 2003 invSimpson 1.328182e+00  1.003589e-01 1.250167e-01
      9907    466_556059 2003        PIE 2.473410e-01  1.256181e-02 1.663763e-01
      9908    466_556059 2003      DomMc 9.252525e-01 -8.442066e-03 1.787569e-01
      9909    466_556059 2003 expShannon 1.823605e+00  1.125367e-01 1.440885e-01
      9910    466_556059 1994          S 9.000000e+00  9.369025e-02 1.315277e-01
      9911    466_556059 1994          N 9.510000e+02 -1.837349e+02 2.146216e-01
      9912    466_556059 1994       maxN 8.040000e+02 -1.783773e+02 2.044668e-01
      9913    466_556059 1994    Shannon 6.629359e-01  3.095189e-02 1.436082e-01
      9914    466_556059 1994    Simpson 2.780028e-01  1.247307e-02 1.675715e-01
      9915    466_556059 1994 invSimpson 1.385047e+00  1.003589e-01 1.250167e-01
      9916    466_556059 1994        PIE 2.782954e-01  1.256181e-02 1.663763e-01
      9917    466_556059 1994      DomMc 9.211356e-01 -8.442066e-03 1.787569e-01
      9918    466_556059 1994 expShannon 1.940481e+00  1.125367e-01 1.440885e-01
      9919    466_556059 1995          S 9.000000e+00  9.369025e-02 1.315277e-01
      9920    466_556059 1995          N 9.547000e+03 -1.837349e+02 2.146216e-01
      9921    466_556059 1995       maxN 8.890000e+03 -1.783773e+02 2.044668e-01
      9922    466_556059 1995    Shannon 3.253036e-01  3.095189e-02 1.436082e-01
      9923    466_556059 1995    Simpson 1.303307e-01  1.247307e-02 1.675715e-01
      9924    466_556059 1995 invSimpson 1.149862e+00  1.003589e-01 1.250167e-01
      9925    466_556059 1995        PIE 1.303444e-01  1.256181e-02 1.663763e-01
      9926    466_556059 1995      DomMc 9.812507e-01 -8.442066e-03 1.787569e-01
      9927    466_556059 1995 expShannon 1.384451e+00  1.125367e-01 1.440885e-01
      9928    466_556059 1996          S 7.000000e+00  9.369025e-02 1.315277e-01
      9929    466_556059 1996          N 1.327000e+03 -1.837349e+02 2.146216e-01
      9930    466_556059 1996       maxN 1.203000e+03 -1.783773e+02 2.044668e-01
      9931    466_556059 1996    Shannon 4.603829e-01  3.095189e-02 1.436082e-01
      9932    466_556059 1996    Simpson 1.762445e-01  1.247307e-02 1.675715e-01
      9933    466_556059 1996 invSimpson 1.213952e+00  1.003589e-01 1.250167e-01
      9934    466_556059 1996        PIE 1.763774e-01  1.256181e-02 1.663763e-01
      9935    466_556059 1996      DomMc 9.321778e-01 -8.442066e-03 1.787569e-01
      9936    466_556059 1996 expShannon 1.584681e+00  1.125367e-01 1.440885e-01
      9937    466_556059 1997          S 8.000000e+00  9.369025e-02 1.315277e-01
      9938    466_556059 1997          N 8.780000e+02 -1.837349e+02 2.146216e-01
      9939    466_556059 1997       maxN 6.840000e+02 -1.783773e+02 2.044668e-01
      9940    466_556059 1997    Shannon 8.530956e-01  3.095189e-02 1.436082e-01
      9941    466_556059 1997    Simpson 3.782411e-01  1.247307e-02 1.675715e-01
      9942    466_556059 1997 invSimpson 1.608340e+00  1.003589e-01 1.250167e-01
      9943    466_556059 1997        PIE 3.786724e-01  1.256181e-02 1.663763e-01
      9944    466_556059 1997      DomMc 8.872437e-01 -8.442066e-03 1.787569e-01
      9945    466_556059 1997 expShannon 2.346901e+00  1.125367e-01 1.440885e-01
      9946    466_556059 1986          S 8.000000e+00  9.369025e-02 1.315277e-01
      9947    466_556059 1986          N 4.894000e+03 -1.837349e+02 2.146216e-01
      9948    466_556059 1986       maxN 4.814000e+03 -1.783773e+02 2.044668e-01
      9949    466_556059 1986    Shannon 1.076238e-01  3.095189e-02 1.436082e-01
      9950    466_556059 1986    Simpson 3.235332e-02  1.247307e-02 1.675715e-01
      9951    466_556059 1986 invSimpson 1.033435e+00  1.003589e-01 1.250167e-01
      9952    466_556059 1986        PIE 3.235993e-02  1.256181e-02 1.663763e-01
      9953    466_556059 1986      DomMc 9.897834e-01 -8.442066e-03 1.787569e-01
      9954    466_556059 1986 expShannon 1.113629e+00  1.125367e-01 1.440885e-01
      9955    466_553874 1989          S 1.100000e+01  5.676684e-02 3.045302e-01
      9956    466_553874 1989          N 3.492000e+03 -2.227042e+02 1.599797e-01
      9957    466_553874 1989       maxN 3.280000e+03 -1.980980e+02 1.983522e-01
      9958    466_553874 1989    Shannon 3.255262e-01  2.161673e-02 1.949859e-02
      9959    466_553874 1989    Simpson 1.166655e-01  8.578298e-03 1.074595e-01
      9960    466_553874 1989 invSimpson 1.132074e+00  1.701966e-02 1.429547e-01
      9961    466_553874 1989        PIE 1.166989e-01  8.602741e-03 1.068875e-01
      9962    466_553874 1989      DomMc 9.682131e-01 -5.555178e-03 3.687522e-04
      9963    466_553874 1989 expShannon 1.384759e+00  4.174625e-02 1.824443e-02
      9964    466_553874 1993          S 1.000000e+01  5.676684e-02 3.045302e-01
      9965    466_553874 1993          N 8.399000e+03 -2.227042e+02 1.599797e-01
      9966    466_553874 1993       maxN 7.437000e+03 -1.980980e+02 1.983522e-01
      9967    466_553874 1993    Shannon 4.677837e-01  2.161673e-02 1.949859e-02
      9968    466_553874 1993    Simpson 2.087061e-01  8.578298e-03 1.074595e-01
      9969    466_553874 1993 invSimpson 1.263753e+00  1.701966e-02 1.429547e-01
      9970    466_553874 1993        PIE 2.087310e-01  8.602741e-03 1.068875e-01
      9971    466_553874 1993      DomMc 9.689249e-01 -5.555178e-03 3.687522e-04
      9972    466_553874 1993 expShannon 1.596452e+00  4.174625e-02 1.824443e-02
      9973    466_553874 2003          S 1.200000e+01  5.676684e-02 3.045302e-01
      9974    466_553874 2003          N 8.810000e+02 -2.227042e+02 1.599797e-01
      9975    466_553874 2003       maxN 7.370000e+02 -1.980980e+02 1.983522e-01
      9976    466_553874 2003    Shannon 6.766990e-01  2.161673e-02 1.949859e-02
      9977    466_553874 2003    Simpson 2.893188e-01  8.578298e-03 1.074595e-01
      9978    466_553874 2003 invSimpson 1.407101e+00  1.701966e-02 1.429547e-01
      9979    466_553874 2003        PIE 2.896476e-01  8.602741e-03 1.068875e-01
      9980    466_553874 2003      DomMc 9.375709e-01 -5.555178e-03 3.687522e-04
      9981    466_553874 2003 expShannon 1.967373e+00  4.174625e-02 1.824443e-02
      9982    466_553874 2008          S 1.100000e+01  5.676684e-02 3.045302e-01
      9983    466_553874 2008          N 1.310000e+03 -2.227042e+02 1.599797e-01
      9984    466_553874 2008       maxN 8.540000e+02 -1.980980e+02 1.983522e-01
      9985    466_553874 2008    Shannon 1.154696e+00  2.161673e-02 1.949859e-02
      9986    466_553874 2008    Simpson 5.406223e-01  8.578298e-03 1.074595e-01
      9987    466_553874 2008 invSimpson 2.176858e+00  1.701966e-02 1.429547e-01
      9988    466_553874 2008        PIE 5.410353e-01  8.602741e-03 1.068875e-01
      9989    466_553874 2008      DomMc 7.854962e-01 -5.555178e-03 3.687522e-04
      9990    466_553874 2008 expShannon 3.173059e+00  4.174625e-02 1.824443e-02
      9991    466_553874 1994          S 1.100000e+01  5.676684e-02 3.045302e-01
      9992    466_553874 1994          N 4.248000e+03 -2.227042e+02 1.599797e-01
      9993    466_553874 1994       maxN 3.977000e+03 -1.980980e+02 1.983522e-01
      9994    466_553874 1994    Shannon 3.540103e-01  2.161673e-02 1.949859e-02
      9995    466_553874 1994    Simpson 1.226847e-01  8.578298e-03 1.074595e-01
      9996    466_553874 1994 invSimpson 1.139841e+00  1.701966e-02 1.429547e-01
      9997    466_553874 1994        PIE 1.227136e-01  8.602741e-03 1.068875e-01
      9998    466_553874 1994      DomMc 9.592750e-01 -5.555178e-03 3.687522e-04
      9999    466_553874 1994 expShannon 1.424770e+00  4.174625e-02 1.824443e-02
      10000   466_553874 1995          S 1.200000e+01  5.676684e-02 3.045302e-01
      10001   466_553874 1995          N 7.343000e+03 -2.227042e+02 1.599797e-01
      10002   466_553874 1995       maxN 6.740000e+03 -1.980980e+02 1.983522e-01
      10003   466_553874 1995    Shannon 3.975705e-01  2.161673e-02 1.949859e-02
      10004   466_553874 1995    Simpson 1.553357e-01  8.578298e-03 1.074595e-01
      10005   466_553874 1995 invSimpson 1.183902e+00  1.701966e-02 1.429547e-01
      10006   466_553874 1995        PIE 1.553569e-01  8.602741e-03 1.068875e-01
      10007   466_553874 1995      DomMc 9.530165e-01 -5.555178e-03 3.687522e-04
      10008   466_553874 1995 expShannon 1.488205e+00  4.174625e-02 1.824443e-02
      10009   466_553874 1992          S 1.000000e+01  5.676684e-02 3.045302e-01
      10010   466_553874 1992          N 1.234000e+03 -2.227042e+02 1.599797e-01
      10011   466_553874 1992       maxN 9.220000e+02 -1.980980e+02 1.983522e-01
      10012   466_553874 1992    Shannon 7.743775e-01  2.161673e-02 1.949859e-02
      10013   466_553874 1992    Simpson 3.995729e-01  8.578298e-03 1.074595e-01
      10014   466_553874 1992 invSimpson 1.665481e+00  1.701966e-02 1.429547e-01
      10015   466_553874 1992        PIE 3.998969e-01  8.602741e-03 1.068875e-01
      10016   466_553874 1992      DomMc 9.513776e-01 -5.555178e-03 3.687522e-04
      10017   466_553874 1992 expShannon 2.169241e+00  4.174625e-02 1.824443e-02
      10018   466_553874 2001          S 9.000000e+00  5.676684e-02 3.045302e-01
      10019   466_553874 2001          N 4.205000e+03 -2.227042e+02 1.599797e-01
      10020   466_553874 2001       maxN 3.835000e+03 -1.980980e+02 1.983522e-01
      10021   466_553874 2001    Shannon 4.377349e-01  2.161673e-02 1.949859e-02
      10022   466_553874 2001    Simpson 1.663036e-01  8.578298e-03 1.074595e-01
      10023   466_553874 2001 invSimpson 1.199477e+00  1.701966e-02 1.429547e-01
      10024   466_553874 2001        PIE 1.663431e-01  8.602741e-03 1.068875e-01
      10025   466_553874 2001      DomMc 9.438763e-01 -5.555178e-03 3.687522e-04
      10026   466_553874 2001 expShannon 1.549194e+00  4.174625e-02 1.824443e-02
      10027   466_553874 2002          S 9.000000e+00  5.676684e-02 3.045302e-01
      10028   466_553874 2002          N 1.884000e+03 -2.227042e+02 1.599797e-01
      10029   466_553874 2002       maxN 1.712000e+03 -1.980980e+02 1.983522e-01
      10030   466_553874 2002    Shannon 4.521228e-01  2.161673e-02 1.949859e-02
      10031   466_553874 2002    Simpson 1.723554e-01  8.578298e-03 1.074595e-01
      10032   466_553874 2002 invSimpson 1.208248e+00  1.701966e-02 1.429547e-01
      10033   466_553874 2002        PIE 1.724470e-01  8.602741e-03 1.068875e-01
      10034   466_553874 2002      DomMc 9.373673e-01 -5.555178e-03 3.687522e-04
      10035   466_553874 2002 expShannon 1.571645e+00  4.174625e-02 1.824443e-02
      10036   466_553874 2005          S 1.200000e+01  5.676684e-02 3.045302e-01
      10037   466_553874 2005          N 2.927000e+03 -2.227042e+02 1.599797e-01
      10038   466_553874 2005       maxN 2.723000e+03 -1.980980e+02 1.983522e-01
      10039   466_553874 2005    Shannon 3.685142e-01  2.161673e-02 1.949859e-02
      10040   466_553874 2005    Simpson 1.334266e-01  8.578298e-03 1.074595e-01
      10041   466_553874 2005 invSimpson 1.153970e+00  1.701966e-02 1.429547e-01
      10042   466_553874 2005        PIE 1.334722e-01  8.602741e-03 1.068875e-01
      10043   466_553874 2005      DomMc 9.501196e-01 -5.555178e-03 3.687522e-04
      10044   466_553874 2005 expShannon 1.445585e+00  4.174625e-02 1.824443e-02
      10045   466_553874 2007          S 1.000000e+01  5.676684e-02 3.045302e-01
      10046   466_553874 2007          N 3.040000e+02 -2.227042e+02 1.599797e-01
      10047   466_553874 2007       maxN 2.220000e+02 -1.980980e+02 1.983522e-01
      10048   466_553874 2007    Shannon 9.647583e-01  2.161673e-02 1.949859e-02
      10049   466_553874 2007    Simpson 4.431051e-01  8.578298e-03 1.074595e-01
      10050   466_553874 2007 invSimpson 1.795671e+00  1.701966e-02 1.429547e-01
      10051   466_553874 2007        PIE 4.445675e-01  8.602741e-03 1.068875e-01
      10052   466_553874 2007      DomMc 8.519737e-01 -5.555178e-03 3.687522e-04
      10053   466_553874 2007 expShannon 2.624153e+00  4.174625e-02 1.824443e-02
      10054   466_553874 2006          S 8.000000e+00  5.676684e-02 3.045302e-01
      10055   466_553874 2006          N 1.904000e+03 -2.227042e+02 1.599797e-01
      10056   466_553874 2006       maxN 1.569000e+03 -1.980980e+02 1.983522e-01
      10057   466_553874 2006    Shannon 6.699483e-01  2.161673e-02 1.949859e-02
      10058   466_553874 2006    Simpson 3.098420e-01  8.578298e-03 1.074595e-01
      10059   466_553874 2006 invSimpson 1.448943e+00  1.701966e-02 1.429547e-01
      10060   466_553874 2006        PIE 3.100048e-01  8.602741e-03 1.068875e-01
      10061   466_553874 2006      DomMc 9.086134e-01 -5.555178e-03 3.687522e-04
      10062   466_553874 2006 expShannon 1.954136e+00  4.174625e-02 1.824443e-02
      10063   466_553874 1988          S 8.000000e+00  5.676684e-02 3.045302e-01
      10064   466_553874 1988          N 6.012000e+03 -2.227042e+02 1.599797e-01
      10065   466_553874 1988       maxN 3.618000e+03 -1.980980e+02 1.983522e-01
      10066   466_553874 1988    Shannon 7.361231e-01  2.161673e-02 1.949859e-02
      10067   466_553874 1988    Simpson 4.877239e-01  8.578298e-03 1.074595e-01
      10068   466_553874 1988 invSimpson 1.952072e+00  1.701966e-02 1.429547e-01
      10069   466_553874 1988        PIE 4.878051e-01  8.602741e-03 1.068875e-01
      10070   466_553874 1988      DomMc 9.891883e-01 -5.555178e-03 3.687522e-04
      10071   466_553874 1988 expShannon 2.087826e+00  4.174625e-02 1.824443e-02
      10072   466_553874 1991          S 1.000000e+01  5.676684e-02 3.045302e-01
      10073   466_553874 1991          N 9.613000e+03 -2.227042e+02 1.599797e-01
      10074   466_553874 1991       maxN 9.261000e+03 -1.980980e+02 1.983522e-01
      10075   466_553874 1991    Shannon 1.950754e-01  2.161673e-02 1.949859e-02
      10076   466_553874 1991    Simpson 7.118988e-02  8.578298e-03 1.074595e-01
      10077   466_553874 1991 invSimpson 1.076646e+00  1.701966e-02 1.429547e-01
      10078   466_553874 1991        PIE 7.119728e-02  8.602741e-03 1.068875e-01
      10079   466_553874 1991      DomMc 9.891813e-01 -5.555178e-03 3.687522e-04
      10080   466_553874 1991 expShannon 1.215403e+00  4.174625e-02 1.824443e-02
      10081   466_553874 1996          S 8.000000e+00  5.676684e-02 3.045302e-01
      10082   466_553874 1996          N 1.542200e+04 -2.227042e+02 1.599797e-01
      10083   466_553874 1996       maxN 1.519900e+04 -1.980980e+02 1.983522e-01
      10084   466_553874 1996    Shannon 9.675343e-02  2.161673e-02 1.949859e-02
      10085   466_553874 1996    Simpson 2.865137e-02  8.578298e-03 1.074595e-01
      10086   466_553874 1996 invSimpson 1.029496e+00  1.701966e-02 1.429547e-01
      10087   466_553874 1996        PIE 2.865323e-02  8.602741e-03 1.068875e-01
      10088   466_553874 1996      DomMc 9.917002e-01 -5.555178e-03 3.687522e-04
      10089   466_553874 1996 expShannon 1.101589e+00  4.174625e-02 1.824443e-02
      10090   466_553874 1997          S 8.000000e+00  5.676684e-02 3.045302e-01
      10091   466_553874 1997          N 1.525000e+04 -2.227042e+02 1.599797e-01
      10092   466_553874 1997       maxN 1.417600e+04 -1.980980e+02 1.983522e-01
      10093   466_553874 1997    Shannon 3.081689e-01  2.161673e-02 1.949859e-02
      10094   466_553874 1997    Simpson 1.325629e-01  8.578298e-03 1.074595e-01
      10095   466_553874 1997 invSimpson 1.152821e+00  1.701966e-02 1.429547e-01
      10096   466_553874 1997        PIE 1.325716e-01  8.602741e-03 1.068875e-01
      10097   466_553874 1997      DomMc 9.868852e-01 -5.555178e-03 3.687522e-04
      10098   466_553874 1997 expShannon 1.360931e+00  4.174625e-02 1.824443e-02
      10099   466_553874 1986          S 9.000000e+00  5.676684e-02 3.045302e-01
      10100   466_553874 1986          N 4.793000e+03 -2.227042e+02 1.599797e-01
      10101   466_553874 1986       maxN 4.633000e+03 -1.980980e+02 1.983522e-01
      10102   466_553874 1986    Shannon 1.856423e-01  2.161673e-02 1.949859e-02
      10103   466_553874 1986    Simpson 6.510956e-02  8.578298e-03 1.074595e-01
      10104   466_553874 1986 invSimpson 1.069644e+00  1.701966e-02 1.429547e-01
      10105   466_553874 1986        PIE 6.512314e-02  8.602741e-03 1.068875e-01
      10106   466_553874 1986      DomMc 9.893595e-01 -5.555178e-03 3.687522e-04
      10107   466_553874 1986 expShannon 1.203992e+00  4.174625e-02 1.824443e-02
      10108   466_553874 1990          S 7.000000e+00  5.676684e-02 3.045302e-01
      10109   466_553874 1990          N 2.678000e+03 -2.227042e+02 1.599797e-01
      10110   466_553874 1990       maxN 2.504000e+03 -1.980980e+02 1.983522e-01
      10111   466_553874 1990    Shannon 3.432647e-01  2.161673e-02 1.949859e-02
      10112   466_553874 1990    Simpson 1.247395e-01  8.578298e-03 1.074595e-01
      10113   466_553874 1990 invSimpson 1.142517e+00  1.701966e-02 1.429547e-01
      10114   466_553874 1990        PIE 1.247861e-01  8.602741e-03 1.068875e-01
      10115   466_553874 1990      DomMc 9.574309e-01 -5.555178e-03 3.687522e-04
      10116   466_553874 1990 expShannon 1.409542e+00  4.174625e-02 1.824443e-02
      10117   466_552417 1991          S 1.300000e+01  1.025132e-02 9.088475e-01
      10118   466_552417 1991          N 3.352000e+03 -1.505066e+02 2.645013e-01
      10119   466_552417 1991       maxN 3.126000e+03 -1.253272e+02 3.022446e-01
      10120   466_552417 1991    Shannon 3.637851e-01  6.972926e-03 6.591802e-01
      10121   466_552417 1991    Simpson 1.292122e-01  2.865450e-03 7.400727e-01
      10122   466_552417 1991 invSimpson 1.148385e+00  5.779455e-03 7.808639e-01
      10123   466_552417 1991        PIE 1.292508e-01  2.871514e-03 7.396490e-01
      10124   466_552417 1991      DomMc 9.582339e-01 -1.571519e-03 5.427566e-01
      10125   466_552417 1991 expShannon 1.438765e+00  1.365602e-02 6.723166e-01
      10126   466_552417 1992          S 1.200000e+01  1.025132e-02 9.088475e-01
      10127   466_552417 1992          N 5.289000e+03 -1.505066e+02 2.645013e-01
      10128   466_552417 1992       maxN 4.430000e+03 -1.253272e+02 3.022446e-01
      10129   466_552417 1992    Shannon 7.190893e-01  6.972926e-03 6.591802e-01
      10130   466_552417 1992    Simpson 2.926556e-01  2.865450e-03 7.400727e-01
      10131   466_552417 1992 invSimpson 1.413739e+00  5.779455e-03 7.808639e-01
      10132   466_552417 1992        PIE 2.927110e-01  2.871514e-03 7.396490e-01
      10133   466_552417 1992      DomMc 8.910947e-01 -1.571519e-03 5.427566e-01
      10134   466_552417 1992 expShannon 2.052563e+00  1.365602e-02 6.723166e-01
      10135   466_552417 1997          S 1.200000e+01  1.025132e-02 9.088475e-01
      10136   466_552417 1997          N 2.822000e+03 -1.505066e+02 2.645013e-01
      10137   466_552417 1997       maxN 1.632000e+03 -1.253272e+02 3.022446e-01
      10138   466_552417 1997    Shannon 1.223730e+00  6.972926e-03 6.591802e-01
      10139   466_552417 1997    Simpson 5.920451e-01  2.865450e-03 7.400727e-01
      10140   466_552417 1997 invSimpson 2.451251e+00  5.779455e-03 7.808639e-01
      10141   466_552417 1997        PIE 5.922550e-01  2.871514e-03 7.396490e-01
      10142   466_552417 1997      DomMc 8.377038e-01 -1.571519e-03 5.427566e-01
      10143   466_552417 1997 expShannon 3.399844e+00  1.365602e-02 6.723166e-01
      10144   466_552417 2002          S 1.300000e+01  1.025132e-02 9.088475e-01
      10145   466_552417 2002          N 2.133000e+03 -1.505066e+02 2.645013e-01
      10146   466_552417 2002       maxN 1.484000e+03 -1.253272e+02 3.022446e-01
      10147   466_552417 2002    Shannon 1.061085e+00  6.972926e-03 6.591802e-01
      10148   466_552417 2002    Simpson 4.894822e-01  2.865450e-03 7.400727e-01
      10149   466_552417 2002 invSimpson 1.958796e+00  5.779455e-03 7.808639e-01
      10150   466_552417 2002        PIE 4.897118e-01  2.871514e-03 7.396490e-01
      10151   466_552417 2002      DomMc 8.237225e-01 -1.571519e-03 5.427566e-01
      10152   466_552417 2002 expShannon 2.889504e+00  1.365602e-02 6.723166e-01
      10153   466_552417 1996          S 1.000000e+01  1.025132e-02 9.088475e-01
      10154   466_552417 1996          N 9.656000e+03 -1.505066e+02 2.645013e-01
      10155   466_552417 1996       maxN 7.099000e+03 -1.253272e+02 3.022446e-01
      10156   466_552417 1996    Shannon 7.622859e-01  6.972926e-03 6.591802e-01
      10157   466_552417 1996    Simpson 4.142942e-01  2.865450e-03 7.400727e-01
      10158   466_552417 1996 invSimpson 1.707342e+00  5.779455e-03 7.808639e-01
      10159   466_552417 1996        PIE 4.143372e-01  2.871514e-03 7.396490e-01
      10160   466_552417 1996      DomMc 9.425228e-01 -1.571519e-03 5.427566e-01
      10161   466_552417 1996 expShannon 2.143170e+00  1.365602e-02 6.723166e-01
      10162   466_552417 2001          S 1.000000e+01  1.025132e-02 9.088475e-01
      10163   466_552417 2001          N 1.444000e+03 -1.505066e+02 2.645013e-01
      10164   466_552417 2001       maxN 1.048000e+03 -1.253272e+02 3.022446e-01
      10165   466_552417 2001    Shannon 8.448208e-01  6.972926e-03 6.591802e-01
      10166   466_552417 2001    Simpson 4.320323e-01  2.865450e-03 7.400727e-01
      10167   466_552417 2001 invSimpson 1.760663e+00  5.779455e-03 7.808639e-01
      10168   466_552417 2001        PIE 4.323316e-01  2.871514e-03 7.396490e-01
      10169   466_552417 2001      DomMc 9.224377e-01 -1.571519e-03 5.427566e-01
      10170   466_552417 2001 expShannon 2.327561e+00  1.365602e-02 6.723166e-01
      10171   466_552417 2003          S 1.100000e+01  1.025132e-02 9.088475e-01
      10172   466_552417 2003          N 1.266000e+03 -1.505066e+02 2.645013e-01
      10173   466_552417 2003       maxN 1.024000e+03 -1.253272e+02 3.022446e-01
      10174   466_552417 2003    Shannon 7.721592e-01  6.972926e-03 6.591802e-01
      10175   466_552417 2003    Simpson 3.350591e-01  2.865450e-03 7.400727e-01
      10176   466_552417 2003 invSimpson 1.503893e+00  5.779455e-03 7.808639e-01
      10177   466_552417 2003        PIE 3.353240e-01  2.871514e-03 7.396490e-01
      10178   466_552417 2003      DomMc 8.965245e-01 -1.571519e-03 5.427566e-01
      10179   466_552417 2003 expShannon 2.164435e+00  1.365602e-02 6.723166e-01
      10180   466_552417 1999          S 9.000000e+00  1.025132e-02 9.088475e-01
      10181   466_552417 1999          N 8.806000e+03 -1.505066e+02 2.645013e-01
      10182   466_552417 1999       maxN 8.311000e+03 -1.253272e+02 3.022446e-01
      10183   466_552417 1999    Shannon 2.920053e-01  6.972926e-03 6.591802e-01
      10184   466_552417 1999    Simpson 1.082766e-01  2.865450e-03 7.400727e-01
      10185   466_552417 1999 invSimpson 1.121424e+00  5.779455e-03 7.808639e-01
      10186   466_552417 1999        PIE 1.082889e-01  2.871514e-03 7.396490e-01
      10187   466_552417 1999      DomMc 9.670679e-01 -1.571519e-03 5.427566e-01
      10188   466_552417 1999 expShannon 1.339110e+00  1.365602e-02 6.723166e-01
      10189   466_552417 2008          S 1.100000e+01  1.025132e-02 9.088475e-01
      10190   466_552417 2008          N 3.792000e+03 -1.505066e+02 2.645013e-01
      10191   466_552417 2008       maxN 3.467000e+03 -1.253272e+02 3.022446e-01
      10192   466_552417 2008    Shannon 4.129790e-01  6.972926e-03 6.591802e-01
      10193   466_552417 2008    Simpson 1.617603e-01  2.865450e-03 7.400727e-01
      10194   466_552417 2008 invSimpson 1.192976e+00  5.779455e-03 7.808639e-01
      10195   466_552417 2008        PIE 1.618030e-01  2.871514e-03 7.396490e-01
      10196   466_552417 2008      DomMc 9.554325e-01 -1.571519e-03 5.427566e-01
      10197   466_552417 2008 expShannon 1.511313e+00  1.365602e-02 6.723166e-01
      10198   466_552417 2005          S 8.000000e+00  1.025132e-02 9.088475e-01
      10199   466_552417 2005          N 5.660000e+03 -1.505066e+02 2.645013e-01
      10200   466_552417 2005       maxN 5.425000e+03 -1.253272e+02 3.022446e-01
      10201   466_552417 2005    Shannon 2.275783e-01  6.972926e-03 6.591802e-01
      10202   466_552417 2005    Simpson 8.068998e-02  2.865450e-03 7.400727e-01
      10203   466_552417 2005 invSimpson 1.087772e+00  5.779455e-03 7.808639e-01
      10204   466_552417 2005        PIE 8.070424e-02  2.871514e-03 7.396490e-01
      10205   466_552417 2005      DomMc 9.814488e-01 -1.571519e-03 5.427566e-01
      10206   466_552417 2005 expShannon 1.255556e+00  1.365602e-02 6.723166e-01
      10207   466_552417 1986          S 8.000000e+00  1.025132e-02 9.088475e-01
      10208   466_552417 1986          N 5.742000e+03 -1.505066e+02 2.645013e-01
      10209   466_552417 1986       maxN 5.505000e+03 -1.253272e+02 3.022446e-01
      10210   466_552417 1986    Shannon 2.042120e-01  6.972926e-03 6.591802e-01
      10211   466_552417 1986    Simpson 7.973913e-02  2.865450e-03 7.400727e-01
      10212   466_552417 1986 invSimpson 1.086648e+00  5.779455e-03 7.808639e-01
      10213   466_552417 1986        PIE 7.975302e-02  2.871514e-03 7.396490e-01
      10214   466_552417 1986      DomMc 9.916405e-01 -1.571519e-03 5.427566e-01
      10215   466_552417 1986 expShannon 1.226558e+00  1.365602e-02 6.723166e-01
      10216   466_552417 1993          S 1.100000e+01  1.025132e-02 9.088475e-01
      10217   466_552417 1993          N 8.679000e+03 -1.505066e+02 2.645013e-01
      10218   466_552417 1993       maxN 7.531000e+03 -1.253272e+02 3.022446e-01
      10219   466_552417 1993    Shannon 5.596919e-01  6.972926e-03 6.591802e-01
      10220   466_552417 1993    Simpson 2.407546e-01  2.865450e-03 7.400727e-01
      10221   466_552417 1993 invSimpson 1.317097e+00  5.779455e-03 7.808639e-01
      10222   466_552417 1993        PIE 2.407823e-01  2.871514e-03 7.396490e-01
      10223   466_552417 1993      DomMc 9.323655e-01 -1.571519e-03 5.427566e-01
      10224   466_552417 1993 expShannon 1.750133e+00  1.365602e-02 6.723166e-01
      10225   466_552417 1995          S 8.000000e+00  1.025132e-02 9.088475e-01
      10226   466_552417 1995          N 5.119000e+03 -1.505066e+02 2.645013e-01
      10227   466_552417 1995       maxN 3.376000e+03 -1.253272e+02 3.022446e-01
      10228   466_552417 1995    Shannon 7.829590e-01  6.972926e-03 6.591802e-01
      10229   466_552417 1995    Simpson 4.704280e-01  2.865450e-03 7.400727e-01
      10230   466_552417 1995 invSimpson 1.888317e+00  5.779455e-03 7.808639e-01
      10231   466_552417 1995        PIE 4.705200e-01  2.871514e-03 7.396490e-01
      10232   466_552417 1995      DomMc 9.660090e-01 -1.571519e-03 5.427566e-01
      10233   466_552417 1995 expShannon 2.187937e+00  1.365602e-02 6.723166e-01
      10234   466_554601 1991          S 8.000000e+00  1.464982e-01 5.787557e-02
      10235   466_554601 1991          N 1.665000e+03 -4.310467e+02 3.509407e-01
      10236   466_554601 1991       maxN 1.335000e+03 -4.118015e+02 1.562547e-01
      10237   466_554601 1991    Shannon 6.422257e-01  4.867241e-02 2.722989e-04
      10238   466_554601 1991    Simpson 3.301182e-01  2.235637e-02 2.306144e-03
      10239   466_554601 1991 invSimpson 1.492801e+00  5.268781e-02 2.870722e-03
      10240   466_554601 1991        PIE 3.303166e-01  2.238263e-02 2.284308e-03
      10241   466_554601 1991      DomMc 9.651652e-01 -1.002079e-02 1.768519e-03
      10242   466_554601 1991 expShannon 1.900707e+00  1.000035e-01 1.496906e-04
      10243   466_554601 1992          S 1.100000e+01  1.464982e-01 5.787557e-02
      10244   466_554601 1992          N 6.916000e+03 -4.310467e+02 3.509407e-01
      10245   466_554601 1992       maxN 6.100000e+03 -4.118015e+02 1.562547e-01
      10246   466_554601 1992    Shannon 4.475724e-01  4.867241e-02 2.722989e-04
      10247   466_554601 1992    Simpson 2.122403e-01  2.235637e-02 2.306144e-03
      10248   466_554601 1992 invSimpson 1.269423e+00  5.268781e-02 2.870722e-03
      10249   466_554601 1992        PIE 2.122710e-01  2.238263e-02 2.284308e-03
      10250   466_554601 1992      DomMc 9.806246e-01 -1.002079e-02 1.768519e-03
      10251   466_554601 1992 expShannon 1.564510e+00  1.000035e-01 1.496906e-04
      10252   466_554601 2005          S 1.200000e+01  1.464982e-01 5.787557e-02
      10253   466_554601 2005          N 2.312000e+03 -4.310467e+02 3.509407e-01
      10254   466_554601 2005       maxN 1.398000e+03 -4.118015e+02 1.562547e-01
      10255   466_554601 2005    Shannon 1.257692e+00  4.867241e-02 2.722989e-04
      10256   466_554601 2005    Simpson 5.922122e-01  2.235637e-02 2.306144e-03
      10257   466_554601 2005 invSimpson 2.452256e+00  5.268781e-02 2.870722e-03
      10258   466_554601 2005        PIE 5.924685e-01  2.238263e-02 2.284308e-03
      10259   466_554601 2005      DomMc 7.409170e-01 -1.002079e-02 1.768519e-03
      10260   466_554601 2005 expShannon 3.517293e+00  1.000035e-01 1.496906e-04
      10261   466_554601 1996          S 1.100000e+01  1.464982e-01 5.787557e-02
      10262   466_554601 1996          N 2.889000e+03 -4.310467e+02 3.509407e-01
      10263   466_554601 1996       maxN 2.166000e+03 -4.118015e+02 1.562547e-01
      10264   466_554601 1996    Shannon 9.383926e-01  4.867241e-02 2.722989e-04
      10265   466_554601 1996    Simpson 4.203632e-01  2.235637e-02 2.306144e-03
      10266   466_554601 1996 invSimpson 1.725218e+00  5.268781e-02 2.870722e-03
      10267   466_554601 1996        PIE 4.205087e-01  2.238263e-02 2.284308e-03
      10268   466_554601 1996      DomMc 8.532364e-01 -1.002079e-02 1.768519e-03
      10269   466_554601 1996 expShannon 2.555870e+00  1.000035e-01 1.496906e-04
      10270   466_554601 2006          S 1.000000e+01  1.464982e-01 5.787557e-02
      10271   466_554601 2006          N 1.010000e+03 -4.310467e+02 3.509407e-01
      10272   466_554601 2006       maxN 7.350000e+02 -4.118015e+02 1.562547e-01
      10273   466_554601 2006    Shannon 9.912973e-01  4.867241e-02 2.722989e-04
      10274   466_554601 2006    Simpson 4.473659e-01  2.235637e-02 2.306144e-03
      10275   466_554601 2006 invSimpson 1.809516e+00  5.268781e-02 2.870722e-03
      10276   466_554601 2006        PIE 4.478093e-01  2.238263e-02 2.284308e-03
      10277   466_554601 2006      DomMc 8.633663e-01 -1.002079e-02 1.768519e-03
      10278   466_554601 2006 expShannon 2.694728e+00  1.000035e-01 1.496906e-04
      10279   466_554601 1986          S 6.000000e+00  1.464982e-01 5.787557e-02
      10280   466_554601 1986          N 1.215100e+04 -4.310467e+02 3.509407e-01
      10281   466_554601 1986       maxN 1.208100e+04 -4.118015e+02 1.562547e-01
      10282   466_554601 1986    Shannon 4.275398e-02  4.867241e-02 2.722989e-04
      10283   466_554601 1986    Simpson 1.147758e-02  2.235637e-02 2.306144e-03
      10284   466_554601 1986 invSimpson 1.011611e+00  5.268781e-02 2.870722e-03
      10285   466_554601 1986        PIE 1.147852e-02  2.238263e-02 2.284308e-03
      10286   466_554601 1986      DomMc 9.965435e-01 -1.002079e-02 1.768519e-03
      10287   466_554601 1986 expShannon 1.043681e+00  1.000035e-01 1.496906e-04
      10288   466_554601 2003          S 1.000000e+01  1.464982e-01 5.787557e-02
      10289   466_554601 2003          N 5.870000e+02 -4.310467e+02 3.509407e-01
      10290   466_554601 2003       maxN 4.220000e+02 -4.118015e+02 1.562547e-01
      10291   466_554601 2003    Shannon 1.023745e+00  4.867241e-02 2.722989e-04
      10292   466_554601 2003    Simpson 4.591823e-01  2.235637e-02 2.306144e-03
      10293   466_554601 2003 invSimpson 1.849052e+00  5.268781e-02 2.870722e-03
      10294   466_554601 2003        PIE 4.599659e-01  2.238263e-02 2.284308e-03
      10295   466_554601 2003      DomMc 8.534923e-01 -1.002079e-02 1.768519e-03
      10296   466_554601 2003 expShannon 2.783599e+00  1.000035e-01 1.496906e-04
      10297   466_554601 1990          S 9.000000e+00  1.464982e-01 5.787557e-02
      10298   466_554601 1990          N 1.020800e+04 -4.310467e+02 3.509407e-01
      10299   466_554601 1990       maxN 9.581000e+03 -4.118015e+02 1.562547e-01
      10300   466_554601 1990    Shannon 2.744532e-01  4.867241e-02 2.722989e-04
      10301   466_554601 1990    Simpson 1.164377e-01  2.235637e-02 2.306144e-03
      10302   466_554601 1990 invSimpson 1.131782e+00  5.268781e-02 2.870722e-03
      10303   466_554601 1990        PIE 1.164491e-01  2.238263e-02 2.284308e-03
      10304   466_554601 1990      DomMc 9.896160e-01 -1.002079e-02 1.768519e-03
      10305   466_554601 1990 expShannon 1.315811e+00  1.000035e-01 1.496906e-04
      10306   466_554601 1988          S 1.000000e+01  1.464982e-01 5.787557e-02
      10307   466_554601 1988          N 2.398000e+03 -4.310467e+02 3.509407e-01
      10308   466_554601 1988       maxN 2.212000e+03 -4.118015e+02 1.562547e-01
      10309   466_554601 1988    Shannon 3.907113e-01  4.867241e-02 2.722989e-04
      10310   466_554601 1988    Simpson 1.475107e-01  2.235637e-02 2.306144e-03
      10311   466_554601 1988 invSimpson 1.173035e+00  5.268781e-02 2.870722e-03
      10312   466_554601 1988        PIE 1.475722e-01  2.238263e-02 2.284308e-03
      10313   466_554601 1988      DomMc 9.503753e-01 -1.002079e-02 1.768519e-03
      10314   466_554601 1988 expShannon 1.478032e+00  1.000035e-01 1.496906e-04
      10315   466_554601 1994          S 9.000000e+00  1.464982e-01 5.787557e-02
      10316   466_554601 1994          N 3.133100e+04 -4.310467e+02 3.509407e-01
      10317   466_554601 1994       maxN 1.865100e+04 -4.118015e+02 1.562547e-01
      10318   466_554601 1994    Shannon 7.998689e-01  4.867241e-02 2.722989e-04
      10319   466_554601 1994    Simpson 4.998483e-01  2.235637e-02 2.306144e-03
      10320   466_554601 1994 invSimpson 1.999394e+00  5.268781e-02 2.870722e-03
      10321   466_554601 1994        PIE 4.998643e-01  2.238263e-02 2.284308e-03
      10322   466_554601 1994      DomMc 9.769238e-01 -1.002079e-02 1.768519e-03
      10323   466_554601 1994 expShannon 2.225249e+00  1.000035e-01 1.496906e-04
      10324   466_556784 1991          S 1.300000e+01  1.000000e+00 2.721805e-14
      10325   466_556784 1991          N 2.228000e+03 -2.506429e+02 5.029834e-01
      10326   466_556784 1991       maxN 1.650000e+03 -3.775714e+02 2.816882e-01
      10327   466_556784 1991    Shannon 9.587005e-01  1.977807e-01 2.407331e-01
      10328   466_556784 1991    Simpson 4.254385e-01  1.003300e-01 2.319368e-01
      10329   466_556784 1991 invSimpson 1.740458e+00  2.041088e-01 2.254441e-01
      10330   466_556784 1991        PIE 4.256296e-01  1.003802e-01 2.318950e-01
      10331   466_556784 1991      DomMc 8.967684e-01 -1.816704e-02 3.146567e-01
      10332   466_556784 1991 expShannon 2.608305e+00  3.960820e-01 2.334909e-01
      10333   466_556784 1988          S 1.000000e+01  1.000000e+00 2.721805e-14
      10334   466_556784 1988          N 3.126000e+03 -2.506429e+02 5.029834e-01
      10335   466_556784 1988       maxN 2.886000e+03 -3.775714e+02 2.816882e-01
      10336   466_556784 1988    Shannon 4.107212e-01  1.977807e-01 2.407331e-01
      10337   466_556784 1988    Simpson 1.465385e-01  1.003300e-01 2.319368e-01
      10338   466_556784 1988 invSimpson 1.171699e+00  2.041088e-01 2.254441e-01
      10339   466_556784 1988        PIE 1.465854e-01  1.003802e-01 2.318950e-01
      10340   466_556784 1988      DomMc 9.456174e-01 -1.816704e-02 3.146567e-01
      10341   466_556784 1988 expShannon 1.507905e+00  3.960820e-01 2.334909e-01
      10342   466_556784 1989          S 1.100000e+01  1.000000e+00 2.721805e-14
      10343   466_556784 1989          N 2.145000e+03 -2.506429e+02 5.029834e-01
      10344   466_556784 1989       maxN 1.992000e+03 -3.775714e+02 2.816882e-01
      10345   466_556784 1989    Shannon 3.816884e-01  1.977807e-01 2.407331e-01
      10346   466_556784 1989    Simpson 1.364192e-01  1.003300e-01 2.319368e-01
      10347   466_556784 1989 invSimpson 1.157969e+00  2.041088e-01 2.254441e-01
      10348   466_556784 1989        PIE 1.364828e-01  1.003802e-01 2.318950e-01
      10349   466_556784 1989      DomMc 9.557110e-01 -1.816704e-02 3.146567e-01
      10350   466_556784 1989 expShannon 1.464756e+00  3.960820e-01 2.334909e-01
      10351   466_556055 1991          S 1.300000e+01  1.328976e-01 3.828755e-01
      10352   466_556055 1991          N 5.467000e+03 -7.380185e+02 8.119958e-02
      10353   466_556055 1991       maxN 3.669000e+03 -4.899336e+02 4.974822e-02
      10354   466_556055 1991    Shannon 7.713818e-01  1.993526e-02 1.209707e-01
      10355   466_556055 1991    Simpson 4.583082e-01  7.008899e-03 3.588641e-01
      10356   466_556055 1991 invSimpson 1.846068e+00  2.894357e-02 2.878659e-01
      10357   466_556055 1991        PIE 4.583920e-01  7.019834e-03 3.582758e-01
      10358   466_556055 1991      DomMc 9.729285e-01 -4.488659e-03 2.126341e-01
      10359   466_556055 1991 expShannon 2.162753e+00  5.069230e-02 1.022688e-01
      10360   466_556055 2001          S 1.000000e+01  1.328976e-01 3.828755e-01
      10361   466_556055 2001          N 2.513000e+03 -7.380185e+02 8.119958e-02
      10362   466_556055 2001       maxN 1.507000e+03 -4.899336e+02 4.974822e-02
      10363   466_556055 2001    Shannon 1.074739e+00  1.993526e-02 1.209707e-01
      10364   466_556055 2001    Simpson 5.599828e-01  7.008899e-03 3.588641e-01
      10365   466_556055 2001 invSimpson 2.272638e+00  2.894357e-02 2.878659e-01
      10366   466_556055 2001        PIE 5.602057e-01  7.019834e-03 3.582758e-01
      10367   466_556055 2001      DomMc 8.710704e-01 -4.488659e-03 2.126341e-01
      10368   466_556055 2001 expShannon 2.929228e+00  5.069230e-02 1.022688e-01
      10369   466_556055 1999          S 9.000000e+00  1.328976e-01 3.828755e-01
      10370   466_556055 1999          N 2.419000e+03 -7.380185e+02 8.119958e-02
      10371   466_556055 1999       maxN 1.715000e+03 -4.899336e+02 4.974822e-02
      10372   466_556055 1999    Shannon 9.834373e-01  1.993526e-02 1.209707e-01
      10373   466_556055 1999    Simpson 4.682439e-01  7.008899e-03 3.588641e-01
      10374   466_556055 1999 invSimpson 1.880562e+00  2.894357e-02 2.878659e-01
      10375   466_556055 1999        PIE 4.684376e-01  7.019834e-03 3.582758e-01
      10376   466_556055 1999      DomMc 8.495246e-01 -4.488659e-03 2.126341e-01
      10377   466_556055 1999 expShannon 2.673630e+00  5.069230e-02 1.022688e-01
      10378   466_556055 2007          S 1.500000e+01  1.328976e-01 3.828755e-01
      10379   466_556055 2007          N 3.089000e+03 -7.380185e+02 8.119958e-02
      10380   466_556055 2007       maxN 1.599000e+03 -4.899336e+02 4.974822e-02
      10381   466_556055 2007    Shannon 1.150968e+00  1.993526e-02 1.209707e-01
      10382   466_556055 2007    Simpson 6.067512e-01  7.008899e-03 3.588641e-01
      10383   466_556055 2007 invSimpson 2.542919e+00  2.894357e-02 2.878659e-01
      10384   466_556055 2007        PIE 6.069477e-01  7.019834e-03 3.582758e-01
      10385   466_556055 2007      DomMc 8.588540e-01 -4.488659e-03 2.126341e-01
      10386   466_556055 2007 expShannon 3.161250e+00  5.069230e-02 1.022688e-01
      10387   466_556055 2003          S 1.000000e+01  1.328976e-01 3.828755e-01
      10388   466_556055 2003          N 3.371000e+03 -7.380185e+02 8.119958e-02
      10389   466_556055 2003       maxN 2.422000e+03 -4.899336e+02 4.974822e-02
      10390   466_556055 2003    Shannon 8.007090e-01  1.993526e-02 1.209707e-01
      10391   466_556055 2003    Simpson 4.293129e-01  7.008899e-03 3.588641e-01
      10392   466_556055 2003 invSimpson 1.752274e+00  2.894357e-02 2.878659e-01
      10393   466_556055 2003        PIE 4.294403e-01  7.019834e-03 3.582758e-01
      10394   466_556055 2003      DomMc 9.504598e-01 -4.488659e-03 2.126341e-01
      10395   466_556055 2003 expShannon 2.227119e+00  5.069230e-02 1.022688e-01
      10396   466_556055 1992          S 9.000000e+00  1.328976e-01 3.828755e-01
      10397   466_556055 1992          N 2.135000e+04 -7.380185e+02 8.119958e-02
      10398   466_556055 1992       maxN 1.227600e+04 -4.899336e+02 4.974822e-02
      10399   466_556055 1992    Shannon 9.612474e-01  1.993526e-02 1.209707e-01
      10400   466_556055 1992    Simpson 5.636022e-01  7.008899e-03 3.588641e-01
      10401   466_556055 1992 invSimpson 2.291487e+00  2.894357e-02 2.878659e-01
      10402   466_556055 1992        PIE 5.636286e-01  7.019834e-03 3.582758e-01
      10403   466_556055 1992      DomMc 8.782201e-01 -4.488659e-03 2.126341e-01
      10404   466_556055 1992 expShannon 2.614956e+00  5.069230e-02 1.022688e-01
      10405   466_556055 1993          S 1.000000e+01  1.328976e-01 3.828755e-01
      10406   466_556055 1993          N 1.117100e+04 -7.380185e+02 8.119958e-02
      10407   466_556055 1993       maxN 8.370000e+03 -4.899336e+02 4.974822e-02
      10408   466_556055 1993    Shannon 6.693200e-01  1.993526e-02 1.209707e-01
      10409   466_556055 1993    Simpson 3.865210e-01  7.008899e-03 3.588641e-01
      10410   466_556055 1993 invSimpson 1.630048e+00  2.894357e-02 2.878659e-01
      10411   466_556055 1993        PIE 3.865556e-01  7.019834e-03 3.582758e-01
      10412   466_556055 1993      DomMc 9.769940e-01 -4.488659e-03 2.126341e-01
      10413   466_556055 1993 expShannon 1.952909e+00  5.069230e-02 1.022688e-01
      10414   466_556055 1996          S 1.000000e+01  1.328976e-01 3.828755e-01
      10415   466_556055 1996          N 8.063000e+03 -7.380185e+02 8.119958e-02
      10416   466_556055 1996       maxN 6.787000e+03 -4.899336e+02 4.974822e-02
      10417   466_556055 1996    Shannon 6.194058e-01  1.993526e-02 1.209707e-01
      10418   466_556055 1996    Simpson 2.815887e-01  7.008899e-03 3.588641e-01
      10419   466_556055 1996 invSimpson 1.391960e+00  2.894357e-02 2.878659e-01
      10420   466_556055 1996        PIE 2.816237e-01  7.019834e-03 3.582758e-01
      10421   466_556055 1996      DomMc 9.140518e-01 -4.488659e-03 2.126341e-01
      10422   466_556055 1996 expShannon 1.857824e+00  5.069230e-02 1.022688e-01
      10423   466_550230 1991          S 1.400000e+01 -1.819580e-01 1.404040e-01
      10424   466_550230 1991          N 8.539000e+03 -4.359621e+02 1.951066e-02
      10425   466_550230 1991       maxN 7.653000e+03 -2.879595e+02 7.749457e-03
      10426   466_550230 1991    Shannon 4.352653e-01  2.283403e-04 9.896457e-01
      10427   466_550230 1991    Simpson 1.906048e-01  1.899003e-03 8.588078e-01
      10428   466_550230 1991 invSimpson 1.235490e+00 -1.326860e-02 7.580714e-01
      10429   466_550230 1991        PIE 1.906271e-01  1.910403e-03 8.579888e-01
      10430   466_550230 1991      DomMc 9.734161e-01  4.838032e-03 3.907186e-01
      10431   466_550230 1991 expShannon 1.545373e+00 -1.111936e-02 7.964197e-01
      10432   466_550230 1994          S 1.100000e+01 -1.819580e-01 1.404040e-01
      10433   466_550230 1994          N 4.749000e+03 -4.359621e+02 1.951066e-02
      10434   466_550230 1994       maxN 3.020000e+03 -2.879595e+02 7.749457e-03
      10435   466_550230 1994    Shannon 1.052833e+00  2.283403e-04 9.896457e-01
      10436   466_550230 1994    Simpson 5.432318e-01  1.899003e-03 8.588078e-01
      10437   466_550230 1994 invSimpson 2.189294e+00 -1.326860e-02 7.580714e-01
      10438   466_550230 1994        PIE 5.433462e-01  1.910403e-03 8.579888e-01
      10439   466_550230 1994      DomMc 7.967993e-01  4.838032e-03 3.907186e-01
      10440   466_550230 1994 expShannon 2.865757e+00 -1.111936e-02 7.964197e-01
      10441   466_550230 1999          S 1.200000e+01 -1.819580e-01 1.404040e-01
      10442   466_550230 1999          N 5.322000e+03 -4.359621e+02 1.951066e-02
      10443   466_550230 1999       maxN 3.730000e+03 -2.879595e+02 7.749457e-03
      10444   466_550230 1999    Shannon 8.466041e-01  2.283403e-04 9.896457e-01
      10445   466_550230 1999    Simpson 4.535493e-01  1.899003e-03 8.588078e-01
      10446   466_550230 1999 invSimpson 1.829991e+00 -1.326860e-02 7.580714e-01
      10447   466_550230 1999        PIE 4.536345e-01  1.910403e-03 8.579888e-01
      10448   466_550230 1999      DomMc 9.316047e-01  4.838032e-03 3.907186e-01
      10449   466_550230 1999 expShannon 2.331715e+00 -1.111936e-02 7.964197e-01
      10450   466_550230 2002          S 1.100000e+01 -1.819580e-01 1.404040e-01
      10451   466_550230 2002          N 4.584000e+03 -4.359621e+02 1.951066e-02
      10452   466_550230 2002       maxN 3.468000e+03 -2.879595e+02 7.749457e-03
      10453   466_550230 2002    Shannon 8.441241e-01  2.283403e-04 9.896457e-01
      10454   466_550230 2002    Simpson 4.043000e-01  1.899003e-03 8.588078e-01
      10455   466_550230 2002 invSimpson 1.678697e+00 -1.326860e-02 7.580714e-01
      10456   466_550230 2002        PIE 4.043882e-01  1.910403e-03 8.579888e-01
      10457   466_550230 2002      DomMc 8.941972e-01  4.838032e-03 3.907186e-01
      10458   466_550230 2002 expShannon 2.325940e+00 -1.111936e-02 7.964197e-01
      10459   466_550230 2003          S 1.200000e+01 -1.819580e-01 1.404040e-01
      10460   466_550230 2003          N 3.898000e+03 -4.359621e+02 1.951066e-02
      10461   466_550230 2003       maxN 2.902000e+03 -2.879595e+02 7.749457e-03
      10462   466_550230 2003    Shannon 7.253987e-01  2.283403e-04 9.896457e-01
      10463   466_550230 2003    Simpson 3.966417e-01  1.899003e-03 8.588078e-01
      10464   466_550230 2003 invSimpson 1.657390e+00 -1.326860e-02 7.580714e-01
      10465   466_550230 2003        PIE 3.967435e-01  1.910403e-03 8.579888e-01
      10466   466_550230 2003      DomMc 9.653669e-01  4.838032e-03 3.907186e-01
      10467   466_550230 2003 expShannon 2.065555e+00 -1.111936e-02 7.964197e-01
      10468   466_550230 2005          S 1.000000e+01 -1.819580e-01 1.404040e-01
      10469   466_550230 2005          N 2.260000e+03 -4.359621e+02 1.951066e-02
      10470   466_550230 2005       maxN 1.802000e+03 -2.879595e+02 7.749457e-03
      10471   466_550230 2005    Shannon 7.828621e-01  2.283403e-04 9.896457e-01
      10472   466_550230 2005    Simpson 3.503630e-01  1.899003e-03 8.588078e-01
      10473   466_550230 2005 invSimpson 1.539321e+00 -1.326860e-02 7.580714e-01
      10474   466_550230 2005        PIE 3.505181e-01  1.910403e-03 8.579888e-01
      10475   466_550230 2005      DomMc 8.973451e-01  4.838032e-03 3.907186e-01
      10476   466_550230 2005 expShannon 2.187725e+00 -1.111936e-02 7.964197e-01
      10477   466_550230 1995          S 9.000000e+00 -1.819580e-01 1.404040e-01
      10478   466_550230 1995          N 1.154300e+04 -4.359621e+02 1.951066e-02
      10479   466_550230 1995       maxN 4.546000e+03 -2.879595e+02 7.749457e-03
      10480   466_550230 1995    Shannon 1.276661e+00  2.283403e-04 9.896457e-01
      10481   466_550230 1995    Simpson 6.881775e-01  1.899003e-03 8.588078e-01
      10482   466_550230 1995 invSimpson 3.206953e+00 -1.326860e-02 7.580714e-01
      10483   466_550230 1995        PIE 6.882372e-01  1.910403e-03 8.579888e-01
      10484   466_550230 1995      DomMc 7.488521e-01  4.838032e-03 3.907186e-01
      10485   466_550230 1995 expShannon 3.584651e+00 -1.111936e-02 7.964197e-01
      10486   466_550230 2008          S 8.000000e+00 -1.819580e-01 1.404040e-01
      10487   466_550230 2008          N 1.739000e+03 -4.359621e+02 1.951066e-02
      10488   466_550230 2008       maxN 1.004000e+03 -2.879595e+02 7.749457e-03
      10489   466_550230 2008    Shannon 8.960979e-01  2.283403e-04 9.896457e-01
      10490   466_550230 2008    Simpson 5.309821e-01  1.899003e-03 8.588078e-01
      10491   466_550230 2008 invSimpson 2.132115e+00 -1.326860e-02 7.580714e-01
      10492   466_550230 2008        PIE 5.312876e-01  1.910403e-03 8.579888e-01
      10493   466_550230 2008      DomMc 9.430707e-01  4.838032e-03 3.907186e-01
      10494   466_550230 2008 expShannon 2.450024e+00 -1.111936e-02 7.964197e-01
      10495   466_553875 1992          S 1.200000e+01  1.131222e-01 3.830147e-01
      10496   466_553875 1992          N 2.475000e+03 -3.661742e+02 1.706022e-01
      10497   466_553875 1992       maxN 2.391000e+03 -2.894118e+02 1.080249e-01
      10498   466_553875 1992    Shannon 2.160906e-01  5.235038e-02 1.932662e-02
      10499   466_553875 1992    Simpson 6.654341e-02  2.229011e-02 4.157315e-02
      10500   466_553875 1992 invSimpson 1.071287e+00  7.751703e-02 5.111492e-02
      10501   466_553875 1992        PIE 6.657031e-02  2.237774e-02 4.126267e-02
      10502   466_553875 1992      DomMc 9.733333e-01 -1.297362e-02 1.408984e-02
      10503   466_553875 1992 expShannon 1.241215e+00  1.291201e-01 2.421291e-02
      10504   466_553875 1993          S 1.200000e+01  1.131222e-01 3.830147e-01
      10505   466_553875 1993          N 1.858400e+04 -3.661742e+02 1.706022e-01
      10506   466_553875 1993       maxN 1.154900e+04 -2.894118e+02 1.080249e-01
      10507   466_553875 1993    Shannon 8.134969e-01  5.235038e-02 1.932662e-02
      10508   466_553875 1993    Simpson 4.920975e-01  2.229011e-02 4.157315e-02
      10509   466_553875 1993 invSimpson 1.968882e+00  7.751703e-02 5.111492e-02
      10510   466_553875 1993        PIE 4.921240e-01  2.237774e-02 4.126267e-02
      10511   466_553875 1993      DomMc 9.699204e-01 -1.297362e-02 1.408984e-02
      10512   466_553875 1993 expShannon 2.255782e+00  1.291201e-01 2.421291e-02
      10513   466_553875 1997          S 1.500000e+01  1.131222e-01 3.830147e-01
      10514   466_553875 1997          N 2.322000e+03 -3.661742e+02 1.706022e-01
      10515   466_553875 1997       maxN 1.689000e+03 -2.894118e+02 1.080249e-01
      10516   466_553875 1997    Shannon 1.075924e+00  5.235038e-02 1.932662e-02
      10517   466_553875 1997    Simpson 4.555033e-01  2.229011e-02 4.157315e-02
      10518   466_553875 1997 invSimpson 1.836559e+00  7.751703e-02 5.111492e-02
      10519   466_553875 1997        PIE 4.556996e-01  2.237774e-02 4.126267e-02
      10520   466_553875 1997      DomMc 8.221361e-01 -1.297362e-02 1.408984e-02
      10521   466_553875 1997 expShannon 2.932702e+00  1.291201e-01 2.421291e-02
      10522   466_553875 1996          S 1.200000e+01  1.131222e-01 3.830147e-01
      10523   466_553875 1996          N 8.697000e+03 -3.661742e+02 1.706022e-01
      10524   466_553875 1996       maxN 8.410000e+03 -2.894118e+02 1.080249e-01
      10525   466_553875 1996    Shannon 1.965381e-01  5.235038e-02 1.932662e-02
      10526   466_553875 1996    Simpson 6.457474e-02  2.229011e-02 4.157315e-02
      10527   466_553875 1996 invSimpson 1.069032e+00  7.751703e-02 5.111492e-02
      10528   466_553875 1996        PIE 6.458217e-02  2.237774e-02 4.126267e-02
      10529   466_553875 1996      DomMc 9.837875e-01 -1.297362e-02 1.408984e-02
      10530   466_553875 1996 expShannon 1.217182e+00  1.291201e-01 2.421291e-02
      10531   466_553875 2001          S 1.100000e+01  1.131222e-01 3.830147e-01
      10532   466_553875 2001          N 3.190000e+02 -3.661742e+02 1.706022e-01
      10533   466_553875 2001       maxN 2.570000e+02 -2.894118e+02 1.080249e-01
      10534   466_553875 2001    Shannon 8.736987e-01  5.235038e-02 1.932662e-02
      10535   466_553875 2001    Simpson 3.447490e-01  2.229011e-02 4.157315e-02
      10536   466_553875 2001 invSimpson 1.526133e+00  7.751703e-02 5.111492e-02
      10537   466_553875 2001        PIE 3.458331e-01  2.237774e-02 4.126267e-02
      10538   466_553875 2001      DomMc 8.526646e-01 -1.297362e-02 1.408984e-02
      10539   466_553875 2001 expShannon 2.395756e+00  1.291201e-01 2.421291e-02
      10540   466_553875 2006          S 1.100000e+01  1.131222e-01 3.830147e-01
      10541   466_553875 2006          N 8.270000e+02 -3.661742e+02 1.706022e-01
      10542   466_553875 2006       maxN 5.900000e+02 -2.894118e+02 1.080249e-01
      10543   466_553875 2006    Shannon 1.055162e+00  5.235038e-02 1.932662e-02
      10544   466_553875 2006    Simpson 4.687241e-01  2.229011e-02 4.157315e-02
      10545   466_553875 2006 invSimpson 1.882261e+00  7.751703e-02 5.111492e-02
      10546   466_553875 2006        PIE 4.692916e-01  2.237774e-02 4.126267e-02
      10547   466_553875 2006      DomMc 8.415961e-01 -1.297362e-02 1.408984e-02
      10548   466_553875 2006 expShannon 2.872440e+00  1.291201e-01 2.421291e-02
      10549   466_553875 1999          S 1.000000e+01  1.131222e-01 3.830147e-01
      10550   466_553875 1999          N 6.430000e+02 -3.661742e+02 1.706022e-01
      10551   466_553875 1999       maxN 4.280000e+02 -2.894118e+02 1.080249e-01
      10552   466_553875 1999    Shannon 1.210815e+00  5.235038e-02 1.932662e-02
      10553   466_553875 1999    Simpson 5.299952e-01  2.229011e-02 4.157315e-02
      10554   466_553875 1999 invSimpson 2.127638e+00  7.751703e-02 5.111492e-02
      10555   466_553875 1999        PIE 5.308208e-01  2.237774e-02 4.126267e-02
      10556   466_553875 1999      DomMc 8.009331e-01 -1.297362e-02 1.408984e-02
      10557   466_553875 1999 expShannon 3.356217e+00  1.291201e-01 2.421291e-02
      10558   466_553875 2008          S 1.300000e+01  1.131222e-01 3.830147e-01
      10559   466_553875 2008          N 2.530000e+02 -3.661742e+02 1.706022e-01
      10560   466_553875 2008       maxN 1.050000e+02 -2.894118e+02 1.080249e-01
      10561   466_553875 2008    Shannon 1.685424e+00  5.235038e-02 1.932662e-02
      10562   466_553875 2008    Simpson 7.497383e-01  2.229011e-02 4.157315e-02
      10563   466_553875 2008 invSimpson 3.995817e+00  7.751703e-02 5.111492e-02
      10564   466_553875 2008        PIE 7.527135e-01  2.237774e-02 4.126267e-02
      10565   466_553875 2008      DomMc 5.889328e-01 -1.297362e-02 1.408984e-02
      10566   466_553875 2008 expShannon 5.394740e+00  1.291201e-01 2.421291e-02
      10567   466_553875 2005          S 8.000000e+00  1.131222e-01 3.830147e-01
      10568   466_553875 2005          N 1.253000e+03 -3.661742e+02 1.706022e-01
      10569   466_553875 2005       maxN 1.116000e+03 -2.894118e+02 1.080249e-01
      10570   466_553875 2005    Shannon 5.183903e-01  5.235038e-02 1.932662e-02
      10571   466_553875 2005    Simpson 2.039224e-01  2.229011e-02 4.157315e-02
      10572   466_553875 2005 invSimpson 1.256159e+00  7.751703e-02 5.111492e-02
      10573   466_553875 2005        PIE 2.040853e-01  2.237774e-02 4.126267e-02
      10574   466_553875 2005      DomMc 9.257781e-01 -1.297362e-02 1.408984e-02
      10575   466_553875 2005 expShannon 1.679322e+00  1.291201e-01 2.421291e-02
      10576   466_553875 1995          S 8.000000e+00  1.131222e-01 3.830147e-01
      10577   466_553875 1995          N 5.600000e+03 -3.661742e+02 1.706022e-01
      10578   466_553875 1995       maxN 5.383000e+03 -2.894118e+02 1.080249e-01
      10579   466_553875 1995    Shannon 2.142460e-01  5.235038e-02 1.932662e-02
      10580   466_553875 1995    Simpson 7.540013e-02  2.229011e-02 4.157315e-02
      10581   466_553875 1995 invSimpson 1.081549e+00  7.751703e-02 5.111492e-02
      10582   466_553875 1995        PIE 7.541359e-02  2.237774e-02 4.126267e-02
      10583   466_553875 1995      DomMc 9.844643e-01 -1.297362e-02 1.408984e-02
      10584   466_553875 1995 expShannon 1.238927e+00  1.291201e-01 2.421291e-02
      10585   466_553875 1986          S 6.000000e+00  1.131222e-01 3.830147e-01
      10586   466_553875 1986          N 3.090000e+03 -3.661742e+02 1.706022e-01
      10587   466_553875 1986       maxN 2.996000e+03 -2.894118e+02 1.080249e-01
      10588   466_553875 1986    Shannon 1.784625e-01  5.235038e-02 1.932662e-02
      10589   466_553875 1986    Simpson 5.967030e-02  2.229011e-02 4.157315e-02
      10590   466_553875 1986 invSimpson 1.063457e+00  7.751703e-02 5.111492e-02
      10591   466_553875 1986        PIE 5.968962e-02  2.237774e-02 4.126267e-02
      10592   466_553875 1986      DomMc 9.802589e-01 -1.297362e-02 1.408984e-02
      10593   466_553875 1986 expShannon 1.195378e+00  1.291201e-01 2.421291e-02
      10594   466_555330 1992          S 1.100000e+01  1.527650e-01 5.134594e-02
      10595   466_555330 1992          N 3.987000e+03 -9.165553e+01 1.471173e-01
      10596   466_555330 1992       maxN 3.749000e+03 -9.511544e+01 8.298761e-02
      10597   466_555330 1992    Shannon 3.158853e-01  3.194288e-02 2.027577e-01
      10598   466_555330 1992    Simpson 1.147629e-01  1.425819e-02 2.337099e-01
      10599   466_555330 1992 invSimpson 1.129641e+00  4.989975e-02 3.413479e-01
      10600   466_555330 1992        PIE 1.147917e-01  1.428753e-02 2.339120e-01
      10601   466_555330 1992      DomMc 9.676448e-01 -7.050848e-03 2.715114e-01
      10602   466_555330 1992 expShannon 1.371473e+00  8.005447e-02 2.826162e-01
      10603   466_555330 1995          S 1.000000e+01  1.527650e-01 5.134594e-02
      10604   466_555330 1995          N 2.019000e+03 -9.165553e+01 1.471173e-01
      10605   466_555330 1995       maxN 1.712000e+03 -9.511544e+01 8.298761e-02
      10606   466_555330 1995    Shannon 6.926855e-01  3.194288e-02 2.027577e-01
      10607   466_555330 1995    Simpson 2.764564e-01  1.425819e-02 2.337099e-01
      10608   466_555330 1995 invSimpson 1.382087e+00  4.989975e-02 3.413479e-01
      10609   466_555330 1995        PIE 2.765934e-01  1.428753e-02 2.339120e-01
      10610   466_555330 1995      DomMc 8.920258e-01 -7.050848e-03 2.715114e-01
      10611   466_555330 1995 expShannon 1.999077e+00  8.005447e-02 2.826162e-01
      10612   466_555330 2002          S 1.100000e+01  1.527650e-01 5.134594e-02
      10613   466_555330 2002          N 1.693000e+03 -9.165553e+01 1.471173e-01
      10614   466_555330 2002       maxN 1.413000e+03 -9.511544e+01 8.298761e-02
      10615   466_555330 2002    Shannon 7.499182e-01  3.194288e-02 2.027577e-01
      10616   466_555330 2002    Simpson 2.983788e-01  1.425819e-02 2.337099e-01
      10617   466_555330 2002 invSimpson 1.425271e+00  4.989975e-02 3.413479e-01
      10618   466_555330 2002        PIE 2.985552e-01  1.428753e-02 2.339120e-01
      10619   466_555330 2002      DomMc 8.730065e-01 -7.050848e-03 2.715114e-01
      10620   466_555330 2002 expShannon 2.116827e+00  8.005447e-02 2.826162e-01
      10621   466_555330 2005          S 1.100000e+01  1.527650e-01 5.134594e-02
      10622   466_555330 2005          N 1.394000e+03 -9.165553e+01 1.471173e-01
      10623   466_555330 2005       maxN 1.266000e+03 -9.511544e+01 8.298761e-02
      10624   466_555330 2005    Shannon 4.646248e-01  3.194288e-02 2.027577e-01
      10625   466_555330 2005    Simpson 1.731133e-01  1.425819e-02 2.337099e-01
      10626   466_555330 2005 invSimpson 1.209356e+00  4.989975e-02 3.413479e-01
      10627   466_555330 2005        PIE 1.732376e-01  1.428753e-02 2.339120e-01
      10628   466_555330 2005      DomMc 9.476327e-01 -7.050848e-03 2.715114e-01
      10629   466_555330 2005 expShannon 1.591417e+00  8.005447e-02 2.826162e-01
      10630   466_555330 1997          S 1.200000e+01  1.527650e-01 5.134594e-02
      10631   466_555330 1997          N 3.236000e+03 -9.165553e+01 1.471173e-01
      10632   466_555330 1997       maxN 2.126000e+03 -9.511544e+01 8.298761e-02
      10633   466_555330 1997    Shannon 1.109640e+00  3.194288e-02 2.027577e-01
      10634   466_555330 1997    Simpson 5.295287e-01  1.425819e-02 2.337099e-01
      10635   466_555330 1997 invSimpson 2.125528e+00  4.989975e-02 3.413479e-01
      10636   466_555330 1997        PIE 5.296924e-01  1.428753e-02 2.339120e-01
      10637   466_555330 1997      DomMc 8.216934e-01 -7.050848e-03 2.715114e-01
      10638   466_555330 1997 expShannon 3.033267e+00  8.005447e-02 2.826162e-01
      10639   466_555330 2001          S 1.100000e+01  1.527650e-01 5.134594e-02
      10640   466_555330 2001          N 1.053000e+03 -9.165553e+01 1.471173e-01
      10641   466_555330 2001       maxN 4.780000e+02 -9.511544e+01 8.298761e-02
      10642   466_555330 2001    Shannon 1.627182e+00  3.194288e-02 2.027577e-01
      10643   466_555330 2001    Simpson 7.246189e-01  1.425819e-02 2.337099e-01
      10644   466_555330 2001 invSimpson 3.631332e+00  4.989975e-02 3.413479e-01
      10645   466_555330 2001        PIE 7.253077e-01  1.428753e-02 2.339120e-01
      10646   466_555330 2001      DomMc 6.305793e-01 -7.050848e-03 2.715114e-01
      10647   466_555330 2001 expShannon 5.089510e+00  8.005447e-02 2.826162e-01
      10648   466_555330 2003          S 9.000000e+00  1.527650e-01 5.134594e-02
      10649   466_555330 2003          N 8.120000e+02 -9.165553e+01 1.471173e-01
      10650   466_555330 2003       maxN 6.950000e+02 -9.511544e+01 8.298761e-02
      10651   466_555330 2003    Shannon 6.243529e-01  3.194288e-02 2.027577e-01
      10652   466_555330 2003    Simpson 2.607622e-01  1.425819e-02 2.337099e-01
      10653   466_555330 2003 invSimpson 1.352745e+00  4.989975e-02 3.413479e-01
      10654   466_555330 2003        PIE 2.610837e-01  1.428753e-02 2.339120e-01
      10655   466_555330 2003      DomMc 9.298030e-01 -7.050848e-03 2.715114e-01
      10656   466_555330 2003 expShannon 1.867037e+00  8.005447e-02 2.826162e-01
      10657   466_555330 1986          S 7.000000e+00  1.527650e-01 5.134594e-02
      10658   466_555330 1986          N 1.544000e+03 -9.165553e+01 1.471173e-01
      10659   466_555330 1986       maxN 1.384000e+03 -9.511544e+01 8.298761e-02
      10660   466_555330 1986    Shannon 4.859950e-01  3.194288e-02 2.027577e-01
      10661   466_555330 1986    Simpson 1.935195e-01  1.425819e-02 2.337099e-01
      10662   466_555330 1986 invSimpson 1.239956e+00  4.989975e-02 3.413479e-01
      10663   466_555330 1986        PIE 1.936449e-01  1.428753e-02 2.339120e-01
      10664   466_555330 1986      DomMc 9.345855e-01 -7.050848e-03 2.715114e-01
      10665   466_555330 1986 expShannon 1.625792e+00  8.005447e-02 2.826162e-01
      10666   466_555330 1996          S 8.000000e+00  1.527650e-01 5.134594e-02
      10667   466_555330 1996          N 3.717000e+03 -9.165553e+01 1.471173e-01
      10668   466_555330 1996       maxN 2.769000e+03 -9.511544e+01 8.298761e-02
      10669   466_555330 1996    Shannon 8.334167e-01  3.194288e-02 2.027577e-01
      10670   466_555330 1996    Simpson 4.174953e-01  1.425819e-02 2.337099e-01
      10671   466_555330 1996 invSimpson 1.716724e+00  4.989975e-02 3.413479e-01
      10672   466_555330 1996        PIE 4.176076e-01  1.428753e-02 2.339120e-01
      10673   466_555330 1996      DomMc 8.730159e-01 -7.050848e-03 2.715114e-01
      10674   466_555330 1996 expShannon 2.301168e+00  8.005447e-02 2.826162e-01
      10675   466_555330 1999          S 1.000000e+01  1.527650e-01 5.134594e-02
      10676   466_555330 1999          N 2.680000e+02 -9.165553e+01 1.471173e-01
      10677   466_555330 1999       maxN 1.170000e+02 -9.511544e+01 8.298761e-02
      10678   466_555330 1999    Shannon 1.665982e+00  3.194288e-02 2.027577e-01
      10679   466_555330 1999    Simpson 7.397527e-01  1.425819e-02 2.337099e-01
      10680   466_555330 1999 invSimpson 3.842499e+00  4.989975e-02 3.413479e-01
      10681   466_555330 1999        PIE 7.425233e-01  1.428753e-02 2.339120e-01
      10682   466_555330 1999      DomMc 6.380597e-01 -7.050848e-03 2.715114e-01
      10683   466_555330 1999 expShannon 5.290868e+00  8.005447e-02 2.826162e-01
      10684   466_555330 1987          S 8.000000e+00  1.527650e-01 5.134594e-02
      10685   466_555330 1987          N 2.895000e+03 -9.165553e+01 1.471173e-01
      10686   466_555330 1987       maxN 2.759000e+03 -9.511544e+01 8.298761e-02
      10687   466_555330 1987    Shannon 2.513985e-01  3.194288e-02 2.027577e-01
      10688   466_555330 1987    Simpson 9.097765e-02  1.425819e-02 2.337099e-01
      10689   466_555330 1987 invSimpson 1.100083e+00  4.989975e-02 3.413479e-01
      10690   466_555330 1987        PIE 9.100909e-02  1.428753e-02 2.339120e-01
      10691   466_555330 1987      DomMc 9.778929e-01 -7.050848e-03 2.715114e-01
      10692   466_555330 1987 expShannon 1.285822e+00  8.005447e-02 2.826162e-01
      10693   466_559695 1992          S 8.000000e+00  4.226434e-02 5.916719e-01
      10694   466_559695 1992          N 6.166000e+03 -2.225569e+02 3.573527e-01
      10695   466_559695 1992       maxN 5.159000e+03 -1.341647e+02 3.195039e-01
      10696   466_559695 1992    Shannon 4.814290e-01  5.154347e-03 7.470043e-01
      10697   466_559695 1992    Simpson 2.754909e-01  1.948203e-03 8.317651e-01
      10698   466_559695 1992 invSimpson 1.380245e+00 -1.321576e-03 9.673428e-01
      10699   466_559695 1992        PIE 2.755355e-01  1.960807e-03 8.308347e-01
      10700   466_559695 1992      DomMc 9.930263e-01 -1.260792e-04 9.712181e-01
      10701   466_559695 1992 expShannon 1.618385e+00  6.879325e-03 8.544147e-01
      10702   466_559695 1995          S 1.100000e+01  4.226434e-02 5.916719e-01
      10703   466_559695 1995          N 2.122000e+03 -2.225569e+02 3.573527e-01
      10704   466_559695 1995       maxN 1.283000e+03 -1.341647e+02 3.195039e-01
      10705   466_559695 1995    Shannon 1.076450e+00  5.154347e-03 7.470043e-01
      10706   466_559695 1995    Simpson 5.533010e-01  1.948203e-03 8.317651e-01
      10707   466_559695 1995 invSimpson 2.238644e+00 -1.321576e-03 9.673428e-01
      10708   466_559695 1995        PIE 5.535618e-01  1.960807e-03 8.308347e-01
      10709   466_559695 1995      DomMc 8.807729e-01 -1.260792e-04 9.712181e-01
      10710   466_559695 1995 expShannon 2.934245e+00  6.879325e-03 8.544147e-01
      10711   466_559695 1999          S 1.200000e+01  4.226434e-02 5.916719e-01
      10712   466_559695 1999          N 1.334000e+03 -2.225569e+02 3.573527e-01
      10713   466_559695 1999       maxN 5.870000e+02 -1.341647e+02 3.195039e-01
      10714   466_559695 1999    Shannon 1.307527e+00  5.154347e-03 7.470043e-01
      10715   466_559695 1999    Simpson 6.675912e-01  1.948203e-03 8.317651e-01
      10716   466_559695 1999 invSimpson 3.008344e+00 -1.321576e-03 9.673428e-01
      10717   466_559695 1999        PIE 6.680921e-01  1.960807e-03 8.308347e-01
      10718   466_559695 1999      DomMc 7.848576e-01 -1.260792e-04 9.712181e-01
      10719   466_559695 1999 expShannon 3.697018e+00  6.879325e-03 8.544147e-01
      10720   466_559695 1988          S 1.200000e+01  4.226434e-02 5.916719e-01
      10721   466_559695 1988          N 1.096000e+03 -2.225569e+02 3.573527e-01
      10722   466_559695 1988       maxN 9.210000e+02 -1.341647e+02 3.195039e-01
      10723   466_559695 1988    Shannon 7.056322e-01  5.154347e-03 7.470043e-01
      10724   466_559695 1988    Simpson 2.879316e-01  1.948203e-03 8.317651e-01
      10725   466_559695 1988 invSimpson 1.404359e+00 -1.321576e-03 9.673428e-01
      10726   466_559695 1988        PIE 2.881945e-01  1.960807e-03 8.308347e-01
      10727   466_559695 1988      DomMc 8.923358e-01 -1.260792e-04 9.712181e-01
      10728   466_559695 1988 expShannon 2.025127e+00  6.879325e-03 8.544147e-01
      10729   466_559695 1993          S 1.000000e+01  4.226434e-02 5.916719e-01
      10730   466_559695 1993          N 2.017800e+04 -2.225569e+02 3.573527e-01
      10731   466_559695 1993       maxN 8.756000e+03 -1.341647e+02 3.195039e-01
      10732   466_559695 1993    Shannon 1.115716e+00  5.154347e-03 7.470043e-01
      10733   466_559695 1993    Simpson 6.453843e-01  1.948203e-03 8.317651e-01
      10734   466_559695 1993 invSimpson 2.819954e+00 -1.321576e-03 9.673428e-01
      10735   466_559695 1993        PIE 6.454163e-01  1.960807e-03 8.308347e-01
      10736   466_559695 1993      DomMc 7.897710e-01 -1.260792e-04 9.712181e-01
      10737   466_559695 1993 expShannon 3.051752e+00  6.879325e-03 8.544147e-01
      10738   466_559695 1994          S 1.200000e+01  4.226434e-02 5.916719e-01
      10739   466_559695 1994          N 2.057000e+03 -2.225569e+02 3.573527e-01
      10740   466_559695 1994       maxN 1.155000e+03 -1.341647e+02 3.195039e-01
      10741   466_559695 1994    Shannon 9.873547e-01  5.154347e-03 7.470043e-01
      10742   466_559695 1994    Simpson 5.454035e-01  1.948203e-03 8.317651e-01
      10743   466_559695 1994 invSimpson 2.199753e+00 -1.321576e-03 9.673428e-01
      10744   466_559695 1994        PIE 5.456688e-01  1.960807e-03 8.308347e-01
      10745   466_559695 1994      DomMc 9.333982e-01 -1.260792e-04 9.712181e-01
      10746   466_559695 1994 expShannon 2.684125e+00  6.879325e-03 8.544147e-01
      10747   466_559695 2001          S 1.100000e+01  4.226434e-02 5.916719e-01
      10748   466_559695 2001          N 7.240000e+02 -2.225569e+02 3.573527e-01
      10749   466_559695 2001       maxN 5.640000e+02 -1.341647e+02 3.195039e-01
      10750   466_559695 2001    Shannon 8.954155e-01  5.154347e-03 7.470043e-01
      10751   466_559695 2001    Simpson 3.813109e-01  1.948203e-03 8.317651e-01
      10752   466_559695 2001 invSimpson 1.616321e+00 -1.321576e-03 9.673428e-01
      10753   466_559695 2001        PIE 3.818383e-01  1.960807e-03 8.308347e-01
      10754   466_559695 2001      DomMc 8.549724e-01 -1.260792e-04 9.712181e-01
      10755   466_559695 2001 expShannon 2.448353e+00  6.879325e-03 8.544147e-01
      10756   466_559695 2008          S 1.000000e+01  4.226434e-02 5.916719e-01
      10757   466_559695 2008          N 6.240000e+02 -2.225569e+02 3.573527e-01
      10758   466_559695 2008       maxN 5.220000e+02 -1.341647e+02 3.195039e-01
      10759   466_559695 2008    Shannon 6.424624e-01  5.154347e-03 7.470043e-01
      10760   466_559695 2008    Simpson 2.899049e-01  1.948203e-03 8.317651e-01
      10761   466_559695 2008 invSimpson 1.408262e+00 -1.321576e-03 9.673428e-01
      10762   466_559695 2008        PIE 2.903702e-01  1.960807e-03 8.308347e-01
      10763   466_559695 2008      DomMc 9.118590e-01 -1.260792e-04 9.712181e-01
      10764   466_559695 2008 expShannon 1.901156e+00  6.879325e-03 8.544147e-01
      10765   466_559695 2006          S 1.000000e+01  4.226434e-02 5.916719e-01
      10766   466_559695 2006          N 1.546000e+03 -2.225569e+02 3.573527e-01
      10767   466_559695 2006       maxN 1.223000e+03 -1.341647e+02 3.195039e-01
      10768   466_559695 2006    Shannon 6.682771e-01  5.154347e-03 7.470043e-01
      10769   466_559695 2006    Simpson 3.436737e-01  1.948203e-03 8.317651e-01
      10770   466_559695 2006 invSimpson 1.523632e+00 -1.321576e-03 9.673428e-01
      10771   466_559695 2006        PIE 3.438961e-01  1.960807e-03 8.308347e-01
      10772   466_559695 2006      DomMc 9.650712e-01 -1.260792e-04 9.712181e-01
      10773   466_559695 2006 expShannon 1.950873e+00  6.879325e-03 8.544147e-01
      10774   466_559695 2007          S 9.000000e+00  4.226434e-02 5.916719e-01
      10775   466_559695 2007          N 1.453000e+03 -2.225569e+02 3.573527e-01
      10776   466_559695 2007       maxN 1.283000e+03 -1.341647e+02 3.195039e-01
      10777   466_559695 2007    Shannon 4.939801e-01  5.154347e-03 7.470043e-01
      10778   466_559695 2007    Simpson 2.136899e-01  1.948203e-03 8.317651e-01
      10779   466_559695 2007 invSimpson 1.271763e+00 -1.321576e-03 9.673428e-01
      10780   466_559695 2007        PIE 2.138371e-01  1.960807e-03 8.308347e-01
      10781   466_559695 2007      DomMc 9.621473e-01 -1.260792e-04 9.712181e-01
      10782   466_559695 2007 expShannon 1.638826e+00  6.879325e-03 8.544147e-01
      10783   466_559695 1989          S 7.000000e+00  4.226434e-02 5.916719e-01
      10784   466_559695 1989          N 3.358000e+03 -2.225569e+02 3.573527e-01
      10785   466_559695 1989       maxN 3.155000e+03 -1.341647e+02 3.195039e-01
      10786   466_559695 1989    Shannon 3.233012e-01  5.154347e-03 7.470043e-01
      10787   466_559695 1989    Simpson 1.163598e-01  1.948203e-03 8.317651e-01
      10788   466_559695 1989 invSimpson 1.131682e+00 -1.321576e-03 9.673428e-01
      10789   466_559695 1989        PIE 1.163944e-01  1.960807e-03 8.308347e-01
      10790   466_559695 1989      DomMc 9.630733e-01 -1.260792e-04 9.712181e-01
      10791   466_559695 1989 expShannon 1.381681e+00  6.879325e-03 8.544147e-01
      10792   466_559695 1991          S 7.000000e+00  4.226434e-02 5.916719e-01
      10793   466_559695 1991          N 5.460000e+02 -2.225569e+02 3.573527e-01
      10794   466_559695 1991       maxN 5.220000e+02 -1.341647e+02 3.195039e-01
      10795   466_559695 1991    Shannon 2.493438e-01  5.154347e-03 7.470043e-01
      10796   466_559695 1991    Simpson 8.553046e-02  1.948203e-03 8.317651e-01
      10797   466_559695 1991 invSimpson 1.093530e+00 -1.321576e-03 9.673428e-01
      10798   466_559695 1991        PIE 8.568740e-02  1.960807e-03 8.308347e-01
      10799   466_559695 1991      DomMc 9.688645e-01 -1.260792e-04 9.712181e-01
      10800   466_559695 1991 expShannon 1.283183e+00  6.879325e-03 8.544147e-01
      10801   466_559695 1996          S 1.000000e+01  4.226434e-02 5.916719e-01
      10802   466_559695 1996          N 1.049700e+04 -2.225569e+02 3.573527e-01
      10803   466_559695 1996       maxN 9.272000e+03 -1.341647e+02 3.195039e-01
      10804   466_559695 1996    Shannon 4.606271e-01  5.154347e-03 7.470043e-01
      10805   466_559695 1996    Simpson 2.123082e-01  1.948203e-03 8.317651e-01
      10806   466_559695 1996 invSimpson 1.269532e+00 -1.321576e-03 9.673428e-01
      10807   466_559695 1996        PIE 2.123284e-01  1.960807e-03 8.308347e-01
      10808   466_559695 1996      DomMc 9.666571e-01 -1.260792e-04 9.712181e-01
      10809   466_559695 1996 expShannon 1.585068e+00  6.879325e-03 8.544147e-01
      10810   466_559695 1997          S 8.000000e+00  4.226434e-02 5.916719e-01
      10811   466_559695 1997          N 5.390000e+02 -2.225569e+02 3.573527e-01
      10812   466_559695 1997       maxN 2.370000e+02 -1.341647e+02 3.195039e-01
      10813   466_559695 1997    Shannon 1.339722e+00  5.154347e-03 7.470043e-01
      10814   466_559695 1997    Simpson 6.794139e-01  1.948203e-03 8.317651e-01
      10815   466_559695 1997 invSimpson 3.119287e+00 -1.321576e-03 9.673428e-01
      10816   466_559695 1997        PIE 6.806767e-01  1.960807e-03 8.308347e-01
      10817   466_559695 1997      DomMc 7.606679e-01 -1.260792e-04 9.712181e-01
      10818   466_559695 1997 expShannon 3.817983e+00  6.879325e-03 8.544147e-01
      10819   466_557513 1992          S 9.000000e+00  1.581367e-01 2.016996e-02
      10820   466_557513 1992          N 1.761000e+03 -1.150984e+02 2.142628e-01
      10821   466_557513 1992       maxN 1.531000e+03 -1.132711e+02 1.912730e-01
      10822   466_557513 1992    Shannon 5.662385e-01  2.306177e-02 1.276079e-01
      10823   466_557513 1992    Simpson 2.381442e-01  1.017100e-02 1.546074e-01
      10824   466_557513 1992 invSimpson 1.312584e+00  2.865666e-02 2.939243e-01
      10825   466_557513 1992        PIE 2.382795e-01  1.018984e-02 1.546173e-01
      10826   466_557513 1992      DomMc 9.398069e-01 -4.244642e-03 2.479319e-01
      10827   466_557513 1992 expShannon 1.761628e+00  4.984963e-02 2.168284e-01
      10828   466_557513 1987          S 7.000000e+00  1.581367e-01 2.016996e-02
      10829   466_557513 1987          N 1.941000e+03 -1.150984e+02 2.142628e-01
      10830   466_557513 1987       maxN 1.883000e+03 -1.132711e+02 1.912730e-01
      10831   466_557513 1987    Shannon 1.690759e-01  2.306177e-02 1.276079e-01
      10832   466_557513 1987    Simpson 5.850647e-02  1.017100e-02 1.546074e-01
      10833   466_557513 1987 invSimpson 1.062142e+00  2.865666e-02 2.939243e-01
      10834   466_557513 1987        PIE 5.853662e-02  1.018984e-02 1.546173e-01
      10835   466_557513 1987      DomMc 9.871200e-01 -4.244642e-03 2.479319e-01
      10836   466_557513 1987 expShannon 1.184210e+00  4.984963e-02 2.168284e-01
      10837   466_557513 1994          S 9.000000e+00  1.581367e-01 2.016996e-02
      10838   466_557513 1994          N 1.463000e+03 -1.150984e+02 2.142628e-01
      10839   466_557513 1994       maxN 1.025000e+03 -1.132711e+02 1.912730e-01
      10840   466_557513 1994    Shannon 1.093393e+00  2.306177e-02 1.276079e-01
      10841   466_557513 1994    Simpson 4.883513e-01  1.017100e-02 1.546074e-01
      10842   466_557513 1994 invSimpson 1.954466e+00  2.865666e-02 2.939243e-01
      10843   466_557513 1994        PIE 4.886853e-01  1.018984e-02 1.546173e-01
      10844   466_557513 1994      DomMc 7.990431e-01 -4.244642e-03 2.479319e-01
      10845   466_557513 1994 expShannon 2.984384e+00  4.984963e-02 2.168284e-01
      10846   466_557513 1991          S 9.000000e+00  1.581367e-01 2.016996e-02
      10847   466_557513 1991          N 4.450000e+02 -1.150984e+02 2.142628e-01
      10848   466_557513 1991       maxN 3.360000e+02 -1.132711e+02 1.912730e-01
      10849   466_557513 1991    Shannon 8.675817e-01  2.306177e-02 1.276079e-01
      10850   466_557513 1991    Simpson 4.061103e-01  1.017100e-02 1.546074e-01
      10851   466_557513 1991 invSimpson 1.683814e+00  2.865666e-02 2.939243e-01
      10852   466_557513 1991        PIE 4.070250e-01  1.018984e-02 1.546173e-01
      10853   466_557513 1991      DomMc 8.988764e-01 -4.244642e-03 2.479319e-01
      10854   466_557513 1991 expShannon 2.381145e+00  4.984963e-02 2.168284e-01
      10855   466_557513 1990          S 1.100000e+01  1.581367e-01 2.016996e-02
      10856   466_557513 1990          N 2.588000e+03 -1.150984e+02 2.142628e-01
      10857   466_557513 1990       maxN 2.356000e+03 -1.132711e+02 1.912730e-01
      10858   466_557513 1990    Shannon 4.299766e-01  2.306177e-02 1.276079e-01
      10859   466_557513 1990    Simpson 1.686129e-01  1.017100e-02 1.546074e-01
      10860   466_557513 1990 invSimpson 1.202809e+00  2.865666e-02 2.939243e-01
      10861   466_557513 1990        PIE 1.686781e-01  1.018984e-02 1.546173e-01
      10862   466_557513 1990      DomMc 9.544049e-01 -4.244642e-03 2.479319e-01
      10863   466_557513 1990 expShannon 1.537221e+00  4.984963e-02 2.168284e-01
      10864   466_557513 1999          S 1.200000e+01  1.581367e-01 2.016996e-02
      10865   466_557513 1999          N 4.730000e+02 -1.150984e+02 2.142628e-01
      10866   466_557513 1999       maxN 2.010000e+02 -1.132711e+02 1.912730e-01
      10867   466_557513 1999    Shannon 1.722704e+00  2.306177e-02 1.276079e-01
      10868   466_557513 1999    Simpson 7.553424e-01  1.017100e-02 1.546074e-01
      10869   466_557513 1999 invSimpson 4.087345e+00  2.865666e-02 2.939243e-01
      10870   466_557513 1999        PIE 7.569427e-01  1.018984e-02 1.546173e-01
      10871   466_557513 1999      DomMc 5.856237e-01 -4.244642e-03 2.479319e-01
      10872   466_557513 1999 expShannon 5.599650e+00  4.984963e-02 2.168284e-01
      10873   466_557513 2008          S 1.100000e+01  1.581367e-01 2.016996e-02
      10874   466_557513 2008          N 7.210000e+02 -1.150984e+02 2.142628e-01
      10875   466_557513 2008       maxN 6.330000e+02 -1.132711e+02 1.912730e-01
      10876   466_557513 2008    Shannon 5.491380e-01  2.306177e-02 1.276079e-01
      10877   466_557513 2008    Simpson 2.234299e-01  1.017100e-02 1.546074e-01
      10878   466_557513 2008 invSimpson 1.287714e+00  2.865666e-02 2.939243e-01
      10879   466_557513 2008        PIE 2.237402e-01  1.018984e-02 1.546173e-01
      10880   466_557513 2008      DomMc 9.514563e-01 -4.244642e-03 2.479319e-01
      10881   466_557513 2008 expShannon 1.731760e+00  4.984963e-02 2.168284e-01
      10882   466_557513 2005          S 1.300000e+01  1.581367e-01 2.016996e-02
      10883   466_557513 2005          N 1.925000e+03 -1.150984e+02 2.142628e-01
      10884   466_557513 2005       maxN 1.625000e+03 -1.132711e+02 1.912730e-01
      10885   466_557513 2005    Shannon 6.867111e-01  2.306177e-02 1.276079e-01
      10886   466_557513 2005    Simpson 2.810198e-01  1.017100e-02 1.546074e-01
      10887   466_557513 2005 invSimpson 1.390859e+00  2.865666e-02 2.939243e-01
      10888   466_557513 2005        PIE 2.811659e-01  1.018984e-02 1.546173e-01
      10889   466_557513 2005      DomMc 9.101299e-01 -4.244642e-03 2.479319e-01
      10890   466_557513 2005 expShannon 1.987169e+00  4.984963e-02 2.168284e-01
      10891   466_557513 2007          S 1.200000e+01  1.581367e-01 2.016996e-02
      10892   466_557513 2007          N 6.000000e+02 -1.150984e+02 2.142628e-01
      10893   466_557513 2007       maxN 3.670000e+02 -1.132711e+02 1.912730e-01
      10894   466_557513 2007    Shannon 1.269054e+00  2.306177e-02 1.276079e-01
      10895   466_557513 2007    Simpson 5.814444e-01  1.017100e-02 1.546074e-01
      10896   466_557513 2007 invSimpson 2.389169e+00  2.865666e-02 2.939243e-01
      10897   466_557513 2007        PIE 5.824151e-01  1.018984e-02 1.546173e-01
      10898   466_557513 2007      DomMc 7.883333e-01 -4.244642e-03 2.479319e-01
      10899   466_557513 2007 expShannon 3.557485e+00  4.984963e-02 2.168284e-01
      10900   466_557513 1988          S 1.000000e+01  1.581367e-01 2.016996e-02
      10901   466_557513 1988          N 2.035000e+03 -1.150984e+02 2.142628e-01
      10902   466_557513 1988       maxN 1.527000e+03 -1.132711e+02 1.912730e-01
      10903   466_557513 1988    Shannon 8.981267e-01  2.306177e-02 1.276079e-01
      10904   466_557513 1988    Simpson 4.155722e-01  1.017100e-02 1.546074e-01
      10905   466_557513 1988 invSimpson 1.711075e+00  2.865666e-02 2.939243e-01
      10906   466_557513 1988        PIE 4.157765e-01  1.018984e-02 1.546173e-01
      10907   466_557513 1988      DomMc 8.732187e-01 -4.244642e-03 2.479319e-01
      10908   466_557513 1988 expShannon 2.455000e+00  4.984963e-02 2.168284e-01
      10909   466_557513 2006          S 9.000000e+00  1.581367e-01 2.016996e-02
      10910   466_557513 2006          N 2.450000e+03 -1.150984e+02 2.142628e-01
      10911   466_557513 2006       maxN 2.151000e+03 -1.132711e+02 1.912730e-01
      10912   466_557513 2006    Shannon 5.759937e-01  2.306177e-02 1.276079e-01
      10913   466_557513 2006    Simpson 2.259132e-01  1.017100e-02 1.546074e-01
      10914   466_557513 2006 invSimpson 1.291845e+00  2.865666e-02 2.939243e-01
      10915   466_557513 2006        PIE 2.260054e-01  1.018984e-02 1.546173e-01
      10916   466_557513 2006      DomMc 9.179592e-01 -4.244642e-03 2.479319e-01
      10917   466_557513 2006 expShannon 1.778897e+00  4.984963e-02 2.168284e-01
      10918   466_557513 1993          S 8.000000e+00  1.581367e-01 2.016996e-02
      10919   466_557513 1993          N 9.226000e+03 -1.150984e+02 2.142628e-01
      10920   466_557513 1993       maxN 8.256000e+03 -1.132711e+02 1.912730e-01
      10921   466_557513 1993    Shannon 4.834181e-01  2.306177e-02 1.276079e-01
      10922   466_557513 1993    Simpson 1.960820e-01  1.017100e-02 1.546074e-01
      10923   466_557513 1993 invSimpson 1.243908e+00  2.865666e-02 2.939243e-01
      10924   466_557513 1993        PIE 1.961032e-01  1.018984e-02 1.546173e-01
      10925   466_557513 1993      DomMc 9.325818e-01 -4.244642e-03 2.479319e-01
      10926   466_557513 1993 expShannon 1.621608e+00  4.984963e-02 2.168284e-01
      10927   466_557513 1995          S 7.000000e+00  1.581367e-01 2.016996e-02
      10928   466_557513 1995          N 7.590000e+03 -1.150984e+02 2.142628e-01
      10929   466_557513 1995       maxN 6.971000e+03 -1.132711e+02 1.912730e-01
      10930   466_557513 1995    Shannon 3.605063e-01  2.306177e-02 1.276079e-01
      10931   466_557513 1995    Simpson 1.531654e-01  1.017100e-02 1.546074e-01
      10932   466_557513 1995 invSimpson 1.180868e+00  2.865666e-02 2.939243e-01
      10933   466_557513 1995        PIE 1.531856e-01  1.018984e-02 1.546173e-01
      10934   466_557513 1995      DomMc 9.720685e-01 -4.244642e-03 2.479319e-01
      10935   466_557513 1995 expShannon 1.434055e+00  4.984963e-02 2.168284e-01
      10936   466_557513 1996          S 1.100000e+01  1.581367e-01 2.016996e-02
      10937   466_557513 1996          N 3.227000e+03 -1.150984e+02 2.142628e-01
      10938   466_557513 1996       maxN 2.386000e+03 -1.132711e+02 1.912730e-01
      10939   466_557513 1996    Shannon 1.002379e+00  2.306177e-02 1.276079e-01
      10940   466_557513 1996    Simpson 4.373635e-01  1.017100e-02 1.546074e-01
      10941   466_557513 1996 invSimpson 1.777347e+00  2.865666e-02 2.939243e-01
      10942   466_557513 1996        PIE 4.374991e-01  1.018984e-02 1.546173e-01
      10943   466_557513 1996      DomMc 8.379300e-01 -4.244642e-03 2.479319e-01
      10944   466_557513 1996 expShannon 2.724756e+00  4.984963e-02 2.168284e-01
      10945   466_557513 2001          S 8.000000e+00  1.581367e-01 2.016996e-02
      10946   466_557513 2001          N 9.240000e+02 -1.150984e+02 2.142628e-01
      10947   466_557513 2001       maxN 6.060000e+02 -1.132711e+02 1.912730e-01
      10948   466_557513 2001    Shannon 1.058795e+00  2.306177e-02 1.276079e-01
      10949   466_557513 2001    Simpson 5.229873e-01  1.017100e-02 1.546074e-01
      10950   466_557513 2001 invSimpson 2.096380e+00  2.865666e-02 2.939243e-01
      10951   466_557513 2001        PIE 5.235539e-01  1.018984e-02 1.546173e-01
      10952   466_557513 2001      DomMc 8.538961e-01 -4.244642e-03 2.479319e-01
      10953   466_557513 2001 expShannon 2.882895e+00  4.984963e-02 2.168284e-01
      10954   466_557513 1986          S 6.000000e+00  1.581367e-01 2.016996e-02
      10955   466_557513 1986          N 5.491000e+03 -1.150984e+02 2.142628e-01
      10956   466_557513 1986       maxN 5.425000e+03 -1.132711e+02 1.912730e-01
      10957   466_557513 1986    Shannon 7.757359e-02  2.306177e-02 1.276079e-01
      10958   466_557513 1986    Simpson 2.382873e-02  1.017100e-02 1.546074e-01
      10959   466_557513 1986 invSimpson 1.024410e+00  2.865666e-02 2.939243e-01
      10960   466_557513 1986        PIE 2.383307e-02  1.018984e-02 1.546173e-01
      10961   466_557513 1986      DomMc 9.956292e-01 -4.244642e-03 2.479319e-01
      10962   466_557513 1986 expShannon 1.080662e+00  4.984963e-02 2.168284e-01
      10963   466_550231 1993          S 1.100000e+01  1.661743e-02 7.766974e-01
      10964   466_550231 1993          N 6.535000e+03 -1.504985e+01 8.580720e-01
      10965   466_550231 1993       maxN 5.070000e+03 -5.552142e+01 4.623955e-01
      10966   466_550231 1993    Shannon 7.032414e-01  4.242871e-02 3.912244e-03
      10967   466_550231 1993    Simpson 3.645104e-01  2.354598e-02 2.896089e-03
      10968   466_550231 1993 invSimpson 1.573590e+00  7.736364e-02 7.418357e-03
      10969   466_550231 1993        PIE 3.645662e-01  2.355460e-02 2.899941e-03
      10970   466_550231 1993      DomMc 9.574598e-01 -8.876225e-03 5.312835e-03
      10971   466_550231 1993 expShannon 2.020291e+00  9.907778e-02 5.737440e-03
      10972   466_550231 1995          S 1.000000e+01  1.661743e-02 7.766974e-01
      10973   466_550231 1995          N 3.874000e+03 -1.504985e+01 8.580720e-01
      10974   466_550231 1995       maxN 2.794000e+03 -5.552142e+01 4.623955e-01
      10975   466_550231 1995    Shannon 7.497634e-01  4.242871e-02 3.912244e-03
      10976   466_550231 1995    Simpson 4.225948e-01  2.354598e-02 2.896089e-03
      10977   466_550231 1995 invSimpson 1.731886e+00  7.736364e-02 7.418357e-03
      10978   466_550231 1995        PIE 4.227039e-01  2.355460e-02 2.899941e-03
      10979   466_550231 1995      DomMc 9.584409e-01 -8.876225e-03 5.312835e-03
      10980   466_550231 1995 expShannon 2.116499e+00  9.907778e-02 5.737440e-03
      10981   466_550231 1997          S 9.000000e+00  1.661743e-02 7.766974e-01
      10982   466_550231 1997          N 3.359000e+03 -1.504985e+01 8.580720e-01
      10983   466_550231 1997       maxN 1.800000e+03 -5.552142e+01 4.623955e-01
      10984   466_550231 1997    Shannon 9.709519e-01  4.242871e-02 3.912244e-03
      10985   466_550231 1997    Simpson 5.592561e-01  2.354598e-02 2.896089e-03
      10986   466_550231 1997 invSimpson 2.268891e+00  7.736364e-02 7.418357e-03
      10987   466_550231 1997        PIE 5.594226e-01  2.355460e-02 2.899941e-03
      10988   466_550231 1997      DomMc 9.237868e-01 -8.876225e-03 5.312835e-03
      10989   466_550231 1997 expShannon 2.640457e+00  9.907778e-02 5.737440e-03
      10990   466_550231 1986          S 1.000000e+01  1.661743e-02 7.766974e-01
      10991   466_550231 1986          N 1.861000e+03 -1.504985e+01 8.580720e-01
      10992   466_550231 1986       maxN 1.622000e+03 -5.552142e+01 4.623955e-01
      10993   466_550231 1986    Shannon 5.139849e-01  4.242871e-02 3.912244e-03
      10994   466_550231 1986    Simpson 2.313716e-01  2.354598e-02 2.896089e-03
      10995   466_550231 1986 invSimpson 1.301019e+00  7.736364e-02 7.418357e-03
      10996   466_550231 1986        PIE 2.314960e-01  2.355460e-02 2.899941e-03
      10997   466_550231 1986      DomMc 9.645352e-01 -8.876225e-03 5.312835e-03
      10998   466_550231 1986 expShannon 1.671941e+00  9.907778e-02 5.737440e-03
      10999   466_550231 1988          S 1.000000e+01  1.661743e-02 7.766974e-01
      11000   466_550231 1988          N 5.050000e+02 -1.504985e+01 8.580720e-01
      11001   466_550231 1988       maxN 4.070000e+02 -5.552142e+01 4.623955e-01
      11002   466_550231 1988    Shannon 8.062438e-01  4.242871e-02 3.912244e-03
      11003   466_550231 1988    Simpson 3.398412e-01  2.354598e-02 2.896089e-03
      11004   466_550231 1988 invSimpson 1.514787e+00  7.736364e-02 7.418357e-03
      11005   466_550231 1988        PIE 3.405155e-01  2.355460e-02 2.899941e-03
      11006   466_550231 1988      DomMc 8.990099e-01 -8.876225e-03 5.312835e-03
      11007   466_550231 1988 expShannon 2.239480e+00  9.907778e-02 5.737440e-03
      11008   466_550231 2002          S 1.200000e+01  1.661743e-02 7.766974e-01
      11009   466_550231 2002          N 2.578000e+03 -1.504985e+01 8.580720e-01
      11010   466_550231 2002       maxN 9.440000e+02 -5.552142e+01 4.623955e-01
      11011   466_550231 2002    Shannon 1.507938e+00  4.242871e-02 3.912244e-03
      11012   466_550231 2002    Simpson 7.289065e-01  2.354598e-02 2.896089e-03
      11013   466_550231 2002 invSimpson 3.688765e+00  7.736364e-02 7.418357e-03
      11014   466_550231 2002        PIE 7.291894e-01  2.355460e-02 2.899941e-03
      11015   466_550231 2002      DomMc 6.912335e-01 -8.876225e-03 5.312835e-03
      11016   466_550231 2002 expShannon 4.517404e+00  9.907778e-02 5.737440e-03
      11017   466_550231 2006          S 9.000000e+00  1.661743e-02 7.766974e-01
      11018   466_550231 2006          N 1.693000e+03 -1.504985e+01 8.580720e-01
      11019   466_550231 2006       maxN 1.109000e+03 -5.552142e+01 4.623955e-01
      11020   466_550231 2006    Shannon 1.044819e+00  4.242871e-02 3.912244e-03
      11021   466_550231 2006    Simpson 5.250702e-01  2.354598e-02 2.896089e-03
      11022   466_550231 2006 invSimpson 2.105574e+00  7.736364e-02 7.418357e-03
      11023   466_550231 2006        PIE 5.253805e-01  2.355460e-02 2.899941e-03
      11024   466_550231 2006      DomMc 8.216184e-01 -8.876225e-03 5.312835e-03
      11025   466_550231 2006 expShannon 2.842884e+00  9.907778e-02 5.737440e-03
      11026   466_550231 1989          S 1.100000e+01  1.661743e-02 7.766974e-01
      11027   466_550231 1989          N 1.577000e+03 -1.504985e+01 8.580720e-01
      11028   466_550231 1989       maxN 1.324000e+03 -5.552142e+01 4.623955e-01
      11029   466_550231 1989    Shannon 6.517602e-01  4.242871e-02 3.912244e-03
      11030   466_550231 1989    Simpson 2.848308e-01  2.354598e-02 2.896089e-03
      11031   466_550231 1989 invSimpson 1.398271e+00  7.736364e-02 7.418357e-03
      11032   466_550231 1989        PIE 2.850115e-01  2.355460e-02 2.899941e-03
      11033   466_550231 1989      DomMc 9.353202e-01 -8.876225e-03 5.312835e-03
      11034   466_550231 1989 expShannon 1.918916e+00  9.907778e-02 5.737440e-03
      11035   466_550231 1990          S 1.000000e+01  1.661743e-02 7.766974e-01
      11036   466_550231 1990          N 2.659000e+03 -1.504985e+01 8.580720e-01
      11037   466_550231 1990       maxN 2.503000e+03 -5.552142e+01 4.623955e-01
      11038   466_550231 1990    Shannon 3.116887e-01  4.242871e-02 3.912244e-03
      11039   466_550231 1990    Simpson 1.127913e-01  2.354598e-02 2.896089e-03
      11040   466_550231 1990 invSimpson 1.127130e+00  7.736364e-02 7.418357e-03
      11041   466_550231 1990        PIE 1.128337e-01  2.355460e-02 2.899941e-03
      11042   466_550231 1990      DomMc 9.717939e-01 -8.876225e-03 5.312835e-03
      11043   466_550231 1990 expShannon 1.365729e+00  9.907778e-02 5.737440e-03
      11044   466_550231 1992          S 8.000000e+00  1.661743e-02 7.766974e-01
      11045   466_550231 1992          N 6.409000e+03 -1.504985e+01 8.580720e-01
      11046   466_550231 1992       maxN 6.251000e+03 -5.552142e+01 4.623955e-01
      11047   466_550231 1992    Shannon 1.451122e-01  4.242871e-02 3.912244e-03
      11048   466_550231 1992    Simpson 4.845566e-02  2.354598e-02 2.896089e-03
      11049   466_550231 1992 invSimpson 1.050923e+00  7.736364e-02 7.418357e-03
      11050   466_550231 1992        PIE 4.846323e-02  2.355460e-02 2.899941e-03
      11051   466_550231 1992      DomMc 9.892339e-01 -8.876225e-03 5.312835e-03
      11052   466_550231 1992 expShannon 1.156169e+00  9.907778e-02 5.737440e-03
      11053   466_550231 1994          S 9.000000e+00  1.661743e-02 7.766974e-01
      11054   466_550231 1994          N 4.046000e+03 -1.504985e+01 8.580720e-01
      11055   466_550231 1994       maxN 2.610000e+03 -5.552142e+01 4.623955e-01
      11056   466_550231 1994    Shannon 8.289165e-01  4.242871e-02 3.912244e-03
      11057   466_550231 1994    Simpson 4.834937e-01  2.354598e-02 2.896089e-03
      11058   466_550231 1994 invSimpson 1.936085e+00  7.736364e-02 7.418357e-03
      11059   466_550231 1994        PIE 4.836132e-01  2.355460e-02 2.899941e-03
      11060   466_550231 1994      DomMc 9.611962e-01 -8.876225e-03 5.312835e-03
      11061   466_550231 1994 expShannon 2.290835e+00  9.907778e-02 5.737440e-03
      11062   466_550231 1996          S 1.100000e+01  1.661743e-02 7.766974e-01
      11063   466_550231 1996          N 1.694000e+03 -1.504985e+01 8.580720e-01
      11064   466_550231 1996       maxN 7.900000e+02 -5.552142e+01 4.623955e-01
      11065   466_550231 1996    Shannon 1.322624e+00  4.242871e-02 3.912244e-03
      11066   466_550231 1996    Simpson 6.503550e-01  2.354598e-02 2.896089e-03
      11067   466_550231 1996 invSimpson 2.860043e+00  7.736364e-02 7.418357e-03
      11068   466_550231 1996        PIE 6.507391e-01  2.355460e-02 2.899941e-03
      11069   466_550231 1996      DomMc 8.193625e-01 -8.876225e-03 5.312835e-03
      11070   466_550231 1996 expShannon 3.753257e+00  9.907778e-02 5.737440e-03
      11071   466_550231 2001          S 9.000000e+00  1.661743e-02 7.766974e-01
      11072   466_550231 2001          N 1.099000e+03 -1.504985e+01 8.580720e-01
      11073   466_550231 2001       maxN 5.020000e+02 -5.552142e+01 4.623955e-01
      11074   466_550231 2001    Shannon 1.084663e+00  4.242871e-02 3.912244e-03
      11075   466_550231 2001    Simpson 5.913077e-01  2.354598e-02 2.896089e-03
      11076   466_550231 2001 invSimpson 2.446828e+00  7.736364e-02 7.418357e-03
      11077   466_550231 2001        PIE 5.918462e-01  2.355460e-02 2.899941e-03
      11078   466_550231 2001      DomMc 8.999090e-01 -8.876225e-03 5.312835e-03
      11079   466_550231 2001 expShannon 2.958442e+00  9.907778e-02 5.737440e-03
      11080   466_550231 2003          S 9.000000e+00  1.661743e-02 7.766974e-01
      11081   466_550231 2003          N 1.418000e+03 -1.504985e+01 8.580720e-01
      11082   466_550231 2003       maxN 1.086000e+03 -5.552142e+01 4.623955e-01
      11083   466_550231 2003    Shannon 8.792860e-01  4.242871e-02 3.912244e-03
      11084   466_550231 2003    Simpson 3.972171e-01  2.354598e-02 2.896089e-03
      11085   466_550231 2003 invSimpson 1.658972e+00  7.736364e-02 7.418357e-03
      11086   466_550231 2003        PIE 3.974974e-01  2.355460e-02 2.899941e-03
      11087   466_550231 2003      DomMc 8.688293e-01 -8.876225e-03 5.312835e-03
      11088   466_550231 2003 expShannon 2.409179e+00  9.907778e-02 5.737440e-03
      11089   466_550231 1987          S 7.000000e+00  1.661743e-02 7.766974e-01
      11090   466_550231 1987          N 9.880000e+02 -1.504985e+01 8.580720e-01
      11091   466_550231 1987       maxN 9.320000e+02 -5.552142e+01 4.623955e-01
      11092   466_550231 1987    Shannon 2.730344e-01  4.242871e-02 3.912244e-03
      11093   466_550231 1987    Simpson 1.084225e-01  2.354598e-02 2.896089e-03
      11094   466_550231 1987 invSimpson 1.121608e+00  7.736364e-02 7.418357e-03
      11095   466_550231 1987        PIE 1.085324e-01  2.355460e-02 2.899941e-03
      11096   466_550231 1987      DomMc 9.838057e-01 -8.876225e-03 5.312835e-03
      11097   466_550231 1987 expShannon 1.313945e+00  9.907778e-02 5.737440e-03
      11098   466_554603 1993          S 1.100000e+01  8.955765e-02 4.332420e-01
      11099   466_554603 1993          N 6.147000e+03 -1.831672e+02 1.252007e-01
      11100   466_554603 1993       maxN 5.934000e+03 -1.905540e+02 1.027023e-01
      11101   466_554603 1993    Shannon 2.158070e-01  2.800352e-02 2.365236e-01
      11102   466_554603 1993    Simpson 6.788399e-02  1.352084e-02 2.301714e-01
      11103   466_554603 1993 invSimpson 1.072828e+00  2.819782e-02 3.141248e-01
      11104   466_554603 1993        PIE 6.789504e-02  1.351635e-02 2.311366e-01
      11105   466_554603 1993      DomMc 9.755979e-01 -4.816175e-03 3.358887e-01
      11106   466_554603 1993 expShannon 1.240863e+00  5.287863e-02 3.021771e-01
      11107   466_554603 2006          S 1.300000e+01  8.955765e-02 4.332420e-01
      11108   466_554603 2006          N 1.631000e+03 -1.831672e+02 1.252007e-01
      11109   466_554603 2006       maxN 1.188000e+03 -1.905540e+02 1.027023e-01
      11110   466_554603 2006    Shannon 1.045134e+00  2.800352e-02 2.365236e-01
      11111   466_554603 2006    Simpson 4.528350e-01  1.352084e-02 2.301714e-01
      11112   466_554603 2006 invSimpson 1.827602e+00  2.819782e-02 3.141248e-01
      11113   466_554603 2006        PIE 4.531128e-01  1.351635e-02 2.311366e-01
      11114   466_554603 2006      DomMc 8.123850e-01 -4.816175e-03 3.358887e-01
      11115   466_554603 2006 expShannon 2.843781e+00  5.287863e-02 3.021771e-01
      11116   466_554603 1997          S 1.100000e+01  8.955765e-02 4.332420e-01
      11117   466_554603 1997          N 1.121000e+03 -1.831672e+02 1.252007e-01
      11118   466_554603 1997       maxN 9.780000e+02 -1.905540e+02 1.027023e-01
      11119   466_554603 1997    Shannon 5.978914e-01  2.800352e-02 2.365236e-01
      11120   466_554603 1997    Simpson 2.349549e-01  1.352084e-02 2.301714e-01
      11121   466_554603 1997 invSimpson 1.307113e+00  2.819782e-02 3.141248e-01
      11122   466_554603 1997        PIE 2.351647e-01  1.351635e-02 2.311366e-01
      11123   466_554603 1997      DomMc 9.232828e-01 -4.816175e-03 3.358887e-01
      11124   466_554603 1997 expShannon 1.818281e+00  5.287863e-02 3.021771e-01
      11125   466_554603 2001          S 1.000000e+01  8.955765e-02 4.332420e-01
      11126   466_554603 2001          N 1.028000e+03 -1.831672e+02 1.252007e-01
      11127   466_554603 2001       maxN 6.260000e+02 -1.905540e+02 1.027023e-01
      11128   466_554603 2001    Shannon 1.249049e+00  2.800352e-02 2.365236e-01
      11129   466_554603 2001    Simpson 5.854366e-01  1.352084e-02 2.301714e-01
      11130   466_554603 2001 invSimpson 2.412176e+00  2.819782e-02 3.141248e-01
      11131   466_554603 2001        PIE 5.860066e-01  1.351635e-02 2.311366e-01
      11132   466_554603 2001      DomMc 7.752918e-01 -4.816175e-03 3.358887e-01
      11133   466_554603 2001 expShannon 3.487025e+00  5.287863e-02 3.021771e-01
      11134   466_554603 2003          S 1.200000e+01  8.955765e-02 4.332420e-01
      11135   466_554603 2003          N 1.740000e+03 -1.831672e+02 1.252007e-01
      11136   466_554603 2003       maxN 1.578000e+03 -1.905540e+02 1.027023e-01
      11137   466_554603 2003    Shannon 4.855920e-01  2.800352e-02 2.365236e-01
      11138   466_554603 2003    Simpson 1.759678e-01  1.352084e-02 2.301714e-01
      11139   466_554603 2003 invSimpson 1.213545e+00  2.819782e-02 3.141248e-01
      11140   466_554603 2003        PIE 1.760690e-01  1.351635e-02 2.311366e-01
      11141   466_554603 2003      DomMc 9.316092e-01 -4.816175e-03 3.358887e-01
      11142   466_554603 2003 expShannon 1.625137e+00  5.287863e-02 3.021771e-01
      11143   466_554603 2005          S 1.000000e+01  8.955765e-02 4.332420e-01
      11144   466_554603 2005          N 1.266000e+03 -1.831672e+02 1.252007e-01
      11145   466_554603 2005       maxN 1.098000e+03 -1.905540e+02 1.027023e-01
      11146   466_554603 2005    Shannon 5.925780e-01  2.800352e-02 2.365236e-01
      11147   466_554603 2005    Simpson 2.421429e-01  1.352084e-02 2.301714e-01
      11148   466_554603 2005 invSimpson 1.319510e+00  2.819782e-02 3.141248e-01
      11149   466_554603 2005        PIE 2.423343e-01  1.351635e-02 2.311366e-01
      11150   466_554603 2005      DomMc 9.368088e-01 -4.816175e-03 3.358887e-01
      11151   466_554603 2005 expShannon 1.808645e+00  5.287863e-02 3.021771e-01
      11152   466_554603 1992          S 1.000000e+01  8.955765e-02 4.332420e-01
      11153   466_554603 1992          N 2.518000e+03 -1.831672e+02 1.252007e-01
      11154   466_554603 1992       maxN 2.382000e+03 -1.905540e+02 1.027023e-01
      11155   466_554603 1992    Shannon 3.063109e-01  2.800352e-02 2.365236e-01
      11156   466_554603 1992    Simpson 1.045249e-01  1.352084e-02 2.301714e-01
      11157   466_554603 1992 invSimpson 1.116726e+00  2.819782e-02 3.141248e-01
      11158   466_554603 1992        PIE 1.045665e-01  1.351635e-02 2.311366e-01
      11159   466_554603 1992      DomMc 9.602859e-01 -4.816175e-03 3.358887e-01
      11160   466_554603 1992 expShannon 1.358405e+00  5.287863e-02 3.021771e-01
      11161   466_554603 1994          S 1.000000e+01  8.955765e-02 4.332420e-01
      11162   466_554603 1994          N 3.480000e+02 -1.831672e+02 1.252007e-01
      11163   466_554603 1994       maxN 2.590000e+02 -1.905540e+02 1.027023e-01
      11164   466_554603 1994    Shannon 1.062925e+00  2.800352e-02 2.365236e-01
      11165   466_554603 1994    Simpson 4.353448e-01  1.352084e-02 2.301714e-01
      11166   466_554603 1994 invSimpson 1.770992e+00  2.819782e-02 3.141248e-01
      11167   466_554603 1994        PIE 4.365994e-01  1.351635e-02 2.311366e-01
      11168   466_554603 1994      DomMc 8.017241e-01 -4.816175e-03 3.358887e-01
      11169   466_554603 1994 expShannon 2.894825e+00  5.287863e-02 3.021771e-01
      11170   466_554603 1995          S 9.000000e+00  8.955765e-02 4.332420e-01
      11171   466_554603 1995          N 4.651000e+03 -1.831672e+02 1.252007e-01
      11172   466_554603 1995       maxN 4.402000e+03 -1.905540e+02 1.027023e-01
      11173   466_554603 1995    Shannon 2.872713e-01  2.800352e-02 2.365236e-01
      11174   466_554603 1995    Simpson 1.034103e-01  1.352084e-02 2.301714e-01
      11175   466_554603 1995 invSimpson 1.115337e+00  2.819782e-02 3.141248e-01
      11176   466_554603 1995        PIE 1.034325e-01  1.351635e-02 2.311366e-01
      11177   466_554603 1995      DomMc 9.658138e-01 -4.816175e-03 3.358887e-01
      11178   466_554603 1995 expShannon 1.332786e+00  5.287863e-02 3.021771e-01
      11179   466_554603 1996          S 8.000000e+00  8.955765e-02 4.332420e-01
      11180   466_554603 1996          N 4.686000e+03 -1.831672e+02 1.252007e-01
      11181   466_554603 1996       maxN 4.287000e+03 -1.905540e+02 1.027023e-01
      11182   466_554603 1996    Shannon 3.873783e-01  2.800352e-02 2.365236e-01
      11183   466_554603 1996    Simpson 1.596485e-01  1.352084e-02 2.301714e-01
      11184   466_554603 1996 invSimpson 1.189978e+00  2.819782e-02 3.141248e-01
      11185   466_554603 1996        PIE 1.596826e-01  1.351635e-02 2.311366e-01
      11186   466_554603 1996      DomMc 9.709774e-01 -4.816175e-03 3.358887e-01
      11187   466_554603 1996 expShannon 1.473114e+00  5.287863e-02 3.021771e-01
      11188   466_554603 2002          S 7.000000e+00  8.955765e-02 4.332420e-01
      11189   466_554603 2002          N 1.671000e+03 -1.831672e+02 1.252007e-01
      11190   466_554603 2002       maxN 1.569000e+03 -1.905540e+02 1.027023e-01
      11191   466_554603 2002    Shannon 3.294869e-01  2.800352e-02 2.365236e-01
      11192   466_554603 2002    Simpson 1.175794e-01  1.352084e-02 2.301714e-01
      11193   466_554603 2002 invSimpson 1.133246e+00  2.819782e-02 3.141248e-01
      11194   466_554603 2002        PIE 1.176498e-01  1.351635e-02 2.311366e-01
      11195   466_554603 2002      DomMc 9.551167e-01 -4.816175e-03 3.358887e-01
      11196   466_554603 2002 expShannon 1.390255e+00  5.287863e-02 3.021771e-01
      11197   466_554600 1993          S 1.000000e+01  1.721470e-01 4.951660e-01
      11198   466_554600 1993          N 7.609000e+03 -5.469130e+02 4.519147e-02
      11199   466_554600 1993       maxN 4.060000e+03 -3.847805e+02 8.644738e-02
      11200   466_554600 1993    Shannon 1.280645e+00  2.508894e-03 9.080931e-01
      11201   466_554600 1993    Simpson 6.476740e-01  1.645824e-03 8.769242e-01
      11202   466_554600 1993 invSimpson 2.838280e+00 -2.558356e-03 9.563118e-01
      11203   466_554600 1993        PIE 6.477591e-01  1.658612e-03 8.760111e-01
      11204   466_554600 1993      DomMc 6.999606e-01  6.753398e-03 4.228298e-01
      11205   466_554600 1993 expShannon 3.598959e+00 -2.184859e-04 9.970307e-01
      11206   466_554600 2006          S 1.400000e+01  1.721470e-01 4.951660e-01
      11207   466_554600 2006          N 3.437000e+03 -5.469130e+02 4.519147e-02
      11208   466_554600 2006       maxN 1.579000e+03 -3.847805e+02 8.644738e-02
      11209   466_554600 2006    Shannon 1.218810e+00  2.508894e-03 9.080931e-01
      11210   466_554600 2006    Simpson 6.322411e-01  1.645824e-03 8.769242e-01
      11211   466_554600 2006 invSimpson 2.719172e+00 -2.558356e-03 9.563118e-01
      11212   466_554600 2006        PIE 6.324251e-01  1.658612e-03 8.760111e-01
      11213   466_554600 2006      DomMc 8.449229e-01  6.753398e-03 4.228298e-01
      11214   466_554600 2006 expShannon 3.383159e+00 -2.184859e-04 9.970307e-01
      11215   466_554600 2003          S 9.000000e+00  1.721470e-01 4.951660e-01
      11216   466_554600 2003          N 1.463000e+03 -5.469130e+02 4.519147e-02
      11217   466_554600 2003       maxN 9.590000e+02 -3.847805e+02 8.644738e-02
      11218   466_554600 2003    Shannon 1.066524e+00  2.508894e-03 9.080931e-01
      11219   466_554600 2003    Simpson 5.260457e-01  1.645824e-03 8.769242e-01
      11220   466_554600 2003 invSimpson 2.109908e+00 -2.558356e-03 9.563118e-01
      11221   466_554600 2003        PIE 5.264056e-01  1.658612e-03 8.760111e-01
      11222   466_554600 2003      DomMc 8.455229e-01  6.753398e-03 4.228298e-01
      11223   466_554600 2003 expShannon 2.905263e+00 -2.184859e-04 9.970307e-01
      11224   466_554600 2005          S 8.000000e+00  1.721470e-01 4.951660e-01
      11225   466_554600 2005          N 2.544000e+03 -5.469130e+02 4.519147e-02
      11226   466_554600 2005       maxN 1.583000e+03 -3.847805e+02 8.644738e-02
      11227   466_554600 2005    Shannon 9.068916e-01  2.508894e-03 9.080931e-01
      11228   466_554600 2005    Simpson 5.086456e-01  1.645824e-03 8.769242e-01
      11229   466_554600 2005 invSimpson 2.035191e+00 -2.558356e-03 9.563118e-01
      11230   466_554600 2005        PIE 5.088457e-01  1.658612e-03 8.760111e-01
      11231   466_554600 2005      DomMc 9.437893e-01  6.753398e-03 4.228298e-01
      11232   466_554600 2005 expShannon 2.476612e+00 -2.184859e-04 9.970307e-01
      11233   466_554600 1995          S 8.000000e+00  1.721470e-01 4.951660e-01
      11234   466_554600 1995          N 1.112000e+04 -5.469130e+02 4.519147e-02
      11235   466_554600 1995       maxN 8.696000e+03 -3.847805e+02 8.644738e-02
      11236   466_554600 1995    Shannon 6.639843e-01  2.508894e-03 9.080931e-01
      11237   466_554600 1995    Simpson 3.583119e-01  1.645824e-03 8.769242e-01
      11238   466_554600 1995 invSimpson 1.558389e+00 -2.558356e-03 9.563118e-01
      11239   466_554600 1995        PIE 3.583441e-01  1.658612e-03 8.760111e-01
      11240   466_554600 1995      DomMc 9.494604e-01  6.753398e-03 4.228298e-01
      11241   466_554600 1995 expShannon 1.942516e+00 -2.184859e-04 9.970307e-01
      11242   466_554600 1999          S 5.000000e+00  1.721470e-01 4.951660e-01
      11243   466_554600 1999          N 2.157000e+03 -5.469130e+02 4.519147e-02
      11244   466_554600 1999       maxN 1.061000e+03 -3.847805e+02 8.644738e-02
      11245   466_554600 1999    Shannon 9.520625e-01  2.508894e-03 9.080931e-01
      11246   466_554600 1999    Simpson 5.615119e-01  1.645824e-03 8.769242e-01
      11247   466_554600 1999 invSimpson 2.280564e+00 -2.558356e-03 9.563118e-01
      11248   466_554600 1999        PIE 5.617724e-01  1.658612e-03 8.760111e-01
      11249   466_554600 1999      DomMc 9.327770e-01  6.753398e-03 4.228298e-01
      11250   466_554600 1999 expShannon 2.591048e+00 -2.184859e-04 9.970307e-01
      11251   466_554600 2002          S 8.000000e+00  1.721470e-01 4.951660e-01
      11252   466_554600 2002          N 2.955000e+03 -5.469130e+02 4.519147e-02
      11253   466_554600 2002       maxN 2.256000e+03 -3.847805e+02 8.644738e-02
      11254   466_554600 2002    Shannon 7.443814e-01  2.508894e-03 9.080931e-01
      11255   466_554600 2002    Simpson 3.826285e-01  1.645824e-03 8.769242e-01
      11256   466_554600 2002 invSimpson 1.619770e+00 -2.558356e-03 9.563118e-01
      11257   466_554600 2002        PIE 3.827581e-01  1.658612e-03 8.760111e-01
      11258   466_554600 2002      DomMc 9.468697e-01  6.753398e-03 4.228298e-01
      11259   466_554600 2002 expShannon 2.105139e+00 -2.184859e-04 9.970307e-01
      11260   466_553147 1994          S 1.100000e+01  3.453307e-02 7.939738e-01
      11261   466_553147 1994          N 5.535000e+03 -5.802967e+01 5.902878e-01
      11262   466_553147 1994       maxN 3.668000e+03 -6.836673e+01 3.579405e-01
      11263   466_553147 1994    Shannon 8.708331e-01  2.075922e-02 3.157093e-01
      11264   466_553147 1994    Simpson 4.799881e-01  1.247456e-02 2.603718e-01
      11265   466_553147 1994 invSimpson 1.923033e+00  3.410652e-02 2.955236e-01
      11266   466_553147 1994        PIE 4.800748e-01  1.247913e-02 2.606439e-01
      11267   466_553147 1994      DomMc 9.454381e-01 -1.858553e-03 6.888375e-01
      11268   466_553147 1994 expShannon 2.388900e+00  3.886721e-02 4.119493e-01
      11269   466_553147 1986          S 1.100000e+01  3.453307e-02 7.939738e-01
      11270   466_553147 1986          N 2.451000e+03 -5.802967e+01 5.902878e-01
      11271   466_553147 1986       maxN 2.311000e+03 -6.836673e+01 3.579405e-01
      11272   466_553147 1986    Shannon 2.983149e-01  2.075922e-02 3.157093e-01
      11273   466_553147 1986    Simpson 1.097832e-01  1.247456e-02 2.603718e-01
      11274   466_553147 1986 invSimpson 1.123322e+00  3.410652e-02 2.955236e-01
      11275   466_553147 1986        PIE 1.098281e-01  1.247913e-02 2.606439e-01
      11276   466_553147 1986      DomMc 9.751122e-01 -1.858553e-03 6.888375e-01
      11277   466_553147 1986 expShannon 1.347586e+00  3.886721e-02 4.119493e-01
      11278   466_553147 1999          S 1.400000e+01  3.453307e-02 7.939738e-01
      11279   466_553147 1999          N 1.592000e+03 -5.802967e+01 5.902878e-01
      11280   466_553147 1999       maxN 8.540000e+02 -6.836673e+01 3.579405e-01
      11281   466_553147 1999    Shannon 1.200277e+00  2.075922e-02 3.157093e-01
      11282   466_553147 1999    Simpson 6.044631e-01  1.247456e-02 2.603718e-01
      11283   466_553147 1999 invSimpson 2.528209e+00  3.410652e-02 2.955236e-01
      11284   466_553147 1999        PIE 6.048430e-01  1.247913e-02 2.606439e-01
      11285   466_553147 1999      DomMc 8.542714e-01 -1.858553e-03 6.888375e-01
      11286   466_553147 1999 expShannon 3.321037e+00  3.886721e-02 4.119493e-01
      11287   466_553147 2005          S 1.200000e+01  3.453307e-02 7.939738e-01
      11288   466_553147 2005          N 1.102000e+03 -5.802967e+01 5.902878e-01
      11289   466_553147 2005       maxN 9.060000e+02 -6.836673e+01 3.579405e-01
      11290   466_553147 2005    Shannon 7.593695e-01  2.075922e-02 3.157093e-01
      11291   466_553147 2005    Simpson 3.163824e-01  1.247456e-02 2.603718e-01
      11292   466_553147 2005 invSimpson 1.462806e+00  3.410652e-02 2.955236e-01
      11293   466_553147 2005        PIE 3.166697e-01  1.247913e-02 2.606439e-01
      11294   466_553147 2005      DomMc 8.865699e-01 -1.858553e-03 6.888375e-01
      11295   466_553147 2005 expShannon 2.136928e+00  3.886721e-02 4.119493e-01
      11296   466_553147 1990          S 1.000000e+01  3.453307e-02 7.939738e-01
      11297   466_553147 1990          N 5.930000e+02 -5.802967e+01 5.902878e-01
      11298   466_553147 1990       maxN 4.130000e+02 -6.836673e+01 3.579405e-01
      11299   466_553147 1990    Shannon 1.173412e+00  2.075922e-02 3.157093e-01
      11300   466_553147 1990    Simpson 4.982127e-01  1.247456e-02 2.603718e-01
      11301   466_553147 1990 invSimpson 1.992876e+00  3.410652e-02 2.955236e-01
      11302   466_553147 1990        PIE 4.990543e-01  1.247913e-02 2.606439e-01
      11303   466_553147 1990      DomMc 7.807757e-01 -1.858553e-03 6.888375e-01
      11304   466_553147 1990 expShannon 3.233004e+00  3.886721e-02 4.119493e-01
      11305   466_553147 1992          S 9.000000e+00  3.453307e-02 7.939738e-01
      11306   466_553147 1992          N 2.172000e+03 -5.802967e+01 5.902878e-01
      11307   466_553147 1992       maxN 1.774000e+03 -6.836673e+01 3.579405e-01
      11308   466_553147 1992    Shannon 6.095912e-01  2.075922e-02 3.157093e-01
      11309   466_553147 1992    Simpson 3.093329e-01  1.247456e-02 2.603718e-01
      11310   466_553147 1992 invSimpson 1.447876e+00  3.410652e-02 2.955236e-01
      11311   466_553147 1992        PIE 3.094754e-01  1.247913e-02 2.606439e-01
      11312   466_553147 1992      DomMc 9.696133e-01 -1.858553e-03 6.888375e-01
      11313   466_553147 1992 expShannon 1.839679e+00  3.886721e-02 4.119493e-01
      11314   466_553147 2003          S 8.000000e+00  3.453307e-02 7.939738e-01
      11315   466_553147 2003          N 1.390000e+03 -5.802967e+01 5.902878e-01
      11316   466_553147 2003       maxN 6.690000e+02 -6.836673e+01 3.579405e-01
      11317   466_553147 2003    Shannon 1.044712e+00  2.075922e-02 3.157093e-01
      11318   466_553147 2003    Simpson 5.780446e-01  1.247456e-02 2.603718e-01
      11319   466_553147 2003 invSimpson 2.369919e+00  3.410652e-02 2.955236e-01
      11320   466_553147 2003        PIE 5.784608e-01  1.247913e-02 2.606439e-01
      11321   466_553147 2003      DomMc 9.151079e-01 -1.858553e-03 6.888375e-01
      11322   466_553147 2003 expShannon 2.842579e+00  3.886721e-02 4.119493e-01
      11323   466_556785 1994          S 8.000000e+00  2.914418e-01 1.075400e-03
      11324   466_556785 1994          N 3.467000e+03 -8.998901e+01 7.542274e-01
      11325   466_556785 1994       maxN 3.203000e+03 -1.732226e+02 4.871067e-01
      11326   466_556785 1994    Shannon 3.796737e-01  5.115565e-02 4.165138e-03
      11327   466_556785 1994    Simpson 1.448166e-01  2.823605e-02 4.813484e-04
      11328   466_556785 1994 invSimpson 1.169340e+00  7.958476e-02 4.012746e-03
      11329   466_556785 1994        PIE 1.448583e-01  2.826079e-02 4.885738e-04
      11330   466_556785 1994      DomMc 9.538506e-01 -8.123916e-03 8.884500e-02
      11331   466_556785 1994 expShannon 1.461808e+00  1.109347e-01 1.459113e-02
      11332   466_556785 2003          S 1.100000e+01  2.914418e-01 1.075400e-03
      11333   466_556785 2003          N 4.621000e+03 -8.998901e+01 7.542274e-01
      11334   466_556785 2003       maxN 3.283000e+03 -1.732226e+02 4.871067e-01
      11335   466_556785 2003    Shannon 7.640015e-01  5.115565e-02 4.165138e-03
      11336   466_556785 2003    Simpson 4.301688e-01  2.823605e-02 4.813484e-04
      11337   466_556785 2003 invSimpson 1.754906e+00  7.958476e-02 4.012746e-03
      11338   466_556785 2003        PIE 4.302619e-01  2.826079e-02 4.885738e-04
      11339   466_556785 2003      DomMc 9.649427e-01 -8.123916e-03 8.884500e-02
      11340   466_556785 2003 expShannon 2.146850e+00  1.109347e-01 1.459113e-02
      11341   466_556785 1997          S 1.000000e+01  2.914418e-01 1.075400e-03
      11342   466_556785 1997          N 8.740000e+02 -8.998901e+01 7.542274e-01
      11343   466_556785 1997       maxN 6.110000e+02 -1.732226e+02 4.871067e-01
      11344   466_556785 1997    Shannon 9.732574e-01  5.115565e-02 4.165138e-03
      11345   466_556785 1997    Simpson 4.697438e-01  2.823605e-02 4.813484e-04
      11346   466_556785 1997 invSimpson 1.885881e+00  7.958476e-02 4.012746e-03
      11347   466_556785 1997        PIE 4.702819e-01  2.826079e-02 4.885738e-04
      11348   466_556785 1997      DomMc 8.958810e-01 -8.123916e-03 8.884500e-02
      11349   466_556785 1997 expShannon 2.646551e+00  1.109347e-01 1.459113e-02
      11350   466_556785 1999          S 1.000000e+01  2.914418e-01 1.075400e-03
      11351   466_556785 1999          N 5.330000e+02 -8.998901e+01 7.542274e-01
      11352   466_556785 1999       maxN 2.900000e+02 -1.732226e+02 4.871067e-01
      11353   466_556785 1999    Shannon 1.438551e+00  5.115565e-02 4.165138e-03
      11354   466_556785 1999    Simpson 6.540838e-01  2.823605e-02 4.813484e-04
      11355   466_556785 1999 invSimpson 2.890873e+00  7.958476e-02 4.012746e-03
      11356   466_556785 1999        PIE 6.553132e-01  2.826079e-02 4.885738e-04
      11357   466_556785 1999      DomMc 7.260788e-01 -8.123916e-03 8.884500e-02
      11358   466_556785 1999 expShannon 4.214585e+00  1.109347e-01 1.459113e-02
      11359   466_556785 2007          S 1.100000e+01  2.914418e-01 1.075400e-03
      11360   466_556785 2007          N 8.040000e+02 -8.998901e+01 7.542274e-01
      11361   466_556785 2007       maxN 4.170000e+02 -1.732226e+02 4.871067e-01
      11362   466_556785 2007    Shannon 1.427993e+00  5.115565e-02 4.165138e-03
      11363   466_556785 2007    Simpson 6.712427e-01  2.823605e-02 4.813484e-04
      11364   466_556785 2007 invSimpson 3.041757e+00  7.958476e-02 4.012746e-03
      11365   466_556785 2007        PIE 6.720786e-01  2.826079e-02 4.885738e-04
      11366   466_556785 2007      DomMc 7.027363e-01 -8.123916e-03 8.884500e-02
      11367   466_556785 2007 expShannon 4.170321e+00  1.109347e-01 1.459113e-02
      11368   466_556785 2005          S 1.200000e+01  2.914418e-01 1.075400e-03
      11369   466_556785 2005          N 9.296000e+03 -8.998901e+01 7.542274e-01
      11370   466_556785 2005       maxN 5.316000e+03 -1.732226e+02 4.871067e-01
      11371   466_556785 2005    Shannon 7.619257e-01  5.115565e-02 4.165138e-03
      11372   466_556785 2005    Simpson 5.013753e-01  2.823605e-02 4.813484e-04
      11373   466_556785 2005 invSimpson 2.005516e+00  7.958476e-02 4.012746e-03
      11374   466_556785 2005        PIE 5.014292e-01  2.826079e-02 4.885738e-04
      11375   466_556785 2005      DomMc 9.860155e-01 -8.123916e-03 8.884500e-02
      11376   466_556785 2005 expShannon 2.142398e+00  1.109347e-01 1.459113e-02
      11377   466_556785 1992          S 9.000000e+00  2.914418e-01 1.075400e-03
      11378   466_556785 1992          N 1.381000e+03 -8.998901e+01 7.542274e-01
      11379   466_556785 1992       maxN 1.106000e+03 -1.732226e+02 4.871067e-01
      11380   466_556785 1992    Shannon 6.481006e-01  5.115565e-02 4.165138e-03
      11381   466_556785 1992    Simpson 3.311100e-01  2.823605e-02 4.813484e-04
      11382   466_556785 1992 invSimpson 1.495014e+00  7.958476e-02 4.012746e-03
      11383   466_556785 1992        PIE 3.313499e-01  2.826079e-02 4.885738e-04
      11384   466_556785 1992      DomMc 9.659667e-01 -8.123916e-03 8.884500e-02
      11385   466_556785 1992 expShannon 1.911906e+00  1.109347e-01 1.459113e-02
      11386   466_556785 1993          S 1.100000e+01  2.914418e-01 1.075400e-03
      11387   466_556785 1993          N 1.950000e+04 -8.998901e+01 7.542274e-01
      11388   466_556785 1993       maxN 1.724900e+04 -1.732226e+02 4.871067e-01
      11389   466_556785 1993    Shannon 4.561404e-01  5.115565e-02 4.165138e-03
      11390   466_556785 1993    Simpson 2.093189e-01  2.823605e-02 4.813484e-04
      11391   466_556785 1993 invSimpson 1.264732e+00  7.958476e-02 4.012746e-03
      11392   466_556785 1993        PIE 2.093296e-01  2.826079e-02 4.885738e-04
      11393   466_556785 1993      DomMc 9.740000e-01 -8.123916e-03 8.884500e-02
      11394   466_556785 1993 expShannon 1.577972e+00  1.109347e-01 1.459113e-02
      11395   466_556785 1995          S 1.000000e+01  2.914418e-01 1.075400e-03
      11396   466_556785 1995          N 2.322000e+03 -8.998901e+01 7.542274e-01
      11397   466_556785 1995       maxN 1.972000e+03 -1.732226e+02 4.871067e-01
      11398   466_556785 1995    Shannon 6.113218e-01  5.115565e-02 4.165138e-03
      11399   466_556785 1995    Simpson 2.686604e-01  2.823605e-02 4.813484e-04
      11400   466_556785 1995 invSimpson 1.367354e+00  7.958476e-02 4.012746e-03
      11401   466_556785 1995        PIE 2.687762e-01  2.826079e-02 4.885738e-04
      11402   466_556785 1995      DomMc 9.465978e-01 -8.123916e-03 8.884500e-02
      11403   466_556785 1995 expShannon 1.842866e+00  1.109347e-01 1.459113e-02
      11404   466_556785 1986          S 5.000000e+00  2.914418e-01 1.075400e-03
      11405   466_556785 1986          N 8.129000e+03 -8.998901e+01 7.542274e-01
      11406   466_556785 1986       maxN 8.079000e+03 -1.732226e+02 4.871067e-01
      11407   466_556785 1986    Shannon 4.266331e-02  5.115565e-02 4.165138e-03
      11408   466_556785 1986    Simpson 1.224216e-02  2.823605e-02 4.813484e-04
      11409   466_556785 1986 invSimpson 1.012394e+00  7.958476e-02 4.012746e-03
      11410   466_556785 1986        PIE 1.224367e-02  2.826079e-02 4.885738e-04
      11411   466_556785 1986      DomMc 9.984008e-01 -8.123916e-03 8.884500e-02
      11412   466_556785 1986 expShannon 1.043586e+00  1.109347e-01 1.459113e-02
      11413   466_556785 1987          S 5.000000e+00  2.914418e-01 1.075400e-03
      11414   466_556785 1987          N 6.470000e+02 -8.998901e+01 7.542274e-01
      11415   466_556785 1987       maxN 6.210000e+02 -1.732226e+02 4.871067e-01
      11416   466_556785 1987    Shannon 2.126907e-01  5.115565e-02 4.165138e-03
      11417   466_556785 1987    Simpson 7.814930e-02  2.823605e-02 4.813484e-04
      11418   466_556785 1987 invSimpson 1.084774e+00  7.958476e-02 4.012746e-03
      11419   466_556785 1987        PIE 7.827027e-02  2.826079e-02 4.885738e-04
      11420   466_556785 1987      DomMc 9.783617e-01 -8.123916e-03 8.884500e-02
      11421   466_556785 1987 expShannon 1.237002e+00  1.109347e-01 1.459113e-02
      11422   466_550958 1994          S 1.200000e+01  7.382763e-02 3.738185e-01
      11423   466_550958 1994          N 6.408000e+03 -2.953400e+02 2.275593e-02
      11424   466_550958 1994       maxN 4.167000e+03 -2.102852e+02 2.261838e-02
      11425   466_550958 1994    Shannon 1.093614e+00 -5.442398e-04 9.586652e-01
      11426   466_550958 1994    Simpson 5.334824e-01  1.282647e-03 8.202125e-01
      11427   466_550958 1994 invSimpson 2.143542e+00  6.184569e-03 7.949371e-01
      11428   466_550958 1994        PIE 5.335656e-01  1.299487e-03 8.179649e-01
      11429   466_550958 1994      DomMc 8.319288e-01  3.164012e-03 3.530184e-01
      11430   466_550958 1994 expShannon 2.985042e+00  3.627789e-04 9.898171e-01
      11431   466_550958 1999          S 1.000000e+01  7.382763e-02 3.738185e-01
      11432   466_550958 1999          N 4.214000e+03 -2.953400e+02 2.275593e-02
      11433   466_550958 1999       maxN 2.175000e+03 -2.102852e+02 2.261838e-02
      11434   466_550958 1999    Shannon 8.867325e-01 -5.442398e-04 9.586652e-01
      11435   466_550958 1999    Simpson 5.411567e-01  1.282647e-03 8.202125e-01
      11436   466_550958 1999 invSimpson 2.179393e+00  6.184569e-03 7.949371e-01
      11437   466_550958 1999        PIE 5.412851e-01  1.299487e-03 8.179649e-01
      11438   466_550958 1999      DomMc 9.532511e-01  3.164012e-03 3.530184e-01
      11439   466_550958 1999 expShannon 2.427186e+00  3.627789e-04 9.898171e-01
      11440   466_550958 2003          S 1.200000e+01  7.382763e-02 3.738185e-01
      11441   466_550958 2003          N 1.446000e+03 -2.953400e+02 2.275593e-02
      11442   466_550958 2003       maxN 7.920000e+02 -2.102852e+02 2.261838e-02
      11443   466_550958 2003    Shannon 1.257423e+00 -5.442398e-04 9.586652e-01
      11444   466_550958 2003    Simpson 6.137396e-01  1.282647e-03 8.202125e-01
      11445   466_550958 2003 invSimpson 2.588927e+00  6.184569e-03 7.949371e-01
      11446   466_550958 2003        PIE 6.141644e-01  1.299487e-03 8.179649e-01
      11447   466_550958 2003      DomMc 8.271093e-01  3.164012e-03 3.530184e-01
      11448   466_550958 2003 expShannon 3.516350e+00  3.627789e-04 9.898171e-01
      11449   466_550958 2005          S 1.000000e+01  7.382763e-02 3.738185e-01
      11450   466_550958 2005          N 1.261000e+03 -2.953400e+02 2.275593e-02
      11451   466_550958 2005       maxN 5.800000e+02 -2.102852e+02 2.261838e-02
      11452   466_550958 2005    Shannon 1.088873e+00 -5.442398e-04 9.586652e-01
      11453   466_550958 2005    Simpson 5.846184e-01  1.282647e-03 8.202125e-01
      11454   466_550958 2005 invSimpson 2.407425e+00  6.184569e-03 7.949371e-01
      11455   466_550958 2005        PIE 5.850824e-01  1.299487e-03 8.179649e-01
      11456   466_550958 2005      DomMc 9.095956e-01  3.164012e-03 3.530184e-01
      11457   466_550958 2005 expShannon 2.970925e+00  3.627789e-04 9.898171e-01
      11458   466_550958 2007          S 1.400000e+01  7.382763e-02 3.738185e-01
      11459   466_550958 2007          N 1.079000e+03 -2.953400e+02 2.275593e-02
      11460   466_550958 2007       maxN 8.200000e+02 -2.102852e+02 2.261838e-02
      11461   466_550958 2007    Shannon 7.706190e-01 -5.442398e-04 9.586652e-01
      11462   466_550958 2007    Simpson 3.877118e-01  1.282647e-03 8.202125e-01
      11463   466_550958 2007 invSimpson 1.633218e+00  6.184569e-03 7.949371e-01
      11464   466_550958 2007        PIE 3.880715e-01  1.299487e-03 8.179649e-01
      11465   466_550958 2007      DomMc 9.434662e-01  3.164012e-03 3.530184e-01
      11466   466_550958 2007 expShannon 2.161104e+00  3.627789e-04 9.898171e-01
      11467   466_550958 2008          S 1.200000e+01  7.382763e-02 3.738185e-01
      11468   466_550958 2008          N 3.979000e+03 -2.953400e+02 2.275593e-02
      11469   466_550958 2008       maxN 2.348000e+03 -2.102852e+02 2.261838e-02
      11470   466_550958 2008    Shannon 8.334288e-01 -5.442398e-04 9.586652e-01
      11471   466_550958 2008    Simpson 5.097377e-01  1.282647e-03 8.202125e-01
      11472   466_550958 2008 invSimpson 2.039724e+00  6.184569e-03 7.949371e-01
      11473   466_550958 2008        PIE 5.098658e-01  1.299487e-03 8.179649e-01
      11474   466_550958 2008      DomMc 9.663232e-01  3.164012e-03 3.530184e-01
      11475   466_550958 2008 expShannon 2.301196e+00  3.627789e-04 9.898171e-01
      11476   466_550958 1993          S 1.200000e+01  7.382763e-02 3.738185e-01
      11477   466_550958 1993          N 7.586000e+03 -2.953400e+02 2.275593e-02
      11478   466_550958 1993       maxN 5.970000e+03 -2.102852e+02 2.261838e-02
      11479   466_550958 1993    Shannon 7.444152e-01 -5.442398e-04 9.586652e-01
      11480   466_550958 1993    Simpson 3.579200e-01  1.282647e-03 8.202125e-01
      11481   466_550958 1993 invSimpson 1.557438e+00  6.184569e-03 7.949371e-01
      11482   466_550958 1993        PIE 3.579672e-01  1.299487e-03 8.179649e-01
      11483   466_550958 1993      DomMc 9.322436e-01  3.164012e-03 3.530184e-01
      11484   466_550958 1993 expShannon 2.105210e+00  3.627789e-04 9.898171e-01
      11485   466_550958 1996          S 1.100000e+01  7.382763e-02 3.738185e-01
      11486   466_550958 1996          N 6.867000e+03 -2.953400e+02 2.275593e-02
      11487   466_550958 1996       maxN 3.338000e+03 -2.102852e+02 2.261838e-02
      11488   466_550958 1996    Shannon 1.049453e+00 -5.442398e-04 9.586652e-01
      11489   466_550958 1996    Simpson 6.008635e-01  1.282647e-03 8.202125e-01
      11490   466_550958 1996 invSimpson 2.505409e+00  6.184569e-03 7.949371e-01
      11491   466_550958 1996        PIE 6.009510e-01  1.299487e-03 8.179649e-01
      11492   466_550958 1996      DomMc 8.743265e-01  3.164012e-03 3.530184e-01
      11493   466_550958 1996 expShannon 2.856088e+00  3.627789e-04 9.898171e-01
      11494   466_550958 1995          S 1.000000e+01  7.382763e-02 3.738185e-01
      11495   466_550958 1995          N 2.668000e+03 -2.953400e+02 2.275593e-02
      11496   466_550958 1995       maxN 1.598000e+03 -2.102852e+02 2.261838e-02
      11497   466_550958 1995    Shannon 9.983560e-01 -5.442398e-04 9.586652e-01
      11498   466_550958 1995    Simpson 5.579895e-01  1.282647e-03 8.202125e-01
      11499   466_550958 1995 invSimpson 2.262390e+00  6.184569e-03 7.949371e-01
      11500   466_550958 1995        PIE 5.581987e-01  1.299487e-03 8.179649e-01
      11501   466_550958 1995      DomMc 8.556972e-01  3.164012e-03 3.530184e-01
      11502   466_550958 1995 expShannon 2.713817e+00  3.627789e-04 9.898171e-01
      11503   466_550958 1997          S 1.000000e+01  7.382763e-02 3.738185e-01
      11504   466_550958 1997          N 2.323000e+03 -2.953400e+02 2.275593e-02
      11505   466_550958 1997       maxN 1.472000e+03 -2.102852e+02 2.261838e-02
      11506   466_550958 1997    Shannon 9.655944e-01 -5.442398e-04 9.586652e-01
      11507   466_550958 1997    Simpson 5.183757e-01  1.282647e-03 8.202125e-01
      11508   466_550958 1997 invSimpson 2.076307e+00  6.184569e-03 7.949371e-01
      11509   466_550958 1997        PIE 5.185990e-01  1.299487e-03 8.179649e-01
      11510   466_550958 1997      DomMc 9.095997e-01  3.164012e-03 3.530184e-01
      11511   466_550958 1997 expShannon 2.626348e+00  3.627789e-04 9.898171e-01
      11512   466_550958 2002          S 1.000000e+01  7.382763e-02 3.738185e-01
      11513   466_550958 2002          N 2.553000e+03 -2.953400e+02 2.275593e-02
      11514   466_550958 2002       maxN 1.185000e+03 -2.102852e+02 2.261838e-02
      11515   466_550958 2002    Shannon 1.162354e+00 -5.442398e-04 9.586652e-01
      11516   466_550958 2002    Simpson 6.382829e-01  1.282647e-03 8.202125e-01
      11517   466_550958 2002 invSimpson 2.764591e+00  6.184569e-03 7.949371e-01
      11518   466_550958 2002        PIE 6.385330e-01  1.299487e-03 8.179649e-01
      11519   466_550958 2002      DomMc 8.131610e-01  3.164012e-03 3.530184e-01
      11520   466_550958 2002 expShannon 3.197450e+00  3.627789e-04 9.898171e-01
      11521   466_561148 1995          S 1.000000e+01  3.035714e-01 2.999501e-01
      11522   466_561148 1995          N 1.835700e+04 -4.005357e+01 9.819930e-01
      11523   466_561148 1995       maxN 1.017500e+04 -8.950000e+01 9.263240e-01
      11524   466_561148 1995    Shannon 7.721885e-01  2.407571e-02 2.701048e-01
      11525   466_561148 1995    Simpson 5.065282e-01  9.544909e-03 9.762643e-02
      11526   466_561148 1995 invSimpson 2.026458e+00  3.864285e-02 1.413554e-01
      11527   466_561148 1995        PIE 5.065558e-01  9.560025e-03 9.868939e-02
      11528   466_561148 1995      DomMc 9.857820e-01 -4.433171e-03 3.915008e-01
      11529   466_561148 1995 expShannon 2.164498e+00  5.541957e-02 2.920292e-01
      11530   466_561148 1999          S 1.300000e+01  3.035714e-01 2.999501e-01
      11531   466_561148 1999          N 1.850000e+03 -4.005357e+01 9.819930e-01
      11532   466_561148 1999       maxN 9.270000e+02 -8.950000e+01 9.263240e-01
      11533   466_561148 1999    Shannon 9.940692e-01  2.407571e-02 2.701048e-01
      11534   466_561148 1999    Simpson 5.617432e-01  9.544909e-03 9.762643e-02
      11535   466_561148 1999 invSimpson 2.281767e+00  3.864285e-02 1.413554e-01
      11536   466_561148 1999        PIE 5.620470e-01  9.560025e-03 9.868939e-02
      11537   466_561148 1999      DomMc 9.318919e-01 -4.433171e-03 3.915008e-01
      11538   466_561148 1999 expShannon 2.702208e+00  5.541957e-02 2.920292e-01
      11539   466_561148 1987          S 9.000000e+00  3.035714e-01 2.999501e-01
      11540   466_561148 1987          N 5.600000e+03 -4.005357e+01 9.819930e-01
      11541   466_561148 1987       maxN 3.779000e+03 -8.950000e+01 9.263240e-01
      11542   466_561148 1987    Shannon 6.800452e-01  2.407571e-02 2.701048e-01
      11543   466_561148 1987    Simpson 4.437972e-01  9.544909e-03 9.762643e-02
      11544   466_561148 1987 invSimpson 1.797905e+00  3.864285e-02 1.413554e-01
      11545   466_561148 1987        PIE 4.438765e-01  9.560025e-03 9.868939e-02
      11546   466_561148 1987      DomMc 9.923214e-01 -4.433171e-03 3.915008e-01
      11547   466_561148 1987 expShannon 1.973967e+00  5.541957e-02 2.920292e-01
      11548   466_558238 1995          S 1.100000e+01  9.699170e-02 6.466084e-02
      11549   466_558238 1995          N 6.573000e+03 -7.687217e+02 2.190703e-01
      11550   466_558238 1995       maxN 5.314000e+03 -6.963846e+02 1.959377e-01
      11551   466_558238 1995    Shannon 6.213225e-01  3.164643e-02 1.099101e-02
      11552   466_558238 1995    Simpson 3.223449e-01  1.845005e-02 2.146134e-02
      11553   466_558238 1995 invSimpson 1.475677e+00  5.238558e-02 5.209056e-02
      11554   466_558238 1995        PIE 3.223940e-01  1.846215e-02 2.141723e-02
      11555   466_558238 1995      DomMc 9.604442e-01 -5.126513e-03 8.853438e-02
      11556   466_558238 1995 expShannon 1.861388e+00  6.674140e-02 2.085579e-02
      11557   466_558238 2005          S 1.000000e+01  9.699170e-02 6.466084e-02
      11558   466_558238 2005          N 4.883000e+03 -7.687217e+02 2.190703e-01
      11559   466_558238 2005       maxN 3.224000e+03 -6.963846e+02 1.959377e-01
      11560   466_558238 2005    Shannon 8.679713e-01  3.164643e-02 1.099101e-02
      11561   466_558238 2005    Simpson 4.840938e-01  1.845005e-02 2.146134e-02
      11562   466_558238 2005 invSimpson 1.938337e+00  5.238558e-02 5.209056e-02
      11563   466_558238 2005        PIE 4.841930e-01  1.846215e-02 2.141723e-02
      11564   466_558238 2005      DomMc 9.402007e-01 -5.126513e-03 8.853438e-02
      11565   466_558238 2005 expShannon 2.382074e+00  6.674140e-02 2.085579e-02
      11566   466_558238 1992          S 9.000000e+00  9.699170e-02 6.466084e-02
      11567   466_558238 1992          N 4.042800e+04 -7.687217e+02 2.190703e-01
      11568   466_558238 1992       maxN 3.453500e+04 -6.963846e+02 1.959377e-01
      11569   466_558238 1992    Shannon 4.878172e-01  3.164643e-02 1.099101e-02
      11570   466_558238 1992    Simpson 2.545573e-01  1.845005e-02 2.146134e-02
      11571   466_558238 1992 invSimpson 1.341485e+00  5.238558e-02 5.209056e-02
      11572   466_558238 1992        PIE 2.545636e-01  1.846215e-02 2.141723e-02
      11573   466_558238 1992      DomMc 9.780845e-01 -5.126513e-03 8.853438e-02
      11574   466_558238 1992 expShannon 1.628757e+00  6.674140e-02 2.085579e-02
      11575   466_558238 1994          S 1.000000e+01  9.699170e-02 6.466084e-02
      11576   466_558238 1994          N 1.948000e+03 -7.687217e+02 2.190703e-01
      11577   466_558238 1994       maxN 1.731000e+03 -6.963846e+02 1.959377e-01
      11578   466_558238 1994    Shannon 5.215307e-01  3.164643e-02 1.099101e-02
      11579   466_558238 1994    Simpson 2.071324e-01  1.845005e-02 2.146134e-02
      11580   466_558238 1994 invSimpson 1.261245e+00  5.238558e-02 5.209056e-02
      11581   466_558238 1994        PIE 2.072387e-01  1.846215e-02 2.141723e-02
      11582   466_558238 1994      DomMc 9.281314e-01 -5.126513e-03 8.853438e-02
      11583   466_558238 1994 expShannon 1.684604e+00  6.674140e-02 2.085579e-02
      11584   466_558238 1996          S 1.000000e+01  9.699170e-02 6.466084e-02
      11585   466_558238 1996          N 6.343000e+03 -7.687217e+02 2.190703e-01
      11586   466_558238 1996       maxN 4.383000e+03 -6.963846e+02 1.959377e-01
      11587   466_558238 1996    Shannon 8.228244e-01  3.164643e-02 1.099101e-02
      11588   466_558238 1996    Simpson 4.577752e-01  1.845005e-02 2.146134e-02
      11589   466_558238 1996 invSimpson 1.844253e+00  5.238558e-02 5.209056e-02
      11590   466_558238 1996        PIE 4.578474e-01  1.846215e-02 2.141723e-02
      11591   466_558238 1996      DomMc 9.415103e-01 -5.126513e-03 8.853438e-02
      11592   466_558238 1996 expShannon 2.276922e+00  6.674140e-02 2.085579e-02
      11593   466_558238 1997          S 9.000000e+00  9.699170e-02 6.466084e-02
      11594   466_558238 1997          N 5.023000e+03 -7.687217e+02 2.190703e-01
      11595   466_558238 1997       maxN 3.765000e+03 -6.963846e+02 1.959377e-01
      11596   466_558238 1997    Shannon 7.262262e-01  3.164643e-02 1.099101e-02
      11597   466_558238 1997    Simpson 3.979823e-01  1.845005e-02 2.146134e-02
      11598   466_558238 1997 invSimpson 1.661081e+00  5.238558e-02 5.209056e-02
      11599   466_558238 1997        PIE 3.980615e-01  1.846215e-02 2.141723e-02
      11600   466_558238 1997      DomMc 9.438583e-01 -5.126513e-03 8.853438e-02
      11601   466_558238 1997 expShannon 2.067264e+00  6.674140e-02 2.085579e-02
      11602   466_558238 2003          S 1.100000e+01  9.699170e-02 6.466084e-02
      11603   466_558238 2003          N 1.834000e+03 -7.687217e+02 2.190703e-01
      11604   466_558238 2003       maxN 9.900000e+02 -6.963846e+02 1.959377e-01
      11605   466_558238 2003    Shannon 1.168031e+00  3.164643e-02 1.099101e-02
      11606   466_558238 2003    Simpson 6.075189e-01  1.845005e-02 2.146134e-02
      11607   466_558238 2003 invSimpson 2.547894e+00  5.238558e-02 5.209056e-02
      11608   466_558238 2003        PIE 6.078504e-01  1.846215e-02 2.141723e-02
      11609   466_558238 2003      DomMc 8.369684e-01 -5.126513e-03 8.853438e-02
      11610   466_558238 2003 expShannon 3.215654e+00  6.674140e-02 2.085579e-02
      11611   466_558238 2007          S 1.200000e+01  9.699170e-02 6.466084e-02
      11612   466_558238 2007          N 1.600000e+03 -7.687217e+02 2.190703e-01
      11613   466_558238 2007       maxN 1.306000e+03 -6.963846e+02 1.959377e-01
      11614   466_558238 2007    Shannon 7.268870e-01  3.164643e-02 1.099101e-02
      11615   466_558238 2007    Simpson 3.229172e-01  1.845005e-02 2.146134e-02
      11616   466_558238 2007 invSimpson 1.476924e+00  5.238558e-02 5.209056e-02
      11617   466_558238 2007        PIE 3.231191e-01  1.846215e-02 2.141723e-02
      11618   466_558238 2007      DomMc 8.987500e-01 -5.126513e-03 8.853438e-02
      11619   466_558238 2007 expShannon 2.068631e+00  6.674140e-02 2.085579e-02
      11620   466_558238 1988          S 9.000000e+00  9.699170e-02 6.466084e-02
      11621   466_558238 1988          N 3.408000e+03 -7.687217e+02 2.190703e-01
      11622   466_558238 1988       maxN 3.194000e+03 -6.963846e+02 1.959377e-01
      11623   466_558238 1988    Shannon 3.372670e-01  3.164643e-02 1.099101e-02
      11624   466_558238 1988    Simpson 1.207470e-01  1.845005e-02 2.146134e-02
      11625   466_558238 1988 invSimpson 1.137329e+00  5.238558e-02 5.209056e-02
      11626   466_558238 1988        PIE 1.207825e-01  1.846215e-02 2.141723e-02
      11627   466_558238 1988      DomMc 9.600939e-01 -5.126513e-03 8.853438e-02
      11628   466_558238 1988 expShannon 1.401113e+00  6.674140e-02 2.085579e-02
      11629   466_558238 1993          S 1.000000e+01  9.699170e-02 6.466084e-02
      11630   466_558238 1993          N 1.436800e+04 -7.687217e+02 2.190703e-01
      11631   466_558238 1993       maxN 1.182600e+04 -6.963846e+02 1.959377e-01
      11632   466_558238 1993    Shannon 6.623491e-01  3.164643e-02 1.099101e-02
      11633   466_558238 1993    Simpson 3.103444e-01  1.845005e-02 2.146134e-02
      11634   466_558238 1993 invSimpson 1.449999e+00  5.238558e-02 5.209056e-02
      11635   466_558238 1993        PIE 3.103660e-01  1.846215e-02 2.141723e-02
      11636   466_558238 1993      DomMc 9.116787e-01 -5.126513e-03 8.853438e-02
      11637   466_558238 1993 expShannon 1.939343e+00  6.674140e-02 2.085579e-02
      11638   466_558238 2001          S 9.000000e+00  9.699170e-02 6.466084e-02
      11639   466_558238 2001          N 3.162000e+03 -7.687217e+02 2.190703e-01
      11640   466_558238 2001       maxN 1.533000e+03 -6.963846e+02 1.959377e-01
      11641   466_558238 2001    Shannon 1.141547e+00  3.164643e-02 1.099101e-02
      11642   466_558238 2001    Simpson 6.359975e-01  1.845005e-02 2.146134e-02
      11643   466_558238 2001 invSimpson 2.747234e+00  5.238558e-02 5.209056e-02
      11644   466_558238 2001        PIE 6.361987e-01  1.846215e-02 2.141723e-02
      11645   466_558238 2001      DomMc 7.915876e-01 -5.126513e-03 8.853438e-02
      11646   466_558238 2001 expShannon 3.131608e+00  6.674140e-02 2.085579e-02
      11647   466_555329 1995          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11648   466_555329 1995          N 1.149600e+04 -3.474435e+02 5.437287e-01
      11649   466_555329 1995       maxN 1.080400e+04 -2.976971e+02 6.062505e-01
      11650   466_555329 1995    Shannon 2.996809e-01  6.239972e-02 3.243257e-02
      11651   466_555329 1995    Simpson 1.153941e-01  2.670736e-02 7.451068e-02
      11652   466_555329 1995 invSimpson 1.130447e+00  9.524115e-02 3.202193e-02
      11653   466_555329 1995        PIE 1.154042e-01  2.679753e-02 7.390587e-02
      11654   466_555329 1995      DomMc 9.673800e-01 -1.454250e-02 4.564785e-03
      11655   466_555329 1995 expShannon 1.349428e+00  1.628668e-01 1.463799e-02
      11656   466_555329 2001          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11657   466_555329 2001          N 1.525000e+03 -3.474435e+02 5.437287e-01
      11658   466_555329 2001       maxN 9.720000e+02 -2.976971e+02 6.062505e-01
      11659   466_555329 2001    Shannon 1.226527e+00  6.239972e-02 3.243257e-02
      11660   466_555329 2001    Simpson 5.568714e-01  2.670736e-02 7.451068e-02
      11661   466_555329 2001 invSimpson 2.256681e+00  9.524115e-02 3.202193e-02
      11662   466_555329 2001        PIE 5.572368e-01  2.679753e-02 7.390587e-02
      11663   466_555329 2001      DomMc 8.045902e-01 -1.454250e-02 4.564785e-03
      11664   466_555329 2001 expShannon 3.409367e+00  1.628668e-01 1.463799e-02
      11665   466_555329 2002          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11666   466_555329 2002          N 1.924000e+03 -3.474435e+02 5.437287e-01
      11667   466_555329 2002       maxN 8.630000e+02 -2.976971e+02 6.062505e-01
      11668   466_555329 2002    Shannon 1.403659e+00  6.239972e-02 3.243257e-02
      11669   466_555329 2002    Simpson 6.775083e-01  2.670736e-02 7.451068e-02
      11670   466_555329 2002 invSimpson 3.100855e+00  9.524115e-02 3.202193e-02
      11671   466_555329 2002        PIE 6.778606e-01  2.679753e-02 7.390587e-02
      11672   466_555329 2002      DomMc 7.759875e-01 -1.454250e-02 4.564785e-03
      11673   466_555329 2002 expShannon 4.070067e+00  1.628668e-01 1.463799e-02
      11674   466_555329 2007          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11675   466_555329 2007          N 2.740000e+02 -3.474435e+02 5.437287e-01
      11676   466_555329 2007       maxN 1.470000e+02 -2.976971e+02 6.062505e-01
      11677   466_555329 2007    Shannon 1.508077e+00  6.239972e-02 3.243257e-02
      11678   466_555329 2007    Simpson 6.678033e-01  2.670736e-02 7.451068e-02
      11679   466_555329 2007 invSimpson 3.010265e+00  9.524115e-02 3.202193e-02
      11680   466_555329 2007        PIE 6.702495e-01  2.679753e-02 7.390587e-02
      11681   466_555329 2007      DomMc 7.007299e-01 -1.454250e-02 4.564785e-03
      11682   466_555329 2007 expShannon 4.518036e+00  1.628668e-01 1.463799e-02
      11683   466_555329 1987          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11684   466_555329 1987          N 5.191000e+03 -3.474435e+02 5.437287e-01
      11685   466_555329 1987       maxN 5.068000e+03 -2.976971e+02 6.062505e-01
      11686   466_555329 1987    Shannon 1.528882e-01  6.239972e-02 3.243257e-02
      11687   466_555329 1987    Simpson 4.669805e-02  2.670736e-02 7.451068e-02
      11688   466_555329 1987 invSimpson 1.048986e+00  9.524115e-02 3.202193e-02
      11689   466_555329 1987        PIE 4.670704e-02  2.679753e-02 7.390587e-02
      11690   466_555329 1987      DomMc 9.859372e-01 -1.454250e-02 4.564785e-03
      11691   466_555329 1987 expShannon 1.165195e+00  1.628668e-01 1.463799e-02
      11692   466_555329 1989          S 1.000000e+01 -1.242718e-02 7.092626e-01
      11693   466_555329 1989          N 7.914000e+03 -3.474435e+02 5.437287e-01
      11694   466_555329 1989       maxN 5.149000e+03 -2.976971e+02 6.062505e-01
      11695   466_555329 1989    Shannon 7.839991e-01  6.239972e-02 3.243257e-02
      11696   466_555329 1989    Simpson 4.738011e-01  2.670736e-02 7.451068e-02
      11697   466_555329 1989 invSimpson 1.900422e+00  9.524115e-02 3.202193e-02
      11698   466_555329 1989        PIE 4.738610e-01  2.679753e-02 7.390587e-02
      11699   466_555329 1989      DomMc 9.709376e-01 -1.454250e-02 4.564785e-03
      11700   466_555329 1989 expShannon 2.190214e+00  1.628668e-01 1.463799e-02
      11701   466_555329 1993          S 1.100000e+01 -1.242718e-02 7.092626e-01
      11702   466_555329 1993          N 8.280000e+03 -3.474435e+02 5.437287e-01
      11703   466_555329 1993       maxN 7.187000e+03 -2.976971e+02 6.062505e-01
      11704   466_555329 1993    Shannon 5.765208e-01  6.239972e-02 3.243257e-02
      11705   466_555329 1993    Simpson 2.414929e-01  2.670736e-02 7.451068e-02
      11706   466_555329 1993 invSimpson 1.318379e+00  9.524115e-02 3.202193e-02
      11707   466_555329 1993        PIE 2.415221e-01  2.679753e-02 7.390587e-02
      11708   466_555329 1993      DomMc 9.181159e-01 -1.454250e-02 4.564785e-03
      11709   466_555329 1993 expShannon 1.779835e+00  1.628668e-01 1.463799e-02
      11710   466_555329 1997          S 9.000000e+00 -1.242718e-02 7.092626e-01
      11711   466_555329 1997          N 2.906100e+04 -3.474435e+02 5.437287e-01
      11712   466_555329 1997       maxN 2.858400e+04 -2.976971e+02 6.062505e-01
      11713   466_555329 1997    Shannon 1.063337e-01  6.239972e-02 3.243257e-02
      11714   466_555329 1997    Simpson 3.246354e-02  2.670736e-02 7.451068e-02
      11715   466_555329 1997 invSimpson 1.033553e+00  9.524115e-02 3.202193e-02
      11716   466_555329 1997        PIE 3.246466e-02  2.679753e-02 7.390587e-02
      11717   466_555329 1997      DomMc 9.925329e-01 -1.454250e-02 4.564785e-03
      11718   466_555329 1997 expShannon 1.112193e+00  1.628668e-01 1.463799e-02
      11719   466_553143 1996          S 1.200000e+01 -3.512397e-02 6.098143e-01
      11720   466_553143 1996          N 1.844000e+03 -3.504398e+02 1.468020e-03
      11721   466_553143 1996       maxN 8.740000e+02 -3.349096e+02 3.019297e-03
      11722   466_553143 1996    Shannon 1.189879e+00  3.081150e-02 8.823266e-02
      11723   466_553143 1996    Simpson 6.485841e-01  1.673407e-02 1.191400e-01
      11724   466_553143 1996 invSimpson 2.845631e+00  4.666814e-02 1.958469e-01
      11725   466_553143 1996        PIE 6.489361e-01  1.677282e-02 1.187989e-01
      11726   466_553143 1996      DomMc 7.657267e-01 -4.481974e-03 3.132830e-01
      11727   466_553143 1996 expShannon 3.286683e+00  6.625742e-02 1.136848e-01
      11728   466_553143 2003          S 1.000000e+01 -3.512397e-02 6.098143e-01
      11729   466_553143 2003          N 3.065000e+03 -3.504398e+02 1.468020e-03
      11730   466_553143 2003       maxN 2.750000e+03 -3.349096e+02 3.019297e-03
      11731   466_553143 2003    Shannon 4.454428e-01  3.081150e-02 8.823266e-02
      11732   466_553143 2003    Simpson 1.898132e-01  1.673407e-02 1.191400e-01
      11733   466_553143 2003 invSimpson 1.234283e+00  4.666814e-02 1.958469e-01
      11734   466_553143 2003        PIE 1.898752e-01  1.677282e-02 1.187989e-01
      11735   466_553143 2003      DomMc 9.670473e-01 -4.481974e-03 3.132830e-01
      11736   466_553143 2003 expShannon 1.561181e+00  6.625742e-02 1.136848e-01
      11737   466_553143 2008          S 1.000000e+01 -3.512397e-02 6.098143e-01
      11738   466_553143 2008          N 5.540000e+02 -3.504398e+02 1.468020e-03
      11739   466_553143 2008       maxN 2.290000e+02 -3.349096e+02 3.019297e-03
      11740   466_553143 2008    Shannon 1.267278e+00  3.081150e-02 8.823266e-02
      11741   466_553143 2008    Simpson 6.619596e-01  1.673407e-02 1.191400e-01
      11742   466_553143 2008 invSimpson 2.958227e+00  4.666814e-02 1.958469e-01
      11743   466_553143 2008        PIE 6.631567e-01  1.677282e-02 1.187989e-01
      11744   466_553143 2008      DomMc 7.942238e-01 -4.481974e-03 3.132830e-01
      11745   466_553143 2008 expShannon 3.551172e+00  6.625742e-02 1.136848e-01
      11746   466_553143 1991          S 1.200000e+01 -3.512397e-02 6.098143e-01
      11747   466_553143 1991          N 7.301000e+03 -3.504398e+02 1.468020e-03
      11748   466_553143 1991       maxN 6.719000e+03 -3.349096e+02 3.019297e-03
      11749   466_553143 1991    Shannon 3.847582e-01  3.081150e-02 8.823266e-02
      11750   466_553143 1991    Simpson 1.505787e-01  1.673407e-02 1.191400e-01
      11751   466_553143 1991 invSimpson 1.177272e+00  4.666814e-02 1.958469e-01
      11752   466_553143 1991        PIE 1.505993e-01  1.677282e-02 1.187989e-01
      11753   466_553143 1991      DomMc 9.678126e-01 -4.481974e-03 3.132830e-01
      11754   466_553143 1991 expShannon 1.469259e+00  6.625742e-02 1.136848e-01
      11755   466_553143 1999          S 1.000000e+01 -3.512397e-02 6.098143e-01
      11756   466_553143 1999          N 3.213000e+03 -3.504398e+02 1.468020e-03
      11757   466_553143 1999       maxN 1.656000e+03 -3.349096e+02 3.019297e-03
      11758   466_553143 1999    Shannon 9.384201e-01  3.081150e-02 8.823266e-02
      11759   466_553143 1999    Simpson 5.501390e-01  1.673407e-02 1.191400e-01
      11760   466_553143 1999 invSimpson 2.222909e+00  4.666814e-02 1.958469e-01
      11761   466_553143 1999        PIE 5.503103e-01  1.677282e-02 1.187989e-01
      11762   466_553143 1999      DomMc 9.430439e-01 -4.481974e-03 3.132830e-01
      11763   466_553143 1999 expShannon 2.555940e+00  6.625742e-02 1.136848e-01
      11764   466_553143 2006          S 1.100000e+01 -3.512397e-02 6.098143e-01
      11765   466_553143 2006          N 2.886000e+03 -3.504398e+02 1.468020e-03
      11766   466_553143 2006       maxN 1.973000e+03 -3.349096e+02 3.019297e-03
      11767   466_553143 2006    Shannon 8.903990e-01  3.081150e-02 8.823266e-02
      11768   466_553143 2006    Simpson 4.724771e-01  1.673407e-02 1.191400e-01
      11769   466_553143 2006 invSimpson 1.895652e+00  4.666814e-02 1.958469e-01
      11770   466_553143 2006        PIE 4.726409e-01  1.677282e-02 1.187989e-01
      11771   466_553143 2006      DomMc 9.237699e-01 -4.481974e-03 3.132830e-01
      11772   466_553143 2006 expShannon 2.436101e+00  6.625742e-02 1.136848e-01
      11773   466_553143 2002          S 1.000000e+01 -3.512397e-02 6.098143e-01
      11774   466_553143 2002          N 2.374000e+03 -3.504398e+02 1.468020e-03
      11775   466_553143 2002       maxN 2.061000e+03 -3.349096e+02 3.019297e-03
      11776   466_553143 2002    Shannon 5.313255e-01  3.081150e-02 8.823266e-02
      11777   466_553143 2002    Simpson 2.371532e-01  1.673407e-02 1.191400e-01
      11778   466_553143 2002 invSimpson 1.310879e+00  4.666814e-02 1.958469e-01
      11779   466_553143 2002        PIE 2.372531e-01  1.677282e-02 1.187989e-01
      11780   466_553143 2002      DomMc 9.620893e-01 -4.481974e-03 3.132830e-01
      11781   466_553143 2002 expShannon 1.701186e+00  6.625742e-02 1.136848e-01
      11782   466_553143 2005          S 8.000000e+00 -3.512397e-02 6.098143e-01
      11783   466_553143 2005          N 4.560000e+02 -3.504398e+02 1.468020e-03
      11784   466_553143 2005       maxN 2.850000e+02 -3.349096e+02 3.019297e-03
      11785   466_553143 2005    Shannon 1.179089e+00  3.081150e-02 8.823266e-02
      11786   466_553143 2005    Simpson 5.661646e-01  1.673407e-02 1.191400e-01
      11787   466_553143 2005 invSimpson 2.305022e+00  4.666814e-02 1.958469e-01
      11788   466_553143 2005        PIE 5.674089e-01  1.677282e-02 1.187989e-01
      11789   466_553143 2005      DomMc 7.938596e-01 -4.481974e-03 3.132830e-01
      11790   466_553143 2005 expShannon 3.251412e+00  6.625742e-02 1.136848e-01
      11791   466_553143 1986          S 9.000000e+00 -3.512397e-02 6.098143e-01
      11792   466_553143 1986          N 9.006000e+03 -3.504398e+02 1.468020e-03
      11793   466_553143 1986       maxN 8.357000e+03 -3.349096e+02 3.019297e-03
      11794   466_553143 1986    Shannon 3.240393e-01  3.081150e-02 8.823266e-02
      11795   466_553143 1986    Simpson 1.365735e-01  1.673407e-02 1.191400e-01
      11796   466_553143 1986 invSimpson 1.158176e+00  4.666814e-02 1.958469e-01
      11797   466_553143 1986        PIE 1.365887e-01  1.677282e-02 1.187989e-01
      11798   466_553143 1986      DomMc 9.639129e-01 -4.481974e-03 3.132830e-01
      11799   466_553143 1986 expShannon 1.382702e+00  6.625742e-02 1.136848e-01
      11800   466_556054 1997          S 1.100000e+01  2.215068e-01 7.231883e-02
      11801   466_556054 1997          N 3.107200e+04  1.281165e+02 8.657649e-01
      11802   466_556054 1997       maxN 2.836600e+04  1.281700e+02 8.600942e-01
      11803   466_556054 1997    Shannon 3.864114e-01  7.408713e-03 6.739960e-01
      11804   466_556054 1997    Simpson 1.625047e-01  1.430076e-03 9.039999e-01
      11805   466_556054 1997 invSimpson 1.194037e+00  2.110328e-03 9.444832e-01
      11806   466_556054 1997        PIE 1.625099e-01  1.430152e-03 9.040148e-01
      11807   466_556054 1997      DomMc 9.758303e-01 -4.331825e-03 4.928712e-02
      11808   466_556054 1997 expShannon 1.471690e+00  1.631708e-02 6.386024e-01
      11809   466_556054 1988          S 8.000000e+00  2.215068e-01 7.231883e-02
      11810   466_556054 1988          N 8.634000e+03  1.281165e+02 8.657649e-01
      11811   466_556054 1988       maxN 6.977000e+03  1.281700e+02 8.600942e-01
      11812   466_556054 1988    Shannon 5.913699e-01  7.408713e-03 6.739960e-01
      11813   466_556054 1988    Simpson 3.181176e-01  1.430076e-03 9.039999e-01
      11814   466_556054 1988 invSimpson 1.466528e+00  2.110328e-03 9.444832e-01
      11815   466_556054 1988        PIE 3.181544e-01  1.430152e-03 9.040148e-01
      11816   466_556054 1988      DomMc 9.776465e-01 -4.331825e-03 4.928712e-02
      11817   466_556054 1988 expShannon 1.806461e+00  1.631708e-02 6.386024e-01
      11818   466_556054 1995          S 8.000000e+00  2.215068e-01 7.231883e-02
      11819   466_556054 1995          N 7.988000e+03  1.281165e+02 8.657649e-01
      11820   466_556054 1995       maxN 5.286000e+03  1.281700e+02 8.600942e-01
      11821   466_556054 1995    Shannon 8.545983e-01  7.408713e-03 6.739960e-01
      11822   466_556054 1995    Simpson 4.870078e-01  1.430076e-03 9.039999e-01
      11823   466_556054 1995 invSimpson 1.949347e+00  2.110328e-03 9.444832e-01
      11824   466_556054 1995        PIE 4.870688e-01  1.430152e-03 9.040148e-01
      11825   466_556054 1995      DomMc 9.286430e-01 -4.331825e-03 4.928712e-02
      11826   466_556054 1995 expShannon 2.350430e+00  1.631708e-02 6.386024e-01
      11827   466_556054 2008          S 1.300000e+01  2.215068e-01 7.231883e-02
      11828   466_556054 2008          N 5.718000e+03  1.281165e+02 8.657649e-01
      11829   466_556054 2008       maxN 4.011000e+03  1.281700e+02 8.600942e-01
      11830   466_556054 2008    Shannon 9.220925e-01  7.408713e-03 6.739960e-01
      11831   466_556054 2008    Simpson 4.686617e-01  1.430076e-03 9.039999e-01
      11832   466_556054 2008 invSimpson 1.882040e+00  2.110328e-03 9.444832e-01
      11833   466_556054 2008        PIE 4.687437e-01  1.430152e-03 9.040148e-01
      11834   466_556054 2008      DomMc 8.758307e-01 -4.331825e-03 4.928712e-02
      11835   466_556054 2008 expShannon 2.514547e+00  1.631708e-02 6.386024e-01
      11836   466_556054 1989          S 1.000000e+01  2.215068e-01 7.231883e-02
      11837   466_556054 1989          N 4.691000e+03  1.281165e+02 8.657649e-01
      11838   466_556054 1989       maxN 2.418000e+03  1.281700e+02 8.600942e-01
      11839   466_556054 1989    Shannon 9.254251e-01  7.408713e-03 6.739960e-01
      11840   466_556054 1989    Simpson 5.434733e-01  1.430076e-03 9.039999e-01
      11841   466_556054 1989 invSimpson 2.190453e+00  2.110328e-03 9.444832e-01
      11842   466_556054 1989        PIE 5.435892e-01  1.430152e-03 9.040148e-01
      11843   466_556054 1989      DomMc 9.516095e-01 -4.331825e-03 4.928712e-02
      11844   466_556054 1989 expShannon 2.522941e+00  1.631708e-02 6.386024e-01
      11845   466_556054 1994          S 8.000000e+00  2.215068e-01 7.231883e-02
      11846   466_556054 1994          N 4.328000e+03  1.281165e+02 8.657649e-01
      11847   466_556054 1994       maxN 3.866000e+03  1.281700e+02 8.600942e-01
      11848   466_556054 1994    Shannon 4.602410e-01  7.408713e-03 6.739960e-01
      11849   466_556054 1994    Simpson 1.970026e-01  1.430076e-03 9.039999e-01
      11850   466_556054 1994 invSimpson 1.245334e+00  2.110328e-03 9.444832e-01
      11851   466_556054 1994        PIE 1.970481e-01  1.430152e-03 9.040148e-01
      11852   466_556054 1994      DomMc 9.604898e-01 -4.331825e-03 4.928712e-02
      11853   466_556054 1994 expShannon 1.584456e+00  1.631708e-02 6.386024e-01
      11854   466_548776 1999          S 1.000000e+01  7.463405e-18 7.966236e-01
      11855   466_548776 1999          N 3.286000e+03 -3.853908e+02 2.878733e-02
      11856   466_548776 1999       maxN 2.625000e+03 -3.055210e+02 2.583434e-02
      11857   466_548776 1999    Shannon 6.165476e-01  5.878286e-03 7.926370e-01
      11858   466_548776 1999    Simpson 3.313745e-01  4.947798e-03 7.447388e-01
      11859   466_548776 1999 invSimpson 1.495605e+00  2.094599e-02 6.812120e-01
      11860   466_548776 1999        PIE 3.314754e-01  4.978049e-03 7.434690e-01
      11861   466_548776 1999      DomMc 9.726111e-01  7.370133e-04 8.048638e-01
      11862   466_548776 1999 expShannon 1.852521e+00  1.595308e-02 7.550000e-01
      11863   466_548776 1992          S 1.000000e+01  7.463405e-18 7.966236e-01
      11864   466_548776 1992          N 5.938000e+03 -3.853908e+02 2.878733e-02
      11865   466_548776 1992       maxN 4.363000e+03 -3.055210e+02 2.583434e-02
      11866   466_548776 1992    Shannon 7.740260e-01  5.878286e-03 7.926370e-01
      11867   466_548776 1992    Simpson 4.138372e-01  4.947798e-03 7.447388e-01
      11868   466_548776 1992 invSimpson 1.706011e+00  2.094599e-02 6.812120e-01
      11869   466_548776 1992        PIE 4.139069e-01  4.978049e-03 7.434690e-01
      11870   466_548776 1992      DomMc 9.471202e-01  7.370133e-04 8.048638e-01
      11871   466_548776 1992 expShannon 2.168479e+00  1.595308e-02 7.550000e-01
      11872   466_548776 2001          S 1.000000e+01  7.463405e-18 7.966236e-01
      11873   466_548776 2001          N 1.173000e+03 -3.853908e+02 2.878733e-02
      11874   466_548776 2001       maxN 5.490000e+02 -3.055210e+02 2.583434e-02
      11875   466_548776 2001    Shannon 1.028698e+00  5.878286e-03 7.926370e-01
      11876   466_548776 2001    Simpson 5.790081e-01  4.947798e-03 7.447388e-01
      11877   466_548776 2001 invSimpson 2.375342e+00  2.094599e-02 6.812120e-01
      11878   466_548776 2001        PIE 5.795021e-01  4.978049e-03 7.434690e-01
      11879   466_548776 2001      DomMc 9.138960e-01  7.370133e-04 8.048638e-01
      11880   466_548776 2001 expShannon 2.797421e+00  1.595308e-02 7.550000e-01
      11881   466_548776 2003          S 1.000000e+01  7.463405e-18 7.966236e-01
      11882   466_548776 2003          N 9.250000e+02 -3.853908e+02 2.878733e-02
      11883   466_548776 2003       maxN 7.580000e+02 -3.055210e+02 2.583434e-02
      11884   466_548776 2003    Shannon 6.350439e-01  5.878286e-03 7.926370e-01
      11885   466_548776 2003    Simpson 3.086025e-01  4.947798e-03 7.447388e-01
      11886   466_548776 2003 invSimpson 1.446346e+00  2.094599e-02 6.812120e-01
      11887   466_548776 2003        PIE 3.089365e-01  4.978049e-03 7.434690e-01
      11888   466_548776 2003      DomMc 9.589189e-01  7.370133e-04 8.048638e-01
      11889   466_548776 2003 expShannon 1.887105e+00  1.595308e-02 7.550000e-01
      11890   466_548776 1993          S 1.000000e+01  7.463405e-18 7.966236e-01
      11891   466_548776 1993          N 3.700000e+03 -3.853908e+02 2.878733e-02
      11892   466_548776 1993       maxN 3.106000e+03 -3.055210e+02 2.583434e-02
      11893   466_548776 1993    Shannon 6.295258e-01  5.878286e-03 7.926370e-01
      11894   466_548776 1993    Simpson 2.848884e-01  4.947798e-03 7.447388e-01
      11895   466_548776 1993 invSimpson 1.398383e+00  2.094599e-02 6.812120e-01
      11896   466_548776 1993        PIE 2.849654e-01  4.978049e-03 7.434690e-01
      11897   466_548776 1993      DomMc 9.289189e-01  7.370133e-04 8.048638e-01
      11898   466_548776 1993 expShannon 1.876720e+00  1.595308e-02 7.550000e-01
      11899   466_550232 1999          S 9.000000e+00 -1.137184e-01 1.280102e-01
      11900   466_550232 1999          N 1.407000e+03 -2.844465e+01 7.969743e-01
      11901   466_550232 1999       maxN 5.360000e+02 -1.070999e+01 9.261156e-01
      11902   466_550232 1999    Shannon 1.558746e+00 -1.416745e-03 9.538290e-01
      11903   466_550232 1999    Simpson 7.467900e-01 -2.844094e-03 8.258279e-01
      11904   466_550232 1999 invSimpson 3.949290e+00  3.388967e-03 9.465212e-01
      11905   466_550232 1999        PIE 7.473211e-01 -2.838190e-03 8.263272e-01
      11906   466_550232 1999      DomMc 6.304193e-01 -1.774568e-03 7.662488e-01
      11907   466_550232 1999 expShannon 4.752856e+00  7.463047e-03 9.038133e-01
      11908   466_550232 2005          S 1.200000e+01 -1.137184e-01 1.280102e-01
      11909   466_550232 2005          N 1.198000e+03 -2.844465e+01 7.969743e-01
      11910   466_550232 2005       maxN 5.210000e+02 -1.070999e+01 9.261156e-01
      11911   466_550232 2005    Shannon 1.449882e+00 -1.416745e-03 9.538290e-01
      11912   466_550232 2005    Simpson 7.100120e-01 -2.844094e-03 8.258279e-01
      11913   466_550232 2005 invSimpson 3.448418e+00  3.388967e-03 9.465212e-01
      11914   466_550232 2005        PIE 7.106051e-01 -2.838190e-03 8.263272e-01
      11915   466_550232 2005      DomMc 6.869783e-01 -1.774568e-03 7.662488e-01
      11916   466_550232 2005 expShannon 4.262613e+00  7.463047e-03 9.038133e-01
      11917   466_550232 2007          S 1.100000e+01 -1.137184e-01 1.280102e-01
      11918   466_550232 2007          N 7.642000e+03 -2.844465e+01 7.969743e-01
      11919   466_550232 2007       maxN 7.278000e+03 -1.070999e+01 9.261156e-01
      11920   466_550232 2007    Shannon 2.577700e-01 -1.416745e-03 9.538290e-01
      11921   466_550232 2007    Simpson 9.229464e-02 -2.844094e-03 8.258279e-01
      11922   466_550232 2007 invSimpson 1.101679e+00  3.388967e-03 9.465212e-01
      11923   466_550232 2007        PIE 9.230672e-02 -2.838190e-03 8.263272e-01
      11924   466_550232 2007      DomMc 9.733054e-01 -1.774568e-03 7.662488e-01
      11925   466_550232 2007 expShannon 1.294041e+00  7.463047e-03 9.038133e-01
      11926   466_550232 2008          S 1.000000e+01 -1.137184e-01 1.280102e-01
      11927   466_550232 2008          N 9.310000e+02 -2.844465e+01 7.969743e-01
      11928   466_550232 2008       maxN 8.760000e+02 -1.070999e+01 9.261156e-01
      11929   466_550232 2008    Shannon 3.143855e-01 -1.416745e-03 9.538290e-01
      11930   466_550232 2008    Simpson 1.135630e-01 -2.844094e-03 8.258279e-01
      11931   466_550232 2008 invSimpson 1.128112e+00  3.388967e-03 9.465212e-01
      11932   466_550232 2008        PIE 1.136851e-01 -2.838190e-03 8.263272e-01
      11933   466_550232 2008      DomMc 9.709989e-01 -1.774568e-03 7.662488e-01
      11934   466_550232 2008 expShannon 1.369418e+00  7.463047e-03 9.038133e-01
      11935   466_550232 1991          S 1.200000e+01 -1.137184e-01 1.280102e-01
      11936   466_550232 1991          N 1.731000e+03 -2.844465e+01 7.969743e-01
      11937   466_550232 1991       maxN 7.450000e+02 -1.070999e+01 9.261156e-01
      11938   466_550232 1991    Shannon 1.187412e+00 -1.416745e-03 9.538290e-01
      11939   466_550232 1991    Simpson 6.495953e-01 -2.844094e-03 8.258279e-01
      11940   466_550232 1991 invSimpson 2.853843e+00  3.388967e-03 9.465212e-01
      11941   466_550232 1991        PIE 6.499708e-01 -2.838190e-03 8.263272e-01
      11942   466_550232 1991      DomMc 7.972270e-01 -1.774568e-03 7.662488e-01
      11943   466_550232 1991 expShannon 3.278585e+00  7.463047e-03 9.038133e-01
      11944   466_550232 1986          S 1.200000e+01 -1.137184e-01 1.280102e-01
      11945   466_550232 1986          N 2.630000e+03 -2.844465e+01 7.969743e-01
      11946   466_550232 1986       maxN 1.825000e+03 -1.070999e+01 9.261156e-01
      11947   466_550232 1986    Shannon 8.906368e-01 -1.416745e-03 9.538290e-01
      11948   466_550232 1986    Simpson 4.635733e-01 -2.844094e-03 8.258279e-01
      11949   466_550232 1986 invSimpson 1.864188e+00  3.388967e-03 9.465212e-01
      11950   466_550232 1986        PIE 4.637496e-01 -2.838190e-03 8.263272e-01
      11951   466_550232 1986      DomMc 9.231939e-01 -1.774568e-03 7.662488e-01
      11952   466_550232 1986 expShannon 2.436681e+00  7.463047e-03 9.038133e-01
      11953   466_550232 1988          S 1.300000e+01 -1.137184e-01 1.280102e-01
      11954   466_550232 1988          N 5.374000e+03 -2.844465e+01 7.969743e-01
      11955   466_550232 1988       maxN 5.054000e+03 -1.070999e+01 9.261156e-01
      11956   466_550232 1988    Shannon 3.051506e-01 -1.416745e-03 9.538290e-01
      11957   466_550232 1988    Simpson 1.142997e-01 -2.844094e-03 8.258279e-01
      11958   466_550232 1988 invSimpson 1.129050e+00  3.388967e-03 9.465212e-01
      11959   466_550232 1988        PIE 1.143210e-01 -2.838190e-03 8.263272e-01
      11960   466_550232 1988      DomMc 9.652028e-01 -1.774568e-03 7.662488e-01
      11961   466_550232 1988 expShannon 1.356829e+00  7.463047e-03 9.038133e-01
      11962   466_550232 2001          S 9.000000e+00 -1.137184e-01 1.280102e-01
      11963   466_550232 2001          N 1.039000e+03 -2.844465e+01 7.969743e-01
      11964   466_550232 2001       maxN 4.670000e+02 -1.070999e+01 9.261156e-01
      11965   466_550232 2001    Shannon 1.333527e+00 -1.416745e-03 9.538290e-01
      11966   466_550232 2001    Simpson 6.671737e-01 -2.844094e-03 8.258279e-01
      11967   466_550232 2001 invSimpson 3.004570e+00  3.388967e-03 9.465212e-01
      11968   466_550232 2001        PIE 6.678164e-01 -2.838190e-03 8.263272e-01
      11969   466_550232 2001      DomMc 7.921078e-01 -1.774568e-03 7.662488e-01
      11970   466_550232 2001 expShannon 3.794402e+00  7.463047e-03 9.038133e-01
      11971   466_550232 2003          S 8.000000e+00 -1.137184e-01 1.280102e-01
      11972   466_550232 2003          N 1.222000e+03 -2.844465e+01 7.969743e-01
      11973   466_550232 2003       maxN 7.870000e+02 -1.070999e+01 9.261156e-01
      11974   466_550232 2003    Shannon 1.144355e+00 -1.416745e-03 9.538290e-01
      11975   466_550232 2003    Simpson 5.456015e-01 -2.844094e-03 8.258279e-01
      11976   466_550232 2003 invSimpson 2.200712e+00  3.388967e-03 9.465212e-01
      11977   466_550232 2003        PIE 5.460484e-01 -2.838190e-03 8.263272e-01
      11978   466_550232 2003      DomMc 8.158756e-01 -1.774568e-03 7.662488e-01
      11979   466_550232 2003 expShannon 3.140416e+00  7.463047e-03 9.038133e-01
      11980   466_558968 1999          S 1.100000e+01  1.565404e-01 3.548559e-01
      11981   466_558968 1999          N 5.423000e+03 -5.611001e+02 1.047277e-02
      11982   466_558968 1999       maxN 4.002000e+03 -3.881687e+02 6.929818e-03
      11983   466_558968 1999    Shannon 8.658808e-01 -4.777878e-03 8.058083e-01
      11984   466_558968 1999    Simpson 4.288453e-01 -4.452731e-04 9.711224e-01
      11985   466_558968 1999 invSimpson 1.750839e+00  8.312305e-03 8.451925e-01
      11986   466_558968 1999        PIE 4.289244e-01 -4.291797e-04 9.721816e-01
      11987   466_558968 1999      DomMc 8.574590e-01  5.744839e-03 1.978958e-01
      11988   466_558968 1999 expShannon 2.377099e+00 -6.315562e-03 8.862304e-01
      11989   466_558968 1993          S 1.000000e+01  1.565404e-01 3.548559e-01
      11990   466_558968 1993          N 1.152700e+04 -5.611001e+02 1.047277e-02
      11991   466_558968 1993       maxN 7.420000e+03 -3.881687e+02 6.929818e-03
      11992   466_558968 1993    Shannon 9.979438e-01 -4.777878e-03 8.058083e-01
      11993   466_558968 1993    Simpson 5.284058e-01 -4.452731e-04 9.711224e-01
      11994   466_558968 1993 invSimpson 2.120467e+00  8.312305e-03 8.451925e-01
      11995   466_558968 1993        PIE 5.284516e-01 -4.291797e-04 9.721816e-01
      11996   466_558968 1993      DomMc 8.488766e-01  5.744839e-03 1.978958e-01
      11997   466_558968 1993 expShannon 2.712698e+00 -6.315562e-03 8.862304e-01
      11998   466_558968 1995          S 1.000000e+01  1.565404e-01 3.548559e-01
      11999   466_558968 1995          N 6.054000e+03 -5.611001e+02 1.047277e-02
      12000   466_558968 1995       maxN 4.577000e+03 -3.881687e+02 6.929818e-03
      12001   466_558968 1995    Shannon 9.073825e-01 -4.777878e-03 8.058083e-01
      12002   466_558968 1995    Simpson 4.125537e-01 -4.452731e-04 9.711224e-01
      12003   466_558968 1995 invSimpson 1.702283e+00  8.312305e-03 8.451925e-01
      12004   466_558968 1995        PIE 4.126219e-01 -4.291797e-04 9.721816e-01
      12005   466_558968 1995      DomMc 8.425834e-01  5.744839e-03 1.978958e-01
      12006   466_558968 1995 expShannon 2.477828e+00 -6.315562e-03 8.862304e-01
      12007   466_558968 1996          S 1.000000e+01  1.565404e-01 3.548559e-01
      12008   466_558968 1996          N 4.441000e+03 -5.611001e+02 1.047277e-02
      12009   466_558968 1996       maxN 3.209000e+03 -3.881687e+02 6.929818e-03
      12010   466_558968 1996    Shannon 8.561608e-01 -4.777878e-03 8.058083e-01
      12011   466_558968 1996    Simpson 4.397018e-01 -4.452731e-04 9.711224e-01
      12012   466_558968 1996 invSimpson 1.784764e+00  8.312305e-03 8.451925e-01
      12013   466_558968 1996        PIE 4.398008e-01 -4.291797e-04 9.721816e-01
      12014   466_558968 1996      DomMc 9.034001e-01  5.744839e-03 1.978958e-01
      12015   466_558968 1996 expShannon 2.354105e+00 -6.315562e-03 8.862304e-01
      12016   466_558968 2007          S 1.500000e+01  1.565404e-01 3.548559e-01
      12017   466_558968 2007          N 1.856000e+03 -5.611001e+02 1.047277e-02
      12018   466_558968 2007       maxN 1.050000e+03 -3.881687e+02 6.929818e-03
      12019   466_558968 2007    Shannon 9.950726e-01 -4.777878e-03 8.058083e-01
      12020   466_558968 2007    Simpson 5.473882e-01 -4.452731e-04 9.711224e-01
      12021   466_558968 2007 invSimpson 2.209399e+00  8.312305e-03 8.451925e-01
      12022   466_558968 2007        PIE 5.476833e-01 -4.291797e-04 9.721816e-01
      12023   466_558968 2007      DomMc 9.272629e-01  5.744839e-03 1.978958e-01
      12024   466_558968 2007 expShannon 2.704921e+00 -6.315562e-03 8.862304e-01
      12025   466_558968 2003          S 8.000000e+00  1.565404e-01 3.548559e-01
      12026   466_558968 2003          N 1.837000e+03 -5.611001e+02 1.047277e-02
      12027   466_558968 2003       maxN 1.681000e+03 -3.881687e+02 6.929818e-03
      12028   466_558968 2003    Shannon 4.057387e-01 -4.777878e-03 8.058083e-01
      12029   466_558968 2003    Simpson 1.599464e-01 -4.452731e-04 9.711224e-01
      12030   466_558968 2003 invSimpson 1.190400e+00  8.312305e-03 8.451925e-01
      12031   466_558968 2003        PIE 1.600335e-01 -4.291797e-04 9.721816e-01
      12032   466_558968 2003      DomMc 9.635275e-01  5.744839e-03 1.978958e-01
      12033   466_558968 2003 expShannon 1.500410e+00 -6.315562e-03 8.862304e-01
      12034   466_558968 2005          S 1.000000e+01  1.565404e-01 3.548559e-01
      12035   466_558968 2005          N 2.297000e+03 -5.611001e+02 1.047277e-02
      12036   466_558968 2005       maxN 1.537000e+03 -3.881687e+02 6.929818e-03
      12037   466_558968 2005    Shannon 9.363828e-01 -4.777878e-03 8.058083e-01
      12038   466_558968 2005    Simpson 4.886956e-01 -4.452731e-04 9.711224e-01
      12039   466_558968 2005 invSimpson 1.955782e+00  8.312305e-03 8.451925e-01
      12040   466_558968 2005        PIE 4.889084e-01 -4.291797e-04 9.721816e-01
      12041   466_558968 2005      DomMc 9.159774e-01  5.744839e-03 1.978958e-01
      12042   466_558968 2005 expShannon 2.550738e+00 -6.315562e-03 8.862304e-01
      12043   466_558968 2001          S 9.000000e+00  1.565404e-01 3.548559e-01
      12044   466_558968 2001          N 1.650000e+03 -5.611001e+02 1.047277e-02
      12045   466_558968 2001       maxN 6.840000e+02 -3.881687e+02 6.929818e-03
      12046   466_558968 2001    Shannon 1.215380e+00 -4.777878e-03 8.058083e-01
      12047   466_558968 2001    Simpson 6.583713e-01 -4.452731e-04 9.711224e-01
      12048   466_558968 2001 invSimpson 2.927155e+00  8.312305e-03 8.451925e-01
      12049   466_558968 2001        PIE 6.587706e-01 -4.291797e-04 9.721816e-01
      12050   466_558968 2001      DomMc 7.884848e-01  5.744839e-03 1.978958e-01
      12051   466_558968 2001 expShannon 3.371575e+00 -6.315562e-03 8.862304e-01
      12052   466_559696 2001          S 1.200000e+01  3.138801e-01 5.696903e-03
      12053   466_559696 2001          N 8.780000e+02 -1.567156e+02 1.172901e-01
      12054   466_559696 2001       maxN 5.690000e+02 -1.373270e+02 1.167691e-01
      12055   466_559696 2001    Shannon 1.124120e+00  3.396533e-03 8.489142e-01
      12056   466_559696 2001    Simpson 5.363842e-01  4.969915e-04 9.590666e-01
      12057   466_559696 2001 invSimpson 2.156958e+00  1.696031e-03 9.427929e-01
      12058   466_559696 2001        PIE 5.369958e-01  5.075741e-04 9.582211e-01
      12059   466_559696 2001      DomMc 8.291572e-01 -3.608193e-04 9.241981e-01
      12060   466_559696 2001 expShannon 3.077507e+00  5.155152e-03 8.900218e-01
      12061   466_559696 2008          S 1.400000e+01  3.138801e-01 5.696903e-03
      12062   466_559696 2008          N 4.730000e+02 -1.567156e+02 1.172901e-01
      12063   466_559696 2008       maxN 4.480000e+02 -1.373270e+02 1.167691e-01
      12064   466_559696 2008    Shannon 3.335749e-01  3.396533e-03 8.489142e-01
      12065   466_559696 2008    Simpson 1.026152e-01  4.969915e-04 9.590666e-01
      12066   466_559696 2008 invSimpson 1.114349e+00  1.696031e-03 9.427929e-01
      12067   466_559696 2008        PIE 1.028326e-01  5.075741e-04 9.582211e-01
      12068   466_559696 2008      DomMc 9.577167e-01 -3.608193e-04 9.241981e-01
      12069   466_559696 2008 expShannon 1.395950e+00  5.155152e-03 8.900218e-01
      12070   466_559696 2007          S 1.300000e+01  3.138801e-01 5.696903e-03
      12071   466_559696 2007          N 9.780000e+02 -1.567156e+02 1.172901e-01
      12072   466_559696 2007       maxN 8.860000e+02 -1.373270e+02 1.167691e-01
      12073   466_559696 2007    Shannon 4.715036e-01  3.396533e-03 8.489142e-01
      12074   466_559696 2007    Simpson 1.765152e-01  4.969915e-04 9.590666e-01
      12075   466_559696 2007 invSimpson 1.214352e+00  1.696031e-03 9.427929e-01
      12076   466_559696 2007        PIE 1.766959e-01  5.075741e-04 9.582211e-01
      12077   466_559696 2007      DomMc 9.560327e-01 -3.608193e-04 9.241981e-01
      12078   466_559696 2007 expShannon 1.602402e+00  5.155152e-03 8.900218e-01
      12079   466_559696 2003          S 1.000000e+01  3.138801e-01 5.696903e-03
      12080   466_559696 2003          N 2.660000e+03 -1.567156e+02 1.172901e-01
      12081   466_559696 2003       maxN 2.019000e+03 -1.373270e+02 1.167691e-01
      12082   466_559696 2003    Shannon 7.290006e-01  3.396533e-03 8.489142e-01
      12083   466_559696 2003    Simpson 3.864043e-01  4.969915e-04 9.590666e-01
      12084   466_559696 2003 invSimpson 1.629738e+00  1.696031e-03 9.427929e-01
      12085   466_559696 2003        PIE 3.865496e-01  5.075741e-04 9.582211e-01
      12086   466_559696 2003      DomMc 9.492481e-01 -3.608193e-04 9.241981e-01
      12087   466_559696 2003 expShannon 2.073008e+00  5.155152e-03 8.900218e-01
      12088   466_559696 1988          S 8.000000e+00  3.138801e-01 5.696903e-03
      12089   466_559696 1988          N 1.741000e+03 -1.567156e+02 1.172901e-01
      12090   466_559696 1988       maxN 1.667000e+03 -1.373270e+02 1.167691e-01
      12091   466_559696 1988    Shannon 2.381886e-01  3.396533e-03 8.489142e-01
      12092   466_559696 1988    Simpson 8.262003e-02  4.969915e-04 9.590666e-01
      12093   466_559696 1988 invSimpson 1.090061e+00  1.696031e-03 9.427929e-01
      12094   466_559696 1988        PIE 8.266751e-02  5.075741e-04 9.582211e-01
      12095   466_559696 1988      DomMc 9.793222e-01 -3.608193e-04 9.241981e-01
      12096   466_559696 1988 expShannon 1.268949e+00  5.155152e-03 8.900218e-01
      12097   466_559696 1992          S 6.000000e+00  3.138801e-01 5.696903e-03
      12098   466_559696 1992          N 6.319000e+03 -1.567156e+02 1.172901e-01
      12099   466_559696 1992       maxN 5.253000e+03 -1.373270e+02 1.167691e-01
      12100   466_559696 1992    Shannon 4.982097e-01  3.396533e-03 8.489142e-01
      12101   466_559696 1992    Simpson 2.834975e-01  4.969915e-04 9.590666e-01
      12102   466_559696 1992 invSimpson 1.395668e+00  1.696031e-03 9.427929e-01
      12103   466_559696 1992        PIE 2.835423e-01  5.075741e-04 9.582211e-01
      12104   466_559696 1992      DomMc 9.906631e-01 -3.608193e-04 9.241981e-01
      12105   466_559696 1992 expShannon 1.645772e+00  5.155152e-03 8.900218e-01
      12106   466_559696 1993          S 1.000000e+01  3.138801e-01 5.696903e-03
      12107   466_559696 1993          N 2.741000e+03 -1.567156e+02 1.172901e-01
      12108   466_559696 1993       maxN 2.195000e+03 -1.373270e+02 1.167691e-01
      12109   466_559696 1993    Shannon 8.350251e-01  3.396533e-03 8.489142e-01
      12110   466_559696 1993    Simpson 3.495514e-01  4.969915e-04 9.590666e-01
      12111   466_559696 1993 invSimpson 1.537401e+00  1.696031e-03 9.427929e-01
      12112   466_559696 1993        PIE 3.496790e-01  5.075741e-04 9.582211e-01
      12113   466_559696 1993      DomMc 8.693907e-01 -3.608193e-04 9.241981e-01
      12114   466_559696 1993 expShannon 2.304872e+00  5.155152e-03 8.900218e-01
      12115   466_559696 1996          S 1.000000e+01  3.138801e-01 5.696903e-03
      12116   466_559696 1996          N 5.423000e+03 -1.567156e+02 1.172901e-01
      12117   466_559696 1996       maxN 4.958000e+03 -1.373270e+02 1.167691e-01
      12118   466_559696 1996    Shannon 4.057478e-01  3.396533e-03 8.489142e-01
      12119   466_559696 1996    Simpson 1.616200e-01  4.969915e-04 9.590666e-01
      12120   466_559696 1996 invSimpson 1.192777e+00  1.696031e-03 9.427929e-01
      12121   466_559696 1996        PIE 1.616498e-01  5.075741e-04 9.582211e-01
      12122   466_559696 1996      DomMc 9.581413e-01 -3.608193e-04 9.241981e-01
      12123   466_559696 1996 expShannon 1.500424e+00  5.155152e-03 8.900218e-01
      12124   466_559696 1997          S 7.000000e+00  3.138801e-01 5.696903e-03
      12125   466_559696 1997          N 1.928000e+03 -1.567156e+02 1.172901e-01
      12126   466_559696 1997       maxN 1.205000e+03 -1.373270e+02 1.167691e-01
      12127   466_559696 1997    Shannon 1.132627e+00  3.396533e-03 8.489142e-01
      12128   466_559696 1997    Simpson 5.616440e-01  4.969915e-04 9.590666e-01
      12129   466_559696 1997 invSimpson 2.281251e+00  1.696031e-03 9.427929e-01
      12130   466_559696 1997        PIE 5.619354e-01  5.075741e-04 9.582211e-01
      12131   466_559696 1997      DomMc 7.904564e-01 -3.608193e-04 9.241981e-01
      12132   466_559696 1997 expShannon 3.103800e+00  5.155152e-03 8.900218e-01
      12133   466_559696 1999          S 9.000000e+00  3.138801e-01 5.696903e-03
      12134   466_559696 1999          N 3.298000e+03 -1.567156e+02 1.172901e-01
      12135   466_559696 1999       maxN 2.448000e+03 -1.373270e+02 1.167691e-01
      12136   466_559696 1999    Shannon 8.216491e-01  3.396533e-03 8.489142e-01
      12137   466_559696 1999    Simpson 4.154320e-01  4.969915e-04 9.590666e-01
      12138   466_559696 1999 invSimpson 1.710665e+00  1.696031e-03 9.427929e-01
      12139   466_559696 1999        PIE 4.155580e-01  5.075741e-04 9.582211e-01
      12140   466_559696 1999      DomMc 9.175258e-01 -3.608193e-04 9.241981e-01
      12141   466_559696 1999 expShannon 2.274247e+00  5.155152e-03 8.900218e-01
      12142   466_551690 1999          S 1.000000e+01  1.381866e-01 2.957542e-01
      12143   466_551690 1999          N 1.494000e+03 -7.649564e+01 5.275307e-01
      12144   466_551690 1999       maxN 5.320000e+02 -6.972711e+01 5.592946e-01
      12145   466_551690 1999    Shannon 1.449282e+00  2.709988e-02 3.165230e-01
      12146   466_551690 1999    Simpson 7.325357e-01  1.280077e-02 3.725725e-01
      12147   466_551690 1999 invSimpson 3.738816e+00  1.693171e-02 7.643941e-01
      12148   466_551690 1999        PIE 7.330263e-01  1.283984e-02 3.715891e-01
      12149   466_551690 1999      DomMc 6.291834e-01 -2.850740e-03 6.996103e-01
      12150   466_551690 1999 expShannon 4.260055e+00  4.549827e-02 4.823325e-01
      12151   466_551690 2003          S 1.200000e+01  1.381866e-01 2.957542e-01
      12152   466_551690 2003          N 1.312000e+03 -7.649564e+01 5.275307e-01
      12153   466_551690 2003       maxN 8.370000e+02 -6.972711e+01 5.592946e-01
      12154   466_551690 2003    Shannon 1.114780e+00  2.709988e-02 3.165230e-01
      12155   466_551690 2003    Simpson 5.443595e-01  1.280077e-02 3.725725e-01
      12156   466_551690 2003 invSimpson 2.194713e+00  1.693171e-02 7.643941e-01
      12157   466_551690 2003        PIE 5.447747e-01  1.283984e-02 3.715891e-01
      12158   466_551690 2003      DomMc 8.208841e-01 -2.850740e-03 6.996103e-01
      12159   466_551690 2003 expShannon 3.048896e+00  4.549827e-02 4.823325e-01
      12160   466_551690 1996          S 1.000000e+01  1.381866e-01 2.957542e-01
      12161   466_551690 1996          N 3.625000e+03 -7.649564e+01 5.275307e-01
      12162   466_551690 1996       maxN 2.766000e+03 -6.972711e+01 5.592946e-01
      12163   466_551690 1996    Shannon 8.479132e-01  2.709988e-02 3.165230e-01
      12164   466_551690 1996    Simpson 3.980359e-01  1.280077e-02 3.725725e-01
      12165   466_551690 1996 invSimpson 1.661229e+00  1.693171e-02 7.643941e-01
      12166   466_551690 1996        PIE 3.981457e-01  1.283984e-02 3.715891e-01
      12167   466_551690 1996      DomMc 8.706207e-01 -2.850740e-03 6.996103e-01
      12168   466_551690 1996 expShannon 2.334770e+00  4.549827e-02 4.823325e-01
      12169   466_551690 2006          S 1.300000e+01  1.381866e-01 2.957542e-01
      12170   466_551690 2006          N 1.179000e+03 -7.649564e+01 5.275307e-01
      12171   466_551690 2006       maxN 8.590000e+02 -6.972711e+01 5.592946e-01
      12172   466_551690 2006    Shannon 9.696644e-01  2.709988e-02 3.165230e-01
      12173   466_551690 2006    Simpson 4.473206e-01  1.280077e-02 3.725725e-01
      12174   466_551690 2006 invSimpson 1.809367e+00  1.693171e-02 7.643941e-01
      12175   466_551690 2006        PIE 4.477003e-01  1.283984e-02 3.715891e-01
      12176   466_551690 2006      DomMc 8.354538e-01 -2.850740e-03 6.996103e-01
      12177   466_551690 2006 expShannon 2.637059e+00  4.549827e-02 4.823325e-01
      12178   466_551690 2005          S 1.300000e+01  1.381866e-01 2.957542e-01
      12179   466_551690 2005          N 6.202000e+03 -7.649564e+01 5.275307e-01
      12180   466_551690 2005       maxN 5.763000e+03 -6.972711e+01 5.592946e-01
      12181   466_551690 2005    Shannon 3.243268e-01  2.709988e-02 3.165230e-01
      12182   466_551690 2005    Simpson 1.337805e-01  1.280077e-02 3.725725e-01
      12183   466_551690 2005 invSimpson 1.154442e+00  1.693171e-02 7.643941e-01
      12184   466_551690 2005        PIE 1.338021e-01  1.283984e-02 3.715891e-01
      12185   466_551690 2005      DomMc 9.806514e-01 -2.850740e-03 6.996103e-01
      12186   466_551690 2005 expShannon 1.383099e+00  4.549827e-02 4.823325e-01
      12187   466_551690 2007          S 9.000000e+00  1.381866e-01 2.957542e-01
      12188   466_551690 2007          N 3.470000e+02 -7.649564e+01 5.275307e-01
      12189   466_551690 2007       maxN 2.410000e+02 -6.972711e+01 5.592946e-01
      12190   466_551690 2007    Shannon 1.025013e+00  2.709988e-02 3.165230e-01
      12191   466_551690 2007    Simpson 4.811268e-01  1.280077e-02 3.725725e-01
      12192   466_551690 2007 invSimpson 1.927253e+00  1.693171e-02 7.643941e-01
      12193   466_551690 2007        PIE 4.825174e-01  1.283984e-02 3.715891e-01
      12194   466_551690 2007      DomMc 8.760807e-01 -2.850740e-03 6.996103e-01
      12195   466_551690 2007 expShannon 2.787131e+00  4.549827e-02 4.823325e-01
      12196   466_551690 1989          S 9.000000e+00  1.381866e-01 2.957542e-01
      12197   466_551690 1989          N 3.130000e+03 -7.649564e+01 5.275307e-01
      12198   466_551690 1989       maxN 3.039000e+03 -6.972711e+01 5.592946e-01
      12199   466_551690 1989    Shannon 1.652768e-01  2.709988e-02 3.165230e-01
      12200   466_551690 1989    Simpson 5.693127e-02  1.280077e-02 3.725725e-01
      12201   466_551690 1989 invSimpson 1.060368e+00  1.693171e-02 7.643941e-01
      12202   466_551690 1989        PIE 5.694947e-02  1.283984e-02 3.715891e-01
      12203   466_551690 1989      DomMc 9.888179e-01 -2.850740e-03 6.996103e-01
      12204   466_551690 1989 expShannon 1.179720e+00  4.549827e-02 4.823325e-01
      12205   466_551690 2001          S 8.000000e+00  1.381866e-01 2.957542e-01
      12206   466_551690 2001          N 2.366000e+03 -7.649564e+01 5.275307e-01
      12207   466_551690 2001       maxN 2.084000e+03 -6.972711e+01 5.592946e-01
      12208   466_551690 2001    Shannon 5.269504e-01  2.709988e-02 3.165230e-01
      12209   466_551690 2001    Simpson 2.200082e-01  1.280077e-02 3.725725e-01
      12210   466_551690 2001 invSimpson 1.282065e+00  1.693171e-02 7.643941e-01
      12211   466_551690 2001        PIE 2.201012e-01  1.283984e-02 3.715891e-01
      12212   466_551690 2001      DomMc 9.298394e-01 -2.850740e-03 6.996103e-01
      12213   466_551690 2001 expShannon 1.693759e+00  4.549827e-02 4.823325e-01
      12214   466_551690 2002          S 8.000000e+00  1.381866e-01 2.957542e-01
      12215   466_551690 2002          N 1.424000e+03 -7.649564e+01 5.275307e-01
      12216   466_551690 2002       maxN 1.198000e+03 -6.972711e+01 5.592946e-01
      12217   466_551690 2002    Shannon 7.109596e-01  2.709988e-02 3.165230e-01
      12218   466_551690 2002    Simpson 2.871856e-01  1.280077e-02 3.725725e-01
      12219   466_551690 2002 invSimpson 1.402890e+00  1.693171e-02 7.643941e-01
      12220   466_551690 2002        PIE 2.873874e-01  1.283984e-02 3.715891e-01
      12221   466_551690 2002      DomMc 8.841292e-01 -2.850740e-03 6.996103e-01
      12222   466_551690 2002 expShannon 2.035944e+00  4.549827e-02 4.823325e-01
      12223   466_553145 2002          S 1.300000e+01  2.316637e-01 1.287827e-02
      12224   466_553145 2002          N 3.330000e+03 -1.650242e+02 2.075952e-01
      12225   466_553145 2002       maxN 2.502000e+03 -1.761091e+02 1.521750e-01
      12226   466_553145 2002    Shannon 8.243653e-01  3.506903e-02 8.100959e-04
      12227   466_553145 2002    Simpson 4.022154e-01  1.658846e-02 2.086586e-03
      12228   466_553145 2002 invSimpson 1.672843e+00  3.648174e-02 6.946606e-04
      12229   466_553145 2002        PIE 4.023362e-01  1.660717e-02 2.077571e-03
      12230   466_553145 2002      DomMc 9.303303e-01 -6.575809e-03 1.328130e-03
      12231   466_553145 2002 expShannon 2.280433e+00  7.141459e-02 3.461203e-04
      12232   466_553145 2003          S 1.400000e+01  2.316637e-01 1.287827e-02
      12233   466_553145 2003          N 3.047000e+03 -1.650242e+02 2.075952e-01
      12234   466_553145 2003       maxN 2.350000e+03 -1.761091e+02 1.521750e-01
      12235   466_553145 2003    Shannon 8.566783e-01  3.506903e-02 8.100959e-04
      12236   466_553145 2003    Simpson 3.839485e-01  1.658846e-02 2.086586e-03
      12237   466_553145 2003 invSimpson 1.623241e+00  3.648174e-02 6.946606e-04
      12238   466_553145 2003        PIE 3.840745e-01  1.660717e-02 2.077571e-03
      12239   466_553145 2003      DomMc 9.110601e-01 -6.575809e-03 1.328130e-03
      12240   466_553145 2003 expShannon 2.355324e+00  7.141459e-02 3.461203e-04
      12241   466_553145 2008          S 1.400000e+01  2.316637e-01 1.287827e-02
      12242   466_553145 2008          N 6.810000e+02 -1.650242e+02 2.075952e-01
      12243   466_553145 2008       maxN 4.540000e+02 -1.761091e+02 1.521750e-01
      12244   466_553145 2008    Shannon 1.196275e+00  3.506903e-02 8.100959e-04
      12245   466_553145 2008    Simpson 5.281902e-01  1.658846e-02 2.086586e-03
      12246   466_553145 2008 invSimpson 2.119498e+00  3.648174e-02 6.946606e-04
      12247   466_553145 2008        PIE 5.289669e-01  1.660717e-02 2.077571e-03
      12248   466_553145 2008      DomMc 7.885463e-01 -6.575809e-03 1.328130e-03
      12249   466_553145 2008 expShannon 3.307772e+00  7.141459e-02 3.461203e-04
      12250   466_553145 1991          S 1.100000e+01  2.316637e-01 1.287827e-02
      12251   466_553145 1991          N 3.352000e+03 -1.650242e+02 2.075952e-01
      12252   466_553145 1991       maxN 3.176000e+03 -1.761091e+02 1.521750e-01
      12253   466_553145 1991    Shannon 2.905113e-01  3.506903e-02 8.100959e-04
      12254   466_553145 1991    Simpson 1.015261e-01  1.658846e-02 2.086586e-03
      12255   466_553145 1991 invSimpson 1.112998e+00  3.648174e-02 6.946606e-04
      12256   466_553145 1991        PIE 1.015564e-01  1.660717e-02 2.077571e-03
      12257   466_553145 1991      DomMc 9.695704e-01 -6.575809e-03 1.328130e-03
      12258   466_553145 1991 expShannon 1.337111e+00  7.141459e-02 3.461203e-04
      12259   466_553145 1997          S 1.000000e+01  2.316637e-01 1.287827e-02
      12260   466_553145 1997          N 4.403000e+03 -1.650242e+02 2.075952e-01
      12261   466_553145 1997       maxN 3.298000e+03 -1.761091e+02 1.521750e-01
      12262   466_553145 1997    Shannon 8.065725e-01  3.506903e-02 8.100959e-04
      12263   466_553145 1997    Simpson 4.110666e-01  1.658846e-02 2.086586e-03
      12264   466_553145 1997 invSimpson 1.697985e+00  3.648174e-02 6.946606e-04
      12265   466_553145 1997        PIE 4.111600e-01  1.660717e-02 2.077571e-03
      12266   466_553145 1997      DomMc 8.757665e-01 -6.575809e-03 1.328130e-03
      12267   466_553145 1997 expShannon 2.240216e+00  7.141459e-02 3.461203e-04
      12268   466_553145 1993          S 1.000000e+01  2.316637e-01 1.287827e-02
      12269   466_553145 1993          N 4.543000e+03 -1.650242e+02 2.075952e-01
      12270   466_553145 1993       maxN 3.919000e+03 -1.761091e+02 1.521750e-01
      12271   466_553145 1993    Shannon 5.499847e-01  3.506903e-02 8.100959e-04
      12272   466_553145 1993    Simpson 2.478161e-01  1.658846e-02 2.086586e-03
      12273   466_553145 1993 invSimpson 1.329462e+00  3.648174e-02 6.946606e-04
      12274   466_553145 1993        PIE 2.478707e-01  1.660717e-02 2.077571e-03
      12275   466_553145 1993      DomMc 9.370460e-01 -6.575809e-03 1.328130e-03
      12276   466_553145 1993 expShannon 1.733227e+00  7.141459e-02 3.461203e-04
      12277   466_553145 1996          S 1.100000e+01  2.316637e-01 1.287827e-02
      12278   466_553145 1996          N 4.536000e+03 -1.650242e+02 2.075952e-01
      12279   466_553145 1996       maxN 3.776000e+03 -1.761091e+02 1.521750e-01
      12280   466_553145 1996    Shannon 6.310412e-01  3.506903e-02 8.100959e-04
      12281   466_553145 1996    Simpson 2.939861e-01  1.658846e-02 2.086586e-03
      12282   466_553145 1996 invSimpson 1.416403e+00  3.648174e-02 6.946606e-04
      12283   466_553145 1996        PIE 2.940510e-01  1.660717e-02 2.077571e-03
      12284   466_553145 1996      DomMc 9.391534e-01 -6.575809e-03 1.328130e-03
      12285   466_553145 1996 expShannon 1.879567e+00  7.141459e-02 3.461203e-04
      12286   466_553145 1994          S 1.200000e+01  2.316637e-01 1.287827e-02
      12287   466_553145 1994          N 1.072300e+04 -1.650242e+02 2.075952e-01
      12288   466_553145 1994       maxN 9.547000e+03 -1.761091e+02 1.521750e-01
      12289   466_553145 1994    Shannon 4.504938e-01  3.506903e-02 8.100959e-04
      12290   466_553145 1994    Simpson 2.003940e-01  1.658846e-02 2.086586e-03
      12291   466_553145 1994 invSimpson 1.250616e+00  3.648174e-02 6.946606e-04
      12292   466_553145 1994        PIE 2.004127e-01  1.660717e-02 2.077571e-03
      12293   466_553145 1994      DomMc 9.723025e-01 -6.575809e-03 1.328130e-03
      12294   466_553145 1994 expShannon 1.569087e+00  7.141459e-02 3.461203e-04
      12295   466_553145 2001          S 9.000000e+00  2.316637e-01 1.287827e-02
      12296   466_553145 2001          N 2.677000e+03 -1.650242e+02 2.075952e-01
      12297   466_553145 2001       maxN 2.143000e+03 -1.761091e+02 1.521750e-01
      12298   466_553145 2001    Shannon 7.851089e-01  3.506903e-02 8.100959e-04
      12299   466_553145 2001    Simpson 3.485235e-01  1.658846e-02 2.086586e-03
      12300   466_553145 2001 invSimpson 1.534975e+00  3.648174e-02 6.946606e-04
      12301   466_553145 2001        PIE 3.486537e-01  1.660717e-02 2.077571e-03
      12302   466_553145 2001      DomMc 8.644004e-01 -6.575809e-03 1.328130e-03
      12303   466_553145 2001 expShannon 2.192646e+00  7.141459e-02 3.461203e-04
      12304   466_553145 1986          S 5.000000e+00  2.316637e-01 1.287827e-02
      12305   466_553145 1986          N 1.026700e+04 -1.650242e+02 2.075952e-01
      12306   466_553145 1986       maxN 9.859000e+03 -1.761091e+02 1.521750e-01
      12307   466_553145 1986    Shannon 1.921590e-01  3.506903e-02 8.100959e-04
      12308   466_553145 1986    Simpson 7.680993e-02  1.658846e-02 2.086586e-03
      12309   466_553145 1986 invSimpson 1.083201e+00  3.648174e-02 6.946606e-04
      12310   466_553145 1986        PIE 7.681741e-02  1.660717e-02 2.077571e-03
      12311   466_553145 1986      DomMc 9.928898e-01 -6.575809e-03 1.328130e-03
      12312   466_553145 1986 expShannon 1.211863e+00  7.141459e-02 3.461203e-04
      12313   466_553145 1988          S 1.000000e+01  2.316637e-01 1.287827e-02
      12314   466_553145 1988          N 2.134000e+03 -1.650242e+02 2.075952e-01
      12315   466_553145 1988       maxN 1.748000e+03 -1.761091e+02 1.521750e-01
      12316   466_553145 1988    Shannon 6.850193e-01  3.506903e-02 8.100959e-04
      12317   466_553145 1988    Simpson 3.153513e-01  1.658846e-02 2.086586e-03
      12318   466_553145 1988 invSimpson 1.460603e+00  3.648174e-02 6.946606e-04
      12319   466_553145 1988        PIE 3.154992e-01  1.660717e-02 2.077571e-03
      12320   466_553145 1988      DomMc 9.245548e-01 -6.575809e-03 1.328130e-03
      12321   466_553145 1988 expShannon 1.983810e+00  7.141459e-02 3.461203e-04
      12322   466_553145 1989          S 1.200000e+01  2.316637e-01 1.287827e-02
      12323   466_553145 1989          N 2.160000e+03 -1.650242e+02 2.075952e-01
      12324   466_553145 1989       maxN 1.997000e+03 -1.761091e+02 1.521750e-01
      12325   466_553145 1989    Shannon 3.811616e-01  3.506903e-02 8.100959e-04
      12326   466_553145 1989    Simpson 1.434015e-01  1.658846e-02 2.086586e-03
      12327   466_553145 1989 invSimpson 1.167408e+00  3.648174e-02 6.946606e-04
      12328   466_553145 1989        PIE 1.434679e-01  1.660717e-02 2.077571e-03
      12329   466_553145 1989      DomMc 9.625000e-01 -6.575809e-03 1.328130e-03
      12330   466_553145 1989 expShannon 1.463984e+00  7.141459e-02 3.461203e-04
      12331   466_553145 1990          S 9.000000e+00  2.316637e-01 1.287827e-02
      12332   466_553145 1990          N 2.105000e+03 -1.650242e+02 2.075952e-01
      12333   466_553145 1990       maxN 1.956000e+03 -1.761091e+02 1.521750e-01
      12334   466_553145 1990    Shannon 3.315614e-01  3.506903e-02 8.100959e-04
      12335   466_553145 1990    Simpson 1.340530e-01  1.658846e-02 2.086586e-03
      12336   466_553145 1990 invSimpson 1.154805e+00  3.648174e-02 6.946606e-04
      12337   466_553145 1990        PIE 1.341167e-01  1.660717e-02 2.077571e-03
      12338   466_553145 1990      DomMc 9.776722e-01 -6.575809e-03 1.328130e-03
      12339   466_553145 1990 expShannon 1.393142e+00  7.141459e-02 3.461203e-04
      12340   466_553145 1992          S 9.000000e+00  2.316637e-01 1.287827e-02
      12341   466_553145 1992          N 7.982000e+03 -1.650242e+02 2.075952