

#' Durées de travail en Europe
#' 
#' This dataset provide mean weekly cumulated work durations for several
#' European countries.
#' 
#' The duration is given in hours
#' 
#' @name Europe
#' @docType data
#' @format A data frame with 25 observations on the following 2 variables.
#' \describe{ \item{Pays}{a factor with the some of the European
#' countries as levels} \item{Duree}{weekly cumulative work duration} }
#' @references F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec
#' R, Dunod, 3ème edition, 2018.
#' @keywords datasets
#' @examples
#' 
#' data(Europe)
#' 
NULL





#' Mesures de fruits d'arbustes
#' 
#' This dataset measurements of several features of the fruits of small trees
#' such as their mass (in g) or their length (in cm).
#' 
#' This dataset was made during the summer 2009 in the south of France. It
#' provides measurements of several features of the fruits of small trees such
#' as their mass or their length.
#' 
#' @name Extrait_Taille
#' @docType data
#' @format A data frame with 252 observations on the following 5 variables.
#' \describe{ \item{masse}{a numeric vector} \item{taille}{a
#' numeric vector} \item{espece}{a factor with levels \code{bignone},
#' \code{glycine blanche}, \code{glycine violette} and \code{lauriers roses}} }
#' @references F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec
#' R, Dunod, 3ème edition, 2018.
#' @keywords datasets
#' @examples
#' 
#' data(Extrait_Taille)
#' 
NULL





#' Mesures de fruits d'arbustes
#' 
#' This dataset measurements of several features of the fruits of small trees
#' such as their mass or their length.
#' 
#' This dataset was made during the summer 2009 in the south of France. It
#' provides measurements of several features of the fruits of small trees such
#' as their mass or their length.
#' 
#' @name Mesures
#' @docType data
#' @format A data frame with 252 observations on the following 3 variables.
#' \describe{ \item{masse}{a numeric vector} \item{taille}{a
#' numeric vector} \item{espece}{a factor with levels \code{bignone},
#' \code{glycine blanche}, \code{glycine violette} and \code{lauriers roses}} }
#' @references F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec
#' R, Dunod, 3ème edition, 2018.
#' @keywords datasets
#' @examples
#' 
#' data(Mesures)
#' 
NULL





#' Mesures de fruits d'arbustes
#' 
#' This dataset measurements of several features of the fruits of small trees
#' such as their mass or their length.
#' 
#' This dataset was made during the summer 2009 in the south of France. It
#' provides measurements of several features of the fruits of small trees such
#' as their mass or their length.
#' 
#' @name Mesures5
#' @docType data
#' @format A data frame with 252 observations on the following 5 variables.
#' \describe{ \item{masse}{a numeric vector} \item{taille}{a
#' numeric vector} \item{graines}{a numeric vector}
#' \item{masse_sec}{a numeric vector} \item{espece}{a factor
#' with levels \code{bignone}, \code{glycine blanche}, \code{glycine violette}
#' and \code{lauriers roses}} }
#' @references F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec
#' R, Dunod, 3ème edition, 2018.
#' @keywords datasets
#' @examples
#' 
#' data(Mesures5)
#' 
NULL







#' Indices de Quetelet
#' 
#' Ce jeu de données contient des mesures de masse et de taille pour permettre
#' le calcul de l'indice de masse corporelle (aussi dit de Quetelet).
#' 
#' Le poids est exprimée en kg et la hauteur en cm
#' 
#' @name Quetelet
#' @docType data
#' @format Un data frame avec 66 observations de 3 variables.  \describe{
#' \item{sexe}{un facteur donnant le sexe de l'individu}
#' \item{poids}{le poids de l'individu} \item{taille}{la
#' hauteur de l'individu} }
#' @references F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec
#' R, Dunod, 3ème edition, 2018.
#' @keywords datasets
#' @examples
#' 
#' data(Quetelet)
#' 
NULL



