#' Toolkit for Compound-Protein Interaction in Drug Discovery
#' 
#' The BioMedR package offers an R/Bioconductor package emphasizing 
#' the comprehensive integration of bioinformatics and chemoinformatics 
#' into a molecular informatics platform for drug discovery.
#' 
#' The comprehensive user guide could be opened with \code{vignette('BioMedR')},
#' which explains the functionalities included in this package in detail.
#' The BioMedR package is developed by Computational Biology and 
#' Drug Design (CBDD) Group, Central South University 
#' (\url{http://www.scbdd.com/}).
#' 
#' \tabular{ll}{ Package: \tab BioMedR\cr Type: \tab Package\cr
#' Version: \tab Release 3\cr License: \tab Artistic-2.0\cr }
#' 
#' @name BioMedR-package
#' @aliases BioMedR
#' @docType package
#' @author Minfeng Zhu <\email{wind2zhu@@163.com.com}>
#'         Dongsheng Cao <\email{oriental-cds@@163.com}>
#'         
#' 
#' @note
#' Bug reports and feature requests should be sent to
#' \url{https://github.com/wind22zhu/BioMedR/issues}.
#' 
#' @keywords BioMedR
#' 
#' @import foreach doParallel Biostrings GOSemSim ChemmineR fmcsR
#' 
#' @example inst/examples/BioMedR-package-ex.R
NULL
